##!/bin/csh -fx

# Loading the data shapefile first and then reproject to the output modeling domain
# Loading once for processing multiple modeling domains

# 1. Load the original data shapefile (shp) with its projection (prj)

setenv shp_tbl `echo $shapefile | tr "[:upper:]" "[:lower:]"`
echo $dbname 
echo $user 
echo $server
echo $shapefile
  $GDALBIN/ogr2ogr -f "PostgreSQL" "PG:dbname=$dbname user=$user host=$server" $indir/$shapefile.shp -lco PRECISION=NO -nlt PROMOTE_TO_MULTI -nln $schema.$table -overwrite

# 2. Tranform to a new projection (from original 900922 to new 900921) and create gist index on it
$PGBIN/psql -h $server -U $user -q $dbname << END1
ALTER TABLE $schema.$table ADD COLUMN $newfield geometry($geomtype, $srid);
-- CREATE INDEX ON $schema.$table USING GIST ($newfield);
UPDATE $schema.$table SET $newfield = ST_Transform($org_geom_field, $srid);
drop index if exists $schema.${table}_${org_geom_field}_geom_idx;
create index on $schema.${table} using GIST(geom_900921);
END1



# polygons, oil gas
echo $attr   $geomtype
#if ( $attr != "" && $geomtype == "MultiPolygon" ) then
if ( $flag == oilgas ) then
psql -h $server -U $user -q $dbname << END1
  ALTER TABLE ${schema}.${table}
        add column ${attr}_dens double precision,
        add column area_900921 double precision;
  update ${schema}.$table
        set area_900921=ST_Area(geom_900921);
  update ${schema}.$table set
        ${attr}_dens=${attr}/area_900921;
END1
endif


# 3. Check whether the shapefile data are imported correclty or not.
$PGBIN/psql -h $server -U $user -q $dbname << END1
update ${schema}.${table}
        SET ${newfield} = ST_MakeValid(${newfield})
       WHERE NOT ST_IsValid(${newfield});
END1

