      subroutine lsrate5(neq,t,y,rate,nr,r)
      implicit none
c
c----CAMx v7Beta6 190902
c
c     LSRATE5 computes double precision species rates
c
c     Copyright 1996 - 2018
c     Ramboll
c     Created by the CMC version 5.2.6
c
c     Routines Called:
c        LSRXN5
c
c     Called by:
c        LSODE
c
      include "camx.prm"
      include "chmdat.inc"
      include "lsbox.inc"
      include "ddmchm.inc"
c
      integer neq, nr, l
      double precision t
      double precision y(*)
      double precision rate(neq)
      double precision r(MXREACT)
      double precision loss(MXSPEC+1)
      double precision gain(MXSPEC+1)
c
c --- Entry point
c
c --- Get reaction rates, r
c
      call lsrxn5(dH2O,dM,dO2,dCH4,dH2,y,dbrk,r)
c
      do l = 1,neq
        Loss(l) = 0.0d0
        Gain(l) = 0.0d0
      enddo
c
c --- Calculate the species rates
c
c
c   NO2    NO   O3P    O3   NO3  N2O5  HNO3   O1D    OH  HONO
c   HO2    CO   PNA  H2O2   SO2  SULF  MEO2  HCHO  COOH  MEOH
c  RO2C  RO2X    XN  MCO3   PAN  CO3H  AACD  RCO3  PAN2  XHO2
c  YRPX  XCCH  RO3H  PACD  BZC3  PBZN   BZO  MAC3  MPAN  TBUO
c  RNO3  ACET  NPHE  CRES   XOH  XNO2  XMEO  XMC3  XRC3  XMA3
c  XTBU   XCO  CCHO  RCHO  XHCH   MEK  ZRN3  XRCH  FACD  XMGL
c  XBAC  ROOH  XPD2  R6PX  PRD2  Y6PX  RAPX  MGLY  IPRD  XGLY
c  XMEK  XAF1  XAF2   GLY  AFG1  AFG2  BACL  BALD  AFG3  XIPR
c  MACR   MVK  XGLD  XRN3  GLYD  XACE  ACRO  XBAL  XAF3  XMAC
c  XMVK  YAPX  XACR  ETHE  PRPE  BD13  ISOP  APIN  ACYE  BENZ
c  TOLU  MXYL  OXYL  PXYL  B124  ETOH  ALK1  ALK2  ALK3  ALK4
c  ALK5  OLE1  OLE2  ARO1  ARO2  TERP  SESQ
c
        Loss(lNO2  )= +         r(  1)+         r(  5)+         r(  6)
     &                +         r(  8)+         r( 11)+         r( 15)
     &                +         r( 25)+         r( 32)+         r( 63)
     &                +         r( 73)+         r( 84)+         r( 96)
     &                +         r(109)+         r(111)
c
        Gain(lNO2  )= +         r(  4)+         r(  7)+( 2.000)*r(  9)
     &                +( 2.000)*r( 10)+         r( 12)+         r( 15)
     &                +         r( 17)+         r( 24)+         r( 26)
     &                +         r( 28)+         r( 31)+         r( 33)
     &                +( 0.610)*r( 34)+         r( 35)+( 0.800)*r( 39)
     &                +( 2.000)*r( 40)+         r( 46)+         r( 49)
     &                +         r( 52)+         r( 54)+         r( 59)
     &                +         r( 64)+( 0.600)*r( 65)+         r( 66)
     &                +         r( 68)+         r( 74)+( 0.600)*r( 75)
        Gain(lNO2  ) = Gain(lNO2  )
     &                +         r( 76)+         r( 78)+         r( 85)
     &                +( 0.600)*r( 86)+         r( 87)+         r( 89)
     &                +         r( 97)+( 0.600)*r( 98)+         r( 99)
     &                +         r(101)+         r(134)+         r(136)
     &                +( 0.500)*r(137)+( 0.500)*r(138)+( 0.500)*r(139)
     &                +         r(140)+         r(141)+         r(142)
     &                +         r(143)+( 0.019)*r(269)+         r(270)
c
        Loss(lNO   )= +         r(  4)+         r(  7)+         r(  9)
     &                +( 2.000)*r( 10)+         r( 22)+         r( 31)
     &                +         r( 46)+         r( 52)+         r( 57)
     &                +         r( 66)+         r( 76)+         r( 87)
     &                +         r( 99)+         r(114)+         r(124)
     &                +         r(134)+         r(144)+         r(154)
     &                +         r(164)+         r(174)+         r(184)
     &                +         r(194)+         r(283)+         r(293)
     &                +         r(303)+         r(313)+         r(323)
        Loss(lNO   ) = Loss(lNO   )
     &                +         r(333)+         r(343)+         r(353)
     &                +         r(363)+         r(373)+         r(383)
     &                +         r(393)+         r(403)+         r(413)
     &                +         r(423)+         r(433)+         r(443)
     &                +         r(453)+         r(463)+         r(473)
     &                +         r(483)+         r(493)+         r(503)
c
        Gain(lNO   )= +         r(  1)+         r(  5)+         r( 15)
     &                +         r( 16)+         r( 23)+         r(114)
     &                +         r(124)+         r(134)+         r(144)
     &                +         r(154)+         r(164)+         r(174)
     &                +         r(184)+         r(194)+         r(283)
     &                +         r(293)+         r(303)+         r(313)
     &                +         r(323)+         r(333)+         r(343)
     &                +         r(353)+         r(363)+         r(373)
     &                +         r(383)+         r(393)+         r(403)
        Gain(lNO   ) = Gain(lNO   )
     &                +         r(413)+         r(423)+         r(433)
     &                +         r(443)+         r(453)+         r(463)
     &                +         r(473)+         r(483)+         r(493)
     &                +         r(503)
c
        Loss(lO3P  )= +         r(  2)+         r(  3)+         r(  4)
     &                +         r(  5)+         r(  6)+         r(257)
     &                +         r(261)+         r(277)+         r(517)
     &                +         r(521)+         r(525)+         r(529)
     &                +         r(533)+         r(551)+         r(555)
     &                +         r(561)+         r(565)
c
        Gain(lO3P  )= +         r(  1)+         r( 17)+         r( 19)
     &                +         r( 21)
c
        Loss(lO3   )= +         r(  3)+         r(  7)+         r(  8)
     &                +         r( 18)+         r( 19)+         r( 30)
     &                +         r( 36)+         r(247)+         r(250)
     &                +         r(253)+         r(255)+         r(260)
     &                +         r(264)+         r(275)+         r(515)
     &                +         r(519)+         r(523)+         r(527)
     &                +         r(531)+         r(535)+         r(549)
     &                +         r(553)+         r(559)+         r(563)
c
        Gain(lO3   )= +         r(  2)+( 0.300)*r( 67)+( 0.250)*r( 77)
     &                +( 0.250)*r( 88)+( 0.250)*r(100)
c
        Loss(lNO3  )= +         r(  9)+         r( 11)+         r( 15)
     &                +         r( 16)+         r( 17)+         r( 26)
     &                +         r( 39)+( 2.000)*r( 40)+         r( 49)
     &                +         r( 54)+         r( 59)+         r( 68)
     &                +         r( 78)+         r( 89)+         r(101)
     &                +         r(116)+         r(126)+         r(136)
     &                +         r(146)+         r(156)+         r(166)
     &                +         r(176)+         r(186)+         r(196)
     &                +         r(207)+         r(210)+         r(213)
        Loss(lNO3  ) = Loss(lNO3  )
     &                +         r(233)+         r(236)+         r(239)
     &                +         r(245)+         r(256)+         r(265)
     &                +         r(273)+         r(276)+         r(285)
     &                +         r(295)+         r(305)+         r(315)
     &                +         r(325)+         r(335)+         r(345)
     &                +         r(355)+         r(365)+         r(375)
     &                +         r(385)+         r(395)+         r(405)
     &                +         r(415)+         r(425)+         r(435)
        Loss(lNO3  ) = Loss(lNO3  )
     &                +         r(445)+         r(455)+         r(465)
     &                +         r(475)+         r(485)+         r(495)
     &                +         r(505)+         r(516)+         r(520)
     &                +         r(524)+         r(528)+         r(532)
     &                +         r(550)+         r(554)+         r(560)
     &                +         r(564)
c
        Gain(lNO3  )= +         r(  6)+         r(  8)+         r( 12)
     &                +         r( 27)+( 0.390)*r( 34)+( 0.400)*r( 65)
     &                +( 0.400)*r( 75)+( 0.400)*r( 86)+( 0.400)*r( 98)
     &                +         r(116)+         r(126)+         r(136)
     &                +         r(146)+         r(156)+         r(166)
     &                +         r(176)+         r(186)+         r(196)
     &                +         r(285)+         r(295)+         r(305)
     &                +         r(315)+         r(325)+         r(335)
     &                +         r(345)+         r(355)+         r(365)
        Gain(lNO3  ) = Gain(lNO3  )
     &                +         r(375)+         r(385)+         r(395)
     &                +         r(405)+         r(415)+         r(425)
     &                +         r(435)+         r(445)+         r(455)
     &                +         r(465)+         r(475)+         r(485)
     &                +         r(495)+         r(505)
c
        Loss(lN2O5 )= +         r( 12)+         r( 13)+         r( 14)
c
        Gain(lN2O5 )= +         r( 11)
c
        Loss(lHNO3 )= +         r( 27)+         r( 28)
c
        Gain(lHNO3 )= +( 2.000)*r( 13)+( 2.000)*r( 14)+         r( 25)
     &                +( 0.200)*r( 39)+         r(207)+         r(210)
     &                +         r(213)+         r(233)+         r(236)
     &                +         r(239)+         r(245)+( 0.500)*r(256)
     &                +( 0.150)*r(265)+         r(273)+( 0.967)*r(276)
c
        Loss(lO1D  )= +         r( 20)+         r( 21)
c
        Gain(lO1D  )= +         r( 18)
c
        Loss(lOH   )= +         r( 22)+         r( 24)+         r( 25)
     &                +         r( 26)+         r( 27)+         r( 29)
     &                +         r( 30)+         r( 35)+         r( 42)
     &                +         r( 43)+         r( 44)+         r( 45)
     &                +         r(206)+         r(208)+         r(211)
     &                +         r(214)+         r(216)+         r(218)
     &                +         r(219)+         r(220)+         r(221)
     &                +         r(222)+         r(224)+         r(226)
     &                +         r(228)+         r(232)+         r(235)
        Loss(lOH   ) = Loss(lOH   )
     &                +         r(238)+         r(240)+         r(243)
     &                +         r(246)+         r(249)+         r(252)
     &                +         r(254)+         r(259)+         r(263)
     &                +         r(267)+         r(269)+         r(271)
     &                +         r(274)+         r(279)+         r(281)
     &                +         r(513)+         r(514)+         r(518)
     &                +         r(522)+         r(526)+         r(530)
     &                +         r(534)+         r(536)+         r(537)
        Loss(lOH   ) = Loss(lOH   )
     &                +         r(538)+         r(539)+         r(540)
     &                +         r(541)+         r(542)+         r(543)
     &                +         r(544)+         r(545)+         r(546)
     &                +         r(547)+         r(548)+         r(552)
     &                +         r(556)+         r(557)+         r(558)
     &                +         r(562)
c
        Gain(lOH   )= +( 2.000)*r( 20)+         r( 23)+         r( 28)
     &                +         r( 31)+( 0.390)*r( 34)+         r( 36)
     &                +( 0.800)*r( 39)+( 2.000)*r( 41)+         r(124)
     &                +         r(126)+( 0.500)*r(127)+( 0.500)*r(128)
     &                +( 0.500)*r(129)+         r(130)+         r(131)
     &                +         r(132)+         r(133)+( 0.300)*r(222)
     &                +         r(223)+( 0.744)*r(224)+         r(225)
     &                +( 0.840)*r(226)+         r(227)+( 0.139)*r(228)
     &                +         r(229)+( 0.826)*r(247)+( 0.826)*r(250)
        Gain(lOH   ) = Gain(lOH   )
     &                +( 0.471)*r(253)+( 0.208)*r(255)+( 0.330)*r(258)
     &                +( 0.164)*r(260)+( 0.285)*r(264)+( 0.330)*r(275)
     &                +( 0.178)*r(278)+         r(280)+         r(282)
     &                +( 0.160)*r(515)+( 0.350)*r(519)+( 0.080)*r(523)
     &                +( 0.266)*r(527)+( 0.728)*r(531)+( 0.700)*r(534)
     &                +( 0.500)*r(535)+( 0.116)*r(536)+( 0.312)*r(537)
     &                +( 0.239)*r(538)+( 0.198)*r(539)+( 0.278)*r(540)
     &                +( 0.230)*r(541)+( 0.128)*r(549)+( 0.443)*r(553)
        Gain(lOH   ) = Gain(lOH   )
     &                +( 0.202)*r(556)+( 0.178)*r(557)+( 0.499)*r(559)
     &                +( 0.499)*r(563)
c
        Loss(lHONO )= +         r( 23)+         r( 24)
c
        Gain(lHONO )= +         r( 22)+         r(241)
c
        Loss(lHO2  )= +         r( 31)+         r( 32)+         r( 36)
     &                +( 2.000)*r( 37)+( 2.000)*r( 38)+         r( 39)
     &                +         r( 43)+         r( 47)+         r( 48)
     &                +         r( 53)+         r( 58)+         r( 67)
     &                +         r( 77)+         r( 88)+         r(100)
     &                +         r(112)+         r(115)+         r(125)
     &                +         r(135)+         r(145)+         r(155)
     &                +         r(165)+         r(175)+         r(185)
     &                +         r(195)+         r(284)+         r(294)
        Loss(lHO2  ) = Loss(lHO2  )
     &                +         r(304)+         r(314)+         r(324)
     &                +         r(334)+         r(344)+         r(354)
     &                +         r(364)+         r(374)+         r(384)
     &                +         r(394)+         r(404)+         r(414)
     &                +         r(424)+         r(434)+         r(444)
     &                +         r(454)+         r(464)+         r(474)
     &                +         r(484)+         r(494)+         r(504)
c
        Gain(lHO2  )= +         r( 26)+         r( 29)+         r( 30)
     &                +         r( 33)+( 0.610)*r( 34)+         r( 42)
     &                +         r( 44)+         r( 45)+         r( 46)
     &                +         r( 49)+( 2.000)*r( 51)+( 0.500)*r( 55)
     &                +( 0.500)*r( 60)+( 0.900)*r( 69)+         r( 79)
     &                +         r( 90)+         r(102)+         r(114)
     &                +         r(115)+         r(116)+( 0.500)*r(117)
     &                +( 0.500)*r(118)+( 0.500)*r(119)+         r(120)
     &                +         r(121)+         r(122)+         r(123)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +         r(125)+         r(135)+         r(145)
     &                +         r(155)+         r(165)+         r(175)
     &                +         r(185)+         r(195)+( 2.000)*r(204)
     &                +         r(206)+         r(207)+         r(209)
     &                +         r(212)+         r(218)+         r(219)
     &                +         r(223)+         r(225)+( 0.142)*r(227)
     &                +( 0.148)*r(228)+         r(229)+( 2.000)*r(230)
     &                +( 0.630)*r(232)+( 0.630)*r(233)+         r(234)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 0.522)*r(247)+( 1.023)*r(248)+( 0.522)*r(250)
     &                +( 0.554)*r(253)+( 0.108)*r(255)+( 0.670)*r(258)
     &                +( 0.064)*r(260)+( 0.400)*r(264)+( 1.233)*r(266)
     &                +( 0.472)*r(267)+( 0.189)*r(269)+( 0.344)*r(270)
     &                +( 2.000)*r(272)+( 0.830)*r(275)+( 1.066)*r(278)
     &                +         r(284)+         r(294)+         r(304)
     &                +         r(314)+         r(324)+         r(334)
     &                +         r(344)+         r(354)+         r(364)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +         r(374)+         r(384)+         r(394)
     &                +         r(404)+         r(414)+         r(424)
     &                +         r(434)+         r(444)+         r(454)
     &                +         r(464)+         r(474)+         r(484)
     &                +         r(485)+( 0.500)*r(486)+( 0.500)*r(487)
     &                +( 0.500)*r(488)+         r(489)+         r(490)
     &                +         r(491)+         r(492)+         r(494)
     &                +         r(504)+( 0.160)*r(515)+( 0.800)*r(517)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 0.165)*r(519)+( 0.080)*r(523)+( 0.250)*r(525)
     &                +( 0.066)*r(527)+( 0.009)*r(531)+( 0.300)*r(534)
     &                +( 1.500)*r(535)+( 0.570)*r(536)+( 0.181)*r(537)
     &                +( 0.159)*r(538)+( 0.161)*r(539)+( 0.159)*r(540)
     &                +( 0.022)*r(541)+( 0.950)*r(542)+( 0.095)*r(549)
     &                +( 0.094)*r(553)+( 0.123)*r(556)+( 0.077)*r(557)
     &                +( 0.078)*r(559)+( 0.078)*r(563)
c
        Loss(lCO   )= +         r( 29)
c
        Gain(lCO   )= +         r(194)+         r(196)+( 0.500)*r(197)
     &                +( 0.500)*r(198)+( 0.500)*r(199)+         r(200)
     &                +         r(201)+         r(202)+         r(203)
     &                +         r(204)+         r(205)+         r(206)
     &                +         r(207)+         r(209)+         r(212)
     &                +( 0.380)*r(215)+( 2.000)*r(230)+         r(231)
     &                +( 1.260)*r(232)+( 1.260)*r(233)+         r(234)
     &                +         r(235)+         r(236)+( 0.522)*r(247)
     &                +( 0.695)*r(248)+( 0.522)*r(250)+( 0.580)*r(253)
        Gain(lCO   ) = Gain(lCO   )
     &                +( 0.450)*r(255)+( 0.670)*r(258)+( 0.475)*r(260)
     &                +( 0.600)*r(262)+( 0.498)*r(264)+( 1.233)*r(266)
     &                +         r(272)+( 1.005)*r(275)+( 1.188)*r(278)
     &                +( 0.510)*r(515)+( 0.510)*r(517)+( 0.525)*r(519)
     &                +( 0.255)*r(523)+( 0.275)*r(527)+( 0.029)*r(531)
     &                +( 0.300)*r(534)+( 1.500)*r(535)+( 0.303)*r(549)
     &                +( 0.299)*r(553)+( 0.249)*r(559)+( 0.249)*r(563)
c
        Loss(lPNA  )= +         r( 33)+         r( 34)+         r( 35)
c
        Gain(lPNA  )= +         r( 32)
c
        Loss(lH2O2 )= +         r( 41)+         r( 42)
c
        Gain(lH2O2 )= +         r( 37)+         r( 38)
c
        Loss(lSO2  )= +         r( 44)
c
        Gain(lSO2  )= 0.0
c
        Loss(lSULF )= 0.0
c
        Gain(lSULF )= +         r( 44)
c
        Loss(lMEO2 )= +         r( 46)+         r( 47)+         r( 48)
     &                +         r( 49)+( 2.000)*r( 50)+( 2.000)*r( 51)
     &                +         r( 55)+         r( 60)+         r( 69)
     &                +         r( 79)+         r( 90)+         r(102)
     &                +         r(117)+         r(127)+         r(137)
     &                +         r(147)+         r(157)+         r(167)
     &                +         r(177)+         r(187)+         r(197)
     &                +         r(286)+         r(296)+         r(306)
     &                +         r(316)+         r(326)+         r(336)
        Loss(lMEO2 ) = Loss(lMEO2 )
     &                +         r(346)+         r(356)+         r(366)
     &                +         r(376)+         r(386)+         r(396)
     &                +         r(406)+         r(416)+         r(426)
     &                +         r(436)+         r(446)+         r(456)
     &                +         r(466)+         r(476)+         r(486)
     &                +         r(496)+         r(506)
c
        Gain(lMEO2 )= +( 0.400)*r( 65)+         r( 66)+         r( 68)
     &                +( 0.900)*r( 69)+         r( 70)+         r( 71)
     &                +( 2.000)*r( 72)+         r( 82)+         r( 93)
     &                +         r(105)+         r(110)+         r(117)
     &                +         r(127)+         r(137)+         r(144)
     &                +         r(146)+( 1.500)*r(147)+( 0.500)*r(148)
     &                +( 0.500)*r(149)+         r(150)+         r(151)
     &                +         r(152)+         r(153)+         r(157)
     &                +         r(167)+         r(177)+         r(187)
        Gain(lMEO2 ) = Gain(lMEO2 )
     &                +         r(197)+         r(209)+( 1.380)*r(215)
     &                +( 0.509)*r(220)+( 0.700)*r(222)+( 0.173)*r(248)
     &                +( 0.400)*r(262)+( 0.234)*r(278)+         r(280)
     &                +         r(286)+         r(296)+         r(306)
     &                +         r(316)+         r(326)+         r(336)
     &                +         r(346)+         r(356)+         r(366)
     &                +         r(376)+         r(386)+         r(396)
     &                +         r(406)+         r(416)+         r(426)
        Gain(lMEO2 ) = Gain(lMEO2 )
     &                +         r(436)+         r(446)+         r(456)
     &                +         r(466)+         r(476)+         r(486)
     &                +         r(496)+         r(506)+         r(513)
     &                +( 0.510)*r(517)+( 0.355)*r(519)+( 0.250)*r(529)
     &                +( 0.307)*r(553)
c
        Loss(lHCHO )= +         r(204)+         r(205)+         r(206)
     &                +         r(207)
c
        Gain(lHCHO )= +         r( 46)+         r( 48)+         r( 49)
     &                +         r( 50)+( 2.000)*r( 51)+( 0.750)*r( 55)
     &                +( 0.750)*r( 60)+         r( 69)+         r( 79)
     &                +         r( 90)+( 0.400)*r( 98)+         r( 99)
     &                +         r(101)+( 2.000)*r(102)+         r(103)
     &                +         r(104)+         r(105)+         r(106)
     &                +         r(107)+( 2.000)*r(108)+         r(218)
     &                +( 0.300)*r(222)+         r(223)+         r(231)
     &                +( 0.100)*r(255)+( 0.340)*r(258)+( 0.050)*r(260)
        Gain(lHCHO ) = Gain(lHCHO )
     &                +( 0.124)*r(264)+( 0.300)*r(266)+( 0.002)*r(267)
     &                +( 0.074)*r(270)+         r(272)+( 0.500)*r(275)
     &                +( 0.340)*r(278)+         r(283)+         r(285)
     &                +( 0.500)*r(286)+( 0.500)*r(287)+( 0.500)*r(288)
     &                +         r(289)+         r(290)+         r(291)
     &                +         r(292)+         r(515)+( 0.500)*r(519)
     &                +( 0.500)*r(523)+( 0.400)*r(527)+( 0.500)*r(549)
     &                +( 0.131)*r(553)+( 0.127)*r(559)+( 0.127)*r(563)
c
        Loss(lCOOH )= +         r(222)+         r(223)
c
        Gain(lCOOH )= +         r( 47)
c
        Loss(lMEOH )= +         r(218)
c
        Gain(lMEOH )= +         r( 50)+( 0.250)*r( 55)+( 0.250)*r( 60)
c
        Loss(lRO2C )= +         r( 52)+         r( 53)+         r( 54)
     &                +         r( 55)+( 2.000)*r( 56)+         r( 61)
     &                +         r( 70)+         r( 80)+         r( 91)
     &                +         r(103)+         r(118)+         r(128)
     &                +         r(138)+         r(148)+         r(158)
     &                +         r(168)+         r(178)+         r(188)
     &                +         r(198)+         r(287)+         r(297)
     &                +         r(307)+         r(317)+         r(327)
     &                +         r(337)+         r(347)+         r(357)
        Loss(lRO2C ) = Loss(lRO2C )
     &                +         r(367)+         r(377)+         r(387)
     &                +         r(397)+         r(407)+         r(417)
     &                +         r(427)+         r(437)+         r(447)
     &                +         r(457)+         r(467)+         r(477)
     &                +         r(487)+         r(497)+         r(507)
c
        Gain(lRO2C )= +( 0.400)*r( 75)+         r( 76)+         r( 78)
     &                +         r( 79)+         r( 80)+         r( 81)
     &                +         r( 82)+( 2.000)*r( 83)+( 0.400)*r( 86)
     &                +         r( 87)+         r( 89)+         r( 90)
     &                +         r( 91)+         r( 92)+         r( 93)
     &                +( 2.000)*r( 94)+( 2.000)*r( 95)+         r(106)
     &                +         r(107)+         r(113)+         r(118)
     &                +         r(128)+         r(138)+         r(148)
     &                +         r(158)+         r(168)+         r(178)
        Gain(lRO2C ) = Gain(lRO2C )
     &                +         r(188)+         r(198)+( 0.035)*r(211)
     &                +         r(212)+         r(214)+( 0.967)*r(216)
     &                +         r(217)+( 0.491)*r(220)+         r(221)
     &                +( 0.251)*r(224)+( 0.222)*r(226)+( 0.782)*r(227)
     &                +( 0.589)*r(228)+( 0.800)*r(238)+( 0.723)*r(246)
     &                +( 0.652)*r(247)+( 0.723)*r(249)+( 0.652)*r(250)
     &                +( 0.733)*r(252)+( 0.258)*r(253)+( 0.500)*r(254)
     &                +( 0.100)*r(255)+( 0.500)*r(256)+( 0.330)*r(258)
        Gain(lRO2C ) = Gain(lRO2C )
     &                +( 0.975)*r(259)+( 0.050)*r(260)+( 0.670)*r(263)
     &                +( 0.048)*r(264)+( 0.799)*r(265)+( 0.473)*r(267)
     &                +( 1.590)*r(268)+( 0.976)*r(269)+( 0.721)*r(270)
     &                +( 0.250)*r(274)+( 0.031)*r(276)+( 0.020)*r(279)
     &                +( 0.194)*r(281)+         r(287)+         r(297)
     &                +         r(307)+         r(317)+         r(327)
     &                +         r(337)+         r(347)+         r(357)
     &                +         r(367)+         r(377)+         r(387)
        Gain(lRO2C ) = Gain(lRO2C )
     &                +         r(397)+         r(407)+         r(417)
     &                +         r(427)+         r(437)+         r(447)
     &                +         r(457)+         r(467)+         r(477)
     &                +         r(487)+         r(497)+         r(507)
     &                +         r(514)+         r(516)+( 0.290)*r(517)
     &                +( 0.984)*r(518)+( 0.949)*r(520)+( 1.189)*r(522)
     &                +( 1.055)*r(524)+( 0.235)*r(525)+( 0.986)*r(526)
     &                +( 0.192)*r(527)+( 0.936)*r(528)+( 0.240)*r(529)
        Gain(lRO2C ) = Gain(lRO2C )
     &                +( 1.042)*r(530)+( 1.511)*r(531)+( 1.050)*r(532)
     &                +( 0.290)*r(536)+( 0.454)*r(537)+( 0.520)*r(538)
     &                +( 0.554)*r(539)+( 0.487)*r(540)+( 0.627)*r(541)
     &                +( 0.050)*r(542)+         r(543)+( 0.965)*r(544)
     &                +( 1.253)*r(545)+( 1.763)*r(546)+( 1.605)*r(547)
     &                +( 1.202)*r(548)+( 0.090)*r(549)+( 1.463)*r(550)
     &                +( 0.953)*r(552)+( 0.212)*r(553)+( 1.193)*r(554)
     &                +( 0.566)*r(556)+( 0.617)*r(557)+( 1.211)*r(558)
        Gain(lRO2C ) = Gain(lRO2C )
     &                +( 0.490)*r(559)+( 1.786)*r(560)+( 1.211)*r(562)
     &                +( 0.490)*r(563)+( 1.786)*r(564)
c
        Loss(lRO2X )= +         r( 57)+         r( 58)+         r( 59)
     &                +         r( 60)+         r( 61)+( 2.000)*r( 62)
     &                +         r( 71)+         r( 81)+         r( 92)
     &                +         r(104)+         r(119)+         r(129)
     &                +         r(139)+         r(149)+         r(159)
     &                +         r(169)+         r(179)+         r(189)
     &                +         r(199)+         r(288)+         r(298)
     &                +         r(308)+         r(318)+         r(328)
     &                +         r(338)+         r(348)+         r(358)
        Loss(lRO2X ) = Loss(lRO2X )
     &                +         r(368)+         r(378)+         r(388)
     &                +         r(398)+         r(408)+         r(418)
     &                +         r(428)+         r(438)+         r(448)
     &                +         r(458)+         r(468)+         r(478)
     &                +         r(488)+         r(498)+         r(508)
c
        Gain(lRO2X )= +         r(119)+         r(129)+         r(139)
     &                +         r(149)+         r(159)+         r(169)
     &                +         r(179)+         r(189)+         r(199)
     &                +( 0.039)*r(216)+( 0.004)*r(224)+( 0.029)*r(226)
     &                +( 0.077)*r(227)+( 0.124)*r(228)+( 0.060)*r(246)
     &                +( 0.060)*r(249)+( 0.117)*r(252)+( 0.007)*r(253)
     &                +( 0.025)*r(259)+( 0.041)*r(263)+( 0.051)*r(265)
     &                +( 0.071)*r(267)+( 0.087)*r(268)+( 0.175)*r(269)
     &                +( 0.102)*r(270)+( 0.002)*r(276)+         r(288)
        Gain(lRO2X ) = Gain(lRO2X )
     &                +         r(298)+         r(308)+         r(318)
     &                +         r(328)+         r(338)+         r(348)
     &                +         r(358)+         r(368)+         r(378)
     &                +         r(388)+         r(398)+         r(408)
     &                +         r(418)+         r(428)+         r(438)
     &                +         r(448)+         r(458)+         r(468)
     &                +         r(478)+         r(488)+         r(498)
     &                +         r(508)+( 0.016)*r(518)+( 0.051)*r(520)
        Gain(lRO2X ) = Gain(lRO2X )
     &                +( 0.049)*r(522)+( 0.065)*r(524)+( 0.015)*r(525)
     &                +( 0.093)*r(526)+( 0.008)*r(527)+( 0.064)*r(528)
     &                +( 0.010)*r(529)+( 0.197)*r(530)+( 0.337)*r(531)
     &                +( 0.293)*r(532)+( 0.024)*r(536)+( 0.054)*r(537)
     &                +( 0.082)*r(538)+( 0.087)*r(539)+( 0.076)*r(540)
     &                +( 0.121)*r(541)+( 0.035)*r(544)+( 0.070)*r(545)
     &                +( 0.149)*r(546)+( 0.353)*r(547)+( 0.128)*r(548)
     &                +( 0.005)*r(549)+( 0.228)*r(550)+( 0.088)*r(552)
        Gain(lRO2X ) = Gain(lRO2X )
     &                +( 0.003)*r(553)+( 0.140)*r(554)+( 0.110)*r(556)
     &                +( 0.128)*r(557)+( 0.201)*r(558)+( 0.121)*r(559)
     &                +( 0.460)*r(560)+( 0.201)*r(562)+( 0.121)*r(563)
     &                +( 0.460)*r(564)
c
        Loss(lXN   )= 0.0
c
        Gain(lXN   )= +         r( 57)+         r(135)+( 0.500)*r(137)
     &                +( 0.500)*r(138)+( 0.500)*r(139)+         r(240)
     &                +         r(242)+( 0.500)*r(256)+( 0.278)*r(265)
     &                +( 0.174)*r(269)+( 0.002)*r(276)+         r(444)
     &                +( 0.500)*r(446)+( 0.500)*r(447)+( 0.500)*r(448)
     &                +(-1.000)*r(483)+         r(516)+         r(520)
     &                +( 0.525)*r(524)+( 0.813)*r(528)+( 0.301)*r(532)
     &                +( 0.226)*r(550)+( 0.254)*r(554)+( 0.485)*r(560)
     &                +( 0.485)*r(564)
c
        Loss(lMCO3 )= +         r( 63)+         r( 66)+         r( 67)
     &                +         r( 68)+         r( 69)+         r( 70)
     &                +         r( 71)+( 2.000)*r( 72)+         r( 82)
     &                +         r( 93)+         r(105)+         r(120)
     &                +         r(130)+         r(140)+         r(150)
     &                +         r(160)+         r(170)+         r(180)
     &                +         r(190)+         r(200)+         r(289)
     &                +         r(299)+         r(309)+         r(319)
     &                +         r(329)+         r(339)+         r(349)
        Loss(lMCO3 ) = Loss(lMCO3 )
     &                +         r(359)+         r(369)+         r(379)
     &                +         r(389)+         r(399)+         r(409)
     &                +         r(419)+         r(429)+         r(439)
     &                +         r(449)+         r(459)+         r(469)
     &                +         r(479)+         r(489)+         r(499)
     &                +         r(509)
c
        Gain(lMCO3 )= +         r( 64)+( 0.600)*r( 65)+( 0.400)*r( 98)
     &                +         r( 99)+         r(101)+         r(102)
     &                +         r(103)+         r(104)+         r(105)
     &                +         r(106)+         r(107)+( 2.000)*r(108)
     &                +         r(120)+         r(130)+         r(140)
     &                +         r(150)+         r(154)+         r(156)
     &                +( 0.500)*r(157)+( 0.500)*r(158)+( 0.500)*r(159)
     &                +( 2.000)*r(160)+         r(161)+         r(162)
     &                +         r(163)+         r(170)+         r(180)
        Gain(lMCO3 ) = Gain(lMCO3 )
     &                +         r(190)+         r(200)+         r(208)
     &                +         r(210)+( 0.620)*r(215)+         r(217)
     &                +         r(234)+         r(235)+         r(236)
     &                +( 2.000)*r(237)+( 0.305)*r(248)+( 0.013)*r(253)
     &                +( 0.340)*r(258)+( 0.467)*r(266)+( 0.400)*r(268)
     &                +         r(271)+         r(273)+( 0.980)*r(279)
     &                +         r(289)+         r(299)+         r(309)
     &                +         r(319)+         r(329)+         r(339)
        Gain(lMCO3 ) = Gain(lMCO3 )
     &                +         r(349)+         r(359)+         r(369)
     &                +         r(379)+         r(389)+         r(399)
     &                +         r(409)+         r(419)+         r(429)
     &                +         r(439)+         r(449)+         r(459)
     &                +         r(469)+         r(479)+         r(489)
     &                +         r(499)+         r(509)
c
        Loss(lPAN  )= +         r( 64)+         r( 65)
c
        Gain(lPAN  )= +         r( 63)
c
        Loss(lCO3H )= +         r(279)+         r(280)
c
        Gain(lCO3H )= +( 0.700)*r( 67)
c
        Loss(lAACD )= +         r(220)
c
        Gain(lAACD )= +( 0.300)*r( 67)+( 0.100)*r( 69)+( 0.050)*r(278)
     &                +( 0.075)*r(519)+( 0.065)*r(553)
c
        Loss(lRCO3 )= +         r( 73)+         r( 76)+         r( 77)
     &                +         r( 78)+         r( 79)+         r( 80)
     &                +         r( 81)+         r( 82)+( 2.000)*r( 83)
     &                +         r( 94)+         r(106)+         r(121)
     &                +         r(131)+         r(141)+         r(151)
     &                +         r(161)+         r(171)+         r(181)
     &                +         r(191)+         r(201)+         r(290)
     &                +         r(300)+         r(310)+         r(320)
     &                +         r(330)+         r(340)+         r(350)
        Loss(lRCO3 ) = Loss(lRCO3 )
     &                +         r(360)+         r(370)+         r(380)
     &                +         r(390)+         r(400)+         r(410)
     &                +         r(420)+         r(430)+         r(440)
     &                +         r(450)+         r(460)+         r(470)
     &                +         r(480)+         r(490)+         r(500)
     &                +         r(510)
c
        Gain(lRCO3 )= +         r( 74)+( 0.600)*r( 75)+         r(121)
     &                +         r(131)+         r(141)+         r(151)
     &                +         r(161)+         r(164)+         r(166)
     &                +( 0.500)*r(167)+( 0.500)*r(168)+( 0.500)*r(169)
     &                +         r(170)+( 2.000)*r(171)+         r(172)
     &                +         r(173)+         r(181)+         r(191)
     &                +         r(201)+( 0.965)*r(211)+         r(213)
     &                +( 0.370)*r(232)+( 0.370)*r(233)+( 0.300)*r(266)
     &                +( 0.600)*r(268)+( 0.806)*r(281)+         r(290)
        Gain(lRCO3 ) = Gain(lRCO3 )
     &                +         r(300)+         r(310)+         r(320)
     &                +         r(330)+         r(340)+         r(350)
     &                +         r(360)+         r(370)+         r(380)
     &                +         r(390)+         r(400)+         r(410)
     &                +         r(420)+         r(430)+         r(440)
     &                +         r(450)+         r(460)+         r(470)
     &                +         r(480)+         r(490)+         r(500)
     &                +         r(510)
c
        Loss(lPAN2 )= +         r( 74)+         r( 75)
c
        Gain(lPAN2 )= +         r( 73)
c
        Loss(lXHO2 )= +         r(114)+         r(115)+         r(116)
     &                +         r(117)+         r(118)+         r(119)
     &                +         r(120)+         r(121)+         r(122)
     &                +         r(123)
c
        Gain(lXHO2 )= +( 0.400)*r( 75)+         r( 76)+         r( 78)
     &                +         r( 79)+         r( 80)+         r( 81)
     &                +         r( 82)+( 2.000)*r( 83)+         r( 94)
     &                +         r(106)+         r(113)+( 0.035)*r(211)
     &                +         r(212)+( 0.376)*r(216)+         r(217)
     &                +( 0.491)*r(220)+         r(221)+( 0.239)*r(224)
     &                +( 0.090)*r(226)+( 0.782)*r(227)+( 0.565)*r(228)
     &                +( 0.800)*r(238)+( 0.521)*r(246)+( 0.521)*r(249)
     &                +( 0.561)*r(252)+( 0.095)*r(253)+( 0.500)*r(254)
        Gain(lXHO2 ) = Gain(lXHO2 )
     &                +( 0.500)*r(256)+( 0.300)*r(259)+( 0.050)*r(260)
     &                +( 0.670)*r(263)+( 0.799)*r(265)+( 0.379)*r(267)
     &                +( 0.913)*r(268)+( 0.305)*r(269)+( 0.554)*r(270)
     &                +( 0.250)*r(274)+( 0.031)*r(276)+( 0.084)*r(281)
     &                +         r(282)+         r(514)+         r(516)
     &                +( 0.290)*r(517)+( 0.984)*r(518)+( 0.949)*r(520)
     &                +( 0.951)*r(522)+( 0.815)*r(524)+( 0.117)*r(525)
     &                +( 0.907)*r(526)+( 0.749)*r(528)+( 0.799)*r(530)
        Gain(lXHO2 ) = Gain(lXHO2 )
     &                +( 0.102)*r(531)+( 0.056)*r(532)+( 0.290)*r(536)
     &                +( 0.454)*r(537)+( 0.520)*r(538)+( 0.554)*r(539)
     &                +( 0.487)*r(540)+( 0.627)*r(541)+( 0.050)*r(542)
     &                +         r(543)+( 0.965)*r(544)+( 0.695)*r(545)
     &                +( 0.830)*r(546)+( 0.647)*r(547)+( 0.871)*r(548)
     &                +( 0.057)*r(549)+( 0.772)*r(550)+( 0.912)*r(552)
     &                +( 0.041)*r(553)+( 0.400)*r(554)+( 0.566)*r(556)
     &                +( 0.617)*r(557)+( 0.734)*r(558)+( 0.046)*r(559)
        Gain(lXHO2 ) = Gain(lXHO2 )
     &                +( 0.227)*r(560)+( 0.734)*r(562)+( 0.046)*r(563)
     &                +( 0.227)*r(564)
c
        Loss(lYRPX )= +         r(453)+         r(454)+         r(455)
     &                +         r(456)+         r(457)+         r(458)
     &                +         r(459)+         r(460)+         r(461)
     &                +         r(462)
c
        Gain(lYRPX )= +( 0.400)*r( 75)+         r( 76)+         r( 78)
     &                +         r( 79)+         r( 80)+         r( 81)
     &                +         r( 82)+( 2.000)*r( 83)+         r( 94)
     &                +         r(106)+( 0.035)*r(211)+         r(212)
     &                +         r(214)+         r(216)+         r(217)
     &                +( 0.491)*r(220)+         r(221)+( 0.256)*r(224)
     &                +( 0.160)*r(226)+( 0.500)*r(254)+( 0.100)*r(255)
     &                +( 0.500)*r(256)+( 0.330)*r(258)+         r(259)
     &                +( 0.050)*r(260)+( 0.157)*r(269)+( 0.066)*r(270)
        Gain(lYRPX ) = Gain(lYRPX )
     &                +( 0.250)*r(274)+( 0.033)*r(276)+( 0.020)*r(279)
     &                +( 0.194)*r(281)+         r(282)+         r(514)
     &                +         r(516)+( 0.290)*r(517)+         r(518)
     &                +         r(520)+         r(522)+         r(524)
     &                +( 0.250)*r(525)+( 0.050)*r(542)+         r(543)
     &                +         r(544)+( 0.983)*r(545)+( 0.169)*r(548)
     &                +( 0.011)*r(549)+( 0.169)*r(550)+( 0.319)*r(552)
     &                +( 0.073)*r(553)+( 0.319)*r(554)
c
        Loss(lXCCH )= +         r(293)+         r(294)+         r(295)
     &                +         r(296)+         r(297)+         r(298)
     &                +         r(299)+         r(300)+         r(301)
     &                +         r(302)
c
        Gain(lXCCH )= +( 0.400)*r( 75)+         r( 76)+         r( 78)
     &                +         r( 79)+         r( 80)+         r( 81)
     &                +         r( 82)+( 2.000)*r( 83)+         r( 94)
     &                +         r(106)+( 0.035)*r(211)+         r(212)
     &                +( 0.504)*r(216)+         r(217)+( 0.142)*r(221)
     &                +( 0.012)*r(224)+( 0.020)*r(226)+( 0.026)*r(227)
     &                +( 0.083)*r(267)+( 0.163)*r(268)+( 0.429)*r(269)
     &                +( 0.230)*r(270)+( 0.167)*r(274)+( 0.110)*r(281)
     &                +         r(282)+( 0.984)*r(518)+         r(543)
        Gain(lXCCH ) = Gain(lXCCH )
     &                +( 0.445)*r(545)+( 0.438)*r(546)+( 0.106)*r(547)
     &                +( 0.010)*r(548)+( 0.011)*r(549)+( 0.013)*r(550)
     &                +( 0.835)*r(552)+( 0.071)*r(553)+( 0.579)*r(554)
     &                +( 0.002)*r(564)
c
        Loss(lRO3H )= +         r(281)+         r(282)
c
        Gain(lRO3H )= +( 0.750)*r( 77)+( 0.750)*r( 88)+( 0.750)*r(100)
c
        Loss(lPACD )= +         r(221)
c
        Gain(lPACD )= +( 0.250)*r( 77)+( 0.250)*r( 88)+( 0.250)*r(100)
     &                +( 0.372)*r(264)+( 0.159)*r(549)+( 0.235)*r(553)
     &                +( 0.068)*r(559)+( 0.068)*r(563)
c
        Loss(lBZC3 )= +         r( 84)+         r( 87)+         r( 88)
     &                +         r( 89)+         r( 90)+         r( 91)
     &                +         r( 92)+         r( 93)+         r( 94)
     &                +( 2.000)*r( 95)+         r(107)+         r(122)
     &                +         r(132)+         r(142)+         r(152)
     &                +         r(162)+         r(172)+         r(182)
     &                +         r(192)+         r(202)+         r(291)
     &                +         r(301)+         r(311)+         r(321)
     &                +         r(331)+         r(341)+         r(351)
        Loss(lBZC3 ) = Loss(lBZC3 )
     &                +         r(361)+         r(371)+         r(381)
     &                +         r(391)+         r(401)+         r(411)
     &                +         r(421)+         r(431)+         r(441)
     &                +         r(451)+         r(461)+         r(471)
     &                +         r(481)+         r(491)+         r(501)
     &                +         r(511)
c
        Gain(lBZC3 )= +         r( 85)+( 0.600)*r( 86)+         r(122)
     &                +         r(132)+         r(142)+         r(152)
     &                +         r(162)+         r(172)+         r(182)
     &                +         r(192)+         r(202)+         r(243)
     &                +         r(245)+         r(291)+         r(301)
     &                +         r(311)+         r(321)+         r(331)
     &                +         r(341)+         r(351)+         r(361)
     &                +         r(371)+         r(381)+         r(391)
     &                +         r(401)+         r(411)+         r(421)
        Gain(lBZC3 ) = Gain(lBZC3 )
     &                +         r(431)+         r(441)+         r(451)
     &                +         r(461)+         r(471)+         r(481)
     &                +         r(491)+         r(501)+         r(511)
c
        Loss(lPBZN )= +         r( 85)+         r( 86)
c
        Gain(lPBZN )= +         r( 84)
c
        Loss(lBZO  )= +         r(111)+         r(112)+         r(113)
c
        Gain(lBZO  )= +( 0.400)*r( 86)+         r( 87)+         r( 89)
     &                +         r( 90)+         r( 91)+         r( 92)
     &                +         r( 93)+         r( 94)+( 2.000)*r( 95)
     &                +         r(107)+( 0.200)*r(238)+         r(239)
     &                +         r(240)
c
        Loss(lMAC3 )= +         r( 96)+         r( 99)+         r(100)
     &                +         r(101)+         r(102)+         r(103)
     &                +         r(104)+         r(105)+         r(106)
     &                +         r(107)+( 2.000)*r(108)+         r(123)
     &                +         r(133)+         r(143)+         r(153)
     &                +         r(163)+         r(173)+         r(183)
     &                +         r(193)+         r(203)+         r(292)
     &                +         r(302)+         r(312)+         r(322)
     &                +         r(332)+         r(342)+         r(352)
        Loss(lMAC3 ) = Loss(lMAC3 )
     &                +         r(362)+         r(372)+         r(382)
     &                +         r(392)+         r(402)+         r(412)
     &                +         r(422)+         r(432)+         r(442)
     &                +         r(452)+         r(462)+         r(472)
     &                +         r(482)+         r(492)+         r(502)
     &                +         r(512)
c
        Gain(lMAC3 )= +         r( 97)+( 0.600)*r( 98)+         r(123)
     &                +         r(133)+         r(143)+         r(153)
     &                +         r(163)+         r(173)+         r(174)
     &                +         r(176)+( 0.500)*r(177)+( 0.500)*r(178)
     &                +( 0.500)*r(179)+         r(180)+         r(181)
     &                +         r(182)+( 2.000)*r(183)+         r(193)
     &                +         r(203)+( 0.217)*r(246)+( 0.500)*r(248)
     &                +( 0.217)*r(249)+( 0.206)*r(252)+( 0.500)*r(254)
     &                +( 0.500)*r(256)+( 0.330)*r(258)+( 0.400)*r(262)
        Gain(lMAC3 ) = Gain(lMAC3 )
     &                +( 0.289)*r(263)+( 0.150)*r(265)+( 0.750)*r(274)
     &                +( 0.967)*r(276)+( 0.330)*r(278)+         r(292)
     &                +         r(302)+         r(312)+         r(322)
     &                +         r(332)+         r(342)+         r(352)
     &                +         r(362)+         r(372)+         r(382)
     &                +         r(392)+         r(402)+         r(412)
     &                +         r(422)+         r(432)+         r(442)
     &                +         r(452)+         r(462)+         r(472)
        Gain(lMAC3 ) = Gain(lMAC3 )
     &                +         r(482)+         r(492)+         r(502)
     &                +         r(512)
c
        Loss(lMPAN )= +         r( 97)+         r( 98)
c
        Gain(lMPAN )= +         r( 96)
c
        Loss(lTBUO )= +         r(109)+         r(110)
c
        Gain(lTBUO )= +         r(184)+         r(186)+( 0.500)*r(187)
     &                +( 0.500)*r(188)+( 0.500)*r(189)+         r(190)
     &                +         r(191)+         r(192)+         r(193)
c
        Loss(lRNO3 )= +         r(269)+         r(270)
c
        Gain(lRNO3 )= +         r(109)+( 0.189)*r(269)+         r(443)
     &                +         r(445)+( 0.500)*r(446)+( 0.500)*r(447)
     &                +( 0.500)*r(448)+         r(449)+         r(450)
     &                +         r(451)+         r(452)+         r(483)
c
        Loss(lACET )= +         r(214)+         r(215)
c
        Gain(lACET )= +         r(110)+         r(313)+         r(315)
     &                +( 0.500)*r(316)+( 0.500)*r(317)+( 0.500)*r(318)
     &                +         r(319)+         r(320)+         r(321)
     &                +         r(322)+( 0.051)*r(553)
c
        Loss(lNPHE )= +         r(240)+         r(241)+         r(242)
c
        Gain(lNPHE )= +         r(111)
c
        Loss(lCRES )= +         r(238)+         r(239)
c
        Gain(lCRES )= +         r(112)+         r(113)+( 0.570)*r(536)
     &                +( 0.181)*r(537)+( 0.159)*r(538)+( 0.161)*r(539)
     &                +( 0.159)*r(540)+( 0.022)*r(541)+( 0.123)*r(556)
     &                +( 0.077)*r(557)
c
        Loss(lXOH  )= +         r(124)+         r(125)+         r(126)
     &                +         r(127)+         r(128)+         r(129)
     &                +         r(130)+         r(131)+         r(132)
     &                +         r(133)
c
        Gain(lXOH  )= +( 0.012)*r(224)+( 0.041)*r(226)+( 0.024)*r(228)
     &                +( 0.020)*r(279)+( 0.110)*r(281)
c
        Loss(lXNO2 )= +         r(134)+         r(135)+         r(136)
     &                +         r(137)+         r(138)+         r(139)
     &                +         r(140)+         r(141)+         r(142)
     &                +         r(143)
c
        Gain(lXNO2 )= +( 0.313)*r(269)+( 0.120)*r(524)+( 0.187)*r(528)
     &                +( 0.643)*r(532)+( 0.426)*r(554)+( 0.287)*r(560)
     &                +( 0.287)*r(564)
c
        Loss(lXMEO )= +         r(144)+         r(145)+         r(146)
     &                +         r(147)+         r(148)+         r(149)
     &                +         r(150)+         r(151)+         r(152)
     &                +         r(153)
c
        Gain(lXMEO )= +( 0.010)*r(546)+( 0.001)*r(548)+( 0.035)*r(554)
c
        Loss(lXMC3 )= +         r(154)+         r(155)+         r(156)
     &                +         r(157)+         r(158)+         r(159)
     &                +         r(160)+         r(161)+         r(162)
     &                +         r(163)
c
        Gain(lXMC3 )= +         r(214)+( 0.510)*r(216)+( 0.201)*r(246)
     &                +( 0.201)*r(249)+( 0.117)*r(252)+( 0.330)*r(258)
     &                +( 0.675)*r(259)+( 0.029)*r(267)+( 0.001)*r(531)
     &                +( 0.011)*r(546)+( 0.156)*r(553)+( 0.202)*r(559)
     &                +( 0.202)*r(563)
c
        Loss(lXRC3 )= +         r(164)+         r(165)+         r(166)
     &                +         r(167)+         r(168)+         r(169)
     &                +         r(170)+         r(171)+         r(172)
     &                +         r(173)
c
        Gain(lXRC3 )= +( 0.074)*r(216)+( 0.652)*r(247)+( 0.652)*r(250)
     &                +( 0.163)*r(253)+( 0.100)*r(255)+( 0.050)*r(260)
     &                +( 0.048)*r(264)+( 0.049)*r(267)+( 0.004)*r(530)
     &                +( 0.297)*r(531)+( 0.007)*r(532)+( 0.008)*r(553)
     &                +( 0.064)*r(558)+( 0.059)*r(559)+( 0.026)*r(560)
     &                +( 0.064)*r(562)+( 0.059)*r(563)+( 0.026)*r(564)
c
        Loss(lXMA3 )= +         r(174)+         r(175)+         r(176)
     &                +         r(177)+         r(178)+         r(179)
     &                +         r(180)+         r(181)+         r(182)
     &                +         r(183)
c
        Gain(lXMA3 )= +( 0.118)*r(525)+( 0.192)*r(527)+( 0.240)*r(529)
c
        Loss(lXTBU )= +         r(184)+         r(185)+         r(186)
     &                +         r(187)+         r(188)+         r(189)
     &                +         r(190)+         r(191)+         r(192)
     &                +         r(193)
c
        Gain(lXTBU )= +( 0.236)*r(545)
c
        Loss(lXCO  )= +         r(194)+         r(195)+         r(196)
     &                +         r(197)+         r(198)+         r(199)
     &                +         r(200)+         r(201)+         r(202)
     &                +         r(203)
c
        Gain(lXCO  )= +( 0.035)*r(211)+( 0.334)*r(246)+( 0.334)*r(249)
     &                +( 0.114)*r(252)+( 0.416)*r(254)+( 0.500)*r(256)
     &                +( 0.336)*r(263)+( 0.572)*r(265)+( 0.167)*r(274)
     &                +( 0.031)*r(276)+( 0.278)*r(517)+( 0.115)*r(525)
     &                +( 0.002)*r(530)+( 0.051)*r(531)+( 0.005)*r(532)
     &                +( 0.002)*r(546)+( 0.001)*r(558)+( 0.012)*r(560)
     &                +( 0.001)*r(562)+( 0.012)*r(564)
c
        Loss(lCCHO )= +         r(208)+         r(209)+         r(210)
c
        Gain(lCCHO )= +( 0.001)*r(267)+( 0.214)*r(270)+         r(293)
     &                +         r(295)+( 0.500)*r(296)+( 0.500)*r(297)
     &                +( 0.500)*r(298)+         r(299)+         r(300)
     &                +         r(301)+         r(302)+( 0.100)*r(517)
     &                +( 0.500)*r(519)+( 0.950)*r(542)+( 0.453)*r(553)
c
        Loss(lRCHO )= +         r(211)+         r(212)+         r(213)
c
        Gain(lRCHO )= +( 0.744)*r(224)+         r(225)+( 0.085)*r(227)
     &                +         r(257)+( 0.450)*r(261)+( 0.143)*r(267)
     &                +( 0.001)*r(269)+( 0.074)*r(270)+         r(277)
     &                +         r(303)+         r(305)+( 0.500)*r(306)
     &                +( 0.500)*r(307)+( 0.500)*r(308)+         r(309)
     &                +         r(310)+         r(311)+         r(312)
     &                +( 0.450)*r(521)+( 0.500)*r(549)+( 0.450)*r(551)
     &                +( 0.333)*r(553)+( 0.079)*r(555)+( 0.237)*r(561)
     &                +( 0.237)*r(565)
c
        Loss(lXHCH )= +         r(283)+         r(284)+         r(285)
     &                +         r(286)+         r(287)+         r(288)
     &                +         r(289)+         r(290)+         r(291)
     &                +         r(292)
c
        Gain(lXHCH )= +         r(214)+( 0.088)*r(216)+( 0.012)*r(224)
     &                +( 0.652)*r(247)+( 0.652)*r(250)+( 0.163)*r(253)
     &                +( 0.084)*r(254)+( 0.100)*r(255)+( 0.330)*r(258)
     &                +( 0.300)*r(259)+( 0.050)*r(260)+( 0.055)*r(263)
     &                +( 0.001)*r(264)+( 0.227)*r(265)+( 0.211)*r(267)
     &                +( 0.303)*r(268)+( 0.011)*r(269)+( 0.061)*r(270)
     &                +( 0.083)*r(274)+( 0.020)*r(279)+( 1.610)*r(514)
     &                +( 0.278)*r(517)+( 0.984)*r(518)+( 0.708)*r(522)
     &                +( 0.115)*r(524)+( 0.624)*r(526)+( 0.192)*r(527)
        Gain(lXHCH ) = Gain(lXHCH )
     &                +( 0.240)*r(529)+( 0.022)*r(530)+( 0.344)*r(531)
     &                +( 0.007)*r(532)+( 0.081)*r(542)+( 0.026)*r(545)
     &                +( 0.029)*r(546)+( 0.040)*r(547)+( 0.582)*r(548)
     &                +( 0.179)*r(552)+( 0.114)*r(553)+( 0.072)*r(554)
     &                +( 0.411)*r(558)+( 0.033)*r(559)+( 0.023)*r(560)
     &                +( 0.411)*r(562)+( 0.033)*r(563)+( 0.023)*r(564)
c
        Loss(lMEK  )= +         r(216)+         r(217)
c
        Gain(lMEK  )= +( 0.550)*r(261)+( 0.210)*r(264)+( 0.233)*r(266)
     &                +( 0.010)*r(269)+( 0.124)*r(270)+         r(323)
     &                +         r(325)+( 0.500)*r(326)+( 0.500)*r(327)
     &                +( 0.500)*r(328)+         r(329)+         r(330)
     &                +         r(331)+         r(332)+( 0.500)*r(456)
     &                +( 0.500)*r(457)+( 0.500)*r(458)+( 0.550)*r(521)
     &                +( 0.008)*r(531)+( 0.009)*r(549)+( 0.390)*r(551)
     &                +( 0.033)*r(553)+( 0.751)*r(555)+( 0.002)*r(559)
     &                +( 0.002)*r(563)
c
        Loss(lZRN3 )= +         r(483)+         r(484)+         r(485)
     &                +         r(486)+         r(487)+         r(488)
     &                +         r(489)+         r(490)+         r(491)
     &                +         r(492)
c
        Gain(lZRN3 )= +( 0.039)*r(216)+( 0.004)*r(224)+( 0.029)*r(226)
     &                +( 0.077)*r(227)+( 0.124)*r(228)+( 0.060)*r(246)
     &                +( 0.060)*r(249)+( 0.117)*r(252)+( 0.007)*r(253)
     &                +( 0.025)*r(259)+( 0.041)*r(263)+( 0.051)*r(265)
     &                +( 0.071)*r(267)+( 0.087)*r(268)+( 0.175)*r(269)
     &                +( 0.102)*r(270)+( 0.002)*r(276)+( 0.016)*r(518)
     &                +( 0.051)*r(520)+( 0.049)*r(522)+( 0.065)*r(524)
     &                +( 0.015)*r(525)+( 0.093)*r(526)+( 0.008)*r(527)
     &                +( 0.064)*r(528)+( 0.010)*r(529)+( 0.197)*r(530)
        Gain(lZRN3 ) = Gain(lZRN3 )
     &                +( 0.337)*r(531)+( 0.293)*r(532)+( 0.024)*r(536)
     &                +( 0.054)*r(537)+( 0.082)*r(538)+( 0.087)*r(539)
     &                +( 0.076)*r(540)+( 0.121)*r(541)+( 0.035)*r(544)
     &                +( 0.070)*r(545)+( 0.149)*r(546)+( 0.353)*r(547)
     &                +( 0.128)*r(548)+( 0.005)*r(549)+( 0.228)*r(550)
     &                +( 0.088)*r(552)+( 0.003)*r(553)+( 0.140)*r(554)
     &                +( 0.110)*r(556)+( 0.128)*r(557)+( 0.201)*r(558)
     &                +( 0.121)*r(559)+( 0.460)*r(560)+( 0.201)*r(562)
        Gain(lZRN3 ) = Gain(lZRN3 )
     &                +( 0.121)*r(563)+( 0.460)*r(564)
c
        Loss(lXRCH )= +         r(303)+         r(304)+         r(305)
     &                +         r(306)+         r(307)+         r(308)
     &                +         r(309)+         r(310)+         r(311)
     &                +         r(312)
c
        Gain(lXRCH )= +( 0.376)*r(216)+( 0.400)*r(221)+( 0.205)*r(224)
     &                +( 0.075)*r(226)+( 0.058)*r(227)+( 0.448)*r(228)
     &                +( 0.407)*r(246)+( 0.407)*r(249)+( 0.013)*r(263)
     &                +( 0.218)*r(265)+( 0.402)*r(267)+( 0.780)*r(268)
     &                +( 0.036)*r(269)+( 0.063)*r(270)+( 0.084)*r(281)
     &                +         r(516)+( 0.776)*r(530)+( 0.240)*r(531)
     &                +( 0.684)*r(532)+( 0.261)*r(544)+( 0.122)*r(545)
     &                +( 0.236)*r(546)+( 0.209)*r(547)+( 0.666)*r(548)
     &                +( 0.044)*r(549)+( 0.003)*r(550)+( 0.510)*r(552)
        Gain(lXRCH ) = Gain(lXRCH )
     &                +( 0.019)*r(553)+( 0.163)*r(554)+( 0.385)*r(558)
     &                +( 0.208)*r(559)+( 0.403)*r(560)+( 0.385)*r(562)
     &                +( 0.208)*r(563)+( 0.403)*r(564)
c
        Loss(lFACD )= +         r(219)
c
        Gain(lFACD )= +( 0.333)*r(255)+( 0.351)*r(260)+( 0.100)*r(264)
     &                +( 0.185)*r(275)+( 0.370)*r(515)+( 0.185)*r(519)
     &                +( 0.185)*r(523)+( 0.204)*r(527)+( 0.300)*r(534)
     &                +( 0.185)*r(549)+( 0.024)*r(553)+( 0.172)*r(559)
     &                +( 0.172)*r(563)
c
        Loss(lXMGL )= +         r(353)+         r(354)+         r(355)
     &                +         r(356)+         r(357)+         r(358)
     &                +         r(359)+         r(360)+         r(361)
     &                +         r(362)
c
        Gain(lXMGL )= +( 0.491)*r(220)+( 0.252)*r(228)+( 0.250)*r(238)
     &                +( 0.267)*r(246)+( 0.267)*r(249)+( 0.153)*r(252)
     &                +( 0.095)*r(253)+( 0.084)*r(254)+( 0.300)*r(259)
     &                +( 0.174)*r(263)+( 0.008)*r(265)+( 0.020)*r(530)
     &                +( 0.002)*r(532)+( 0.151)*r(537)+( 0.380)*r(538)
     &                +( 0.238)*r(539)+( 0.112)*r(540)+( 0.405)*r(541)
     &                +( 0.100)*r(556)+( 0.312)*r(557)+( 0.003)*r(558)
     &                +( 0.003)*r(559)+( 0.003)*r(562)+( 0.003)*r(563)
c
        Loss(lXBAC )= +         r(363)+         r(364)+         r(365)
     &                +         r(366)+         r(367)+         r(368)
     &                +         r(369)+         r(370)+         r(371)
     &                +         r(372)
c
        Gain(lXBAC )= +( 0.457)*r(221)+( 0.019)*r(252)+( 0.023)*r(530)
     &                +( 0.081)*r(531)+( 0.185)*r(539)+( 0.112)*r(541)
     &                +( 0.134)*r(557)+( 0.009)*r(558)+( 0.039)*r(559)
     &                +( 0.009)*r(562)+( 0.039)*r(563)
c
        Loss(lROOH )= +         r(224)+         r(225)
c
        Gain(lROOH )= +         r(454)
c
        Loss(lXPD2 )= +         r(333)+         r(334)+         r(335)
     &                +         r(336)+         r(337)+         r(338)
     &                +         r(339)+         r(340)+         r(341)
     &                +         r(342)
c
        Gain(lXPD2 )= +( 0.034)*r(224)+( 0.084)*r(226)+( 0.698)*r(227)
     &                +( 0.332)*r(263)+( 0.007)*r(267)+( 0.031)*r(269)
     &                +( 0.261)*r(270)+( 0.146)*r(546)+( 0.407)*r(547)
     &                +( 0.168)*r(548)+( 0.023)*r(552)+( 0.309)*r(556)
     &                +( 0.057)*r(557)+( 0.409)*r(558)+( 0.409)*r(562)
c
        Loss(lR6PX )= +         r(226)+         r(227)
c
        Gain(lR6PX )= +         r(464)
c
        Loss(lPRD2 )= +         r(267)+         r(268)
c
        Gain(lPRD2 )= +( 0.840)*r(226)+( 0.142)*r(227)+( 0.074)*r(228)
     &                +         r(251)+( 0.600)*r(262)+( 0.329)*r(267)
     &                +( 0.008)*r(269)+( 0.190)*r(270)+         r(333)
     &                +         r(335)+( 0.500)*r(336)+( 0.500)*r(337)
     &                +( 0.500)*r(338)+         r(339)+         r(340)
     &                +         r(341)+         r(342)+( 0.500)*r(466)
     &                +( 0.500)*r(467)+( 0.500)*r(468)+( 0.500)*r(476)
     &                +( 0.500)*r(477)+( 0.500)*r(478)+         r(485)
     &                +( 0.500)*r(486)+( 0.500)*r(487)+( 0.500)*r(488)
        Gain(lPRD2 ) = Gain(lPRD2 )
     &                +         r(489)+         r(490)+         r(491)
     &                +         r(492)+( 0.125)*r(523)+( 0.750)*r(525)
     &                +( 0.100)*r(527)+( 0.750)*r(529)+( 0.255)*r(531)
     &                +         r(533)+( 0.268)*r(549)+( 0.160)*r(551)
     &                +( 0.037)*r(553)+( 0.170)*r(555)+( 0.502)*r(559)
     &                +( 0.763)*r(561)+( 0.502)*r(563)+( 0.763)*r(565)
c
        Loss(lY6PX )= +         r(463)+         r(464)+         r(465)
     &                +         r(466)+         r(467)+         r(468)
     &                +         r(469)+         r(470)+         r(471)
     &                +         r(472)
c
        Gain(lY6PX )= +( 0.858)*r(227)+( 0.713)*r(228)+( 0.800)*r(238)
     &                +( 0.783)*r(246)+( 0.652)*r(247)+( 0.783)*r(249)
     &                +( 0.652)*r(250)+( 0.794)*r(252)+( 0.264)*r(253)
     &                +( 0.711)*r(263)+( 0.048)*r(264)+( 0.850)*r(265)
     &                +( 0.528)*r(267)+         r(268)+( 0.636)*r(269)
     &                +( 0.591)*r(270)+         r(526)+( 0.200)*r(527)
     &                +         r(528)+( 0.250)*r(529)+         r(530)
     &                +( 0.737)*r(531)+         r(532)+( 0.073)*r(537)
     &                +( 0.047)*r(538)+( 0.055)*r(539)+( 0.102)*r(540)
        Gain(lY6PX ) = Gain(lY6PX )
     &                +( 0.043)*r(541)+( 0.017)*r(545)+         r(546)
     &                +         r(547)+( 0.831)*r(548)+( 0.052)*r(549)
     &                +( 0.831)*r(550)+( 0.681)*r(552)+( 0.136)*r(553)
     &                +( 0.681)*r(554)+( 0.369)*r(556)+( 0.101)*r(557)
     &                +         r(558)+( 0.428)*r(559)+         r(560)
     &                +         r(562)+( 0.428)*r(563)+         r(564)
c
        Loss(lRAPX )= +         r(228)+         r(229)
c
        Gain(lRAPX )= +         r(474)
c
        Loss(lMGLY )= +         r(234)+         r(235)+         r(236)
c
        Gain(lMGLY )= +( 0.147)*r(228)+( 0.500)*r(229)+( 0.568)*r(247)
     &                +( 0.305)*r(248)+( 0.568)*r(250)+( 0.184)*r(253)
     &                +( 0.900)*r(255)+( 0.950)*r(260)+( 0.742)*r(264)
     &                +         r(353)+         r(355)+( 0.500)*r(356)
     &                +( 0.500)*r(357)+( 0.500)*r(358)+         r(359)
     &                +         r(360)+         r(361)+         r(362)
c
        Loss(lIPRD )= +         r(263)+         r(264)+         r(265)
     &                +         r(266)
c
        Gain(lIPRD )= +( 0.139)*r(228)+( 0.003)*r(253)+         r(433)
     &                +         r(435)+( 0.500)*r(436)+( 0.500)*r(437)
     &                +( 0.500)*r(438)+         r(439)+         r(440)
     &                +         r(441)+         r(442)+( 0.150)*r(527)
c
        Loss(lXGLY )= +         r(343)+         r(344)+         r(345)
     &                +         r(346)+         r(347)+         r(348)
     &                +         r(349)+         r(350)+         r(351)
     &                +         r(352)
c
        Gain(lXGLY )= +( 0.026)*r(228)+( 0.107)*r(246)+( 0.107)*r(249)
     &                +( 0.274)*r(252)+( 0.150)*r(263)+( 0.083)*r(274)
     &                +( 0.012)*r(517)+( 0.002)*r(531)+( 0.290)*r(536)
     &                +( 0.238)*r(537)+( 0.100)*r(538)+( 0.084)*r(539)
     &                +( 0.286)*r(540)+( 0.074)*r(541)+( 0.158)*r(556)
     &                +( 0.088)*r(557)
c
        Loss(lXMEK )= +         r(323)+         r(324)+         r(325)
     &                +         r(326)+         r(327)+         r(328)
     &                +         r(329)+         r(330)+         r(331)
     &                +         r(332)
c
        Gain(lXMEK )= +( 0.030)*r(228)+( 0.129)*r(246)+( 0.129)*r(249)
     &                +( 0.416)*r(254)+( 0.150)*r(263)+( 0.115)*r(267)
     &                +( 0.170)*r(269)+( 0.083)*r(270)+( 0.332)*r(545)
     &                +( 0.106)*r(546)+( 0.086)*r(547)+( 0.080)*r(552)
     &                +( 0.001)*r(553)+( 0.002)*r(554)+( 0.007)*r(558)
     &                +( 0.007)*r(562)
c
        Loss(lXAF1 )= +         r(383)+         r(384)+         r(385)
     &                +         r(386)+         r(387)+         r(388)
     &                +         r(389)+         r(390)+         r(391)
     &                +         r(392)
c
        Gain(lXAF1 )= +( 0.073)*r(228)+( 0.195)*r(252)+( 0.001)*r(525)
     &                +( 0.029)*r(536)+( 0.195)*r(537)+( 0.336)*r(538)
     &                +( 0.253)*r(539)+( 0.045)*r(540)+( 0.088)*r(541)
     &                +( 0.072)*r(556)+( 0.221)*r(557)
c
        Loss(lXAF2 )= +         r(393)+         r(394)+         r(395)
     &                +         r(396)+         r(397)+         r(398)
     &                +         r(399)+         r(400)+         r(401)
     &                +         r(402)
c
        Gain(lXAF2 )= +( 0.073)*r(228)+( 0.195)*r(252)+( 0.001)*r(525)
     &                +( 0.261)*r(536)+( 0.195)*r(537)+( 0.144)*r(538)
     &                +( 0.253)*r(539)+( 0.067)*r(540)+( 0.352)*r(541)
     &                +( 0.185)*r(556)+( 0.247)*r(557)
c
        Loss(lGLY  )= +         r(230)+         r(231)+         r(232)
     &                +         r(233)
c
        Gain(lGLY  )= +( 0.500)*r(229)+( 0.432)*r(247)+( 0.195)*r(248)
     &                +( 0.432)*r(250)+( 0.366)*r(253)+( 0.023)*r(264)
     &                +( 0.500)*r(275)+         r(343)+         r(345)
     &                +( 0.500)*r(346)+( 0.500)*r(347)+( 0.500)*r(348)
     &                +         r(349)+         r(350)+         r(351)
     &                +         r(352)+( 0.700)*r(534)
c
        Loss(lAFG1 )= +         r(246)+         r(247)+         r(248)
c
        Gain(lAFG1 )= +( 0.500)*r(229)+( 0.350)*r(253)+         r(383)
     &                +         r(385)+( 0.500)*r(386)+( 0.500)*r(387)
     &                +( 0.500)*r(388)+         r(389)+         r(390)
     &                +         r(391)+         r(392)
c
        Loss(lAFG2 )= +         r(249)+         r(250)+         r(251)
c
        Gain(lAFG2 )= +( 0.500)*r(229)+( 0.350)*r(253)+         r(393)
     &                +         r(395)+( 0.500)*r(396)+( 0.500)*r(397)
     &                +( 0.500)*r(398)+         r(399)+         r(400)
     &                +         r(401)+         r(402)
c
        Loss(lBACL )= +         r(237)
c
        Gain(lBACL )= +         r(363)+         r(365)+( 0.500)*r(366)
     &                +( 0.500)*r(367)+( 0.500)*r(368)+         r(369)
     &                +         r(370)+         r(371)+         r(372)
c
        Loss(lBALD )= +         r(243)+         r(244)+         r(245)
c
        Gain(lBALD )= +         r(373)+         r(375)+( 0.500)*r(376)
     &                +( 0.500)*r(377)+( 0.500)*r(378)+         r(379)
     &                +         r(380)+         r(381)+         r(382)
c
        Loss(lAFG3 )= +         r(252)+         r(253)
c
        Gain(lAFG3 )= +( 0.139)*r(253)+         r(403)+         r(405)
     &                +( 0.500)*r(406)+( 0.500)*r(407)+( 0.500)*r(408)
     &                +         r(409)+         r(410)+         r(411)
     &                +         r(412)+( 0.116)*r(536)+( 0.312)*r(537)
     &                +( 0.239)*r(538)+( 0.198)*r(539)+( 0.278)*r(540)
     &                +( 0.230)*r(541)+( 0.202)*r(556)+( 0.178)*r(557)
c
        Loss(lXIPR )= +         r(433)+         r(434)+         r(435)
     &                +         r(436)+         r(437)+         r(438)
     &                +         r(439)+         r(440)+         r(441)
     &                +         r(442)
c
        Gain(lXIPR )= +( 0.231)*r(252)+( 0.471)*r(522)+( 0.120)*r(524)
     &                +( 0.357)*r(526)+( 0.936)*r(528)+( 0.009)*r(548)
     &                +( 0.012)*r(552)+( 0.002)*r(558)+( 0.001)*r(559)
     &                +( 0.004)*r(560)+( 0.002)*r(562)+( 0.001)*r(563)
     &                +( 0.004)*r(564)
c
        Loss(lMACR )= +         r(254)+         r(255)+         r(256)
     &                +         r(257)+         r(258)
c
        Gain(lMACR )= +( 0.003)*r(253)+         r(413)+         r(415)
     &                +( 0.500)*r(416)+( 0.500)*r(417)+( 0.500)*r(418)
     &                +         r(419)+         r(420)+         r(421)
     &                +         r(422)+( 0.390)*r(527)
c
        Loss(lMVK  )= +         r(259)+         r(260)+         r(261)
     &                +         r(262)
c
        Gain(lMVK  )= +( 0.004)*r(253)+         r(423)+         r(425)
     &                +( 0.500)*r(426)+( 0.500)*r(427)+( 0.500)*r(428)
     &                +         r(429)+         r(430)+         r(431)
     &                +         r(432)+( 0.375)*r(523)+( 0.160)*r(527)
c
        Loss(lXGLD )= +         r(493)+         r(494)+         r(495)
     &                +         r(496)+         r(497)+         r(498)
     &                +         r(499)+         r(500)+         r(501)
     &                +         r(502)
c
        Gain(lXGLD )= +( 0.675)*r(259)+( 0.129)*r(263)+( 0.047)*r(264)
     &                +( 0.195)*r(514)+( 0.010)*r(542)+( 0.007)*r(548)
     &                +( 0.002)*r(560)
c
        Loss(lXRN3 )= +         r(443)+         r(444)+         r(445)
     &                +         r(446)+         r(447)+         r(448)
     &                +         r(449)+         r(450)+         r(451)
     &                +         r(452)
c
        Gain(lXRN3 )= +( 0.572)*r(265)+( 0.305)*r(269)+( 0.031)*r(276)
     &                +( 0.355)*r(524)+( 0.056)*r(532)+( 0.774)*r(550)
     &                +( 0.320)*r(554)+( 0.228)*r(560)+( 0.228)*r(564)
c
        Loss(lGLYD )= +         r(271)+         r(272)+         r(273)
c
        Gain(lGLYD )= +( 0.467)*r(266)+         r(493)+         r(495)
     &                +( 0.500)*r(496)+( 0.500)*r(497)+( 0.500)*r(498)
     &                +         r(499)+         r(500)+         r(501)
     &                +         r(502)
c
        Loss(lXACE )= +         r(313)+         r(314)+         r(315)
     &                +         r(316)+         r(317)+         r(318)
     &                +         r(319)+         r(320)+         r(321)
     &                +         r(322)
c
        Gain(lXACE )= +( 0.004)*r(269)+( 0.008)*r(270)+( 0.034)*r(530)
     &                +( 0.345)*r(531)+( 0.069)*r(532)+( 0.704)*r(544)
     &                +( 0.024)*r(545)+( 0.426)*r(546)+( 0.071)*r(547)
     &                +( 0.007)*r(548)+( 0.003)*r(549)+( 0.034)*r(550)
     &                +( 0.144)*r(552)+( 0.116)*r(554)+( 0.037)*r(558)
     &                +( 0.057)*r(559)+( 0.239)*r(560)+( 0.037)*r(562)
     &                +( 0.057)*r(563)+( 0.239)*r(564)
c
        Loss(lACRO )= +         r(274)+         r(275)+         r(276)
     &                +         r(277)+         r(278)
c
        Gain(lACRO )= +         r(503)+         r(505)+( 0.500)*r(506)
     &                +( 0.500)*r(507)+( 0.500)*r(508)+         r(509)
     &                +         r(510)+         r(511)+         r(512)
     &                +( 0.500)*r(523)
c
        Loss(lXBAL )= +         r(373)+         r(374)+         r(375)
     &                +         r(376)+         r(377)+         r(378)
     &                +         r(379)+         r(380)+         r(381)
     &                +         r(382)
c
        Gain(lXBAL )= +( 0.065)*r(537)+( 0.041)*r(538)+( 0.047)*r(539)
     &                +( 0.088)*r(540)+( 0.036)*r(541)+( 0.026)*r(557)
c
        Loss(lXAF3 )= +         r(403)+         r(404)+         r(405)
     &                +         r(406)+         r(407)+         r(408)
     &                +         r(409)+         r(410)+         r(411)
     &                +         r(412)
c
        Gain(lXAF3 )= +( 0.286)*r(540)+( 0.151)*r(541)+( 0.068)*r(557)
c
        Loss(lXMAC )= +         r(413)+         r(414)+         r(415)
     &                +         r(416)+         r(417)+         r(418)
     &                +         r(419)+         r(420)+         r(421)
     &                +         r(422)
c
        Gain(lXMAC )= +( 0.230)*r(526)+( 0.001)*r(548)+( 0.002)*r(559)
     &                +( 0.005)*r(560)+( 0.002)*r(563)+( 0.005)*r(564)
c
        Loss(lXMVK )= +         r(423)+         r(424)+         r(425)
     &                +         r(426)+         r(427)+         r(428)
     &                +         r(429)+         r(430)+         r(431)
     &                +         r(432)
c
        Gain(lXMVK )= +( 0.460)*r(524)+( 0.320)*r(526)+( 0.012)*r(548)
     &                +( 0.002)*r(552)+( 0.003)*r(558)+( 0.001)*r(560)
     &                +( 0.003)*r(562)+( 0.001)*r(564)
c
        Loss(lYAPX )= +         r(473)+         r(474)+         r(475)
     &                +         r(476)+         r(477)+         r(478)
     &                +         r(479)+         r(480)+         r(481)
     &                +         r(482)
c
        Gain(lYAPX )= +( 0.314)*r(536)+( 0.435)*r(537)+( 0.555)*r(538)
     &                +( 0.586)*r(539)+( 0.461)*r(540)+( 0.705)*r(541)
c
        Loss(lXACR )= +         r(503)+         r(504)+         r(505)
     &                +         r(506)+         r(507)+         r(508)
     &                +         r(509)+         r(510)+         r(511)
     &                +         r(512)
c
        Gain(lXACR )= +( 0.480)*r(522)+( 0.115)*r(525)+( 0.036)*r(548)
c
        Loss(lETHE )= +         r(514)+         r(515)+         r(516)
     &                +         r(517)
c
        Gain(lETHE )= 0.0
c
        Loss(lPRPE )= +         r(518)+         r(519)+         r(520)
     &                +         r(521)
c
        Gain(lPRPE )= 0.0
c
        Loss(lBD13 )= +         r(522)+         r(523)+         r(524)
     &                +         r(525)
c
        Gain(lBD13 )= 0.0
c
        Loss(lISOP )= +         r(526)+         r(527)+         r(528)
     &                +         r(529)
c
        Gain(lISOP )= 0.0
c
        Loss(lAPIN )= +         r(530)+         r(531)+         r(532)
     &                +         r(533)
c
        Gain(lAPIN )= 0.0
c
        Loss(lACYE )= +         r(534)+         r(535)
c
        Gain(lACYE )= 0.0
c
        Loss(lBENZ )= +         r(536)
c
        Gain(lBENZ )= 0.0
c
        Loss(lTOLU )= +         r(537)
c
        Gain(lTOLU )= 0.0
c
        Loss(lMXYL )= +         r(538)
c
        Gain(lMXYL )= 0.0
c
        Loss(lOXYL )= +         r(539)
c
        Gain(lOXYL )= 0.0
c
        Loss(lPXYL )= +         r(540)
c
        Gain(lPXYL )= 0.0
c
        Loss(lB124 )= +         r(541)
c
        Gain(lB124 )= 0.0
c
        Loss(lETOH )= +         r(542)
c
        Gain(lETOH )= 0.0
c
        Loss(lALK1 )= +         r(543)
c
        Gain(lALK1 )= 0.0
c
        Loss(lALK2 )= +         r(544)
c
        Gain(lALK2 )= 0.0
c
        Loss(lALK3 )= +         r(545)
c
        Gain(lALK3 )= 0.0
c
        Loss(lALK4 )= +         r(546)
c
        Gain(lALK4 )= 0.0
c
        Loss(lALK5 )= +         r(547)
c
        Gain(lALK5 )= 0.0
c
        Loss(lOLE1 )= +         r(548)+         r(549)+         r(550)
     &                +         r(551)
c
        Gain(lOLE1 )= 0.0
c
        Loss(lOLE2 )= +         r(552)+         r(553)+         r(554)
     &                +         r(555)
c
        Gain(lOLE2 )= 0.0
c
        Loss(lARO1 )= +         r(556)
c
        Gain(lARO1 )= 0.0
c
        Loss(lARO2 )= +         r(557)
c
        Gain(lARO2 )= 0.0
c
        Loss(lTERP )= +         r(558)+         r(559)+         r(560)
     &                +         r(561)
c
        Gain(lTERP )= 0.0
c
        Loss(lSESQ )= +         r(562)+         r(563)+         r(564)
     &                +         r(565)
c
        Gain(lSESQ )= 0.0
c
c
      do l = 1,neq
        rate(l) = gain(l) -loss(l)
      enddo
c
      return
      end
