      subroutine lsrxn4(H2O,M,O2,CH4,H2,y,dbrk,r)
      implicit none
c
c----CAMx v7Beta6 190902
c
c     LSRXN4 computes double precision fluxes for each reaction
c
c     Copyright 1996 - 2019
c     Ramboll
c     Created by the CMC version 5.2.6
c
c     Routines Called:
c        none
c
c     Called by:
c        LSRATE4
c
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
      double precision H2O, M, O2, CH4, H2, N2
      double precision y(*)
      double precision dbrk(*)
      double precision r(*)
c
c --- Entry point
c
      N2  = M - O2
      r(  1) = dbrk(  1)*y(lNO2)
      r(  2) = dbrk(  2)*y(lO)*O2*M
      r(  3) = dbrk(  3)*y(lO3)*y(lNO)
      r(  4) = dbrk(  4)*y(lO)*y(lNO)*M
      r(  5) = dbrk(  5)*y(lO)*y(lNO2)
      r(  6) = dbrk(  6)*y(lO)*y(lNO2)
      r(  7) = dbrk(  7)*y(lO)*y(lO3)
      r(  8) = dbrk(  8)*y(lO3)
      r(  9) = dbrk(  9)*y(lO3)
      r( 10) = dbrk( 10)*y(lO1D)*M
      r( 11) = dbrk( 11)*y(lO1D)*H2O
      r( 12) = dbrk( 12)*y(lO3)*y(lOH)
      r( 13) = dbrk( 13)*y(lO3)*y(lHO2)
      r( 14) = dbrk( 14)*y(lOH)*y(lO)
      r( 15) = dbrk( 15)*y(lHO2)*y(lO)
      r( 16) = dbrk( 16)*y(lOH)*y(lOH)
      r( 17) = dbrk( 17)*y(lOH)*y(lOH)
      r( 18) = dbrk( 18)*y(lOH)*y(lHO2)
      r( 19) = dbrk( 19)*y(lHO2)*y(lHO2)
      r( 20) = dbrk( 20)*y(lHO2)*y(lHO2)*H2O
      r( 21) = dbrk( 21)*y(lH2O2)
      r( 22) = dbrk( 22)*y(lH2O2)*y(lOH)
      r( 23) = dbrk( 23)*y(lH2O2)*y(lO)
      r( 24) = dbrk( 24)*y(lNO)*y(lNO)*O2
      r( 25) = dbrk( 25)*y(lHO2)*y(lNO)
      r( 26) = dbrk( 26)*y(lNO2)*y(lO3)
      r( 27) = dbrk( 27)*y(lNO3)
      r( 28) = dbrk( 28)*y(lNO3)
      r( 29) = dbrk( 29)*y(lNO3)*y(lNO)
      r( 30) = dbrk( 30)*y(lNO3)*y(lNO2)
      r( 31) = dbrk( 31)*y(lNO3)*y(lO)
      r( 32) = dbrk( 32)*y(lNO3)*y(lOH)
      r( 33) = dbrk( 33)*y(lNO3)*y(lHO2)
      r( 34) = dbrk( 34)*y(lNO3)*y(lO3)
      r( 35) = dbrk( 35)*y(lNO3)*y(lNO3)
      r( 36) = dbrk( 36)*y(lNO3)*y(lNO2)
      r( 37) = dbrk( 37)*y(lN2O5)
      r( 38) = dbrk( 38)*y(lN2O5)
      r( 39) = dbrk( 39)*y(lN2O5)*H2O
      r( 40) = dbrk( 40)*y(lNO)*y(lOH)
      r( 41) = dbrk( 41)*y(lNO)*y(lNO2)*H2O
      r( 42) = dbrk( 42)*y(lHONO)*y(lHONO)
      r( 43) = dbrk( 43)*y(lHONO)
      r( 44) = dbrk( 44)*y(lHONO)*y(lOH)
      r( 45) = dbrk( 45)*y(lNO2)*y(lOH)
      r( 46) = dbrk( 46)*y(lHNO3)*y(lOH)
      r( 47) = dbrk( 47)*y(lHNO3)
      r( 48) = dbrk( 48)*y(lHO2)*y(lNO2)
      r( 49) = dbrk( 49)*y(lPNA)
      r( 50) = dbrk( 50)*y(lPNA)
      r( 51) = dbrk( 51)*y(lPNA)*y(lOH)
      r( 52) = dbrk( 52)*y(lSO2)*y(lOH)
      r( 53) = dbrk( 53)*y(lC2O3)*y(lNO)
      r( 54) = dbrk( 54)*y(lC2O3)*y(lNO2)
      r( 55) = dbrk( 55)*y(lPAN)
      r( 56) = dbrk( 56)*y(lPAN)
      r( 57) = dbrk( 57)*y(lC2O3)*y(lHO2)
      r( 58) = dbrk( 58)*y(lC2O3)*y(lRO2)
      r( 59) = dbrk( 59)*y(lC2O3)*y(lC2O3)
      r( 60) = dbrk( 60)*y(lC2O3)*y(lCXO3)
      r( 61) = dbrk( 61)*y(lCXO3)*y(lNO)
      r( 62) = dbrk( 62)*y(lCXO3)*y(lNO2)
      r( 63) = dbrk( 63)*y(lPANX)
      r( 64) = dbrk( 64)*y(lPANX)
      r( 65) = dbrk( 65)*y(lCXO3)*y(lHO2)
      r( 66) = dbrk( 66)*y(lCXO3)*y(lRO2)
      r( 67) = dbrk( 67)*y(lCXO3)*y(lCXO3)
      r( 68) = dbrk( 68)*y(lRO2)*y(lNO)
      r( 69) = dbrk( 69)*y(lRO2)*y(lHO2)
      r( 70) = dbrk( 70)*y(lRO2)*y(lRO2)
      r( 71) = dbrk( 71)*y(lMEO2)*y(lNO)
      r( 72) = dbrk( 72)*y(lMEO2)*y(lHO2)
      r( 73) = dbrk( 73)*y(lMEO2)*y(lC2O3)
      r( 74) = dbrk( 74)*y(lMEO2)*y(lRO2)
      r( 75) = dbrk( 75)*y(lXO2H)*y(lNO)
      r( 76) = dbrk( 76)*y(lXO2H)*y(lHO2)
      r( 77) = dbrk( 77)*y(lXO2H)*y(lC2O3)
      r( 78) = dbrk( 78)*y(lXO2H)*y(lRO2)
      r( 79) = dbrk( 79)*y(lXO2)*y(lNO)
      r( 80) = dbrk( 80)*y(lXO2)*y(lHO2)
      r( 81) = dbrk( 81)*y(lXO2)*y(lC2O3)
      r( 82) = dbrk( 82)*y(lXO2)*y(lRO2)
      r( 83) = dbrk( 83)*y(lXO2N)*y(lNO)
      r( 84) = dbrk( 84)*y(lXO2N)*y(lHO2)
      r( 85) = dbrk( 85)*y(lXO2N)*y(lC2O3)
      r( 86) = dbrk( 86)*y(lXO2N)*y(lRO2)
      r( 87) = dbrk( 87)*y(lMEPX)*y(lOH)
      r( 88) = dbrk( 88)*y(lMEPX)
      r( 89) = dbrk( 89)*y(lROOH)*y(lOH)
      r( 90) = dbrk( 90)*y(lROOH)
      r( 91) = dbrk( 91)*y(lNTR1)*y(lOH)
      r( 92) = dbrk( 92)*y(lNTR1)
      r( 93) = dbrk( 93)*y(lFACD)*y(lOH)
      r( 94) = dbrk( 94)*y(lAACD)*y(lOH)
      r( 95) = dbrk( 95)*y(lPACD)*y(lOH)
      r( 96) = dbrk( 96)*y(lFORM)*y(lOH)
      r( 97) = dbrk( 97)*y(lFORM)
      r( 98) = dbrk( 98)*y(lFORM)
      r( 99) = dbrk( 99)*y(lFORM)*y(lNO3)
      r(100) = dbrk(100)*y(lFORM)*y(lHO2)
      r(101) = dbrk(101)*y(lHCO3)
      r(102) = dbrk(102)*y(lHCO3)*y(lNO)
      r(103) = dbrk(103)*y(lHCO3)*y(lHO2)
      r(104) = dbrk(104)*y(lALD2)*y(lOH)
      r(105) = dbrk(105)*y(lALD2)*y(lNO3)
      r(106) = dbrk(106)*y(lALD2)
      r(107) = dbrk(107)*y(lALDX)*y(lOH)
      r(108) = dbrk(108)*y(lALDX)*y(lNO3)
      r(109) = dbrk(109)*y(lALDX)
      r(110) = dbrk(110)*y(lGLYD)*y(lOH)
      r(111) = dbrk(111)*y(lGLYD)
      r(112) = dbrk(112)*y(lGLYD)*y(lNO3)
      r(113) = dbrk(113)*y(lGLY)*y(lOH)
      r(114) = dbrk(114)*y(lGLY)
      r(115) = dbrk(115)*y(lGLY)*y(lNO3)
      r(116) = dbrk(116)*y(lMGLY)
      r(117) = dbrk(117)*y(lMGLY)*y(lNO3)
      r(118) = dbrk(118)*y(lMGLY)*y(lOH)
      r(119) = dbrk(119)*H2*y(lOH)
      r(120) = dbrk(120)*y(lCO)*y(lOH)
      r(121) = dbrk(121)*CH4*y(lOH)
      r(122) = dbrk(122)*y(lETHA)*y(lOH)
      r(123) = dbrk(123)*y(lMEOH)*y(lOH)
      r(124) = dbrk(124)*y(lETOH)*y(lOH)
      r(125) = dbrk(125)*y(lKET)
      r(126) = dbrk(126)*y(lACET)
      r(127) = dbrk(127)*y(lACET)*y(lOH)
      r(128) = dbrk(128)*y(lPRPA)*y(lOH)
      r(129) = dbrk(129)*y(lPAR)*y(lOH)
      r(130) = dbrk(130)*y(lROR)
      r(131) = dbrk(131)*y(lROR)*O2
      r(132) = dbrk(132)*y(lROR)*y(lNO2)
      r(133) = dbrk(133)*y(lETHY)*y(lOH)
      r(134) = dbrk(134)*y(lETH)*y(lOH)
      r(135) = dbrk(135)*y(lETH)*y(lO3)
      r(136) = dbrk(136)*y(lETH)*y(lNO3)
      r(137) = dbrk(137)*y(lOLE)*y(lOH)
      r(138) = dbrk(138)*y(lOLE)*y(lO3)
      r(139) = dbrk(139)*y(lOLE)*y(lNO3)
      r(140) = dbrk(140)*y(lIOLE)*y(lOH)
      r(141) = dbrk(141)*y(lIOLE)*y(lO3)
      r(142) = dbrk(142)*y(lIOLE)*y(lNO3)
      r(143) = dbrk(143)*y(lISOP)*y(lOH)
      r(144) = dbrk(144)*y(lISO2)*y(lNO)
      r(145) = dbrk(145)*y(lISO2)*y(lHO2)
      r(146) = dbrk(146)*y(lISO2)*y(lC2O3)
      r(147) = dbrk(147)*y(lISO2)*y(lRO2)
      r(148) = dbrk(148)*y(lISO2)
      r(149) = dbrk(149)*y(lISOP)*y(lO3)
      r(150) = dbrk(150)*y(lISOP)*y(lNO3)
      r(151) = dbrk(151)*y(lISPD)*y(lOH)
      r(152) = dbrk(152)*y(lISPD)*y(lO3)
      r(153) = dbrk(153)*y(lISPD)*y(lNO3)
      r(154) = dbrk(154)*y(lISPD)
      r(155) = dbrk(155)*y(lISPX)*y(lOH)
      r(156) = dbrk(156)*y(lHPLD)
      r(157) = dbrk(157)*y(lHPLD)*y(lNO3)
      r(158) = dbrk(158)*y(lEPOX)*y(lOH)
      r(159) = dbrk(159)*y(lEPX2)*y(lHO2)
      r(160) = dbrk(160)*y(lEPX2)*y(lNO)
      r(161) = dbrk(161)*y(lEPX2)*y(lC2O3)
      r(162) = dbrk(162)*y(lEPX2)*y(lRO2)
      r(163) = dbrk(163)*y(lINTR)*y(lOH)
      r(164) = dbrk(164)*y(lTERP)*y(lOH)
      r(165) = dbrk(165)*y(lTERP)*y(lO3)
      r(166) = dbrk(166)*y(lTERP)*y(lNO3)
      r(167) = dbrk(167)*y(lBENZ)*y(lOH)
      r(168) = dbrk(168)*y(lBZO2)*y(lNO)
      r(169) = dbrk(169)*y(lBZO2)*y(lC2O3)
      r(170) = dbrk(170)*y(lBZO2)*y(lHO2)
      r(171) = dbrk(171)*y(lBZO2)*y(lRO2)
      r(172) = dbrk(172)*y(lTOL)*y(lOH)
      r(173) = dbrk(173)*y(lTO2)*y(lNO)
      r(174) = dbrk(174)*y(lTO2)*y(lC2O3)
      r(175) = dbrk(175)*y(lTO2)*y(lHO2)
      r(176) = dbrk(176)*y(lTO2)*y(lRO2)
      r(177) = dbrk(177)*y(lXYL)*y(lOH)
      r(178) = dbrk(178)*y(lXLO2)*y(lNO)
      r(179) = dbrk(179)*y(lXLO2)*y(lHO2)
      r(180) = dbrk(180)*y(lXLO2)*y(lC2O3)
      r(181) = dbrk(181)*y(lXLO2)*y(lRO2)
      r(182) = dbrk(182)*y(lCRES)*y(lOH)
      r(183) = dbrk(183)*y(lCRES)*y(lNO3)
      r(184) = dbrk(184)*y(lCRO)*y(lNO2)
      r(185) = dbrk(185)*y(lCRO)*y(lHO2)
      r(186) = dbrk(186)*y(lCRON)*y(lOH)
      r(187) = dbrk(187)*y(lCRON)*y(lNO3)
      r(188) = dbrk(188)*y(lCRON)
      r(189) = dbrk(189)*y(lXOPN)
      r(190) = dbrk(190)*y(lXOPN)*y(lOH)
      r(191) = dbrk(191)*y(lXOPN)*y(lO3)
      r(192) = dbrk(192)*y(lXOPN)*y(lNO3)
      r(193) = dbrk(193)*y(lOPEN)
      r(194) = dbrk(194)*y(lOPEN)*y(lOH)
      r(195) = dbrk(195)*y(lOPEN)*y(lO3)
      r(196) = dbrk(196)*y(lOPEN)*y(lNO3)
      r(197) = dbrk(197)*y(lCAT1)*y(lOH)
      r(198) = dbrk(198)*y(lCAT1)*y(lNO3)
      r(199) = dbrk(199)*y(lOPO3)*y(lNO)
      r(200) = dbrk(200)*y(lOPO3)*y(lNO2)
      r(201) = dbrk(201)*y(lOPAN)
      r(202) = dbrk(202)*y(lOPO3)*y(lHO2)
      r(203) = dbrk(203)*y(lOPO3)*y(lC2O3)
      r(204) = dbrk(204)*y(lOPO3)*y(lRO2)
      r(205) = dbrk(205)*y(lOPAN)*y(lOH)
      r(206) = dbrk(206)*y(lPANX)*y(lOH)
      r(207) = dbrk(207)*y(lNTR2)
      r(208) = dbrk(208)*y(lECH4)*y(lOH)
      r(209) = dbrk(209)*y(lI2)
      r(210) = dbrk(210)*y(lHOI)
      r(211) = dbrk(211)*y(lI)*y(lO3)
      r(212) = dbrk(212)*y(lIO)
      r(213) = dbrk(213)*y(lIO)*y(lIO)
      r(214) = dbrk(214)*y(lIO)*y(lHO2)
      r(215) = dbrk(215)*y(lIO)*y(lNO)
      r(216) = dbrk(216)*y(lIO)*y(lNO2)
      r(217) = dbrk(217)*y(lOIO)
      r(218) = dbrk(218)*y(lOIO)*y(lOH)
      r(219) = dbrk(219)*y(lOIO)*y(lIO)
      r(220) = dbrk(220)*y(lOIO)*y(lNO)
      r(221) = dbrk(221)*y(lI2O2)
      r(222) = dbrk(222)*y(lI2O2)*y(lO3)
      r(223) = dbrk(223)*y(lINO3)
      r(224) = dbrk(224)*y(lINO3)*H2O
      r(225) = dbrk(225)*y(lXPRP)
      r(226) = dbrk(226)*y(lXPRP)
      r(227) = dbrk(227)*y(lXPAR)
      r(228) = dbrk(228)*y(lXPAR)
      r(229) = dbrk(229)*y(lINTR)
      r(230) = dbrk(230)*y(lSO2)
      r(231) = dbrk(231)*y(lDMS)*y(lOH)
      r(232) = dbrk(232)*y(lDMS)*y(lOH)*O2
      r(233) = dbrk(233)*y(lDMS)*y(lNO3)
c
      return
      end
