c**** NCF_SET_EMISS_MAPPING
c
      subroutine ncf_set_emiss_mapping(iounit,action)
      use filunit
      use chmstry
      implicit none
c
c----CAMx v7Beta6 190902
c
c-----------------------------------------------------------------------
c    Description:
c-----------------------------------------------------------------------
c
c   This routine checks which species are in the file and adds them to
c   the master emissions species list. It also sets the array for
c   the index of species into this file.
c
c     Copyright 1996 - 2018
c     Ramboll
c      Argument description:
c       Inputs:
c         iounit        I NCF file ID
c         action        C string that describes file being read
c       Outputs:
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c     02/20/17   --gwilson--    Original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'camx.prm'
      include 'netcdf.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer       iounit
      character*(*) action
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
      integer istrln
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer ispc, ierr, this_varid, i
      logical lfound
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c   --- loop ober species in list ----
c
      do ispc=1,nspec
c
c   --- seek this species ---
c
         ierr = nf_inq_varid(iounit,spname(ispc),this_varid)
         if( ierr .EQ. NF_NOERR  ) then
c
c   --- now check if this species is already in master list ---
c
           lfound = .FALSE.
           do i=1,nemspc
             if(spname(ispc) .EQ. emspcname(i) ) then
                lfound = .TRUE.
                lemmap(ispc) = i
             endif
           enddo
           if( .NOT. lfound ) then
             nemspc = nemspc + 1
             emspcname(nemspc) = spname(ispc)
             lemmap(ispc) = nemspc
           endif
         endif
c
c  --- next species ---
c
      enddo
c
c-----------------------------------------------------------------------
c    Error messages:
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
 
