c***** NCF_RDPTRT.F
c
      subroutine ncf_rdptrt(ndate,ttime)
      use tracer
      use ptemiss
      implicit none
c
c----CAMx v7Beta6 190902
c
c
c     Copyright 1996 - 2018
c     Ramboll
c
c-----------------------------------------------------------------------
c
c   This routine reads one hour of emissions for the RTRAC process
c   and fills the approproate arrays.  The emissions file for one grid
c   but each emissions groups is read. This version is for NetCDF files.
c    Argument descriptions:
c     Outputs:
c     Inputs:
c       ndate     I    julian day of current hour
c       ttime     R    current hour
c       
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c     06/13/19   --gwilson--   Originial development
c
c-----------------------------------------------------------------------
c   Include files:
c-----------------------------------------------------------------------
c
      include 'camx.prm'
      include 'netcdf.inc'
c       
c-----------------------------------------------------------------------
c   Argument declarations:
c-----------------------------------------------------------------------
c
      integer ndate
      real    ttime
c
c-----------------------------------------------------------------------
c   Local variables:
c-----------------------------------------------------------------------
c
      character*200 fname
      character*10  this_var
      integer       ierr, nlays_in
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c  --- initialize emissions to zero ---
c
     sapnts = 0.
c
c   --- skip if filename not supplied ---
c
      if( .NOT. is_netcdf_iortpt(1,1) .OR. .NOT. ltptfl(1,1) 
     &                             .OR. .NOT. lptsrc ) goto 9999
c
c   --- set the unit number for surface emissions file ---
c
      iounit = iortpt(1,1)
      fname = tptfil(1,1)
c
c   ---- get the number of layers in this file ---
c
      this_var = 'NLAYS'
      ierr = nf_get_att_int(iounit, NF_GLOBAL, 'NLAYS', nlays_in)
      if( ierr .NE. NF_NOERR ) goto 7000
c
c   --- allocate the local array ---
c
      read(iounit,END=222) ibgdat, bgtim, iendat, edtim
      bgtim = 100.*aint(bgtim) + 60.*amod(bgtim,1.)
      edtim = 100.*aint(edtim) + 60.*amod(edtim,1.)
c
c   --- read the emissions for this hour ---
c
      read(iounit,ERR=7000,END=7001) iseg, npoint
      if( npoint .GT. nptsrc ) goto 7002
      read(iounit,ERR=7000,END=7001) idum
      do 20 ispc = 1,nspcpt(1,1)
        read(iounit,ERR=7000) iseg, (iname(i),i=1,10), 
     &                              (emspnt(i),i=1,npoint)
        write(cname,'(10A1)') iname
c
c   --- if date and time does not match this hour, skip this record ---
c
        if( le1day ) then
           if( abs(bgtim-ttime).ge.0.01 ) goto 20
        else
           if( ndate .NE. ibgdat .OR. abs(bgtim-ttime).ge.0.01 ) goto 20
        endif
        lfound  = .TRUE.
c
c   --- if the species is not modelled or not used for RTRAC ----
c
        idx = idxpts(1,1,ispc)
        if( idx .LE. 0 ) goto 20
c
c  --- find this species in the modeled species list ---
c
        do imod = 1,nrtrac
          if( cname .EQ. ptname(imod) ) then
             do 30 i = 1,npoint
               if( llatlon ) then
                  xloctmp = xlocpt(i) - xorg
                  yloctmp = ylocpt(i) - yorg
               else
                  xloctmp = xlocpt(i)/1000. - xorg
                  yloctmp = ylocpt(i)/1000. - yorg
               endif
               icel = 1 + FLOOR( xloctmp/delx )
               jcel = 1 + FLOOR( yloctmp/dely )
               if( icel .LT. 1 .OR. icel .GT. ncol(1) ) goto 30
               if( jcel .LT. 1 .OR. jcel .GT. nrow(1) ) goto 30
c
c  --- convert to emissions time and put into array ---
c
               emstmp = emspnt(i)/(60.*dtems)
               if( emstmp .GT. rtlbnd(imod) ) sapnts(i,imod) = emstmp
c
c  --- next point ---
c
   30        continue
             goto 20
          endif
c
c  --- next RTRAC emssions species ---
c
        enddo
c
c  --- if not found in model species list, write a message ----     
c   
        write(idiag,'(1X,4A)') 'Species in RTRAC ',
     &            'point source file: ',cname(:istrln(cname)),
     &            ' not found in species list ... Skipping.'
c
c   --- next species ---
c
  20  continue
c
c   --- if the correct hour has not been found, 
c       go back and read some more else read next file ---
c
      if( .NOT. lfound ) then
         goto 111
      else
         goto 9999
      endif
c
c   --- if using 1 day emissions, we need to rewind the file to
c       get the current hour ---
c
  222 continue
      if( le1day ) then
          rewind(iounit)
          read(iounit)
          read(iounit)
          read(iounit)
          read(iounit)
          read(iounit)
          read(iounit)
          if( lpass ) goto 7001
          if( .NOT. lpass ) lpass = .TRUE.
          goto 111
      else
          goto 7001
      endif
c
c  --- get the next file ---
c
      goto 9999
c
c----------------------------------------------------------------------
c    Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(iout,'(//,a)') 'ERROR in NCF_RDPTRT:'
      write(iout,'(A)') action(:istrln(action))
      write(iout,'(2A)') 'Cannot find global attribute: ',
     &                                      this_var(:istrln(this_var))
      write(iout,'(2A)') 'File: ',fname(:istrln(fname))
      call camxerr()
c
c----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
c
      return
      end
