C=======================================================================
      MODULE mod_AsosCommDates
C=======================================================================

      IMPLICIT NONE

      INTEGER, PARAMETER :: NCommDates=886

      TYPE ASOSData
            CHARACTER (LEN=40) :: City
            CHARACTER (Len=60) :: Location
            CHARACTER (LEN=2)  :: State
            INTEGER            :: IWBAN
            CHARACTER (LEN=4)  :: INTCALL
            CHARACTER (LEN=3)  :: USACALL
            REAL               :: DDLAT
            REAL               :: DDLON
            CHARACTER (LEN=8)  :: COMMISDATE
            CHARACTER (LEN=3)  :: PUB
            CHARACTER (LEN=3)  :: SITETYPE
            REAL               :: ANEM_FEET
            REAL               :: ANEM_METERS
      END TYPE ASOSData
      
      TYPE (ASOSDATA), DIMENSION(NCommDates) :: ASOSCommDates

      CONTAINS

         SUBROUTINE InitAsosCommInfo (ASOSCommDates)

         TYPE (ASOSDATA), DIMENSION(NCommDates) :: ASOSCommDates

      ASOSCommDates(1) = ASOSDATA("ANCHORAGE","LAKE HOOD SEAPLANE BASE",
     &  "AK",26491,"PALH","LHD",61.17,-149.96,"19980122","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(2) = ASOSDATA("ANCHORAGE","MERRILL FIELD AIRPORT",
     &  "AK",26409,"PAMR","MRI",61.21,-149.85,"19971015","NO","FAA",
     &  16.00,4.87)
      ASOSCommDates(3) = ASOSDATA("ANCHORAGE",
     &  "TED STEVENS ANCHORAGE INTERNATIONAL AIRPORT","AK",26451,"PANC",
     &  "ANC",61.17,-149.99,"19980601","YES","NWS",26.00,7.92)
      ASOSCommDates(4) = ASOSDATA("ANNETTE ","ANNETTE ISLAND AIRPORT",
     &  "AK",25308,"PANT","ANN",55.04,-131.57,"19960901","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(5) = ASOSDATA("BARROW",
     &  "WILEY POST - WILL ROGERS MEMORIAL AIPRORT","AK",27502,"PABR",
     &  "BRW",71.28,-156.76,"19980601","YES","NWS",26.00,7.92)
      ASOSCommDates(6) = ASOSDATA("BETHEL","BETHEL AIRPORT","AK",26615,
     &  "PABE","BET",60.78,-161.82,"19981101","YES","NWS",26.00,7.92)
      ASOSCommDates(7) = ASOSDATA("BETTLES","BETTLES AIRPORT","AK",
     &  26533,"PABT","BTT",66.91,-151.5,"19991119","YES","FAA",33.00,
     &  10.05)
      ASOSCommDates(8) = ASOSDATA("COLD BAY","COLD BAY AIRPORT","AK",
     &  25624,"PACD","CDB",55.2,-162.72,"19980701","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(9) = ASOSDATA("CORDOVA",
     &  "MERLE K.(MUDHOLE)SMITH AIRPORT","AK",26410,"PACV","CDV",60.48,
     &  -145.45,"19991213","NO","FAA",26.00,7.92)
      ASOSCommDates(10) = ASOSDATA("DEADHORSE","DEADHORSE AIRPORT","AK",
     &  27406,"PASC","SCC",70.19,-148.47,"19990609","NO","FAA",26.00,
     &  7.92)
      ASOSCommDates(11) = ASOSDATA("DEERING","DEERING AIRPORT","AK",
     &  26643,"PADE","0Z0",66.06,-162.76,"19980727","NO","FAA",-9.,-9.)
      ASOSCommDates(12) = ASOSDATA("DELTA JUNCTION/FT GREELY",
     &  "ALLEN ARMY AIRFIELD ","AK",26415,"PABI","BIG",63.99,-145.71,
     &  "19971215","YES","FAA",33.00,10.05)
      ASOSCommDates(13) = ASOSDATA("EAGLE","EAGLE AIRPORT","AK",26422,
     &  "PAEG","EAA",64.77,-141.14,"19980215","NO","FAA",33.00,10.05)
      ASOSCommDates(14) = ASOSDATA("FAIRBANKS",
     &  "FAIRBANKS INTERNATIONAL AIRPORT","AK",26411,"PAFA","FAI",64.81,
     &  -147.85,"19971201","YES","NWS",33.00,10.05)
      ASOSCommDates(15) = ASOSDATA("GULKANA","GULKANA AIRPORT","AK",
     &  26425,"PAGK","GKN",62.16,-145.45,"19991119","YES","FAA",33.00,
     &  10.05)
      ASOSCommDates(16) = ASOSDATA("HAINES","HAINES AIRPORT","AK",25323,
     &  "PAHN","HNS",59.24,-135.52,"19980605","NO","FAA",33.00,10.05)
      ASOSCommDates(17) = ASOSDATA("HOMER","HOMER AIRPORT","AK",25507,
     &  "PAHO","HOM",59.64,-151.47,"19971201","YES","NWS",26.00,7.92)
      ASOSCommDates(18) = ASOSDATA("ILIAMNA","ILIAMNA AIRPORT","AK",
     &  25506,"PAIL","ILI",59.75,-154.91,"19971201","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(19) = ASOSDATA("JUNEAU",
     &  "JUNEAU INTERNATIONAL AIRPORT","AK",25309,"PAJN","JNU",58.35,
     &  -134.57,"19980301","YES","FAA",33.00,10.05)
      ASOSCommDates(20) = ASOSDATA("KALTAG","KALTAG AIRPORT","AK",26502,
     &  "PAKV","KAL",64.32,-158.74,"19980707","NO","FAA",26.00,7.92)
      ASOSCommDates(21) = ASOSDATA("KALWOCK","KALWOCK AIRPORT","AK",
     &  25367,"PAKW","AKW",55.58,-133.07,"19970401","NO","FAA",26.00,
     &  7.92)
      ASOSCommDates(22) = ASOSDATA("KENAI","KENAI MUNICIPAL AIRPORT",
     &  "AK",26523,"PAEN","ENA",60.57,-151.23,"19990510","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(23) = ASOSDATA("KETCHIKAN",
     &  "KETCHIKAN INTERNATIONAL AIRPORT","AK",25325,"PAKT","KTN",55.35,
     &  -131.71,"19961209","NO","FAA",26.00,7.92)
      ASOSCommDates(24) = ASOSDATA("KING SALMON","KING SALMON AIRPORT",
     &  "AK",25503,"PAKN","AKN",58.68,-156.65,"19980601","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(25) = ASOSDATA("KIVALINA","KIVALINA AIRPORT","AK",
     &  26642,"PAVL","KVL",67.73,-164.54,"19980707","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(26) = ASOSDATA("KODIAK","KODIAK AIRPORT","AK",25501,
     &  "PADQ","ADQ",57.75,-152.49,"19970101","YES","NWS",33.00,10.05)
      ASOSCommDates(27) = ASOSDATA("KOTZEBUE",
     &  "RALPH WIEN MEMORIAL AIRPORT","AK",26616,"PAOT","OTZ",66.88,
     &  -162.59,"19971201","YES","NWS",26.00,7.92)
      ASOSCommDates(28) = ASOSDATA("MC GRATH","MC GRATH AIRPORT","AK",
     &  26510,"PAMC","MCG",62.95,-155.6,"19980701","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(29) = ASOSDATA("NENANA","NENANA MUNICIPAL AIRPORT",
     &  "AK",26435,"PANN","ENN",64.55,-149.07,"19980101","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(30) = ASOSDATA("NOME","NOME AIRPORT","AK",26617,
     &  "PAOM","OME",64.51,-165.44,"19980701","YES","NWS",26.00,7.92)
      ASOSCommDates(31) = ASOSDATA("NORTHWAY","NORTHWAY AIRPORT","AK",
     &  26412,"PAOR","ORT",62.96,-141.94,"20000320","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(32) = ASOSDATA("NUIQSUT","NUIQSUT AIRPORT","AK",
     &  27515,"PAQT","AQT",70.21,-151.,"19980723","NO","FAA",26.00,7.92)
      ASOSCommDates(33) = ASOSDATA("PALMER","PALMER MUNICIPAL AIRPORT",
     &  "AK",25331,"PAAQ","PAQ",61.59,-149.09,"19970915","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(34) = ASOSDATA("PORTAGE GLACIER","PORTAGE GLACIER",
     &  "AK",26492,"PATO","POR",60.78,-148.83,"19981015","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(35) = ASOSDATA("SELDOVIA","SELDOVIA AIRPORT","AK",
     &  25516,"PASO","SOV",59.44,-151.7,"19970502","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(36) = ASOSDATA("SEWARD","SEWARD AIRPORT","AK",26438,
     &  "PAWD","SWD",60.12,-149.41,"19970401","NO","FAA",26.00,7.92)
      ASOSCommDates(37) = ASOSDATA("SITKA",
     &  "SITKA ROCKY GUTIERREZ AIRPORT","AK",25333,"PASI","SIT",57.04,
     &  -135.36,"19961201","NO","FAA",26.00,7.92)
      ASOSCommDates(38) = ASOSDATA("SKAGWAY","SKAGWAY AIRPORT","AK",
     &  25335,"PAGY","SGY",59.46,-135.31,"19960822","NO","FAA",26.00,
     &  7.92)
      ASOSCommDates(39) = ASOSDATA("ST PAUL ISLAND",
     &  "ST PAUL ISLAND AIRPORT","AK",25713,"PASN","SNP",57.16,-170.22,
     &  "19970101","YES","NWS",33.00,10.05)
      ASOSCommDates(40) = ASOSDATA("ST. GEORGE ISLAND",
     &  "ST GEORGE AIRPORT","AK",25628,"PAPB","A8L",56.6,-169.56,
     &  "19960918","NO","FAA",-9.,-9.)
      ASOSCommDates(41) = ASOSDATA("TALKEETNA","TALKEETNA AIRPORT","AK",
     &  26528,"PATK","TKA",62.32,-150.09,"19980101","YES","NWS",26.00,
     &  7.92)
      ASOSCommDates(42) = ASOSDATA("TANANA",
     &  "RALPH M CALHOUN MEMORIAL AIRPORT","AK",26529,"PATA","TAL",
     &  65.17,-152.1,"19991119","NO","FAA",33.00,10.05)
      ASOSCommDates(43) = ASOSDATA("WAINWRIGHT",
     &  "WAINWRIGHT AIRPORT (NOTE SITE ID IS 5WW)","AK",27503,"PAWI",
     &  "AWI",70.63,-159.99,"19980915","NO","FAA",26.00,7.92)
      ASOSCommDates(44) = ASOSDATA("YAKUTAT","YAKUTAT AIRPORT","AK",
     &  25339,"PAYA","YAK",59.51,-139.62,"19971101","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(45) = ASOSDATA("ALABASTER","SHELBY COUNTY AIRPORT",
     &  "AL",53864,"KEET","EET",33.17,-86.78,"19980617","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(46) = ASOSDATA("ANNISTON",
     &  "ANNISTON METROPOLITAN AIRPORT","AL",13871,"KANB","ANB",33.58,
     &  -85.85,"19980617","NO","FAA",26.00,7.92)
      ASOSCommDates(47) = ASOSDATA("BIRMINGHAM",
     &  "BIRMINGHAM INTERNATIONAL AIRPORT","AL",13876,"KBHM","BHM",
     &  33.56,-86.75,"19980925","YES","FAA",33.00,10.05)
      ASOSCommDates(48) = ASOSDATA("DECATUR",
     &  "PRYOR FIELD REGIONAL AIRPORT","AL",53852,"KDCU","DCU",34.65,
     &  -86.94,"19961023","NO","FAA",33.00,10.05)
      ASOSCommDates(49) = ASOSDATA("DOTHAN","DOTHAN REGIONAL AIRPORT",
     &  "AL",13839,"KDHN","DHN",31.32,-85.44,"20010627","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(50) = ASOSDATA("EVERGREEN",
     &  "MIDDLETON FIELD AIRPORT","AL",53820,"KGZH","GZH",31.41,-87.04,
     &  "19970331","NO","FAA",33.00,10.05)
      ASOSCommDates(51) = ASOSDATA("HUNTSVILLE",
     &  "HUNTSVILLE INTERNATIONAL/CARL T. JONES FIELD ARPT","AL",3856,
     &  "KHSV","HSV",34.64,-86.78,"19940801","YES","NWS",33.00,10.05)
      ASOSCommDates(52) = ASOSDATA("MOBILE","MOBILE DOWNTOWN AIRPORT",
     &  "AL",13838,"KBFM","BFM",30.62,-88.06,"19960905","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(53) = ASOSDATA("MOBILE","MOBILE REGIONAL AIRPORT",
     &  "AL",13894,"KMOB","MOB",30.68,-88.24,"19960201","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(54) = ASOSDATA("MONTGOMERY",
     &  "MONTGOMERY REGIONAL (DANNELLY FIELD) AIRPORT","AL",13895,
     &  "KMGM","MGM",32.3,-86.39,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(55) = ASOSDATA("MUSCLE SHOALS",
     &  "NORTH WEST ALABAMA REGIONAL AIRPORT","AL",13896,"KMSL","MSL",
     &  34.74,-87.61,"19970408","NO","FAA",33.00,10.05)
      ASOSCommDates(56) = ASOSDATA("TROY","TROY MUNICIPAL AIRPORT","AL",
     &  3878,"KTOI","TOI",31.86,-86.01,"20001005","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(57) = ASOSDATA("TUSCALOOSA",
     &  "TUSCALOOSA MUNICIPAL AIRPORT","AL",93806,"KTCL","TCL",33.21,
     &  -87.61,"19990107","NO","FAA",33.00,10.05)
      ASOSCommDates(58) = ASOSDATA("BLYTHEVILLE",
     &  "BLYTHEVILLE MUNICIPAL AIRPORT","AR",53869,"KHKA","HKA",35.94,
     &  -89.83,"19981028","NO","FAA",33.00,10.05)
      ASOSCommDates(59) = ASOSDATA("De QUEEN",
     &  "J LYNN HELMS SEVIER COUNTY AIRPORT","AR",53925,"KDEQ","DEQ",
     &  34.04,-94.39,"20010712","NO","FAA",26.00,7.92)
      ASOSCommDates(60) = ASOSDATA("EL DORADO",
     &  "SOUTH ARKANSAS REGIONAL AT GOODWIN FIELD AIRPORT","AR",93992,
     &  "KELD","ELD",33.22,-92.81,"20001101","NO","FAA",33.00,10.05)
      ASOSCommDates(61) = ASOSDATA("FAYETTEVILLE","DRAKE FIELD AIRPORT",
     &  "AR",93993,"KFYV","FYV",36.,-94.17,"19970513","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(62) = ASOSDATA("FAYETTEVILLE/SPRINGDALE",
     &  "NORTHWEST ARKANSAS REGIONAL AIRPORT","AR",53922,"KXNA","XNA",
     &  36.28,-94.3,"19990428","NO","FAA",33.00,10.05)
      ASOSCommDates(63) = ASOSDATA("FORT SMITH",
     &  "FORT SMITH REGIONAL AIRPORT","AR",13964,"KFSM","FSM",35.33,
     &  -94.36,"19940801","YES","NWS",33.00,10.05)
      ASOSCommDates(64) = ASOSDATA("HARRISON","BOONE COUNTY AIRPORT",
     &  "AR",13971,"KHRO","HRO",36.26,-93.15,"20000913","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(65) = ASOSDATA("HOT SPRINGS",
     &  "MEMORIAL FIELD AIRPORT","AR",3962,"KHOT","HOT",34.47,-93.09,
     &  "20001220","NO","FAA",26.00,7.92)
      ASOSCommDates(66) = ASOSDATA("JONESBORO",
     &  "JONESBORO MUNICIPAL AIRPORT","AR",3953,"KJBR","JBR",35.83,
     &  -90.64,"19981028","NO","FAA",33.00,10.05)
      ASOSCommDates(67) = ASOSDATA("LITTLE ROCK","ADAMS FIELD AIRPORT",
     &  "AR",13963,"KLIT","LIT",34.74,-92.23,"19981028","YES","FAA",
     &  33.00,10.05)
      ASOSCommDates(68) = ASOSDATA("MONTICELLO",
     &  "MONTICELLO MUNICIPAL/ELLIS FIELD AIRPORT","AR",53919,"KLLQ",
     &  "LLQ",33.63,-91.75,"19981022","NO","FAA",33.00,10.05)
      ASOSCommDates(69) = ASOSDATA("MOUNT IDA","MOUNT IDA","AR",53921,
     &  "KMWT","MWT",34.54,-93.57,"19990301","NO","NWS",33.00,10.05)
      ASOSCommDates(70) = ASOSDATA("MOUNTAIN HOME",
     &  "OCARK REGIONAL AIRPORT","AR",53918,"KBPK","BPK",36.36,-92.47,
     &  "19981022","NO","FAA",26.00,7.92)
      ASOSCommDates(71) = ASOSDATA("PINE BLUFF","GRIDER FIELD AIRPORT",
     &  "AR",93988,"KPBF","PBF",34.17,-91.93,"20000926","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(72) = ASOSDATA("RUSSELLVILLE",
     &  "RUSSELLVILLE REGIONAL AIRPORT","AR",53920,"KRUE","RUE",35.25,
     &  -93.09,"19990112","NO","FAA",33.00,10.05)
      ASOSCommDates(73) = ASOSDATA("TEXARKANA",
     &  "TEXARKANA REGIONAL AIRPORT-WEBB FIELD","AR",13977,"KTXK","TXK",
     &  33.45,-94.,"19960712","NO","FAA",26.00,7.92)
      ASOSCommDates(74) = ASOSDATA("WEST MEMPHIS",
     &  "WEST MEMPHIS MUNICIPAL AIRPORT","AR",53959,"KAWM","AWM",35.13,
     &  -90.23,"20030115","NO","FAA",33.00,10.05)
      ASOSCommDates(75) = ASOSDATA("DOUGLAS BISBEE",
     &  "BISBEE DOUGLAS INTERNATIONAL AIRPORT","AZ",93026,"KDUG","DUG",
     &  31.46,-109.6,"20000927","NO","FAA",33.00,10.05)
      ASOSCommDates(76) = ASOSDATA("FLAGSTAFF",
     &  "FLAGSTAGG PULLIAM AIRPORT","AZ",3103,"KFLG","FLG",35.14,
     &  -111.67,"19940701","YES","NWS",33.00,10.05)
      ASOSCommDates(77) = ASOSDATA("GRAND CANYON",
     &  "GRAND CANYON NATIONAL PARK AIRPORT ","AZ",3195,"KGCN","GCN",
     &  35.94,-112.15,"19931201","NO","FAA",33.00,10.05)
      ASOSCommDates(78) = ASOSDATA("KINGMAN","KINGMAN AIRPORT","AZ",
     &  93167,"KIGM","IGM",35.25,-113.93,"19950901","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(79) = ASOSDATA("NOGALES",
     &  "NOGALES INTERNATIONAL AIRPORT","AZ",3196,"KOLS","OLS",31.42,
     &  -110.84,"19990728","NO","FAA",33.00,10.05)
      ASOSCommDates(80) = ASOSDATA("PAGE","PAGE MUNICIPAL AIRPORT","AZ",
     &  3162,"KPGA","PGA",36.92,-111.44,"19970328","NO","NWS",
     &  26.00,7.92)
      ASOSCommDates(81) = ASOSDATA("PHOENIX",
     &  "PHOENIX DEER VALLEY AIRPORT","AZ",3184,"KDVT","DVT",33.68,
     &  -112.08,"19980902","NO","FAA",33.00,10.05)
      ASOSCommDates(82) = ASOSDATA("PHOENIX",
     &  "PHOENIX SKY HARBOR INTERNATIONAL AIRPORT","AZ",23183,"KPHX",
     &  "PHX",33.44,-111.99,"19940301","YES","NWS",33.00,10.05)
      ASOSCommDates(83) = ASOSDATA("PRESCOTT",
     &  "ERNEST A.LOVE FIELD AIRPORT","AZ",23184,"KPRC","PRC",34.65,
     &  -112.42,"19990203","NO","FAA",33.00,10.05)
      ASOSCommDates(84) = ASOSDATA("SAFFORD","SAFFORD REGIONAL AIRPORT",
     &  "AZ",93084,"KSAD","SAD",32.85,-109.63,"19970903","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(85) = ASOSDATA("SCOTTSDALE","SCOTTSDALE AIRPORT",
     &  "AZ",3192,"KSDL","SDL",33.62,-111.91,"20011030","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(86) = ASOSDATA("ST. JOHNS",
     &  "ST.JOHNS INDUSTRIAL AIR PARK AIRPORT","AZ",93027,"KSJN","SJN",
     &  34.51,-109.37,"19990526","NO","FAA",33.00,10.05)
      ASOSCommDates(87) = ASOSDATA("TUCSON",
     &  "TUCSON INTERNATIONAL AIRPORT","AZ",23160,"KTUS","TUS",32.13,
     &  -110.95,"19960101","YES","NWS",33.00,10.05)
      ASOSCommDates(88) = ASOSDATA("WINDOW ROCK","WINDOW ROCK AIRPORT",
     &  "AZ",3029,"KRQE","RQE",35.65,-109.06,"19980818","NO","NWS",
     &  26.00,7.92)
      ASOSCommDates(89) = ASOSDATA("WINSLOW",
     &  "WINSLOW-LINDBERGH REGIONAL AIRPORT","AZ",23194,"KINW","INW",
     &  35.02,-110.72,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(90) = ASOSDATA("ALTURAS",
     &  "ALTURAS MUNICIPAL AIRPORT","CA",94299,"KAAT","AAT",41.48,
     &  -120.56,"19980601","NO","NWS",33.00,10.05)
      ASOSCommDates(91) = ASOSDATA("ARCATA/EUREKA","ARCATA AIRPORT",
     &  "CA",24283,"KACV","ACV",40.97,-124.1,"20010208","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(92) = ASOSDATA("AVALON","CATALINA AIRPORT","CA",
     &  23191,"KAVX","AVX",33.4,-118.41,"20000607","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(93) = ASOSDATA("BAKERSFIELD",
     &  "MEADOWS FIELD AIRPORT","CA",23155,"KBFL","BFL",35.43,-119.05,
     &  "19960601","YES","NWS",33.00,10.05)
      ASOSCommDates(94) = ASOSDATA("BISHOP","BISHOP AIRPORT","CA",23157,
     &  "KBIH","BIH",37.37,-118.36,"19940501","YES","NWS",33.00,10.05)
      ASOSCommDates(95) = ASOSDATA("BLYTHE","BLYTHE AIRPORT","CA",23158,
     &  "KBLH","BLH",33.61,-114.71,"20000830","NO","FAA",33.00,10.05)
      ASOSCommDates(96) = ASOSDATA("BURBANK",
     &  "BURBANK-GLENDALE-PASADENA AIRPORT","CA",23152,"KBUR","BUR",
     &  34.2,-118.35,"19980522","NO","FAA",26.00,7.92)
      ASOSCommDates(97) = ASOSDATA("CAMARILLO","CAMARILLO AIRPORT","CA",
     &  23136,"KCMA","CMA",34.21,-119.08,"19990929","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(98) = ASOSDATA("CAMPO","CAMPO","CA",3164,"KCZZ",
     &  "CZZ",32.61,-116.46,"19970826","NO","NWS",33.00,10.05)
      ASOSCommDates(99) = ASOSDATA("CARLSBAD",
     &  "McCLELLAN-PALOMAR AIRPORT","CA",3177,"KCRQ","CRQ",33.12,
     &  -117.27,"19980218","NO","FAA",26.00,7.92)
      ASOSCommDates(100) = ASOSDATA("CHINO","CHINO AIRPORT","CA",3179,
     &  "KCNO","CNO",33.97,-117.63,"19980521","NO","FAA",26.00,7.92)
      ASOSCommDates(101) = ASOSDATA("CONCORD","BUCHANAN FIELD AIRPORT",
     &  "CA",23254,"KCCR","CCR",37.99,-122.05,"19990608","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(102) = ASOSDATA("CRESCENT CITY",
     &  "JACK McNAMARA FIELD AIRPORT","CA",24286,"KCEC","CEC",41.78,
     &  -124.23,"20000913","NO","FAA",26.00,7.92)
      ASOSCommDates(103) = ASOSDATA("DAGGETT","BARSTOW-DAGGETT AIRPORT",
     &  "CA",23161,"KDAG","DAG",34.85,-116.78,"20000823","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(104) = ASOSDATA("EMIGRANT GAP",
     &  "BLUE CANYON - NYACK AIRPORT","CA",23225,"KBLU","BLU",39.29,
     &  -120.7,"19930201","NO","NWS",26.00,7.92)
      ASOSCommDates(105) = ASOSDATA("FRESNO",
     &  "FRESNO YOSEMITE INTERNATIONAL AIRPORT","CA",93193,"KFAT","FAT",
     &  36.78,-119.71,"19950901","YES","NWS",26.00,7.92)
      ASOSCommDates(106) = ASOSDATA("FULLERTON",
     &  "FULLERTON MUNICIPAL AIRPORT","CA",3166,"KFUL","FUL",33.87,
     &  -117.97,"19980701","NO","FAA",33.00,10.05)
      ASOSCommDates(107) = ASOSDATA("HANFORD",
     &  "HANFORD MUNICIPAL AIRPORT","CA",53119,"KHJO","HJO",36.31,
     &  -119.62,"19980219","NO","FAA",33.00,10.05)
      ASOSCommDates(108) = ASOSDATA("HAWTHORNE",
     &  "JACK NORTHROP FIELD/HAWTHORNE MUNICIPAL AIRPORT","CA",3167,
     &  "KHHR","HHR",33.92,-118.33,"19981110","NO","FAA",26.00,7.92)
      ASOSCommDates(109) = ASOSDATA("HAYWARD",
     &  "HAYWARD EXECUTIVE AIRPORT","CA",93228,"KHWD","HWD",37.65,
     &  -122.12,"19980923","NO","FAA",33.00,10.05)
      ASOSCommDates(110) = ASOSDATA("IMPERIAL",
     &  "IMPERIAL COUNTY AIRPORT","CA",3144,"KIPL","IPL",32.83,-115.57,
     &  "20000816","NO","FAA",33.00,10.05)
      ASOSCommDates(111) = ASOSDATA("LANCASTER",
     &  "GENERAL WILLIAM J. FOX AIRFIELD AIRPORT","CA",3159,"KWJF",
     &  "WJF",34.74,-118.21,"20001213","NO","FAA",33.00,10.05)
      ASOSCommDates(112) = ASOSDATA("LIVERMORE",
     &  "LIVERMORE MUNICIPAL AIRPORT","CA",23285,"KLVK","LVK",37.69,
     &  -121.81,"19980331","NO","FAA",26.00,7.92)
      ASOSCommDates(113) = ASOSDATA("LONG BEACH",
     &  "LONG BEACH/DAUGHERTY FIELD AIRPORT","CA",23129,"KLGB","LGB",
     &  33.82,-118.16,"19960901","YES","NWS",26.00,7.92)
      ASOSCommDates(114) = ASOSDATA("LOS ANGELES",
     &  "DOWNTOWN LOS ANGELES/USC CAMPUS","CA",93134,"KCQT","CQT",34.02,
     &  -118.29,"19990624","YES","NWS",19.00,5.79)
      ASOSCommDates(115) = ASOSDATA("LOS ANGELES",
     &  "LOS ANGELES INTERNATIONAL AIRPORT","CA",23174,"KLAX","LAX",
     &  33.93,-118.4,"19970301","YES","NWS",33.00,10.05)
      ASOSCommDates(116) = ASOSDATA("MADERA","MADERA MUNICIPAL AIRPORT",
     &  "CA",93242,"KMAE","MAE",36.98,-120.11,"19980902","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(117) = ASOSDATA("MARYSVILLE","YUBA COUNTY AIRPORT",
     &  "CA",93205,"KMYV","MYV",39.09,-121.56,"20001004","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(118) = ASOSDATA("MERCED",
     &  "MERCED MUNICIPAL/MACREADY FIELD AIRPORT","CA",23257,"KMCE",
     &  "MCE",37.28,-120.51,"19980806","NO","FAA",26.00,7.92)
      ASOSCommDates(119) = ASOSDATA("MODESTO",
     &  "MODESTO CITY COUNTY HARRY SHAM FIELD AIRPORT","CA",23258,
     &  "KMOD","MOD",37.62,-120.95,"19980513","NO","FAA",26.00,7.92)
      ASOSCommDates(120) = ASOSDATA("MOUNTAIN VIEW",
     &  "MOFFETT FEDERAL AIRFIELD","CA",23244,"KNUQ","NUQ",37.41,
     &  -122.04,"19960526","NO","NWS",-9.,-9.)
      ASOSCommDates(121) = ASOSDATA("MONTAGUE",
     &  "SISKIYOU COUNTY AIRPORT","CA",24259,"KSIY","SIY",41.78,-122.46,
     &  "20010110","NO","FAA",33.00,10.05)
      ASOSCommDates(122) = ASOSDATA("MONTEREY",
     &  "MONTEREY PENINSULA AIRPORT","CA",23259,"KMRY","MRY",36.58,
     &  -121.84,"19980325","NO","FAA",26.00,7.92)
      ASOSCommDates(123) = ASOSDATA("MOUNT SHASTA","MOUNT SHASTA","CA",
     &  24215,"KMHS","MHS",41.33,-122.33,"19960801","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(124) = ASOSDATA("NAPA","NAPA COUNTY AIRPORT","CA",
     &  93227,"KAPC","APC",38.21,-122.27,"19980522","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(125) = ASOSDATA("NEEDLES","NEEDLES AIRPORT","CA",
     &  23179,"KEED","EED",34.76,-114.62,"20010124","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(126) = ASOSDATA("OAKLAND",
     &  "METROPOLITAN OAKLAND INTERNATIONAL AIRPORT","CA",23230,"KOAK",
     &  "OAK",37.75,-122.22,"20000112","NO","FAA",33.00,10.05)
      ASOSCommDates(127) = ASOSDATA("OCEANSIDE",
     &  "OCEANSIDE MUNICIPAL AIRPORT","CA",53121,"KOKB","OKB",33.21,
     &  -117.34,"19990512","NO","FAA",33.00,10.05)
      ASOSCommDates(128) = ASOSDATA("ONTARIO",
     &  "ONTARIO INTERNATIONAL AIRPORT","CA",3102,"KONT","ONT",34.05,
     &  -117.6,"19980527","NO","FAA",26.00,7.92)
      ASOSCommDates(129) = ASOSDATA("OROVILLE",
     &  "OROVILLE MUNICIPAL AIRPORT","CA",93210,"KOVE","OVE",39.49,
     &  -121.61,"19980617","NO","FAA",33.00,10.05)
      ASOSCommDates(130) = ASOSDATA("OXNARD","OXNARD AIRPORT","CA",
     &  93110,"KOXR","OXR",34.2,-119.2,"19980304","NO","FAA",26.00,7.92)
      ASOSCommDates(131) = ASOSDATA("PALM SPRINGS",
     &  "PALM SPRINGS INTERNATIONAL AIRPORT","CA",93138,"KPSP","PSP",
     &  33.82,-116.5,"19980218","NO","FAA",33.00,10.05)
      ASOSCommDates(132) = ASOSDATA("PALM SPRINGS",
     &  "DESERT RESORTS REGIONAL AIRPORT","CA",3104,"KTRM","TRM",33.62,
     &  -116.16,"20001011","NO","FAA",33.00,10.05)
      ASOSCommDates(133) = ASOSDATA("PALMDALE",
     &  "PALMDALE PRODUCTION FLIGHT/TEST INSTLN AF PLANT APT","CA",
     &  23182,"KPMD","PMD",34.62,-118.08,"19980408","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(134) = ASOSDATA("PASO ROBLES",
     &  "PASO ROBLES MUNICIPAL AIRPORT","CA",93209,"KPRB","PRB",35.67,
     &  -120.62,"20010118","NO","FAA",33.00,10.05)
      ASOSCommDates(135) = ASOSDATA("RAMONA","RAMONA AIRPORT","CA",
     &  53120,"KRNM","RNM",33.03,-116.91,"19980416","NO","NWS",26.00,
     &  7.92)
      ASOSCommDates(136) = ASOSDATA("RED BLUFF",
     &  "RED BLUFF MUNICIPAL AIRPORT","CA",24216,"KRBL","RBL",40.15,
     &  -122.25,"19951001","NO","NWS",33.00,10.05)
      ASOSCommDates(137) = ASOSDATA("REDDING",
     &  "REDDING MUNICIPAL AIRPORT","CA",24257,"KRDD","RDD",40.51,
     &  -122.31,"19960701","YES","NWS",33.00,10.05)
      ASOSCommDates(138) = ASOSDATA("RIVERSIDE",
     &  "RIVERSIDE MUNICIPAL AIRPORT","CA",3171,"KRAL","RAL",33.95,
     &  -117.43,"19980723","NO","FAA",33.00,10.05)
      ASOSCommDates(139) = ASOSDATA("SACRAMENTO",
     &  "SACRAMENTO EXECUTIVE AIRPORT","CA",23232,"KSAC","SAC",38.51,
     &  -121.49,"19980415","YES","FAA",33.00,10.05)
      ASOSCommDates(140) = ASOSDATA("SACRAMENTO",
     &  "SACRAMENTO INTERNATIONAL AIRPORT","CA",93225,"KSMF","SMF",
     &  38.69,-121.58,"19980521","NO","FAA",33.00,10.05)
      ASOSCommDates(141) = ASOSDATA("SALINAS",
     &  "SALINAS MUNICIPAL AIRPORT","CA",23233,"KSNS","SNS",36.66,
     &  -121.6,"19980909","NO","FAA",33.00,10.05)
      ASOSCommDates(142) = ASOSDATA("SAN DIEGO",
     &  "MONTGOMERY FIELD AIRPORT","CA",3131,"KMYF","MYF",32.81,-117.13,
     &  "19980218","NO","FAA",26.00,7.92)
      ASOSCommDates(143) = ASOSDATA("SAN DIEGO",
     &  "SAN DIEGO INTERNATIONAL-LINDBERGH FIELD AIRPORT","CA",23188,
     &  "KSAN","SAN",32.73,-117.16,"19960801","YES","NWS",33.00,10.05)
      ASOSCommDates(144) = ASOSDATA("SAN DIEGO",
     &  "BROWN FIELD MUNICIPAL AIRPORT","CA",3178,"KSDM","SDM",32.57,
     &  -116.97,"19970201","NO","NWS",33.00,10.05)
      ASOSCommDates(145) = ASOSDATA("SAN FRANCISCO",
     &  "SAN FRANCISCO INTERNATIONAL AIRPORT","CA",23234,"KSFO","SFO",
     &  37.61,-122.39,"19961001","YES","NWS",33.00,10.05)
      ASOSCommDates(146) = ASOSDATA("SAN JOSE",
     &  "NORMAN Y. MINETA SAN JOSE INTERNATIONAL AIRPORT","CA",23293,
     &  "KSJC","SJC",37.36,-121.92,"19980708","NO","FAA",26.00,7.92)
      ASOSCommDates(147) = ASOSDATA("SAN LUIS OBISPO",
     &  "SAN LUIS COUNTY REGIONAL AIRPORT","CA",93206,"KSBP","SBP",
     &  35.23,-120.64,"19980401","NO","FAA",33.00,10.05)
      ASOSCommDates(148) = ASOSDATA("SANDBERG","SANDBERG","CA",23187,
     &  "KSDB","SDB",34.74,-118.72,"19960401","NO","NWS",33.00,10.05)
      ASOSCommDates(149) = ASOSDATA("SANTA ANA",
     &  "J.WAYNE AIRPORT-ORANGE COUNTY AIRPORT","CA",93184,"KSNA","SNA",
     &  33.68,-117.86,"19990217","NO","FAA",19.00,5.79)
      ASOSCommDates(150) = ASOSDATA("SANTA BARBARA",
     &  "SANTA BARBARA MUNICIPAL AIRPORT","CA",23190,"KSBA","SBA",34.42,
     &  -119.84,"19980304","NO","FAA",26.00,7.92)
      ASOSCommDates(151) = ASOSDATA("SANTA MARIA",
     &  "SANTA MARIA PUBLIC/CAPT G ALLEN HANCOCK FLD AIRPORT","CA",
     &  23273,"KSMX","SMX",34.91,-120.46,"19960801","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(152) = ASOSDATA("SANTA MONICA",
     &  "SANTA MONICA MUNICIPAL AIRPORT","CA",93197,"KSMO","SMO",34.01,
     &  -118.45,"20001005","NO","FAA",33.00,10.05)
      ASOSCommDates(153) = ASOSDATA("SANTA ROSA",
     &  "SONOMA COUNTY AIRPORT","CA",23213,"KSTS","STS",38.5,-122.81,
     &  "19980603","NO","FAA",33.00,10.05)
      ASOSCommDates(154) = ASOSDATA("SOUTH LAKE TAHOE",
     &  "LAKE TAHOE AIRPORT","CA",93230,"KTVL","TVL",38.89,-119.99,
     &  "20001018","NO","FAA",33.00,10.05)
      ASOSCommDates(155) = ASOSDATA("STOCKTON",
     &  "STOCKTON METROPOLITAN AIRPORT","CA",23237,"KSCK","SCK",37.89,
     &  -121.23,"19961101","YES","NWS",33.00,10.05)
      ASOSCommDates(156) = ASOSDATA("UKIAH","UKIAH MUNICIPAL AIRPORT",
     &  "CA",23275,"KUKI","UKI",39.12,-123.2,"20010125","NO","FAA",
     &  19.00,5.79)
      ASOSCommDates(157) = ASOSDATA("VACAVILLE","NUT TREE AIRPORT","CA",
     &  93241,"KVCB","VCB",38.37,-121.96,"19980331","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(158) = ASOSDATA("VAN NUYS","VAN NUYS AIRPORT","CA",
     &  23130,"KVNY","VNY",34.2,-118.48,"19980526","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(159) = ASOSDATA("WATSONVILLE",
     &  "WATSONVILLE MUNICIPAL AIRPORT","CA",23277,"KWVI","WVI",36.93,
     &  -121.78,"19980723","NO","FAA",33.00,10.05)
      ASOSCommDates(160) = ASOSDATA("AKRON",
     &  "COLORADO PLAINS REGIONAL AIRPORT","CO",24015,"KAKO","AKO",
     &  40.17,-103.23,"19960206","NO","FAA",33.00,10.05)
      ASOSCommDates(161) = ASOSDATA("ALAMOSA",
     &  "SAN LUIS VALLEY REGIONAL AIRPORT","CO",23061,"KALS","ALS",
     &  37.43,-105.86,"19920901","YES","NWS",33.00,10.05)
      ASOSCommDates(162) = ASOSDATA("ASPEN",
     &  "ASPEN-PITKIN COUNTY AIRPORT","CO",93073,"KASE","ASE",39.22,
     &  -106.86,"19980521","NO","FAA",26.00,7.92)
      ASOSCommDates(163) = ASOSDATA("BURLINGTON",
     &  "KIT CARSON COUNTY AIRPORT","CO",3026,"KITR","ITR",39.24,
     &  -102.28,"19970410","NO","FAA",33.00,10.05)
      ASOSCommDates(164) = ASOSDATA("COLORADO SPRINGS",
     &  "CITY OF COLORADO SPRINGS MUNICIPAL AIRPORT","CO",93037,"KCOS",
     &  "COS",38.81,-104.71,"19921101","YES","NWS",33.00,10.05)
      ASOSCommDates(165) = ASOSDATA("CORTEZ","CORTEZ MUNICIPAL AIRPORT",
     &  "CO",93069,"KCEZ","CEZ",37.3,-108.62,"19960523","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(166) = ASOSDATA("CRAIG","CRAIG-MOFFAT AIRPORT","CO",
     &  24046,"KCAG","CAG",40.49,-107.52,"19960815","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(167) = ASOSDATA("DENVER","CENTENNIAL AIRPORT","CO",
     &  93067,"KAPA","APA",39.57,-104.84,"19980629","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(168) = ASOSDATA("DENVER",
     &  "DENVER INTERNATIONAL AIRPORT","CO",3017,"KDEN","DEN",39.83,
     &  -104.65,"19950301","YES","NWS",33.00,10.05)
      ASOSCommDates(169) = ASOSDATA("DURANGO",
     &  "DURANGO LA PLATA COUNTY AIRPORT","CO",93005,"KDRO","DRO",37.14,
     &  -107.75,"19960523","NO","FAA",33.00,10.05)
      ASOSCommDates(170) = ASOSDATA("GRAND JUNCTION",
     &  "WALKER FIELD AIRPORT","CO",23066,"KGJT","GJT",39.13,-108.53,
     &  "19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(171) = ASOSDATA("LA JUNTA",
     &  "LA JUNTA MUNICIPAL AIRPORT","CO",23067,"KLHX","LHX",38.05,
     &  -103.52,"19960206","NO","FAA",33.00,10.05)
      ASOSCommDates(172) = ASOSDATA("LAMAR","LAMAR MUNICIPAL AIRPORT",
     &  "CO",3013,"KLAA","LAA",38.07,-102.68,"19950517","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(173) = ASOSDATA("LEADVILLE",
     &  "LEADVILLE/LAKE COUNTY AIRPORT","CO",93009,"KLXV","LXV",39.22,
     &  -106.31,"19980730","NO","NWS",33.00,10.05)
      ASOSCommDates(174) = ASOSDATA("LIMON","LIMON MUNICIPAL AIRPORT",
     &  "CO",93010,"KLIC","LIC",39.18,-103.71,"19951214","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(175) = ASOSDATA("MEEKER","MEEKER AIRPORT","CO",
     &  94050,"KEEO","EEO",40.04,-107.88,"19970227","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(176) = ASOSDATA("MONTROSE",
     &  "MONTROSE REGIONAL AIRPORT","CO",93013,"KMTJ","MTJ",38.5,
     &  -107.89,"19931201","NO","FAA",33.00,10.05)
      ASOSCommDates(177) = ASOSDATA("PUEBLO","PUEBLO MEMORIAL AIRPORT",
     &  "CO",93058,"KPUB","PUB",38.29,-104.49,"19921001","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(178) = ASOSDATA("RIFLE",
     &  "GARFIELD COUNTY REGIONAL AIRPORT","CO",3016,"KRIL","RIL",39.52,
     &  -107.72,"19970227","NO","FAA",33.00,10.05)
      ASOSCommDates(179) = ASOSDATA("SPRINGFIELD","SPRINGFIELD AIRPORT",
     &  "CO",3028,"KSPD","SPD",37.28,-102.61,"19980625","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(180) = ASOSDATA("TRINIDAD","PERRY STOKES AIRPORT",
     &  "CO",23070,"KTAD","TAD",37.25,-104.34,"20010927","NO","FAA",-9,
     &  -9)
      ASOSCommDates(181) = ASOSDATA("BRIDGEPORT",
     &  "IGOR I SIKORSKY MEMORIAL AIRPORT","CT",94702,"KBDR","BDR",
     &  41.17,-73.14,"19960501","YES","NWS",26.00,7.92)
      ASOSCommDates(182) = ASOSDATA("DANBURY",
     &  "DANBURY MUNICIPAL AIRPORT","CT",54734,"KDXR","DXR",41.37,
     &  -73.48,"19980513","NO","FAA",26.00,7.92)
      ASOSCommDates(183) = ASOSDATA("GROTON NEW LONDON",
     &  "GROTON-NEW LONDON AIRPORT","CT",14707,"KGON","GON",41.32,
     &  -72.04,"19991208","NO","FAA",33.00,10.05)
      ASOSCommDates(184) = ASOSDATA("HARTFORD",
     &  "HARTFORD-BRAINARD AIRPORT","CT",14752,"KHFD","HFD",41.73,
     &  -72.65,"19970515","NO","FAA",33.00,10.05)
      ASOSCommDates(185) = ASOSDATA("MERIDEN",
     &  "MERIDEN MARKHAM MUNICIPAL AIRPORT","CT",54788,"KMMK","MMK",
     &  41.5,-72.82,"19990804","NO","FAA",33.00,10.05)
      ASOSCommDates(186) = ASOSDATA("NEW HAVEN",
     &  "TWEED-NEW HAVEN AIRPORT","CT",14758,"KHVN","HVN",41.26,-72.88,
     &  "20011114","NO","FAA",26.00,7.92)
      ASOSCommDates(187) = ASOSDATA("WILLIMANTIC","WINDHAM AIRPORT",
     &  "CT",54767,"KIJD","IJD",41.74,-72.18,"19950428","NO","FAA",4.00,
     &  1.21)
      ASOSCommDates(188) = ASOSDATA("WINDSOR LOCKS",
     &  "BRADLEY INTERNATIONAL AIRPORT","CT",14740,"KBDL","BDL",41.93,
     &  -72.68,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(189) = ASOSDATA("WASHINGTON",
     &  "RONALD REAGAN WASHINGTON NATIONAL AIRPORT","DC",13743,"KDCA",
     &  "DCA",38.86,-77.03,"19980201","YES","NWS",26.00,7.92)
      ASOSCommDates(190) = ASOSDATA("WASHINGTON ",
     &  "WASHINGTON DULLES INTERNATIONAL AIRPORT","DC",93738,"KIAD",
     &  "IAD",38.93,-77.44,"19960501","YES","NWS",33.00,10.05)
      ASOSCommDates(191) = ASOSDATA("GEORGETOWN",
     &  "SUSSEX COUNTY AIRPORT","DE",13764,"KGED","GED",38.68,-75.35,
     &  "19971008","NO","FAA",33.00,10.05)
      ASOSCommDates(192) = ASOSDATA("WILMINGTON",
     &  "NEW CASTLE COUNTY AIRPORT","DE",13781,"KILG","ILG",39.67,-75.6,
     &  "19941001","YES","NWS",33.00,10.05)
      ASOSCommDates(193) = ASOSDATA("APALACHICOLA",
     &  "APALACHICOLA MUNICIPAL AIRPORT","FL",12832,"KAAF","AAF",29.73,
     &  -85.03,"19980731","NO","NWS",33.00,10.05)
      ASOSCommDates(194) = ASOSDATA("BROOKSVILLE",
     &  "HERNANDO COUNTY AIRPORT","FL",12818,"KBKV","BKV",28.47,-82.45,
     &  "19950524","NO","FAA",33.00,10.05)
      ASOSCommDates(195) = ASOSDATA("CRESTVIEW","BOB SIKES AIRPORT",
     &  "FL",13884,"KCEW","CEW",30.77,-86.52,"19970701","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(196) = ASOSDATA("CROSS CITY","CROSS CITY AIRPORT",
     &  "FL",12833,"KCTY","CTY",29.55,-83.1,"19980227","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(197) = ASOSDATA("DAYTONA BEACH",
     &  "DAYTONA BEACH INTERNATIONAL AIRPORT","FL",12834,"KDAB","DAB",
     &  29.17,-81.06,"19950601","YES","NWS",33.00,10.05)
      ASOSCommDates(198) = ASOSDATA("DESTIN",
     &  "DESTIN-FORT WALTON BEACH AIRPORT","FL",53853,"KDTS","DTS",30.4,
     &  -86.47,"19961106","NO","FAA",26.00,7.92)
      ASOSCommDates(199) = ASOSDATA("FORT LAUDERDALE",
     &  "FORT LAUDERDALE/HOLLYWOOD INTERNATIONAL AIRPORT","FL",12849,
     &  "KFLL","FLL",26.07,-80.15,"19980909","NO","FAA",33.00,10.05)
      ASOSCommDates(200) = ASOSDATA("FORT LAUDERDALE",
     &  "FORT LAUDERDALE EXECUTIVE AIRPORT","FL",12885,"KFXE","FXE",
     &  26.19,-80.17,"19980624","NO","FAA",33.00,10.05)
      ASOSCommDates(201) = ASOSDATA("FORT MYERS","PAGE FIELD AIRPORT",
     &  "FL",12835,"KFMY","FMY",26.58,-81.86,"19980610","YES","FAA",
     &  26.00,7.92)
      ASOSCommDates(202) = ASOSDATA("FORT MYERS",
     &  "SOUTHWEST FLORIDA INTERNATIONAL AIRPORT","FL",12894,"KRSW",
     &  "RSW",26.53,-81.75,"19980521","NO","FAA",33.00,10.05)
      ASOSCommDates(203) = ASOSDATA("FORT PIERCE",
     &  "ST LUCIE COUNTY INTERNATIONAL AIRPORT","FL",12895,"KFPR","FPR",
     &  27.49,-80.37,"19990728","NO","FAA",26.00,7.92)
      ASOSCommDates(204) = ASOSDATA("GAINESVILLE",
     &  "GAINESVILLE REGIONAL AIRPORT","FL",12816,"KGNV","GNV",29.68,
     &  -82.27,"19980812","YES","FAA",33.00,10.05)
      ASOSCommDates(205) = ASOSDATA("HOLLYWOOD","NORTH PERRY AIRPORT",
     &  "FL",92809,"KHWO","HWO",25.99,-80.24,"19990421","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(206) = ASOSDATA("JACKSONVILLE",
     &  "CRAIG MUNICIPAL AIRPORT ","FL",53860,"KCRG","CRG",30.33,-81.51,
     &  "19971125","NO","FAA",26.00,7.92)
      ASOSCommDates(207) = ASOSDATA("JACKSONVILLE",
     &  "JACKSONVILLE INTERNATIONAL AIRPORT","FL",13889,"KJAX","JAX",
     &  30.49,-81.69,"19960301","YES","NWS",33.00,10.05)
      ASOSCommDates(208) = ASOSDATA("KEY WEST",
     &  "KEY WEST INTERNATIONAL AIRPORT","FL",12836,"KEYW","EYW",24.55,
     &  -81.75,"19960301","YES","NWS",33.00,10.05)
      ASOSCommDates(209) = ASOSDATA("LEESBURG",
     &  "LEESBURG REGIONAL AIRPORT","FL",12819,"KLEE","LEE",28.82,-81.8,
     &  "19960807","NO","FAA",33.00,10.05)
      ASOSCommDates(210) = ASOSDATA("MARATHON",
     &  "THE FLORIDA KEYS MARATHON AIRPORT","FL",12896,"KMTH","MTH",
     &  24.72,-81.05,"19980514","NO","FAA",26.00,7.92)
      ASOSCommDates(211) = ASOSDATA("MARIANNA",
     &  "MARIANNA MUNICIPAL AIRPORT","FL",3818,"KMAI","MAI",30.83,
     &  -85.18,"19970415","NO","FAA",33.00,10.05)
      ASOSCommDates(212) = ASOSDATA("MELBOURNE",
     &  "MELBOURNE INTERNATIONAL AIRPORT","FL",12838,"KMLB","MLB",28.1,
     &  -80.64,"20010207","NO","FAA",33.00,10.05)
      ASOSCommDates(213) = ASOSDATA("MIAMI",
     &  "MIAMI INTERNATIONAL AIRPORT","FL",12839,"KMIA","MIA",25.82,
     &  -80.29,"19960701","YES","NWS",33.00,10.05)
      ASOSCommDates(214) = ASOSDATA("MIAMI","OPA LOCKA AIRPORT","FL",
     &  12882,"KOPF","OPF",25.9,-80.28,"19980521","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(215) = ASOSDATA("MIAMI",
     &  "KENDALL-TAMIAMI EXECUTIVE AIRPORT","FL",12888,"KTMB","TMB",
     &  25.64,-80.43,"19980617","NO","FAA",33.00,10.05)
      ASOSCommDates(216) = ASOSDATA("NAPLES","NAPLES MUNICIPAL AIRPORT",
     &  "FL",12897,"KAPF","APF",26.15,-81.77,"20020326","NO","FAA",
     &  -9.,-9.)
      ASOSCommDates(217) = ASOSDATA("ORLANDO",
     &  "ORLANDO INTERNATIONAL AIRPORT","FL",12815,"KMCO","MCO",28.43,
     &  -81.32,"19960701","YES","NWS",26.00,7.92)
      ASOSCommDates(218) = ASOSDATA("ORLANDO","EXECUTIVE AIRPORT","FL",
     &  12841,"KORL","ORL",28.54,-81.33,"19980610","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(219) = ASOSDATA("ORLANDO","ORLANDO SANFORD AIRPORT",
     &  "FL",12854,"KSFB","SFB",28.77,-81.24,"19990224","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(220) = ASOSDATA("PANAMA CITY",
     &  "PANAMA CITY-BAY COUNTY INTERNATIONAL AIRPORT","FL",3882,"KPFN",
     &  "PFN",30.21,-85.68,"19980716","NO","FAA",33.00,10.05)
      ASOSCommDates(221) = ASOSDATA("PENSACOLA",
     &  "PENSACOLA REGIONAL AIRPORT","FL",13899,"KPNS","PNS",30.47,
     &  -87.18,"19971201","YES","FAA",33.00,10.05)
      ASOSCommDates(222) = ASOSDATA("PERRY","PERRY-FOLEY AIRPORT","FL",
     &  53862,"K40J","40J",30.07,-83.57,"19980227","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(223) = ASOSDATA("POMPANO BEACH",
     &  "POMPANO BEACH AIRPARK AIRPORT","FL",92805,"KPMP","PMP",26.25,
     &  -80.1,"19980312","NO","FAA",33.00,10.05)
      ASOSCommDates(224) = ASOSDATA("PUNTA GORDA",
     &  "CHARLOTTE COUNTY AIRPORT","FL",12812,"KPGD","PGD",26.91,-81.99,
     &  "19960920","NO","FAA",33.00,10.05)
      ASOSCommDates(225) = ASOSDATA("SARASOTA/BRADENTON",
     &  "SARASOTA/BRADENTON INTERNATIONAL AIRPORT","FL",12871,"KSRQ",
     &  "SRQ",27.4,-82.55,"19990318","NO","FAA",33.00,10.05)
      ASOSCommDates(226) = ASOSDATA("ST PETERSBURG",
     &  "ALBERT WHITTED AIRPORT","FL",92806,"KSPG","SPG",27.76,-82.62,
     &  "19980617","NO","FAA",26.00,7.92)
      ASOSCommDates(227) = ASOSDATA("ST PETERSBURG/CLEARWATER",
     &  "ST PETERSBURG-CLEARWATER INTERNATIONAL AIRPORT","FL",12873,
     &  "KPIE","PIE",27.91,-82.68,"19980924","NO","FAA",33.00,10.05)
      ASOSCommDates(228) = ASOSDATA("TALLAHASSEE",
     &  "TALLAHASSEE REGIONAL AIRPORT","FL",93805,"KTLH","TLH",30.39,
     &  -84.35,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(229) = ASOSDATA("TAMPA",
     &  "TAMPA INTERNATIONAL AIRPORT","FL",12842,"KTPA","TPA",27.96,
     &  -82.54,"19951101","YES","NWS",26.00,7.92)
      ASOSCommDates(230) = ASOSDATA("VERO BEACH",
     &  "VERO BEACH MUNICIPAL AIRPORT","FL",12843,
     &  "KVRB","VRB",27.65,-80.41,"20010730","YES","FAA",33.00,10.05)
      ASOSCommDates(231) = ASOSDATA("WEST PALM BEACH",
     &  "PALM BEACH INTERNATIONAL AIRPORT","FL",12844,"KPBI","PBI",
     &  26.68,-80.09,"19930401","YES","NWS",33.00,10.05)
      ASOSCommDates(232) = ASOSDATA("WINTER HAVEN",
     &  "WINTER HAVEN'S GILBERT AIRPORT","FL",12876,"KGIF","GIF",28.06,
     &  -81.75,"19950701","NO","FAA",33.00,10.05)
      ASOSCommDates(233) = ASOSDATA("ALBANY",
     &  "SOUTHWEST GEORGIA REGIONAL AIRPORT","GA",13869,"KABY","ABY",
     &  31.53,-84.19,"20010117","NO","FAA",33.00,10.05)
      ASOSCommDates(234) = ASOSDATA("ALMA","BACON COUNTY AIRPORT","GA",
     &  13870,"KAMG","AMG",31.53,-82.5,"20001213","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(235) = ASOSDATA("ATHENS","ATHENS/BEN EPPS AIRPORT",
     &  "GA",13873,"KAHN","AHN",33.94,-83.32,"19960201","YES","NWS",
     &  26.00,7.92)
      ASOSCommDates(236) = ASOSDATA("ATLANTA",
     &  "HARTSFIELD-JACKSON ATLANTA INTERNATIONAL AIRPORT","GA",13874,
     &  "KATL","ATL",33.64,-84.42,"19950801","YES","NWS",33.00,10.05)
      ASOSCommDates(237) = ASOSDATA("ATLANTA",
     &  "PEACHTREE CITY-FALCON FIELD AIRPORT","GA",53819,"KFFC","FFC",
     &  33.35,-84.56,"19950927","NO","FAA",33.00,10.05)
      ASOSCommDates(238) = ASOSDATA("ATLANTA",
     &  "FULTON COUNTY AIRPORT-BROWN FIELD AIRPORT","GA",3888,"KFTY",
     &  "FTY",33.77,-84.52,"19981028","NO","FAA",26.00,7.92)
      ASOSCommDates(239) = ASOSDATA("ATLANTA",
     &  "DEKALB-PEACHTREE AIRPORT","GA",53863,"KPDK","PDK",33.87,-84.3,
     &  "19980318","NO","FAA",33.00,10.05)
      ASOSCommDates(240) = ASOSDATA("AUGUSTA",
     &  "AUGUSTA REGIONAL AT BUSH FIELD AIRPORT","GA",3820,"KAGS","AGS",
     &  33.36,-81.96,"19940501","YES","NWS",33.00,10.05)
      ASOSCommDates(241) = ASOSDATA("AUGUSTA","DANIEL FIELD AIRPORT",
     &  "GA",13837,"KDNL","DNL",33.46,-82.03,"19951205","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(242) = ASOSDATA("BRUNSWICK",
     &  "MALCOLM MC KINNON AIRPORT","GA",13878,"KSSI",
     &  "SSI",31.25,-81.39,"20001025","NO","FAA",33.00,10.05)
      ASOSCommDates(243) = ASOSDATA("CARTERSVILLE",
     &  "CARTERSVILLE AIRPORT","GA",53873,"KVPC","VPC",34.12,-84.84,
     &  "20000322","NO","FAA",33.00,10.05)
      ASOSCommDates(244) = ASOSDATA("COLUMBUS",
     &  "COLUMBUS METROPOLITAN AIRPORT","GA",93842,"KCSG","CSG",32.51,
     &  -84.94,"19940501","YES","NWS",33.00,10.05)
      ASOSCommDates(245) = ASOSDATA("GAINESVILLE",
     &  "LEE GILMER MEMORIAL AIRPORT","GA",53838,"KGVL","GVL",34.27,
     &  -83.83,"19951017","NO","FAA",26.00,7.92)
      ASOSCommDates(246) = ASOSDATA("MACON",
     &  "MIDDLE GEORGIA REGIONAL AIRPORT","GA",3813,"KMCN","MCN",32.68,
     &  -83.65,"19940501","YES","NWS",33.00,10.05)
      ASOSCommDates(247) = ASOSDATA("ROME","RICHARD B RUSSELL AIRPORT",
     &  "GA",93801,"KRMG","RMG",34.34,-85.16,"19970331","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(248) = ASOSDATA("SAVANNAH",
     &  "SAVANNAH/HILTON HEAD INTERNATIONAL AIRPORT","GA",3822,"KSAV",
     &  "SAV",32.11,-81.2,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(249) = ASOSDATA("VALDOSTA",
     &  "VALDOSTA REGIONAL AIRPORT","GA",93845,"KVLD","VLD",30.78,
     &  -83.27,"20010227","NO","FAA",33.00,10.05)
      ASOSCommDates(250) = ASOSDATA("HILO","HILO INTERNATIONAL AIRPORT",
     &  "HI",21504,"PHTO","ITO",19.72,-155.05,"19980101","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(251) = ASOSDATA("HONOLULU",
     &  "HONOLULU INTERNATIONAL AIRPORT","HI",22521,"PHNL","HNL",21.32,
     &  -157.94,"19980201","YES","NWS",26.00,7.92)
      ASOSCommDates(252) = ASOSDATA("KAHULUI","KAHULUI AIRPORT","HI",
     &  22516,"PHOG","OGG",20.9,-156.43,"19980301","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(253) = ASOSDATA("KAILUA/KONA",
     &  "KONA INTERNATIONAL AT KEYHOLE AIRPORT","HI",21510,"PHKO","KOA",
     &  19.73,-156.04,"19971231","NO","FAA",33.00,10.05)
      ASOSCommDates(254) = ASOSDATA("KAPOLEI",
     &  "KALAELOA AIRPORT (JOHN RODGERS FIELD) ","HI",22551,"PHJR",
     &  "JRF",21.31,-158.06,"19990831","NO","NWS",-9.,-9.)
      ASOSCommDates(255) = ASOSDATA("KAUNAKAKAI ","MOLOKAI AIRPORT",
     &  "HI",22534,"PHMK","MKK",21.15,-157.09,"19990601","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(256) = ASOSDATA("LIHUE","LIHUE AIRPORT","HI",22536,
     &  "PHLI","LIH",21.97,-159.34,"19971201","YES","NWS",33.00,10.05)
      ASOSCommDates(257) = ASOSDATA("AMES","AMES MUNICIPAL AIRPORT",
     &  "IA",94989,"KAMW","AMW",41.99,-93.62,"19960919","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(258) = ASOSDATA("BURLINGTON",
     &  "SOUTHEAST IOWA REGIONAL AIRPORT","IA",14931,"KBRL","BRL",40.78,
     &  -91.12,"19961121","NO","FAA",33.00,10.05)
      ASOSCommDates(259) = ASOSDATA("CEDAR RAPIDS",
     &  "THE EASTERN IOWA AIRPORT","IA",14990,"KCID","CID",41.88,-91.7,
     &  "19960424","NO","FAA",26.00,7.92)
      ASOSCommDates(260) = ASOSDATA("DAVENPORT",
     &  "DAVENPORT MUNICIPAL AIRPORT","IA",94982,"KDVN","DVN",41.61,
     &  -90.59,"19960417","NO","FAA",33.00,10.05)
      ASOSCommDates(261) = ASOSDATA("DES MOINES",
     &  "DES MOINES INTERNATIONAL AIRPORT","IA",14933,"KDSM","DSM",
     &  41.53,-93.66,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(262) = ASOSDATA("DUBUQUE",
     &  "DUBUQUE REGIONAL AIRPORT","IA",94908,"KDBQ","DBQ",42.39,-90.7,
     &  "19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(263) = ASOSDATA("ESTHERVILLE",
     &  "ESTHERVILLE MUNICIPAL AIRPORT","IA",94971,"KEST","EST",43.4,
     &  -94.74,"19951214","NO","FAA",33.00,10.05)
      ASOSCommDates(264) = ASOSDATA("IOWA CITY",
     &  "IOWA CITY MUNICIPAL AIRPORT","IA",14937,"KIOW","IOW",41.63,
     &  -91.54,"19950401","NO","FAA",33.00,10.05)
      ASOSCommDates(265) = ASOSDATA("LAMONI","LAMONI MUNICIPAL AIRPORT",
     &  "IA",94991,"KLWD","LWD",40.63,-93.9,"19970901","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(266) = ASOSDATA("MARSHALLTOWN",
     &  "MARSHALLTOWN MUNICIPAL AIRPORT","IA",94988,"KMIW","MIW",42.11,
     &  -92.91,"19960904","NO","FAA",33.00,10.05)
      ASOSCommDates(267) = ASOSDATA("MASON CITY",
     &  "MASON CITY MUNICIPAL AIRPORT","IA",14940,
     &  "KMCW","MCW",43.15,-93.33,"20000817","NO","FAA",33.00,10.05)
      ASOSCommDates(268) = ASOSDATA("OTTUMWA",
     &  "OTTUMWA INDUSTRIAL AIRPORT","IA",14950,"KOTM",
     &  "OTM",41.1,-92.44,"20000817","NO","FAA",33.00,10.05)
      ASOSCommDates(269) = ASOSDATA("SIOUX CITY",
     &  "SIOUX GATEWAY/COL. BUD DAY FIELD AIRPORT","IA",14943,"KSUX",
     &  "SUX",42.39,-96.37,"19950601","YES","NWS",33.00,10.05)
      ASOSCommDates(270) = ASOSDATA("SPENCER",
     &  "SPENCER MUNICIPAL AIRPORT","IA",14972,"KSPW","SPW",43.16,-95.2,
     &  "19960919","NO","FAA",33.00,10.05)
      ASOSCommDates(271) = ASOSDATA("WATERLOO",
     &  "WATERLOO MUNICIPAL AIRPORT","IA",94910,"KALO","ALO",42.55,
     &  -92.4,"19960401","YES","FAA",33.00,10.05)
      ASOSCommDates(272) = ASOSDATA("BOISE",
     &  "BOISE AIR TERM/GOWEN FIELD AIRPORT","ID",24131,"KBOI","BOI",
     &  43.56,-116.22,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(273) = ASOSDATA("BURLEY","BURLEY MUNICIPAL AIRPORT",
     &  "ID",24133,"KBYI","BYI",42.54,-113.77,"20001108","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(274) = ASOSDATA("CHALLIS","CHALLIS AIRPORT","ID",
     &  4114,"KLLJ","LLJ",41.52,-114.21,"19980922","NO","NWS",
     &  26.00,7.92)
      ASOSCommDates(275) = ASOSDATA("ELK CITY","ELK CITY","ID",4109,
     &  "KP69","P69",46.14,-115.59,"19970501","NO","NWS",26.00,7.92)
      ASOSCommDates(276) = ASOSDATA("IDAHO FALLS",
     &  "IDAHO FALLS REGIONAL AIRPORT","ID",24145,"KIDA","IDA",43.51,
     &  -112.06,"19980205","NO","FAA",26.00,7.92)
      ASOSCommDates(277) = ASOSDATA("JEROME","JEROME COUNTY AIRPORT",
     &  "ID",4110,"KJER","JER",42.72,-114.45,"19970201","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(278) = ASOSDATA("LEWISTON",
     &  "LEWISTON-NEZ PERCE COUNTY AIRPORT","ID",24149,"KLWS","LWS",
     &  46.37,-117.01,"19950701","YES","NWS",26.00,7.92)
      ASOSCommDates(279) = ASOSDATA("McCALL","McCALL MUNICIPAL AIRPORT",
     &  "ID",94182,"KMYL","MYL",44.88,-116.1,"19970916","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(280) = ASOSDATA("MULLAN PASS","MULLAN PASS ","ID",
     &  24154,"KMLP","MLP",47.45,-115.64,"19960619","NO","FAA",26.00,
     &  7.92)
      ASOSCommDates(281) = ASOSDATA("POCATELLO",
     &  "POCATELLO REGIONAL AIRPORT","ID",24156,"KPIH","PIH",42.92,
     &  -112.57,"19960301","YES","NWS",33.00,10.05)
      ASOSCommDates(282) = ASOSDATA("REXBURG",
     &  "REXBURG-MADISON COUNTY AIRPORT","ID",94194,"KRXE","RXE",43.83,
     &  -111.88,"19980212","NO","FAA",33.00,10.05)
      ASOSCommDates(283) = ASOSDATA("STANLEY","STANLEY RANGER STATION",
     &  "ID",4112,"KSNT","SNT",44.17,-114.92,"19980313","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(284) = ASOSDATA("TWIN FALLS",
     &  "JOSLIN FIELD-MAGIC VALLEY REGIONAL AIRPORT","ID",94178,"KTWF",
     &  "TWF",42.48,-114.48,"19970227","NO","FAA",33.00,10.05)
      ASOSCommDates(285) = ASOSDATA("BLOOMINGTON/NORMAL",
     &  "CENTRAL ILLINOIS REGIONAL AIRPORT","IL",54831,"KBMI","BMI",
     &  40.47,-88.91,"20050217","NO","FAA",-9.,-9.)
      ASOSCommDates(286) = ASOSDATA("CAHOKIA/ST.LOUIS",
     &  "ST.LOUIS DOWNTOWN AIRPORT","IL",3960,"KCPS","CPS",38.57,-90.15,
     &  "19970529","NO","FAA",33.00,10.05)
      ASOSCommDates(287) = ASOSDATA("CARBONDALE/MURPHYBORO",
     &  "SOUTHERN ILLINOIS AIRPORT","IL",93810,"KMDH","MDH",37.77,
     &  -89.24,"19971120","NO","FAA",33.00,10.05)
      ASOSCommDates(288) = ASOSDATA("CHAMPAIGN/URBANA",
     &  "UNIVERSITY OF ILLINOIS-WILLARD AIRPORT","IL",94870,"KCMI",
     &  "CMI",40.03,-88.27,"19970424","NO","FAA",26.00,7.92)
      ASOSCommDates(289) = ASOSDATA("CHICAGO",
     &  "CHICAGO MIDWAY INTERNATIONAL AIRPORT","IL",14819,"KMDW","MDW",
     &  41.78,-87.75,"19970410","NO","FAA",33.00,10.05)
      ASOSCommDates(290) = ASOSDATA("CHICAGO",
     &  "CHICAGO O'HARE INTERNATIONAL AIRPORT","IL",94846,"KORD","ORD",
     &  41.98,-87.91,"19960201","YES","NWS",33.00,10.05)
      ASOSCommDates(291) = ASOSDATA("CHICAGO/AURORA",
     &  "AURORA MUNICIPAL AIRPORT","IL",4808,"KARR","ARR",41.77,-88.48,
     &  "19981008","NO","FAA",26.00,7.92)
      ASOSCommDates(292) = ASOSDATA("CHICAGO/PROSPECT HEIGHTS/WHEELING",
     &  "PALWAUKEE MUNICIPAL AIRPORT","IL",4838,"KPWK","PWK",42.12,
     &  -87.9,"19960417","NO","FAA",26.00,7.92)
      ASOSCommDates(293) = ASOSDATA("CHICAGO/WAUKEGAN",
     &  "WAUKEGAN REGIONAL AIRPORT","IL",14880,"KUGN","UGN",42.42,
     &  -87.86,"19990901","NO","FAA",33.00,10.05)
      ASOSCommDates(294) = ASOSDATA("CHICAGO/WEST CHICAGO",
     &  "DUPAGE AIRPORT","IL",94892,"KDPA","DPA",41.91,-88.24,
     &  "19970424","NO","FAA",26.00,7.92)
      ASOSCommDates(295) = ASOSDATA("DECATUR","DECATUR AIRPORT","IL",
     &  3887,"KDEC","DEC",39.98,-88.86,"20001129","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(296) = ASOSDATA("LAWRENCEVILLE",
     &  "LAWRENCEVILLE-VINCENNES INTERNATIONAL AIRPORT","IL",13809,
     &  "KLWV","LWV",38.76,-87.6,"19960918","NO","FAA",33.00,10.05)
      ASOSCommDates(297) = ASOSDATA("MATTOON/CHARLESTON",
     &  "COLES COUNTY MEMORIAL AIRPORT","IL",53802,"KMTO","MTO",39.47,
     &  -88.28,"19971204","NO","FAA",26.00,7.92)
      ASOSCommDates(298) = ASOSDATA("MOLINE",
     &  "QUAD CITY INTERNATIONAL AIRPORT","IL",14923,"KMLI","MLI",41.46,
     &  -90.52,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(299) = ASOSDATA("PEORIA",
     &  "GREATER PEORIA REGIONAL AIRPORT","IL",14842,"KPIA","PIA",40.66,
     &  -89.68,"19951001","YES","NWS",33.00,10.05)
      ASOSCommDates(300) = ASOSDATA("QUINCY",
     &  "QUINCY REGIONAL-BALDWIN FIELD AIRPORT","IL",93989,"KUIN","UIN",
     &  39.94,-91.19,"20000906","NO","FAA",26.00,7.92)
      ASOSCommDates(301) = ASOSDATA("ROCKFORD",
     &  "GREATER ROCKFORD AIRPORT","IL",94822,"KRFD","RFD",42.19,-89.09,
     &  "19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(302) = ASOSDATA("SPRINGFIELD",
     &  "ABRAHAM LINCOLN CAPITAL AIRPORT","IL",93822,"KSPI","SPI",39.84,
     &  -89.68,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(303) = ASOSDATA("BLOOMINGTON",
     &  "MONROE COUNTY AIRPORT","IN",3893,"KBMG","BMG",39.14,-86.61,
     &  "19980312","NO","FAA",26.00,7.92)
      ASOSCommDates(304) = ASOSDATA("EVANSVILLE",
     &  "EVANSVILLE REGIONAL AIRPORT","IN",93817,"KEVV","EVV",38.04,
     &  -87.53,"19960201","YES","NWS",26.00,7.92)
      ASOSCommDates(305) = ASOSDATA("FORT WAYNE",
     &  "FORT WAYNE INTERNATIONAL AIRPORT","IN",14827,"KFWA","FWA",41.,
     &  -85.2,"19960701","YES","NWS",33.00,10.05)
      ASOSCommDates(306) = ASOSDATA("GOSHEN","GOSHEN MUNICIPAL AIRPORT",
     &  "IN",14829,"KGSH","GSH",41.52,-85.79,"19960926","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(307) = ASOSDATA("INDIANAPOLIS",
     &  "EAGLE CREEK AIRPARK AIRPORT","IN",53842,"KEYE","EYE",39.82,
     &  -86.29,"19960215","NO","FAA",33.00,10.05)
      ASOSCommDates(308) = ASOSDATA("INDIANAPOLIS",
     &  "INDIANAPOLIS INTERNATIONAL AIRPORT","IN",93819,"KIND","IND",
     &  39.71,-86.27,"19960101","YES","NWS",33.00,10.05)
      ASOSCommDates(309) = ASOSDATA("LAFAYETTE",
     &  "PURDUE UNIVERSITY AIRPORT","IN",14835,"KLAF","LAF",40.41,
     &  -86.93,"19980115","NO","FAA",33.00,10.05)
      ASOSCommDates(310) = ASOSDATA("MUNCIE",
     &  "DELAWARE COUNTY-JOHNSON FIELD AIRPORT","IN",94895,"KMIE","MIE",
     &  40.23,-85.39,"19990429","NO","FAA",33.00,10.05)
      ASOSCommDates(311) = ASOSDATA("SHELBYVILLE",
     &  "SHELBYVILLE MUNICIPAL AIRPORT","IN",53866,"KGEZ","GEZ",39.57,
     &  -85.8,"19980625","NO","NWS",33.00,10.05)
      ASOSCommDates(312) = ASOSDATA("SOUTH BEND",
     &  "SOUTH BEND REGIONAL AIRPORT","IN",14848,"KSBN","SBN",41.7,
     &  -86.33,"19960701","YES","NWS",33.00,10.05)
      ASOSCommDates(313) = ASOSDATA("TERRE HAUTE",
     &  "TERRE HAUTE INTERNATIONAL-HULMAN FIELD AIRPORT","IN",3868,
     &  "KHUF","HUF",39.45,-87.3,"19980305","NO","FAA",26.00,7.92)
      ASOSCommDates(314) = ASOSDATA("VALPARAISO",
     &  "PORTER COUNTY MUNICIPAL AIRPORT","IN",4846,"KVPZ","VPZ",41.45,
     &  -87.,"19971113","NO","FAA",26.00,7.92)
      ASOSCommDates(315) = ASOSDATA("CHANUTE",
     &  "CHANUTE MARTIN JOHNSON AIRPORT","KS",13981,"KCNU","CNU",37.67,
     &  -95.48,"19960516","NO","FAA",33.00,10.05)
      ASOSCommDates(316) = ASOSDATA("COFFEYVILLE",
     &  "COFFEYVILLE MUNICIPAL AIRPORT","KS",93967,"KCFV","CFV",37.09,
     &  -95.56,"19960417","NO","FAA",33.00,10.05)
      ASOSCommDates(317) = ASOSDATA("CONCORDIA",
     &  "BLOSSER MUNICIPAL AIRPORT","KS",13984,"KCNK","CNK",39.54,
     &  -97.65,"19920901","YES","NWS",33.00,10.05)
      ASOSCommDates(318) = ASOSDATA("DODGE CITY",
     &  "DODGE CITY REGIONAL AIRPORT","KS",13985,"KDDC","DDC",37.77,
     &  -99.96,"19920901","YES","NWS",26.00,7.92)
      ASOSCommDates(319) = ASOSDATA("EMPORIA",
     &  "EMPORIA MUNICIPAL AIRPORT","KS",13989,"KEMP","EMP",38.33,
     &  -96.18,"19960215","NO","FAA",33.00,10.05)
      ASOSCommDates(320) = ASOSDATA("GARDEN CITY",
     &  "GARDEN CITY REGIONAL AIRPORT","KS",23064,"KGCK","GCK",37.92,
     &  -100.72,"19961217","NO","FAA",26.00,7.92)
      ASOSCommDates(321) = ASOSDATA("GOODLAND",
     &  "RENNER FIELD/GOODLAND MUNICIPAL AIRPORT","KS",23065,"KGLD",
     &  "GLD",39.36,-101.69,"19920901","YES","NWS",33.00,10.05)
      ASOSCommDates(322) = ASOSDATA("HILL CITY",
     &  "HILL CITY MUNICIPAL AIRPORT","KS",93990,"KHLC","HLC",39.37,
     &  -99.82,"19960516","NO","FAA",33.00,10.05)
      ASOSCommDates(323) = ASOSDATA("HUTCHINSON",
     &  "HUTCHINSON MUNICIPAL AIRPORT","KS",13986,"KHUT","HUT",38.06,
     &  -97.86,"19960620","NO","FAA",33.00,10.05)
      ASOSCommDates(324) = ASOSDATA("LAWRENCE",
     &  "LAWRENCE MUNICIPAL AIRPORT","KS",3997,"KLWC","LWC",39.,-95.21,
     &  "19960417","NO","FAA",33.00,10.05)
      ASOSCommDates(325) = ASOSDATA("MANHATTAN",
     &  "MANHATTAN REGIONAL AIRPORT","KS",3936,"KMHK","MHK",39.13,
     &  -96.67,"19960215","NO","FAA",26.00,7.92)
      ASOSCommDates(326) = ASOSDATA("MEDICINE LODGE","MEDICINE LODGE",
     &  "KS",3957,"KP28","P28",37.28,-98.55,"19980205","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(327) = ASOSDATA("OLATHE",
     &  "NEW CENTURY AIRCENTER AIRPORT","KS",93909,"KIXD","IXD",38.83,
     &  -94.88,"19970410","NO","FAA",33.00,10.05)
      ASOSCommDates(328) = ASOSDATA("OLATHE",
     &  "JOHNSON COUNTY EXECUTIVE AIRPORT","KS",3967,"KOJC","OJC",38.85,
     &  -94.73,"19960620","NO","FAA",33.00,10.05)
      ASOSCommDates(329) = ASOSDATA("PARSONS","TRI-CITY AIRPORT","KS",
     &  3998,"KPPF","PPF",37.32,-95.5,"19960516","NO","FAA",26.00,7.92)
      ASOSCommDates(330) = ASOSDATA("RUSSELL",
     &  "RUSSELL MUNICIPAL AIRPORT","KS",93997,"KRSL","RSL",38.87,
     &  -98.82,"19951214","NO","FAA",33.00,10.05)
      ASOSCommDates(331) = ASOSDATA("SALINA","SALINA MUNICIPAL AIRPORT",
     &  "KS",3919,"KSLN","SLN",38.81,-97.66,"19951214","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(332) = ASOSDATA("TOPEKA","FORBES FIELD AIRPORT",
     &  "KS",13920,"KFOE","FOE",38.95,-95.66,"19971119","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(333) = ASOSDATA("TOPEKA",
     &  "PHILIP BILLARD MUNICIPAL AIRPORT","KS",13996,"KTOP","TOP",
     &  39.07,-95.62,"19921201","YES","NWS",26.00,7.92)
      ASOSCommDates(334) = ASOSDATA("WICHITA",
     &  "COLONEL JAMES JABARA AIRPORT","KS",3974,"KAAO","AAO",37.74,
     &  -97.21,"19951114","NO","FAA",33.00,10.05)
      ASOSCommDates(335) = ASOSDATA("WICHITA",
     &  "WICHITA MID-CONTINENT AIRPORT","KS",3928,"KICT","ICT",37.64,
     &  -97.42,"19921101","YES","NWS",33.00,10.05)
      ASOSCommDates(336) = ASOSDATA("WINFIELD/ARKANSAS CITY",
     &  "STROTNER FIELD AIRPORT","KS",13932,"KWLD","WLD",37.16,-97.03,
     &  "19951214","NO","FAA",26.00,7.92)
      ASOSCommDates(337) = ASOSDATA("BOWLING GREEN",
     &  "BOWLING GREEN-WARREN COUNTY REGIONAL AIRPORT","KY",93808,
     &  "KBWG","BWG",36.98,-86.43,"19960206","NO","FAA",26.00,7.92)
      ASOSCommDates(338) = ASOSDATA("FRANKFORT","CAPITAL CITY AIRPORT",
     &  "KY",53841,"KFFT","FFT",38.18,-84.9,"19951214","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(339) = ASOSDATA("JACKSON","JULIAN CARROLL AIRPORT",
     &  "KY",3889,"KJKL","JKL",37.59,-83.31,"19951201","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(340) = ASOSDATA("LEXINGTON","BLUE GRASS AIRPORT",
     &  "KY",93820,"KLEX","LEX",38.04,-84.6,"19960301","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(341) = ASOSDATA("LONDON",
     &  "LONDON-CORBIN AIRPORT-MAGEE FIELD AIRPORT","KY",3849,"KLOZ",
     &  "LOZ",37.08,-84.07,"19960918","NO","FAA",33.00,10.05)
      ASOSCommDates(342) = ASOSDATA("LOUISVILLE","BOWMAN FIELD AIRPORT",
     &  "KY",13810,"KLOU","LOU",38.22,-85.66,"20000906","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(343) = ASOSDATA("LOUISVILLE",
     &  "LOUISVILLE INTERNATIONAL-STANDIFORD FIELD AIRPORT","KY",93821,
     &  "KSDF","SDF",38.17,-85.72,"19940801","YES","NWS",33.00,10.05)
      ASOSCommDates(344) = ASOSDATA("PADUCAH",
     &  "BARKLEY REGIONAL AIRPORT","KY",3816,"KPAH","PAH",37.05,-88.77,
     &  "19950801","YES","NWS",33.00,10.05)
      ASOSCommDates(345) = ASOSDATA("ALEXANDRIA",
     &  "ALEXANDRIA INTERNATIONAL AIRPORT","LA",93915,"KAEX","AEX",
     &  31.33,-92.55,"19990720","NO","FAA",26.00,7.92)
      ASOSCommDates(346) = ASOSDATA("ALEXANDRIA",
     &  "ESLER REGIONAL AIRPORT","LA",13935,"KESF","ESF",31.39,-92.29,
     &  "19960430","NO","FAA",33.00,10.05)
      ASOSCommDates(347) = ASOSDATA("BATON ROUGE",
     &  "BATON ROUGE METROPOLITAN, RYAN FIELD AIRPORT","LA",13970,
     &  "KBTR","BTR",30.53,-91.14,"19930501","YES","NWS",33.00,10.05)
      ASOSCommDates(348) = ASOSDATA("BOOTHVILLE","BOOTHVILLE","LA",
     &  12884,"KBVE","BVE",29.34,-89.4,"19990630","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(349) = ASOSDATA("LAFAYETTE",
     &  "LAFAYETTE REGIONAL AIRPORT","LA",13976,"KLFT","LFT",30.2,
     &  -91.98,"19980825","NO","FAA",26.00,7.92)
      ASOSCommDates(350) = ASOSDATA("LAKE CHARLES",
     &  "LAKE CHARLES REGIONAL AIRPORT","LA",3937,"KLCH","LCH",30.12,
     &  -93.22,"19960101","YES","NWS",33.00,10.05)
      ASOSCommDates(351) = ASOSDATA("MONROE","MONROE REGIONAL AIRPORT",
     &  "LA",13942,"KMLU","MLU",32.51,-92.03,"19980624","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(352) = ASOSDATA("NEW IBERIA",
     &  "ACADIANA REGIONAL AIRPORT","LA",53915,"KARA","ARA",30.05,
     &  -91.88,"19981105","NO","FAA",26.00,7.92)
      ASOSCommDates(353) = ASOSDATA("NEW ORLEANS",
     &  "LOUIS ARMSTRONG NEW ORLEANS INTERNATIONAL AIRPORT","LA",12916,
     &  "KMSY","MSY",29.99,-90.25,"19960501","YES","NWS",33.00,10.05)
      ASOSCommDates(354) = ASOSDATA("NEW ORLEANS","LAKEFRONT AIRPORT",
     &  "LA",53917,"KNEW","NEW",30.04,-90.02,"19980812","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(355) = ASOSDATA("SALT POINT","SALT POINT","LA",
     &  12968,"KP92","P92",29.56,-91.52,"19980505","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(356) = ASOSDATA("SHREVEPORT",
     &  "SHREVEPORT DOWNTOWN AIRPORT","LA",53905,"KDTN","DTN",32.53,
     &  -93.74,"19970501","NO","FAA",33.00,10.05)
      ASOSCommDates(357) = ASOSDATA("SHREVEPORT",
     &  "SHREVEPORT REGIONAL AIRPORT","LA",13957,"KSHV","SHV",32.44,
     &  -93.82,"19951001","YES","NWS",33.00,10.05)
      ASOSCommDates(358) = ASOSDATA("SLIDELL","SLIDELL AIRPORT","LA",
     &  53865,"KASD","ASD",30.34,-89.82,"19980624","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(359) = ASOSDATA("BEDFORD",
     &  "LAURENCE G HANSCOM FIELD AIRPORT","MA",14702,"KBED","BED",
     &  42.47,-71.28,"19980819","NO","FAA",33.00,10.05)
      ASOSCommDates(360) = ASOSDATA("BEVERLY",
     &  "BEVERLY MUNICIPAL AIRPORT","MA",54733,"KBVY","BVY",42.58,
     &  -70.91,"19981209","NO","FAA",33.00,10.05)
      ASOSCommDates(361) = ASOSDATA("BOSTON",
     &  "GENERAL E.L. LOGAN INTERNATIONAL AIRPORT","MA",14739,"KBOS",
     &  "BOS",42.36,-71.01,"19960401","YES","NWS",26.00,7.92)
      ASOSCommDates(362) = ASOSDATA("CHATHAM",
     &  "CHATHAM MUNICIPAL AIRPORT","MA",94624,"KCQX","CQX",41.68,
     &  -69.99,"19950614","NO","FAA",33.00,10.05)
      ASOSCommDates(363) = ASOSDATA("FITCHBURG",
     &  "FITCHBURG MUNICIPAL AIRPORT","MA",4780,"KFIT","FIT",42.55,
     &  -71.75,"19970917","NO","FAA",33.00,10.05)
      ASOSCommDates(364) = ASOSDATA("HYANNIS",
     &  "BARNSTABLE MUNICIPAL-BOARDMAN/POLANDO FIELD AIRPORT","MA",
     &  94720,"KHYA","HYA",41.66,-70.28,"19970219","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(365) = ASOSDATA("LAWRENCE",
     &  "LAWRENCE MUNICIPAL AIRPORT","MA",94723,"KLWM","LWM",42.71,
     &  -71.12,"19970515","NO","FAA",33.00,10.05)
      ASOSCommDates(366) = ASOSDATA("MILTON","BLUE HILL OBSERVATORY",
     &  "MA",14753,"KMQE","MQE",42.21,-71.11,"19981015","YES","NWS",
     &  14.00,4.26)
      ASOSCommDates(367) = ASOSDATA("NANTUCKET",
     &  "NANTUCKET MEMORIAL AIRPORT","MA",14756,"KACK","ACK",41.25,
     &  -70.06,"19970616","NO","FAA",33.00,10.05)
      ASOSCommDates(368) = ASOSDATA("NEW BEDFORD",
     &  "NEW BEDFORD REGIONAL AIRPORT","MA",94726,"KEWB","EWB",41.67,
     &  -70.95,"19960320","NO","FAA",26.00,7.92)
      ASOSCommDates(369) = ASOSDATA("NORTH ADAMS",
     &  "HARRIMAN-AND-WEST AIRPORT","MA",53915,"KAQW","AQW",30.03,
     &  -91.88,"19980505","NO","FAA",33.00,10.05)
      ASOSCommDates(370) = ASOSDATA("NORWOOD",
     &  "NORWOOD MEMORIAL AIRPORT","MA",54704,"KOWD","OWD",42.19,-71.17,
     &  "19980603","NO","FAA",26.00,7.92)
      ASOSCommDates(371) = ASOSDATA("ORANGE","ORANGE MUNICIPAL AIRPORT",
     &  "MA",54756,"KORE","ORE",42.57,-72.29,"19950524","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(372) = ASOSDATA("PITTSFIELD",
     &  "PITTSFIELD MUNICIPAL AIRPORT","MA",14763,"KPSF","PSF",42.42,
     &  -73.28,"19990120","NO","FAA",33.00,10.05)
      ASOSCommDates(373) = ASOSDATA("PLYMOUTH",
     &  "PLYMOUTH MUNICIPAL AIRPORT","MA",54769,"KPYM","PYM",41.9,
     &  -70.72,"19950512","NO","FAA",33.00,10.05)
      ASOSCommDates(374) = ASOSDATA("TAUNTON",
     &  "TAUNTON MUNICIPAL AIRPORT","MA",54777,"KTAN","TAN",41.87,
     &  -71.02,"19971105","NO","FAA",33.00,10.05)
      ASOSCommDates(375) = ASOSDATA("VINEYARD HAVEN",
     &  "MARTHAS VINEYARD AIRPORT","MA",94724,"KMVY","MVY",41.39,-70.61,
     &  "19970617","NO","FAA",33.00,10.05)
      ASOSCommDates(376) = ASOSDATA("WESTFIELD/SPRINGFIELD",
     &  "BARNES MUNICIPAL AIRPORT","MA",14775,"KBAF","BAF",42.15,-72.71,
     &  "19980805","NO","FAA",33.00,10.05)
      ASOSCommDates(377) = ASOSDATA("WORCESTER",
     &  "WORCHESTER REGIONAL AIRPORT","MA",94746,"KORH","ORH",42.26,
     &  -71.87,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(378) = ASOSDATA("BALTIMORE",
     &  "BALTIMORE-WASHINGTON INTERNATIONAL AIRPORT","MD",93721,"KBWI",
     &  "BWI",39.17,-76.68,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(379) = ASOSDATA("BALTIMORE","BALTIMORE DOWNTOWN",
     &  "MD",93784,"KDMH","DMH",39.28,-76.61,"19980429","NO","NWS",0.00,
     &  0.00)
      ASOSCommDates(380) = ASOSDATA("HAGERSTOWN",
     &  "HAGERSTOWN REGIONAL - RICHARD A HENSON FIELD ARPT","MD",93706,
     &  "KHGR","HGR",39.7,-77.72,"19981001","NO","FAA",26.00,7.92)
      ASOSCommDates(381) = ASOSDATA("OCEAN CITY",
     &  "OCEAN CITY MUNICIPAL AIRPORT","MD",93786,"KOXB","OXB",38.3,
     &  -75.12,"19990901","NO","FAA",33.00,10.05)
      ASOSCommDates(382) = ASOSDATA("SALISBURY",
     &  "SALISBURY-OCEAN CITY WICOMICO REGIONAL AIRPORT","MD",93720,
     &  "KSBY","SBY",38.34,-75.51,"20010509","NO","FAA",26.00,7.92)
      ASOSCommDates(383) = ASOSDATA("AUGUSTA","AUGUSTA STATE AIRPORT",
     &  "ME",14605,"KAUG","AUG",44.32,-69.79,"20010110","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(384) = ASOSDATA("BANGOR",
     &  "BANGOR INTERNATIONAL AIRPORT","ME",14606,"KBGR","BGR",44.8,
     &  -68.82,"19980401","NO","FAA",33.00,10.05)
      ASOSCommDates(385) = ASOSDATA("CARIBOU",
     &  "CARIBOU MUNICIPAL AIRPORT","ME",14607,"KCAR","CAR",46.86,
     &  -68.03,"19960801","YES","NWS",26.00,7.92)
      ASOSCommDates(386) = ASOSDATA("FRENCHVILLE",
     &  "NORTHERN AROOSTOOK REGIONAL AIRPORT","ME",4836,"KFVE","FVE",
     &  47.28,-68.3,"19950531","NO","FAA",33.00,10.05)
      ASOSCommDates(387) = ASOSDATA("FRYEBURG",
     &  "EASTERN SLOPES REGIONAL AIRPORT","ME",54772,"KIZG","IZG",43.99,
     &  -70.94,"19951206","NO","FAA",33.00,10.05)
      ASOSCommDates(388) = ASOSDATA("GREENVILLE","MAINE FOREST SERVICE",
     &  "ME",94626,"KGNR","GNR",45.46,-69.59,"19980304","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(389) = ASOSDATA("HOULTON",
     &  "HOULTON INTERNATIONAL AIRPORT","ME",14609,"KHUL","HUL",46.12,
     &  -67.79,"20000913","NO","FAA",33.00,10.05)
      ASOSCommDates(390) = ASOSDATA("MILLINOCKET",
     &  "MILLINOCKET MUNICIPAL AIRPORT","ME",14610,"KMLT","MLT",45.64,
     &  -68.68,"19950920","NO","FAA",33.00,10.05)
      ASOSCommDates(391) = ASOSDATA("PORTLAND",
     &  "PORTLAND INTERNATIONAL JETPORT AIRPORT","ME",14764,"KPWM",
     &  "PWM",43.64,-70.3,"19940801","YES","NWS",26.00,7.92)
      ASOSCommDates(392) = ASOSDATA("WISCASSET","WISCASSET AIRPORT",
     &  "ME",94623,"KIWI","IWI",43.96,-69.71,"19950428","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(393) = ASOSDATA("ADRIAN",
     &  "ADRIAN LENAWEE COUNTY AIRPORT","MI",4847,"KADG","ADG",41.86,
     &  -84.07,"19971217","NO","FAA",33.00,10.05)
      ASOSCommDates(394) = ASOSDATA("ALPENA",
     &  "ALPENA COUNTY REGIONAL AIRPORT","MI",94849,"KAPN","APN",45.08,
     &  -83.17,"19950614","NO","FAA",33.00,10.05)
      ASOSCommDates(395) = ASOSDATA("ANN ARBOR",
     &  "ANN ARBOR MUNICIPAL AIRPORT","MI",94849,"KARB","ARB",45.07,
     &  -83.58,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(396) = ASOSDATA("BATTLE CREEK",
     &  "W.K.KELLOGG AIRPORT","MI",14815,"KBTL","BTL",42.3,-85.25,
     &  "19980212","NO","FAA",33.00,10.05)
      ASOSCommDates(397) = ASOSDATA("BENTON HARBOR",
     &  "SOUTHWEST MICHIGAN REGIONAL AIRPORT","MI",94871,"KBEH","BEH",
     &  42.12,-86.42,"19960619","NO","FAA",33.00,10.05)
      ASOSCommDates(398) = ASOSDATA("COPPER HARBOR","COPPER HARBOR",
     &  "MI",94899,"KP59","P59",47.46,-87.87,"19980730","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(399) = ASOSDATA("DETROIT","DETROIT CITY AIRPORT",
     &  "MI",14822,"KDET","DET",42.4,-83.01,"20001019","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(400) = ASOSDATA("DETROIT",
     &  "DETROIT METROPOLITAN WAYNE COUNTY AIRPORT","MI",94847,"KDTW",
     &  "DTW",42.21,-83.34,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(401) = ASOSDATA("DETROIT","WILLOW RUN AIRPORT","MI",
     &  14853,"KYIP","YIP",42.23,-85.52,"19990311","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(402) = ASOSDATA("FLINT",
     &  "BISHOP INTERNATIONAL AIRPORT","MI",14826,"KFNT","FNT",42.96,
     &  -83.74,"19950601","YES","NWS",33.00,10.05)
      ASOSCommDates(403) = ASOSDATA("GAYLORD","OTSEGO COUNTY AIRPORT",
     &  "MI",4854,"KGLR","GLR",45.01,-84.7,"19980326","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(404) = ASOSDATA("GRAND RAPTIDS",
     &  "GERALD R. FORD INTERNATIONAL AIRPORT","MI",94860,"KGRR","GRR",
     &  42.88,-85.52,"19950801","YES","NWS",33.00,10.05)
      ASOSCommDates(405) = ASOSDATA("HANCOCK",
     &  "HOUGHTON COUNTY MEMORIAL AIRPORT","MI",14858,"KCMX","CMX",
     &  47.16,-88.5,"20000914","NO","FAA",26.00,7.92)
      ASOSCommDates(406) = ASOSDATA("HARBOR BEACH","HARBOR BEACH","MI",
     &  94898,"KP58","P58",44.02,-82.79,"19990624","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(407) = ASOSDATA("HOLLAND","TULIP CITY AIRPORT","MI",
     &  4839,"KBIV","BIV",42.74,-86.09,"19960621","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(408) = ASOSDATA("HOUGHTON LAKE",
     &  "ROSCOMMON COUNTY AIRPORT","MI",94814,"KHTL","HTL",44.36,-84.69,
     &  "19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(409) = ASOSDATA("IRON MOUNTAIN/KINGSFORD",
     &  "FORD AIRPORT","MI",94893,"KIMT","IMT",45.81,-88.11,"19960910",
     &  "NO","FAA",26.00,7.92)
      ASOSCommDates(410) = ASOSDATA("JACKSON",
     &  "JACKSON COUNTY-REYNOLDS FIELD AIRPORT",
     &  "MI",14833,"KJXN","JXN",42.25,-84.45,"20001013","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(411) = ASOSDATA("KALAMAZOO",
     &  "KALAMAZOO/BATTLE CREEK INTERNATIONAL AIRPORT","MI",94815,
     &  "KAZO","AZO",42.23,-85.55,"19980115","NO","FAA",33.00,10.05)
      ASOSCommDates(412) = ASOSDATA("LANSING","CAPITAL CITY AIRPORT",
     &  "MI",14836,"KLAN","LAN",42.78,-84.57,"19960601","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(413) = ASOSDATA("MUNISING","MUNISING LAKESHORE",
     &  "MI",54813,"KP53","P53",46.42,-86.65,"20041201","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(414) = ASOSDATA("MUSKEGON",
     &  "MUSKEGON COUNTY AIRPORT","MI",14840,"KMKG","MKG",43.17,-86.23,
     &  "19960501","YES","NWS",33.00,10.05)
      ASOSCommDates(415) = ASOSDATA("PELLSTON",
     &  "PELLSTON REGIONAL AIRPORT OF EMMET COUNTY AIRPORT","MI",14841,
     &  "KPLN","PLN",45.57,-84.79,"20000824","NO","FAA",26.00,7.92)
      ASOSCommDates(416) = ASOSDATA("PONTIAC",
     &  "OAKLAND COUNTY INTERNATIONAL AIRPORT","MI",94817,"KPTK","PTK",
     &  42.66,-83.41,"19980820","NO","FAA",33.00,10.05)
      ASOSCommDates(417) = ASOSDATA("SAGINAW",
     &  "MBS INTERNATIONAL AIRPORT","MI",14845,"KMBS","MBS",43.53,
     &  -84.07,"19980909","NO","FAA",33.00,10.05)
      ASOSCommDates(418) = ASOSDATA("SAULT STE MARIE",
     &  "SAULT STE MARIE MUNI/SANDERSON FIELD AIRPORT","MI",14847,
     &  "KANJ","ANJ",46.46,-84.36,"19970101","YES","NWS",33.00,10.05)
      ASOSCommDates(419) = ASOSDATA("TRAVERSE CITY",
     &  "CHERRY CAPITAL AIRPORT","MI",14850,"KTVC","TVC",44.74,-85.58,
     &  "19980611","NO","FAA",26.00,7.92)
      ASOSCommDates(420) = ASOSDATA("ALEXANDRIA",
     &  "CHANDLER FIELD AIRPORT","MN",14910,"KAXN","AXN",45.88,-95.39,
     &  "19951214","NO","FAA",33.00,10.05)
      ASOSCommDates(421) = ASOSDATA("BAUDETTE",
     &  "BAUDETTE INTERNATIONAL AIRPORT","MN",94961,"KBDE","BDE",48.72,
     &  -94.61,"19950701","NO","FAA",33.00,10.05)
      ASOSCommDates(422) = ASOSDATA("BRAINERD",
     &  "BRAINERD LAKES REGIONAL AIRPORT","MN",94938,"KBRD","BRD",46.4,
     &  -94.13,"19951024","NO","FAA",33.00,10.05)
      ASOSCommDates(423) = ASOSDATA("DULUTH",
     &  "DULUTH INTERNATIONAL AIRPORT","MN",14913,"KDLH","DLH",46.84,
     &  -92.19,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(424) = ASOSDATA("GRAND MARAIS","GRAND MARAIS","MN",
     &  94992,"KGNA","GNA",47.74,-90.34,"19980730","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(425) = ASOSDATA("HIBBING",
     &  "CHISHOLM-HIBBING AIRPORT","MN",94931,"KHIB","HIB",47.38,-92.83,
     &  "20000824","NO","FAA",33.00,10.05)
      ASOSCommDates(426) = ASOSDATA("INTERNATIONAL FALLS",
     &  "FALLS INTERNATIONAL AIRPORT","MN",14918,"KINL","INL",48.56,
     &  -93.4,"19961101","YES","NWS",33.00,10.05)
      ASOSCommDates(427) = ASOSDATA("MINNEAPOLIS",
     &  "FLYING CLOUD AIRPORT","MN",94963,"KFCM","FCM",44.83,-93.47,
     &  "19971002","NO","FAA",33.00,10.05)
      ASOSCommDates(428) = ASOSDATA("MINNEAPOLIS","CRYSTAL AIRPORT",
     &  "MN",94960,"KMIC","MIC",45.06,-93.35,"19970911","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(429) = ASOSDATA("MINNEAPOLIS",
     &  "MINNEAPOLIS-ST PAUL INTL/WORLD-CHAMBERLAIN AIRPORT","MN",14922,
     &  "KMSP","MSP",44.88,-93.22,"19960601","YES","NWS",33.00,10.05)
      ASOSCommDates(430) = ASOSDATA("PARK RAPIDS",
     &  "PARK RAPIDS MUNICIPAL-KONSHOK FIELD AIRPORT","MN",94967,"KPKD",
     &  "PKD",46.9,-95.06,"19950701","NO","FAA",33.00,10.05)
      ASOSCommDates(431) = ASOSDATA("REDWOOD FALLS",
     &  "REDWOOD FALLS MUNICIPAL AIRPORT","MN",14992,
     &  "KRWF","RWF",44.54,-95.08,"20000824","NO","FAA",33.00,10.05)
      ASOSCommDates(432) = ASOSDATA("ROCHESTER",
     &  "ROCHESTER INTERNATIONAL AIRPORT","MN",14925,"KRST","RST",43.9,
     &  -92.49,"19960601","YES","NWS",33.00,10.05)
      ASOSCommDates(433) = ASOSDATA("ST CLOUD",
     &  "ST CLOUD REGIONAL AIRPORT","MN",14926,"KSTC","STC",45.54,
     &  -94.05,"19950601","YES","NWS",33.00,10.05)
      ASOSCommDates(434) = ASOSDATA("ST PAUL",
     &  "ST PAUL DOWNTOWN HOLMAN FIELD AIRPORT","MN",14927,"KSTP","STP",
     &  44.93,-93.04,"19960628","NO","FAA",33.00,10.05)
      ASOSCommDates(435) = ASOSDATA("CAPE GIRARDEAU",
     &  "CAPE GIRARDEAU REGIONAL AIRPORT","MO",3935,"KCGI","CGI",37.22,
     &  -89.57,"19970305","NO","FAA",26.00,7.92)
      ASOSCommDates(436) = ASOSDATA("CHILLICOTHE",
     &  "AGRICULTURAL-SCIENCE CENTER ","MO",53916,"KCDJ","CDJ",39.82,
     &  -93.57,"19980521","NO","NWS",33.00,10.05)
      ASOSCommDates(437) = ASOSDATA("COLUMBIA",
     &  "COLUMBIA REGIONAL AIRPORT","MO",3945,"KCOU","COU",38.81,-92.21,
     &  "19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(438) = ASOSDATA("JEFFERSON CITY",
     &  "JEFFERSON CITY MEMORIAL AIRPORT","MO",3963,"KJEF","JEF",38.59,
     &  -92.15,"19970410","NO","FAA",33.00,10.05)
      ASOSCommDates(439) = ASOSDATA("JOPLIN","JOPLIN REGIONAL AIRPORT",
     &  "MO",13987,"KJLN","JLN",37.14,-94.49,"19980226","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(440) = ASOSDATA("KANSAS CITY",
     &  "KANSAS CITY INTERNATIONAL AIRPORT","MO",3947,"KMCI","MCI",
     &  39.29,-94.71,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(441) = ASOSDATA("KANSAS CITY",
     &  "CHARLES B WHEELER DOWNTOWN AIRPORT","MO",13988,"KMKC","MKC",
     &  39.12,-94.59,"19971113","NO","FAA",26.00,7.92)
      ASOSCommDates(442) = ASOSDATA("KIRKSVILLE",
     &  "KIRKSVILLE REGIONAL AIRPORT","MO",14938,"KIRK","IRK",40.09,
     &  -92.54,"19980611","NO","NWS",33.00,10.05)
      ASOSCommDates(443) = ASOSDATA("LEE'S SUMMIT",
     &  "LEE'S SUMMIT MUNICIPAL AIRPORT","MO",53879,"KLXT","LXT",38.95,
     &  -94.37,"20020418","NO","FAA",-9.,-9.)
      ASOSCommDates(444) = ASOSDATA("POPLAR BLUFF",
     &  "POPLAR BLUFF MUNICIPAL AIRPORT","MO",3975,"KPOF","POF",36.77,
     &  -90.32,"19971120","NO","NWS",26.00,7.92)
      ASOSCommDates(445) = ASOSDATA("ROLLA/VICHY",
     &  "ROLLA NATIONAL AIRPORT","MO",13997,"KVIH","VIH",38.12,-91.76,
     &  "19961112","NO","FAA",33.00,10.05)
      ASOSCommDates(446) = ASOSDATA("SEDALIA",
     &  "SEDALIA MEMORIAL AIRPORT","MO",3994,"KDMO","DMO",38.7,-93.18,
     &  "19951024","NO","FAA",33.00,10.05)
      ASOSCommDates(447) = ASOSDATA("SPRINGFIELD",
     &  "SPRINGFIELD-BRANSON REGIONAL AIRPORT","MO",13995,"KSGF","SGF",
     &  37.23,-93.38,"19951101","YES","NWS",33.00,10.05)
      ASOSCommDates(448) = ASOSDATA("ST CHARLES",
     &  "ST CHARLES COUNTY SMARTT AIRPORT","MO",53904,"KSET","SET",
     &  38.92,-90.42,"19970326","NO","FAA",33.00,10.05)
      ASOSCommDates(449) = ASOSDATA("ST JOSEPH",
     &  "ROSECRANS MEMORIAL AIRPORT","MO",13993,"KSTJ","STJ",39.77,
     &  -94.9,"19960919","NO","FAA",33.00,10.05)
      ASOSCommDates(450) = ASOSDATA("ST LOUIS",
     &  "LAMBERT-ST LOUIS INTERNATIONAL AIRPORT","MO",13994,"KSTL",
     &  "STL",38.75,-90.37,"19960601","YES","NWS",33.00,10.05)
      ASOSCommDates(451) = ASOSDATA("ST LOUIS",
     &  "SPIRIT OF ST LOUIS AIRPORT","MO",3966,"KSUS","SUS",38.65,
     &  -90.65,"19980115","NO","FAA",26.00,7.92)
      ASOSCommDates(452) = ASOSDATA("WEST PLAINS",
     &  "WEST PLAINS MUNICIPAL AIRPORT","MO",53901,"KUNO","UNO",36.87,
     &  -91.9,"19960815","NO","FAA",33.00,10.05)
      ASOSCommDates(453) = ASOSDATA("GREENVILLE",
     &  "MID DELTA REGIONAL AIRPORT","MS",13939,"KGLH","GLH",33.48,
     &  -90.98,"20010815","NO","FAA",33.00,10.05)
      ASOSCommDates(454) = ASOSDATA("GREENWOOD",
     &  "GREENWOOD-LEFLORE AIRPORT","MS",13978,"KGWO","GWO",33.49,
     &  -90.08,"19970603","NO","FAA",33.00,10.05)
      ASOSCommDates(455) = ASOSDATA("GULFPORT",
     &  "GULFPORT-BILOXI INTERNATIONAL AIRPORT","MS",93874,"KGPT","GPT",
     &  30.4,-89.07,"19980812","NO","FAA",33.00,10.05)
      ASOSCommDates(456) = ASOSDATA("HATTIESBURG",
     &  "BOBBY L CHAIN MUNICIPAL AIRPORT","MS",13833,"KHBG","HBG",31.26,
     &  -89.25,"20000510","NO","FAA",33.00,10.05)
      ASOSCommDates(457) = ASOSDATA("JACKSON","HAWKINS FIELD AIRPORT",
     &  "MS",13927,"KHKS","HKS",32.33,-90.22,"20000720","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(458) = ASOSDATA("JACKSON",
     &  "JACKSON INTERNATIONAL AIRPORT","MS",3940,"KJAN","JAN",32.31,
     &  -90.07,"19930701","YES","NWS",33.00,10.05)
      ASOSCommDates(459) = ASOSDATA("MCCOMB",
     &  "MC COMB/PIKE COUNTY/JOHN E LEWIS FIELD AIRPORT","MS",93919,
     &  "KMCB","MCB",31.17,-90.47,"20000927","NO","FAA",33.00,10.05)
      ASOSCommDates(460) = ASOSDATA("MERIDIAN","KEY FIELD AIRPORT","MS",
     &  13865,"KMEI","MEI",32.33,-88.75,"19950701","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(461) = ASOSDATA("PASCAGOULA",
     &  "TRENT LOTT INTERNATIONAL AIRPORT","MS",53858,"KPQL","PQL",
     &  30.46,-88.53,"19970814","NO","FAA",26.00,7.92)
      ASOSCommDates(462) = ASOSDATA("TALLULAH/VICKSBURG",
     &  "VICKSBURG/TALLULAH REGIONAL AIRPORT","MS",3996,"KTVR","TVR",
     &  32.34,-91.03,"19960229","NO","FAA",33.00,10.05)
      ASOSCommDates(463) = ASOSDATA("TUPELO","TUPELO REGIONAL AIRPORT",
     &  "MS",93862,"KTUP","TUP",34.26,-88.77,"19930601","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(464) = ASOSDATA("BAKER","BAKER  MUNICIPAL AIRPORT",
     &  "MT",94055,"KBHK","BHK",46.35,-104.25,"19980219","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(465) = ASOSDATA("BILLINGS",
     &  "BILLINGS LOGAN INTERNATIONAL AIRPORT","MT",24033,"KBIL","BIL",
     &  45.8,-108.54,"19950501","YES","NWS",33.00,10.05)
      ASOSCommDates(466) = ASOSDATA("BOZEMAN","GALLATIN FIELD AIRPORT",
     &  "MT",24132,"KBZN","BZN",45.79,-111.15,"19950615","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(467) = ASOSDATA("BUTTE","BERT MOONEY AIRPORT","MT",
     &  24135,"KBTM","BTM",45.95,-112.51,"20001109","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(468) = ASOSDATA("CUT BANK",
     &  "CUT BANK MUNICIPAL AIRPORT","MT",24137,"KCTB","CTB",48.6,
     &  -112.37,"20010117","NO","FAA",33.00,10.05)
      ASOSCommDates(469) = ASOSDATA("DILLON","DILLON AIRPORT","MT",
     &  24138,"KDLN","DLN",45.25,-112.55,"19970514","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(470) = ASOSDATA("GLASGOW",
     &  "WOKAL FIELD/GLASGOW INTERNATIONAL AIRPORT","MT",94008,"KGGW",
     &  "GGW",48.21,-106.62,"19940401","YES","NWS",33.00,10.05)
      ASOSCommDates(471) = ASOSDATA("GREAT FALLS",
     &  "GREAT FALLS INTERNATIONAL AIRPORT","MT",24143,"KGTF","GTF",
     &  47.47,-111.38,"19940801","YES","NWS",33.00,10.05)
      ASOSCommDates(472) = ASOSDATA("HAVRE","HAVRE CITY-COUNTY AIRPORT",
     &  "MT",94012,"KHVR","HVR",48.55,-109.78,"19940401","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(473) = ASOSDATA("HELENA","HELENA REGIONAL AIRPORT",
     &  "MT",24144,"KHLN","HLN",46.6,-111.96,"19941101","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(474) = ASOSDATA("JORDAN","JORDAN AIRPORT","MT",
     &  94051,"KJDN","JDN",47.32,-106.94,"19970814","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(475) = ASOSDATA("KALISPELL",
     &  "GLACIER PARK INTERNATIONAL AIRPORT","MT",24146,"KGPI","GPI",
     &  48.3,-114.26,"19940201","YES","NWS",26.00,7.92)
      ASOSCommDates(476) = ASOSDATA("LEWISTOWN",
     &  "LEWISTOWN MUNICIPAL AIRPORT","MT",24036,"KLWT","LWT",47.04,
     &  -109.46,"20001214","NO","FAA",33.00,10.05)
      ASOSCommDates(477) = ASOSDATA("LIVINGSTON",
     &  "MISSION FIELD AIRPORT","MT",24150,"KLVM",
     &  "LVM",45.69,-110.44,"20001025","NO","FAA",33.00,10.05)
      ASOSCommDates(478) = ASOSDATA("MILES","FRANK WILEY FIELD AIRPORT",
     &  "MT",24037,"KMLS","MLS",46.42,-105.88,"20001102","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(479) = ASOSDATA("MISSOULA",
     &  "MISSOULA INTERNATIONAL AIRPORT","MT",24153,"KMSO","MSO",46.92,
     &  -114.09,"19960901","YES","NWS",33.00,10.05)
      ASOSCommDates(480) = ASOSDATA("WOLF POINT","L M CLAYTON AIRPORT",
     &  "MT",94017,"KOLF","OLF",48.09,-105.57,"19980917","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(481) = ASOSDATA("ASHEVILLE",
     &  "ASHEVILLE REGIONAL AIRPORT","NC",3812,"KAVL","AVL",35.43,
     &  -82.53,"19960601","YES","NWS",26.00,7.92)
      ASOSCommDates(482) = ASOSDATA("BEAUFORT",
     &  "MICHAEL J. SMITH FIELD AIRPORT","NC",93765,"KMRH","MRH",34.73,
     &  -76.66,"20000426","NO","FAA",33.00,10.05)
      ASOSCommDates(483) = ASOSDATA("BURLINGTON",
     &  "BURLINGTON ALAMANCE REGIONAL AIRPORT","NC",93783,"KBUY","BUY",
     &  36.04,-79.47,"19980701","NO","FAA",33.00,10.05)
      ASOSCommDates(484) = ASOSDATA("CAPE HATTERAS",
     &  "BILLY MITCHEL AIRPORT","NC",93729,"KHSE","HSE",35.23,-75.62,
     &  "19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(485) = ASOSDATA("CHAPEL HILL",
     &  "HORACE WILLIAMS AIRPORT","NC",93785,"KIGX","IGX",35.93,-79.06,
     &  "19990714","NO","FAA",33.00,10.05)
      ASOSCommDates(486) = ASOSDATA("CHARLOTTE",
     &  "CHARLOTTE/DOUGLAS INTERNATIONAL AIRPORT","NC",13881,"KCLT",
     &  "CLT",35.21,-80.94,"19980701","YES","NWS",33.00,10.05)
      ASOSCommDates(487) = ASOSDATA("ELIZABETH CITY",
     &  "ELIZABETH CITY CG AIR STATION/REGIONAL AIRPORT","NC",13786,
     &  "KECG","ECG",36.26,-76.17,"19980325","NO","FAA",33.00,10.05)
      ASOSCommDates(488) = ASOSDATA("FAYETTEVILLE",
     &  "FAYETTEVILLE REGIONAL/GRANNIS FIELD AIRPORT","NC",93740,"KFAY",
     &  "FAY",34.99,-78.88,"19980415","NO","FAA",33.00,10.05)
      ASOSCommDates(489) = ASOSDATA("GASTONIA",
     &  "GASTONIA MUNICIPAL AIRPORT","NC",53870,"KAKH","AKH",35.19,
     &  -81.15,"19990120","NO","FAA",33.00,10.05)
      ASOSCommDates(490) = ASOSDATA("GREENSBORO",
     &  "PIEDMONT TRIAD INTERNATIONAL AIRPORT","NC",13723,"KGSO","GSO",
     &  36.09,-79.94,"19951001","YES","NWS",33.00,10.05)
      ASOSCommDates(491) = ASOSDATA("HICKORY",
     &  "HICKORY REGIONAL AIRPORT","NC",3810,"KHKY","HKY",35.74,-81.38,
     &  "19970905","NO","FAA",26.00,7.92)
      ASOSCommDates(492) = ASOSDATA("LUMBERTON",
     &  "LUMBERTON MUNICIPAL AIRPORT","NC",13776,"KLBT","LBT",34.61,
     &  -79.05,"19980916","NO","FAA",33.00,10.05)
      ASOSCommDates(493) = ASOSDATA("MAXTON",
     &  "LAURINBURG-MAXTON AIRPORT","NC",93782,"KMEB","MEB",34.79,
     &  -79.36,"19980624","NO","FAA",33.00,10.05)
      ASOSCommDates(494) = ASOSDATA("MONROE","MONROE AIRPORT","NC",
     &  53872,"KEQY","EQY",35.01,-80.62,"19990127","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(495) = ASOSDATA("NEW BERN",
     &  "CRAVEN COUNTY REGIONAL AIRPORT","NC",93719,"KEWN","EWN",35.06,
     &  -77.04,"19970912","NO","FAA",26.00,7.92)
      ASOSCommDates(496) = ASOSDATA("RALEIGH/DURHAM",
     &  "RALEIGH-DURHAM INTERNATIONAL AIRPORT","NC",13722,"KRDU","RDU",
     &  35.87,-78.78,"19960201","YES","NWS",33.00,10.05)
      ASOSCommDates(497) = ASOSDATA("ROANOKE RAPIDS",
     &  "HALIFAX COUNTY AIRPORT","NC",93781,"KRZZ","RZZ",36.43,-77.7,
     &  "19980513","NO","FAA",33.00,10.05)
      ASOSCommDates(498) = ASOSDATA("ROCKY MOUNT",
     &  "ROCKY MOUNT-WILSON REGIONAL AIRPORT","NC",93759,"KRWI","RWI",
     &  35.85,-77.89,"20001011","NO","FAA",26.00,7.92)
      ASOSCommDates(499) = ASOSDATA("WILMINGTON",
     &  "WILMINGTON INTERNATIONAL AIRPORT","NC",13748,"KILM","ILM",
     &  34.26,-77.9,"19951101","YES","NWS",33.00,10.05)
      ASOSCommDates(500) = ASOSDATA("WINSTON SALEM",
     &  "SMITH REYNOLDS AIRPORT","NC",93807,"KINT","INT",36.13,-80.22,
     &  "19981202","NO","FAA",26.00,7.92)
      ASOSCommDates(501) = ASOSDATA("BISMARCK",
     &  "BISMARCK MUNICIPAL AIRPORT","ND",24011,"KBIS","BIS",46.77,
     &  -100.74,"19960501","YES","NWS",33.00,10.05)
      ASOSCommDates(502) = ASOSDATA("DICKINSON",
     &  "DICKINSON MUNICIPAL AIRPORT","ND",24012,"KDIK","DIK",46.79,
     &  -102.8,"20010621","NO","FAA",33.00,10.05)
      ASOSCommDates(503) = ASOSDATA("FARGO",
     &  "HECTOR INTERNATIONAL AIRPORT","ND",14914,"KFAR","FAR",46.92,
     &  -96.81,"19951101","YES","NWS",33.00,10.05)
      ASOSCommDates(504) = ASOSDATA("GARRISON","GARRISON","ND",94041,
     &  "KN60","N60",47.66,-101.43,"19980521","NO","NWS",33.00,10.05)
      ASOSCommDates(505) = ASOSDATA("GRAND FORKS",
     &  "GRAND FORKS INTERNATIONAL AIRPORT","ND",14916,"KGFK","GFK",
     &  47.94,-97.17,"19971218","YES","FAA",26.00,7.92)
      ASOSCommDates(506) = ASOSDATA("HETTINGER",
     &  "HETTINGER MUNICIPAL AIRPORT","ND",94038,"KHEI","HEI",46.01,
     &  -102.65,"19960313","NO","FAA",33.00,10.05)
      ASOSCommDates(507) = ASOSDATA("JAMESTOWN",
     &  "JAMESTOWN REGIONAL AIRPORT","ND",14919,
     &  "KJMS","JMS",46.92,-98.67,"20001005","NO","FAA",26.00,7.92)
      ASOSCommDates(508) = ASOSDATA("MINOT",
     &  "MINOT INTERNATIONAL AIRPORT","ND",24013,"KMOT",
     &  "MOT",48.25,-101.28,"20010726","NO","FAA",26.00,7.92)
      ASOSCommDates(509) = ASOSDATA("WILLISTON",
     &  "SLOULIN FIELD INTERNATIONAL AIRPORT","ND",94014,"KISN","ISN",
     &  48.19,-103.64,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(510) = ASOSDATA("ALLIANCE",
     &  "ALLIANCE MUNICIPAL AIRPORT","NE",24044,"KAIA","AIA",42.05,
     &  -102.8,"19960516","NO","FAA",33.00,10.05)
      ASOSCommDates(511) = ASOSDATA("BROKEN BOW",
     &  "BROKEN BOW MUNICIPAL AIRPORT","NE",94946,"KBBW","BBW",41.43,
     &  -99.63,"19990729","NO","FAA",33.00,10.05)
      ASOSCommDates(512) = ASOSDATA("CHADRON",
     &  "CHADRON MUNICIPAL AIRPORT","NE",24017,"KCDR","CDR",42.83,
     &  -103.09,"20000830","NO","FAA",33.00,10.05)
      ASOSCommDates(513) = ASOSDATA("FALLS CITY",
     &  "BRENNER FIELD AIRPORT","NE",94957,"KFNB","FNB",40.07,-95.59,
     &  "20000830","NO","FAA",33.00,10.05)
      ASOSCommDates(514) = ASOSDATA("GRAND ISLAND",
     &  "CENTRAL NEBRASKA REGIONAL AIRPORT","NE",14935,"KGRI","GRI",
     &  40.95,-98.31,"19921001","YES","NWS",26.00,7.92)
      ASOSCommDates(515) = ASOSDATA("HASTINGS",
     &  "HASTINGS MUNICIPAL AIRPORT","NE",94949,"KHSI","HSI",40.6,
     &  -98.42,"19950530","NO","FAA",26.00,7.92)
      ASOSCommDates(516) = ASOSDATA("IMPERIAL",
     &  "IMPERIAL MUNICIPAL AIRPORT","NE",24091,"KIML","IML",40.51,
     &  -101.62,"20000629","NO","FAA",33.00,10.05)
      ASOSCommDates(517) = ASOSDATA("LINCOLN",
     &  "LINCOLN MUNICIPAL AIRPORT","NE",14939,"KLNK","LNK",40.83,
     &  -96.76,"19921101","YES","NWS",33.00,10.05)
      ASOSCommDates(518) = ASOSDATA("MC COOK",
     &  "MC COOK MUNICIPAL AIRPORT","NE",94040,"KMCK","MCK",40.2,
     &  -100.59,"19961204","NO","FAA",33.00,10.05)
      ASOSCommDates(519) = ASOSDATA("NORFOLK",
     &  "KARL STEFAN MEMORIAL AIRPORT","NE",14941,"KOFK","OFK",41.98,
     &  -97.43,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(520) = ASOSDATA("NORTH PLATTE",
     &  "NORTH PLATT REGIONAL AIRPORT LEE BIRD FIELD AIRPORT","NE",
     &  24023,"KLBF","LBF",41.12,-100.66,"19960201","YES","NWS",26.00,
     &  7.92)
      ASOSCommDates(521) = ASOSDATA("OMAHA","EPPLEY AIRFIELD AIRPORT",
     &  "NE",14942,"KOMA","OMA",41.31,-95.89,"19960222","YES","FAA",
     &  33.00,10.05)
      ASOSCommDates(522) = ASOSDATA("ORD","EVELYN SHARP FIELD AIRPORT",
     &  "NE",94958,"KODX","ODX",41.62,-98.95,"20000830","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(523) = ASOSDATA("SCOTTSBLUFF",
     &  "WESTERN NEB. RGNL/WILLIAM B HEILIG FIELD AIRPORT","NE",24028,
     &  "KBFF","BFF",41.87,-103.59,"19950601","YES","NWS",26.00,7.92)
      ASOSCommDates(524) = ASOSDATA("SIDNEY","SIDNEY MUNICIPAL AIRPORT",
     &  "NE",24030,"KSNY","SNY",41.1,-102.98,"19951214","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(525) = ASOSDATA("TEKAMAH",
     &  "TEKAMAH MUNICIPAL AIRPORT","NE",94978,"KTQE","TQE",41.76,
     &  -96.17,"19950530","NO","FAA",33.00,10.05)
      ASOSCommDates(526) = ASOSDATA("VALENTINE","MILLER FIELD AIRPORT",
     &  "NE",24032,"KVTN","VTN",42.85,-100.55,"19951001","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(527) = ASOSDATA("BERLIN","BERLIN MUNICIPAL AIRPORT",
     &  "NH",94700,"KBML","BML",44.57,-71.17,"19950428","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(528) = ASOSDATA("CONCORD",
     &  "CONCORD MUNICIPAL AIRPORT","NH",14745,"KCON","CON",43.19,-71.5,
     &  "19960301","YES","NWS",26.00,7.92)
      ASOSCommDates(529) = ASOSDATA("JAFFREY",
     &  "JAFFREY MUNICIPAL - SILVER RANCH AIRPORT","NH",54770,"KAFN",
     &  "AFN",42.8,-72.,"19950524","NO","FAA",33.00,10.05)
      ASOSCommDates(530) = ASOSDATA("LEBANON",
     &  "LEBANON MUNICIPAL AIRPORT","NH",94765,"KLEB","LEB",43.62,-72.3,
     &  "19980513","NO","FAA",33.00,10.05)
      ASOSCommDates(531) = ASOSDATA("MANCHESTER","MANCHESTER AIRPORT",
     &  "NH",14710,"KMHT","MHT",42.93,-71.43,"19971114","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(532) = ASOSDATA("ROCHESTER","SKYHAVEN AIRPORT","NH",
     &  54791,"KDAW","DAW",43.27,-70.92,"20000119","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(533) = ASOSDATA("WHITEFIELD",
     &  "MOUNT WASHINGTON REGIONAL AIRPORT","NH",54728,"KHIE","HIE",
     &  44.36,-71.54,"19950518","NO","FAA",26.00,7.92)
      ASOSCommDates(534) = ASOSDATA("ANDOVER",
     &  "AEROFLEX-ANDOVER AIRPORT","NJ",54779,"K12N","12N",41.,-74.73,
     &  "19980817","NO","NWS",33.00,10.05)
      ASOSCommDates(535) = ASOSDATA("ATLANTIC CITY",
     &  "ATLANTIC CITY INTERNATIONAL AIRPORT","NJ",93730,"KACY","ACY",
     &  39.45,-74.45,"19950901","YES","NWS",26.00,7.92)
      ASOSCommDates(536) = ASOSDATA("CALDWELL","ESSEX COUNTY AIRPORT",
     &  "NJ",54743,"KCDW","CDW",40.87,-74.28,"19990602","NO","NWS",
     &  26.00,7.92)
      ASOSCommDates(537) = ASOSDATA("MILLVILLE",
     &  "MILLVILLE MUNICIPAL AIRPORT","NJ",13735,"KMIV","MIV",39.36,
     &  -75.07,"19990217","NO","FAA",26.00,7.92)
      ASOSCommDates(538) = ASOSDATA("MOUNT HOLLY",
     &  "SOUTH JERSEY REGIONAL AIRPORT","NJ",93780,"KVAY","VAY",39.94,
     &  -74.84,"19971105","NO","FAA",33.00,10.05)
      ASOSCommDates(539) = ASOSDATA("NEWARK",
     &  "NEWARK LIBERTY INTERNATIONAL AIRPORT","NJ",14734,"KEWR","EWR",
     &  40.71,-74.16,"19960701","YES","NWS",33.00,10.05)
      ASOSCommDates(540) = ASOSDATA("SOMERVILLE","SOMERSET AIRPORT",
     &  "NJ",54785,"KSMQ","SMQ",40.62,-74.66,"19990602","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(541) = ASOSDATA("SUSSEX","SUSSEX AIRPORT","NJ",
     &  54793,"KFWN","FWN",41.2,-74.62,"20001025","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(542) = ASOSDATA("TETERBORO","TETERBORO AIRPORT",
     &  "NJ",94741,"KTEB","TEB",40.85,-74.06,"19970101","NO","NWS",
     &  26.00,7.92)
      ASOSCommDates(543) = ASOSDATA("TRENTON","TRENTON MERCER AIRPORT",
     &  "NJ",14792,"KTTN","TTN",40.27,-74.81,"19980311","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(544) = ASOSDATA("ALBUQUERQUE",
     &  "ALBUQUERQUE INTERNATIONAL SUNPORT AIRPORT","NM",23050,"KABQ",
     &  "ABQ",35.04,-106.61,"19960301","YES","NWS",33.00,10.05)
      ASOSCommDates(545) = ASOSDATA("CARLSBAD",
     &  "CAVERN CITY AIR TERMINAL AIRPORT","NM",93033,"KCNM","CNM",
     &  32.33,-104.26,"20001129","NO","FAA",33.00,10.05)
      ASOSCommDates(546) = ASOSDATA("CLAYTON",
     &  "CLAYTON MUNICIPAL AIRPARK AIRPORT","NM",23051,"KCAO","CAO",
     &  36.44,-103.15,"19960601","YES","NWS",33.00,10.05)
      ASOSCommDates(547) = ASOSDATA("CLINES CORNERS","CLINES CORNERS",
     &  "NM",3027,"KCQC","CQC",35.,-105.66,"19980527","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(548) = ASOSDATA("DEMING","DEMING MUNICIPAL AIRPORT",
     &  "NM",23078,"KDMN","DMN",32.26,-107.72,"20000830","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(549) = ASOSDATA("FARMINGTON",
     &  "FOUR CORNERS REGIONAL AIRPORT","NM",23090,"KFMN","FMN",36.74,
     &  -108.22,"19971210","NO","NWS",33.00,10.05)
      ASOSCommDates(550) = ASOSDATA("GALLUP","GALLUP MUNICIPAL AIRPORT",
     &  "NM",23081,"KGUP","GUP",35.51,-108.78,"20001011","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(551) = ASOSDATA("GRANTS",
     &  "GRANTS-MILAN MUNICIPAL AIRPORT","NM",93057,"KGNT","GNT",35.16,
     &  -107.9,"19971001","NO","NWS",33.00,10.05)
      ASOSCommDates(552) = ASOSDATA("LAS VEGAS",
     &  "LAS VEGAS MUNICIPAL AIRPORT","NM",23054,"KLVS","LVS",35.65,
     &  -105.14,"20001011","NO","FAA",33.00,10.05)
      ASOSCommDates(553) = ASOSDATA("RATON",
     &  "RATON MUNICIPAL/CREWS FIELD AIRPORT","NM",23052,"KRTN","RTN",
     &  36.74,-104.5,"19980827","NO","NWS",33.00,10.05)
      ASOSCommDates(554) = ASOSDATA("ROSWELL",
     &  "ROSWELL INDUSTRIAL AIR CENTER AIRPORT","NM",23009,"KROW","ROW",
     &  33.3,-104.54,"19961001","YES","NWS",26.00,7.92)
      ASOSCommDates(555) = ASOSDATA("SANTA FE",
     &  "SANTA FE MUNICIPAL AIRPORT","NM",23049,"KSAF","SAF",35.61,
     &  -106.08,"19971002","NO","FAA",26.00,7.92)
      ASOSCommDates(556) = ASOSDATA("TRUTH OR CONSEQUENCES",
     &  "TRUTH OR CONSEQUENCES MUNICIPAL AIRPORT","NM",93045,"KTCS",
     &  "TCS",33.23,-107.26,"19960916","NO","NWS",26.00,7.92)
      ASOSCommDates(557) = ASOSDATA("TUCUMCARI",
     &  "TUCUMCARI MUNICIPAL AIRPORT","NM",23048,"KTCC","TCC",35.18,
     &  -103.6,"20000906","NO","FAA",33.00,10.05)
      ASOSCommDates(558) = ASOSDATA("ELKO","ELKO REGIONAL AIRPORT","NV",
     &  24121,"KEKO","EKO",40.82,-115.79,"20010214","YES","FAA",33.00,
     &  10.05)
      ASOSCommDates(559) = ASOSDATA("ELY",
     &  "ELY AIRPORT/YELLAND FIELD/AIRPORT","NV",23154,"KELY","ELY",
     &  39.29,-114.84,"19940601","YES","NWS",33.00,10.05)
      ASOSCommDates(560) = ASOSDATA("EUREKA","EUREKA","NV",3170,"KP68",
     &  "P68",39.6,-116.,"19970813","NO","NWS",33.00,10.05)
      ASOSCommDates(561) = ASOSDATA("LAS VAGAS",
     &  "NORTH LAS VEGAS AIRPORT","NV",53123,"KVGT","VGT",36.21,-115.19,
     &  "20000928","NO","FAA",33.00,10.05)
      ASOSCommDates(562) = ASOSDATA("LAS VEGAS",
     &  "MCCARRAN INTERNATIONAL AIRPORT","NV",23169,"KLAS","LAS",36.07,
     &  -115.15,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(563) = ASOSDATA("LOVELOCK",
     &  "DERBY FIELD AIRPORT","NV",24172,"KLOL",
     &  "LOL",40.06,-118.56,"20001206","NO","FAA",33.00,10.05)
      ASOSCommDates(564) = ASOSDATA("MERCURY","DESERT ROCK AIRPORT",
     &  "NV",3160,"KDRA","DRA",36.62,-116.02,"19960701","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(565) = ASOSDATA("RENO",
     &  "RENO/TAHOE INTERNATIONAL AIRPORT","NV",23185,"KRNO","RNO",
     &  39.48,-119.77,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(566) = ASOSDATA("TONOPAH","TONOPAH AIRPORT","NV",
     &  23153,"KTPH","TPH",38.06,-117.08,"20001129","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(567) = ASOSDATA("WINNEMUCCA",
     &  "WINNEMUCCA MUNICIPAL AIRPORT","NV",24128,"KWMC","WMC",40.9,
     &  -117.8,"19941001","YES","NWS",33.00,10.05)
      ASOSCommDates(568) = ASOSDATA("ALBANY",
     &  "ALBANY INTERNATIONAL AIRPORT","NY",14735,"KALB","ALB",42.74,
     &  -73.8,"19950801","YES","NWS",33.00,10.05)
      ASOSCommDates(569) = ASOSDATA("BINGHAMTON",
     &  "GREATER BINGHAMTON/EDWIN A LINK FIELD AIRPORT","NY",4725,
     &  "KBGM","BGM",42.2,-75.98,"19951101","YES","NWS",26.00,7.92)
      ASOSCommDates(570) = ASOSDATA("BUFFALO",
     &  "BUFFALO NIAGARA INTERNATIONAL AIRPORT","NY",14733,"KBUF","BUF",
     &  42.94,-78.73,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(571) = ASOSDATA("DANSVILLE",
     &  "DANSVILLE MUNICIPAL AIRPORT","NY",94704,"KDSV","DSV",42.57,
     &  -77.71,"20000301","NO","FAA",33.00,10.05)
      ASOSCommDates(572) = ASOSDATA("DUNKIRK",
     &  "CHAUTAUQUA COUNTY/DUNKIRK AIRPORT","NY",14747,"KDKK","DKK",
     &  42.49,-79.27,"19961211","NO","FAA",33.00,10.05)
      ASOSCommDates(573) = ASOSDATA("ELMIRA/CORNING",
     &  "ELMIRA/CORNING REGIONAL AIRPORT","NY",14748,"KELM","ELM",42.15,
     &  -76.89,"19971217","NO","FAA",33.00,10.05)
      ASOSCommDates(574) = ASOSDATA("FARMINGDALE","REPUBLIC AIRPORT",
     &  "NY",54787,"KFRG","FRG",40.73,-73.41,"19990804","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(575) = ASOSDATA("FULTON","OSWEGO COUNTY AIRPORT",
     &  "NY",54773,"KFZY","FZY",43.34,-76.38,"19970601","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(576) = ASOSDATA("GLEN FALLS",
     &  "FLOYD BENNETT MEMORIAL AIRPORT","NY",14750,"KGFL","GFL",43.34,
     &  -73.61,"20010718","NO","FAA",33.00,10.05)
      ASOSCommDates(577) = ASOSDATA("ISLIP",
     &  "LONG ISLAND MAC ARTHUR AIRPORT","NY",4781,"KISP","ISP",40.79,
     &  -73.1,"19990801","YES","FAA",26.00,7.92)
      ASOSCommDates(578) = ASOSDATA("MASSENA",
     &  "MASSENA INTERNATIONAL-RICHARDS FIELD AIRPORT","NY",94725,
     &  "KMSS","MSS",44.93,-74.84,"20000913","NO","FAA",33.00,10.05)
      ASOSCommDates(579) = ASOSDATA("MONTAUK","MONTAUK AIRPORT","NY",
     &  54780,"KMTP","MTP",41.07,-71.92,"19980901","NO","NWS",
     &  19.00,5.79)
      ASOSCommDates(580) = ASOSDATA("MONTGOMERY",
     &  "ORANGE COUNTY AIRPORT","NY",4789,"KMGJ","MGJ",41.5,-74.26,
     &  "19971217","NO","FAA",33.00,10.05)
      ASOSCommDates(581) = ASOSDATA("NEW YORK",
     &  "JOHN F KENNEDY INTERNATIONAL AIRPORT","NY",94789,"KJFK","JFK",
     &  40.65,-73.79,"19960501","YES","NWS",33.00,10.05)
      ASOSCommDates(582) = ASOSDATA("NEW YORK","LA GUARDIA AIRPORT",
     &  "NY",14732,"KLGA","LGA",40.77,-73.88,"19960501","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(583) = ASOSDATA("NEW YORK ","CENTRAL PARK","NY",
     &  94728,"KNYC","NYC",40.78,-73.96,"19951101","YES","NWS",
     &  -9.0,-9.0)
      ASOSCommDates(584) = ASOSDATA("NIAGARA FALLS",
     &  "NIAGARA FALLS INTERNATIONAL AIRPORT","NY",4724,"KIAG","IAG",
     &  43.1,-78.94,"20010926","NO","FAA",33.00,10.05)
      ASOSCommDates(585) = ASOSDATA("PLATTSBURGH",
     &  "PLATTSBURG INTERNATIONAL AIRPORT","NY",04742,"KPBG","PBG",
     &  44.65,-73.46,"20070618","NO","FAA",-9.,-9.)
      ASOSCommDates(586) = ASOSDATA("PENN YAN","PENN YAN AIRPORT","NY",
     &  54778,"KPEO","PEO",42.64,-77.05,"19971210","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(587) = ASOSDATA("PLATTSBURGH",
     &  "CLINTON COUNTY AIRPORT (CLOSED 5/9/2007)","NY",94733,"KPLB",
     &  "PLB",44.68,-73.52,"19980701","NO","FAA",26.00,7.92)
      ASOSCommDates(588) = ASOSDATA("POUGHKEEPSIE",
     &  "DUTCHESS COUNTY AIRPORT","NY",14757,"KPOU","POU",41.62,-73.88,
     &  "20000927","NO","FAA",26.00,7.92)
      ASOSCommDates(589) = ASOSDATA("ROCHESTER",
     &  "GREATER ROCHESTER INTERNATION AIRPORT","NY",14768,"KROC","ROC",
     &  43.11,-77.67,"19960701","YES","NWS",33.00,10.05)
      ASOSCommDates(590) = ASOSDATA("SARANAC LAKE",
     &  "ADIRONDACK REGIONAL AIRPORT","NY",94740,"KSLK","SLK",44.38,
     &  -74.2,"19980610","NO","FAA",26.00,7.92)
      ASOSCommDates(591) = ASOSDATA("SHIRLEY","BROOKHAVEN AIRPORT","NY",
     &  54790,"KHWV","HWV",40.82,-72.86,"19990929","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(592) = ASOSDATA("SYRACUSE",
     &  "SYRACUSE HANCOCK INTERNATIONAL AIRPORT","NY",14771,"KSYR",
     &  "SYR",43.1,-76.1,"19931101","YES","NWS",33.00,10.05)
      ASOSCommDates(593) = ASOSDATA("UTICA",
     &  "ONEIDA COUNTY AIRPORT (closed 011807)","NY",94794,"KUCA","UCA",
     &  43.14,-72.38,"20010131","NO","FAA",26.00,7.92)
      ASOSCommDates(594) = ASOSDATA("WATERTOWN",
     &  "WATERTOWN INTERNATIONAL AIRPORT","NY",94790,"KART","ART",43.99,
     &  -76.02,"20010124","NO","FAA",26.00,7.92)
      ASOSCommDates(595) = ASOSDATA("WELLSVILLE","WELLSVILLE MUNI ARPT,
     &  TARANTINE FIELD AIRPORT","NY",54757,"KELZ","ELZ",42.1,-77.99,
     &  "20000202","NO","FAA",33.00,10.05)
      ASOSCommDates(596) = ASOSDATA("WESTHAMPTON BEACH",
     &  "FRANCIS S GABRESKI AIRPORT","NY",14719,"KFOK","FOK",40.84,
     &  -72.63,"19980722","NO","FAA",33.00,10.05)
      ASOSCommDates(597) = ASOSDATA("WHITE PLAINS",
     &  "WESTCHESTER COUNTY AIRPORT","NY",94745,"KHPN","HPN",41.06,
     &  -73.7,"20010425","NO","FAA",33.00,10.05)
      ASOSCommDates(598) = ASOSDATA("AKRON",
     &  "AKRON FULTON INTERNATIONAL AIRPORT","OH",14813,"KAKR","AKR",
     &  41.03,-81.46,"19990519","NO","FAA",33.00,10.05)
      ASOSCommDates(599) = ASOSDATA("AKRON",
     &  "AKRON-CANTON REGIONAL AIRPORT","OH",14895,"KCAK","CAK",40.91,
     &  -81.44,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(600) = ASOSDATA("ASHTABULA",
     &  "ASHTABULA COUNTY AIRPORT","OH",4857,"KHZY","HZY",41.77,-80.69,
     &  "19981202","NO","FAA",33.00,10.05)
      ASOSCommDates(601) = ASOSDATA("CINCINNATI",
     &  "CINCINNATI MUNICIPAL AIRPORT/LUNKEN FIELD AIRPORT","OH",93812,
     &  "KLUK","LUK",39.1,-84.41,"19970813","NO","FAA",33.00,10.05)
      ASOSCommDates(602) = ASOSDATA("CLEVELAND",
     &  "CLEVELAND BURKE LAKEFRONT AIRPORT","OH",4853,"KBKL","BKL",
     &  41.51,-81.68,"19980211","NO","FAA",26.00,7.92)
      ASOSCommDates(603) = ASOSDATA("CLEVELAND",
     &  "CLEVELAND-HOPKINS INTERNATIONAL AIRPORT","OH",14820,"KCLE",
     &  "CLE",41.4,-81.85,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(604) = ASOSDATA("COLUMBUS",
     &  "PORT COLUMBUS INTERNATIONAL AIRPORT","OH",14821,"KCMH","CMH",
     &  39.99,-82.88,"19960201","YES","NWS",33.00,10.05)
      ASOSCommDates(605) = ASOSDATA("COLUMBUS",
     &  "OHIO STATE UNIVERSITY AIRPORT","OH",4804,"KOSU","OSU",40.07,
     &  -83.07,"19971008","NO","FAA",26.00,7.92)
      ASOSCommDates(606) = ASOSDATA("COVINGTON/CINCINNATI",
     &  "CINCINNATI/NORTHERN KY INTERNATIONAL AIRPORT","OH",93814,
     &  "KCVG","CVG",39.04,-84.67,"19951001","YES","NWS",33.00,10.05)
      ASOSCommDates(607) = ASOSDATA("DAYTON",
     &  "JAMES M COX DAYTON INTERNATIONAL AIRPORT","OH",93815,"KDAY",
     &  "DAY",39.9,-84.21,"19951101","YES","NWS",33.00,10.05)
      ASOSCommDates(608) = ASOSDATA("DAYTON",
     &  "DAYTON WRIGHT BROTHERS AIRPORT","OH",53859,"KMGY","MGY",39.59,
     &  -84.22,"19971015","NO","FAA",26.00,7.92)
      ASOSCommDates(609) = ASOSDATA("DEFIANCE",
     &  "DEFIANCE MEMORIAL AIRPORT","OH",4851,"KDFI","DFI",41.33,-84.42,
     &  "19980107","NO","FAA",33.00,10.05)
      ASOSCommDates(610) = ASOSDATA("FINDLAY","FINDLAY AIRPORT","OH",
     &  14825,"KFDY","FDY",41.01,-83.66,"20000816","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(611) = ASOSDATA("HAMILTON",
     &  "BUTLER COUNTY REGIONAL AIRPORT","OH",53855,"KHAO","HAO",39.36,
     &  -84.52,"19970515","NO","FAA",33.00,10.05)
      ASOSCommDates(612) = ASOSDATA("LANCASTER",
     &  "FAIRFIELD COUNTY AIRPORT","OH",53844,"KLHQ","LHQ",39.75,-82.65,
     &  "19960320","NO","FAA",33.00,10.05)
      ASOSCommDates(613) = ASOSDATA("LIMA","LIMA ALLEN COUNTY AIRPORT",
     &  "OH",4850,"KAOH","AOH",40.7,-84.02,"19980128","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(614) = ASOSDATA("LORAIN/ELYRIA",
     &  "LORAIN COUNTY REGIONAL AIRPORT","OH",4849,"KLPR","LPR",41.17,
     &  -82.17,"19970425","NO","FAA",33.00,10.05)
      ASOSCommDates(615) = ASOSDATA("MANSFIELD",
     &  "MANSFIELD LAHM MUNICIPAL AIRPORT","OH",14891,"KMFD","MFD",
     &  40.82,-82.51,"19960201","YES","NWS",33.00,10.05)
      ASOSCommDates(616) = ASOSDATA("MARION","MARION MUNICIPAL AIRPORT",
     &  "OH",4855,"KMNN","MNN",40.61,-83.06,"19980506","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(617) = ASOSDATA("NEW PHILADELPHIA",
     &  "HARRY CLEVER FIELD AIRPORT","OH",4852,"KPHD","PHD",40.47,
     &  -81.42,"19980128","NO","FAA",33.00,10.05)
      ASOSCommDates(618) = ASOSDATA("NEWARK","NEWARK-HEATH AIRPORT",
     &  "OH",4858,"KVTA","VTA",40.02,-82.46,"19990224","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(619) = ASOSDATA("TOLEDO","METCALF FIELD AIRPORT",
     &  "OH",4848,"KTDZ","TDZ",41.56,-83.47,"19971217","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(620) = ASOSDATA("TOLEDO","TOLEDO EXPRESS AIRPORT",
     &  "OH",94830,"KTOL","TOL",41.58,-83.8,"19951201","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(621) = ASOSDATA("WILMINGTON",
     &  "AIRBORNE AIRPARK AIRPORT","OH",13841,"KILN","ILN",39.42,-83.82,
     &  "19980401","NO","NWS",33.00,10.05)
      ASOSCommDates(622) = ASOSDATA("WOOSTER","WAYNE COUNTY AIRPORT",
     &  "OH",4842,"KBJJ","BJJ",40.87,-81.88,"19961211","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(623) = ASOSDATA("YOUNGSTOWN/WARREN",
     &  "YOUNGSTOWN-WARREN REGIONAL AIRPORT","OH",14852,"KYNG","YNG",
     &  41.25,-80.67,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(624) = ASOSDATA("ZANESVILLE",
     &  "ZANESVILLE MUNICIPAL AIRPORT","OH",93824,"KZZV","ZZV",39.94,
     &  -81.89,"20000913","NO","FAA",26.00,7.92)
      ASOSCommDates(625) = ASOSDATA("CLINTON","CLINTON-SHERMAN AIRPORT",
     &  "OK",3932,"KCSM","CSM",35.33,-99.2,"19961015","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(626) = ASOSDATA("FREDERICK",
     &  "FREDERICK MUNICIPAL AIRPORT","OK",3981,"KFDR","FDR",34.35,
     &  -98.98,"19980128","NO","FAA",33.00,10.05)
      ASOSCommDates(627) = ASOSDATA("GAGE","GAGE AIRPORT","OK",13975,
     &  "KGAG","GAG",36.29,-99.77,"19961031","NO","FAA",33.00,10.05)
      ASOSCommDates(628) = ASOSDATA("GUTHRIE",
     &  "GUTHRIE MUNICIPAL AIRPORT","OK",53913,"KGOK","GOK",35.85,
     &  -97.41,"19980409","NO","FAA",33.00,10.05)
      ASOSCommDates(629) = ASOSDATA("GUYMON","GUYMON MUNICIPAL AIRPORT",
     &  "OK",3030,"KGUY","GUY",36.68,-101.5,"19981201","NO","NWS",26.00,
     &  7.92)
      ASOSCommDates(630) = ASOSDATA("HOBART","HOBART MUNICIPAL AIRPORT",
     &  "OK",93986,"KHBR","HBR",35.,-99.05,"19960731","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(631) = ASOSDATA("LAWTON",
     &  "LAWTON-FORT SILL REGIONAL AIRPORT","OK",3950,"KLAW","LAW",
     &  34.56,-98.41,"19960913","NO","FAA",33.00,10.05)
      ASOSCommDates(632) = ASOSDATA("MC ALESTER",
     &  "MC ALESTER REGIONAL AIRPORT","OK",93950,"KMLC","MLC",34.89,
     &  -95.78,"19960715","NO","FAA",33.00,10.05)
      ASOSCommDates(633) = ASOSDATA("MUSKOGEE","DAVIS FIELD AIRPORT",
     &  "OK",93953,"KMKO","MKO",35.65,-95.36,"19960712","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(634) = ASOSDATA("OKLAHOMA CITY",
     &  "WILL ROGERS WORLD AIRPORT","OK",13967,"KOKC","OKC",35.38,-97.6,
     &  "19921001","YES","NWS",26.00,7.92)
      ASOSCommDates(635) = ASOSDATA("OKLAHOMA CITY",
     &  "WILEY POST AIRPORT","OK",3954,"KPWA","PWA",35.53,-97.64,
     &  "19960731","NO","FAA",26.00,7.92)
      ASOSCommDates(636) = ASOSDATA("PONCA CITY",
     &  "PONCA CITY REGIONAL AIRPORT","OK",13969,"KPNC","PNC",36.73,
     &  -97.09,"20001108","NO","FAA",33.00,10.05)
      ASOSCommDates(637) = ASOSDATA("STILLWATER",
     &  "STILLWATER REGIONAL AIRPORT","OK",3965,"KSWO","SWO",36.16,
     &  -97.08,"19961015","NO","FAA",33.00,10.05)
      ASOSCommDates(638) = ASOSDATA("TULSA",
     &  "RICHARD LLOYD JONES JR AIRPORT","OK",53908,"KRVS","RVS",36.03,
     &  -95.98,"19970904","NO","FAA",33.00,10.05)
      ASOSCommDates(639) = ASOSDATA("TULSA",
     &  "TULSA INTERNATIONAL AIRPORT","OK",13968,"KTUL","TUL",36.19,
     &  -95.88,"19921001","YES","NWS",33.00,10.05)
      ASOSCommDates(640) = ASOSDATA("ASTORIA",
     &  "ASTORIA REGIONAL AIRPORT","OR",94224,"KAST","AST",46.15,
     &  -123.87,"19930301","YES","NWS",33.00,10.05)
      ASOSCommDates(641) = ASOSDATA("AURORA","AURORA STATE AIRPORT",
     &  "OR",94281,"KUAO","UAO",45.24,-122.76,"19970129","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(642) = ASOSDATA("BAKER CITY",
     &  "BAKER CITY MUNICIPAL AIRPORT","OR",24130,"KBKE","BKE",44.83,
     &  -117.8,"20011025","NO","FAA",33.00,10.05)
      ASOSCommDates(643) = ASOSDATA("BURNS","BURNS MUNICIPAL AIRPORT",
     &  "OR",94185,"KBNO","BNO",43.59,-118.95,"19950701","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(644) = ASOSDATA("EUGENE",
     &  "MAHLON SWEET FIELD AIRPORT","OR",24221,"KEUG","EUG",44.13,
     &  -123.21,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(645) = ASOSDATA("HERMISTON",
     &  "HERMISTON MUNICIPAL AIRPORT","OR",4113,"KHRI","HRI",45.82,
     &  -119.26,"19980313","NO","FAA",33.00,10.05)
      ASOSCommDates(646) = ASOSDATA("KLAMATH FALLS",
     &  "KLAMATH FALLS AIRPORT","OR",94236,"KLMT","LMT",42.14,-121.72,
     &  "19971015","NO","FAA",33.00,10.05)
      ASOSCommDates(647) = ASOSDATA("MC MINNVILLE",
     &  "MC MINNVILLE MUNICIPAL AIRPORT","OR",94273,"KMMV","MMV",45.19,
     &  -123.13,"19970129","NO","FAA",33.00,10.05)
      ASOSCommDates(648) = ASOSDATA("MEACHAM","MEACHAM","OR",24152,
     &  "KMEH","MEH",45.51,-118.42,"19980507","NO","NWS",33.00,10.05)
      ASOSCommDates(649) = ASOSDATA("MEDFORD",
     &  "ROGUE VALLEY INTERNATIONAL-MEDFORD AIRPORT","OR",24225,"KMFR",
     &  "MFR",42.38,-122.87,"19980101","YES","NWS",33.00,10.05)
      ASOSCommDates(650) = ASOSDATA("ONTARIO",
     &  "ONTARIO MUNICIPAL AIRPORT","OR",24162,"KONO","ONO",44.02,
     &  -117.01,"19970409","NO","FAA",33.00,10.05)
      ASOSCommDates(651) = ASOSDATA("PENDLETON",
     &  "EASTERN OREGON REGIONAL AT PENDLETON AIRPORT","OR",24155,
     &  "KPDT","PDT",45.69,-118.83,"19950601","YES","NWS",33.00,10.05)
      ASOSCommDates(652) = ASOSDATA("PORTLAND",
     &  "PORTLAND-HILLSBORO AIRPORT","OR",94261,"KHIO","HIO",45.54,
     &  -122.94,"19980618","NO","FAA",33.00,10.05)
      ASOSCommDates(653) = ASOSDATA("PORTLAND",
     &  "PORTLAND INTERNATIONAL AIRPORT","OR",24229,"KPDX","PDX",45.59,
     &  -122.6,"19951101","YES","NWS",33.00,10.05)
      ASOSCommDates(654) = ASOSDATA("PORTLAND",
     &  "PORTLAND-TROUTDALE AIRPORT","OR",24242,"KTTD","TTD",45.54,
     &  -122.4,"19980625","NO","FAA",33.00,10.05)
      ASOSCommDates(655) = ASOSDATA("REDMOND",
     &  "ROBERTS FIELD AIRPORT","OR",24230,"KRDM",
     &  "RDM",44.25,-121.15,"20000420","NO","FAA",33.00,10.05)
      ASOSCommDates(656) = ASOSDATA("ROME","ROME STATE AIRPORT","OR",
     &  94107,"KREO","REO",42.59,-117.86,"19980318","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(657) = ASOSDATA("ROSEBURG",
     &  "ROSEBURG REGIONAL AIRPORT","OR",24231,"KRBG","RBG",43.23,
     &  -123.35,"19970625","NO","FAA",33.00,10.05)
      ASOSCommDates(658) = ASOSDATA("SALEM","MCNARY FIELD AIRPORT","OR",
     &  24232,"KSLE","SLE",44.9,-122.99,"19950701","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(659) = ASOSDATA("SCAPPOOSE",
     &  "SCAPPOOSE INDUSTRIAL AIRPARK AIRPORT","OR",4201,"KSPB","SPB",
     &  45.77,-122.86,"19980827","NO","FAA",33.00,10.05)
      ASOSCommDates(660) = ASOSDATA("SEXTON SUMMIT","SEXTON SUMMIT",
     &  "OR",24235,"KSXT","SXT",42.61,-123.38,"19930101","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(661) = ASOSDATA("THE DALLES",
     &  "COLUMBIA GORGE RGNL/THE DALLES MUNICIPAL AIRPORT","OR",24219,
     &  "KDLS","DLS",45.61,-121.16,"20001026","NO","FAA",33.00,10.05)
      ASOSCommDates(662) = ASOSDATA("ALLENTOWN",
     &  "LEHIGH VALLEY INTERNATIONAL AIRPORT","PA",14737,"KABE","ABE",
     &  40.65,-75.44,"19951101","YES","NWS",26.00,7.92)
      ASOSCommDates(663) = ASOSDATA("ALTOONA",
     &  "ALTOONA-BLAIR COUNTY AIRPORT","PA",14736,"KAOO","AOO",40.3,
     &  -78.31,"19990714","NO","FAA",26.00,7.92)
      ASOSCommDates(664) = ASOSDATA("BRADFORD",
     &  "BRADFORD REGIONAL AIRPORT","PA",4751,"KBFD","BFD",41.8,-78.64,
     &  "19961202","NO","FAA",26.00,7.92)
      ASOSCommDates(665) = ASOSDATA("CLEARFIELD",
     &  "CLEARFIELD - LAWRENCE AIRPORT","PA",54792,"KFIG","FIG",41.04,
     &  -78.41,"20000126","NO","FAA",33.00,10.05)
      ASOSCommDates(666) = ASOSDATA("DOYLESTOWN","DOYLESTOWN AIRPORT",
     &  "PA",54786,"KDYL","DYL",40.33,-75.12,"19990728","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(667) = ASOSDATA("DU BOIS",
     &  "DU BOIS-JEFFERSON COUNTY AIRPORT","PA",4787,"KDUJ","DUJ",41.17,
     &  -78.89,"20000614","NO","FAA",26.00,7.92)
      ASOSCommDates(668) = ASOSDATA("ERIE",
     &  "ERIE INTERNATIONAL/TOM RIDGE FIELD AIRPORT","PA",14860,"KERI",
     &  "ERI",42.08,-80.18,"19951001","YES","NWS",33.00,10.05)
      ASOSCommDates(669) = ASOSDATA("HARRISBURG","CAPITAL CITY AIRPORT",
     &  "PA",14751,"KCXY","CXY",40.21,-76.85,"20001011","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(670) = ASOSDATA("HARRISBURG",
     &  "HARRISBURG INTERNATIONAL AIRPORT","PA",14711,"KMDT",
     &  "MDT",40.19,-76.76,"20001201","YES","FAA",26.00,7.92)
      ASOSCommDates(671) = ASOSDATA("JOHNSTOWN",
     &  "JOHN MURTHA JOHNSTOWN-CAMBRIA COUNTY AIRPORT","PA",4726,"KJST",
     &  "JST",40.3,-78.83,"20000830","NO","FAA",26.00,7.92)
      ASOSCommDates(672) = ASOSDATA("LANCASTER","LANCASTER AIRPORT",
     &  "PA",54737,"KLNS","LNS",40.12,-76.29,"19990317","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(673) = ASOSDATA("MEADVILLE",
     &  "PORT MEADVILLE AIRPORT","PA",4843,"KGKJ","GKJ",41.62,-80.21,
     &  "19970122","NO","FAA",33.00,10.05)
      ASOSCommDates(674) = ASOSDATA("MOUNT POCONO",
     &  "POCONO MOUNTAINS MUNICIPAL AIRPORT","PA",54789,"KMPO","MPO",
     &  41.13,-75.37,"19990929","NO","FAA",33.00,10.05)
      ASOSCommDates(675) = ASOSDATA("PHILADELPHIA",
     &  "PHILADELPHIA INTERNATIONAL AIRPORT","PA",13739,"KPHL","PHL",
     &  39.86,-75.23,"19951201","YES","NWS",26.00,7.92)
      ASOSCommDates(676) = ASOSDATA("PHILADELPHIA",
     &  "NORTHEAST PHILADELPHIA AIRPORT","PA",94732,"KPNE","PNE",40.08,
     &  -75.01,"19960501","NO","NWS",33.00,10.05)
      ASOSCommDates(677) = ASOSDATA("PITTSBURGH",
     &  "ALLEGHENY COUNTY AIRPORT","PA",14762,"KAGC","AGC",40.35,-79.92,
     &  "19990203","NO","FAA",26.00,7.92)
      ASOSCommDates(678) = ASOSDATA("PITTSBURGH",
     &  "PITTSBURGH INTERNATIONAL AIRPORT","PA",94823,"KPIT","PIT",40.5,
     &  -80.23,"19960701","YES","NWS",33.00,10.05)
      ASOSCommDates(679) = ASOSDATA("POTTSTOWN",
     &  "POTTSTOWN LIMERICK AIRPORT","PA",54782,"KPTW","PTW",40.23,
     &  -75.55,"19990303","NO","FAA",26.00,7.92)
      ASOSCommDates(680) = ASOSDATA("READING",
     &  "READING REGIONAL/CARL A SPAATZ FIELD AIRPORT","PA",14712,
     &  "KRDG","RDG",40.37,-75.95,"19990217","NO","FAA",26.00,7.92)
      ASOSCommDates(681) = ASOSDATA("SELINSGROVE","PENN VALLEY AIRPORT",
     &  "PA",14770,"KSEG","SEG",40.82,-76.86,"19970813","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(682) = ASOSDATA("WILKES-BARRE/SCRANTON",
     &  "WILKES-BARRE/SCRANTON INTERNATIONAL AIRPORT","PA",14777,"KAVP",
     &  "AVP",41.33,-75.72,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(683) = ASOSDATA("WILLIAMSPORT",
     &  "WILLIAMSPORT REGIONAL AIRPORT","PA",14778,"KIPT","IPT",41.24,
     &  -76.92,"19950901","YES","NWS",26.00,7.92)
      ASOSCommDates(684) = ASOSDATA("YORK","YORK AIRPORT","PA",93778,
     &  "KTHV","THV",39.91,-76.87,"19970813","NO","FAA",33.00,10.05)
      ASOSCommDates(685) = ASOSDATA("NEWPORT","NEWPORT STATE AIRPORT",
     &  "RI",14787,"KUUU","UUU",41.53,-71.28,"19960229","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(686) = ASOSDATA("PROVIDENCE",
     &  "THEODORE FRANCIS GREEN STATE AIRPORT","RI",14765,"KPVD","PVD",
     &  41.72,-71.43,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(687) = ASOSDATA("WESTERLY","WESTERLY STATE AIRPORT",
     &  "RI",14794,"KWST","WST",41.34,-71.79,"19990728","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(688) = ASOSDATA("ANDERSON",
     &  "ANDERSON COUNTY AIRPORT","SC",93846,"KAND","AND",34.49,-82.7,
     &  "19981104","NO","FAA",33.00,10.05)
      ASOSCommDates(689) = ASOSDATA("CHARLESTON",
     &  "CHARLESTON AFB/INTERNATIONAL AIRPORT","SC",13880,"KCHS","CHS",
     &  32.89,-80.04,"19951001","YES","NWS",33.00,10.05)
      ASOSCommDates(690) = ASOSDATA("CLEMSON",
     &  "OCONEE COUNTY REGIONAL AIRPORT","SC",53850,"KCEU","CEU",34.67,
     &  -82.88,"20000316","NO","FAA",26.00,7.92)
      ASOSCommDates(691) = ASOSDATA("COLUMBIA",
     &  "COLUMBIA METROPOLITAN AIRPORT","SC",13883,"KCAE","CAE",33.94,
     &  -81.11,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(692) = ASOSDATA("COLUMBIA",
     &  "COLUMBIA OWENS DOWNTOWN AIRPORT","SC",53867,"KCUB","CUB",33.97,
     &  -80.99,"19981015","NO","FAA",26.00,7.92)
      ASOSCommDates(693) = ASOSDATA("FLORENCE",
     &  "FLORENCE REGIONAL AIRPORT","SC",13744,"KFLO","FLO",34.18,
     &  -79.73,"19990423","NO","FAA",33.00,10.05)
      ASOSCommDates(694) = ASOSDATA("GREENVILLE",
     &  "GREENVILLE DOWNTOWN AIRPORT","SC",13886,"KGMU","GMU",34.84,
     &  -82.34,"19990428","NO","FAA",26.00,7.92)
      ASOSCommDates(695) = ASOSDATA("GREENWOOD",
     &  "GREENWOOD COUNTY AIRPORT","SC",53874,"KGRD","GRD",34.24,-82.15,
     &  "20000524","NO","FAA",33.00,10.05)
      ASOSCommDates(696) = ASOSDATA("GREER",
     &  "GREENVILLE-SPARTANBURG INTERNATIONAL AIRPORT","SC",3870,"KGSP",
     &  "GSP",34.89,-82.21,"19960401","YES","NWS",26.00,7.92)
      ASOSCommDates(697) = ASOSDATA("NORTH MYRTLE BEACH",
     &  "GRAND STRAND AIRPORT","SC",93718,"KCRE","CRE",33.81,-78.72,
     &  "19990616","NO","FAA",33.00,10.05)
      ASOSCommDates(698) = ASOSDATA("ORANGEBURG",
     &  "ORANGEBURG MUNICIPAL AIRPORT","SC",53854,"KOGB","OGB",33.46,
     &  -80.85,"19970320","NO","FAA",33.00,10.05)
      ASOSCommDates(699) = ASOSDATA("ROCK HILL",
     &  "ROCK HILL/YORK COUNTY/BRYANT FIELD AIRPORT","SC",53871,"KUZA",
     &  "UZA",34.98,-81.05,"19990120","NO","FAA",33.00,10.05)
      ASOSCommDates(700) = ASOSDATA("ABERDEEN",
     &  "ABERDEEN REGIONAL AIRPORT","SD",14929,"KABR","ABR",45.44,
     &  -98.42,"19941101","YES","NWS",26.00,7.92)
      ASOSCommDates(701) = ASOSDATA("BUFFALO","BUFFALO AMOS","SD",94037,
     &  "K2WX","2WX",45.6,-103.54,"19980416","NO","NWS",26.00,7.92)
      ASOSCommDates(702) = ASOSDATA("CHAMBERLAIN",
     &  "CHAMBERLAIN MUNICIPAL AIRPORT","SD",94943,"K9V9","9V9",43.76,
     &  -99.31,"19980205","NO","NWS",33.00,10.05)
      ASOSCommDates(703) = ASOSDATA("CUSTER","CUSTER COUNTY AIRPORT",
     &  "SD",94032,"KCUT","CUT",43.73,-103.62,"19990409","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(704) = ASOSDATA("FAITH","FAITH MUNICIPAL AIRPORT",
     &  "SD",94056,"KD07","D07",45.03,-102.01,"19980521","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(705) = ASOSDATA("SISSETON",
     &  "SISSETON MUNICIPAL AIRPORT","SD",94993,"K8D3","8D3",45.66,
     &  -96.99,"19980827","NO","NWS",33.00,10.05)
      ASOSCommDates(706) = ASOSDATA("HURON","HURON REGIONAL AIRPORT",
     &  "SD",14936,"KHON","HON",44.38,-98.22,"19961101","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(707) = ASOSDATA("MITCHELL",
     &  "MITCHELL MUNICIPAL AIRPORT","SD",94950,"KMHE","MHE",43.77,
     &  -98.03,"19990901","NO","FAA",26.00,7.92)
      ASOSCommDates(708) = ASOSDATA("MOBRIDGE",
     &  "MOBRIDGE MUNICIPAL AIRPORT","SD",94052,"KMBG","MBG",45.54,
     &  -100.4,"19970901","NO","NWS",33.00,10.05)
      ASOSCommDates(709) = ASOSDATA("PHILIP","PHILIP AIRPORT","SD",
     &  24024,"KPHP","PHP",44.05,-101.6,"19980626","NO","NWS",33.00,
     &  10.05)
      ASOSCommDates(710) = ASOSDATA("PIERRE","PIERRE REGIONAL AIRPORT",
     &  "SD",24025,"KPIR","PIR",44.38,-100.28,"20000907","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(711) = ASOSDATA("PINE RIDGE","PINE RIDGE AIRPORT",
     &  "SD",94039,"KIEN","IEN",43.02,-102.51,"19970611","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(712) = ASOSDATA("RAPID CITY",
     &  "RAPID CITY REGIONAL AIRPORT","SD",24090,"KRAP","RAP",44.04,
     &  -103.05,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(713) = ASOSDATA("SIOUX FALLS",
     &  "JOE FOSS FIELD AIRPORT","SD",14944,"KFSD","FSD",43.57,-96.75,
     &  "19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(714) = ASOSDATA("WATERTOWN",
     &  "WATERTOWN MUNICIPAL AIRPORT","SD",14946,"KATY","ATY",44.93,
     &  -97.15,"19960424","NO","FAA",26.00,7.92)
      ASOSCommDates(715) = ASOSDATA("WINNER",
     &  "WINNER REGIONAL AIRPORT (SITE ID/LOCATION CHANGE) 7/5/2007",
     &  "SD",94990,"KICR","ICR",43.39,-99.84,"19970319","NO","FAA",
     &  -9.0,-9.0)
      ASOSCommDates(716) = ASOSDATA("BRISTOL/JOHNSON CITY/KINGSPORT",
     &  "TRI-CITY REGIONAL TN/VA AIRPORT","TN",13877,"KTRI","TRI",36.47,
     &  -82.39,"19951001","YES","NWS",33.00,10.05)
      ASOSCommDates(717) = ASOSDATA("CHATTANOOGA",
     &  "LOVELL FIELD AIRPORT","TN",13882,"KCHA","CHA",35.03,-85.2,
     &  "19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(718) = ASOSDATA("CLARKSVILLE",
     &  "OUTLAW FIELD AIRPORT","TN",3894,"KCKV","CKV",36.62,-87.41,
     &  "20010410","NO","FAA",33.00,10.05)
      ASOSCommDates(719) = ASOSDATA("CROSSVILLE",
     &  "CROSSVILLE MEMORIAL-WHITSON FIELD AIRPORT","TN",3847,"KCSV",
     &  "CSV",35.95,-85.08,"20001004","NO","FAA",26.00,7.92)
      ASOSCommDates(720) = ASOSDATA("JACKSON",
     &  "MCKELLAR-SIPES REGIONAL AIRPORT","TN",3811,"KMKL","MKL",35.59,
     &  -88.91,"19970603","NO","FAA",33.00,10.05)
      ASOSCommDates(721) = ASOSDATA("KNOXVILLE","MC GHEE TYSON AIRPORT",
     &  "TN",13891,"KTYS","TYS",35.81,-83.98,"19951001","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(722) = ASOSDATA("MEMPHIS",
     &  "MEMPHIS INTERNATIONAL AIRPORT","TN",13893,"KMEM","MEM",35.06,
     &  -89.98,"19990430","YES","FAA",33.00,10.05)
      ASOSCommDates(723) = ASOSDATA("NASHVILLE",
     &  "NASHVILLE INTERNATIONAL AIRPORT","TN",13897,"KBNA","BNA",36.11,
     &  -86.68,"19960601","YES","NWS",33.00,10.05)
      ASOSCommDates(724) = ASOSDATA("OAK RIDGE","OAK RIDGE","TN",53868,
     &  "KOQT","OQT",36.02,-84.23,"19980901","YES","NWS",33.00,10.05)
      ASOSCommDates(725) = ASOSDATA("ABILENE",
     &  "ABILENE REGIONAL AIRPORT","TX",13962,"KABI","ABI",32.41,-99.68,
     &  "19960501","YES","NWS",33.00,10.05)
      ASOSCommDates(726) = ASOSDATA("ALICE",
     &  "ALICE INTERNATIONAL AIRPORT","TX",12932,"KALI","ALI",27.74,
     &  -98.02,"20010110","NO","FAA",33.00,10.05)
      ASOSCommDates(727) = ASOSDATA("AMARILLO",
     &  "AMARILLO INTERNATIONAL AIRPORT","TX",23047,"KAMA","AMA",35.21,
     &  -101.7,"19921101","YES","NWS",33.00,10.05)
      ASOSCommDates(728) = ASOSDATA("ANGLETON/LAKE JACKSON",
     &  "BRAZORIA COUNTY AIRPORT","TX",12976,"KLBX","LBX",29.1,-95.46,
     &  "19980513","NO","FAA",33.00,10.05)
      ASOSCommDates(729) = ASOSDATA("ARLINGTON",
     &  "ARLINGTON MUNICIPAL AIRPORT","TX",53907,"KGKY","GKY",32.66,
     &  -97.09,"19970722","NO","FAA",33.00,10.05)
      ASOSCommDates(730) = ASOSDATA("AUSTIN/BERGSTROM",
     &  "AUSTIN-BERGSTROM INTERNATIONAL AIRPORT","TX",13904,"KAUS",
     &  "AUS",30.17,-97.68,"19971002","YES","FAA",33.00,10.05)
      ASOSCommDates(731) = ASOSDATA("AUSTIN/CITY",
     &  "CAMP MABRY ARMY NATIONAL GUARD","TX",13958,"KATT","ATT",30.31,
     &  -97.76,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(732) = ASOSDATA("BEAUMONT/PORT ARTHUR",
     &  "SOUTHEAST TEXAS REGIONAL AIRPORT","TX",12917,"KBPT","BPT",
     &  29.95,-94.02,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(733) = ASOSDATA("BORGER",
     &  "HUTCHINSON COUNTY AIRPORT","TX",3024,"KBGD","BGD",35.7,-101.39,
     &  "19951218","NO","FAA",33.00,10.05)
      ASOSCommDates(734) = ASOSDATA("BROWNSVILLE",
     &  "BROWNSVILLE/SOUTH PADRE IS. INTERNATIONAL AIRPORT","TX",12919,
     &  "KBRO","BRO",25.9,-97.42,"19940501","YES","NWS",33.00,10.05)
      ASOSCommDates(735) = ASOSDATA("BURNET",
     &  "BURNET MUNICIPAL KATE CRADDOCK FIELD AIRPORT","TX",3999,"KBMQ",
     &  "BMQ",30.74,-98.23,"19960712","NO","FAA",33.00,10.05)
      ASOSCommDates(736) = ASOSDATA("CHILDRESS",
     &  "CHILDRESS MUNICIPAL AIRPORT","TX",23007,"KCDS","CDS",34.43,
     &  -100.28,"19960731","NO","FAA",33.00,10.05)
      ASOSCommDates(737) = ASOSDATA("COLLEGE STATION",
     &  "EASTERWOOD FIELD AIRPORT","TX",3904,"KCLL","CLL",30.58,-96.36,
     &  "19961210","NO","FAA",26.00,7.92)
      ASOSCommDates(738) = ASOSDATA("CONROE",
     &  "MONTGOMERY COUNTY AIRPORT","TX",53902,"KCXO","CXO",30.35,
     &  -95.41,"19961210","NO","FAA",26.00,7.92)
      ASOSCommDates(739) = ASOSDATA("CORPUS CHRISTI",
     &  "CORPUS CHRISTI INTERNATIONAL AIRPORT","TX",12924,"KCRP","CRP",
     &  27.77,-97.51,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(740) = ASOSDATA("CORSICANA",
     &  "C DAVID CAMPBELL FIELD-CORSICANA MUNICIPAL AIRPORT","TX",53912,
     &  "KCRS","CRS",32.02,-96.39,"19970520","NO","FAA",33.00,10.05)
      ASOSCommDates(741) = ASOSDATA("COTULLA",
     &  "COTULLA-LA SALLE COUNTY AIRPORT","TX",12947,"KCOT","COT",28.45,
     &  -99.22,"20010110","NO","FAA",33.00,10.05)
      ASOSCommDates(742) = ASOSDATA("DALHART",
     &  "DALHART MUNICIPAL AIRPORT","TX",93042,"KDHT","DHT",36.02,
     &  -102.54,"20000920","NO","FAA",33.00,10.05)
      ASOSCommDates(743) = ASOSDATA("DALLAS",
     &  "DALLAS LOVE FIELD AIRPORT","TX",13960,"KDAL","DAL",32.84,
     &  -96.85,"19971119","YES","FAA",33.00,10.05)
      ASOSCommDates(744) = ASOSDATA("DALLAS","DALLAS EXECUTIVE AIRPORT",
     &  "TX",3971,"KRBD","RBD",32.68,-96.86,"19970826","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(745) = ASOSDATA("DALLAS-FT WORTH",
     &  "DALLAS/FT WORTH INTERNATIONAL AIRPORT","TX",3927,"KDFW","DFW",
     &  32.89,-97.04,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(746) = ASOSDATA("DEL RIO",
     &  "DEL RIO INTERNATIONAL AIRPORT","TX",22010,"KDRT","DRT",29.36,
     &  -100.92,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(747) = ASOSDATA("DENTON","DENTON MUNICIPAL AIRPORT",
     &  "TX",3991,"KDTO","DTO",33.2,-97.19,"19950726","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(748) = ASOSDATA("DRYDEN","TERRELL COUNTY AIRPORT",
     &  "TX",3032,"K6R6","6R6",30.04,-102.21,"19990615","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(749) = ASOSDATA("EL PASO",
     &  "EL PASO INTERNATIONAL AIRPORT","TX",23044,"KELP","ELP",31.81,
     &  -106.37,"19950601","YES","NWS",33.00,10.05)
      ASOSCommDates(750) = ASOSDATA("FORT STOCKTON",
     &  "FORT STOCKTON-PECOS COUNTY AIRPORT","TX",23091,"KFST","FST",
     &  30.91,-102.91,"19951206","NO","FAA",33.00,10.05)
      ASOSCommDates(751) = ASOSDATA("FORT WORTH",
     &  "FORT WORTH ALLIANCE AIRPORT","TX",53909,"KAFW","AFW",32.97,
     &  -97.31,"19970725","NO","FAA",33.00,10.05)
      ASOSCommDates(752) = ASOSDATA("FORT WORTH",
     &  "FORT WORTH MEACHAM INTERNATIONAL AIRPORT","TX",13961,"KFTW",
     &  "FTW",32.81,-97.36,"19970923","NO","FAA",26.00,7.92)
      ASOSCommDates(753) = ASOSDATA("GALVESTON",
     &  "SCHOLES INTERNATIONAL AT GALVESTON AIRPORT","TX",12923,"KGLS",
     &  "GLS",29.26,-94.86,"19961130","NO","FAA",26.00,7.92)
      ASOSCommDates(754) = ASOSDATA("GUADALUPE PASS",
     &  "GUADALUPE PASS AUTO METEORLOLGICAL OBSERVING SYSTEM ","TX",
     &  23055,"KGDP","GDP",31.83,-104.8,"19990615","NO","NWS",
     &  19.00,5.79)
      ASOSCommDates(755) = ASOSDATA("HARLINGEN",
     &  "VALLEY INTERNATIONAL AIRPORT","TX",12904,"KHRL","HRL",26.22,
     &  -97.65,"19961125","NO","FAA",33.00,10.05)
      ASOSCommDates(756) = ASOSDATA("HONDO","HONDO MUNICIPAL AIRPORT",
     &  "TX",12962,"KHDO","HDO",29.35,-99.17,"19960315","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(757) = ASOSDATA("HOUSTON",
     &  "DAVID WAYNE HOOKS MEMORIAL AIRPORT","TX",53910,"KDWH","DWH",
     &  30.06,-95.55,"19971209","NO","FAA",33.00,10.05)
      ASOSCommDates(758) = ASOSDATA("HOUSTON","WILLIAM P.HOBBY AIRPORT",
     &  "TX",12918,"KHOU","HOU",29.64,-95.27,"19980812","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(759) = ASOSDATA("HOUSTON",
     &  "G. BUSH INTERCONTINENTAL AIRPORT/HOUSTON AIRPORT","TX",12960,
     &  "KIAH","IAH",29.99,-95.36,"19960601","YES","NWS",33.00,10.05)
      ASOSCommDates(760) = ASOSDATA("HOUSTON","CLOVER FIELD AIRPORT",
     &  "TX",12975,"KLVJ","LVJ",29.52,-95.24,"19970410","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(761) = ASOSDATA("HOUSTON",
     &  "SUGAR LAND REGIONAL AIRPORT","TX",12977,"KSGR","SGR",29.62,
     &  -95.65,"20001228","NO","FAA",25.00,7.62)
      ASOSCommDates(762) = ASOSDATA("HUNTSVILLE",
     &  "HUNTSVILLE MUNICIPAL AIRPORT","TX",53903,"KUTS","UTS",30.74,
     &  -95.58,"19970203","NO","FAA",33.00,10.05)
      ASOSCommDates(763) = ASOSDATA("JUNCTION","KIMBLE COUNTY AIRPORT",
     &  "TX",13973,"KJCT","JCT",30.51,-99.76,"19961202","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(764) = ASOSDATA("LONGVIEW",
     &  "EAST TEXAS REGIONAL AIRPORT","TX",3901,"KGGG","GGG",32.38,
     &  -94.71,"19980520","NO","FAA",33.00,10.05)
      ASOSCommDates(765) = ASOSDATA("LUBBOCK",
     &  "LUBBOCK INTERNATIONAL AIRPORT","TX",23042,"KLBB","LBB",33.66,
     &  -101.82,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(766) = ASOSDATA("LUFKIN",
     &  "ANGELINA COUNTY AIRPORT","TX",93987,"KLFK","LFK",
     &  31.23,-94.75,"20000823","NO","FAA",26.00,7.92)
      ASOSCommDates(767) = ASOSDATA("MC ALLEN",
     &  "MC ALLEN MILLER INTERNATIONAL AIRPORT","TX",12959,"KMFE","MFE",
     &  26.17,-98.23,"19960930","NO","FAA",33.00,10.05)
      ASOSCommDates(768) = ASOSDATA("MC KINNEY",
     &  "MC KINNEY MUNICIPAL AIRPORT","TX",53914,"KTKI","TKI",33.18,
     &  -96.59,"19980422","NO","FAA",33.00,10.05)
      ASOSCommDates(769) = ASOSDATA("MIDLAND",
     &  "MIDLAND INTERNATIONAL AIRPORT","TX",23023,"KMAF","MAF",31.93,
     &  -102.2,"19960301","YES","NWS",26.00,7.92)
      ASOSCommDates(770) = ASOSDATA("MINERAL WELLS",
     &  "MINERAL WELLS AIRPORT","TX",93985,"KMWL","MWL",32.78,-98.06,
     &  "20001206","NO","FAA",33.00,10.05)
      ASOSCommDates(771) = ASOSDATA("NEW BRAUNFELS",
     &  "NEW BRAUNFELS MUNICIPAL AIRPORT","TX",12971,"KBAZ","BAZ",29.7,
     &  -98.04,"19960229","NO","FAA",33.00,10.05)
      ASOSCommDates(772) = ASOSDATA("ODESSA",
     &  "ODESSA-SCHLEMEYER FIELD AIRPORT","TX",3031,"KODO","ODO",31.92,
     &  -102.38,"19981201","NO","FAA",33.00,10.05)
      ASOSCommDates(773) = ASOSDATA("PALACIOS",
     &  "PALACIOS MUNICIPAL AIRPORT","TX",12935,"KPSX","PSX",28.72,
     &  -96.25,"20001018","NO","FAA",33.00,10.05)
      ASOSCommDates(774) = ASOSDATA("PORT ISABEL",
     &  "PORT ISABEL-CAMERON COUNTY AIRPORT","TX",12957,"KPIL","PIL",
     &  26.16,-97.34,"19980917","NO","FAA",33.00,10.05)
      ASOSCommDates(775) = ASOSDATA("ROCKPORT","ARANSAS COUNTY AIRPORT",
     &  "TX",12972,"KRKP","RKP",28.08,-97.04,"19960229","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(776) = ASOSDATA("SAN ANGELO",
     &  "SAN ANGELO REGIONAL/MATHIS FIELD AIRPORT","TX",23034,"KSJT",
     &  "SJT",31.35,-100.49,"19960201","YES","NWS",33.00,10.05)
      ASOSCommDates(777) = ASOSDATA("SAN ANTONIO",
     &  "SAN ANTONIO INTERNATIONAL AIRPORT","TX",12921,"KSAT","SAT",
     &  29.53,-98.46,"19950601","YES","NWS",33.00,10.05)
      ASOSCommDates(778) = ASOSDATA("SAN ANTONIO",
     &  "STINSON MUNICIPAL AIRPORT","TX",12970,"KSSF","SSF",29.33,
     &  -98.47,"19980513","NO","FAA",33.00,10.05)
      ASOSCommDates(779) = ASOSDATA("TERRELL",
     &  "TERRELL MUNICIPAL AIRPORT","TX",53911,"KTRL","TRL",32.71,
     &  -96.26,"19970520","NO","FAA",26.00,7.92)
      ASOSCommDates(780) = ASOSDATA("TYLER",
     &  "TYLER POUNDS REGIONAL AIRPORT","TX",13972,"KTYR","TYR",32.35,
     &  -95.4,"19980520","NO","FAA",33.00,10.05)
      ASOSCommDates(781) = ASOSDATA("VICTORIA",
     &  "VICTORIA REGIONAL AIRPORT","TX",12912,"KVCT","VCT",28.86,
     &  -96.92,"19951201","YES","NWS",33.00,10.05)
      ASOSCommDates(782) = ASOSDATA("WACO","WACO REGIONAL AIRPORT","TX",
     &  13959,"KACT","ACT",31.61,-97.22,"19930701","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(783) = ASOSDATA("WICHITA FALLS",
     &  "SHEPPARD AFB/WICHITA FALLS MUNICIPAL AIRPORT","TX",13966,
     &  "KSPS","SPS",33.97,-98.49,"19930501","YES","NWS",33.00,10.05)
      ASOSCommDates(784) = ASOSDATA("WINK","WINKLER COUNTY AIRPORT",
     &  "TX",23040,"KINK","INK",31.77,-103.2,"20001129","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(785) = ASOSDATA("BRYCE CANYON",
     &  "BRYCE CANYON AIRPORT","UT",23159,"KBCE","BCE",37.7,-112.14,
     &  "20001116","NO","FAA",33.00,10.05)
      ASOSCommDates(786) = ASOSDATA("CEDAR CITY",
     &  "CEDAR CITY REGIONAL AIRPORT","UT",93129,"KCDC","CDC",37.7,
     &  -113.09,"19980528","NO","FAA",26.00,7.92)
      ASOSCommDates(787) = ASOSDATA("LOGAN","LOGAN-CACHE AIRPORT","UT",
     &  94128,"KLGU","LGU",41.78,-111.85,"19981001","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(788) = ASOSDATA("MILFORD",
     &  "MILFORD MUNICIPAL AIRPORT","UT",23176,"KMLF","MLF",38.44,
     &  -113.02,"19960801","NO","NWS",33.00,10.05)
      ASOSCommDates(789) = ASOSDATA("MOAB","CANYONLANDS FIELD AIRPORT",
     &  "UT",93075,"KCNY","CNY",38.75,-109.75,"19980716","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(790) = ASOSDATA("OGDEN","OGDEN-HINCKLEY AIRPORT",
     &  "UT",24126,"KOGD","OGD",41.19,-112.01,"19980506","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(791) = ASOSDATA("PRICE","CARBON COUNTY AIRPORT",
     &  "UT",93141,"KPUC","PUC",39.54,-110.74,"19980911","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(792) = ASOSDATA("SALT LAKE CITY",
     &  "SALT LAKE CITY INTERNATIONAL AIRPORT","UT",24127,"KSLC","SLC",
     &  40.78,-111.96,"19980301","YES","NWS",33.00,10.05)
      ASOSCommDates(793) = ASOSDATA("VERNAL","VERNAL AIRPORT","UT",
     &  94030,"KVEL","VEL",40.44,-109.5,"19980129","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(794) = ASOSDATA("CHARLOTTESVILLE",
     &  "CHARLOTTESVILLE-ALBEMARLE AIRPORT","VA",93736,"KCHO","CHO",
     &  38.13,-78.45,"19981118","NO","FAA",26.00,7.92)
      ASOSCommDates(795) = ASOSDATA("DANVILLE",
     &  "DANVILLE REGIONAL AIRPORT","VA",13728,"KDAN","DAN",36.57,
     &  -79.33,"20000816","NO","FAA",33.00,10.05)
      ASOSCommDates(796) = ASOSDATA("LYNCHBURG",
     &  "LYNCHBURG REGIONAL/PRESTON GLENN FIELD AIRPORT","VA",13733,
     &  "KLYH","LYH",37.33,-79.2,"19960801","YES","NWS",33.00,10.05)
      ASOSCommDates(797) = ASOSDATA("NEWPORT NEWS",
     &  "NEWPORT NEWS/WILLIAMSBURG INTERNATIONAL AIRPORT","VA",93741,
     &  "KPHF","PHF",37.13,-76.49,"20001213","NO","FAA",33.00,10.05)
      ASOSCommDates(798) = ASOSDATA("NORFOLK",
     &  "NORFOLK INTERNATIONAL AIRPORT","VA",13737,"KORF","ORF",36.9,
     &  -76.19,"19960301","YES","NWS",33.00,10.05)
      ASOSCommDates(799) = ASOSDATA("RICHMOND",
     &  "RICHMOND INTERNATIONAL AIRPORT","VA",13740,"KRIC","RIC",37.51,
     &  -77.32,"19951001","YES","NWS",33.00,10.05)
      ASOSCommDates(800) = ASOSDATA("RICHMOND/ASHLAND",
     &  "HANOVER COUNTY MUNICIPAL AIRPORT","VA",93775,"KOFP","OFP",37.7,
     &  -77.43,"19950301","NO","FAA",33.00,10.05)
      ASOSCommDates(801) = ASOSDATA("ROANOKE",
     &  "ROANOKE REGIONAL/WOODRUM FIELD AIRPORT","VA",13741,"KROA",
     &  "ROA",37.31,-79.97,"19960501","YES","NWS",33.00,10.05)
      ASOSCommDates(802) = ASOSDATA("WAKEFIELD",
     &  "WAKEFIELD MUNICIPAL AIRPORT","VA",93773,"KAKQ","AKQ",36.98,
     &  -77.,"19971016","NO","NWS",26.00,7.92)
      ASOSCommDates(803) = ASOSDATA("WALLOPS ISLAND",
     &  "WALLOPS FLIGHT FACILITY AIRPORT","VA",93739,"KWAL","WAL",37.94,
     &  -75.49,"19960901","YES","NWS",33.00,10.05)
      ASOSCommDates(804) = ASOSDATA("BARRE/MONTPELIER",
     &  "EDWARD F KNAPP STATE AIRPORT","VT",94705,"KMPV","MPV",44.2,
     &  -72.57,"19960618","NO","FAA",26.00,7.92)
      ASOSCommDates(805) = ASOSDATA("BENNINGTON",
     &  "WILLIAM H. MORSE STATE AIRPORT","VT",54781,"KDDH","DDH",42.89,
     &  -73.24,"19981209","NO","FAA",33.00,10.05)
      ASOSCommDates(806) = ASOSDATA("BURLINGTON",
     &  "BURLINGTON INTERNATIONAL AIRPORT","VT",14742,"KBTV","BTV",
     &  44.46,-73.15,"19960201","YES","NWS",26.00,7.92)
      ASOSCommDates(807) = ASOSDATA("MORRISVILLE",
     &  "MORRISVILLE-STOWE STATE AIRPORT","VT",54771,"KMVL","MVL",44.53,
     &  -72.61,"19951115","NO","FAA",26.00,7.92)
      ASOSCommDates(808) = ASOSDATA("SPRINGFIELD",
     &  "HARTNESS STATE (SPRINGFIELD) AIRPORT","VT",54740,"KVSF","VSF",
     &  43.34,-72.51,"19950823","NO","FAA",26.00,7.92)
      ASOSCommDates(809) = ASOSDATA("ST. JOHNSBURY",
     &  "FAIRBANKS MUSEUM AMOS","VT",54742,"K1V4","1V4",44.41,-72.01,
     &  "19980715","NO","NWS",33.00,10.05)
      ASOSCommDates(810) = ASOSDATA("BELLINGHAM",
     &  "BELLINGHAM INTERNATIONAL AIRPORT","WA",24217,"KBLI","BLI",
     &  48.79,-122.53,"19980917","NO","FAA",33.00,10.05)
      ASOSCommDates(811) = ASOSDATA("DEER PARK","DEER PARK AIRPORT",
     &  "WA",94119,"KDEW","DEW",47.96,-117.42,"19981105","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(812) = ASOSDATA("ELLENSBURG","BOWERS FIELD AIRPORT",
     &  "WA",24220,"KELN","ELN",47.03,-120.53,"19980730","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(813) = ASOSDATA("EPHRATA",
     &  "EPHRATA MUNICIPAL AIRPORT","WA",24141,"KEPH","EPH",47.3,
     &  -119.51,"20010920","NO","FAA",33.00,10.05)
      ASOSCommDates(814) = ASOSDATA("EVERETT",
     &  "SNOHOMISH COUNTY (PAINE FIELD) AIRPORT","WA",24222,"KPAE",
     &  "PAE",47.9,-122.28,"19980924","NO","FAA",33.00,10.05)
      ASOSCommDates(815) = ASOSDATA("FRIDAY HARBOR",
     &  "FRIDAY HARBOR AIRPORT","WA",94276,"KFHR","FHR",48.52,-123.02,
     &  "19971218","NO","FAA",26.00,7.92)
      ASOSCommDates(816) = ASOSDATA("HOQUIAM","BOWERMAN AIRPORT","WA",
     &  94225,"KHQM","HQM",46.97,-123.93,"20010322","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(817) = ASOSDATA("MOSES LAKE",
     &  "GRANT COUNTY INTERNATIONAL AIRPORT","WA",24110,"KMWH","MWH",
     &  47.2,-119.31,"19970630","NO","FAA",33.00,10.05)
      ASOSCommDates(818) = ASOSDATA("OLYMPIA","OLYMPIA AIRPORT AIRPORT",
     &  "WA",24227,"KOLM","OLM",46.97,-122.9,"19951101","YES","NWS",
     &  26.00,7.92)
      ASOSCommDates(819) = ASOSDATA("OMAK","OMAK AIRPORT","WA",94197,
     &  "KOMK","OMK",48.46,-119.51,"19980217","NO","FAA",33.00,10.05)
      ASOSCommDates(820) = ASOSDATA("PASCO","TRI-CITIES AIRPORT","WA",
     &  24163,"KPSC","PSC",46.26,-119.11,"19980129","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(821) = ASOSDATA("PORT ANGELES",
     &  "WILLIAM R. FAIRCHILD INTERNATIONAL AIRPORT","WA",94266,"KCLM",
     &  "CLM",48.12,-123.49,"19981016","NO","FAA",33.00,10.05)
      ASOSCommDates(822) = ASOSDATA("PULLMAN/MOSCOW",
     &  "PULLMAN/MOSCOW REGIONAL AIRPORT","WA",94129,"KPUW","PUW",46.74,
     &  -117.1,"19980611","NO","FAA",33.00,10.05)
      ASOSCommDates(823) = ASOSDATA("QUILLAYUTE","QUILLAYUTE AIRPORT",
     &  "WA",94240,"KUIL","UIL",47.93,-124.56,"19961201","YES","NWS",
     &  33.00,10.05)
      ASOSCommDates(824) = ASOSDATA("RENTON","RENTON MUNICIPAL AIRPORT",
     &  "WA",94248,"KRNT","RNT",47.49,-122.21,"19981008","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(825) = ASOSDATA("SEATTLE",
     &  "BOEING FIELD/KING COUNTY INTERNATIONAL AIRPORT","WA",24234,
     &  "KBFI","BFI",47.53,-122.3,"19981209","NO","FAA",26.00,7.92)
      ASOSCommDates(826) = ASOSDATA("SEATTLE",
     &  "SEATTLE-TACOMA INTERNATIONAL AIRPORT","WA",24233,"KSEA","SEA",
     &  47.46,-122.31,"19961001","YES","NWS",33.00,10.05)
      ASOSCommDates(827) = ASOSDATA("SHELTON","SANDERSON FIELD AIRPORT",
     &  "WA",94227,"KSHN","SHN",47.23,-123.14,"19980522","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(828) = ASOSDATA("SPOKANE",
     &  "SPOKANE INTERNATIONAL AIRPORT","WA",24157,"KGEG","GEG",47.62,
     &  -117.52,"19950901","YES","NWS",33.00,10.05)
      ASOSCommDates(829) = ASOSDATA("SPOKANE","FELTS FIELD AIRPORT",
     &  "WA",94176,"KSFF","SFF",47.68,-117.32,"19981015","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(830) = ASOSDATA("STAMPEDE PASS",
     &  "STAMPEDE PASS FLTWO","WA",24237,"KSMP","SMP",47.29,-121.33,
     &  "19940201","NO","NWS",26.00,7.92)
      ASOSCommDates(831) = ASOSDATA("TACOMA","TACOMA NARROWS AIRPORT",
     &  "WA",94274,"KTIW","TIW",47.26,-122.57,"19990114","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(832) = ASOSDATA("VANCOUVER","PEARSON FIELD AIRPORT",
     &  "WA",94298,"KVUO","VUO",45.62,-122.65,"19960619","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(833) = ASOSDATA("WALLA WALLA",
     &  "WALLA WALLA REGIONAL AIRPORT","WA",24160,"KALW","ALW",46.09,
     &  -118.28,"19981023","NO","FAA",33.00,10.05)
      ASOSCommDates(834) = ASOSDATA("WENATCHEE",
     &  "PANGBORN MEMORIAL AIRPORT","WA",94239,"KEAT","EAT",47.39,
     &  -120.2,"20001130","NO","FAA",33.00,10.05)
      ASOSCommDates(835) = ASOSDATA("YAKIMA",
     &  "YAKIMA AIR TERMINAL/MCALLISTER FIELD AIRPORT","WA",24243,
     &  "KYKM","YKM",46.56,-120.53,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(836) = ASOSDATA("ASHLAND",
     &  "JOHN F KENNEDY INTERNATIONAL AIRPORT","WI",94929,"KASX","ASX",
     &  46.54,-90.91,"19981016","NO","FAA",33.00,10.05)
      ASOSCommDates(837) = ASOSDATA("B0SCOBEL","BOSCOBEL AIRPORT","WI",
     &  94994,"KOVS","OVS",43.15,-90.67,"19990121","NO","FAA",33.00,
     &  10.05)
      ASOSCommDates(838) = ASOSDATA("EAU CLAIRE",
     &  "CHIPPEWA VALLEY REGIONAL AIRPORT","WI",14991,"KEAU","EAU",
     &  44.86,-91.48,"20000824","NO","FAA",33.00,10.05)
      ASOSCommDates(839) = ASOSDATA("FOND DU LAC",
     &  "FOND DU LAC COUNTY AIRPORT","WI",4840,"KFLD","FLD",43.77,
     &  -88.48,"19960729","NO","FAA",33.00,10.05)
      ASOSCommDates(840) = ASOSDATA("GREEN BAY",
     &  "AUSTIN STRAUBEL INTERNATIONAL AIRPORT","WI",14898,"KGRB","GRB",
     &  44.51,-88.12,"19960701","YES","NWS",33.00,10.05)
      ASOSCommDates(841) = ASOSDATA("HAYWARD","SAWYER COUNTY AIRPORT",
     &  "WI",94973,"KHYR","HYR",46.02,-91.44,"19951114","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(842) = ASOSDATA("KENOSHA",
     &  "KENOSHA REGIONAL AIRPORT","WI",4845,"KENW","ENW",42.59,-87.93,
     &  "19971009","NO","FAA",33.00,10.05)
      ASOSCommDates(843) = ASOSDATA("LA CROSSE",
     &  "LA CROSSE MUNICIPAL AIRPORT","WI",14920,
     &  "KLSE","LSE",43.75,-91.25,"20001005","YES","FAA",33.00,10.05)
      ASOSCommDates(844) = ASOSDATA("LONE ROCK",
     &  "TRI-COUNTY REGIONAL AIRPORT","WI",14921,"KLNR","LNR",43.21,
     &  -90.18,"20001019","NO","FAA",33.00,10.05)
      ASOSCommDates(845) = ASOSDATA("MADISON",
     &  "DANE COUNTY REGIONAL-TRUAX FIELD AIRPORT","WI",14837,"KMSN",
     &  "MSN",43.14,-89.34,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(846) = ASOSDATA("MARSHFIELD",
     &  "MARSHFIELD MUNICIPAL AIRPORT","WI",94985,"KMFI","MFI",44.63,
     &  -90.18,"19951024","NO","FAA",33.00,10.05)
      ASOSCommDates(847) = ASOSDATA("MILWAUKEE",
     &  "GENERAL MITCHELL INTERNATIONAL AIRPORT","WI",14839,"KMKE",
     &  "MKE",42.94,-87.89,"19950701","YES","NWS",33.00,10.05)
      ASOSCommDates(848) = ASOSDATA("OSHKOSH",
     &  "WHITTMAN REGIONAL AIRPORT","WI",94855,"KOSH","OSH",43.98,
     &  -88.55,"19960417","NO","FAA",26.00,7.92)
      ASOSCommDates(849) = ASOSDATA("RACINE","JOHN H BATTEN AIRPORT",
     &  "WI",94818,"KRAC","RAC",42.76,-87.81,"19980326","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(850) = ASOSDATA("RHINELANDER",
     &  "RHINELANDER-ONEIDA COUNTY AIRPORT","WI",4803,"KRHI","RHI",
     &  45.63,-89.46,"19980528","NO","FAA",26.00,7.92)
      ASOSCommDates(851) = ASOSDATA("SHEBOYGAN",
     &  "SHEBOYGAN COUNTY MEMORIAL AIRPORT","WI",4841,"KSBM","SBM",
     &  43.76,-87.85,"19960815","NO","FAA",33.00,10.05)
      ASOSCommDates(852) = ASOSDATA("WAUSAU","WAUSAU DOWNTOWN AIRPORT",
     &  "WI",14897,"KAUW","AUW",44.92,-89.62,"20000914","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(853) = ASOSDATA("WISCONSIN RAPTIDS",
     &  "ALEXANDER FIELD SOUTH WOOD COUNTY AIRPORT","WI",4826,"KISW",
     &  "ISW",44.35,-89.83,"19951114","NO","FAA",33.00,10.05)
      ASOSCommDates(854) = ASOSDATA("BECKLEY",
     &  "RALEIGH COUNTY MEMORIAL AIRPORT","WV",3872,"KBKW","BKW",37.79,
     &  -81.12,"19960201","YES","NWS",33.00,10.05)
      ASOSCommDates(855) = ASOSDATA("BLUEFIELD","MERCER COUNTY AIRPORT",
     &  "WV",3859,"KBLF","BLF",37.29,-81.2,"20001108","NO","FAA",26.00,
     &  7.92)
      ASOSCommDates(856) = ASOSDATA("CHARLESTON","YEAGER AIRPORT","WV",
     &  13866,"KCRW","CRW",38.37,-81.59,"19941001","YES","NWS",26.00,
     &  7.92)
      ASOSCommDates(857) = ASOSDATA("CLARKSBURG",
     &  "HARRISON/MARION REGIONAL AIRPORT","WV",3802,"KCKB","CKB",39.29,
     &  -80.22,"19980812","NO","FAA",26.00,7.92)
      ASOSCommDates(858) = ASOSDATA("ELKINS",
     &  "ELKINS-RANDOLPH COUNTY-JENNINGS RANDOLPH FLD ARPT","WV",13729,
     &  "KEKN","EKN",38.88,-79.85,"19960501","YES","NWS",26.00,7.92)
      ASOSCommDates(859) = ASOSDATA("HUNTINGTON",
     &  "TRI-STATE/MILTON J.FERGUSON FIELD AIRPORT","WV",3860,"KHTS",
     &  "HTS",38.38,-82.55,"19960901","YES","NWS",26.00,7.92)
      ASOSCommDates(860) = ASOSDATA("MARTINSBURG",
     &  "EASTERN WEST VIRGINIA REGIONAL/SHEPHERD FLD AIRPORT","WV",
     &  13734,"KMRB","MRB",39.4,-77.98,"20001129","NO","FAA",26.00,7.92)
      ASOSCommDates(861) = ASOSDATA("MORGANTOWN",
     &  "MORGANTOWN REGIONAL-WALTER L. BILL HART FLD AIRPORT","WV",
     &  13736,"KMGW","MGW",39.64,-79.91,"19990106","NO","FAA",
     &  26.00,7.92)
      ASOSCommDates(862) = ASOSDATA("PARKERSBURG",
     &  "WOOD COUNTY AIRPORT GILL ROBB WILSON FIELD AIRPORT","WV",3804,
     &  "KPKB","PKB",39.34,-81.43,"20001108","NO","FAA",33.00,10.05)
      ASOSCommDates(863) = ASOSDATA("WHEELING",
     &  "WHEELING OHIO COUNTY AIRPORT","WV",14894,"KHLG","HLG",40.17,
     &  -80.64,"19980325","NO","FAA",33.00,10.05)
      ASOSCommDates(864) = ASOSDATA("BIG PINEY",
     &  "BIG PINEY-MARBLETON AIRPORT","WY",24164,"KBPI","BPI",42.58,
     &  -110.1,"19980226","NO","FAA",33.00,10.05)
      ASOSCommDates(865) = ASOSDATA("BUFFALO","JOHNSON COUNTY AIRPORT",
     &  "WY",94054,"KBYG","BYG",44.38,-106.72,"19980730","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(866) = ASOSDATA("CASPER",
     &  "NATRONA COUNTY INTERNATIONAL AIRPORT","WY",24089,"KCPR","CPR",
     &  42.89,-106.47,"19960401","YES","NWS",33.00,10.05)
      ASOSCommDates(867) = ASOSDATA("CHEYENNE","CHEYENNE AIRPORT","WY",
     &  24018,"KCYS","CYS",41.15,-104.8,"19951101","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(868) = ASOSDATA("DOUGLAS","CONVERSE COUNTY AIRPORT",
     &  "WY",94057,"KDGW","DGW",42.79,-105.38,"19980528","NO","FAA",
     &  33.00,10.05)
      ASOSCommDates(869) = ASOSDATA("EVANSTON",
     &  "EVANSTON-UINTA COUNTY BURNS FIELD AIRPORT","WY",4111,"KEVW",
     &  "EVW",41.27,-111.03,"19990729","NO","FAA",33.00,10.05)
      ASOSCommDates(870) = ASOSDATA("GILLETTE",
     &  "GILLETTE-CAMPBELL COUNTY AIRPORT","WY",94023,"KGCC","GCC",
     &  44.33,-105.54,"19980716","NO","NWS",26.00,7.92)
      ASOSCommDates(871) = ASOSDATA("GREYBULL",
     &  "SOUTH BIG HORN COUNTY AIRPORT","WY",24048,"KGEY","GEY",44.51,
     &  -108.08,"19981015","NO","FAA",33.00,10.05)
      ASOSCommDates(872) = ASOSDATA("LANDER","HUNT FIELD AIRPORT","WY",
     &  24021,"KLND","LND",42.81,-108.73,"19961201","YES","NWS",33.00,
     &  10.05)
      ASOSCommDates(873) = ASOSDATA("LARAMIE",
     &  "LARAMIE REGIONAL AIRPORT","WY",24022,"KLAR","LAR",41.31,
     &  -105.67,"20000928","NO","FAA",33.00,10.05)
      ASOSCommDates(874) = ASOSDATA("RAWLINS",
     &  "RAWLINS MUNICIPAL AIRPORT","WY",24057,"KRWL","RWL",41.8,-107.2,
     &  "20000928","NO","FAA",33.00,10.05)
      ASOSCommDates(875) = ASOSDATA("RIVERTON",
     &  "RIVERTON REGIONAL AIRPORT","WY",24061,"KRIW","RIW",43.06,
     &  -108.45,"19951201","NO","NWS",33.00,10.05)
      ASOSCommDates(876) = ASOSDATA("ROCK SPRINGS",
     &  "ROCK SPRINGS-SWEETWATER COUNTY AIRPORT","WY",24027,"KRKS",
     &  "RKS",41.59,-109.06,"20010517","NO","FAA",33.00,10.05)
      ASOSCommDates(877) = ASOSDATA("SHERIDAN",
     &  "SHERIDAN COUNTY AIRPORT","WY",24029,"KSHR","SHR",44.77,-106.97,
     &  "19961201","YES","NWS",33.00,10.05)
      ASOSCommDates(878) = ASOSDATA("TORRINGTON",
     &  "TORRINGTON MUNICIPAL AIRPORT","WY",94053,"KTOR","TOR",42.06,
     &  -104.15,"19990826","NO","FAA",33.00,10.05)
      ASOSCommDates(879) = ASOSDATA("WORLAND",
     &  "WORLAND MUNICIPAL AIRPORT","WY",24062,"KWRL","WRL",43.96,
     &  -107.95,"20001220","NO","FAA",33.00,10.05)
      ASOSCommDates(880) = ASOSDATA("YELLOWSTONE","YELLOWSTONE LAKE",
     &  "WY",94173,"KP60","P60",44.54,-110.42,"19980813","NO","NWS",
     &  33.00,10.05)
      ASOSCommDates(881) = ASOSDATA("AGANA",
     &  "GUAM INTERNATIONAL AIRPORT"," ",41415,"PGUM","GUM",13.48,
     &  144.79,"20000111","YES","NWS",-9.,-9.)
      ASOSCommDates(882) = ASOSDATA("CHARLOTTE AMALIE",
     &  "CYRIL E KING AIRPORT"," ",11640,"TIST","STT",18.34,-64.97,
     &  "19980810","NO","FAA",26.00,7.92)
      ASOSCommDates(883) = ASOSDATA("CHRISTIANSTED",
     &  "HENRY E ROHISEN AIRPORT"," ",11624,"TISX","STX",17.7,-64.79,
     &  "20000808","NO","FAA",26.00,7.92)
      ASOSCommDates(884) = ASOSDATA("NAVSTN ROOSEVELT ROADS, CEIBA",
     &  "ROOSEVELT ROADS"," ",11630,"TJNR","NRR",18.25,-65.63,
     &  "20051019","YES","NWS",-9.,-9.)
      ASOSCommDates(885) = ASOSDATA("OBYAN",
     &  "FRANCISCO C. ADA/SAIPAN INTERNATIONAL AIRPORT"," ",41818,
     &  "PGSN","GSN",15.11,145.72,"20000111","NO","NWS",-9.,-9.)
      ASOSCommDates(886) = ASOSDATA("SAN JUAN",
     &  "LUIS MUNOZ MARIN INTERNATIONAL AIRPORT"," ",11641,"TJSJ","SJU",
     &  18.44,-66.,"19960501","YES","NWS",33.00,10.05)


         END SUBROUTINE InitAsosCommInfo

      END MODULE mod_AsosCommDates