      PROGRAM AERMET
C=======================================================================
C            MAIN Module of the AERMET Meteorological Processor
C                         Version Dated 21112
C
C                             April 22, 2021
C
C            *** SEE AERMET MODEL CHANGE BULLETIN MCB#10 ***
C
C       ON THE SUPPORT CENTER FOR REGULATORY AIR MODELS (SCRAM) WEBSITE
C
C                      https://www.epa.gov/scram
C
C=======================================================================
C
C       This revised version of AERMET (dated 21112) includes several
C       modifications relative to the previous version (dated 19191);
C       see AERMET Model Change Bullentin (MCB) #10 and AERMET User's
C       Guide.
C
C https://www.epa.gov/scram/meteorological-processors-and-accessory-programs#aermet
C
C
C-----  MODIFIED BY:    
C                       U.S. EPA, OAQPS/AQAD
C                       Air Quality Modeling Group
C
C                       April 22, 2021
C
C-----  MODIFIED FROM:         AERMET
C                       (Version Dated 19191)
C
C
C=======================================================================

      IMPLICIT NONE

      INCLUDE 'MAIN1.INC'
      INCLUDE 'MAIN2.INC'
      INCLUDE 'UA1.INC'
      INCLUDE 'SF1.INC'
      INCLUDE 'OS1.INC'
      INCLUDE 'MP1.INC'
      INCLUDE 'WORK1.INC'


      CHARACTER*96 INPFILE
      INTEGER  :: ISTAT, ISTAGE, DEVICE

c     JAT 12/14/17 ADDED FOR COMMAND LINE ARGUMENT
      integer  :: linp
      integer  :: iargc, cmdargstatus
      character c*300
      
c     WRITE(6, *)'Enter the name of the input file:     '               ! ! dtb001 01085
c     WRITE(6, *)                                                       ! ! dtb001 01085
c     READ(5, '(A96)') INPFILE                                          ! ! dtb001 01085
c     WRITE(6, *)'The input file is:  ', INPFILE                        ! ! dtb001 01085

c     OPEN (DEVIN, FILE=INPFILE, STATUS='OLD', ERR=900)                 ! ! dtb001 01085

      INPFILE = 'AERMET.INP'

c     JAT 12/14/17 added for command line argument
!     Set input file name based on optional
!     command line argumant. If no such argument,
!     use the default.
      iargc = command_argument_count()
      if(      iargc .eq. 0 ) then
         INPFILE = 'aermet.inp'
         linp = 10
      else if( iargc .ge. 1 ) then
         call get_command_argument (1, c, linp, cmdargstatus)
         if (cmdargstatus .ne. 0) then
             write (*,*) 'get_command_argument failed: cmdargstatus = ',
     &       cmdargstatus, ' iargc = ', 1, ' arg = ', 1
             stop
         end if
         INPFILE = c(1:linp)
      end if
      
      OPEN (DEVIN, FILE=INPFILE, STATUS='OLD', ERR=900)

C---- Open the console/screen for model output displays
C      OPEN( UNIT=3, FILE='CON', CARRIAGECONTROL='FORTRAN')

C---- Display version of AERMET that is being run
      WRITE( *,1 ) VERSNO
    1 FORMAT('   AERMET Version ', A6 )


C---- Initialize OSLON & OSLAT in case no ONSITE data
      OSLON = BLNK08
      OSLAt = BLNK08
      ISTAGE = 0
      PGNUM  = 0
      STATUS = 0
      OSDNUM = 0
      OSHTPREV = 0
      L_HgtsVary = .FALSE.

C---- Call PRESET to pre-process runstream input file ('aermet.inp')
C     to determine which stage of processing is being performed
C     based on pathways included.
      CALL PRESET( ISTAGE )

C---- Process user supplied set up data.
      CALL SETUP( ISTAGE )

C---- Assign processing stage:
      IF( STABLK(5) .EQ. 2 )THEN
C        MERGE Pathway in Stage 2
         ISTAGE = 2
      ELSEIF( STABLK(6) .EQ. 2 )THEN
C        METPREP Pathway in Stage 3
         ISTAGE = 3
      ELSEIF( STABLK(2) .EQ. 2 .OR. STABLK(3) .EQ. 2 .OR.
     &        STABLK(4) .EQ. 2 )THEN
C        UPPERAIR, SURFACE, or ONSITE Pathway in Stage 1
         ISTAGE = 1
      ENDIF

C---- Call status summary, SUMRY1
C         This routine is called before any data processing because
C         all pathway statuses are set at this point.  Errors in data
C         processing may change the status and, hence, the original
C         intent for data processing is lost
      CALL SUMRY1( ISTAGE )

C---- Test status words (all must be ok, or we skip processing)

      IF( JBSTAT.LT.0 .OR. UASTAT.LT.0 .OR.
     &    SFSTAT.LT.0 .OR. OSSTAT.LT.0 .OR.
     &    MRSTAT.LT.0 .OR. MPSTAT.LT.0 )THEN
         GO TO 10
      ENDIF

      IF( .NOT. SETERR .AND. STABLK(6) .NE. 2 )THEN
C------- Perform STAGE1 or STAGE2 processing

C------- Rewind the temporary file (DEV70) for later use

         REWIND DEV70

C------  UPPERAIR data pathway - extract and/or QA.

         IF( STABLK(2) .EQ. 2  .AND.  JBSTAT .NE. -1 )THEN
            CALL UAPATH
            ISTAGE = 1
         ENDIF

C------- SURFACE data pathway - extract and/or QA.

         IF( STABLK(3) .EQ. 2  .AND.
     &      JBSTAT .NE. -1    .AND.  UASTAT .NE. -1 )THEN
            CALL SFPATH
            ISTAGE = 1
         ENDIF

C------- ONSITE data pathway - QA.

         IF( STABLK(4) .EQ. 2  .AND.  JBSTAT .NE. -1  .AND.
     &       UASTAT .NE. -1    .AND.  SFSTAT .NE. -1 )THEN
            CALL OSPATH
            ISTAGE = 1
         ENDIF

C------- MERGE data pathway.

         IF( STABLK(5) .EQ. 2 .AND.
     &       JBSTAT .NE. -1   .AND.  UASTAT .NE. -1 .AND.
     &       SFSTAT .NE. -1   .AND.  OSSTAT .NE. -1 )THEN
            CALL MRPATH
            ISTAGE = 2
         ENDIF

C------- Close out run, generating the summary of the run.

         WRITE( *,8 )
    8    FORMAT('   Processing completed; writing summary files'/ )

C----    Call the QA audit routine if there was a QA on any pathway

         ISTAT = 0
         IF( (UASTAT .EQ. 2) .OR. (UASTAT .EQ. 3) .OR.
     &       (SFSTAT .EQ. 2) .OR. (SFSTAT .EQ. 3) .OR.
     &       (OSSTAT .EQ. 2) .OR. (OSSTAT .EQ. 3) )THEN
            CALL AUDIT( ISTAGE,ISTAT )
            IF( ISTAT.EQ.1 )THEN
               RUNERR = .TRUE.
            ENDIF
         ENDIF

         IF( STATUS(1,1).EQ.2 )THEN
            DEVICE = DEV50
         ELSE
            DEVICE = DEVIO
         ENDIF

         IF( ISTAGE .EQ. 1 .AND. OSSTAT .NE. 0 )THEN
C----       Call routine to summarize ONSITE values:
C           OBS/HOUR, calm threshold and heights for tower data
            CALL OSSMRY (DEVICE)
         ENDIF

C----    Call the summary routine (the argument defines the stage)
         CALL SUMRY2( ISTAGE )

      ELSEIF( .NOT. SETERR .AND. STATUS(1,3) .EQ. 0 )THEN
C------- Perform STAGE3 processing
C

C------- METPREP data pathway.

         IF( STABLK(6) .EQ. 2 .AND.
     &       JBSTAT .NE. -1   .AND.  UASTAT .NE. -1 .AND.
     &       SFSTAT .NE. -1   .AND.  OSSTAT .NE. -1 .AND.
     &       MRSTAT .NE. -1 )THEN

            ISTAT = 0
            WRITE( *,* ) ' '
C---------- Call MPMET to proces merged data in Stage 3
            CALL MPMET( ISTAT )

            IF( ISTAT .EQ. 1 )THEN
C              An error condition occurred in Stage 3
               MPSTAT = -1
               RUNERR = .TRUE.
            ENDIF
         ENDIF

C        Close out the run, generating such reports as needed.

         WRITE( *, 18 )
   18    FORMAT('   Processing completed; writing summary files'/ )

         CALL MPFIN( ISTAGE )

      ENDIF

C --- Branch statement to skip processing when SETUP errors are found
   10 CONTINUE

      IF( STATUS(1,1) .EQ. 2 )THEN
C ---    Issue message regarding the Summary Report file
         WRITE(DEVIO,5060) DISK50(1:MIN(LEN_TRIM(DISK50),96))
      ENDIF

      IF( SETERR .AND. ISTAGE .EQ. 3 )THEN
C ---    Call MPFIN to get the summary of inputs if
C        setup errors occur for Stage 3
         WRITE( *, 18 )
         CALL MPFIN( ISTAGE )

      ELSEIF( SETERR .AND. (ISTAGE.EQ.1 .OR. ISTAGE.EQ.2) )THEN
C ---    Call SUMRY2 to get the summary of inputs if
C        setup errors occur for Stages 1 or 2
         CALL SUMRY2( ISTAGE )

      ENDIF

C --- Close and delete temporary files
      close(unit=dev70,status="delete")
      close(unit=dev75,status="delete")

      GO TO 910

  900 WRITE(6, '(A17,A)') ' Error opening:  ', INPFILE

  910 CONTINUE

      STOP

5060  FORMAT(/3X,'The Summary Report Generated by AERMET Is In: ',
     &         /5X,A:/)

      END




      BLOCK DATA

      INCLUDE 'MAIN1.INC'
      INCLUDE 'MAIN2.INC'
      INCLUDE 'UA1.INC'
      INCLUDE 'UA2.INC'
      INCLUDE 'SF1.INC'
      INCLUDE 'SF2.INC'
      INCLUDE 'OS1.INC'
      INCLUDE 'OS2.INC'
      INCLUDE 'MP1.INC'
      INCLUDE 'MP2.INC'
      INCLUDE 'BLOCK1.INC'
      INCLUDE 'BLOCK2.INC'

      END
