C     SF1.INC

C     SF PATHWAY

      INTEGER   SFOBS,SFBLKF, IDVAR,NVARS, INK
      CHARACTER VNAMES*4,SFFMT*8,SFLON*8,SFLAT*8,SFLOC*8
      CHARACTER SAMFMT*180
      CHARACTER HUSFMT*200                                               ! dtb #009 01165

      INTEGER, PARAMETER :: SFMH=24, SFMV=56, MAXVAR=26
      INTEGER, PARAMETER :: ASOSMH=24, ASOSMV=3
      
C     Variables Specific to ASOS Records in SFC Files                    
      CHARACTER*8  cCommDate                                             
      INTEGER      iCommDate                                             
      CHARACTER*1  ISASOS1, ISASOS24(24) ! ASOS Tag (N or A)             
      REAL         ASOSOBS                                               
      INTEGER      NADJASOS       ! count of ASOS obs                     
      LOGICAL      SrchCommDate   ! attempt made to find commission date 
      LOGICAL      GotCommDate    ! commission date found (T or F)        
      LOGICAL      GotSfcObsWBAN  ! read first surface observation WBAN  
      LOGICAL      GotSfcObsCALL  ! read first surface observation CALL  
      LOGICAL      ISHD_ASOS      ! user-specified ASOS option for ISHD data
      INTEGER      iSfcObsWBAN    ! Sfc WBAN from first obs or header   
      CHARACTER*5  cSfcObsWBAN    ! Sfc WBAN from first obs or header   
      CHARACTER*4  csfcobsCALL4   ! sfc CALL4 letters from ISHD         
      CHARACTER*3  csfcobsCALL3   ! sfc CALL3 letters from ISHD         
      LOGICAL      ReformattedSFC ! sfc file outside valid date range   
      INTEGER      SfcVldStart    ! valid start date for sfc format     
      INTEGER      SfcVldEnd      ! valid end date for sfc format       
      INTEGER      IWBAN_A1       ! WBAN number for 1-min ASOS wind data
      REAL         ASOS_ANEM_HGT  ! Anemometer height for ASOS station from NCDC list
      
      COMMON /SFBK01/ SFOBS(SFMH,SFMV)
      COMMON /SFBK02/ SFLON,SFLAT,SFFMT,SFLOC, SFBLKF
      COMMON /SFBK03/ VNAMES(SFMV)
      COMMON /SFBK04/ HUSFMT, SAMFMT, IDVAR(MAXVAR), NVARS, INK          ! dtb #107 02024
      COMMON /SFBK10/ ReformattedSFC
      COMMON /ASOS01/ ASOSOBS(ASOSMH,ASOSMV), iCommDate, NADJASOS,   
     &                iSfcObsWBAN
      COMMON /ASOS03/ ISASOS1, ISASOS24, cCommDate, cSfcObsWBAN,     
     &                csfcobsCALL4, csfcobsCALL3
      COMMON /ASOS04/ SrchCommDate, GotCommDate, GotSfcObsWBAN,      
     &                GotSfcobsCALL, ISHD_ASOS
      COMMON /ASOS05/ SfcVldStart, SfcVldEnd, IWBAN_A1, ASOS_ANEM_HGT

c     HUSFMT   Format constructed to read HUSWO data
c     SAMFMT   Format constructed to read SAMSON data
c     IDVAR    The variable ID number for processing HUSWO or SAMSON data
c     INK      Reset value (minutes) for ISHD extraction; default is     ! dtb #107 02024
c                  zero (no reset)                                       ! dtb #107 02024

C     SFMH     MAXIMUM NUMBER OF HOURS MERGED
C     SFMV     MAXIMUM NUMBER OF WXX OBSERVATION VARIABLES
C     SFLOC    HOURLY SURFACE STATION ID
C     SFOBS    MASTER DATA ARRAY FOR SURFACE DATA
C     SFLAT    STATION LATITUDE*100 (DEGREES) (E.G. 3034N)
C     SFLON    STATION LONGITUDE*100 (DEGREES)
C     SFFMT    SURFACE WEATHER DATA FORMAT (E.G 144FB)
C     SFBLKF   BLOCKING FACTOR FOR NWS DATA FILE (not of any real use
C              but removing it requires detailed review of consequences)
C     VNAMES   4-LETTER VARIABLE NAMES FOR VARIOUS WEATHER VARIABLES
C
C     ASOSOBS  MASTER ARRAY OF HRLY-AVERAGED 1-MIN ASOS OBSERVATIONS
C              These data are read from a file generated by EPA's
C               converter program of 1-min data to hour averages.
C              ASOSOBS(hr,1) = WIND SPEED (M/S)
C              ASOSOBS(hr,2) = WIND DIRECTION (DEGREES)
C              ASOSOBS(hr,3) = ANEMOMETER HT (M)
C     NCommDates Maximum number of stations allowed to define the

C     iCommDate      ASOS commissioning date - integer
C     cCommDate      ASOS commissioning date - character        
C     ISASOS1        ASOS flag for NWS surface obs
C     ISASOS24(24)   ASOS flag for NWS surface obs - up to 24 obs
C     NADJASOS       Count of ASOS records in NWS surface file    
C     SrchCommDate   Has commission date been looked up? T or F
C     GotCommDate    Was commission date found? T or F
C     GotSfcObsWBAN  Is there a NWS Sfc file WBAN in sfc file? T or F
C     iSfcObsWBAN    WBAN in NWS sfc file - integer
C     cSfcObsWBAN    WBAN in NWS sfc file - character
C     ReformattedSFC Does NWS surface file appear to be reformated 
C                    based on valid date range
C     SfcVldStart    Valid start date for NWS sfc file format
C     SfcVldEnd      Valid end date for NWS sfc file format
C     ASOSData       ASOS commissioning information for NWS sfc station 
