library(dplyr)


a <- paste("/work/MOD3EVAL/kbaker/projects/cfire/data/facts/facts_2023nov25version.csv",sep="")
one <- read.csv(file=a,skip=0,header=T,row.names=NULL)
one$CZ <- 0
one$CZ <- ifelse(one$longitude < -100 , 1,one$CZ)
head(one)


q = c(0.0,.01, .5, .99,1.0)


#calculate quantiles by grouping variable

test <- one %>%
  group_by(CZ) %>%
  summarize(min = quantile(acres_accomplished, probs = q[1]),
            low = quantile(acres_accomplished, probs = q[2]),
            mid = quantile(acres_accomplished, probs = q[3]),
            high = quantile(acres_accomplished, probs = q[4]),
            max = quantile(acres_accomplished, probs = q[5]))

test <- as.data.frame(test)
test

east <- subset(one,longitude > -100) 
west <- subset(one,longitude < -100)
xeast <- subset(east,acres_accomplished > 0.5 & acres_accomplished < 8133)
xwest <- subset(west,acres_accomplished > 0.1 & acres_accomplished < 14349)

qa <- subset(one,acres_accomplished>89000)
qa
qa <- subset(one,acres_accomplished==31208)
qa



both <- rbind(xeast,xwest)
head(both)


test <- both %>%
  group_by(CZ) %>%
  summarize(min = quantile(acres_accomplished, probs = q[1]),
            low = quantile(acres_accomplished, probs = q[2]),
            mid = quantile(acres_accomplished, probs = q[3]),
            high = quantile(acres_accomplished, probs = q[4]),
            max = quantile(acres_accomplished, probs = q[5]))

test <- as.data.frame(test)
test





write.table(both, file='facts_subset.csv', sep=",",row.names=FALSE,quote=FALSE)


