       program rfmx

!----------------------------------------------------------------------

c *** Variable declarations
      implicit none
      
      include 'PARMS3.EXT'
      include 'IODECL3.EXT'
      include 'FDESC3.EXT'

      INTEGER :: NCOLS, NROWS, NLAYS, NVARS, JDATE, JTIME, RUNLEN
      INTEGER :: TSTEP, NSTEPS, I,V, T, VMAX, UMAX, DMAX, newi,newj
      CHARACTER*16    VNAME( MXVARS3 ) !  list of vble names, from user
      CHARACTER*16    UNITS( MXVARS3 ) !  list of vble units
      CHARACTER*80    VDESC( MXVARS3 ) !  list of vble descs
      CHARACTER*256   MESG    !  buffer for m3exit(), etc
      CHARACTER*16    INAME   !  logical name of the input file
      LOGICAL         EFLAG !flag: error has happened

      REAL    :: rlon0,rlat0,tlat1,tlat2,xloc,yloc,rlat,rlon,xpos,ypos
      REAL    :: xorg,yorg,dx,xlong,xlat,beta1,beta2,weight, beta3
      REAL    :: beta1ts, beta2ts, beta1sr, beta2sr, beta3ts, beta3sr
      REAL    :: beta4ts, beta4sr, beta4, totdist,epm
      INTEGER :: xorig,yorig,nx,ny,IH,j,tempy,tempx,ii,jj, id, height
      integer :: npri,nso4,nno3,ncm,nid,no3n,no3v
      integer :: xyear,xpri,xcm,xo3n,xo3v,xso4,xno3,xx,yy
      integer    c, r, k, layer, hour, ihour, idate, n, nfiles,HOURS
      integer :: xnh4, flag
      real cfac,cfac2,distance,  lat,long, conc,qano3

      REAL, ALLOCATABLE :: xn4lat(:),xn4lon(:)
      REAL, ALLOCATABLE :: xplat(:),xplon(:),xslat(:),xslon(:)
      REAL, ALLOCATABLE :: xnlat(:),xnlon(:),xclat(:),xclon(:)
      REAL, ALLOCATABLE :: xo3nlat(:),xo3nlon(:),xo3vlat(:),xo3vlon(:)
      REAL, ALLOCATABLE :: zno3(:,:,:),zso4(:,:,:),zcm(:,:,:)
      REAL, ALLOCATABLE :: zpri(:,:,:),zo3n(:,:,:),zo3v(:,:,:)
      REAL, ALLOCATABLE :: znh4(:,:,:)

      REAL, ALLOCATABLE :: TOTS( :,:,:),QA(:,:,:),qd(:,:,:),emissum(:)
      REAL, ALLOCATABLE :: ammonia(:,:),o3n(:,:,:),o3v(:,:,:),nh4(:,:,:)
      REAL, ALLOCATABLE :: convfac(:),no3(:,:,:),so4(:,:,:),cm(:,:,:)
      REAL, ALLOCATABLE :: GRID( :,:,:),pri(:,:,:),xloca(:,:),yloca(:,:)
      REAL, ALLOCATABLE :: latit(:,:),longi(:,:),stktk(:,:),acres(:,:)
      INTEGER, ALLOCATABLE :: row(:,:),col(:,:),dups(:),stkht(:,:)
      REAL, ALLOCATABLE :: stackpri(:),emispri(:),latpri(:),longpri(:)
      REAL, ALLOCATABLE :: stackso4(:),emisso4(:),latso4(:),longso4(:)
      REAL, ALLOCATABLE :: stacknh4(:),emisnh4(:),latnh4(:),longnh4(:)
      REAL, ALLOCATABLE :: stackno3(:),emisno3(:),latno3(:),longno3(:)
      REAL, ALLOCATABLE :: stacko3n(:),emiso3n(:),lato3n(:),longo3n(:)
      REAL, ALLOCATABLE :: stacko3v(:),emiso3v(:),lato3v(:),longo3v(:)
      REAL, ALLOCATABLE :: stackcm(:),emiscm(:),latcm(:),numb(:,:,:)
      INTEGER, ALLOCATABLE :: xday(:),xtime(:),ids(:)

      CHARACTER(LEN=16) :: progname
      CHARACTER(LEN=16) :: aqtarget, outfile, outfileqd
      CHARACTER(LEN=280) :: ename(366),xname(366),land,fname,aname

      INTEGER :: istatus, MXREC, JSTEP
      INTEGER :: TRIMLEN
      real       envreal

      EXTERNAL TRIMLEN, envreal

c *** Initialize variables
      progname = 'PCAPS'


c      read(*,'(a)') fname
c      read(fname,*) rlon0,rlat0,tlat1,tlat2,nx,ny,xorg,yorg,dx
c      write(*,'(a,t20,3f10.0)') 'Projection:',rlon0,rlat0,tlat1,tlat2
c      write(*,*) 'X and Y cells:',nx,ny
c      xorg=xorg*1000.
c      yorg=yorg*1000.
c      dx=dx*1000.
c      write(*,*) 'X orig, Y orig, cell size (m):',xorg,yorg,dx

c      read(*,'(a)') fname
c      read(fname,*) xyear
c      write(*,*)'Year for output file:', xyear

c      read(*,'(a)') fname
c      write(*,*) 'Pattern location file:',fname
c        open(15,file=fname,status='old')



      read(*,'(a)') fname
      write(*,*) 'Pattern air quality surfaces file:',fname
        open(16,file=fname,status='old')

      read(*,'(a)') fname
      open(8,file=fname,status='unknown',form='formatted')
      write(*,*)'Text output file normalized patterns:',fname

      read(*,'(a)') fname
      open(18,file=fname,status='unknown',form='formatted')
      write(*,*)'Text output file pattern list:',fname


c---- Allocate and clear main program arrays

      allocate ( TOTS(NX, NY , 900) )
      allocate ( qd(nx,ny, 900))
      allocate (ammonia(NX,NY))

      allocate (no3(900,nx,ny))
      allocate (zno3(900,nx,ny))
      allocate (numb(900,nx,ny))
   
      allocate (stackno3(900))
      allocate (latno3(900))
      allocate (longno3(900))
      allocate (emisno3(900))

      allocate (dups(900))
      allocate (xnlat(900),xnlon(900))
      allocate (xo3nlat(900),xo3nlon(900))


c---- read in pattern air quality surface files

ccccccccc pattern air qualiy surface file

          id = 1
          nid = 1

        read(16,*) !read header line

 918    continue

         do r = 1, nx
          do c = 1, ny
          read(16,*,end=919) idate,iname,i,j,epm,height,lat,long,conc
c        write(*,*) idate,iname,i,j,epm,height,lat,long,conc

           no3(id,i,j) = conc
          enddo
         enddo

           latno3(id) = lat
           longno3(id) = long
           emisno3(id) = epm
           stackno3(id) = height

           if(id.eq.1) then
           xnlat(id) = lat
           xnlon(id) = long
           endif

           flag = 0
           do k = 1, nid
        if(xnlat(k).eq.lat.and.
     &     xnlon(k).eq.long) then 
           flag = 1
        endif
           enddo

           if(flag.eq.0) then
           nid = nid + 1
           xnlat(nid) = lat
           xnlon(nid) = long
           endif


          id = id + 1

          goto 918
 919      continue


          id = id - 1
        write(*,*)'total number of patterns:',id
        write(*,*)'total number of unique pattern locatios:',nid

        do i = 1, id
         write(*,*) i,latno3(i),longno3(i),emisno3(i),stackno3(i)
        enddo

        do i = 1, nid
         write(*,*) i,xnlat(i),xnlon(i)
        enddo


c--- prep work

          do C = 1, nid
           dups(C) = 0
          enddo

c--normalize aq surfaces for nitrate

           do i = 1, nid


           do ii = 1,nx
           do jj = 1,ny
            zno3(i,ii,jj) = 0.
            numb(i,ii,jj) = 0.
           enddo
           enddo

            do j = 1, id

            if(xnlat(i).eq.latno3(j).and.
     &        xnlon(i).eq.longno3(j) ) then
            dups(i) = dups(i) + 1
             !aggregate same location patterns

           do ii = 1,nx
           do jj = 1,ny
c            if(no3(j,ii,jj).gt.0) then
            zno3(i,ii,jj) = zno3(i,ii,jj)+
     &      no3(j,ii,jj)/emisno3(j) !adjust for emissions
            numb(i,ii,jj) = numb(i,ii,jj) + 1.
c            else
c            zno3(i,ii,jj) = -9. !keep missing values
c            endif
           enddo
           enddo

            endif

           enddo ! end loop over all patterns
           enddo !end loop over unique patterns




           do i = 1, nid
           do ii = 1,nx !average patterns for each unique source
           do jj = 1,ny
c             write(*,*)'QA:',zno3(23,90,193),numb(23,90,193)
c             write(*,*)'QA:',zno3(23,190,193),numb(23,190,193)
            if(zno3(i,ii,jj).gt.0) then
            zno3(i,ii,jj) = zno3(i,ii,jj) / numb(i,ii,jj)
            else
            zno3(i,ii,jj) = -9.
            endif
           enddo
           enddo
           enddo !end loop over unique patterns


ccccccc------ write to output files
ccccccc------ text format file for comparison purposes


       write(8,887)
 887  format('I,J,K,TRANSCOEF')

       do R = 1, nid
         do ii = 1,nx !average patterns for each unique source
         do jj = 1,ny
          write(8,888) R, ii, jj, zno3(R,ii,jj)
         enddo
         enddo
       enddo

 888  format(i4,',',i4,',',i4,',',f30.20)



       write(18,987)
 987  format('I,LAT,LONG,N')

       do R = 1, nid
          write(18,889) R,xnlat(R),xnlon(R),dups(R)
       enddo

 889  format(i4,',',f20.10,',',f20.10,',',i5)




C******************  FORMAT  STATEMENTS   ******************************

C...........   Error and warning message formats..... 91xxx

91000   FORMAT ( //5X , '*** ERROR ABORT in program VERTOT ***',
     &            /5X , A ,
     &           // )        !  generic error message format

C...........   Informational (LOG) message formats... 92xxx

92000   FORMAT ( 5X , A )

92999   FORMAT ( //5X , A, // )

C...........   Formatted file I/O formats............ 93xxx

93000   FORMAT ( A16 )

C...........   Internal buffering formats............ 94xxx

C...........   Miscellaneous formats................. 95xxx

95000   FORMAT ( /5X , A , $ )          !  generic prompt format.


      stop

      END


c-----Start subroutines
      subroutine lcpgeo(iway,phic,xlonc,truelat1,truelat2,xloc,yloc,
     &                  xlon,ylat)
c
c     LCPGEO performs Lambert Conformal to geodetic (lat/lon) translation
c
c     Code based on the TERRAIN preprocessor for MM5 v2.0,
c     developed by Yong-Run Guo and Sue Chen, National Center for
c     Atmospheric Research, and Pennsylvania State University
c     10/21/1993
c
c     Input arguments:
c        iway                Conversion type
c                            0 = geodetic to Lambert Conformal
c                            1 = Lambert Conformal to geodetic
c        phic                Central latitude (deg, neg for southern hem)
c        xlonc               Central longitude (deg, neg for western hem)
c        truelat1            First true latitute (deg, neg for southern hem)
c        truelat2            Second true latitute (deg, neg for southern hem)
c        xloc/yloc           Projection coordinates (km)
c        xlon/ylat           Longitude/Latitude (deg)
c
c     Output arguments:
c        xloc/yloc           Projection coordinates (km)
c        xlon/ylat           Longitude/Latitude (deg)
c
      data conv/57.29578/, a/6370./
c
c-----Entry Point
c
      if (phic.lt.0) then
        sign = -1.
      else
        sign = 1.
      endif
      pole = 90.
      if (abs(truelat1).gt.90.) then
        truelat1 = 60.
        truelat2 = 30.
        truelat1 = sign*truelat1
        truelat2 = sign*truelat2
      endif
      xn = alog10(cos(truelat1/conv)) - alog10(cos(truelat2/conv))
      xn = xn/(alog10(tan((45. - sign*truelat1/2.)/conv)) -
     &         alog10(tan((45. - sign*truelat2/2.)/conv)))           
      psi1 = 90. - sign*truelat1
      psi1 = psi1/conv
      if (phic.lt.0.) then
        psi1 = -psi1
        pole = -pole
      endif
      psi0 = (pole - phic)/conv
      xc = 0.
      yc = -a/xn*sin(psi1)*(tan(psi0/2.)/tan(psi1/2.))**xn
c
c-----Calculate lat/lon of the point (xloc,yloc)
c
      if (iway.eq.1) then
        xloc = xloc + xc
        yloc = yloc + yc
        if (yloc.eq.0.) then
          if (xloc.ge.0.) flp = 90./conv
          if (xloc.lt.0.) flp = -90./conv
        else
          if (phic.lt.0.) then
            flp = atan2(xloc,yloc)
          else
            flp = atan2(xloc,-yloc)
          endif
        endif
        flpp = (flp/xn)*conv + xlonc
        if (flpp.lt.-180.) flpp = flpp + 360.
        if (flpp.gt. 180.) flpp = flpp - 360. 
        xlon = flpp 
c
        r = sqrt(xloc*xloc + yloc*yloc)
        if (phic.lt.0.) r = -r
        cell = (r*xn)/(a*sin(psi1))
        rxn  = 1.0/xn
        cel1 = tan(psi1/2.)*cell**rxn
        cel2 = atan(cel1)
        psx  = 2.*cel2*conv
        ylat = pole - psx
c
c-----Calculate x/y from lat/lon
c
      else
        ylon = xlon - xlonc
        if (ylon.gt. 180.) ylon = ylon - 360.
        if (ylon.lt.-180.) ylon = ylon + 360.
        flp = xn*ylon/conv
        psx = (pole - ylat)/conv
        r = -a/xn*sin(psi1)*(tan(psx/2.)/tan(psi1/2.))**xn
        if (phic.lt.0.) then
          xloc = r*sin(flp)
          yloc = r*cos(flp)
        else
          xloc = -r*sin(flp)
          yloc =  r*cos(flp)
        endif
      endif
c
      xloc = xloc - xc
      yloc = yloc - yc
c
      return
      end

      subroutine caldate(idate)

      integer idate
      dimension nday(12)
      data nday/31,28,31,30,31,30,31,31,30,31,30,31/

c
c-----Entry point
c
c-----If it is already in calender date, return
c

      icent = int(idate/100000)
      iyear = int((idate - icent*100000)/1000)
      jday = idate - icent*100000 - iyear*1000

      nday(2) = 28
      if (mod(iyear,4).eq.0) nday(2) = 29
      mday = 0
      do imonth = 1,12
        mday = mday + nday(imonth)
        if (mday.ge.jday) go to 20
      enddo
 20   iday = jday - (mday - nday(imonth))
      idate = icent*1000000 + iyear*10000 + imonth*100 + iday
c
c      write(*,'(4i6)') icent,iyear,imonth,iday

      return
      end
