       program rfmx

!----------------------------------------------------------------------

c *** Variable declarations
      implicit none
      
      include 'PARMS3.EXT'
      include 'IODECL3.EXT'
      include 'FDESC3.EXT'

      INTEGER :: NCOLS, NROWS, NLAYS, NVARS, JDATE, JTIME, RUNLEN
      INTEGER :: TSTEP, NSTEPS, I,V, T, VMAX, UMAX, DMAX, newi,newj
      CHARACTER*16    VNAME( MXVARS3 ) !  list of vble names, from user
      CHARACTER*16    UNITS( MXVARS3 ) !  list of vble units
      CHARACTER*80    VDESC( MXVARS3 ) !  list of vble descs
      CHARACTER*256   MESG    !  buffer for m3exit(), etc
      CHARACTER*16    INAME   !  logical name of the input file
      LOGICAL         EFLAG !flag: error has happened

      REAL    :: rlon0,rlat0,tlat1,tlat2,xloc,yloc,rlat,rlon,xpos,ypos
      REAL    :: xorg,yorg,dx,xlong,xlat,beta1,beta2,weight, beta3
      REAL    :: beta1ts, beta2ts, beta1sr, beta2sr, beta3ts, beta3sr
      REAL    :: beta4ts, beta4sr, beta4, totdist,epm,xpri,xcm,xo3n,xo3v
      INTEGER :: xorig,yorig,nx,ny,IH,j,tempy,tempx,ii,jj, id, height
      integer :: npri,nso4,nno3,ncm,nid,no3n,no3v,xyear,xso4,xno3,xo3
      integer    c, r, k, layer, hour, ihour, idate, n, nfiles,HOURS
      integer :: xnh4, nnh4
      integer oldi,oldj,adji,adjj,xi,xj
      real cfac,cfac2,distance,  lat,long, conc,qano3,emissum,adja,adjb

      REAL, ALLOCATABLE :: xxlat(:),xxlon(:)
      REAL, ALLOCATABLE :: xplat(:),xplon(:),xslat(:),xslon(:)
      REAL, ALLOCATABLE :: xnlat(:),xnlon(:),xclat(:),xclon(:)
      REAL, ALLOCATABLE :: xo3nlat(:),xo3nlon(:),xo3vlat(:),xo3vlon(:)
      REAL, ALLOCATABLE :: zno3(:,:,:),zso4(:,:,:),zcm(:,:,:)
      REAL, ALLOCATABLE :: znh4(:,:,:)
      REAL, ALLOCATABLE :: zpri(:,:,:),zo3n(:,:,:),zo3v(:,:,:)

      REAL, ALLOCATABLE :: TOTS( :,:,:),QA(:,:,:),qd(:,:,:)
      REAL, ALLOCATABLE :: ammonia(:,:),o3n(:,:,:),o3v(:,:,:),nh4(:,:,:)
      REAL, ALLOCATABLE :: indica(:,:),indicb(:,:),indic(:,:)
      REAL, ALLOCATABLE :: convfac(:),no3(:,:,:),so4(:,:,:),cm(:,:,:)
      REAL, ALLOCATABLE :: GRID( :,:,:),pri(:,:,:),xloca(:,:),yloca(:,:)
      REAL, ALLOCATABLE :: latit(:,:),longi(:,:),stktk(:,:),acres(:,:)
      INTEGER, ALLOCATABLE :: row(:,:),col(:,:),fips(:,:),stkht(:,:)
      REAL, ALLOCATABLE :: stackpri(:),emispri(:),latpri(:),longpri(:)
      REAL, ALLOCATABLE :: stackso4(:),emisso4(:),latso4(:),longso4(:)
      REAL, ALLOCATABLE :: stacknh4(:),emisnh4(:),latnh4(:),longnh4(:)
      REAL, ALLOCATABLE :: stackno3(:),emisno3(:),latno3(:),longno3(:)
      REAL, ALLOCATABLE :: stacko3n(:),emiso3n(:),lato3n(:),longo3n(:)
      REAL, ALLOCATABLE :: stacko3v(:),emiso3v(:),lato3v(:),longo3v(:)
      REAL, ALLOCATABLE :: stackcm(:),emiscm(:),latcm(:),longcm(:)
      INTEGER, ALLOCATABLE :: xday(:),xtime(:),ids(:)

      CHARACTER(LEN=16) :: progname
      CHARACTER(LEN=16) :: aqtarget, outfile, outfileqd
      CHARACTER(LEN=180) :: ename(366),xname(366),land,fname,aname

      INTEGER :: istatus, MXREC, JSTEP
      INTEGER :: TRIMLEN
      real       envreal

      EXTERNAL TRIMLEN, envreal

c *** Initialize variables
      progname = 'PCAPS'

      cfac = (1./1000.) * 0.001102293 * 3600. !convert from g to tons and sec to hour

      write(*,*) 'max vars',MXVARS3

      read(*,'(a)') fname
      read(fname,*) rlon0,rlat0,tlat1,tlat2,nx,ny,xorg,yorg,dx
      write(*,'(a,t20,3f10.0)') 'Projection:',rlon0,rlat0,tlat1,tlat2
      write(*,*) 'X and Y cells:',nx,ny
      xorg=xorg*1000.
      yorg=yorg*1000.
      dx=dx*1000.
      write(*,*) 'X orig, Y orig, cell size (m):',xorg,yorg,dx

      read(*,'(a)') outfile
      write(*,*)'Output emissions QA file:', outfile

      read(*,'(a)') outfileqd
      write(*,*)'Output air quality file:', outfileqd

      read(*,'(a)') aname
      write(*,*)'Input air quality surface file:', aname

      read(*,'(a)') fname
      read(fname,*) xyear
      write(*,*)'Year for output file:', xyear

      read(*,'(a)') fname
      write(*,*) 'Primary PM25 location file:',fname
        open(11,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'Primary PM25 air quality surfaces file:',fname
        open(12,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'PM25 sulfate location file:',fname
        open(13,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'PM25 sulfate air quality surfaces file:',fname
        open(14,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'PM25 nitrate location file:',fname
        open(15,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'PM25 nitrate air quality surfaces file:',fname
        open(16,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'PM coarse location file:',fname
        open(17,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'PM coarse air quality surfaces file:',fname
        open(18,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'O3N location file:',fname
        open(19,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'O3N air quality surfaces file:',fname
        open(20,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'O3V location file:',fname
        open(21,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'O3V air quality surfaces file:',fname
        open(22,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'PM25 ammonium location file:',fname
        open(23,file=fname,status='old')

      read(*,'(a)') fname
      write(*,*) 'PM25 ammonium air quality surfaces file:',fname
        open(24,file=fname,status='old')

      read(*,'(a)') fname
      read(fname,*) nfiles
      write(*,'(a,t20,i5)') '# of gridded files:',nfiles

      do n = 1, nfiles
      read(*,'(a)') ename(n)
      enddo


c---- Allocate and clear main program arrays

      allocate ( TOTS(NX, NY , 500) )
      allocate ( QA(nx,ny, 500))
      allocate ( qd(nx,ny, 500))

      allocate (convfac(500))
      allocate (ammonia(NX,NY))
      allocate (indica(NX,NY))
      allocate (indicb(NX,NY))
      allocate (indic(NX,NY))

      allocate (zpri(900,nx,ny))
      allocate (zso4(900,nx,ny))
      allocate (zno3(900,nx,ny))
      allocate (zcm(900,nx,ny))
      allocate (zo3n(900,nx,ny))
      allocate (zo3v(900,nx,ny))
      allocate (znh4(900,nx,ny))

      allocate (xslat(900),xslon(900))
      allocate (xxlat(900),xxlon(900))
      allocate (xnlat(900),xnlon(900))
      allocate (xclat(900),xclon(900))
      allocate (xplat(900),xplon(900))
      allocate (xo3nlat(900),xo3nlon(900))
      allocate (xo3vlat(900),xo3vlon(900))

        DO R = 1, ny
         DO C = 1, nx
         ammonia(C,R) = 0.0
         indic(C,R) = 1.0
          do V = 1, 500
           TOTS( C,R,V ) = 0.0
           QA(c,r,v) = 0.0
           qd(c,r,v) = 0.0
          ENDDO
         ENDDO
        ENDDO

c---- read in air quality surface input file

      land = aname

      if ( .not. open3( land, FSREAD3, progname ) ) THEN
         MESG = 'Could not open file "' //
     &   land( 1: TRIMLEN(land))
     &   // '" for input'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

      IF ( .NOT. DESC3(land))THEN
         MESG = 'Could not get description info for file "' //
     &            land( 1: TRIMLEN( land) ) //'"'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      ENDIF

        NCOLS = NCOLS3D
        NROWS = NROWS3D
        NLAYS = NLAYS3D
        TSTEP = TSTEP3D
        JSTEP = TSTEP3D

       write(*,*) NCOLS,NROWS,NLAYS,TSTEP,NVARS3D
       write(*,*) 'Done reading stack file'

                NVARS = NVARS3D
                DO  V = 1, NVARS3D
                 VNAME( V ) = VNAME3D( V )
                 UNITS( V ) = UNITS3D( V )
                 VDESC( V ) = VDESC3D( V )
                 EFLAG = EFLAG .OR. ( VTYPE3D( V ) .NE. M3REAL )
                END DO
       
       JDATE = SDATE3D
       JTIME = STIME3D

        DO  V = 1, NVARS

             if(VNAME(V).eq.'NH3') then
             write(*,*) 'Found ammonia surface'
            IF ( .NOT. READ3( land, VNAME( V ), ALLAYS3,
     &                        JDATE, JTIME, ammonia ) ) THEN
                MESG = 'Read failure:  file ' // land //
     &                 ' variable ' // VNAME( V )
                CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                       MESG, 2 )
            END IF      !  if read3() failed
             endif

             if(VNAME(V).eq.'O3IND2007') then
             write(*,*) 'Found O3 indicator 2007 surface'
            IF ( .NOT. READ3( land, VNAME( V ), ALLAYS3,
     &                        JDATE, JTIME, indica ) ) THEN
                MESG = 'Read failure:  file ' // land //
     &                 ' variable ' // VNAME( V )
                CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                       MESG, 2 )
            END IF      !  if read3() failed
             endif

             if(VNAME(V).eq.'O3IND2016') then
             write(*,*) 'Found O3 indicator 2016 surface'
            IF ( .NOT. READ3( land, VNAME( V ), ALLAYS3,
     &                        JDATE, JTIME, indicb ) ) THEN
                MESG = 'Read failure:  file ' // land //
     &                 ' variable ' // VNAME( V )
                CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                       MESG, 2 )
            END IF      !  if read3() failed
             endif

         ENDDO


c  Values indicate:  0 = No days, 1 = NOx Lim, 2 = NOx Sat, 3 = Mixed


        DO j = 1, ny
         DO i = 1, nx

          if(xyear.le.2012) then
           if(indica(i,j).gt.1) then
           write(*,*)'VOC limited at ',xyear,i,j
           indic(i,j) = 0.0 
           endif
          else 
           if(indicb(i,j).gt.1) then
           indic(i,j) = 0.0
           endif
          endif

           enddo
          enddo




ccccccccc pattern location file for primary PM25

        nid = 0

        read(11,*) !read header line
 898    continue
        read(11,*,end=899) id,lat,long

           xplat(id) = lat
           xplon(id) = long

           nid = nid + 1

          goto 898
 899      continue

        xpri = nid

        write(*,*)'Total unique source locations for PM25',xpri


        read(12,*) !read header line
        do k = 1, xpri
         do c = 1, nx
          do r = 1, ny
          read(12,*) id,i,j,conc
c          if(id.eq.k.and.i.eq.c.and.j.eq.r) then
          zpri(id,i,j) = conc
c          else
c          write(*,*)k,c,r,id,i,j
c          stop
c          endif
          enddo
         enddo
        enddo

ccccccccc pattern air qualiy surface file sulfate

        nid = 0

        read(13,*) !read header line
 700    continue
        read(13,*,end=710) id,lat,long

           xslat(id) = lat
           xslon(id) = long

           nid = nid + 1

          goto 700
 710      continue

        xso4 = nid

        write(*,*)'Total unique source locations for sulfate',xso4

        read(14,*) !read header line
        do k = 1, xso4
         do r = 1, nx
          do c = 1, ny
          read(14,*) id,i,j,conc
          zso4(id,i,j) = conc
          enddo
         enddo
        enddo

ccccccccc pattern air qualiy surface file nitrate

        nid = 0

        read(15,*) !read header line
 701    continue
        read(15,*,end=711) id,lat,long

           xnlat(id) = lat
           xnlon(id) = long

           nid = nid + 1

          goto 701
 711      continue

        xno3 = nid

        write(*,*)'Total unique source locations for nitrate',xno3

        read(16,*) !read header line
        do k = 1, xno3
         do r = 1, nx
          do c = 1, ny
          read(16,*) id,i,j,conc
          zno3(id,i,j) = conc
          enddo
         enddo
        enddo

ccccccccc pattern air qualiy surface file CM


        nid = 0

        read(17,*) !read header line
 702    continue
        read(17,*,end=712) id,lat,long

           xclat(id) = lat
           xclon(id) = long

           nid = nid + 1

          goto 702
 712      continue

        xcm = nid

        write(*,*)'Total unique source locations for coarse mass',xcm

        read(18,*) !read header line
        do k = 1, xcm
         do r = 1, nx
          do c = 1, ny
          read(18,*) id,i,j,conc
          zcm(id,i,j) = conc
          enddo
         enddo
        enddo

ccccccccc pattern air qualiy surface file O3N


        nid = 0

        read(19,*) !read header line
 703    continue
        read(19,*,end=713) id,lat,long

           xo3nlat(id) = lat
           xo3nlon(id) = long

           nid = nid + 1

          goto 703
 713      continue

        xo3n = nid

        write(*,*)'Total unique source locations for O3N',xo3n

        read(20,*) !read header line
        do k = 1, xo3n
         do r = 1, nx
          do c = 1, ny
          read(20,*) id,i,j,conc
          zo3n(id,i,j) = conc
          enddo
         enddo
        enddo

 

ccccccccc pattern air qualiy surface file O3V

        nid = 0

        read(21,*) !read header line
 704    continue
        read(21,*,end=714) id,lat,long

           xo3vlat(id) = lat
           xo3vlon(id) = long

           nid = nid + 1

          goto 704
 714      continue

        xo3v = nid

        write(*,*)'Total unique source locations for O3V',xo3v

        read(22,*) !read header line
        do k = 1, xo3v
         do r = 1, nx
          do c = 1, ny
          read(22,*) id,i,j,conc
          zo3v(id,i,j) = conc
          enddo
         enddo
        enddo


ccccccccc pattern air qualiy surface file ammonium

        nid = 0

        read(23,*) !read header line
 601    continue
        read(23,*,end=611) id,lat,long

           xxlat(id) = lat
           xxlon(id) = long

           nid = nid + 1

          goto 601
 611      continue

        xnh4 = nid

        write(*,*)'Total unique source locations for ammonium',xnh4

        read(24,*) !read header line
        do k = 1, xnh4
         do r = 1, nx
          do c = 1, ny
          read(24,*) id,i,j,conc
          znh4(id,i,j) = conc
          enddo
         enddo
        enddo




c---- start processing emission input files

      do n = 1, nfiles

c---- open ioapi file: gridded info

      land = ename(n)

      if ( .not. open3( land, FSREAD3, progname ) ) THEN
         MESG = 'Could not open file "' //
     &   land( 1: TRIMLEN(land))
     &   // '" for input'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

      IF ( .NOT. DESC3(land))THEN
         MESG = 'Could not get description info for file "' //
     &            land( 1: TRIMLEN( land) ) //'"'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      ENDIF

        NCOLS = NCOLS3D
        NROWS = NROWS3D
        NLAYS = NLAYS3D
        TSTEP = TSTEP3D
        JSTEP = TSTEP3D
        MXREC = MXREC3D


       write(*,*) NCOLS,NROWS,NLAYS,TSTEP,NVARS3D
       write(*,*) 'Reading emissions file'

       if(n.eq.1) then ! clear array for annual total emissions
 
       allocate ( GRID(NCOLS, NROWS, NLAYS) )
c      allocate ( QA(NCOLS, NROWS, 500))
 
c        DO V = 1, 500
c           DO R = 1, NROWS
c            DO C = 1, NCOLS
c                QA(C,R,V) = 0.0
c            ENDDO
c           ENDDO
c         ENDDO

        endif

C.......   Get max string-lengths for use in variables-listing:

        VMAX = TRIMLEN( VNAME3D( 1 ) )
        UMAX = TRIMLEN( UNITS3D( 1 ) )
        DMAX = TRIMLEN( VDESC3D( 1 ) )
        DO  I = 1, NVARS3D
            VMAX = MAX( VMAX , TRIMLEN( VNAME3D( I ) ) )
            UMAX = MAX( UMAX , TRIMLEN( UNITS3D( I ) ) )
            DMAX = MAX( DMAX , TRIMLEN( VDESC3D( I ) ) )
        END DO

        WRITE( *,92000 )
     &  ' ', 'The list of variables in this file is:', ' ',
     &  ( VNAME3D( I )( 1:VMAX ) // ' (' //
     &    UNITS3D( I )( 1:UMAX ) // '): ' //
     &    VDESC3D( I )( 1:DMAX ), I = 1, NVARS3D )

        write(*,*) NVARS3D

                NVARS = NVARS3D
                DO  V = 1, NVARS3D
                 VNAME( V ) = VNAME3D( V )
                 UNITS( V ) = UNITS3D( V )
                 VDESC( V ) = VDESC3D( V )
                 EFLAG = EFLAG .OR. ( VTYPE3D( V ) .NE. M3REAL )

         convfac(V) = 1.*cfac
        if(VNAME(V).eq.'NO') convfac(V) = 30.*cfac
        if(VNAME(V).eq.'NO2') convfac(V) = 46.*cfac
        if(VNAME(V).eq.'CO') convfac(V) = 28.*cfac
        if(VNAME(V).eq.'SO2') convfac(V) = 64.*cfac
        if(VNAME(V).eq.'NH3') convfac(V) = 17.*cfac

        if(VNAME(V).eq.'ACET') convfac(V) = 58.*cfac
        if(VNAME(V).eq.'BENZ') convfac(V) = 78.*cfac
        if(VNAME(V).eq.'ETHY') convfac(V) = 26.*cfac
        if(VNAME(V).eq.'KET') convfac(V) = 72.*cfac
        if(VNAME(V).eq.'NAPH') convfac(V) = 128.*cfac
        if(VNAME(V).eq.'PRPA') convfac(V) = 44.*cfac
        if(VNAME(V).eq.'XYLMN') convfac(V) = 128.*cfac
        if(VNAME(V).eq.'ALD2') convfac(V) = 44.*cfac
        if(VNAME(V).eq.'ALDX') convfac(V) = 44.*cfac
        if(VNAME(V).eq.'ETH') convfac(V) = 28.*cfac
        if(VNAME(V).eq.'ETHA') convfac(V) = 30.*cfac
        if(VNAME(V).eq.'FORM') convfac(V) = 16.*cfac
        if(VNAME(V).eq.'TOL') convfac(V) = 92.*cfac
        if(VNAME(V).eq.'XYL') convfac(V) = 128.*cfac
        if(VNAME(V).eq.'MEOH') convfac(V) = 32.*cfac
        if(VNAME(V).eq.'ETOH') convfac(V) = 46.*cfac
        if(VNAME(V).eq.'OLE') convfac(V) = 27.*cfac
        if(VNAME(V).eq.'IOLE') convfac(V) = 48.*cfac
        if(VNAME(V).eq.'OLE2') convfac(V) = 75.*cfac
        if(VNAME(V).eq.'PAR') convfac(V) = 14.*cfac
        if(VNAME(V).eq.'CH4') convfac(V) = 16.*cfac
        if(VNAME(V).eq.'NR') convfac(V) = 16.*cfac
        if(VNAME(V).eq.'ISOP') convfac(V) = 68.*cfac
        if(VNAME(V).eq.'TERP') convfac(V) = 136.*cfac
        if(VNAME(V).eq.'VOC_INV') convfac(V) = 75.*cfac !made up factor

        
        write(*,*)'Conversion factor:',V,VNAME(V),convfac(V)  
                END DO

c---- read in variables and sum over all hours

       JDATE = SDATE3D
       JTIME = STIME3D

       if((MXREC-1).gt.24) then
          write(*,*)'Error: program expects 24 hours of
     &     emissions per input file'
          stop
       endif

       write(*,*)'max records',MXREC,JDATE,JTIME

       DO T = 1, (MXREC-1), 1  !only want 24 hours of emissions
      write(*,*) 'Reading file at',JDATE,JTIME

        DO  V = 1, NVARS

            IF ( .NOT. READ3( land, VNAME( V ), ALLAYS3,
     &                        JDATE, JTIME, GRID ) ) THEN
                MESG = 'Read failure:  file ' // land //
     &                 ' variable ' // VNAME( V )
                CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                       MESG, 2 )
            END IF      !  if read3() failed


           DO R = 1, NROWS
            DO C = 1, NCOLS
           TOTS( C,R,V ) = TOTS(C,R,V) + convfac(V)*GRID( C,R,1 )
           QA( C,R,V ) = QA(C,R,V) + convfac(V)*GRID( C,R,1 )
            ENDDO
           ENDDO

        ENDDO !end loop over variables on file

          CALL NEXTIME( JDATE, JTIME, JSTEP )

      enddo !end loop over times

      if ( .not. close3 ( land ) ) THEN
         MESG = 'Could not close file'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

c----- Loop over the rest of the input files
   
       enddo !end loop over all input files

c----- model application

          do V = 1,NVARS


            emissum = 0.0
            DO R = 1, NROWS
            DO C = 1, NCOLS
            emissum = emissum + TOTS(C,R,V)
            enddo
            enddo

           write(*,*)VNAME3D(V),UNITS3D(V),emissum

          enddo

c----- air quality surfaces

        write(*,*)'Calculating air quality surfaces...'

        DO R = 1, NROWS

        qano3 = 100*(real(R)/real(NROWS))
       write(*,*)'>Percent of grid completed:',qano3,'(',R,'/',NROWS,')'

         DO C = 1, NCOLS

          DO  V = 1, NVARS

           if(QA(C,R,V).gt.0.) then

c--- start with primary PM2.5

        if(VNAME(V).eq.'PAL'.or.VNAME(V).eq.'PCA'.or.
     &     VNAME(V).eq.'PCL'.or.VNAME(V).eq.'PEC'.or.
     &     VNAME(V).eq.'PFE'.or.VNAME(V).eq.'PH2O'.or.
     &     VNAME(V).eq.'PK'.or.VNAME(V).eq.'PMG'.or.
     &     VNAME(V).eq.'PMN'.or.VNAME(V).eq.'PMOTHR'.or.
     &     VNAME(V).eq.'PNCOM'.or.VNAME(V).eq.'PNH4'.or.
     &     VNAME(V).eq.'PNO3'.or.VNAME(V).eq.'POC'.or.
     &     VNAME(V).eq.'PSI'.or.VNAME(V).eq.'PSO4'.or.
     &     VNAME(V).eq.'PTI') then


           !find total distances to all patterns for distance weighting
           totdist = 0.

           do i = 1, xpri

           rlat = xplat(i)
           rlon = xplon(i)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.

           if(distance.lt.1000) then
           totdist = totdist + (1/distance**1.5)
           endif
 
           enddo !end loop over unique patterns


           !patterns
           do k = 1, xpri

           rlat = xplat(k)
           rlon = xplon(k)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.


           if(distance.lt.1000) then

           oldi =  (int((xpos - XORG) / DX))
           oldj =  (int((ypos - YORG) / DX))
           newi =  (int((xloc - XORG) / DX))
           newj =  (int((yloc - YORG) / DX))
           adji = oldi - newi
           adjj = oldj - newj

           do ii = 1,nx !start looping over pattern grid
           do jj = 1,ny

           xi = ii + adji
           xj = jj + adjj


           if(xi.gt.0.and.xi.lt.nx.and.xj.gt.0.and.xj.lt.ny) then
           if(zpri(k,xi,xj).gt.0) then

           qd(ii,jj,V) = qd(ii,jj,V) +
     &      (zpri(k,xi,xj)*convfac(V)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist)) !distance weighting

           qd(ii,jj,NVARS+1) = qd(ii,jj,NVARS+1) +
     &      (zpri(k,xi,xj)*convfac(V)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist)) !distance weighting

           endif
           endif 

           enddo !ii
           enddo !jj

           endif !distance condition
           enddo !end loop over patterns
           endif


c--- nitrate

        if(VNAME(V).eq.'NO'.or.VNAME(V).eq.'NO2') then

           totdist = 0.
           do i = 1, xno3

           !find total distances to all patterns for distance weighting
           rlat = xnlat(i)
           rlon = xnlon(i)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.
 
           if(distance.lt.1000) then
           totdist = totdist + (1/distance**1.5)
           endif

           enddo !end loop over unique patterns



           !patterns
           do k = 1, xno3

           rlat = xnlat(k)
           rlon = xnlon(k)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.


           if(distance.lt.1000) then

           oldi =  (int((xpos - XORG) / DX))
           oldj =  (int((ypos - YORG) / DX))
           newi =  (int((xloc - XORG) / DX))
           newj =  (int((yloc - YORG) / DX))
           adji = oldi - newi
           adjj = oldj - newj

c           write(*,*) oldi,oldj,newi,newj,adji,adjj

           do ii = 1,nx !start looping over pattern grid
           do jj = 1,ny

           xi = ii + adji
           xj = jj + adjj

           if(xi.gt.0.and.xi.lt.nx.and.xj.gt.0.and.xj.lt.ny) then

          if(zno3(k,xi,xj).gt.0) then

          qd(ii,jj,V)=qd(ii,jj,V)+
     &      (zno3(k,xi,xj)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist)) !distance weighting

          qd(ii,jj,NVARS+2)=qd(ii,jj,NVARS+2)+
     &      (zno3(k,xi,xj)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist)) !distance weighting

           endif
           endif

           enddo !ii
           enddo !jj
           endif !distance condition
           enddo !end loop over patterns
           endif !condition for nitrate

c----ammonium

        if(VNAME(V).eq.'NH3') then

           !find total distances to all patterns for distance weighting
           totdist = 0.

           do i = 1, xnh4

           rlat = xxlat(i)
           rlon = xxlon(i)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.

           if(distance.lt.1000) then
           totdist = totdist + (1/distance**1.5)
           endif

           enddo !end loop over unique patterns


           !patterns
           do k = 1, xnh4

           rlat = xxlat(k)
           rlon = xxlon(k)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.

           if(distance.lt.1000) then

           oldi =  (int((xpos - XORG) / DX))
           oldj =  (int((ypos - YORG) / DX))
           newi =  (int((xloc - XORG) / DX))
           newj =  (int((yloc - YORG) / DX))
           adji = oldi - newi
           adjj = oldj - newj

c           write(*,*) oldi,oldj,newi,newj,adji,adjj

           do ii = 1,nx !start looping over pattern grid
           do jj = 1,ny

           xi = ii + adji
           xj = jj + adjj

           if(xi.gt.0.and.xi.lt.nx.and.xj.gt.0.and.xj.lt.ny) then

          if(znh4(k,xi,xj).gt.0) then
           qd(ii,jj,NVARS+6)=qd(ii,jj,NVARS+6)+
     &      ( znh4(k,xi,xj)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist))
          endif
           endif

           enddo !ii
           enddo !jj
           endif !distance condition

           enddo !end loop over normalized patterns
           endif !ned condition on ammonium


c----sulfate


        if(VNAME(V).eq.'SO2') then

           !find total distances to all patterns for distance weighting
           totdist = 0.

           do i = 1, xso4

           rlat = xslat(i)
           rlon = xslon(i)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.

           if(distance.lt.1000) then
           totdist = totdist + (1/distance**1.5)
           endif

           enddo !end loop over unique patterns


           !patterns
           do k = 1, xso4

           rlat = xslat(k)
           rlon = xslon(k)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.

           if(distance.lt.1000) then

           oldi =  (int((xpos - XORG) / DX))
           oldj =  (int((ypos - YORG) / DX))
           newi =  (int((xloc - XORG) / DX))
           newj =  (int((yloc - YORG) / DX))
           adji = oldi - newi
           adjj = oldj - newj

c           write(*,*) oldi,oldj,newi,newj,adji,adjj

           do ii = 1,nx !start looping over pattern grid
           do jj = 1,ny

           xi = ii + adji
           xj = jj + adjj


           if(xi.gt.0.and.xi.lt.nx.and.xj.gt.0.and.xj.lt.ny) then

          if(zso4(k,xi,xj).gt.0) then
           qd(ii,jj,NVARS+3)=qd(ii,jj,NVARS+3)+
     &      ( zso4(k,xi,xj)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist))
           endif
           endif

           enddo !ii
           enddo !jj
           endif !distance condition
           enddo !end loop over patterns

           endif



c----Coarse mass

        if(VNAME(V).eq.'PMC') then


          !find total distances to all patterns for distance weighting
           totdist = 0.

           do i = 1, xcm
           rlat = xclat(i)
           rlon = xclon(i)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.
 
           if(distance.lt.1000) then
           totdist = totdist + (1/distance**1.5)
           endif

           enddo !end loop over unique patterns



           do k = 1, xcm

           rlat = xclat(k)
           rlon = xclon(k)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.


           if(distance.lt.1000) then

           oldi =  (int((xpos - XORG) / DX))
           oldj =  (int((ypos - YORG) / DX))
           newi =  (int((xloc - XORG) / DX))
           newj =  (int((yloc - YORG) / DX))
           adji = oldi - newi
           adjj = oldj - newj

c           write(*,*) oldi,oldj,newi,newj,adji,adjj

           do ii = 1,nx !start looping over pattern grid
           do jj = 1,ny

           xi = ii + adji
           xj = jj + adjj

           if(xi.gt.0.and.xi.lt.nx.and.xj.gt.0.and.xj.lt.ny) then

            if(zcm(k,xi,xj).gt.0) then
           qd(ii,jj,V)=qd(ii,jj,V)+
     &      (zcm(k,xi,xj)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist)) !distance weighting
            endif
           endif

           enddo !ii
           enddo !jj
           endif !distance condition
           enddo !end loop over patterns

           endif !condition for CM


c----O3N

        if(VNAME(V).eq.'NO'.or.VNAME(V).eq.'NO2') then

          !find total distances to all patterns for distance weighting
           totdist = 0.

           do i = 1, xo3n
           rlat = xo3nlat(i)
           rlon = xo3nlon(i)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.

           if(distance.lt.1000) then
           totdist = totdist + (1/distance**1.5)
           endif

           enddo !end loop over unique patterns


           !patterns
           do k = 1, xo3n

           rlat = xo3nlat(k)
           rlon = xo3nlon(k)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.


           if(distance.lt.1000) then

           oldi =  (int((xpos - XORG) / DX))
           oldj =  (int((ypos - YORG) / DX))
           newi =  (int((xloc - XORG) / DX))
           newj =  (int((yloc - YORG) / DX))
           adji = oldi - newi
           adjj = oldj - newj

c           write(*,*) oldi,oldj,newi,newj,adji,adjj

           do ii = 1,nx !start looping over pattern grid
           do jj = 1,ny

           xi = ii + adji
           xj = jj + adjj


           if(xi.gt.0.and.xi.lt.nx.and.xj.gt.0.and.xj.lt.ny) then


            if(zo3n(k,xi,xj).gt.0) then
           qano3 = (zo3n(k,xi,xj)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist)) !distance weighting
           qd(ii,jj,NVARS+4)=qd(ii,jj,NVARS+4)+qano3
           endif
           endif

           enddo !ii
           enddo !jj
           endif !distance condition
           enddo !end loop over patterns
           endif !condition for O3N

c----O3V

        if(VNAME(V).eq.'ALD2'.or.VNAME(V).eq.'ALDX'.or.
     &     VNAME(V).eq.'ETH'.or.VNAME(V).eq.'ETHA'.or.
     &     VNAME(V).eq.'FORM'.or.VNAME(V).eq.'TOL'.or.
     &     VNAME(V).eq.'XYL'.or.VNAME(V).eq.'MEOH'.or.
     &     VNAME(V).eq.'ETOH'.or.VNAME(V).eq.'OLE'.or.
     &     VNAME(V).eq.'IOLE'.or.VNAME(V).eq.'OLE2'.or.
     &     VNAME(V).eq.'PAR'.or.VNAME(V).eq.'CH4'.or.
     &     VNAME(V).eq.'NR'.or.VNAME(V).eq.'ISOP'.or.
     &     VNAME(V).eq.'ACET'.or.VNAME(V).eq.'BENZ'.or.
     &     VNAME(V).eq.'ETHY'.or.VNAME(V).eq.'KET'.or.
     &     VNAME(V).eq.'NAPH'.or.VNAME(V).eq.'PRPA'.or.
     &     VNAME(V).eq.'XYLMN'.or.VNAME(V).eq.'TERP') then
c     &     VNAME(V).eq.'VOC_INV') then


          !find total distances to all patterns for distance weighting
           totdist = 0.

           do i = 1, xo3v
           rlat = xo3vlat(i)
           rlon = xo3vlon(i)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.

           if(distance.lt.1000) then
           totdist = totdist + (1/distance**1.5)
           endif

           enddo !end loop over unique patterns




           !patterns
           do k = 1, xo3v

           rlat = xo3vlat(k)
           rlon = xo3vlon(k)
           call lcpgeo(0,rlat0,rlon0,tlat1,tlat2,xpos,ypos,
     &                  rlon,rlat)
            xpos = xpos * 1000 !everything in meters
            ypos = ypos * 1000
            xloc = XORG + C*DX
            yloc = YORG + R*DX
            distance = sqrt( ((xpos-(xloc))*(xpos-(xloc))) +
     &       ((ypos-(yloc))*(ypos-(yloc))) ) / 1000.


           if(distance.lt.1000) then


           oldi =  (int((xpos - XORG) / DX))
           oldj =  (int((ypos - YORG) / DX))
           newi =  (int((xloc - XORG) / DX))
           newj =  (int((yloc - YORG) / DX))
           adji = oldi - newi
           adjj = oldj - newj

c           write(*,*) oldi,oldj,newi,newj,adji,adjj

           do ii = 1,nx !start looping over pattern grid
           do jj = 1,ny

           xi = ii + adji
           xj = jj + adjj

           if(xi.gt.0.and.xi.lt.nx.and.xj.gt.0.and.xj.lt.ny) then
            if(zo3v(k,xi,xj).gt.0) then
          qd(ii,jj,NVARS+5)=qd(ii,jj,NVARS+5)+
     &      (zo3v(k,xi,xj)*QA(C,R,V)*
     &      ( (1/distance**1.5) / totdist)) !distance weighting
           endif
           endif

           enddo !ii
           enddo !jj
           endif !distnace condition
           enddo !end loop over patterns
           endif !condition for O3V


c--- finished doing the pattern work

           endif !end condition for non-zero emissions

         enddo !end vars looop

         enddo !end col/row loops
         enddo !end col/row loops


c----- apply O3 titration adjustment

        DO R = 1, NROWS
         DO C = 1, NCOLS
           V = NVARS + 4 !only applies to O3N
           qd(C,R,NVARS+4) = qd(C,R,NVARS+4) * indic(C,R)
           if(indic(C,R).lt.1) then
           write(*,*)'Check on VOC limited at ',C,R
           endif
         ENDDO
        ENDDO

c------ create output file
            
       JDATE = SDATE3D
       JTIME = STIME3D
       TSTEP3D = 240000
     
            NCOLS3D = NX
            NROWS3D = NY
            XORIG3D = XORG
            YORIG3D = YORG
            XCELL3D = DX
            YCELL3D = DX
            GDTYP3D = 2
            P_ALP3D = 33.
            P_BET3D = 45.
            P_GAM3D = -97.
            XCENT3D = -97.
            YCENT3D = 40.
            SDATE3D = (xyear * 1000) + 001
            STIME3D = 000000

            JDATE = SDATE3D
            JTIME = STIME3D


            DO I = 1, NVARS
             write(*,*)   VNAME3D( I )
             write(*,*)   UNITS3D( I ) 
             write(*,*)   VDESC3D( I ) 
c                VTYPE3D( I ) = M3REAL

            END DO
                
      if ( .not. open3( outfile, FSCREA3, progname ) ) THEN
          MESG = 'Could not open file "' //
     &     outfile( 1: TRIMLEN(outfile))
     &     // '" for output'
           CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if    
                
          do V = 1,NVARS


            emissum = 0.0
            DO R = 1, NROWS
            DO C = 1, NCOLS
            emissum = emissum + TOTS(C,R,V)
            enddo
            enddo

           write(*,*)VNAME3D(V),UNITS3D(V),emissum


      IF ( .NOT. WRITE3( OUTFILE,VNAME(V),JDATE, JTIME, TOTS(1,1,V) )) THEN
                 MESG = 'Could not write totals to ' // VNAME(V)
                  CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                          MESG, 2 )
                END IF      !  if write3() failed
      
          enddo !end loop over variables


c---- outfput second file with air quality surfaces
       
            NVARS3D = NVARS + 6

            VNAME3D(NVARS+1) = 'PRIPM25'
            UNITS3D(NVARS+1) = 'ug/m3'
            VDESC3D(NVARS+1) = 'PABAQS1.0'
            VTYPE3D(NVARS+1) = M3REAL  

            VNAME3D(NVARS+2) = 'XNO3'
            UNITS3D(NVARS+2) = 'ug/m3'
            VDESC3D(NVARS+2) = 'PABAQS1.0'
            VTYPE3D(NVARS+2) = M3REAL

            VNAME3D(NVARS+3) = 'XSO4'
            UNITS3D(NVARS+3) = 'ug/m3'
            VDESC3D(NVARS+3) = 'PABAQS1.0'
            VTYPE3D(NVARS+3) = M3REAL

            VNAME3D(NVARS+4) = 'O3N'
            UNITS3D(NVARS+4) = 'ppb'
            VDESC3D(NVARS+4) = 'PABAQS1.0'
            VTYPE3D(NVARS+4) = M3REAL

            VNAME3D(NVARS+5) = 'O3V'
            UNITS3D(NVARS+5) = 'ppb'
            VDESC3D(NVARS+5) = 'PABAQS1.0'
            VTYPE3D(NVARS+5) = M3REAL

            VNAME3D(NVARS+6) = 'XNH4'
            UNITS3D(NVARS+6) = 'ug/m3'
            VDESC3D(NVARS+6) = 'PABAQS1.0'
            VTYPE3D(NVARS+6) = M3REAL


      if ( .not. open3( outfileqd, FSCREA3, progname ) ) THEN
          MESG = 'Could not open file "' //
     &     outfile( 1: TRIMLEN(outfileqd))
     &     // '" for output'
           CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

          do V = 1,NVARS+6
           write(*,*)VNAME3D(V)


      IF ( .NOT. WRITE3( OUTFILEQD,VNAME3D(V),JDATE, JTIME, qd(1,1,V)
     &    )) THEN
                 MESG = 'Could not write totals to ' // VNAME(V)
                  CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                          MESG, 2 )
                END IF      !  if write3() failed

          enddo !end loop over variables


C******************  FORMAT  STATEMENTS   ******************************

C...........   Error and warning message formats..... 91xxx

91000   FORMAT ( //5X , '*** ERROR ABORT in program VERTOT ***',
     &            /5X , A ,
     &           // )        !  generic error message format

C...........   Informational (LOG) message formats... 92xxx

92000   FORMAT ( 5X , A )

92999   FORMAT ( //5X , A, // )

C...........   Formatted file I/O formats............ 93xxx

93000   FORMAT ( A16 )

C...........   Internal buffering formats............ 94xxx

C...........   Miscellaneous formats................. 95xxx

95000   FORMAT ( /5X , A , $ )          !  generic prompt format.


      stop

      END


c-----Start subroutines
      subroutine lcpgeo(iway,phic,xlonc,truelat1,truelat2,xloc,yloc,
     &                  xlon,ylat)
c
c     LCPGEO performs Lambert Conformal to geodetic (lat/lon) translation
c
c     Code based on the TERRAIN preprocessor for MM5 v2.0,
c     developed by Yong-Run Guo and Sue Chen, National Center for
c     Atmospheric Research, and Pennsylvania State University
c     10/21/1993
c
c     Input arguments:
c        iway                Conversion type
c                            0 = geodetic to Lambert Conformal
c                            1 = Lambert Conformal to geodetic
c        phic                Central latitude (deg, neg for southern hem)
c        xlonc               Central longitude (deg, neg for western hem)
c        truelat1            First true latitute (deg, neg for southern hem)
c        truelat2            Second true latitute (deg, neg for southern hem)
c        xloc/yloc           Projection coordinates (km)
c        xlon/ylat           Longitude/Latitude (deg)
c
c     Output arguments:
c        xloc/yloc           Projection coordinates (km)
c        xlon/ylat           Longitude/Latitude (deg)
c
      data conv/57.29578/, a/6370./
c
c-----Entry Point
c
      if (phic.lt.0) then
        sign = -1.
      else
        sign = 1.
      endif
      pole = 90.
      if (abs(truelat1).gt.90.) then
        truelat1 = 60.
        truelat2 = 30.
        truelat1 = sign*truelat1
        truelat2 = sign*truelat2
      endif
      xn = alog10(cos(truelat1/conv)) - alog10(cos(truelat2/conv))
      xn = xn/(alog10(tan((45. - sign*truelat1/2.)/conv)) -
     &         alog10(tan((45. - sign*truelat2/2.)/conv)))           
      psi1 = 90. - sign*truelat1
      psi1 = psi1/conv
      if (phic.lt.0.) then
        psi1 = -psi1
        pole = -pole
      endif
      psi0 = (pole - phic)/conv
      xc = 0.
      yc = -a/xn*sin(psi1)*(tan(psi0/2.)/tan(psi1/2.))**xn
c
c-----Calculate lat/lon of the point (xloc,yloc)
c
      if (iway.eq.1) then
        xloc = xloc + xc
        yloc = yloc + yc
        if (yloc.eq.0.) then
          if (xloc.ge.0.) flp = 90./conv
          if (xloc.lt.0.) flp = -90./conv
        else
          if (phic.lt.0.) then
            flp = atan2(xloc,yloc)
          else
            flp = atan2(xloc,-yloc)
          endif
        endif
        flpp = (flp/xn)*conv + xlonc
        if (flpp.lt.-180.) flpp = flpp + 360.
        if (flpp.gt. 180.) flpp = flpp - 360. 
        xlon = flpp 
c
        r = sqrt(xloc*xloc + yloc*yloc)
        if (phic.lt.0.) r = -r
        cell = (r*xn)/(a*sin(psi1))
        rxn  = 1.0/xn
        cel1 = tan(psi1/2.)*cell**rxn
        cel2 = atan(cel1)
        psx  = 2.*cel2*conv
        ylat = pole - psx
c
c-----Calculate x/y from lat/lon
c
      else
        ylon = xlon - xlonc
        if (ylon.gt. 180.) ylon = ylon - 360.
        if (ylon.lt.-180.) ylon = ylon + 360.
        flp = xn*ylon/conv
        psx = (pole - ylat)/conv
        r = -a/xn*sin(psi1)*(tan(psx/2.)/tan(psi1/2.))**xn
        if (phic.lt.0.) then
          xloc = r*sin(flp)
          yloc = r*cos(flp)
        else
          xloc = -r*sin(flp)
          yloc =  r*cos(flp)
        endif
      endif
c
      xloc = xloc - xc
      yloc = yloc - yc
c
      return
      end

      subroutine caldate(idate)

      integer idate
      dimension nday(12)
      data nday/31,28,31,30,31,30,31,31,30,31,30,31/

c
c-----Entry point
c
c-----If it is already in calender date, return
c

      icent = int(idate/100000)
      iyear = int((idate - icent*100000)/1000)
      jday = idate - icent*100000 - iyear*1000

      nday(2) = 28
      if (mod(iyear,4).eq.0) nday(2) = 29
      mday = 0
      do imonth = 1,12
        mday = mday + nday(imonth)
        if (mday.ge.jday) go to 20
      enddo
 20   iday = jday - (mday - nday(imonth))
      idate = icent*1000000 + iyear*10000 + imonth*100 + iday
c
c      write(*,'(4i6)') icent,iyear,imonth,iday

      return
      end
