c**** NCF_WRT_DATA_SPECIES
c
      subroutine ncf_wrt_data_species(ierr,action,iounit,nspcs)
      use ncf_iomod
      implicit none
c
c-----------------------------------------------------------------------
c    Description:
c-----------------------------------------------------------------------
c
c   This routine writes the data for the timestep variables to the
c    NetCDF file
c
c      Argument description:
c       Inputs:
c           action        C name of file to open
c           iounit        I NetCDF file ID of file
c           nspcs         I number of species in the file
c       Outputs:
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'netcdf.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer       ierr
      character*(*) action
      integer       iounit
      integer       nspcs
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
      integer istrln
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*14 this_var
      integer      data_start(2), data_count(2), ispc, i
      integer      this_varid
      real,        allocatable, dimension(:) :: array_1d
c
c-----------------------------------------------------------------------
c    Entry point:
c-----------------------------------------------------------------------
c
c  --- set the position in the NetCDF variable to write ---
c
      data_start(1) = 1
      data_count(1) = nptsrc
      data_start(2) = ncf_cur_tstep
      data_count(2) = 1
c
c  --- first do the plume variables ----
c
      this_var = 'flowrate'
      ierr = nf_inq_varid(iounit,this_var(:istrln(this_var)),this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_vara_real(iounit,this_varid,data_start,
     &                                              data_count,flowrat)
      if( ierr .NE. NF_NOERR ) goto 7001
c
      this_var = 'plumerise'
      ierr = nf_inq_varid(iounit,this_var(:istrln(this_var)),this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_vara_real(iounit,this_varid,data_start,
     &                                              data_count,plumerise)
      if( ierr .NE. NF_NOERR ) goto 7001
c
      this_var = 'plume_bottom'
      ierr = nf_inq_varid(iounit,this_var(:istrln(this_var)),this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_vara_real(iounit,this_varid,data_start,
     &                                              data_count,plume_bot)
      if( ierr .NE. NF_NOERR ) goto 7001
c
      this_var = 'plume_top'
      ierr = nf_inq_varid(iounit,this_var(:istrln(this_var)),this_varid)
      if( ierr .NE. NF_NOERR ) goto 7000
      ierr = nf_put_vara_real(iounit,this_varid,data_start,
     &                                              data_count,plume_top)
      if( ierr .NE. NF_NOERR ) goto 7001
c
c  --- allocate the array that will be used to write the data ---
c
      allocate( array_1d(nptsrc) )
c
c  --- loop over all variables in this file ---
c
      do ispc=1,nspcs
c
c  --- get name for this variable, and get it's variable ID
c      in this file ---
c
         this_var = spcname(ispc)
         call jstlft(this_var)
         ierr = nf_inq_varid(iounit,this_var(:istrln(this_var)),
     &                                                   this_varid)
         if( ierr .NE. NF_NOERR ) goto 7000
c
c  --- load the data into the local array to write ---
c
         do i=1,nptsrc
            array_1d(i) = ptemis(i,ispc)
         enddo
c
         ierr = nf_put_vara_real(iounit,this_varid,data_start,
     &                                          data_count,array_1d)
         if( ierr .NE. NF_NOERR ) goto 7001
      enddo
c
c  ---- deallocate the array ---
c
      deallocate( array_1d )
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c    Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(*,'(//,a)') 'ERROR in NCF_WRT_DATA_SPECIES:'
      write(*,'(A)') action(:istrln(action))
      write(*,'(2A)') 'Cannot find variable id for: ',
     &                                      this_var(:istrln(this_var))
      ierr = IFAIL
      goto 9999
c
 7001 continue
      write(*,'(//,a)') 'ERROR in NCF_WRT_DATA_SPECIES:'
      write(*,'(A)') action(:istrln(action))
      write(*,'(2A)') 'Cannot write data for the variable: ',
     &                                      this_var(:istrln(this_var))
      ierr = IFAIL
      goto 9999
c
c-----------------------------------------------------------------------
c    Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
 
