      program camx2ncf_pts
c
c----------------------------------------------------------------
c     This program reads a CAMx binary emissions file and
c     write a NetCDF version of it.
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c Copyright (C) 2006-2020  Ramboll
c
c This program is free software; you can redistribute it and/or
c modify it under the terms of the GNU General Public License
c as published by the Free Software Foundation; either version 2
c of the License, or (at your option) any later version.
c
c This program is distributed in the hope that it will be useful,
c but WITHOUT ANY WARRANTY; without even the implied warranty of
c MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
c GNU General Public License for more details.
c
c To obtain a copy of the GNU General Public License
c go to the Free Software Foundation at http://www.fsf.org.
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c----------------------------------------------------------------
c  Include files:
c----------------------------------------------------------------
c     
      implicit none
      include 'camx2ncf_pts.inc'
      include 'ncf_iodat.inc'
      include 'netcdf.inc'
c
c----------------------------------------------------------------
c  External functions:
c----------------------------------------------------------------
c
      integer istrln
c
c----------------------------------------------------------------
c  Local variables:     
c----------------------------------------------------------------
c
      character*200 action
      character*20  spec_units(MXSPEC), spec_long_name(MXSPEC)
      character*60  spec_desc(MXSPEC), spec_coords(MXSPEC)
      integer       ierr, icur_file, i
c
c----------------------------------------------------------------
c  Entry point:
c----------------------------------------------------------------
c
c --- set compression flag ---
c
      call ncf_set_compress_flag()
c
c --- call routine to read the options ---
c
      call rdopts_pts(ierr)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- call routine to read header data from each file ---
c
      do icur_file=1,nfiles
         call rdpthdr(ierr,icur_file)
         if( ierr .NE. ISUCES ) goto 9999
      enddo
c
c  --- set flags for each source ---
c
      do i=1,nptsrc
        piglet(i) = 0
        if( dstk(i) .LT. 0. ) piglet(i) = 1
        dstk(i) = ABS(dstk(i))
      enddo
c
c --- call routine to read the species list file ---
c
      call rdspclst(ierr)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- write header part of the netCDF file ---
c
      action = 'Writing output NetCDF file.'
      call ncf_set_vars_base()
      call ncf_set_tstep(begdate,begtim,enddate,endtim)
      call ncf_set_specatt_pts(spec_units,spec_long_name,
     &                                             spec_desc,spec_coords)
      call ncf_set_global('PTSOURCE  ',1,begdate,begtim,
     &                                         enddate,endtim,nlay,nspec)
      call ncf_wrt_dim(ierr,action,ncf_iowemis,nptsrc,nspec)
      if( ierr .NE. ISUCES ) goto 9999
      call ncf_wrt_global(ierr,action,ncf_iowemis,nspec,spcname)
      if( ierr .NE. ISUCES ) goto 9999
      call ncf_wrt_vars_base(ierr,action,ncf_iowemis)
      if( ierr .NE. ISUCES ) goto 9999
      call ncf_wrt_vars_species(ierr,action,ncf_iowemis,nptsrc,nspec,
     &        spcname,spec_units,spec_long_name,spec_desc,spec_coords)
      if( ierr .NE. ISUCES ) goto 9999
      ierr = nf_enddef(ncf_iowemis)
c
c  --- read first file as long as there are hours to read ---
c
      ncf_cur_tstep = 0
  111 continue
      icur_file = 1
      nptsrc = 0
      ncf_cur_tstep = ncf_cur_tstep + 1
      call readpt(ierr,icur_file)
      if( ierr .EQ. IEOF ) goto 222 
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- there is an hour, read other files ---
c
      do icur_file=2,nfiles
         call readpt(ierr,icur_file)
         if( ierr .NE. ISUCES ) goto 9999
      enddo
c
c  --- set the point source override flag ---
c
      do i=1,nptsrc
        if( sa_region(i) .LT. 0 ) then
           sa_region(i) = -sa_region(i)
        else
           sa_region(i) = 0
        endif
      enddo
c
c  --- first hour, write the data that is not dependent on time ---
c
      call ncf_wrt_data_pts(ierr,action,ncf_iowemis)
      if( ierr .NE. ISUCES ) goto 9999
c
c  --- write the data for this hour ---
c
      action = 'Writing timestamp to output NetCDF file.'
      call ncf_wrt_data_tstep(ierr,action,ncf_iowemis,nspec)
      if( ierr .NE. ISUCES ) goto 9999
c
      action = 'Writing hourly data to output NetCDF file.'
      call ncf_wrt_data_species(ierr,action,ncf_iowemis,nspec)
      if( ierr .NE. ISUCES ) goto 9999
c
      goto 111
c
c  --- entire files read, close file ---
c
  222 continue
      ierr = nf_close(ncf_iowemis)
      write(*,'(//,A)') 'Successful completion of CAMx2NCF_PTS.'
      goto 9999
c
c----------------------------------------------------------------
c  Exit point:
c----------------------------------------------------------------
c
 9999 continue
      end
