%let base=.;

options nosymbolgen mprint mlogic errors=6;

***********************************************;

%MACRO program;

%macro qa1(yn,modl,mdax,range,scen);
%IF &yn.=y %then %do;

  %let grid=12US2;
  %let yyyy=%SUBSTR(&scen.,1,4);

  filename lrg&yyyy. "[ENTER CORRECT PATHNAME]/smat.O3_MDA&mdax..&modl..&grid..&scen..&range..csv";

  data lrgfil(drop=type lat lon);
    length colrow 4. date 5. o3mda&mdax. 5.;
    infile lrg&yyyy. firstobs=3 dlm=',' dsd;
    input colrow type $ lat lon date o3mda&mdax.;
  run;
  
  proc means n nmiss min max mean median;
    title "&modl. &scen. O3_MDA&mdax. &range. Large File";
  run;


%end;
%mend qa1;
************;

%qa1(y,CAMx,8,5-9,2016gf_v7.10_CB6r5)
%qa1(y,CAMx,8,5-9,2026gf_v7.10_CB6r5)

%qa1(y,CAMx,8,4-9,2016gf_v7.10_CB6r5)
%qa1(y,CAMx,8,4-9,2026gf_v7.10_CB6r5)

%qa1(y,CAMx,1,4-9,2016fj_v7.10_CB6r5)
%qa1(y,CAMx,1,4-9,2023fj_v7.10_CB6r5)


%MEND program;
%program
