#!/bin/csh -f
#SBATCH -A emis
#SBATCH --gid=emis-hpc
#SBATCH --mem-per-cpu=16g
#SBATCH -p singlepe
#SBATCH -n 1
#SBATCH -t 72:00:00
#SBATCH -o camx_convert_2016fj_cb6ae7_12US2_ptfire-rx.%j.log

unset verbose

if ( $?SLURM_JOB_ID ) then
 cd $SLURM_SUBMIT_DIR
else
 set SLURM_JOB_ID = $?
endif


### USER DEFINED SETTINGS ###
#-----------------------------------------------------------------#

    ## Convert 3D point fires to UAM ptsr (leave as Y if you want it to do anything)
    set CTM_3DPTFIRE = Y

   ### Input and output settings
    ## Name of SMOKE sector for conversion (eg. ptfire3D)
    set smoke_sector = ptfire-rx3D
    ## Path to input netCDF files for SMOKE sector
    set INPATH = /work/EMIS/em_v7.4/2016platform/2016fj_16j/premerged/ptfire-rx3D
    ## Name of sector to output as (eg. ptfire)
    set camx_sector = ptfire-rx
    ## Path to output CAMx files
    set OUTPATH = /work/EMIS/cmaq2camx/fires/ptfire-rx_2016fj_12US2_camx_v7

    ## Path to CMAQ METCRO3D files
    set MET_ROOT = /work/EMIS/met/MCIP_v4.3/WRFv3.8_12US2_2016_35aL/3D

    set YEAR = 2016
    ## Year specific table of dates and representative dates
    set datefile = /work/EMIS/cmaq2camx/dates/mergedates_${YEAR}.txt
    # Root to cmaq2camx executables
    set execroot = /work/EMIS/cmaq2camx/bin 

    ## First and last Julian run dates for conversion loop
    set start_date = 2015356          #first Julian day
    set end_date   = 2016366          #last Julian day

    ## Variables for use in input and output file names
    setenv GRID 12US2
    setenv CASE 2016fj_16j  ## secondary case for inline emissions
    setenv SPEC cmaq_cb6ae7

    ## Path to the CMAQ->CAMx species mapping table
		set SPECIES_MAPPING  = /work/EMIS/cmaq2camx/Species_Mapping_Tables/MAPTBL.CMAQ-CB6R3AE7_to_CAMXv7_CB6+CF_07aug2020.txt

    ## Grid definitions
    setenv XORG -2412.
    setenv YORG -1620.
    setenv NX 396
    setenv NY 246
    setenv DX 12.
    set LAYERS = 35  ## Number of layers to output


#-----------------------------------------------------------------#
### END USER DEFINED SETTINGS ###

#location for QA files - domain totals and domain total 2D plots of point emissions
set QADIR = $cwd/qatemp 
if (! -e $QADIR) then
	mkdir -p $QADIR
endif

## Path for the temporary work directory
set tempdir = $cwd/work  
if (! -e $tempdir) then
	mkdir -p $tempdir
endif

setenv SCRIPTLOG cmaq2camx_${CASE}_${GRID}_${SLURM_JOB_ID}.log  ## Name of script log 
if ( -e $cwd/$SCRIPTLOG) then
	rm $cwd/$SCRIPTLOG
endif
set today = $start_date

## Timezone for output, typically should be left at 0
setenv OUTPUT_TIMEZONE 0 
setenv OUTPUT_N_LAYERS $LAYERS

## Run the CMAQ to CAMx conversion by loop over the specified date range 
while ($today <= $end_date )

	echo $today >> $cwd/$SCRIPTLOG
	#-----------------------------------------------------------------#
	set STDATE = $today

	set GDAY = (`$execroot/j2g $today`)
	set YYYY = `echo $GDAY | cut -c1-4`
	set YY = `echo $YYYY | cut -c3-4`
	set MM = `echo $GDAY | cut -c5-6`
	set DD = `echo $GDAY | cut -c7-8`
	set G_DAY = $YYYY$MM$DD
	set GS_DAY = $YY$MM$DD
	set YYDDD = `echo $today | cut -c3-8`

	set iday = `grep ^$STDATE $datefile`
	set dateheader = `grep ^Date $datefile`
	#---------------------------------------------------------------------------#

	setenv CMAQ_METCRO3D $MET_ROOT/METCRO3D_${YY}${MM}${DD}

	if ($CTM_3DPTFIRE == Y) then ## elevated point file preparation
                set repday = $iday[9]
		set FILEA = emis_mole_${smoke_sector}_${repday}_${GRID}_${SPEC}_${CASE}.ncf

		rm -f ${tempdir}/temp_${SLURM_JOB_ID}_ptf.ncf

		if (! -e $INPATH/$FILEA) then
			gunzip -c $INPATH/${FILEA}.gz > ${tempdir}/temp_${SLURM_JOB_ID}_ptf.ncf
		else
			cp $INPATH/$FILEA ${tempdir}/temp_${SLURM_JOB_ID}_ptf.ncf
		endif

		# 1. run cmaq2camx to convert IOAPI 2D file to camx format and adjust species 
		# 2. run qaemis on camx input file

		rm -f ${tempdir}/tmp_emis_${SLURM_JOB_ID}_ptf

		setenv INFILE  ${tempdir}/temp_${SLURM_JOB_ID}_ptf.ncf
		setenv OUTFILE ${tempdir}/tmp_emis_${SLURM_JOB_ID}_ptf
		setenv MAPTBL  $SPECIES_MAPPING
		$execroot/spcmap

		setenv CMAQEMIS ${tempdir}/tmp_emis_${SLURM_JOB_ID}_ptf
		rm -f ${tempdir}/tmp_pnt_${SLURM_JOB_ID} ${tempdir}/junk 

#$execroot/cmaq2uam << EOF
$execroot/../bin-11sep2013/cmaq2uam << EOF
File Type          |EMIS
OutFile1 (IC,BC,AR)|${tempdir}/junk
OutFile2 (TopC,PT) |${tempdir}/tmp_pnt_${SLURM_JOB_ID}
Output Timezone    |0
EOF
		rm -f ${tempdir}/junk

		## Add effective plume height to the CAMx elevated point source file
		echo ${INPATH}/${FILEA} >> $cwd/$SCRIPTLOG
		set OUTFILE = ptsr.${camx_sector}.${G_DAY}.${GRID}.bin

		rm -f $OUTPATH/$OUTFILE

$execroot/pthtq << EOF
Input CAMx PT      |${tempdir}/tmp_pnt_${SLURM_JOB_ID}
Output CAMx PT     |$OUTPATH/$OUTFILE
EOF

		rm -f ${tempdir}/tmp_pnt_${SLURM_JOB_ID}
		rm -f ${tempdir}/qaemis.${camx_sector}.${SLURM_JOB_ID}.in
cat << ieof > ${tempdir}/qaemis.${camx_sector}.${SLURM_JOB_ID}.in
$OUTPATH/$OUTFILE
$QADIR/${camx_sector}.$G_DAY.$GRID.$CASE.camx.tot.txt
$QADIR/${camx_sector}.$G_DAY.$GRID.$CASE.camx.hrs.txt
$QADIR/${camx_sector}.$G_DAY.$GRID.$CASE.camx.pave.bin
ieof

		$execroot/qaelev < ${tempdir}/qaemis.${camx_sector}.${SLURM_JOB_ID}.in
		rm -f ${tempdir}/qaemis.${camx_sector}.${SLURM_JOB_ID}.in
		rm -f ${tempdir}/temp_${SLURM_JOB_ID}_ptf.ncf

	endif # if CTM_3DPTFIRE

	@ today = $today + 1

	if ($today == 2015366) then
		set today = 2016001
	endif

end #loop back to next day

exit


