#! /bin/csh

cat $0
uname -a
date

set torun = 1

chdir $WCDIR/post

# # alias testing
# set torun = 0
# alias aget echo
# alias cp   echo

# based on github run_combine.csh and bkx combine.aconc.job and
# combine.dep.job.

#> Configure the system environment and set up the module 
#> capability
   limit stacksize unlimited
#

#> Choose compiler and set up CMAQ environment with correct
#> libraries using config.cmaq. Options: intel | gcc | pgi
# the cmaq_env.csh is sourced from the
# /work/MOD3DEV/rmm/CMAQV52/base/config_cmaq.csh
# /work/MOD3DEV/rmm/CMAQV521    /config_cmaq.csh
 if ( ! $?compiler ) then
   setenv compiler intel
   setenv compilerVrsn 17.0
   setenv compilerString ${compiler}${compilerVrsn}
   set cmenv = /work/MOD3DEV/cmaq_common/cmaq_env.csh
   ls -lpF $cmenv
   set t = `date +%s`
   set freez = /home/bkx/cmaq/misc/fr/cmaq_env.csh.$t
   \cp -p $cmenv $freez
   ls -lpF   $freez
   source    $freez
 endif

# these assignments must be consistent with cmaq_env.csh
# ensure version of exe is valid
set cbdir = /work/MOD3EVAL/bkx/cmaq/wr401/task4/2018/cctm/july_2019_runs/github/chk11jun2019/POST/combine/scripts
set exe   = $cbdir/BLD_combine_v53_intel17.0/combine_v53.exe
set species_ac =  $WCDIR/post/SpecDef_cb6r3_ae7_aq.txt

# module_file.F reads INFILEn, n+1... until it is empty, then it
# stops.  but it issues a warning message saying the empty file does
# not exist, even though the specdef file does not need it.

setenv METDATA $WCDIR/mcip
#setenv OUTDIR  $WCDIR/extr/$MONTH  # set in wrapper
setenv SPEC    $WCDIR/post
setenv INDATA  $WCDIR/post/data

#========================================================================
# Run combine to yield all desired concentrations
#

echo "OUTDIR is $OUTDIR"
if ( ! -d "$OUTDIR" ) mkdir -p $OUTDIR

setenv OUTFILE      $OUTDIR/combine_aconc$SFX$YEAR$MONTH
setenv SPECIES_DEF  $species_ac

#if (-e $OUTFILE) rm $OUTFILE
if (-e $OUTFILE) then
    echo "warning: note $OUTFILE already exists"
    echo abort
    exit
endif

set cday = $BEGCOM
while ( $cday <= $ENDDAY )
set yyyy   = `echo $cday |cut -b1-4`
set metday = `echo $cday |cut -b3-`

set file1 = ${PFX}ACONC$SFX$cday$SFX2
set file2 = METCRO3D$METSFX$metday
set file3 = ${PFX}APMDIAG$SFX$cday$SFX2
set file4 = METCRO2D$METSFX$metday

set wfile1 = $INDIR/$file1
set wfile2 = $METDATA/$file2
set wfile3 = $INDIR/$file3
set wfile4 = $METDATA/$file4

setenv ADIR $ADIR1
setenv AMET $AMET1

set afile1 = $ADIR/ACONC/$file1
set afile2 = $AMET/$file2
set afile3 = $ADIR/APMDIAG/$file3
set afile4 = $AMET/$file4

set ifile1 = $INDATA/$file1
set ifile2 = $INDATA/$file2
set ifile3 = $INDATA/$file3
set ifile4 = $INDATA/$file4

# try linking from work
if ( ( ! -e $ifile1 ) && ( -e $wfile1 )) ln -s $wfile1 $INDATA
if ( ( ! -e $ifile2 ) && ( -e $wfile2 )) ln -s $wfile2 $INDATA
if ( ( ! -e $ifile3 ) && ( -e $wfile3 )) ln -s $wfile3 $INDATA
if ( ( ! -e $ifile4 ) && ( -e $wfile4 )) ln -s $wfile4 $INDATA

# incase there is some kind of unfinished copy
# sleep 5

# if not on work then aget
if ( ! -e $ifile1 ) aget -a $INDATA $afile1
if ( ! -e $ifile2 ) aget -a $INDATA $afile2
if ( ! -e $ifile3 ) aget -a $INDATA $afile3
if ( ! -e $ifile4 ) aget -a $INDATA $afile4

#chgrp mod3app $ifile1 $ifile2 $ifile3 $ifile4
(chdir $INDATA; ls -lpF $ifile1 $ifile2 $ifile3 $ifile4 )

unsetenv INFILE1 INFILE2 INFILE3 INFILE4 INFILE5
setenv INFILE1 $ifile1
setenv INFILE2 $ifile2
setenv INFILE3 $ifile3
setenv INFILE4 $ifile4

if ( $torun == 1 ) $exe

set cday = `date -d "$cday  1 days" '+%Y%m%d' `

end # day concs

