library(maps);
library(mapproj);
library(fields);
library(graphics);
library(ncdf4);


## panel 1
source.open <- nc_open(filename="/work/MOD3EVAL/kbaker/data/cmaq/36US3/emis.2017/airports/emis_mole_airports_20170102_12US1_cmaq_cb6_WR413_MYR_2017.nc4", write=FALSE, readunlim=FALSE)

x.orig.km <- ncatt_get(source.open,varid=0,attname="XORIG")$value/1000
y.orig.km <- ncatt_get(source.open,varid=0,attname="YORIG")$value/1000
x.cell.size <- ncatt_get(source.open,varid=0,attname="XCELL")$value/1000
y.cell.size <- ncatt_get(source.open,varid=0,attname="YCELL")$value/1000
num.grid.x <- ncatt_get(source.open,varid=0,attname="NCOLS")$value
num.grid.y <- ncatt_get(source.open,varid=0,attname="NROWS")$value
x.proj.12 <- seq(from=x.orig.km + x.cell.size/2, length=num.grid.x, by=x.cell.size)
y.proj.12 <- seq(from=y.orig.km + y.cell.size/2, length=num.grid.y, by=y.cell.size)

#datavar.array <- ncvar_get(source.open,"PEC")
datavar.array <- ncvar_get(source.open,"CO",start=c(1,1,1,22),count=c(num.grid.x,num.grid.y,1,1))

max(datavar.array)
sum(datavar.array)



source.open <- nc_open(filename="/work/MOD3EVAL/kbaker/data/cmaq/36US3/emis.2017/airports/emis_mole_airports_20170102_36US3_cmaq_cb6_WR413_MYR_2017.nc4", write=FALSE, readunlim=FALSE)

x.orig.km <- ncatt_get(source.open,varid=0,attname="XORIG")$value/1000
y.orig.km <- ncatt_get(source.open,varid=0,attname="YORIG")$value/1000
x.cell.size <- ncatt_get(source.open,varid=0,attname="XCELL")$value/1000
y.cell.size <- ncatt_get(source.open,varid=0,attname="YCELL")$value/1000
num.grid.x <- ncatt_get(source.open,varid=0,attname="NCOLS")$value
num.grid.y <- ncatt_get(source.open,varid=0,attname="NROWS")$value
x.proj.12 <- seq(from=x.orig.km + x.cell.size/2, length=num.grid.x, by=x.cell.size)
y.proj.12 <- seq(from=y.orig.km + y.cell.size/2, length=num.grid.y, by=y.cell.size)

#datavar.array <- ncvar_get(source.open,"PEC")
datavar.array <- ncvar_get(source.open,"CO",start=c(1,1,1,22),count=c(num.grid.x,num.grid.y,1,1))
datavar.array[datavar.array < 0] <- 0

max(datavar.array)
sum(datavar.array)





