      subroutine ncf_set_global(begin_date,begin_time,begin_datec,dtout,
     &                          progname,lnest,lstagw,itzon,izone,iproj,
     &                          nxc,nyc,nzc,dxcamx,dycamx,x0camx,y0camx,
     &                          olonin,olatin,tlat1in,tlat2in,note)
      implicit none
c
c-----This routine sets the global file attributes for the NetCDF file
c
c       Inputs:
c         begin_date  I model begin date (YYJJJ)
c         begin_time  I model begin time (HHMM)
c         begin_datec I model begin date (YYMMDD)
c         dtout       I time interval (MM)
c         progname    C program name/version string
c         lnest       L nested grid flag
c         lstagw      L staggered wind flag
c         itzon       I time zone
c         izone       I UTM zone
c         iproj       I projection index
c         nxc         I number of grid columns
c         nyc         I number of grid rows
c         nzc         I number of grid layers
c         dxcamx      R grid X spacing
c         dycamx      R grid Y spacing
c         x0camx      R grid X origin
c         y0camx      R grid Y origin
c         olonin      R projection longitude origin
c         olatin      R projection latitude origin
c         tlat1in     R first true latitude
c         tlat2in     R second true latitude
c         note        C run note
c       Outputs:
c
      include 'ncf_iodat.inc'
c
      character*200 note
      character*60 progname
      integer      begin_date
      integer      begin_datec
      integer      begin_time
      integer      dtout
      integer      itzon,izone,iproj
      integer      nxc,nyc,nzc
      real         dxcamx,dycamx,x0camx,y0camx,olonin,olatin,tlat1in,tlat2in
      logical      lstagw
      logical      lnest
c
c --- get current date/time ---
c
      call getime(ncf_cdate,ncf_ctime)
      ncf_wdate = ncf_cdate
      ncf_wtime = ncf_ctime
c
c --- domain definition attributes ---
c
      ncf_iutm = izone
      ncf_istag = 0
      if (lstagw) ncf_istag = 1
      ncf_cproj = iproj
      if( iproj.eq.0 ) then
         ncf_gdtyp = 1
         ncf_xcell = dxcamx
         ncf_ycell = dycamx
         ncf_xorig = x0camx
         ncf_yorig = y0camx
         if (lnest) then
           ncf_xorig = x0camx + dxcamx
           ncf_yorig = y0camx + dycamx
         endif
         ncf_xorigbuf = x0camx
         ncf_yorigbuf = y0camx
      else
         if( iproj.eq.1 ) ncf_gdtyp = 5
         if( iproj.eq.2 ) ncf_gdtyp = 2
         if( iproj.eq.4 ) ncf_gdtyp = 6
         if( iproj.eq.5 ) ncf_gdtyp = 7
         ncf_xcell = dxcamx*1000.
         ncf_ycell = dycamx*1000.
         ncf_xorig = x0camx*1000.
         ncf_yorig = y0camx*1000.
         if (lnest) then
           ncf_xorig = (x0camx + dxcamx)*1000.
           ncf_yorig = (y0camx + dycamx)*1000.
         endif
         ncf_xorigbuf = x0camx*1000.
         ncf_yorigbuf = y0camx*1000.
      endif
      ncf_xcent = olonin
      ncf_ycent = olatin
      ncf_p_alp = tlat1in
      ncf_p_bet = tlat2in
      ncf_p_gam = olonin
      ncf_nlays = nzc
      ncf_nrows = nyc
      ncf_ncols = nxc
      if (lnest) then
        ncf_nrows = nyc - 2
        ncf_ncols = nxc - 2
      endif
      ncf_nrowsbuf = nyc
      ncf_ncolsbuf = nxc
      ncf_nthik = 1
c
c --- file description attributes ---
c
      ncf_note = trim(note)
      ncf_itzon = itzon
      ncf_ftype = 1
      ncf_vgtyp = 6
      ncf_vgtop = 10000.
      ncf_vglvls = 0.
      ncf_gdnam = " "
      ncf_upnam = " "
      if (begin_date/1000.gt.80) then
        ncf_sdate = 1900000 + begin_date
        ncf_sdatec = 19000000 + begin_datec
      else
        ncf_sdate = 2000000 + begin_date
        ncf_sdatec = 20000000 + begin_datec
      endif
      ncf_stime = begin_time*100
      if (dtout.lt.60) then
        ncf_tstep = dtout*100
      else
        ncf_tstep = (dtout/60)*10000
      endif
c
c --- simulation description attributes ---
c
      ncf_conventions = "CF-1.6"
      ncf_history = "Generated by "//trim(progname)
c
      return
      end
