--T_Mortality_Ozone
CREATE TABLE IF NOT EXISTS T_Mortality_Ozone(
	[Year] INTEGER NOT NULL,														--Year
	EndpointId INTEGER NOT NULL,													--Health Impact Function Param Id
	GeoId11 TEXT NOT NULL,															--State FIPS + County FIPS + CensusTract FIPS
	CreatedDate TEXT NOT NULL DEFAULT (DATETIME(CURRENT_TIMESTAMP,'LOCALTIME')),	--Created date
	DeathsPer10K REAL NOT NULL,														--Deaths per 10k
	DeathsPercentile REAL NOT NULL,													--Deaths percent rank
	Annual REAL NOT NULL,															--Annual value (µg/m3)
	Population REAL NOT NULL,														--Population
	PointEstimate REAL NOT NULL,													--PointEstimate
	PRIMARY KEY([Year],EndpointId,GeoId11),
	FOREIGN KEY (EndpointId) REFERENCES T_Endpoint(Id)
);

--创建索引
CREATE INDEX IF NOT EXISTS Index_Mortality_Ozone_1 ON T_Mortality_Ozone(DeathsPer10K);
CREATE INDEX IF NOT EXISTS Index_Mortality_Ozone_2 ON T_Mortality_Ozone(DeathsPercentile);

