﻿using System.Collections.Generic;

namespace NEXUS.WebApi.Controllers
{
    /// <summary>
    /// District
    /// </summary>
    [Route("api")]
    public class DistrictController : ApiControllerBase
    {
        [Route("EPA_Region")]
        [ResponseCache(Duration = ResponseCache.Duration)]
        [HttpGet]
        public async Task<Response<IEnumerable<T_EPARegion>>> GetEPA_Region([FromServices] IEPARegionRepository repository)
        {
            var data = await repository.QueryAllAsync();
            return SucceededResult(data);
        }

        [Route("State")]
        [ResponseCache(Duration = ResponseCache.Duration)]
        [HttpGet]
        public async Task<Response<IEnumerable<T_State>>> GetState([FromServices] IStateRepository repository, [FromQuery] string? name)
        {
            IEnumerable<T_State> data;
            if (string.IsNullOrEmpty(name))
            {
                data = await repository.QueryAllAsync();
            }
            else
            {
                data = await repository.QueryAsync("Name LIKE '%'||@Keyword||'%'", "Name", new { Keyword = name });
            }
            
            return SucceededResult(data);
        }

        [Route("County")]
        [ResponseCache(Duration = ResponseCache.Duration)]
        [HttpGet]
        public async Task<Response<IEnumerable<T_County>>> GetCounty([FromServices] ICountyRepository repository, [FromQuery] string? name)
        {
            IEnumerable<T_County> data;
            if (string.IsNullOrEmpty(name))
            {
                data = await repository.QueryAllAsync();
            }
            else
            {
                data = await repository.QueryAsync("Name LIKE '%'||@Keyword||'%'", "Name", new { Keyword = name });
            }

            return SucceededResult(data);
        }

        [Route("CBSA")]
        [ResponseCache(Duration = ResponseCache.Duration)]
        [HttpGet]
        public async Task<Response<IEnumerable<T_CBSA>>> GetCBSA([FromServices] ICBSARepository repository, [FromQuery] string? name)
        {
            IEnumerable<T_CBSA> data;
            if (string.IsNullOrEmpty(name))
            {
                data = await repository.QueryAllAsync();
            }
            else
            {
                data = await repository.QueryAsync("Name LIKE '%'||@Keyword||'%'", "Name", new { Keyword = name });
            }

            return SucceededResult(data);
        }

        [Route("CensusTract/{geoId}")]
        [ResponseCache(Duration = ResponseCache.Duration)]
        [HttpGet]
        public async Task<Response<T_CensusTract?>> GetCensusTract([FromServices] ICensusTractRepository repository, [FromRoute] string geoId)
        {
            var data = await repository.QueryByIdAsync("GeoId11", geoId);
            return SucceededResult(data.FirstOrDefault());
        }
    }
}
