﻿using NEXUS.Data.Dtos;

namespace NEXUS.WebApi.Controllers
{
    /// <summary>
    /// Hazard Index
    /// </summary>
    [Route("api/{year}/[controller]/{pollutantType}")]
    public class HazardIndexController : ApiControllerBase
    {
        private readonly IHazardIndexRepository _hazardIndexRepository;
        public HazardIndexController(IHazardIndexRepository hazardIndexRepository)
        {
            _hazardIndexRepository = hazardIndexRepository;
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Percentile")]
        public async Task<Response<IEnumerable<string>>> GetGeoId11(
            [FromRoute] Year year, [FromRoute] PollutantType pollutantType, [FromQuery] float min)
        {
            var data = await _hazardIndexRepository.QueryGeoId11ByMinPercentileAsync(year, pollutantType, min);
            return SucceededResult(data);
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Value")]
        public async Task<Response<IEnumerable<string>>> GetGeoId11(
            [FromRoute] Year year, [FromRoute] PollutantType pollutantType, [FromQuery] double min)
        {
            var data = await _hazardIndexRepository.QueryGeoId11ByMinValueAsync(year, pollutantType, min);
            return SucceededResult(data);
        }
    }
}
