﻿namespace NEXUS.WebApi.Controllers
{
    /// <summary>
    /// Design Values
    /// </summary>
    [Route("api/{year}/[controller]")]
    public class DesignValuesController : ApiControllerBase
    {
        private readonly IDesignValueOzone8HourRepository _ozone8HourRepository;
        private readonly IDesignValuePM25AnnualRepository _pm25AnnualRepository;
        private readonly IDesignValuePM25DailyRepository _pm25DailyRepository;
        public DesignValuesController(
            IDesignValueOzone8HourRepository ozone8HourRepository,
            IDesignValuePM25AnnualRepository pm25AnnualRepository,
            IDesignValuePM25DailyRepository pm25DailyRepository)
        {
            _ozone8HourRepository = ozone8HourRepository;
            _pm25AnnualRepository = pm25AnnualRepository;
            _pm25DailyRepository = pm25DailyRepository;
        }

        #region PM2.5 Annual

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("PM25/Annual")]
        public async Task<Response<IEnumerable<DesignValuePM25AnnualModel>>> GetPM25Annual([FromRoute] Year year)
        {
            var data = await _pm25AnnualRepository.QueryByIdAsync("Year", year);
            return SucceededResult(data.Adapt<IEnumerable<DesignValuePM25AnnualModel>>());
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("PM25/Annual/{geoId5}")]
        public async Task<Response<DesignValuePM25AnnualModel>> GetPM25Annual([FromRoute] Year year, [FromRoute] string geoId5)
        {
            var param = new { Year = year, GeoId5 = geoId5 };
            var data = await _pm25AnnualRepository.QueryAsync("Year=@Year AND GeoId5=@GeoId5", param: param);
            if (data.Any() == false)
            {
                return FailedResult("Empty result");
            }

            return SucceededResult(data.First().Adapt<DesignValuePM25AnnualModel>());
        }

        #endregion

        #region PM2.5 Daily
        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("PM25/Daily")]
        public async Task<Response<IEnumerable<DesignValuePM25DailyModel>>> GetPM25Daily([FromRoute] Year year)
        {
            var data = await _pm25DailyRepository.QueryByIdAsync("Year", year);
            return SucceededResult(data.Adapt<IEnumerable<DesignValuePM25DailyModel>>());
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("PM25/Daily/{geoId5}")]
        public async Task<Response<DesignValuePM25DailyModel>> GetPM25Daily([FromRoute] Year year, [FromRoute] string geoId5)
        {
            var param = new { Year = year, GeoId5 = geoId5 };
            var data = await _pm25DailyRepository.QueryAsync("Year=@Year AND GeoId5=@GeoId5", param: param);
            if (data.Any() == false)
            {
                return FailedResult("Empty result");
            }

            return SucceededResult(data.First().Adapt<DesignValuePM25DailyModel>());
        }

        #endregion

        #region Ozone 8Hour

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Ozone/8Hour")]
        public async Task<Response<IEnumerable<DesignValueOzone8HourModel>>> GetOzone8Hour([FromRoute] Year year)
        {
            var data = await _ozone8HourRepository.QueryByIdAsync("Year", year);
            return SucceededResult(data.Adapt<IEnumerable<DesignValueOzone8HourModel>>());
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Ozone/8Hour/{geoId5}")]
        public async Task<Response<DesignValueOzone8HourModel>> GetOzone8Hour([FromRoute] Year year, [FromRoute] string geoId5)
        {
            var param = new { Year = year, GeoId5 = geoId5 };
            var data = await _ozone8HourRepository.QueryAsync("Year=@Year AND GeoId5=@GeoId5", param: param);
            if (data.Any() == false)
            {
                return FailedResult("Empty result");
            }

            return SucceededResult(data.First().Adapt<DesignValueOzone8HourModel>());
        }

        #endregion
    }
}
