﻿namespace NEXUS.WebApi.Controllers
{
    /// <summary>
    /// Endpoints
    /// </summary>
    [Route("api/[controller]")]
    public class EndpointsController : ApiControllerBase
    {
        private readonly IEndpointRepository _endpointRepository;
        public EndpointsController(IEndpointRepository endpointRepository)
        {
            _endpointRepository = endpointRepository;
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        public async Task<Response<IEnumerable<T_Endpoint>>> Get()
        {
            var data = await _endpointRepository.QueryAllAsync();
            return SucceededResult(data.Where(p => p.Group != "Mortality"));
        }
    }
}
