﻿namespace NEXUS.WebApi.Controllers
{
    /// <summary>
    /// Mortality Rate
    /// </summary>
    [Route("api/{year}/[controller]")]
    public class MortalityRateController : ApiControllerBase
    {
        private readonly IMortalityPM25Repository _pm25Repository;
        private readonly IMortalityOzoneRepository _ozoneRepository;
        public MortalityRateController(IMortalityPM25Repository pm25Repository, IMortalityOzoneRepository ozoneRepository)
        {
            _pm25Repository = pm25Repository;
            _ozoneRepository = ozoneRepository;
        }

        #region PM2.5

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("PM25/Percentile")]
        public async Task<Response<IEnumerable<string>>> GetPM25GeoId11([FromRoute] Year year, [FromQuery, BindRequired] int endpointId, [FromQuery] float min)
        {
            var data = await _pm25Repository.QueryGeoId11ByMinPercentileAsync(year, endpointId, min);
            return SucceededResult(data);
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("PM25/Value")]
        public async Task<Response<IEnumerable<string>>> GetPM25GeoId11([FromRoute] Year year, [FromQuery, BindRequired] int endpointId, [FromQuery] double min)
        {
            var data = await _pm25Repository.QueryGeoId11ByMinValueAsync(year, endpointId, min);
            return SucceededResult(data);
        }

        #endregion

        #region Ozone

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Ozone/Percentile")]
        public async Task<Response<IEnumerable<string>>> GetOzoneGeoId11([FromRoute] Year year, [FromQuery, BindRequired] int endpointId, [FromQuery] float min)
        {
            var data = await _ozoneRepository.QueryGeoId11ByMinPercentileAsync(year, endpointId, min);
            return SucceededResult(data);
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Ozone/Value")]
        public async Task<Response<IEnumerable<string>>> GetOzoneGeoId11([FromRoute] Year year, [FromQuery, BindRequired] int endpointId, [FromQuery] double min)
        {
            var data = await _ozoneRepository.QueryGeoId11ByMinValueAsync(year, endpointId, min);
            return SucceededResult(data);
        }
        #endregion
    }
}
