import { defineStore } from 'pinia';
import { emitter, eventTypes } from '../../libs/event-hub';
import { getGeoId11ByMinPercentile, getGeoId11ByMinValue } from '../../api/ej-demographic';
import { ejCache as cache } from '../../libs/geoid-cache';

export const useEJStore = defineStore('ej', {
    state: () => {
        return {
            year: 2021,
            isValueChecked: false,
            isPercentileChecked: false,
            currentValue: 50,
            currentPercentile: 90,
            maxValue: 100,
            ejValueType: 'DemographicIndex',
            ejPercentileType: 'DemographicIndex',
            ejOptions: [
                { value: 'DemographicIndex', label: 'Demographic index' },
                { value: 'LowIncome', label: '% Low-Income' },
                { value: 'Minority', label: '% Minority' },
                { value: 'LessThanHighSchoolEdu', label: 'Less than high school education' },
                { value: 'LinguisticIsolation', label: 'Linguistic isolation' },
                { value: 'IndividualsUnderAge5', label: 'Individuals under age 5' },
                { value: 'IndividualsOverAge64', label: 'Individuals over age 64' },
            ],
        };
    },
    getters: {},
    actions: {
        async handleData() {
            if (this.isValueChecked) {
                cache.values = await getGeoId11ByMinValue(this.year, this.ejValueType, this.currentValue);
            }

            if (this.isPercentileChecked) {
                cache.percentiles = await getGeoId11ByMinPercentile(this.year, this.ejPercentileType, this.currentPercentile);
            }

            emitter.emit(eventTypes.OnRefreshDataAndSetStyle);
        },
    },
});
