using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Reflection;

namespace SMAT_CE
{
    public partial class About : FormBase
    {
        public About()
        {
            InitializeComponent();
            this.Text = string.Format("About {0}", AssemblyTitle);
            this.lblName.Text = AssemblyProduct;
            this.lblVersion.Text = string.Format("Version: {0}",AssemblyVersion);
            this.lblCopyright.Text = AssemblyCopyright;
            this.lblDescription.Text = AssemblyDescription;
        }

        #region Assembly Attribute Accessors

        public string AssemblyTitle
        {
            get            
            {
                //object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyTitleAttribute),false);
                //if (attributes.Length > 0)
                //{
                //    AssemblyTitleAttribute titleAttribute = (AssemblyTitleAttribute)attributes[0];
                //    if (titleAttribute.Title != "")
                //    {
                //        return titleAttribute.Title;
                //    }
                //}
                string title = "SMAT-CE " + CommonClass.VersionNumber;
                return title;//System.IO.Path.GetFileNameWithoutExtension(Assembly.GetExecutingAssembly().CodeBase)
            }
        }

        public string AssemblyVersion
        {
            get
            {
                string version = CommonClass.VersionNumber + $" ({System.Configuration.ConfigurationManager.AppSettings["ReleaseDate"]})"; //" (September 26, 2017)"Assembly.GetExecutingAssembly().GetName().Version.ToString().Substring(0, System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Count() - 4) + " (March 22, 2017)";               
                return version;//Assembly.GetExecutingAssembly().GetName().Version.ToString().Substring(0, System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Count() - 4) + " (March 22, 2017)"
            }
        }

        public string AssemblyDescription
        {
            get
            {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyDescriptionAttribute), false);
                if (attributes.Length == 0)
                {
                    return "";
                }

                string description = ((AssemblyDescriptionAttribute)attributes[0]).Description.Replace("1.7", CommonClass.VersionNumber);
                return description;
            }
        }

        public string AssemblyProduct
        {
            get
            {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyProductAttribute), false);
                if (attributes.Length == 0)
                {
                    return "";
                }
                return ((AssemblyProductAttribute)attributes[0]).Product;
            }
        }

        public string AssemblyCopyright
        {
            get
            {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCopyrightAttribute), false);
                if (attributes.Length == 0)
                {
                    return "";
                }
                return ((AssemblyCopyrightAttribute)attributes[0]).Copyright;
            }
        }

        public string AssemblyCompany
        {
            get
            {
                object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCompanyAttribute), false);
                if (attributes.Length == 0)
                {
                    return "";
                }
                return ((AssemblyCompanyAttribute)attributes[0]).Company;
            }
        }

        #endregion

        private void btnOKAbout_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void btnRealeaseNote_Click(object sender, EventArgs e)
        {
            try
            {
                ReleaseNotes releaseNotesForm = new ReleaseNotes();
                releaseNotesForm.ShowDialog();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
