using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace SMAT_CE
{

    /// <summary>
    ///Extension method
    /// added by devin
    /// 20190724
    /// </summary>
    public static class ExtensionMethods
    {
        /// <summary>
        ///Compatible with projects on different computers
        /// </summary>
        /// <param name="filePath"></param>    
        ///<returns>returns the local path of the current computer</returns>
        public static string ToLocal(this string filePath, string keyWord = "SMAT-CE")
        {
            string result = filePath;
            if (string.IsNullOrEmpty(keyWord))
            {
                keyWord = "SMAT-CE";
            }
            try
            {
                string firstFile = filePath;
                var arr = firstFile.Split('\\');
                if (!arr.Contains(keyWord))
                {
                    keyWord = "My SMAT-CE Files";
                }               
                int index = firstFile.IndexOf(keyWord);
                if (index >= 0)
                {
                    index += (keyWord + "\\").Length;
                    string OriginalFilePath = firstFile.Substring(0, index);
                    string LocalFilePath = string.Empty;
                    if (keyWord=="SMAT-CE")
                    {
                        LocalFilePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, string.Format(@"{0}\", keyWord));
                        if (!Directory.Exists(LocalFilePath))
                        {
                            LocalFilePath = AppDomain.CurrentDomain.BaseDirectory;
                        }
                    }
                    else
                    {
                        LocalFilePath=CommonClass.ResultFilePath+"\\";
                    }                    
                    result = filePath.Replace(OriginalFilePath, LocalFilePath);
                    if (!File.Exists(result))//cannot find the path, return the original path.
                    {
                        result = filePath;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            return result;
        }

        /// <summary>
        ///When setting the file path, you can assign the path to the tag tag of the control, and then assign the file name to the text of the control
        /// </summary>
        /// <param name="control"></param>
        ///<param name="path">file path</param>
        public static void ToTag(this System.Windows.Forms.Control control, string path)
        {

            try
            {
                if (!string.IsNullOrEmpty(path))
                {
                    control.Tag = path;
                    control.Text = Path.GetFileName(path);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Get local path
        ///The path is in c:\users\devins\documents\my SMAT CE files\ format.
        /// add by devin
        /// </summary>
        ///<param name="configpath">current path</param>
        ///<param name="keyword">the position of the keyword to be intercepted.The first half of the keyword is system Environment.SpecialFolder.Replace mydocuments, and connect the second half directly to</param>
        ///<returns>returns the real path.If the real path cannot be found, the original value returns</returns>
        public static string GetLocalDataPath(this string configPath, string keyWord = "My SMAT-CE Files")
        {
            string result = configPath;
            try
            {
                bool noNeedReplace = File.Exists(configPath) || Directory.Exists(configPath);//There is no need to use environment SpecialFolder.Mydocuments replacement
                if (!noNeedReplace)
                {
                    if (configPath.ToLower().Contains(keyWord.ToLower()))
                    {
                        int i = configPath.ToLower().IndexOf(keyWord.ToLower());
                        if (i > 0)
                        {
                            result = Environment.GetFolderPath(System.Environment.SpecialFolder.MyDocuments) + @"\" + configPath.Substring(i);
                        }
                        noNeedReplace = File.Exists(result) || Directory.Exists(result);
                        if (!noNeedReplace)
                        {
                            result = configPath;
                        }
                    }
                    else if (configPath.ToLower().Contains("debug"))
                    {
                        int i = configPath.ToLower().IndexOf("debug");
                        if (i > 0)
                        {
                            result = AppDomain.CurrentDomain.BaseDirectory + configPath.Substring(i + "debug".Length);
                        }
                        noNeedReplace = File.Exists(result) || Directory.Exists(result);
                        if (!noNeedReplace)
                        {
                            result = configPath;
                        }
                    }
                }

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            return result;
        }

        /// <summary>
        ///Get the directory where the user document is located
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        public static void ToUserDocument(this BaseScenario baseScenario)
        {
            try
            {

                //Todo: at present, only Chinese cases are verified, and other cases need to be supplemented later
                if (baseScenario.configuration is AnnualPMAnalysisChinaConfiguration)
                {
                    var configuration = baseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                    configuration.modelDataInputChina.BaselineModelDataFile = configuration.modelDataInputChina.BaselineModelDataFile.GetLocalDataPath();
                    configuration.modelDataInputChina.ControlModelDataFile = configuration.modelDataInputChina.ControlModelDataFile.GetLocalDataPath();
                    configuration.monitorDataInputChina.MonitorDataInputFile = configuration.monitorDataInputChina.MonitorDataInputFile.GetLocalDataPath();
                    configuration.pm25SpeciesOptionChina.SpeciesMonitorDataFile = configuration.pm25SpeciesOptionChina.SpeciesMonitorDataFile.GetLocalDataPath();
                }
                else if (baseScenario.configuration is OzoneAnalysisChinaConfiguration)
                {
                    var configuration = baseScenario.configuration as OzoneAnalysisChinaConfiguration;
                    configuration.modelDataOzoneChina.baselineModelDataFile = configuration.modelDataOzoneChina.baselineModelDataFile.GetLocalDataPath();
                    configuration.modelDataOzoneChina.forecastModelDataFile = configuration.modelDataOzoneChina.forecastModelDataFile.GetLocalDataPath();
                    configuration.monitorDataOzoneChina.ozoneMonitorDataFile = configuration.monitorDataOzoneChina.ozoneMonitorDataFile.GetLocalDataPath();
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }
    }
}
