using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using ProtoBuf;
using System.Data;
using LumenWorks.Framework.IO.Csv;
using System.Collections;
using System.Windows.Forms;
using System.Data.OleDb;
using DotSpatial.Topology.Voronoi;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using System.Drawing;
using System.Xml;

namespace SMAT_CE
{
    #region Language

    public class LanguageOld
    {
        public static bool IsSMATChina = false;
        public static string LangPath = Application.StartupPath + "\\Configs\\Language\\English.xml";
        private static Dictionary<string, string> dicControls = new Dictionary<string, string>();

        public static void SetDicFromXml(Control control, Dictionary<string, string> dic)
        {
            try
            {
                XmlReader reader = XmlReader.Create(LangPath);
                reader.ReadToDescendant("Form");
                if (control is UserControl)
                {
                    reader.ReadToNextSibling("UserControl");
                }
                reader.ReadToDescendant(control.Name);
                XmlReader subreader = reader.ReadSubtree();
                while (subreader.Read())
                {
                    try
                    {
                        string key, value;
                        if (subreader.NodeType == XmlNodeType.Element && subreader.Name == "Item")
                        {
                            if (subreader.GetAttribute("key") != "")
                            {
                                key = subreader.GetAttribute("key");
                                if (!dic.ContainsKey(key))
                                {
                                    value = subreader.GetAttribute("value");
                                    value = value.Replace(@"\\\n", System.Environment.NewLine);
                                    value = value.Replace(@"\\\t", "\t");
                                    dic.Add(key, value);
                                }
                            }
                        }
                    }
                    catch (Exception)
                    {
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("");
                CommonClass.LogError(ex);
            }

        }
        public static void ChangeLanguage(Dictionary<string, string> dic, Control control)
        {
            try
            {
                if (dic.Count == 0)
                {
                    MessageBox.Show("Language files lost! Showing in English!");
                    LangPath = Application.StartupPath + "\\Configs\\Language\\English.xml";
                }
                if (control is Form && control.Name != null && dic.ContainsKey(control.Name))
                    control.Text = dic[control.Name];

                foreach (Control ctrl in control.Controls)
                {
                    #region translate normal controls
                    try
                    {
                        if (dic.ContainsKey(ctrl.Name))
                        {
                            ctrl.Text = dic[ctrl.Name];
                        }
                    }
                    catch (Exception)
                    {
                        MessageBox.Show("1");
                    }
                    #endregion

                    #region translate toolstrip
                    if (ctrl is ToolStrip)
                    {
                        foreach (object ToolCtrl in ((ToolStrip)ctrl).Items)
                        {
                            if (ToolCtrl is ToolStripButton)
                            {
                                try
                                {
                                    ((ToolStripButton)ToolCtrl).Text = dic[((ToolStripButton)ToolCtrl).Name];
                                }
                                catch (Exception)
                                {

                                }

                            }
                            else if (ToolCtrl is ToolStripDropDownButton)
                            {
                                ((ToolStripDropDownButton)ToolCtrl).Text = dic[((ToolStripDropDownButton)ToolCtrl).Name];
                                foreach (object dditem in ((ToolStripDropDownButton)ToolCtrl).DropDownItems)
                                {
                                    if (dditem is ToolStripMenuItem)
                                    {
                                        ToolStripMenuItem tsmi = (ToolStripMenuItem)dditem;
                                        tsmi.Text = dic[tsmi.Name];
                                    }
                                    else
                                    {
                                        continue;
                                    }
                                }
                            }
                        }
                    }
                    #endregion

                    #region translate tabcontrol
                    if (ctrl is TabControl)
                    {
                        foreach (TabPage tbp in ((TabControl)ctrl).TabPages)
                        {
                            foreach (Control SubCtrl in tbp.Controls)
                            {
                                ChangeLanguage(dic, ctrl);
                            }
                        }
                    }
                    #endregion

                    #region translate usercontrol
                    if (ctrl is UserControl)
                    {
                        if (ctrl.Name == "plotControl1" || ctrl.Name == "mainMap" || ctrl.Name == "colorBlend" || ctrl.Name == "zgcChart" || ctrl.Name == "colorBlendMap"
                            || ctrl.Name == "uc_AnalysisOption" || ctrl.Name == "uc_ModelDataInputA" || ctrl.Name == "uc_ModelDataInputD" || ctrl.Name == "uc_ModelDataInputO"
                            || ctrl.Name == "uc_MonitorDataInputA" || ctrl.Name == "uc_MonitorDataInputD" || ctrl.Name == "uc_MonitorDataInputO" || ctrl.Name == null)
                            continue;
                        Dictionary<string, string> newdic = new Dictionary<string, string>();
                        SetDicFromXml(ctrl, newdic);
                        ChangeLanguage(newdic, ctrl);
                    }
                    #endregion

                    if (ctrl.HasChildren && !(ctrl is UserControl) && ctrl.Name != "SMAT_CE")
                        ChangeLanguage(dic, ctrl);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("");
                CommonClass.LogError(ex);
            }

        }

        //public static void ce(Control control, string str, XmlDocument doc)
        //{
        //    foreach (Control ctrl in control.Controls)
        //    {
        //        XmlElement Node = doc.CreateElement("Item");
        //        Node.SetAttribute("key", ctrl.Name);
        //        Node.SetAttribute("value", ctrl.Text);
        //        doc.SelectSingleNode(str).AppendChild(Node);
        //        if (ctrl is TabPage)
        //        {
        //            MessageBox.Show("!" + ctrl.Name);
        //        }
        //        if (ctrl.Controls.Count != 0 && !(ctrl is UserControl))
        //        {
        //            ce(ctrl, str, doc);
        //        }

        //        if (ctrl is ToolStrip)
        //        {
        //            foreach (object item in ((ToolStrip)ctrl).Items)
        //            {
        //                if (item is ToolStripButton)
        //                {
        //                    XmlElement node = doc.CreateElement("Item");
        //                    node.SetAttribute("key", ((ToolStripButton)item).Name);
        //                    node.SetAttribute("value", ((ToolStripButton)item).Text);
        //                    doc.SelectSingleNode(str).AppendChild(node);
        //                }
        //                else if (item is ToolStripDropDownButton)
        //                {
        //                    XmlElement node = doc.CreateElement("Item");
        //                    node.SetAttribute("key", ((ToolStripDropDownButton)item).Name);
        //                    node.SetAttribute("value", ((ToolStripDropDownButton)item).Text);
        //                    doc.SelectSingleNode(str).AppendChild(node);
        //                    MessageBox.Show(((ToolStripDropDownButton)item).Name);
        //                    foreach (object dditems in ((ToolStripDropDownButton)item).DropDownItems)
        //                    {
        //                        if (dditems is ToolStripMenuItem)
        //                        {
        //                            ToolStripMenuItem tsmi = (ToolStripMenuItem)dditems;
        //                            XmlElement tsminode = doc.CreateElement("Item");
        //                            tsminode.SetAttribute("key", tsmi.Name);
        //                            tsminode.SetAttribute("value", tsmi.Text);
        //                            doc.SelectSingleNode(str).AppendChild(tsminode);
        //                        }
        //                        else
        //                        {
        //                            continue;
        //                        }
        //                    }
        //                }
        //            }
        //        }
        //    }
        //    doc.Save(Application.StartupPath + "\\Configs\\Language\\Controls.xml");
        //}
        //public static void CreateXML(Control control)
        //{
        //    try
        //    {
        //        XmlDocument doc = new XmlDocument();
        //        doc.Load(Application.StartupPath + "\\Configs\\Language\\Controls.xml");
        //        string str = "";

        //        XmlElement CtrlName = doc.CreateElement(control.Name);
        //        if (control is Form)
        //        {
        //            if (doc.SelectSingleNode("//Form/" + control.Name) != null)
        //            {
        //                XmlNode child = doc.SelectSingleNode("//Form/" + control.Name);
        //                XmlNode parent = child.ParentNode;
        //                parent.RemoveChild(child);
        //            }
        //            doc.SelectSingleNode("//Form").AppendChild(CtrlName);
        //            XmlElement Node = doc.CreateElement("Item");
        //            Node.SetAttribute("key", control.Name);
        //            Node.SetAttribute("value", control.Text);
        //            doc.SelectSingleNode("//Form/" + control.Name).AppendChild(Node);
        //            str = "//Form/" + control.Name;

        //        }
        //        if (control is UserControl)
        //        {
        //            if (doc.SelectSingleNode("//UserControl/" + control.Name) != null)
        //            {
        //                XmlNode child = doc.SelectSingleNode("//UserControl/" + control.Name);
        //                XmlNode parent = child.ParentNode;
        //                parent.RemoveChild(child);
        //            }
        //            doc.SelectSingleNode("//UserControl").AppendChild(CtrlName);
        //            str = "//UserControl/" + control.Name;
        //        }
        //        doc.Save(Application.StartupPath + "\\Configs\\Language\\Controls.xml");

        //        ce(control, str, doc);
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //    }
        //}

        //public static void UpdateConfig(string Xvalue)
        //{
        //    try
        //    {
        //        XmlDocument doc = new XmlDocument();
        //        doc.Load(Application.StartupPath + "\\Configs\\Language\\LangSetting.xml");
        //        doc.SelectSingleNode("//Settings/Type[@key='language']").Attributes["value"].Value = Xvalue;
        //        doc.Save(Application.StartupPath + "\\Configs\\Language\\LangSetting.xml");
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //    }

        //}
        //public static void GetLanguagePath()
        //{
        //    try
        //    {
        //        XmlDocument doc = new XmlDocument();
        //        doc.Load(Application.StartupPath + "\\Configs\\Language\\LangSetting.xml");
        //        string str = doc.SelectSingleNode("//Settings/Type[@key='language']").Attributes["value"].Value;
        //        LangPath = Application.StartupPath + "\\Configs\\language\\" + str + ".xml";
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //    }

        //}

        public static string Translate(string str)
        {
            try
            {
                //Trun off translation
                //if (str == "")
                //    return "";
                //XmlDocument doc = new XmlDocument();
                //doc.Load(LangPath);
                //XmlNodeList nodelist = doc.SelectSingleNode("//Message").ChildNodes;

                //foreach (XmlNode node in nodelist)
                //{
                //    XmlElement xe = (XmlElement)node;
                //    if (xe.GetAttribute("key") == str)
                //    {
                //        return xe.GetAttribute("value");
                //    }
                //}
                return str;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return str;
            }

        }
        public static string CurrentLanguage()
        {
            if (LangPath.Contains("English.xml"))
            {
                return "En";
            }
            else
            {
                return "Ch";
            }
        }
    }

    #endregion
}
