using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Diagnostics;

namespace SMAT_CE
{
    public class Logger
    {
        private static string CRLF = "\r\n";           //Terminator

        #region LogError
        /// <summary>
        ///Record errors that occur
        ///Heavy load 1
        /// </summary>
        ///<param name="ex">exception object</param>
        public static void LogError(Exception ex)
        {
            try
            {
                string place = ex.StackTrace.ToString();
                int pos = place.LastIndexOf("\n");
                //Debug.WriteLine(ex.Message+"\n"+msg+"\n"+ex.StackTrace.ToString());
                //If it cannot be found, pos=-1, the character index in c# starts from 0
                string msg = CRLF + DateTime.Now.ToString() + CRLF + ex.Message + CRLF + place.Substring(pos + 1);
                //Debug.WriteLine(msg);
                AppendErr(GetLogPath(ex), msg);
                //Debug.WriteLine(System.Threading.Thread.GetDomain().GetAssemblies().ToString());
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + "  " + "CommonClass.LogError";
                Debug.WriteLine(errMsg);
                Console.WriteLine(errMsg);
            }
        }
        /// <summary>
        ///Record errors that occur
        ///Heavy load 2
        /// </summary>
        ///<param name="ex">exception object</param>
        ///<param name="msg">additional custom information</param>
        public static void LogError(Exception ex, string msg)
        {
            try
            {
                string place = ex.StackTrace.ToString();
                int pos = place.LastIndexOf("\n");

                //Debug.WriteLine(ex.Message+"\n"+msg+"\n"+ex.StackTrace.ToString());
                //If it cannot be found, pos=-1, the character index in c# starts from 0
                string myMsg = CRLF + DateTime.Now.ToString() + CRLF + ex.Message + CRLF + msg + CRLF + place.Substring(pos + 1);
                //Debug.WriteLine(myMsg);
                AppendErr(GetLogPath(ex), myMsg);
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + "  " + "CommonClass.LogError";
                Debug.WriteLine(errMsg);
                Console.WriteLine(errMsg);
            }
        }
        /// <summary>
        ///Record errors that occur
        ///Heavy load 3
        /// </summary>
        ///<param name="msg">customized error message</param>
        public static void LogError(string msg)
        {
            try
            {
                //Debug.WriteLine("\n"+msg+"  "+DateTime.Now.ToString());
                string myMsg = CRLF + DateTime.Now.ToString() + CRLF + msg;
                //C:\err must be guaranteed_ Log\ directory exists and ASP_ Net has the right to write
                //AppendErr("c:\\Err_Log\\Err_.log",myMsg);
                AppendErr(GetLogPath(null), myMsg);
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + CRLF + "CommonClass.LogError";
                Debug.WriteLine(errMsg);
                Console.WriteLine(errMsg);
            }
        }

        /// <summary>
        ///From app Get the full path of the file recording the error log in the Appsettings section of config (or web.config)<br/>
        ///If the configuration section does not exist, then in datamanager Create err in the directory where DLL is located_ log.log
        /// </summary>
        /// <param name="ex"></param>
        ///<returns>full path of file</returns>
        public static string GetLogPath(Exception ex)
        {
            try
            {
                //string logPath;

                // Get the appSettings.
                //Even if the Appsettings section does not exist in the configuration file, there will be no error
                //System.Collections.Specialized.NameValueCollection appSettings = ConfigurationManager.AppSettings;

                //logPath = appSettings["errorLogFile"];

                //if (logPath == null)
                //{
                //    logPath = AppDomain.CurrentDomain.BaseDirectory + "\\err_log.log";
                //    logPath = logPath.Replace("\\\\", "\\");
                //}
                //CheckAndCreateDir(logPath);
                //return logPath;
                return null;
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + CRLF + "Logger.GetLogPath";
                Debug.WriteLine(errMsg);
                Console.WriteLine(errMsg);
                return "err_log.log";
            }
        }

        /// <summary>
        ///Check the full path of the meeting file and create all nonexistent directories (Note: do not create files)
        /// </summary>
        ///<param name="path">the full path of the file, which must contain the file name For example: d:\test\test txt</param>
        public static void CheckAndCreateDir(string path)
        {
            try
            {
                string dir;
                int pos = path.LastIndexOf("\\");
                dir = path.Substring(0, pos);
                if (Directory.Exists(dir) == false)
                {
                    //Create all nonexistent directories in the path
                    Directory.CreateDirectory(dir);
                }
                //return;
            }
            catch (Exception ex)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + "\\rn" + ex.ToString() + "\r\npath=" + path + CRLF + "Logger.CheckAndCreateDir";
                Debug.WriteLine(errMsg);
                Console.WriteLine(errMsg);
            }
        }

        /// <summary>
        ///Append error information to the error log
        /// </summary>
        ///<param name="path">error log file location, such as: "c:\err_ Log\\err_ myUtil.log"</param>
        ///<param name="msg">error message</param>
        private static void AppendErr(string path, string msg)
        {
            try
            {
                StreamWriter writer = new StreamWriter(path, true);
                writer.WriteLine(msg);
                writer.Close();
                Debug.WriteLine(msg);
                Console.WriteLine(msg);
            }
            catch (Exception myEx)
            {
                string errMsg = CRLF + DateTime.Now.ToString() + CRLF + myEx.Message + CRLF + "Logger.AppendErr";
                Debug.WriteLine(errMsg);
                Console.WriteLine(errMsg);
            }
        }
        #endregion
    }//class
}
