using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace SMAT_CE
{
    public class XMLWorker
    {
        //Use this XmlWriter to write content to the XML file
        XmlTextWriter _writer = null;

        /// <summary>
        ///Create XmlWriter
        /// </summary>
        ///<param name="strfilepath">full path of XML data file to be generated</param>
        ///<returns>true indicates success; False means failure</returns>
        public bool CreateDataFile(string strFilePath)
        {
            try
            {
                _writer = new XmlTextWriter(strFilePath, null);
                _writer.Formatting = Formatting.Indented;
                _writer.WriteStartDocument();

                return true;
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
                return false;
            }
        }

        /// <summary>
        ///Write to XML file
        /// </summary>
        public void Save()
        {
            try
            {
                _writer.WriteEndDocument();
                _writer.Flush();
                _writer.Close();
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }
        }

        /// <summary>
        ///Write node start tag
        /// </summary>
        ///<param name="nodename">node name</param>
        public void WriteStartElement(string nodeName)
        {
            try
            {
                _writer.WriteStartElement(nodeName);
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }
        }

        /// <summary>
        ///Write node end tag
        /// </summary>
        public void WriteEndElement()
        {
            try
            {
                _writer.WriteEndElement();
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }
        }

        /// <summary>
        ///Write node attributes, such as writing<table dest="corp_ Dest="corp in info">_ Info"
        /// </summary>
        ///<param name="name">attribute name</param>
        ///<param name="value">attribute value</param>
        public void WriteAttributeString(string name, string value)
        {
            try
            {
                _writer.WriteAttributeString(name, value);
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }
        }

        /// <summary>
        ///Write node content values, such as writing<field>num</field>
        /// </summary>
        ///<param name="field">element name</param>
        ///<param name="value">element value</param>
        public void WriteElementString(string field, string value)
        {
            try
            {
                _writer.WriteElementString(field, value);
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }
        }
        /// <summary>
        /// create a xml file
        /// </summary>
        /// <param name="xmlPath"></param>
        /// <param name="startNode"></param>
        public void CreateNode(string xmlPath, string nodeName)
        {
            XMLWorker worker = new XMLWorker();
            try
            {
                bool ok = worker.CreateDataFile(xmlPath);
                //if (!ok)
                //{
                //    msg = "Error encountered while creating script file (*.xml)!"; ;                  
                //    return false;
                //}
                worker.WriteStartElement(nodeName);
                //worker.WriteStartElement("RSM");
                worker.WriteEndElement();
                worker.Save();
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }
            finally
            {
                if (worker != null)
                {
                    worker = null;
                }
                //if (msg != "")
                //{
                //    //MessageBox.Show(msg, Language.Localization.MessageTitle, MessageBoxButtons.OK, icon);
                //}
            }
        }

        /// <summary>
        ///Append node fragments to existing XML files
        /// </summary>
        ///<param name="xmlpath">path to append file</param>
        ///<param name="startnode">append node fragment at the specified node</param>
        ///<param name="sectionnode">node fragment information</param>
        public void AppendNode(string xmlPath, string startNode, SectionNode sectionNode)
        {
            XmlDocument xmlDoc = new XmlDocument();
            try
            {
                xmlDoc.Load(xmlPath);
                XmlNode root = xmlDoc.SelectSingleNode(startNode); //xmlDoc.SelectSingleNode("bookstore");//Find<bookstore>
                //Create a parent node
                XmlElement parentNode = xmlDoc.CreateElement(sectionNode.ParentNode.NodeName);
                //XmlElement xe1 = xmlDoc.CreateElement("book");//Create a<book>node
                //Set properties for this parent node
                foreach (var item in sectionNode.ParentNode.NodeAttributes)
                {
                    //xe1.SetAttribute ("gene", "Li zanhong ")//Set the generic attribute of this node
                    //xe1.SetAttribute("ISBN", "2-3631-4");//Set the ISBN attribute of this node
                    parentNode.SetAttribute(item.Key, item.Value);
                }
                foreach (var item in sectionNode.ChildNodes)
                {
                    XmlElement childNode = xmlDoc.CreateElement(item.NodeName);
                    childNode.InnerText = item.NodeText;//Set text node
                    foreach (var childAttribute in item.NodeAttributes)
                    {
                        parentNode.SetAttribute(childAttribute.Key, childAttribute.Value);
                    }
                    parentNode.AppendChild(childNode);//Add to the<book>node
                }
                root.AppendChild(parentNode);//Add to the<bookstore>node
                xmlDoc.Save(xmlPath);

            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }
        }

        /// <summary>
        ///Modify the values and attributes of the specified node
        /// </summary>
        ///<param name="xmlpath">file to be modified</param>
        ///<param name="updatedparentnodename">the parent node name of the node to be modified</param>
        ///<param name="updatedchildnode">node to be modified</param>
        public void UpdateNode(string xmlPath, string updatedParentNodeName, List<Node> lstNode)
        {
            try
            {
                XmlDocument xmlDoc = new XmlDocument();
                xmlDoc.Load(xmlPath);
                XmlNodeList nodeList = xmlDoc.SelectSingleNode(updatedParentNodeName).ChildNodes;//Get all child nodes of the bookstore node
                foreach (Node node in lstNode)
                {
                    foreach (XmlNode xn in nodeList)//Traverse all child nodes
                    {
                        XmlElement xe = (XmlElement)xn;//Convert child node type to xmlelement type
                        if (xe.Name == node.NodeName)
                        {
                            xe.InnerText = node.NodeText;
                            foreach (var item in node.NodeAttributes)
                            {
                                xe.SetAttribute(item.Key, item.Value);
                            }
                            break;
                        }
                    }
                }
                xmlDoc.Save(xmlPath);//Save.
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
            }
        }


        public void DeleteNode(string xmlPath, string deletedParentNodeName, Node deletedChildNode)
        {

            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(xmlPath);
            XmlNode xn = xmlDoc.SelectSingleNode("bookstore");
            XmlNodeList xnl = xn.ChildNodes;
            foreach (XmlNode xnf in xnl)
            {
                XmlElement xe = (XmlElement)xnf;
                Console.WriteLine(xe.GetAttribute("genre"));//Display attribute values
                Console.WriteLine(xe.GetAttribute("ISBN"));


                XmlNodeList xnf1 = xe.ChildNodes;
                foreach (XmlNode xn2 in xnf1)
                {
                    Console.WriteLine(xn2.InnerText);//Show child node point text
                }
            }
        }

        public bool SearchNode(string xmlPath, string NodeName)
        {

            try
            {
                XmlDocument xmlDoc = new XmlDocument();
                xmlDoc.Load(xmlPath);
                XmlElement root = xmlDoc.DocumentElement;
                XmlNode node = root.SelectSingleNode(string.Format("//Settings//{0}", NodeName));//Find the specified node
                if (node == null)
                {
                    return false;
                }
                return true;
                //Get all child nodes of the root node
                //XmlNodeList childNodes = xmlDoc.SelectSingleNode("Settings").ChildNodes;
            }
            catch (Exception ex)
            {
                Logger.LogError(ex);
                return false;               
            }
        }

    }// XMLWorker
}
