
namespace SMAT_CE.DownscaleR.AnnualPM
{
    /// <summary>
    /// Annual PM model data
    /// </summary>
    public class AnnualPMModel
    {
        private string _id;
        private double _lat;
        private double _lon;
        private double _pm;
        private string _quarter;
        private double _ds_prediction;
        private double _ds_sepred;
        /// <summary>
        /// Initialize the annual pm model data with some given values
        /// </summary>
        /// <param name="id">Id</param>
        /// <param name="lat">Latitude</param>
        /// <param name="lon">Longitude</param>
        /// <param name="pm">Base value</param>
        /// <param name="quarter">Quarter</param>
        /// <param name="ds_prediction">Downscaler prediction value</param>
        /// <param name="ds_sepred">Downscaler sepred value</param>
        public AnnualPMModel(string id, double lat, double lon, double pm, string quarter, double ds_prediction = 0.0, double ds_sepred = 0.0)
        {
            _id = id;
            _lat = lat;
            _lon = lon;
            _pm = pm;
            _quarter = quarter;
            _ds_prediction = ds_prediction;
            _ds_sepred = ds_sepred;
        }
        /// <summary>
        /// Id
        /// </summary>
        public string Id
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// Latitude
        /// </summary>
        public double Lat
        {
            get { return _lat; }
            set { _lat = value; }
        }
        /// <summary>
        /// Longitude
        /// </summary>
        public double Lon
        {
            get { return _lon; }
            set { _lon = value; }
        }
        /// <summary>
        /// Base value
        /// </summary>
        public double PM
        {
            get { return _pm; }
            set { _pm = value; }
        }
        /// <summary>
        /// Quarter
        /// </summary>
        public string Quarter
        {
            get { return _quarter; }
            set { _quarter = value; }
        }
        /// <summary>
        /// Downscaler prediction value, not forcast
        /// </summary>
        public double DS_Prediction
        {
            get { return _ds_prediction; }
            set { _ds_prediction = value; }
        }
        /// <summary>
        /// Downscaler sepred value
        /// </summary>
        public double DS_SEpred
        {
            get { return _ds_sepred; }
            set { _ds_sepred = value; }
        }
    }
}
