using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.DownscaleR
{
    /// <summary>
    ///Downscaler settings
    /// </summary>
    public class CommonSettings : ICloneable
    {
        /// <summary>
        ///Initialize
        /// </summary>
        public CommonSettings()
        {
            _numit = 2500;
            _burn = 500;
            _thin = 1;
            _cmaqres = 12;
            _multithreading = false;
            _modelfilepath = null;
        }
        private int _numit;
        private int _burn;
        private int _thin;
        private int _cmaqres;
        private bool _multithreading;
        private string _modelfilepath;
        /// <summary>
        /// Desired number of MCMC draws
        ///Default: 2500
        /// </summary>
        public int Numit
        {
            get { return _numit; }
            set { _numit = value; }
        }
        /// <summary>
        /// Desired Burn-in time
        ///Default: 500
        /// </summary>
        public int Burn
        {
            get { return _burn; }
            set { _burn = value; }
        }
        /// <summary>
        /// Thin every
        ///Default: 1
        /// </summary>
        public int Thin
        {
            get { return _thin; }
            set { _thin = value; }
        }
        /// <summary>
        /// km resolution of the numerical model data：4, 12, 36；
        ///Default: 12
        /// </summary>
        public int Cmaqres
        {
            get { return _cmaqres; }
            set { _cmaqres = value; }
        }
        /// <summary>
        /// DS multithreading computing;
        ///Default: false
        /// </summary>
        public bool MultiThreading
        {
            get { return _multithreading; }
            set { _multithreading = value; }
        }
        /// <summary>
        /// Model file path;
        ///Default: null
        /// </summary>
        public string ModelFilePath
        {
            get { return _modelfilepath; }
            set { _modelfilepath = value; }
        }
        /// <summary>
        ///Cloning
        /// </summary>
        public object Clone()
        {
            return new CommonSettings()
            {
                Numit = _numit,
                Burn = _burn,
                Thin = _thin,
                Cmaqres = _cmaqres,
                MultiThreading = _multithreading,
                ModelFilePath = _modelfilepath
            };
        }
    }
}
