using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.DownscaleR.Ozone
{
    /// <summary>
    /// Ozone downscaler result output data
    /// </summary>
    public class OzoneModel
    {
        private string _id;
        private double _lat;
        private double _lon;
        private double _ozone;
        private double _ds_prediction;
        private double _ds_sepred;
        /// <summary>
        /// Initialize the ozone downscaler result output data with some given values
        /// </summary>
        /// <param name="id">Id</param>
        /// <param name="lat">Latitude</param>
        /// <param name="lon">Longitude</param>
        /// <param name="ozone">Ozone value</param>
        /// <param name="ds_prediction">Downscaler prediction value</param>
        /// <param name="ds_sepred">Downscaler sepred value</param>
        public OzoneModel(string id, double lat, double lon, double ozone, double ds_prediction = -9.0, double ds_sepred = -9.0)
        {
            _id = id;
            _lat = lat;
            _lon = lon;
            _ozone = ozone;
            _ds_prediction = ds_prediction;
            _ds_sepred = ds_sepred;
        }
        /// <summary>
        /// Id
        /// </summary>
        public string Id
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// Latitude
        /// </summary>
        public double Lat
        {
            get { return _lat; }
            set { _lat = value; }
        }
        /// <summary>
        /// Longitude
        /// </summary>
        public double Lon
        {
            get { return _lon; }
            set { _lon = value; }
        }
        /// <summary>
        /// Ozone value
        /// </summary>
        public double Ozone
        {
            get { return _ozone; }
            set { _ozone = value; }
        }
        /// <summary>
        /// Downscaler prediction value, not forcast
        /// </summary>
        public double DS_Prediction
        {
            get { return _ds_prediction; }
            set { _ds_prediction = value; }
        }
        /// <summary>
        /// Downscaler sepred value
        /// </summary>
        public double DS_SEpred
        {
            get { return _ds_sepred; }
            set { _ds_sepred = value; }
        }
    }
}
