using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.DownscaleR.Ozone
{
    /// <summary>
    /// Ozone monitor data
    /// </summary>
    public class OzoneMonitor
    {
        private string _id;
        private double _lat;
        private double _lon;
        private double _ozonebase;
        /// <summary>
        /// Initialize the ozone monitor data with some given values
        /// </summary>
        /// <param name="id">Id</param>
        /// <param name="lat">Latitude</param>
        /// <param name="lon">Longitude</param>
        /// <param name="ozonebase">Base value</param>
        public OzoneMonitor(string id, double lat, double lon, double ozonebase)
        {
            _id = id;
            _lat = lat;
            _lon = lon;
            _ozonebase = ozonebase;
        }
        /// <summary>
        /// Id
        /// </summary>
        public string Id
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// Latitude
        /// </summary>
        public double Lat
        {
            get { return _lat; }
            set { _lat = value; }
        }
        /// <summary>
        /// Longitude
        /// </summary>
        public double Lon
        {
            get { return _lon; }
            set { _lon = value; }
        }
        /// <summary>
        /// Base value
        /// </summary>
        public double Ozonebase
        {
            get { return _ozonebase; }
            set { _ozonebase = value; }
        }
    }
}
