using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.Matlab
{
    /// <summary>
    ///Double numeric comparator
    /// </summary>
    public class DoubleComparer : IComparer<double>
    {
        /// <summary>
        ///Initialize sort type
        /// </summary>
        ///<param name="type">sort type</param>
        public DoubleComparer(SortType type)
        {
            _type = type;
        }

        //Default ascending order
        private SortType _type;

        //Icomparer<double>member
        public int Compare(double x, double y)
        {
            if (_type == SortType.Descend)
            {
                return y.CompareTo(x);
            }
            return x.CompareTo(y);
        }
    }
}
