using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.Matlab
{
    /// <summary>
    ///Double vector
    /// </summary>
    public class DoubleVector : IComparable, IComparable<DoubleVector>, IEquatable<DoubleVector>
    {
        #region Constructor
        /// <summary>
        ///Basic constructor
        /// </summary>
        public DoubleVector()
            : this(1)
        {

        }
        /// <summary>
        ///Constructor with specified length
        /// </summary>
        ///<param name="length">length</param>
        public DoubleVector(int length)
        {
            _length = length;
            Init(_length);
        }
        /// <summary>
        ///Specify the constructor of the data
        /// </summary>
        ///<param name="value">data</param>
        public DoubleVector(double[] value)
        {
            _length = value.Length;
            Init(_length);
            SetData(value);
        }
        #endregion

        #region private variable
        private double[] _data;
        private int _length;
        #endregion

        #region Public attribute
        /// <summary>
        ///Data
        /// </summary>
        public double[] Data
        {
            get { return _data; }
        }
        /// <summary>
        ///Length
        /// </summary>
        public int Length
        {
            get { return _length; }
        }
        #endregion

        #region Public method
        /// <summary>
        ///Initialize
        /// </summary>
        ///<param name="length">specify the length</param>
        public bool Init(int length)
        {
            _length = length;
            if (length < 0)
            {
                return false;
            }
            _data = new double[length];
            return true;
        }
        /// <summary>
        ///Set the value of the array
        /// </summary>
        ///<param name="value">data</param>
        public void SetData(double[] value)
        {
            _data = (double[])value.Clone();
            //value.CopyTo(_data, 0);
        }
        #endregion

        #region IComparable member
        /// <summary>
        ///Compare size
        /// </summary>
        ///<param name="obj">other objects</param>
        public int CompareTo(object obj)
        {
            DoubleVector other = obj as DoubleVector;
            if (other == null)
            {
                return 1;
            }
            return CompareTo(other);
        }
        #endregion

        #region Icomparable<doublearray>member
        /// <summary>
        ///Compare size
        /// </summary>
        ///<param name="other">another instance</param>
        public int CompareTo(DoubleVector other)
        {
            double tmp = 0.0;
            for (int i = 0; i < _length; i++)
            {
                tmp = _data[i] - other.Data[i];
                if (tmp > 0.0)
                {
                    return 1;
                }
                else if (tmp < 0.0)
                {
                    return -1;
                }
            }
            return 0;
        }
        #endregion

        #region Iequatable<doublearray>member
        /// <summary>
        ///Equality judgment
        /// </summary>
        ///<param name="other">another instance</param>
        public bool Equals(DoubleVector other)
        {
            if (_length != other.Length)
            {
                return false;
            }
            double tmp = 0.0;
            for (int i = 0; i < _length; i++)
            {
                tmp = _data[i] - other.Data[i];
                if (tmp != 0.0)
                {
                    return false;
                }
            }
            return true;
        }
        #endregion

        #region Override equals
        /// <summary>
        ///Override equals
        /// </summary>
        ///<param name="obj">other objects</param>
        /// <returns></returns>
        public override bool Equals(object obj)
        {
            DoubleVector other = obj as DoubleVector;
            if (other == null)
            {
                return false;
            }
            return Equals(other);
        }
        #endregion

        #region Rewrite GetHashCode
        /// <summary>
        ///Rewrite GetHashCode
        /// </summary>
        public override int GetHashCode()
        {
            double sum = 0.0;
            for (int i = 0; i < _length; i++)
            {
                sum += (i + 1) * _data[i] * _data[i];
            }
            return (int)Math.Sqrt(sum);
        }
        #endregion

        #region Override toString
        /// <summary>
        ///Override toString
        /// </summary>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < _length; i++)
            {
                sb.AppendFormat("{0},", _data[i]);
            }
            sb.Remove(sb.Length - 1, 1);
            return sb.ToString();
        }
        #endregion
    }
}
