using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.Matlab
{
    /// <summary>
    ///Doublevector numeric comparator
    /// </summary>
    public class DoubleVectorComparer : IComparer<DoubleVector>
    {
        /// <summary>
        ///Initialize sort type
        /// </summary>
        ///<param name="type">sort type</param>
        public DoubleVectorComparer(SortType type)
        {
            _type = type;
        }

        //Default ascending order
        private SortType _type;

        //Icomparer<doublevector>member
        public int Compare(DoubleVector x, DoubleVector y)
        {
            if (_type == SortType.Descend)
            {
                return y.CompareTo(x);
            }
            return x.CompareTo(y);
        }
    }
}
