using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.Matlab
{
    /// <summary>
    ///Regression significance test
    ///Regstats result specific
    /// </summary>
    public class LinearRegression
    {
        /// <summary>
        ///Constructor
        /// </summary>
        public LinearRegression()
        {
            Coefficients = new Coefficients();
        }
        /// <summary>
        ///Regression sum of squares
        /// </summary>
        public double RegressionSumOfSquares { get; set; }
        /// <summary>
        ///Regression variance
        /// </summary>
        public double RegressionVariance { get; set; }
        /// <summary>
        ///Residual sum of square
        /// </summary>
        public double ResidualSumOfSquares { get; set; }
        /// <summary>
        ///Residual variance
        /// </summary>
        public double ResidualVariance { get; set; }
        /// <summary>
        ///Sum of squares of deviations
        /// </summary>
        public double SumOfSquaresOfDeviations { get; set; }
        /// <summary>
        ///Standard error
        /// </summary>
        public double StandardError { get; set; }
        /// <summary>
        ///F verification f
        /// </summary>
        public double VerificationF { get; set; }
        /// <summary>
        ///Correlation coefficient
        /// </summary>
        public double CorrelationCoefficient { get; set; }
        /// <summary>
        ///Regression coefficient
        /// Y = item1 + item2 * X1
        /// </summary>
        public Coefficients Coefficients { get; set; }
    }
    /// <summary>
    ///Regression coefficient, temporarily only univariate linear regression
    /// </summary>
    public class Coefficients
    {
        public double Item1 { get; set; }
        public double Item2 { get; set; }
    }
}
