using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.Matlab
{
    /// <summary>
    ///Float value comparator
    /// </summary>
    public class SingleComparer : IComparer<float>
    {
        /// <summary>
        ///Initialize sort type
        /// </summary>
        ///<param name="type">sort type</param>
        public SingleComparer(SortType type)
        {
            _type = type;
        }

        //Default ascending order
        private SortType _type;

        //Icomparer<float>member
        public int Compare(float x, float y)
        {
            if (_type == SortType.Descend)
            {
                return y.CompareTo(x);
            }
            return x.CompareTo(y);
        }
    }
}
