using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SMAT_CE.Matlab
{
    /// <summary>
    ///Singlevector numeric comparator
    /// </summary>
    public class SingleVectorComparer : IComparer<SingleVector>
    {
        /// <summary>
        ///Initialize sort type
        /// </summary>
        ///<param name="type">sort type</param>
        public SingleVectorComparer(SortType type)
        {
            _type = type;
        }

        //Default ascending order
        private SortType _type;

        //Icomparer<singlevector>member
        public int Compare(SingleVector x, SingleVector y)
        {
            if (_type == SortType.Descend)
            {
                return y.CompareTo(x);
            }
            return x.CompareTo(y);
        }
    }
}
