using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Drawing.Printing;
//using System.Runtime.InteropServices;

namespace SMAT_CE
{
    public partial class ReleaseNotes : FormBase
    {
        public ReleaseNotes()
        {
            InitializeComponent();
            this.printDocumentNotes.BeginPrint += new System.Drawing.Printing.PrintEventHandler(this.printDocumentNotes_BeginPrint);
            this.printDocumentNotes.PrintPage += new System.Drawing.Printing.PrintPageEventHandler(this.printDocumentNotes_PrintPage);
        }

        private int checkPrint;
        //private string _ documentName;//Record the name of the document
        //Record the path of the open document
        private string _filePath;
        private void ReleaseNotes_Load(object sender, EventArgs e)
        {
            try
            {
                rtbPrintCtrlReleaseNotes.LoadFile(Application.StartupPath + @"\Data\SMAT-CE Release Notes.rtf", RichTextBoxStreamType.RichText);
                _filePath = Application.StartupPath + @"\Data\SMAT-CE Release Notes.rtf";
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void printDocumentNotes_BeginPrint(object sender, PrintEventArgs e)
        {
            try
            {
                checkPrint = 0;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void printDocumentNotes_PrintPage(object sender, PrintPageEventArgs e)
        {
            try
            {
                //Print the content of RichTextBox. Store the last character printed.
                checkPrint = rtbPrintCtrlReleaseNotes.Print(checkPrint, rtbPrintCtrlReleaseNotes.TextLength, e);

                // Check for more pages
                if (checkPrint < rtbPrintCtrlReleaseNotes.TextLength)
                    e.HasMorePages = true;
                else
                    e.HasMorePages = false;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsmiExit_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsmiOpen_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openFile = new OpenFileDialog();
                openFile.Title = "Open Release Notes";
                openFile.Filter = "RTF file(*.RTF)|*.RTF";//Set filtering parameters for open files
                openFile.InitialDirectory = System.Windows.Forms.Application.StartupPath + @"\Data\";
                openFile.RestoreDirectory = true;
                if (openFile.ShowDialog() != DialogResult.OK)
                    return;
                this.rtbPrintCtrlReleaseNotes.LoadFile(openFile.FileName, RichTextBoxStreamType.RichText);
                _filePath = openFile.FileName;
                //_documentName = openFile.FileName;
                //Path.GetFileNameWithoutExtension(openFile.FileName);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsmiSaveAs_Click(object sender, EventArgs e)
        {
            try
            {
                SaveFileDialog saveFile = new SaveFileDialog();
                saveFile.Title = "Save Realease Notes...";
                saveFile.InitialDirectory = Application.StartupPath + @"\Data\";
                saveFile.Filter = "RTF files(*.rtf)|*.rtf";
                saveFile.RestoreDirectory = true;
                if (saveFile.ShowDialog() != DialogResult.OK)
                    return;
                rtbPrintCtrlReleaseNotes.SaveFile(saveFile.FileName, RichTextBoxStreamType.RichText);
                MessageBox.Show("Save file successfully! ");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsmiPageSetup_Click(object sender, EventArgs e)
        {
            try
            {
                pageSetupDialog.ShowDialog();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsmiPrintPreview_Click(object sender, EventArgs e)
        {
            try
            {
                printPreviewDialog.StartPosition = FormStartPosition.CenterScreen;
                printPreviewDialog.ShowDialog();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsmiPrint_Click(object sender, EventArgs e)
        {
            try
            {
                if (printDialog.ShowDialog() == DialogResult.OK)
                    printDocumentNotes.Print();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsbtnExit_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsmiExitMain_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void tsmiSave_Click(object sender, EventArgs e)
        {
            try
            {
                rtbPrintCtrlReleaseNotes.SaveFile(_filePath, RichTextBoxStreamType.RichText);
                MessageBox.Show("Save file successfully! ");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
