using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using SMAT_CE.Properties;
using SMAT_CE.Data;
using System.Xml.Linq;
using System.IO;
using DotSpatial.Controls;
using DotSpatial.Symbology;
using System.Threading;
using System.Data.OleDb;
using ZedGraph;
using DotSpatial.Data;
using System.Text.RegularExpressions;
using DotSpatial.Projections;
using DotSpatial.Topology;
using System.Drawing.Imaging;
using System.Xml;
using WinControls;
using Microsoft.Win32;
using System.Runtime.InteropServices;


namespace SMAT_CE
{
    public partial class SMAT_CE : FormBase
    {
        #region Custom attributes
        string[] strmapNameColRow = new string[6];//save the file name, species name, col.min, col.max, row.min, row.max for drawing map with lengend

        public string[] strMapNameColRow
        {
            get { return strmapNameColRow; }
            set { strmapNameColRow = value; }
        }

        DataTable dtchartTemp = null;//draw bar distribution frequency in chart (ssia)
        /// <summary>
        /// 0-bar or 1-distribution or 2-frequency - when click apply - only in ssia
        /// </summary>
        int ichartType = 0;
        private bool plotLine = false;
        private bool changeColor = false;
        private bool ssia_useMonitor = true;//flag - whether use monitor in SSIA
        public bool Ssia_useMonitor
        {
            get { return ssia_useMonitor; }
            set
            {
                if (value != ssia_useMonitor)
                {
                    SSIA_useMonitorChange(value);
                }
                ssia_useMonitor = value;
            }
        }
        //Dictionary<string, string> diclatlongTOLambert = new Dictionary<string, string>();
        Dictionary<string, Dictionary<string, double>> dicValueMAP = new Dictionary<string, Dictionary<string, double>>();
        //Save the DataTable read for the first time to show all later
        private DataTable _dtOutput = new DataTable();
        private int iStateName = -1;//Record the index value of the statename column
        //Save the selected datatable
        private DataTable _dtSelectOutput = new DataTable();
        //Save the file type selected by clicking treelistview
        private string _fileType = "";
        //---------Monitoring frequency of data in the record file-----------
        private string _dataType = "";
   
        //-------Chart displays baseline and forecast value by default.If the user chooses, only one value is selected
        private bool isSelectValue = false;
        /// <summary>
        ///Indicates the icon key that has not been set, and the setting in the parameter file (image name in Imagelist) must be consistent with that here
        /// </summary>
        private const string _unreadyImageKey = "unready";
        /// <summary>
        ///The icon key indicates that there is already a setting, and the setting in the parameter file must be consistent with that here
        /// </summary>
        private const string _readyImageKey = "ready";
        private const string _yibuImageKey = "loading";
        private const string _saveImageKey = "savescenario";
        private const string _errorImageKey = "error";
        private bool isMaxView = false; //Is it the largest view
        private bool isShowLegend = false;//Show legend

        private string _ChartFilter = "";//Used in the chart part to record the value of cbofilter

        //Instantiate a tooltip
        ToolTip tips = new ToolTip();
        //// dataviewer 
        ToolTip tipTreelistview = new ToolTip();

        /// <summary>
        ///Prompt information content
        /// </summary>
        private string _stips = "";

        /// <summary>
        ///Judge next or back
        /// </summary>
        private bool isNext;

        public TreeListViewItem item;
        bool isPolygon = false;
        string smallDomianMAP = "";
        double[] dataDomainGIS = null;
        /// <summary>
        /// 0-grid; 1-combine; 2-dispersion
        /// </summary>
        int ssiaDataOption = 0;//draw in map-- show max or min value at latlong
        /// <summary>
        /// use to distinguish the bar when showing point values 
        /// </summary>
        public List<string> lstReceptors = new List<string>();
        /// <summary>
        ///Configure chart style, add by devin
        /// </summary>
        ConfigureSymbol _configureSymbol = null;
        #endregion

        public SMAT_CE()
        {
            InitializeComponent();
            stcMain.Panel1.BackColor = Color.FromArgb(225, 225, 225);
            stcMain.Panel2.BackColor = Color.FromArgb(241, 241, 241);
            //---------Save the acquired background color-----------
            CommonClass.BackColorPick = new byte[3];
            CommonClass.BackColorPick[0] = stcGIS.Panel1.BackColor.R;
            CommonClass.BackColorPick[1] = stcGIS.Panel1.BackColor.G;
            CommonClass.BackColorPick[2] = stcGIS.Panel1.BackColor.B;
            //------------end-------------------------------------------
            CommonClass.CurrentLogChanged += new CommonClass.CurrentLogChangedStartHandler(SetRunningLog);
            // picClose.Parent = tlvRunning;
        }

        private void SMAT_CE_Load(object sender, EventArgs e)
        {
            initForm();
            //proBarRunning.Maximum = 100;//Set the maximum length value
            //proBarRunning.Value = 0;//set currency
            //proBarRunning.Step = 1;//Set how much to increase every time
            //timer1.Enabled = false ;

            //----------Add Result Filefolder
            if (!Directory.Exists(CommonClass.ResultFilePath + @"\Result\CFG"))
            {
                System.IO.Directory.CreateDirectory(CommonClass.ResultFilePath + @"\Result\CFG");
            }
            if (!Directory.Exists(CommonClass.ResultFilePath + @"\Result\SHP"))
            {
                System.IO.Directory.CreateDirectory(CommonClass.ResultFilePath + @"\Result\SHP");
            }
            if (!Directory.Exists(CommonClass.ResultFilePath + @"\Result\Batchjob"))
            {
                System.IO.Directory.CreateDirectory(CommonClass.ResultFilePath + @"\Result\Batchjob");
            }
            if (!Directory.Exists(CommonClass.ResultFilePath + @"\Result\Picture"))
            {
                System.IO.Directory.CreateDirectory(CommonClass.ResultFilePath + @"\Result\Picture");
            }
            if (!Directory.Exists(CommonClass.ResultFilePath + @"\Result\Output"))
            {
                System.IO.Directory.CreateDirectory(CommonClass.ResultFilePath + @"\Result\Output");
            }
            if (!Directory.Exists(CommonClass.ResultFilePath + @"\Result\Project"))
            {
                System.IO.Directory.CreateDirectory(CommonClass.ResultFilePath + @"\Result\Project");
            }
            if (!Directory.Exists(CommonClass.ResultFilePath + @"\Result\CSV"))
            {
                System.IO.Directory.CreateDirectory(CommonClass.ResultFilePath + @"\Result\CSV");
            }
            if (!Directory.Exists(CommonClass.ResultFilePath + @"\Result\LOG"))
            {
                System.IO.Directory.CreateDirectory(CommonClass.ResultFilePath + @"\Result\LOG");
            }

            colorBlend.CustomizeValueRange -= ResetMapColor;
            colorBlend.CustomizeValueRange += ResetMapColor;
        }

        private void tbcFunction_DrawItem(object sender, DrawItemEventArgs e)
        {
            try
            {
                //SolidBrush bru = new SolidBrush(Color.FromArgb(241, 241, 241));
                ////Draw main control background color
                //e.Graphics.FillRectangle(bru, 0, 0, tbcFunction.Width, tbcFunction.Height);
                Graphics g = e.Graphics;
                Rectangle endPageRect = tbcFunction.GetTabRect(tbcFunction.TabPages.Count - 1); //Range of the last title block
                Rectangle TitleRect = tbcFunction.GetTabRect(e.Index);              //Range of current title block
                Rectangle HeaderBackRect = Rectangle.Empty;
                HeaderBackRect = new Rectangle(new System.Drawing.Point(endPageRect.X + endPageRect.Width, endPageRect.Y),
                      new Size(tbcFunction.Width - endPageRect.X - endPageRect.Width, endPageRect.Height));
                Brush b = new SolidBrush(Color.FromArgb(241, 241, 241));
                g.FillRectangle(b, HeaderBackRect);
                Image img = null;
                Rectangle rct;
                int i = e.Index;

                rct = tbcFunction.GetTabRect(i);
                if (this.tbcFunction.TabPages[i].Text.ToString() == "Map")
                {
                    img = Resources.map_new;
                }
                if (this.tbcFunction.TabPages[i].Text.ToString() == "GIS")
                {
                    img = Resources.Tab_GIS;
                }
                if (this.tbcFunction.TabPages[i].Text.ToString() == "Data")
                {
                    img = Resources.data_new;
                }
                if (this.tbcFunction.TabPages[i].Text.ToString() == "Chart")
                {
                    img = Resources.chart_new;
                }
                if (this.tbcFunction.TabPages[i].Text.ToString() == "Output Navigator")
                {
                    img = Resources.TabOutput1;
                }
                if (this.tbcFunction.TabPages[i].Text.ToString() == "Running")
                {
                    img = Resources.log1;
                }
                if (this.tbcFunction.TabPages[i].Text.ToString() == "Run Log")
                {
                    img = Resources.log1;
                }
                if (this.tbcFunction.TabPages[i].Text.ToString() == "Configuration & Batch")
                {
                    img = Resources.batch;
                }
                e.Graphics.DrawImage(img, rct);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        #region Custom function
        /// <summary>
        ///Automatically add running log
        /// </summary>
        public void SetRunningLog()
        {
            try
            {
                if (CommonClass.CurrentLog != string.Empty)
                {
                    if (tlvRunning.Items.Count == 0)
                    {
                        item = new TreeListViewItem() { Text = CommonClass.CurrentBaseScenario.configuration.configurationName };
                        item.SubItems.Add(CommonClass.CurrentLog);
                        tlvRunning.Items.Add(item);
                    }
                    else
                    {
                        TreeListViewItem itemA = new TreeListViewItem() { };
                        item.Items.Add(itemA);
                        itemA.SubItems.Add(CommonClass.CurrentLog);
                    }
                    tlvRunning.Refresh();
                    tlvRunning.ExpandAll();
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        ///// <summary>
        /////Set according to the passed in parameters
        ///// </summary>
        //public void SetProgressBar()
        //{
        //    try
        //    {
        //        if (CommonClass.CurrentProgressBar != 0)
        //        {

        //            proBarRunning.PerformStep();
        //            proBarRunning.Refresh();
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex); 
        //    }
        //}

        /// <summary>
        ///Initialization interface
        /// </summary>
        public void initForm()
        {
            try
            {
                ssia_useMonitor = true;
                //numericUpDownResult.Value = 4;
                isMaxView = false;
                //-----------timer initialization---------
                timerLoad.Enabled = false;
                timerLoad.Interval = 5000;

                //--------------instantiate a Tooltip，and set properties----------
                tips.InitialDelay = 200;
                tips.AutoPopDelay = 10 * 1000;
                tips.ReshowDelay = 200;
                tips.ShowAlways = true;
                tips.IsBalloon = true;
                tips.BackColor = Color.FromArgb(251, 233, 169);
                tips.SetToolTip(btnUserGuide, Language.Localization.GetValue("Users' Guide"));
                tips.SetToolTip(btnAbout, Language.Localization.GetValue("About"));
                lblProjectName.Text = "";
                lblAnalysis2.Text = "";
                //--------------data view Tips setting------------
                tipTreelistview.InitialDelay = 200;
                tipTreelistview.AutoPopDelay = 10 * 1000;
                tipTreelistview.ReshowDelay = 200;
                tipTreelistview.ShowAlways = true;
                tipTreelistview.IsBalloon = false;
                //tipTreelistview.SetToolTip(tlvDataViewer, Language.Translate("Double-click or right-click to view data & map"));
                //------------hide tabpage--------------
                if (!CommonClass.IsDataViewerState)
                {
                    _dtOutput = null;
                    _dtSelectOutput = null;
                    if (tlvDataViewer.Items.Count > 0)
                    {
                        tlvDataViewer.Items.Clear();
                        colorBlend.SetValueRange(0, 0, true);
                    }
                    if (tlvLogFile.Items.Count > 0)
                        tlvLogFile.Items.Clear();
                    if (dgvDataView.Columns.Count > 0)
                        dgvDataView.Columns.Clear();
                    dgvDataView.Refresh();
                    if (clboQuantifiers.Items.Count > 0)
                        clboQuantifiers.Items.Clear();
                    if (dgvDataList.Columns.Count > 0)
                        dgvDataList.Columns.Clear();
                    dgvDataList.Refresh();
                    if (cboFilter.Items.Count > 0)
                        cboFilter.Items.Clear();
                    if (cboType.Items.Count > 0)
                        cboType.Items.Clear();
                    if (listViewCFG.Items.Count > 0)
                        listViewCFG.Items.Clear();
                    lblProjectName.Text = "";
                    lblAnalysis2.Text = "";
                    labelTips.Visible = false;
                    //if()
                    //Empty ZedGraph
                    GraphPane myPane = this.zgcChart.GraphPane;
                    myPane.CurveList.Clear();
                    myPane.GraphObjList.Clear();
                    myPane.Title.Text = "";
                    myPane.XAxis.Title.Text = "";
                    myPane.YAxis.Title.Text = "";
                    myPane.XAxis.Scale.TextLabels = null;
                    myPane.Chart.Fill = new Fill();

                    lblFileName.Text = "";

                    if (mainMap.Layers.Count > 1)
                    {
                        mainMap.Layers.Clear();
                        setStandardMap();
                    }
                    dgvDataList.DataSource = null;
                    dgvDataView.DataSource = null;
                    cboType.Text = "";
                }
                this.tbcFunction.TabPages.Remove(tbpRunning);
                this.tbcFunction.TabPages.Remove(tbpLog);
                this.tbcFunction.TabPages.Remove(tbpMap);

                this.tbcFunction.TabPages.Remove(tbpGIS);
                this.tbcFunction.TabPages.Remove(tbpData);
                this.tbcFunction.TabPages.Remove(tbpChart);
                this.tbcFunction.TabPages.Remove(tbpConfigurationBatch);
                labelTips.Visible = false;

                CommonClass.speciesMonitorFile = "";
                CommonClass.speciesFractionFilePoint = "";
                CommonClass.speciesFractionFileSpatial = "";
                CommonClass.unofficialPMFile = "";
                CommonClass.officialPMFile = "";
                CommonClass.baseModelFile = "";
                CommonClass.futureModelFile = "";
                CommonClass.dispersionModelFile = "";
                CommonClass.monitorFile = "";
                CommonClass.ozoneMonitorFile = "";
                //CommonClass.improveAlgorithmNew = "";
                //CommonClass.improveAlgorithmOld = "";

                if (CommonClass.OutputNavigator == true)
                {
                    if (!CommonClass.IsDataViewerState)
                    {
                        if (tlvDataViewer.Items.Count == 0)
                        {
                            btnExtractSelected.Enabled = false;
                            btnExtractAll.Enabled = false;
                            btnLinkTo.Enabled = false;
                            rbtnVNA.Enabled = false;
                            rbtnEVNA.Enabled = false;
                            //btnOutputFor.Enabled = false;
                            tlvDataViewer.Items.Add("No data loaded");
                            //tlvDataViewer.ShowItemToolTips = false;
                        }
                        //else
                        {
                            if (CommonClass.CurrentBaseScenario != null && CommonClass.CurrentBaseScenario.configuration != null && (CommonClass.CurrentBaseScenario.configuration is BenMAPAnnualPMAnalysisConfiguration || CommonClass.CurrentBaseScenario.configuration is BenMAPOzoneAnalysisConfiguration))
                            {
                                rbtnVNA.Enabled = true;
                                rbtnEVNA.Enabled = true;
                                btnLinkTo.Enabled = true;
                            }
                            else
                            {
                                rbtnVNA.Enabled = false;
                                rbtnEVNA.Enabled = false;
                                btnLinkTo.Enabled = false;
                            }
                        }
                        //-----added & modified by Edwin 20131231-----
                        if (!LanguageOld.IsSMATChina)
                        {
                            tsmiContinentalUS.Visible = true;
                            tsmiMaryland.Visible = true;
                            tsmiNewEngland.Visible = true;
                            tsmiSouthernCalifornia.Visible = true;
                            tsmiTexas.Visible = true;
                            tsmiWashingtonDC.Visible = true;
                            tsmiChina.Visible = false;
                            tsmiYRD.Visible = false;
                            tsmiPRD.Visible = false;
                            tsmiJJJ.Visible = false;
                        }
                        else
                        {
                            tsmiContinentalUS.Visible = false;
                            tsmiMaryland.Visible = false;
                            tsmiNewEngland.Visible = false;
                            tsmiSouthernCalifornia.Visible = false;
                            tsmiTexas.Visible = false;
                            tsmiWashingtonDC.Visible = false;
                            tsmiChina.Visible = true;
                            tsmiYRD.Visible = true;
                            tsmiPRD.Visible = true;
                            tsmiJJJ.Visible = true;
                        }
                        if (cboStandardLayers.Items.Count == 0)
                        {
                            cboStandardLayers.Items.Add("US States");
                            cboStandardLayers.Items.Add("US Counties");
                            cboStandardLayers.Items.Add("Class I Area");
                            cboStandardLayers.Items.Add("Class I Area and States");
                            cboStandardLayers.Items.Add("Continental US");
                        }
                        if (cboZoomTo.Items.Count == 0)
                        {
                            cboZoomTo.Items.Add("Continental US");
                            cboZoomTo.Items.Add("Maryland");
                            cboZoomTo.Items.Add("New England");
                            cboZoomTo.Items.Add("Southern California");
                            cboZoomTo.Items.Add("Texas");
                            cboZoomTo.Items.Add("Washington DC");
                        }
                        if (LanguageOld.IsSMATChina && cboStandardLayers.Items[0].ToString() == "US States")
                        {
                            cboStandardLayers.Items.Clear();
                            cboStandardLayers.Items.Add("China");
                            cboZoomTo.Items.Clear();
                            cboZoomTo.Items.Add("China");
                            cboZoomTo.Items.Add("YRD");
                            cboZoomTo.Items.Add("PRD");
                            cboZoomTo.Items.Add("JJJ");
                        }
                        else if (!LanguageOld.IsSMATChina && cboStandardLayers.Items[0].ToString() == "China")
                        {
                            cboStandardLayers.Items.Clear();
                            cboStandardLayers.Items.Add("US States");
                            cboStandardLayers.Items.Add("US Counties");
                            cboStandardLayers.Items.Add("Class I Area");
                            cboStandardLayers.Items.Add("Class I Area and States");
                            cboStandardLayers.Items.Add("Continental US");
                            cboZoomTo.Items.Clear();
                            cboZoomTo.Items.Add("Continental US");
                            cboZoomTo.Items.Add("Maryland");
                            cboZoomTo.Items.Add("New England");
                            cboZoomTo.Items.Add("Southern California");
                            cboZoomTo.Items.Add("Texas");
                            cboZoomTo.Items.Add("Washington DC");

                        }
                        cboZoomTo.SelectedIndex = 0;
                        cboStandardLayers.SelectedIndex = 0;
                        lblProjectName.Text = "";
                        lblAnalysis2.Text = "";
                    }
                    if (dgvDataList.Columns.Count == 0)
                    {
                        //btnApply.Enabled = false;
                    }
                    if (dgvDataView.Columns.Count == 0)
                    {
                        btnShowAll.Enabled = false;
                        btnExport.Enabled = false;
                        btnApplyData.Enabled = false;
                        numericUpDownResult.Enabled = false;
                        txtDistance.Enabled = false;
                        txtThreshold.Enabled = false;
                        //btnApply.Enabled = false;
                    }

                    if (listViewCFG.Items.Count == 0)
                    {
                        btnClose.Enabled = false;
                        btnEdit.Enabled = false;
                        btnExportCFG.Enabled = false;
                        picCloseCFG.Visible = false;
                    }
                    if (tlvLogFile.Items.Count == 0)
                        picCloseLog.Visible = false;

                    pnlDataViewer.Visible = true;
                    lblProjectName.Visible = true;
                    lblAnalysis2.Visible = true;

                    //if (CommonClass.IsDataViewerState)
                    if (tlvDataViewer.Items.Count <= 1)
                        labelTips.Visible = false;
                    else
                        labelTips.Visible = true;
                    stcMain.Width = 974;
                    stcMain.Refresh();
                    stcMain.Panel1MinSize = 338;
                    stcMain.SplitterDistance = 338;
                    stcMain.FixedPanel = FixedPanel.Panel1;
                    scrRight.Panel1MinSize = 104;
                    scrRight.Refresh();
                    scrRight.SplitterDistance = 104;
                    scrRight.FixedPanel = FixedPanel.Panel1;
                    //mainMap.BackColor = Color.FromArgb(214, 231, 255);
                    this.tbcFunction.TabPages.Add(tbpGIS);
                    this.tbcFunction.TabPages.Add(tbpMap);
                    this.tbcFunction.TabPages.Add(tbpData);
                    this.tbcFunction.TabPages.Add(tbpChart);
                    this.tbcFunction.TabPages.Add(tbpLog);
                    this.tbcFunction.TabPages.Add(tbpConfigurationBatch);
                    if (CommonClass.IsFirstLoadProject == true)
                    {
                        this.tbcFunction.SelectedTab = tbpLog;
                    }
                    else
                    {
                        this.tbcFunction.SelectedTab = tbpGIS;
                    }
                    //if (this.tbcFunction.SelectedTab.Text != "Map" && this.tbcFunction.SelectedTab.Text != "Data" && this.tbcFunction.SelectedTab.Text != "Chart")
                    //    this.tbcFunction.SelectedTab = tbpMap;
                    lblAnalysis.Text = Language.Localization.GetValue("Data Viewer");
                    pboPollutant.Image = Resources.OutputNavigator;

                    lblSteps.Visible = false;
                    pboHelp.Visible = false;
                    pboOpenCFG.Visible = false;
                    pboCreateCFG.Visible = false;
                    btnSave.Visible = false;
                    btnSaveRun.Visible = false;
                    btnClear.Visible = false;
                    btnNext.Visible = false;
                    btnBack.Visible = false;
                    lblBack.Visible = false;
                    lblNext.Visible = false;
                    trvAnalysis.Visible = false;
                    pnlUserControl.Visible = false;
                    //lblProjectName.Text = CommonClass.CurrentBaseScenario.configuration.configurationName;
                    //-----------The default is to show the legend------------
                    this.stcGIS.Panel1MinSize = 185;
                    this.stcGIS.SplitterDistance = 185;
                    this.stcGIS.SplitterWidth = 1;
                    this.stcGIS.FixedPanel = FixedPanel.Panel1;
                    this.stcGIS.BorderStyle = BorderStyle.FixedSingle;
                    this.stcMap.Panel1MinSize = 185;
                    this.stcMap.SplitterDistance = 185;
                    this.stcMap.SplitterWidth = 1;
                    this.stcMap.FixedPanel = FixedPanel.Panel1;
                    this.stcMap.BorderStyle = BorderStyle.FixedSingle;
                    //this.stcMap.Panel1MinSize = 24;
                    //this.stcMap.FixedPanel = FixedPanel.Panel1;
                    //this.stcMap.SplitterDistance = 0;
                    //this.stcMap.BorderStyle = BorderStyle.None;
                    if (CommonClass.LoadProjectFromStartPageOrAnalysisPage)
                    {
                        LoadProject(CommonClass.FileName);
                        CommonClass.LoadProjectFromStartPageOrAnalysisPage = false;
                    }
                }
                else
                {
                    lblProjectName.Visible = false;
                    lblAnalysis2.Visible = false;
                    labelTips.Visible = false;
                    pnlDataViewer.Visible = false;
                    pboOpenCFG.Visible = true;
                    pboCreateCFG.Visible = true;
                    btnSave.Visible = true;
                    btnSaveRun.Visible = true;
                    btnClear.Visible = true;
                    btnNext.Visible = true;
                    btnBack.Visible = true;
                    lblBack.Visible = true;
                    lblNext.Visible = true;
                    trvAnalysis.Visible = true;
                    pnlUserControl.Visible = true;
                    lblSteps.Visible = true;
                    pboHelp.Visible = true;
                    stcMain.Panel1MinSize = 491;
                    stcMain.SplitterDistance = 491;
                    stcMain.FixedPanel = FixedPanel.Panel1;
                    scrRight.Panel1MinSize = 104;
                    scrRight.SplitterDistance = 104;
                    scrRight.FixedPanel = FixedPanel.Panel1;
                    //-----------Clear panel before loading the user control---------
                    pnlUserControl.Controls.Clear();

                    //------------Clear treeview before loading-----------
                    if (trvAnalysis.Nodes.Count > 0)
                    {
                        this.trvAnalysis.Nodes.Clear();
                    }

                    this.tbcFunction.TabPages.Add(tbpRunning);
                    //this.tbcFunction.TabPages.Add(tbpConfigurationBatch);
                    if (this.tlvRunning.Items.Count > 0)
                        tlvRunning.Items.Clear();
                    tbcFunction.Refresh();

                    //--------------set up for buttons-------------
                    btnSave.Enabled = false;
                    btnNext.Enabled = true;
                    btnNext.Image = Resources.Next1;
                    btnBack.Enabled = false;
                    btnBack.Image = Resources.Back_gray;
                    btnSaveRun.Enabled = false;

                    tips.SetToolTip(pboCreateCFG, Language.Localization.GetValue("Create a new project"));
                    tips.SetToolTip(pboOpenCFG, Language.Localization.GetValue("Open an existing project"));

                    lblSteps.Text = "Choose Desired Output";
                    string path = null;
                    if (CommonClass.OpenScenario == true)
                    {
                        //if (!CommonClass.IsDataViewer)
                        //{
                        //-----------identify current analysis------------
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.AnnualPM;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.DailyPM;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.Ozone;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.Visibility;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.SSIAAnnualPM;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.SSIADailyPM;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.SSIAOzone;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.SSIADeposition;
                        }  //added by K.B.
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.AnnualPMChina;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.OzoneChina;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.BenMAPAnnualPM;
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration))
                        {
                            CommonClass.CurrentAnalysis = enumAnalysis.BenMAPSeasonalOzone;
                        }
                        #region//-------------different analysis has different image,name and tree nodes-------------
                        switch (CommonClass.CurrentAnalysis)
                        {
                            case enumAnalysis.AnnualPM:
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("Annual PM Analysis");
                                path = Application.StartupPath + @"\Configs\Annual PM Analysis.xml";
                                break;
                            case enumAnalysis.DailyPM:
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("Daily PM Analysis");
                                path = Application.StartupPath + @"\Configs\Daily PM Analysis.xml";
                                break;
                            case enumAnalysis.Ozone:
                                lblAnalysis.Text = Language.Localization.GetValue("Ozone Analysis");
                                path = Application.StartupPath + @"\Configs\Ozone Analysis.xml";
                                pboPollutant.Image = Resources.O3;
                                break;
                            case enumAnalysis.Visibility:
                                lblAnalysis.Text = Language.Localization.GetValue("Visibility Analysis");
                                path = Application.StartupPath + @"\Configs\Visibility Analysis.xml";
                                pboPollutant.Image = Resources.Haze;
                                break;
                            case enumAnalysis.SSIAAnnualPM:
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("SSIA - Annual PM Analysis");
                                path = Application.StartupPath + @"\Configs\SSIA PM Analysis.xml";
                                break;
                            case enumAnalysis.SSIADailyPM:
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("SSIA - Daily PM Analysis");
                                path = Application.StartupPath + @"\Configs\SSIA PM Analysis.xml";
                                break;
                            case enumAnalysis.SSIAOzone:
                                pboPollutant.Image = Resources.O3;
                                lblAnalysis.Text = Language.Localization.GetValue("SSIA - Ozone Analysis");
                                path = Application.StartupPath + @"\Configs\SSIA Ozone Analysis.xml";
                                break;
                            case enumAnalysis.SSIADeposition:                                         //added by K.B.                  
                                pboPollutant.Image = Resources.Deposition;
                                lblAnalysis.Text = Language.Localization.GetValue("SSIA - Deposition Analysis");
                                path = Application.StartupPath + @"\Configs\SSIA Deposition Analysis.xml";
                                break;
                            case enumAnalysis.AnnualPMChina:
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("Annual PM Analysis");
                                path = Application.StartupPath + @"\Configs\Annual PM Analysis China.xml";
                                break;
                            case enumAnalysis.OzoneChina:
                                pboPollutant.Image = Resources.O3;
                                lblAnalysis.Text = Language.Localization.GetValue("Ozone Analysis");
                                path = Application.StartupPath + @"\Configs\Ozone Analysis China.xml";
                                break;
                            case enumAnalysis.BenMAPAnnualPM:
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("BenMAP - Annual PM Analysis");
                                path = Application.StartupPath + @"\Configs\BenMAP_Annual PM.xml";
                                break;
                            case enumAnalysis.BenMAPSeasonalOzone:
                                pboPollutant.Image = Resources.O3;
                                lblAnalysis.Text = Language.Localization.GetValue("BenMAP - Ozone Analysis");
                                path = Application.StartupPath + @"\Configs\BenMAP_Ozone.xml";
                                break;
                        }
                        loadTreeNodes(trvAnalysis.Nodes, path);
                        #endregion
                        string errorTip = "";
                        #region annual pm
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                                || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA != null
                                || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                                && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA != null
                                && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkAnnualPMUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null)
                            {
                                pnlUserControl.Controls.Add(new uc_OutputA());
                                uc_OutputA _outPutA = (pnlUserControl.Controls[0] as uc_OutputA);
                                _outPutA.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.scenarioName;
                                _outPutA.choStandardAnalysisA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doStandardAnalysis;
                                _outPutA.choQuarterlyModelDataA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doQuarterlyModelData;
                                _outPutA.choQuarterlyModelDataUsedA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doUsedQuarterlyAvgModelData;
                                _outPutA.choSpeciesFractionOutputA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doSpeciesFraction;
                                _outPutA.choActionsCompletionA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doAutomaticallyExtract;
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkUCOutputAdvancedA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkUCDataInputA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[3]);
                            }
                            //if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionAdvancedA != null)
                            //{
                            //    ChangeNodeImage(trvAnalysis.Nodes[4]);
                            //}
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[4]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[5]);
                            }
                        }
                        #endregion
                        #region daily
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null
                                || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD != null
                                || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null
                                 && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD != null
                                 && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkDailyPMUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null)
                            {
                                pnlUserControl.Controls.Add(new uc_OutputD());
                                uc_OutputD _outPutD = (pnlUserControl.Controls[0] as uc_OutputD);
                                _outPutD.txtScenarioNameDily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.scenarioName;
                                _outPutD.choStandardAnalysisD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doStandardAnalysis;
                                _outPutD.choQuarterlyPeakModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doQuarterlyPeakModelData;
                                _outPutD.choSpeciesFractionsFileD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doSpeciesFraction;
                                _outPutD.choActionsExtractAllD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doAutomaticallyExtract;
                                errorTip = "";
                                errorTip = CommonClass.checkUCOutputD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkUCOutputAdvancedD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkUCDataInputD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[3]);
                            }
                            //if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionAdvancedD != null)
                            //{
                            //    ChangeNodeImage(trvAnalysis.Nodes[4]);
                            //}
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[4]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[5]);
                            }
                        }
                        #endregion
                        #region Ozone added by devin
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null
                        || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null
                                 && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkOzoneUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                            {
                                btnSaveRun.Enabled = false;
                            }

                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO != null)
                            {
                                pnlUserControl.Controls.Add(new uc_DesiredOutputOzone());
                                uc_DesiredOutputOzone _desiredOutputOzone = (pnlUserControl.Controls[0] as uc_DesiredOutputOzone);
                                _desiredOutputOzone.txtScenarioOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.scenarioName;
                                _desiredOutputOzone.choPointForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doPointEstimatesForecast;
                                _desiredOutputOzone.choQuarterlyModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doQuarterlyModelData;
                                _desiredOutputOzone.choSpatialOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates;
                                _desiredOutputOzone.choSpatialGradAdjOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj;
                                _desiredOutputOzone.chkDS.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doDownscaler;

                                _desiredOutputOzone.chkDSOnlyBase.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSBaseOnly;
                                _desiredOutputOzone.chkDSOnlyFuture.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSFutureOnly;

                                _desiredOutputOzone.txtDSBurn.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSBurn.ToString();
                                _desiredOutputOzone.txtDSCmaqres.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSCmaqres.ToString();
                                _desiredOutputOzone.txtDSNumit.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSNumit.ToString();
                                _desiredOutputOzone.txtDSThin.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSThin.ToString();



                                _desiredOutputOzone.choBaseOnlyVNAOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyVNA;
                                _desiredOutputOzone.choFutureOnlyVNAOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA;
                                _desiredOutputOzone.choBaseOnlyEvnaOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyEVNA;
                                _desiredOutputOzone.choFutureOnlyEvnaOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA;
                                //_desiredOutputOzone.choSpatialForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesForecast;
                                //_desiredOutputOzone.choSpatialGradAdjForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesForecastGradAdj;
                                _desiredOutputOzone.choNeighborFileSpatial.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doNeighborFileSpatial;
                                _desiredOutputOzone.choExtractAllOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doAutomaticallyExtract;
                                _desiredOutputOzone.choDVPeriods.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doDesignValuePeriods;
                                _desiredOutputOzone.choMaxDVPeriods.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doMaxDesignValuePeriods;
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkOzoneUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[2]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[3]);
                            }
                        }
                        #endregion
                        #region Visibility added by devin
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV != null || (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV != null
                              || (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV != null && (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV != null
                               && (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkVisibilityUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                            {
                                btnSaveRun.Enabled = false;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV != null)
                            {
                                pnlUserControl.Controls.Add(new uc_ChooseDesiredOutputV());
                                uc_ChooseDesiredOutputV _chooseDesiredOutputV = (pnlUserControl.Controls[0] as uc_ChooseDesiredOutputV);
                                _chooseDesiredOutputV.txtScenarioNameVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.scenarioName;
                                _chooseDesiredOutputV.choVisibilityLevels.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.doTemporallyAdjVisibilityLevelsForecast;
                                _chooseDesiredOutputV.rbtnOldIMPROVEAlgorithmVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm;
                                _chooseDesiredOutputV.rbtnNewIMPROVEAlgorithmVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseNewVersionforIMPROVEAlgorithm;
                                _chooseDesiredOutputV.rbtnModelGridCellatMonitorVisi.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseModelGridCellAtMonitor;
                                _chooseDesiredOutputV.rbtnModelGridCellatClass1Visi.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseModelGridCellatClassIAreaCentroid;
                                _chooseDesiredOutputV.choExtractAllVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.doAutomaticallyExtract;
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkVisibilityUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[2]);
                            }
                        }

                        #endregion
                        #region annual pm SSIA
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA != null && (((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAAnnualPMUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null)
                            {
                                pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                                uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData;
                                _analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly;
                                _analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion;
                                _analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly;
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCModelInputA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCMonitorInputA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCCalculationOption(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        #endregion
                        #region daily pm SSIA added by Edwin
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD != null && (((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIADailyPMUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null)
                            {
                                pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                                uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData;
                                _analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly;
                                _analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion;
                                _analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly;
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAModelInputD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAMonitorInputD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCCalculationOption(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        #endregion
                        #region ozone SSIA
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO != null && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO != null && (((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAOzoneUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO != null)
                            {
                                pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                                uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData;
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCModelInputO(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCMonitorInputO(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCCalculationOption(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        #endregion
                        #region deposition SSIA added by K.B.
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep != null || (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep != null || (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep != null && (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep != null && (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIADepositionUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep != null)
                            {
                                pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                                uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelData;
                                //_analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelFRMData;
                                //_analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useDispersionOnly;
                                //_analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useGridAndDispersion;
                                //_analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useGridOnly;
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCModelInputDep(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            //if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).monitorInputDep != null)
                            //{
                            //    errorTip = "";
                            //    errorTip = CommonClass.checkSSIAUCMonitorInputA(CommonClass.CurrentBaseScenario);
                            //    if (errorTip != null && errorTip.Length > 0)
                            //    {
                            //        errorNode(trvAnalysis.Nodes[2]);
                            //    }
                            //    else
                            //    {
                            //        ChangeNodeImage(trvAnalysis.Nodes[2]);
                            //    }
                            //}
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkSSIAUCCalculationOption(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        #endregion
                        #region Annual PM China added by Edwin
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkAnnualPMChina(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina != null)
                            {
                                pnlUserControl.Controls.Add(new uc_ModelDataChina());
                                uc_ModelDataChina modeldatachina = (pnlUserControl.Controls[0] as uc_ModelDataChina);
                                modeldatachina.InitializeControl();
                                //modeldatachina.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.scenarioName;
                                //modeldatachina.rbtnCMAQChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doInputFromCMAQ;
                                //modeldatachina.rbtnDailyAvertageDatalChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doDailyAverageDataInput;
                                //modeldatachina.rbtnQuarterlyAverageDataChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doQuarterlyAverageDataInput;
                                //CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.BaselineModelDataFile;
                                //modeldatachina.txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                                //CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.ControlModelDataFile;
                                //modeldatachina.txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[1]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[2]);
                            }
                        }
                        #endregion
                        #region Ozone China added by Edwin
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina != null)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkOzoneChina(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina != null)
                            {
                                pnlUserControl.Controls.Add(new uc_ModelDataOzoneChina());
                                uc_ModelDataOzoneChina modeldataozonechina = (pnlUserControl.Controls[0] as uc_ModelDataOzoneChina);
                                modeldataozonechina.InitializeControl();
                                //modeldataozonechina.cboCMAQOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.doInputfromCmaq;
                                //modeldataozonechina.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.scenarioName;
                                //modeldataozonechina.txtBaselineOzone.Text = Path.GetFileName((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile);
                                //modeldataozonechina.txtForecastOzone.Text = Path.GetFileName((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile);
                                //CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile;
                                //CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile;

                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina != null)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[1]);
                            }
                        }
                        #endregion
                        #region BenMAP Annual PM
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput != null
                                || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile.Length > 0)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput != null
                                && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile.Length > 0)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkBenMAPAnnualPMUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput != null)
                            {
                                pnlUserControl.Controls.Add(new uc_BenMAP_AnnualPM_ModelData());
                                uc_BenMAP_AnnualPM_ModelData _model = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_ModelData);
                                _model.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.scenarioName;
                                _model.rbtnDailyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doDailyModelData;
                                _model.rbtnQuarterlyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doQuarterlyModelData;
                                _model.rbtnCMAQA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doInputfromCMAQ;
                                CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.baselineFile;
                                _model.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.forecastFile;
                                _model.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                _model.cboSpatialGridA.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.temporalAdjustmentAtMonitorGridSpatial;
                                errorTip = "";
                                errorTip = CommonClass.checkUCBenMAPPMModelData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkUCBenMAPPMMonitorData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkUCBenMAPPMSpeciesData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile.Length > 0)
                            {
                                if (!File.Exists((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile))
                                {
                                    errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        #endregion
                        #region BenMap Ozone
                        if (CommonClass.CurrentBaseScenario.configuration == (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration))
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput != null
                                || (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile.Length > 0)
                            {
                                btnSave.Enabled = true;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput != null
                                && (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile.Length > 0)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkBenMAPOzoneUC(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    btnSaveRun.Enabled = false;
                                }
                                else
                                {
                                    btnSaveRun.Enabled = true;
                                }
                            }
                            else
                                btnSaveRun.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput != null)
                            {
                                pnlUserControl.Controls.Add(new uc_BenMap_Ozone_ModelData());
                                uc_BenMap_Ozone_ModelData _model = (pnlUserControl.Controls[0] as uc_BenMap_Ozone_ModelData);
                                _model.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.scenarioName;
                                _model.choCMAQOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.doInputfromCmaq;
                                CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.baselineModelDataFile;
                                _model.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                                CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.forecastModelDataFile;
                                _model.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                                errorTip = "";
                                errorTip = CommonClass.checkBenMAPOzoneModelData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput != null)
                            {
                                errorTip = "";
                                errorTip = CommonClass.checkBenMAPOzoneMonitorlData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }

                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile.Length > 0)
                            {
                                if (!File.Exists((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile))
                                {
                                    errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        #endregion
                        //}
                    }
                    else
                    {
                        #region Create a new scenario
                        CommonClass.CurrentBaseScenario = new BaseScenario();
                        switch (CommonClass.CurrentAnalysis)
                        {
                            case enumAnalysis.AnnualPM:
                                CommonClass.CurrentBaseScenario.configuration = new AnnualPMAnalysisConfiguration();
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA = new ChooseDesiredOutputA();
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("Annual PM Analysis");
                                path = Application.StartupPath + @"\Configs\Annual PM Analysis.xml";
                                pnlUserControl.Controls.Add(new uc_OutputA());
                                uc_OutputA _outPutA = (pnlUserControl.Controls[0] as uc_OutputA);
                                _outPutA.choStandardAnalysisA.Checked = true;
                                _outPutA.choQuarterlyModelDataA.Checked = true;
                                _outPutA.choQuarterlyModelDataUsedA.Checked = true;
                                _outPutA.choSpeciesFractionOutputA.Checked = true;
                                _outPutA.choActionsCompletionA.Checked = true;
                                break;
                            case enumAnalysis.DailyPM:
                                CommonClass.CurrentBaseScenario.configuration = new DailyPMAnalysisConfiguration();
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD = new ChooseDesiredOutputD();
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("Daily PM Analysis");
                                path = Application.StartupPath + @"\Configs\Daily PM Analysis.xml";
                                pnlUserControl.Controls.Add(new uc_OutputD());
                                uc_OutputD _outputD = (pnlUserControl.Controls[0] as uc_OutputD);
                                _outputD.choStandardAnalysisD.Checked = true;
                                _outputD.choQuarterlyPeakModelDataD.Checked = true;
                                _outputD.choSpeciesFractionsFileD.Checked = true;
                                _outputD.choActionsExtractAllD.Checked = true;
                                break;
                            case enumAnalysis.Ozone:
                                CommonClass.CurrentBaseScenario.configuration = new OzoneAnalysisConfiguration();
                                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO = new ChooseDesiredOutputO();
                                pboPollutant.Image = Resources.O3;
                                lblAnalysis.Text = Language.Localization.GetValue("Ozone Analysis");
                                path = Application.StartupPath + @"\Configs\Ozone Analysis.xml";
                                pnlUserControl.Controls.Add(new uc_DesiredOutputOzone());
                                uc_DesiredOutputOzone _outputO = (pnlUserControl.Controls[0] as uc_DesiredOutputOzone);
                                _outputO.choPointForecastOzone.Checked = true;
                                _outputO.choExtractAllOzone.Checked = true;
                                _outputO.choQuarterlyModelData.Checked = true;
                                break;
                            case enumAnalysis.Visibility:
                                CommonClass.CurrentBaseScenario.configuration = new VisibilityAnalysisConfiguration();
                                (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV = new ChooseDesiredOutputV();
                                pboPollutant.Image = Resources.Haze;
                                lblAnalysis.Text = Language.Localization.GetValue("Visibility Analysis");
                                path = Application.StartupPath + @"\Configs\Visibility Analysis.xml";
                                pnlUserControl.Controls.Add(new uc_ChooseDesiredOutputV());
                                uc_ChooseDesiredOutputV _outputV = (pnlUserControl.Controls[0] as uc_ChooseDesiredOutputV);
                                _outputV.choVisibilityLevels.Checked = true;
                                _outputV.rbtnNewIMPROVEAlgorithmVisibility.Checked = true;
                                _outputV.rbtnModelGridCellatMonitorVisi.Checked = true;
                                _outputV.choExtractAllVisibility.Checked = true;
                                break;
                            case enumAnalysis.SSIAAnnualPM:
                                CommonClass.CurrentBaseScenario.configuration = new SSIAAnnualPMAnalysisConfiguration();
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("SSIA - Annual PM Analysis");
                                path = Application.StartupPath + @"\Configs\SSIA PM Analysis.xml";
                                pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                                uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                                break;
                            case enumAnalysis.SSIADailyPM:
                                CommonClass.CurrentBaseScenario.configuration = new SSIADailyPMAnalysisConfiguration();
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("SSIA - Daily PM Analysis");
                                path = Application.StartupPath + @"\Configs\SSIA PM Analysis.xml";
                                pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                                _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                                break;
                            case enumAnalysis.SSIAOzone:
                                CommonClass.CurrentBaseScenario.configuration = new SSIAOzoneAnalysisConfiguration();
                                pboPollutant.Image = Resources.O3;
                                lblAnalysis.Text = Language.Localization.GetValue("SSIA - Ozone Analysis");
                                path = Application.StartupPath + @"\Configs\SSIA Ozone Analysis.xml";
                                pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                                _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                                break;
                            case enumAnalysis.SSIADeposition:                                                         //added by K.B.
                                CommonClass.CurrentBaseScenario.configuration = new SSIADepositionConfiguration();
                                pboPollutant.Image = Resources.Deposition;
                                lblAnalysis.Text = Language.Localization.GetValue("SSIA - Deposition Analysis");
                                path = Application.StartupPath + @"\Configs\SSIA Deposition Analysis.xml";
                                pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                                _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                                _analysisOption.choUseModelFRMData.Checked = false;
                                break;
                            case enumAnalysis.AnnualPMChina:
                                CommonClass.CurrentBaseScenario.configuration = new AnnualPMAnalysisChinaConfiguration();
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("Annual PM Analysis");
                                path = Application.StartupPath + @"\Configs\Annual PM Analysis China.xml";
                                pnlUserControl.Controls.Add(new uc_ModelDataChina());
                                uc_ModelDataChina modelDataChina = (pnlUserControl.Controls[0] as uc_ModelDataChina);
                                modelDataChina.InitializeControl();
                                //modelDataChina.rbtnQuarterlyAverageDataChina.Checked = true;
                                //CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\XiAn_Model_Base_Quarterly.csv";
                                //modelDataChina.txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                                //CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\XiAn_Model_L_R_0.5_0.5_Quarterly.csv";
                                //modelDataChina.txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
                                break;
                            case enumAnalysis.OzoneChina:
                                CommonClass.CurrentBaseScenario.configuration = new OzoneAnalysisChinaConfiguration();
                                pboPollutant.Image = Resources.O3;
                                lblAnalysis.Text = Language.Localization.GetValue("Ozone Analysis");
                                path = Application.StartupPath + @"\Configs\Ozone Analysis China.xml";
                                pnlUserControl.Controls.Add(new uc_ModelDataOzoneChina());
                                uc_ModelDataOzoneChina modelDataOzoneChina = (pnlUserControl.Controls[0] as uc_ModelDataOzoneChina);
                                modelDataOzoneChina.InitializeControl();
                                //CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\Model_O3_Seasonal_2013_YRD.csv";
                                //modelDataOzoneChina.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                                //CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\Model_O3_Seasonal_2017_YRD.csv";
                                //modelDataOzoneChina.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                                break;
                            case enumAnalysis.BenMAPAnnualPM:
                                CommonClass.CurrentBaseScenario.configuration = new BenMAPAnnualPMAnalysisConfiguration();
                                pboPollutant.Image = Resources.PM;
                                lblAnalysis.Text = Language.Localization.GetValue("BenMAP - Annual PM Analysis");
                                path = Application.StartupPath + @"\Configs\BenMAP_Annual PM.xml";
                                pnlUserControl.Controls.Add(new uc_BenMAP_AnnualPM_ModelData());
                                uc_BenMAP_AnnualPM_ModelData model = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_ModelData);
                                model.rbtnDailyModelA.Checked = true;
                                CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["baselineModelDataFile"];//  Application.StartupPath + @"\Data\SampleData\Model_data\SMAT.PM.Large.12.SE_US2.2011eh.camx.grid.csv";//PM_small_USA_12km_2011.csv";
                                model.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["forecastModelDataFile"];//  Application.StartupPath + @"\Data\SampleData\Model_data\SMAT.PM.Large.12.SE_US2.2017eh.camx.grid.csv";//PM_small_USA_12km_2018.csv";
                                model.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                model.cboSpatialGridA.SelectedIndex = 0;
                                break;
                            case enumAnalysis.BenMAPSeasonalOzone:
                                CommonClass.CurrentBaseScenario.configuration = new BenMAPOzoneAnalysisConfiguration();
                                pboPollutant.Image = Resources.O3;
                                lblAnalysis.Text = Language.Localization.GetValue("BenMAP - Ozone Analysis");
                                path = Application.StartupPath + @"\Configs\BenMAP_Ozone.xml";
                                pnlUserControl.Controls.Add(new uc_BenMap_Ozone_ModelData());
                                uc_BenMap_Ozone_ModelData benMapOzoneModel = (pnlUserControl.Controls[0] as uc_BenMap_Ozone_ModelData);
                                CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["Ozone"]["baselineModelDataFile"];// Application.StartupPath + @"\Data\SampleData\Model_data\O3_small_USA_12km_2011.csv";
                                CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["Ozone"]["forecastModelDataFile"];//  Application.StartupPath + @"\Data\SampleData\Model_data\O3_small_USA_12km_2018.csv";
                                benMapOzoneModel.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                                benMapOzoneModel.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                                break;
                            default:
                                break;
                        }
                        loadTreeNodes(trvAnalysis.Nodes, path);
                        // -------------initialize picture of all tree nodes------------
                        foreach (TreeNode tr in trvAnalysis.Nodes)
                        {
                            InitNodeImage(tr);
                            //ChangeNodeImage(tr);
                        }
                        //if (CommonClass.CurrentAnalysis==enumAnalysis.SSIADeposition)     //added by K.B.
                        //{
                        //    Ssia_useMonitor = false;                            
                        //}
                        #endregion
                    }
                    //_stips = "Choose Desired Output";
                    if (trvAnalysis.Nodes.Count > 0)
                        _stips = trvAnalysis.Nodes[0].Text;
                    else
                        _stips = "";
                    //if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM || CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM || CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                    //{
                    //    _stips = "Single Source Impact Analysis Option";
                    //}
                    //if (CommonClass.CurrentAnalysis == enumAnalysis.AnnualPMChina || CommonClass.CurrentAnalysis == enumAnalysis.OzoneChina)
                    //{
                    //    _stips = "Model Data Input";
                    //}
                    lblSteps.Text = Language.Localization.GetValue(_stips).Replace("&", "&&");
                    tips.SetToolTip(pboHelp, Language.Localization.GetValue(_stips));
                }
                //_stips = "Choose desired output";
                //tips.SetToolTip(pboHelp, _stips);

                #region Language added by Edwin
                if (LanguageOld.CurrentLanguage() == "Ch")
                {
                    //Language.GetLanguagePath();
                    Dictionary<string, string> langdic = new Dictionary<string, string>();
                    LanguageOld.SetDicFromXml(this, langdic);
                    LanguageOld.ChangeLanguage(langdic, this);
                }
                #endregion

                #region clean map
                if (!CommonClass.IsDataViewerState)
                {
                    lstSpeciesTypeMap.Items.Clear();
                    CommonClass.dicBlend.Clear();
                    CommonClass.dicLayerValueRange.Clear();
                    cboSpeciesTypeGIS.Items.Clear();
                    lblMinMax.Visible = false;
                    lblMinMaxGIS.Visible = false; //added by Edwin
                    dgvGridInfo.DataSource = null;
                    btnZoomIn.Enabled = false;
                    btnZoomOut.Enabled = false;
                    btnChangeBoundary.Enabled = false;
                    tsbtnPlotMonitors.Enabled = false; plotControl1.IsDrawMonitors = false; plotControl1.isMarkSelectedPoint = false;
                    btnSavePic.Enabled = false;
                    btnBar.Visible = false;
                    btnDistribution.Visible = false;
                    btnFrequency.Visible = false;
                    //btnSetting.Location = new System.Drawing.Point(zgcChart.Location.X + zgcChart.Size.Width - btnSetting.Size.Width, btnSetting.Location.Y);
                    //zgcChart.Size = new Size(zgcChart.Size.Width, tbpChart.Size.Height - 18);
                    //zgcChart.Location = new System.Drawing.Point(zgcChart.Location.X, 7);
                    lblMAPname.Text = "";
                    if (CommonClass.modelDefinition == null)
                    {
                        CommonClass.modelDefinition = new ModelDefinition();
                        CommonClass.modelDefinition.ActiveGridType = "12km";
                        CommonClass.modelDefinition.ParseModelDef("", !CommonClass.currentProjisLCC());
                    }
                    if (CommonClass.modelDefinition.ShapeLCCFiles == null)
                        CommonClass.modelDefinition.ShapeLCCFiles = new Dictionary<string, Dictionary<string, double[,]>>();
                    if (!CommonClass.modelDefinition.ShapeLCCFiles.ContainsKey(CommonClass.modelDefinition.ActiveGridType))
                        CommonClass.modelDefinition.ShapeLCCFiles.Add(CommonClass.modelDefinition.ActiveGridType, new Dictionary<string, double[,]>());
                    if (CommonClass.currentProjisLCC())
                    {
                        if (!CommonClass.modelDefinition.ShapeLCCFiles[CommonClass.modelDefinition.ActiveGridType].ContainsKey("state"))
                        {
                            CommonClass.ShapeLCC = CommonClass.ParseShapeLcc(Application.StartupPath + @"\Data\ShapeFiles\state.csv");
                            CommonClass.modelDefinition.ShapeLCCFiles[CommonClass.modelDefinition.ActiveGridType].Add("state", CommonClass.ShapeLCC);
                        }
                    }
                    else
                    {
                        if (!CommonClass.modelDefinition.ShapeLCCFiles[CommonClass.modelDefinition.ActiveGridType].ContainsKey("state_utm"))
                        {
                            CommonClass.ShapeLCC = CommonClass.ParseShapeLcc(Application.StartupPath + @"\Data\ShapeFiles\state_utm.csv");
                            CommonClass.modelDefinition.ShapeLCCFiles[CommonClass.modelDefinition.ActiveGridType].Add("state_utm", CommonClass.ShapeLCC);
                        }
                    }
                    //SMAT-China Map added by Edwin
                    if (!CommonClass.modelDefinition.ShapeLCCFiles[CommonClass.modelDefinition.ActiveGridType].ContainsKey("region") && LanguageOld.IsSMATChina)
                    {
                        CommonClass.ShapeLCC = CommonClass.ParseShapeLcc(Application.StartupPath + @"\Data\ShapeFiles\China_Region.csv");
                        CommonClass.modelDefinition.ShapeLCCFiles[CommonClass.modelDefinition.ActiveGridType].Add("region", CommonClass.ShapeLCC);
                    }
                    //slow - add when draw map
                    //if (!CommonClass.modelDefinition.ShapeLCCFiles[CommonClass.modelDefinition.ActiveGridType].ContainsKey("county"))
                    //{
                    //    CommonClass.ShapeLCC = CommonClass.ParseShapeLcc(Application.StartupPath + @"\Data\ShapeFiles\county.csv");
                    //    CommonClass.modelDefinition.ShapeLCCFiles[CommonClass.modelDefinition.ActiveGridType].Add("county", CommonClass.ShapeLCC);
                    //}
                    CommonClass.modelDefinition.ParseModelDef("", !CommonClass.currentProjisLCC());
                    plotControl1.modelDef = CommonClass.modelDefinition.modelDef;
                    if (LanguageOld.IsSMATChina)
                        plotControl1.SegmentsList = CommonClass.modelDefinition.GetShapesSegments("region");
                    else if (!CommonClass.currentProjisLCC())
                        plotControl1.SegmentsList = CommonClass.modelDefinition.GetShapesSegments("state_utm");
                    else
                        plotControl1.SegmentsList = CommonClass.modelDefinition.GetShapesSegments("state");
                    plotControl1.ColorBlendControl = colorBlendMap;
                    colorBlendMap.ValueUnit = CommonClass.modelDefinition.modelDef.ValueUnit;
                    CommonClass.modelDefinition.GridValues = new Dictionary<string, double>();
                    plotControl1.UseInterpolation = true;
                    Dictionary<string, double> dic = new Dictionary<string, double>();
                    dic.Add("0,0", 0);
                    plotControl1.NewGridValues = dic;
                    plotControl1.UseInterpolation = false;
                    dataDomainGIS = null;
                }
                #endregion
                //added by Edwin
                if ((!LanguageOld.IsSMATChina))// && groupBox3.Left == 6)
                {
                    gbxQuantifiers.Visible = true;
                    splitContainerData.Panel1MinSize = 25;
                    splitContainerData.SplitterDistance = 214;
                    //groupBox3.Width -= 220;
                    //groupBox3.Left = 226;
                }
                else if (LanguageOld.IsSMATChina)// && groupBox3.Left == 226)
                {
                    gbxQuantifiers.Visible = false;
                    splitContainerData.Panel1MinSize = 0;
                    splitContainerData.SplitterDistance = 0;
                    //groupBox3.Width += 220;
                    //groupBox3.Left = 6;
                }
               
                if (this.ParentForm != null)
                {
                    if (LanguageOld.IsSMATChina || Language.Localization.CurrentLanguage == "zh")
                        (this.ParentForm as Main).Text = "SMAT-China " + CommonClass.versionSMATChina;
                    else
                    {

                        (this.ParentForm as Main).Text = "SMAT-CE " + CommonClass.VersionNumber; //"SMAT-CE " + System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Substring(0, System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Count() - 4);
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Add data for treelistview
        /// </summary>
        ///<param name="filename">file path</param>
        public void addTreeListView(string fileName)
        {
            try
            {
                tlvDataViewer.Items.Clear();
                tlvDataViewer.Sorting = SortOrder.None;
                tlvDataViewer.Items.Sortable = false;
                tlvDataViewer.ExpandAll();

                TreeListViewItem itemProject;
                TreeListViewItem itemPROJECT;
                TreeListViewItem itemConfigurationBacth;
                TreeListViewItem itemCFG;
                if (CommonClass.CurrentBaseScenario.lstOutput == null)
                {
                    itemProject = new TreeListViewItem() { Name = "project", Font = new System.Drawing.Font("Calibri", 13f, FontStyle.Underline), Text = "Project Name", Tag = CommonClass.CurrentBaseScenario.configuration.configurationName.Trim().ToLower(), ImageIndex = 0 };
                    itemProject.Expand();

                    itemPROJECT = new TreeListViewItem() { Name = CommonClass.FileName, Text = CommonClass.CurrentBaseScenario.configuration.configurationName, Tag = "proj", ImageIndex = 1 };
                    itemProject.Items.Add(itemPROJECT);

                    tlvDataViewer.Items.Add(itemProject);

                    //itemConfigurationBacth = new TreeListViewItem() { Name = "configurationbatch", Font = new System.Drawing.Font("Calibri", 13f, FontStyle.Underline), Text = "Configuration & Batch File", Tag = CommonClass.CurrentBaseScenario.configuration.configurationName.Trim().ToLower(), ImageIndex = 0 };
                    //itemConfigurationBacth.Expand();

                    //itemCFG = new TreeListViewItem() { Name = CommonClass.CurrentBaseScenario.configuration.configurationPath, Text = "Configuration & Batch File", Tag = "cfg", ImageIndex = 1 };
                    //itemConfigurationBacth.Items.Add(itemCFG);
                    //itemCFG.SubItems.Add("Configuration");
                    //itemCFG.SubItems.Add(Convert.ToString(fileName.Length) + "kb");
                    return;
                }

                itemProject = new TreeListViewItem() { Name = "project", Font = new System.Drawing.Font("Calibri", 13f, FontStyle.Underline), Text = "Project Name", Tag = CommonClass.CurrentBaseScenario.configuration.configurationName.Trim().ToLower(), ImageIndex = 0 };
                itemProject.Expand();

                itemPROJECT = new TreeListViewItem()
                {
                    Name = CommonClass.FileName,
                    Text = CommonClass.CurrentBaseScenario.configuration.configurationName,
                    Tag = "proj",
                    ImageIndex = 1,
                    ToolTipText = "Double-click to view analysis settings"
                };
                itemProject.Items.Add(itemPROJECT);

                TreeListViewItem itemLog = new TreeListViewItem() { Name = "audittrailreport", Font = new System.Drawing.Font("Calibri", 13f, FontStyle.Underline), Text = "Log & Msg", Tag = CommonClass.CurrentBaseScenario.configuration.configurationName.Trim().ToLower(), ImageIndex = 0 };
                itemLog.Expand();

                TreeListViewItem itemLOG = new TreeListViewItem()
                {
                    Name = "logfile",
                    Text = "Log & Msg",
                    Tag = "logfile",
                    ImageIndex = 1,
                    ToolTipText = "Double-click to view log"
                };
                itemLog.Items.Add(itemLOG);
                itemLOG.SubItems.Add("Run Log");
                itemLOG.SubItems.Add("0kb");

                itemConfigurationBacth = new TreeListViewItem() { Name = "configurationbatch", Font = new System.Drawing.Font("Calibri", 13f, FontStyle.Underline), Text = "Configuration & Batch File", Tag = CommonClass.CurrentBaseScenario.configuration.configurationName.Trim().ToLower(), ImageIndex = 0 };
                itemConfigurationBacth.Expand();

                itemCFG = new TreeListViewItem()
                {
                    Name = CommonClass.CurrentBaseScenario.configuration.configurationPath,
                    Text = "Configuration & Batch File",
                    Tag = "cfg",
                    ImageIndex = 1,
                    ToolTipText = "Double-click to view config"
                };
                itemConfigurationBacth.Items.Add(itemCFG);
                itemCFG.SubItems.Add("Configuration");
                itemCFG.SubItems.Add(Convert.ToString(fileName.Length) + "kb");

                TreeListViewItem itemOutput = new TreeListViewItem() { Name = "outputfiles", Font = new Font("Calibri", 13f, FontStyle.Underline), Text = "Output Files", Tag = "outputfilestitle", ImageIndex = 0 };
                itemOutput.Expand();
                itemOutput.Items.Sortable = false;
                itemOutput.Items.SortOrder = SortOrder.None;
                TreeListViewItem itemFiles = new TreeListViewItem();
                int index = -1;
                foreach (var item in CommonClass.CurrentBaseScenario.lstOutput)
                {
                    index++;
                    if (item.outputName.Contains("Annual PM25 Point") || item.outputName.Contains("Daily PM25 Point")
                        || item.outputName.Contains("Ozone Monitors -- monitor data") || item.outputName.Contains("Forecasted Visibility Data"))
                    {
                        if (index != 0)
                        {
                            CommonClass.CurrentBaseScenario.lstOutput.RemoveAt(index);
                            CommonClass.CurrentBaseScenario.lstOutput.Insert(0, item);
                        }
                        break;
                    }
                }


                foreach (BaseOutput baseOutput in CommonClass.CurrentBaseScenario.lstOutput)
                {
                    string _text = baseOutput.outputName.Substring((CommonClass.CurrentBaseScenario.configuration.configurationName + " ").Length, baseOutput.outputName.Length - (CommonClass.CurrentBaseScenario.configuration.configurationName + " ").Length);
                    if (_text.StartsWith("-"))
                    {
                        _text = _text.Substring(1).Trim();
                    }
                    itemFiles = new TreeListViewItem()
                    {
                        Name = baseOutput.outputFilePath,
                        Text = _text,
                        Tag = "outputfiles",
                        ImageIndex = 1,
                        ToolTipText = "Double-click to view data/map"
                    };
                    itemOutput.Items.Add(itemFiles);
                    itemFiles.SubItems.Add(baseOutput.outputType);
                    itemFiles.SubItems.Add(Convert.ToString(baseOutput.outputSize) + "kb");
                }
                tlvDataViewer.Items.Add(itemProject);
                tlvDataViewer.Items.Add(itemOutput);
                tlvDataViewer.Items.Add(itemLog);
                tlvDataViewer.Items.Add(itemConfigurationBacth);
                //tlvDataViewer.Refresh();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Maximize TabControl to maximize the data display
        /// </summary>
        public void maxViewer()
        {
            try
            {
                Extent exLast = mainMap.ViewExtents.Clone() as Extent;
                if (!isMaxView)
                {
                    this.stcMain.Panel1MinSize = 0;
                    this.stcMain.SplitterDistance = 0;
                    this.stcMain.BorderStyle = BorderStyle.None;
                    this.scrRight.Panel1MinSize = 0;
                    this.scrRight.SplitterDistance = 0;
                    this.scrRight.FixedPanel = FixedPanel.Panel1;
                    this.scrRight.BorderStyle = BorderStyle.None;
                    //mainMap.ZoomToMaxExtent();
                    isMaxView = true;
                }
                else
                {
                    if (CommonClass.OutputNavigator)
                    {
                        this.stcMain.Panel1MinSize = 338;
                        this.stcMain.SplitterDistance = 338;
                        this.stcMain.FixedPanel = FixedPanel.Panel1;
                        this.stcMain.BorderStyle = BorderStyle.None;
                        this.scrRight.Panel1MinSize = 104;
                        this.scrRight.SplitterDistance = 104;
                        this.scrRight.FixedPanel = FixedPanel.Panel1;
                        this.scrRight.BorderStyle = BorderStyle.None;
                        //mainMap.ZoomToMaxExtent();
                    }
                    else
                    {
                        this.stcMain.Panel1MinSize = 491;
                        this.stcMain.SplitterDistance = 491;
                        this.stcMain.FixedPanel = FixedPanel.Panel1;
                        this.stcMain.BorderStyle = BorderStyle.None;
                        this.scrRight.Panel1MinSize = 104;
                        this.scrRight.SplitterDistance = 104;
                        this.scrRight.FixedPanel = FixedPanel.Panel1;
                        this.scrRight.BorderStyle = BorderStyle.None;
                    }
                    isMaxView = false;
                }
                if (mainMap.Layers.Count == 1)
                {
                    if (cboStandardLayers.SelectedItem.ToString() == "China")
                    {
                        mainMap.ViewExtents = new Extent()
                        {
                            MaxX = 2114399,
                            MaxY = 2906359,
                            MinX = -3397624,
                            MinY = -2567910
                        };
                    }
                    else
                    {
                        if (CommonClass.currentProjisLCC())
                        {
                            mainMap.ViewExtents = new Extent()
                            {
                                MaxX = 2325850.8,
                                MaxY = 1275319.5,
                                MinX = -2274714.4,
                                MinY = -1604646.2
                            };
                        }
                        else
                        {
                            mainMap.ViewExtents = new Extent()
                            {
                                MaxX = 2084597.7,
                                MaxY = 6873065.9,
                                MinX = -2728406.7,
                                MinY = 1935195.9
                            };

                        }
                    }
                    //mainMap.ViewExtents = mainMap.Extent;
                }
                else
                {
                    mainMap.ViewExtents = exLast;
                    //double MaxX = exLast.MaxX;
                    //double MaxY = exLast.MaxY;
                    //double MinX = exLast.MinX;
                    //double MinY = exLast.MinY;
                    //mainMap.ViewExtents = new Extent()
                    //{
                    //    MaxX = MaxX,
                    //    MaxY = MaxY,
                    //    MinX = MinX,
                    //    MinY = MinY,
                    //};
                }
                mainMap.Refresh();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //---------------dynamic loading treeview-------------------
        private void loadTreeNodes(TreeNodeCollection node, string fileName)
        {
            try
            {
                // added & modified by Yangwewei 2013 11.12
                string text = "text-" + LanguageOld.CurrentLanguage();
                string tooltip = "tooltip-" + LanguageOld.CurrentLanguage();

                var root = XElement.Load(fileName);
                foreach (var element in root.Elements())
                {
                    TreeNode tNode = new TreeNode();
                    tNode.Text = Language.Localization.GetValue(element.Attribute(text).Value);
                    tNode.Name = element.Attribute("name").Value;
                    tNode.ToolTipText = Language.Localization.GetValue(element.Attribute(tooltip).Value);
                    tNode.ImageKey = element.Attribute("icon").Value;
                    tNode.SelectedImageKey = element.Attribute("icon").Value;
                    node.Add(tNode);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //-------------initialize picture of tree nodes----------------
        private void InitNodeImage(TreeNode node)
        {
            try
            {
                node.ImageKey = _unreadyImageKey;
                node.SelectedImageKey = _unreadyImageKey;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //-------------Change pictures of nodes---------------
        private void ChangeNodeImage(TreeNode node)
        {
            try
            {
                node.ImageKey = _readyImageKey;
                node.SelectedImageKey = _readyImageKey;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //---------------Error node----------------
        private void errorNode(TreeNode node)
        {
            try
            {
                node.ImageKey = _errorImageKey;
                node.SelectedImageKey = _errorImageKey;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }

        /// <summary>
        /// create new project
        /// </summary>
        public void createCfg(int n)
        {
            try
            {
                //string msg = "";
                string path = null;
                lblSteps.Text = Language.Localization.GetValue("Choose Desired Output");
                //---------------Tips for save or not-----------------
                DialogResult rtn = MessageBox.Show(Language.Localization.GetValue("Save project?"), Language.Localization.GetValue("Tip"), MessageBoxButtons.YesNo);
                if (rtn == DialogResult.Yes)
                {

                }
                clearAll();
                switch (n)
                {
                    case 1:
                        lblAnalysis.Text = Language.Localization.GetValue("Annual PM Analysis");
                        path = Application.StartupPath + @"\Configs\Annual PM Analysis.xml";
                        pnlUserControl.Controls.Add(new uc_OutputA());
                        break;
                    case 2:
                        lblAnalysis.Text = Language.Localization.GetValue("Daily PM Analysis");
                        path = Application.StartupPath + @"\Configs\Daily PM Analysis.xml";
                        pnlUserControl.Controls.Add(new uc_OutputD());
                        break;
                    case 3:
                        lblAnalysis.Text = Language.Localization.GetValue("Ozone Analysis");
                        path = Application.StartupPath + @"\Configs\Ozone Analysis.xml";
                        pboPollutant.Image = Resources.O3;
                        pnlUserControl.Controls.Add(new uc_DesiredOutputOzone());
                        break;
                    case 4:
                        lblAnalysis.Text = Language.Localization.GetValue("Visibility Analysis");
                        path = Application.StartupPath + @"\Configs\Visibility Analysis.xml";
                        pboPollutant.Image = Resources.Haze;
                        pnlUserControl.Controls.Add(new uc_ChooseDesiredOutputV());
                        break;
                }
                loadTreeNodes(trvAnalysis.Nodes, path);
                _stips = "Choose Desired output";
                tips.SetToolTip(pboHelp, Language.Localization.GetValue(_stips));
                for (int i = 0; i < trvAnalysis.Nodes.Count; i++)
                {
                    foreach (TreeNode tr in trvAnalysis.Nodes[i].Nodes)
                    {
                        InitNodeImage(tr);
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        /// Clear previous
        /// </summary>
        public void clearAll()
        {
            try
            {
                this.btnSave.Enabled = false;
                this.btnSaveRun.Enabled = false;
                this.pnlUserControl.Controls.Clear();
                this.trvAnalysis.Nodes.Clear();
                this.tbcFunction.SelectedTab = tbpGIS;
                if (tlvDataViewer.Items.Count > 1)
                    tlvDataViewer.Items.Clear();
                if (tlvLogFile.Items.Count > 0)
                    tlvLogFile.Items.Clear();
                if (dgvDataView.Rows.Count > 0)
                    dgvDataView.Rows.Clear();
                if (clboQuantifiers.Items.Count > 0)
                    clboQuantifiers.Items.Clear();
                if (dgvDataList.Columns.Count > 0)
                    dgvDataList.Columns.Clear();
                if (cboFilter.Items.Count > 0)
                    cboFilter.Items.Clear();
                if (cboType.Items.Count > 0)
                    cboType.Items.Clear();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
        #region check UC
        public string checkDataInputA()
        {
            try
            {
                AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_DataInputA _dataInputA = (pnlUserControl.Controls[0] as uc_DataInputA);
                if (_dataInputA.rbtnMonitorFileA.Checked)
                {
                    //check species monitor data file
                    #region
                    if (CommonClass.speciesMonitorFile != null && CommonClass.speciesMonitorFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.speciesMonitorFile))
                        { errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File does not exist!\n")); }
                        else
                        {
                            fileStream = new FileStream(CommonClass.speciesMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("no3r") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("ocb")
                                    && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("salt") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("h2o_aim") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("so4_3s") && fieldNameAdd.Contains("crustal_alt")
                                    && fieldNameAdd.Contains("frm_mass") && fieldNameAdd.Contains("measured_fm") && fieldNameAdd.Contains("rcfm") && fieldNameAdd.Contains("al") && fieldNameAdd.Contains("ca") && fieldNameAdd.Contains("fe") && fieldNameAdd.Contains("ti") && fieldNameAdd.Contains("si") && fieldNameAdd.Contains("epa_flag")
                                    && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 28)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Species Monitor Data File!\n"));
                    }
                    #endregion
                    //check unofficial monitor data file
                    #region
                    if (CommonClass.unofficialPMFile != null && CommonClass.unofficialPMFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.unofficialPMFile))
                            errorTipBuilder.Append(Language.Localization.GetValue("Unofficial Daily Average PM25 Data File path does not exist!\n"));
                        else
                        {
                            fileStream = new FileStream(CommonClass.unofficialPMFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Unofficial Daily Average PM25 Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date")
                                    && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 8)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Unofficial Daily Average PM25 Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Unofficial Daily Average PM25 Data File!\n"));
                    }
                    #endregion
                }
                else
                {
                    if (_dataInputA.rbtnFractionA.Checked)//check species fractions file
                    {
                        #region
                        if (annualPMAnalysisConfiguration.outputChoiceAdvancedA != null
                            && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFilePoint
                            || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Using species fractions file. Disable neighbor file creation.\n"));
                            errorNode(trvAnalysis.Nodes[1]);
                        }
                        if (_dataInputA.rbtnFractionA.Checked && _dataInputA.cboSpatialA.Text == "grad adj spatial field" && annualPMAnalysisConfiguration.outputChoiceAdvancedA != null
                            && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyVNA || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Using gradient-adjustment species fractions file spatial field. Disable VNA files creation.\n"));
                            errorNode(trvAnalysis.Nodes[1]);
                        }
                        if (_dataInputA.rbtnFractionA.Checked && _dataInputA.cboSpatialA.Text == "spatial field" && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                           && ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyEvna || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Using species fractions file spatial field. Disable eVNA files creation.\n"));
                            errorNode(trvAnalysis.Nodes[1]);
                        }
                        //if (((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null
                        //    && ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doStandardAnalysis || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doSpeciesFraction
                        //    || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doUsedQuarterlyAvgModelData)) ||
                        //    ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFilePoint))
                        //{
                        if (CommonClass.speciesFractionFilePoint != null && CommonClass.speciesFractionFilePoint.Length > 0)
                        {
                            if (!File.Exists(CommonClass.speciesFractionFilePoint))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Point Species Fractions File path does not exist!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.speciesFractionFilePoint, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Point Species Fractions File is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Contains("monitor_lat") && fieldNameAdd.Contains("monitor_long") && fieldNameAdd.Contains("quarter")
                                        && fieldNameAdd.Contains("pm25_mass_frac") && fieldNameAdd.Contains("fcr") && fieldNameAdd.Contains("fec") && fieldNameAdd.Contains("fnh4") && fieldNameAdd.Contains("focm") && fieldNameAdd.Contains("fso4")
                                        && fieldNameAdd.Contains("fno3") && fieldNameAdd.Contains("fwater") && fieldNameAdd.Contains("fsalt") && fieldNameAdd.Contains("blank_mass") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("i_so4")
                                        && fieldNameAdd.Contains("i_no3r") && fieldNameAdd.Contains("i_ocb") && fieldNameAdd.Contains("i_ec") && fieldNameAdd.Contains("i_crustal") && fieldNameAdd.Contains("i_don") && fieldNameAdd.Contains("i_nh4")
                                        && fieldNameAdd.Contains("i_no3") && fieldNameAdd.Contains("i_salt") && fieldNameAdd.Length == 26)
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Point Species Fractions File is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Point Species Fractions File!\n"));
                        }
                        //}
                        #endregion
                        //check species fractions file-spatial field
                        #region
                        if (_dataInputA.cboSpatialA.Text == "spatial field" && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                            && ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyVNA || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial))
                        {
                            if (CommonClass.speciesFractionFileSpatial != null && CommonClass.speciesFractionFileSpatial.Length > 0)
                            {
                                if (!File.Exists(CommonClass.speciesFractionFileSpatial))
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Spatial Field Species Fractions File path does not exist!\n"));
                                }
                                else
                                {
                                    fileStream = new FileStream(CommonClass.speciesFractionFileSpatial, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                    streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                    frequency = streamReader.ReadLine();
                                    if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Spatial Field Species Fractions File is ill-formatted data!\n"));
                                    }
                                    else
                                    {
                                        string fieldName = streamReader.ReadLine();
                                        string[] fieldNameAdd = new string[] { };
                                        if (fieldName != null && fieldName.Length > 0)
                                        {
                                            fieldName = fieldName.Replace(" ", "");
                                            fieldName = fieldName.Replace("\"", "");
                                            fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                        }
                                        if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("gridcell_lat") && fieldNameAdd.Contains("gridcell_long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("pm25_mass_frac")
                                        && fieldNameAdd.Contains("fcr") && fieldNameAdd.Contains("fec") && fieldNameAdd.Contains("fnh4") && fieldNameAdd.Contains("focm") && fieldNameAdd.Contains("fso4")
                                        && fieldNameAdd.Contains("fno3") && fieldNameAdd.Contains("fwater") && fieldNameAdd.Contains("fsalt") && fieldNameAdd.Contains("blank_mass") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("i_so4")
                                        && fieldNameAdd.Contains("i_no3r") && fieldNameAdd.Contains("i_ocb") && fieldNameAdd.Contains("i_ec") && fieldNameAdd.Contains("i_crustal") && fieldNameAdd.Contains("i_don") && fieldNameAdd.Contains("i_nh4")
                                        && fieldNameAdd.Contains("i_no3") && fieldNameAdd.Contains("i_salt") && fieldNameAdd.Length == 24)
                                        {
                                            ok = true;
                                        }
                                        else
                                        {
                                            ok = false;
                                        }
                                        if (!ok)
                                        {
                                            errorTipBuilder.Append(Language.Localization.GetValue("Spatial Field Species Fractions File is ill-formatted data!\n"));
                                        }
                                    }
                                    ok = false;
                                    fileStream.Dispose();
                                    streamReader.Dispose();
                                }
                            }
                            else
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Please select a Spatial Field Species Fractions File!\n"));
                            }
                        }
                        else if (_dataInputA.cboSpatialA.Text == "grad adj spatial field" && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                            && ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyEvna || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj))
                        {
                            if (CommonClass.speciesFractionFileSpatial != null && CommonClass.speciesFractionFileSpatial.Length > 0)
                            {
                                if (!File.Exists(CommonClass.speciesFractionFileSpatial))
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Gradient-adjusted Spatial Field Species Fractions File path does not exist!\n"));
                                }
                                else
                                {
                                    fileStream = new FileStream(CommonClass.speciesFractionFileSpatial, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                    streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                    frequency = streamReader.ReadLine();
                                    if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Gradient-adjusted Spatial Field Species Fractions File is ill-formatted data!\n"));
                                    }
                                    else
                                    {
                                        string fieldName = streamReader.ReadLine();
                                        string[] fieldNameAdd = new string[] { };
                                        if (fieldName != null && fieldName.Length > 0)
                                        {
                                            fieldName = fieldName.Replace(" ", "");
                                            fieldName = fieldName.Replace("\"", "");
                                            fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                        }
                                        if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("gridcell_lat") && fieldNameAdd.Contains("gridcell_long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("pm25_mass_frac_ga") && fieldNameAdd.Contains("fcr_ga") && fieldNameAdd.Contains("fec_ga")
                                            && fieldNameAdd.Contains("fnh4_ga") && fieldNameAdd.Contains("focm_ga") && fieldNameAdd.Contains("fso4_ga") && fieldNameAdd.Contains("fno3_ga") && fieldNameAdd.Contains("fwater_ga") && fieldNameAdd.Contains("fsalt_ga") && fieldNameAdd.Contains("blank_mass_ga")
                                            && fieldNameAdd.Contains("don_ga") && fieldNameAdd.Contains("i_so4_ga") && fieldNameAdd.Contains("i_no3r_ga") && fieldNameAdd.Contains("i_ocb_ga") && fieldNameAdd.Contains("i_ec_ga") && fieldNameAdd.Contains("i_crustal_ga") && fieldNameAdd.Contains("i_don_ga")
                                            && fieldNameAdd.Contains("i_nh4_ga") && fieldNameAdd.Contains("i_no3_ga") && fieldNameAdd.Contains("i_salt_ga") && fieldNameAdd.Length == 24)
                                        {
                                            ok = true;
                                        }
                                        else
                                        {
                                            ok = false;
                                        }
                                        if (!ok)
                                        {
                                            errorTipBuilder.Append(Language.Localization.GetValue("Gradient-adjusted Spatial Field Species Fractions File is ill-formatted data!\n"));
                                        }
                                    }
                                    ok = false;
                                    fileStream.Dispose();
                                    streamReader.Dispose();
                                }
                            }
                            else
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Please select a Gradient-adjusted Spatial Field Species Fractions File!\n"));
                            }
                        }
                        //}
                        #endregion
                    }
                }

                //check official monitor data
                if (CommonClass.officialPMFile != null && CommonClass.officialPMFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.officialPMFile))
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File path does not exist!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.officialPMFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("ndays")
                                && fieldNameAdd.Contains("_substitution_code") && fieldNameAdd.Contains("completion_code") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Length == 11)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select an Official Quarterly Average FRM Data File!\n"));
                }

                if (_dataInputA.rbtnDailyModelA.Checked)//check daily model data
                {
                    //baseline model data
                    if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.baseModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Baseline Model Data File!\n"));
                    }

                    //control model data
                    if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.futureModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Forecast Model Data File!\n"));
                    }
                }

                if (_dataInputA.rbtnQuarterlyModelA.Checked)//check quarterly model data
                {
                    //baseline model data
                    if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.baseModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Baseline Model Data File!\n"));
                    }

                    //control model data
                    if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.futureModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Forecast Model Data File!\n"));
                    }
                }

                if (_dataInputA.rbtnCMAQA.Checked)//CMAQ
                {

                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public string checkDataInputD()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_DataInputD _dataInputD = (pnlUserControl.Controls[0] as uc_DataInputD);
                if (_dataInputD.rbtnSpeciesMonitorD.Checked)
                {
                    //check species monitor data file
                    if (CommonClass.speciesMonitorFile != null && CommonClass.speciesMonitorFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.speciesMonitorFile))
                        { errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File path does not exist!\n")); }
                        else
                        {
                            fileStream = new FileStream(CommonClass.speciesMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("no3r") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("ocb")
                                    && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("salt") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("h2o_aim") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("so4_3s") && fieldNameAdd.Contains("crustal_alt")
                                    && fieldNameAdd.Contains("frm_mass") && fieldNameAdd.Contains("measured_fm") && fieldNameAdd.Contains("rcfm") && fieldNameAdd.Contains("al") && fieldNameAdd.Contains("ca") && fieldNameAdd.Contains("fe") && fieldNameAdd.Contains("ti") && fieldNameAdd.Contains("si") && fieldNameAdd.Contains("epa_flag")
                                    && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 28)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Species Monitor Data File!\n"));
                    }

                    //check unofficial monitor data file
                    if (CommonClass.unofficialPMFile != null && CommonClass.unofficialPMFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.unofficialPMFile))
                            errorTipBuilder.Append(Language.Localization.GetValue("Unofficial Daily Average PM25 Data File path does not exist!\n"));
                        else
                        {
                            fileStream = new FileStream(CommonClass.unofficialPMFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Unofficial Daily Average PM25 Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date")
                                    && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 8)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Unofficial Daily Average PM25 Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Unofficial Daily Average PM25 Data File!\n"));
                    }
                }
                else
                {
                    if (_dataInputD.rbtnSpeciesFractionD.Checked)//check species fractions file
                    {
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doNeighborFilePoint)
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Using species fractions file. Disable neighbor file creation.\n"));
                            errorNode(trvAnalysis.Nodes[1]);
                        }
                        if (CommonClass.speciesFractionFilePoint != null && CommonClass.speciesFractionFilePoint.Length > 0)
                        {
                            if (!File.Exists(CommonClass.speciesFractionFilePoint))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Point Species Fractions File path does not exist!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.speciesFractionFilePoint, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Point Species Fractions File is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Contains("monitor_lat") && fieldNameAdd.Contains("monitor_long") && fieldNameAdd.Contains("quarter")
                                        && fieldNameAdd.Contains("pm25_mass_frac") && fieldNameAdd.Contains("fcr") && fieldNameAdd.Contains("fec") && fieldNameAdd.Contains("fnh4") && fieldNameAdd.Contains("focm") && fieldNameAdd.Contains("fso4")
                                        && fieldNameAdd.Contains("fno3") && fieldNameAdd.Contains("fwater") && fieldNameAdd.Contains("fsalt") && fieldNameAdd.Contains("blank_mass") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("i_so4")
                                        && fieldNameAdd.Contains("i_no3r") && fieldNameAdd.Contains("i_ocb") && fieldNameAdd.Contains("i_ec") && fieldNameAdd.Contains("i_crustal") && fieldNameAdd.Contains("i_don") && fieldNameAdd.Contains("i_nh4")
                                        && fieldNameAdd.Contains("i_no3") && fieldNameAdd.Contains("i_salt") && fieldNameAdd.Length == 26)
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Point Species Fractions File is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Point Species Fractions File!\n"));
                        }
                    }
                }

                //check official monitor data
                if (CommonClass.officialPMFile != null && CommonClass.officialPMFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.officialPMFile))
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File path does not exist!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.officialPMFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("98_percentile")
                                && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("completion_code") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Contains("rank98") && fieldNameAdd.Length == 12)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select an Official Quarterly Average FRM Data File!\n"));
                }

                if (_dataInputD.rbtnDailyModelDataD.Checked)//check daily model data
                {
                    //baseline model data
                    if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.baseModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Daily Baseline Model Data File can not be empty!\n"));
                    }

                    //control model data
                    if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.futureModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Daily Forecast Model Data File can not be empty!\n"));
                    }
                }

                if (_dataInputD.rbtnQuarterlyPeakModelDataD.Checked)//check quarterly model data
                {
                    //baseline model data
                    if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.baseModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Quarterly Baseline Model Data File can not be empty!\n"));
                    }

                    //control model data
                    if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.futureModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Quarterly Forecast Model Data File can not be empty!\n"));
                    }
                }

                if (_dataInputD.rbtnCMAQFileD.Checked)//CMAQ
                {

                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public string checkDataInputO()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_DataInputOzone _dataInputO = (pnlUserControl.Controls[0] as uc_DataInputOzone);
                //check monitor data file
                if (CommonClass.ozoneMonitorFile != null && CommonClass.ozoneMonitorFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.ozoneMonitorFile))
                    { errorTipBuilder.Append(Language.Localization.GetValue("Monitor Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(CommonClass.ozoneMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "designvalue")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Monitor Data File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("poc") && fieldNameAdd.Contains("dvyear") && fieldNameAdd.Contains("o3") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Length == 9)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Monitor Data File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a Monitor Data File!\n"));
                }

                //check model data file-baseline
                if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.baseModelFile))
                    { errorTipBuilder.Append(Language.Localization.GetValue("Model Baseline Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Model Baseline File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Model Baseline File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a Model Baseline File!\n"));
                }

                //check model data file-forecast
                if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.futureModelFile))
                    { errorTipBuilder.Append(Language.Localization.GetValue("Model Forecast Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Model Forecast File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Model Forecast File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a Model Forecast File!\n"));
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        #region remove to DataInputV user control, by devin, 2017-02-17
        /*
           public string checkDataInputV()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_DataInputV _dataInputV = (pnlUserControl.Controls[0] as uc_DataInputV);
                //check monitor data file
                if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm)
                {

                    if (CommonClass.improveAlgorithmOld != null && CommonClass.improveAlgorithmOld.Length > 0)
                    {
                        if (!File.Exists(CommonClass.improveAlgorithmOld))
                        { errorTipBuilder.Append(Language.Translate("Monitor Data File path does not exist!\n")); }
                        else
                        {
                            fileStream = new FileStream(CommonClass.improveAlgorithmOld, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Translate("Monitor Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("frh") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("amm_no3") && fieldNameAdd.Contains("omc") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("pm10") && fieldNameAdd.Contains("cm") && fieldNameAdd.Contains("amm_so4") && fieldNameAdd.Contains("e_amm_so4") && fieldNameAdd.Contains("e_amm_no3") && fieldNameAdd.Contains("e_omc") && fieldNameAdd.Contains("e_ec") && fieldNameAdd.Contains("e_crustal") && fieldNameAdd.Contains("e_cm") && fieldNameAdd.Contains("tbext") && fieldNameAdd.Contains("dv") && fieldNameAdd.Contains("good_year") && fieldNameAdd.Contains("group") && fieldNameAdd.Contains("possible_ndays") && fieldNameAdd.Contains("ndays") && fieldNameAdd.Contains("complete_quarter") && fieldNameAdd.Contains("sf") && fieldNameAdd.Contains("so4f") && fieldNameAdd.Length == 29)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Translate("Monitor Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Translate("Please select a Monitor Data File!\n"));
                    }
                }
                else
                {
                    if (CommonClass.improveAlgorithmNew != null && CommonClass.improveAlgorithmNew.Length > 0)
                    {
                        if (!File.Exists(CommonClass.improveAlgorithmNew))
                        { errorTipBuilder.Append(Language.Translate("Monitor Data File path does not exist!\n")); }
                        else
                        {
                            fileStream = new FileStream(CommonClass.improveAlgorithmNew, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Translate("Monitor Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long")
                                    && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("frh") && fieldNameAdd.Contains("fsrh") && fieldNameAdd.Contains("flrh")
                                    && fieldNameAdd.Contains("fssrh") && fieldNameAdd.Contains("ss_rayleigh") && fieldNameAdd.Contains("sea_salt") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("amm_no3") && fieldNameAdd.Contains("omc") && fieldNameAdd.Contains("ec")
                                    && fieldNameAdd.Contains("pm10") && fieldNameAdd.Contains("cm") && fieldNameAdd.Contains("amm_so4") && fieldNameAdd.Contains("large_omc")
                                    && fieldNameAdd.Contains("small_omc") && fieldNameAdd.Contains("large_amm_so4") && fieldNameAdd.Contains("small_amm_so4")
                                    && fieldNameAdd.Contains("large_amm_no3") && fieldNameAdd.Contains("small_amm_no3") && fieldNameAdd.Contains("e_amm_so4")
                                    && fieldNameAdd.Contains("e_amm_no3") && fieldNameAdd.Contains("e_omc") && fieldNameAdd.Contains("e_ec") && fieldNameAdd.Contains("e_crustal")
                                    && fieldNameAdd.Contains("e_cm") && fieldNameAdd.Contains("e_sea_salt") && fieldNameAdd.Contains("tbext") && fieldNameAdd.Contains("dv")
                                    && fieldNameAdd.Contains("good_year") && fieldNameAdd.Contains("group") && fieldNameAdd.Contains("possible_ndays") && fieldNameAdd.Contains("ndays")
                                    && fieldNameAdd.Contains("complete_quarter") && fieldNameAdd.Contains("sf") && fieldNameAdd.Contains("so4f") && fieldNameAdd.Length == 41)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Translate("Monitor Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Translate("Please select a Monitor Data File!\n"));
                    }
                }

                //check model data file
                if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.baseModelFile))
                    { errorTipBuilder.Append(Language.Translate("Model Baseline Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(Language.Translate("Model Baseline File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Translate("Model Baseline File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Translate("Please select a Model Baseline File!\n"));
                }

                if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.futureModelFile))
                    { errorTipBuilder.Append(Language.Translate("Model Forecast Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(Language.Translate("Model Forecast File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Translate("Model Forecast File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Translate("Please select a Model Forecast File!\n"));
                }

                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
         */
        #endregion remove to DataInputV user control, by devin, 2017-02-17


        public string checkSSIAModelInputA()
        {
            try
            {
                SSIAAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_ModelDataInputA _dataInputA = (pnlUserControl.Controls[0] as uc_ModelDataInputA);

                if (!annualPMAnalysisConfiguration.analysisOptionA.useDispersionOnly)
                {
                    if (_dataInputA.rbtnDailyModelA.Checked)//check daily model data
                    {
                        #region baseline model data
                        if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.baseModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Baseline Model Data File!\n"));
                        }
                        #endregion
                        #region control model data
                        if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.futureModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                        && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        #endregion
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Forecast Model Data File!\n"));
                        }
                    }

                    if (_dataInputA.rbtnQuarterlyModelA.Checked)//check quarterly model data
                    {
                        #region baseline model data
                        if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.baseModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Baseline Model Data File!\n"));
                        }
                        #endregion
                        #region control model data
                        if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.futureModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Forecast Model Data File!\n"));
                        }
                        #endregion
                    }
                }
                if (!annualPMAnalysisConfiguration.analysisOptionA.useGridOnly)
                {
                    if (CommonClass.dispersionModelFile != null && CommonClass.dispersionModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.dispersionModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Dispersion model file path does not exits!\n"));
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Dispersion Model Data File!\n"));
                    }
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public string checkSSIAMonitorInputA()
        {
            try
            {
                SSIAAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_MonitorDataInputA _dataInputA = (pnlUserControl.Controls[0] as uc_MonitorDataInputA);

                #region check official monitor data
                if (CommonClass.officialPMFile != null && CommonClass.officialPMFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.officialPMFile))
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File path does not exist!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.officialPMFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                            return errorTips = errorTipBuilder.ToString();
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("ndays")
                                && fieldNameAdd.Contains("_substitution_code") && fieldNameAdd.Contains("completion_code") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Length == 11)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                                return errorTips = errorTipBuilder.ToString();
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select an Official Quarterly Average FRM Data File!\n"));
                    return errorTips = errorTipBuilder.ToString();
                }
                #endregion

                if (Convert.ToInt16(_dataInputA.cboEndYearA.Text) < Convert.ToInt16(_dataInputA.cboStartYearA.Text))
                    errorTipBuilder.Append(Language.Localization.GetValue("End Year should be later than Start Year!\n"));
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public string checkSSIAModelInputO()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_ModelDataInputO _dataInputO = (pnlUserControl.Controls[0] as uc_ModelDataInputO);

                //check model data file-baseline
                if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.baseModelFile))
                    { errorTipBuilder.Append(Language.Localization.GetValue("Model Baseline Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Model Baseline File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Model Baseline File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a Model Baseline File!\n"));
                }

                //check model data file-forecast
                if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.futureModelFile))
                    { errorTipBuilder.Append(Language.Localization.GetValue("Model Forecast Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Model Forecast File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Model Forecast File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a Model Forecast File!\n"));
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public string checkSSIAMonitorInputO()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_ModelDataInputO _dataInputO = (pnlUserControl.Controls[0] as uc_ModelDataInputO);
                //check monitor data file
                if (CommonClass.ozoneMonitorFile != null && CommonClass.ozoneMonitorFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.ozoneMonitorFile))
                    { errorTipBuilder.Append(Language.Localization.GetValue("Monitor Data File path does not exist!\n")); }
                    else
                    {
                        fileStream = new FileStream(CommonClass.ozoneMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "designvalue")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Monitor Data File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("poc") && fieldNameAdd.Contains("dvyear") && fieldNameAdd.Contains("o3") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Length == 9)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Monitor Data File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a Monitor Data File!\n"));
                }

                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        //---check SSIA Daily added by Edwin
        public string checkSSIAModelInputD()
        {
            try
            {
                SSIADailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_ModelDataInputD _dataInputD = (pnlUserControl.Controls[0] as uc_ModelDataInputD);

                if (!dailyPMAnalysisConfiguration.analysisOptionD.useDispersionOnly)
                {
                    if (_dataInputD.rbtnDailyModelDataD.Checked)//check daily model data
                    {
                        #region baseline model data
                        if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.baseModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Baseline Model Data File!\n"));
                        }
                        #endregion
                        #region control model data
                        if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.futureModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                        && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        #endregion
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Forecast Model Data File!\n"));
                        }
                    }

                    if (_dataInputD.rbtnQuarterlyPeakModelDataD.Checked)//check quarterly model data
                    {
                        #region baseline model data
                        if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.baseModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Baseline Model Data File!\n"));
                        }
                        #endregion
                        #region control model data
                        if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.futureModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                        && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Forecast Model Data File!\n"));
                        }
                        #endregion
                    }
                }
                if (!dailyPMAnalysisConfiguration.analysisOptionD.useGridOnly)
                {
                    if (CommonClass.dispersionModelFile != null && CommonClass.dispersionModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.dispersionModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Dispersion model file path does not exits!\n"));
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Dispersion Model Data File!\n"));
                    }
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public string checkSSIAMonitorInputD()
        {
            try
            {
                SSIADailyPMAnalysisConfiguration dailyPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                if (CommonClass.officialPMFile != null && CommonClass.officialPMFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.officialPMFile))
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File path does not exist!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.officialPMFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("98_percentile")
                                && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("completion_code") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name") && fieldNameAdd.Contains("rank98") && fieldNameAdd.Length == 12)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Official Quarterly Average FRM Data File is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select an Official Quarterly Average FRM Data File!\n"));
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public string checkSSIAModelInputDep()    //added by K.B.
        {
            try
            {
                SSIADepositionConfiguration depositionAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_ModelDataInputDep _dataInputDep = (pnlUserControl.Controls[0] as uc_ModelDataInputDep);
                if (!depositionAnalysisConfiguration.analysisOptionDep.useDispersionOnly)
                {
                    if (_dataInputDep.rbtnDailyModelDataDep.Checked)//check daily model data
                    {
                        #region baseline model data
                        if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.baseModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("tsdep")
                                        && fieldNameAdd.Contains("tndep"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Baseline Model Data File!\n"));
                        }
                        #endregion
                        #region control model data
                        if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.futureModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "day")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("tsdep")
                                        && fieldNameAdd.Contains("tndep"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        #endregion
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Forecast Model Data File!\n"));
                        }
                    }

                    if (_dataInputDep.rbtnQuarterlyModelDataDep.Checked)//check quarterly model data
                    {
                        #region baseline model data
                        if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.baseModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("tsdep")
                                        && fieldNameAdd.Contains("tndep"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Baseline Model Data File!\n"));
                        }
                        #endregion
                        #region control model data
                        if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                        {
                            if (!File.Exists(CommonClass.futureModelFile))
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("tsdep")
                                        && fieldNameAdd.Contains("tndep"))
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Forecast Model Data File!\n"));
                        }
                        #endregion
                    }
                }
                if (!depositionAnalysisConfiguration.analysisOptionDep.useGridOnly)
                {
                    //if (CommonClass.dispersionModelFile != null && CommonClass.dispersionModelFile.Length > 0)
                    //{
                    //    if (!File.Exists(CommonClass.dispersionModelFile))
                    //    {
                    //        errorTipBuilder.Append(Language.Translate("Dispersion model file path does not exits!\n"));
                    //    }
                    //}
                    //else
                    //{
                    //    errorTipBuilder.Append(Language.Translate("Please select a Dispersion Model Data File!\n"));
                    //}
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        //----check data added by Edwin
        public string checkPMChinaModelInput()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_ModelDataChina _dataInputPMChina = (pnlUserControl.Controls[0] as uc_ModelDataChina);

                if (_dataInputPMChina.rbtnQuarterlyAverageDataChina.Checked)//check quarter model data
                {
                    #region baseline model data
                    if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.baseModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Baseline Model Data File!\n"));
                    }
                    #endregion
                    #region control model data
                    if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.futureModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Control file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Control file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm") && fieldNameAdd.Length == 13)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Control file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                        #endregion
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Forecast Model Data File!\n"));
                    }
                }

                if (_dataInputPMChina.rbtnDailyAvertageDatalChina.Checked)//check daily model data
                {
                }

                if (_dataInputPMChina.rbtnCMAQChina.Checked)//CMAQ
                {

                }

                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public string checkPMChinaMonitorInput()
        {
            try
            {
                AnnualPMAnalysisChinaConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_MonitorDataChina _dataInputPMChina = (pnlUserControl.Controls[0] as uc_MonitorDataChina);

                #region check quarter monitor data
                if (_dataInputPMChina.rbtnQuarterlyMonitorChina.Checked)
                {
                    if (CommonClass.monitorFile != null && CommonClass.monitorFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.monitorFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Quarterly Monitor Data File path does not exist!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.monitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Quarterly Monitor Data File is ill-formatted data!\n"));
                                return errorTips = errorTipBuilder.ToString();
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("quarter_dv") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("location_name")
                                    && fieldNameAdd.Contains("station_name") && fieldNameAdd.Length == 8)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Quarterly Monitor Data File is ill-formatted data!\n"));
                                    return errorTips = errorTipBuilder.ToString();
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Monitor Data File!\n"));
                        return errorTips = errorTipBuilder.ToString();
                    }
                }
                #endregion

                if (_dataInputPMChina.rbtnDailyMonitorChina.Checked)
                {
                }
                if (Convert.ToInt16(_dataInputPMChina.cboEndYearChina.Text) < Convert.ToInt16(_dataInputPMChina.cboStartYearChina.Text))
                    errorTipBuilder.Append(Language.Localization.GetValue("End Year should be later than Start Year!\n"));
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public string checkPMChinaSpecies()
        {
            try
            {
                AnnualPMAnalysisChinaConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_PM25SpeciesOptionChina _dataInputPMChina = (pnlUserControl.Controls[0] as uc_PM25SpeciesOptionChina);
                if (_dataInputPMChina.chkSpeciesFractionDataChina.Checked)
                {
                    //check species monitor data file
                    #region
                    if (CommonClass.speciesMonitorFile != null && CommonClass.speciesMonitorFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.speciesMonitorFile))
                        { errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File does not exist!\n")); }
                        else
                        {
                            fileStream = new FileStream(CommonClass.speciesMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("quarter_dv") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("oc")
                                    && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("h2o") && fieldNameAdd.Contains("other") && fieldNameAdd.Contains("location_name") && fieldNameAdd.Contains("station_name") && fieldNameAdd.Length == 15)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Species Monitor Data File is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Species Monitor Data File!\n"));
                    }
                    #endregion
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public string checkOzoneChinaModelInput()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_ModelDataOzoneChina _dataInputOzoneChina = (pnlUserControl.Controls[0] as uc_ModelDataOzoneChina);

                #region baseline model data
                if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.baseModelFile))
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "season")
                        //if(false)
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                        }
                        else
                        {
                            streamReader.ReadLine();
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("season") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a Baseline Model Data File!\n"));
                }
                #endregion
                #region control model data
                if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.futureModelFile))
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Control file path does not exits!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "season")
                        //if (false)
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Control file is ill-formatted data!\n"));
                        }
                        else
                        {
                            streamReader.ReadLine();
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("season") && fieldNameAdd.Contains("o3") && fieldNameAdd.Length == 6)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Control file is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a  Forecast Model Data File!\n"));
                }
                #endregion

                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public string checkOzoneChinaMonitorInput()
        {
            try
            {
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_MonitorDataOzoneChina _dataInputOzoneChina = (pnlUserControl.Controls[0] as uc_MonitorDataOzoneChina);

                if (CommonClass.ozoneMonitorFile != null && CommonClass.ozoneMonitorFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.ozoneMonitorFile))
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Monitor file path does not exits!\n"));
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.ozoneMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "designvalue")
                        //if(false)
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Monitor file is ill-formatted data!\n"));
                        }
                        else
                        {
                            streamReader.ReadLine();
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("season_dv") && fieldNameAdd.Contains("o3")
                                && fieldNameAdd.Contains("location_name") && fieldNameAdd.Contains("station_name") && fieldNameAdd.Length == 8)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Monitor file is ill-formatted data!\n"));
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorTipBuilder.Append(Language.Localization.GetValue("Please select a  Monitor Data File!\n"));
                }
                if (Convert.ToInt16(_dataInputOzoneChina.cboEndYearOzone.Text) < Convert.ToInt16(_dataInputOzoneChina.cboEndYearOzone.Text))
                    errorTipBuilder.Append(Language.Localization.GetValue("End Year should be later than Start Year!\n"));
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }

        }

        public string checkBenMAPAnnualPMModelInput()
        {
            try
            {
                BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorTipBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_BenMAP_AnnualPM_ModelData _dataInputA = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_ModelData);

                if (_dataInputA.rbtnDailyModelA.Checked)//check daily model data
                {
                    #region baseline model data
                    if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.baseModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Baseline Model Data File!\n"));
                    }
                    #endregion
                    #region control model data
                    if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.futureModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25")
                                    && fieldNameAdd.Contains("cm"))
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                        #endregion
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Daily Forecast Model Data File!\n"));
                    }
                }

                if (_dataInputA.rbtnQuarterlyModelA.Checked)//check quarterly model data
                {
                    #region baseline model data
                    if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.baseModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Baseline file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Baseline file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Baseline Model Data File!\n"));
                    }
                    #endregion
                    #region control model data
                    if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.futureModelFile))
                        {
                            errorTipBuilder.Append(Language.Localization.GetValue("Forecast file path does not exits!\n"));
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                            {
                                errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("crustal")
                                    && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("pm25") && fieldNameAdd.Contains("cm"))
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorTipBuilder.Append(Language.Localization.GetValue("Forecast file is ill-formatted data!\n"));
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorTipBuilder.Append(Language.Localization.GetValue("Please select a Quarterly Forecast Model Data File!\n"));
                    }
                    #endregion
                }
                return errorTips = errorTipBuilder.ToString();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        public string checkBenMAPAnnualPMMonitorInput()
        {
            try
            {
                BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_BenMAP_AnnualPM_MonitorData _dataInputA = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_MonitorData);

                if (CommonClass.unofficialPMFile != null && CommonClass.unofficialPMFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.unofficialPMFile))
                    {
                        errorBuilder.Append("Unofficial Daily Average PM25 Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.unofficialPMFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Unofficial Daily Average PM25 Data File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("pm25")
                                && fieldNameAdd.Contains("epa_flag") && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 8)
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Unofficial Daily Average PM25 Data File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Unofficial Daily Average PM25 Data File can't be empty!\n");
                }

                if (!string.IsNullOrEmpty(errorBuilder.ToString()))
                    return errorTips = errorBuilder.ToString();

                if (Convert.ToInt16(_dataInputA.cboEndYearA.Text) < Convert.ToInt16(_dataInputA.cboStartYearA.Text))
                    errorBuilder.Append(Language.Localization.GetValue("End Year should be later than Start Year!\n"));
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public string checkBenMAPAnnualPMSpeciesInput()
        {
            try
            {
                BenMAPAnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration;
                FileStream fileStream;
                StreamReader streamReader;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                string frequency = "";
                bool ok = false;
                uc_BenMAP_AnnualPM_SpeciesData _dataInputA = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_SpeciesData);

                //check species monitor data file path
                #region
                if (_dataInputA.rbtnMonitorFileA.Checked)
                {
                    if (CommonClass.speciesMonitorFile != null && CommonClass.speciesMonitorFile.Length > 0)
                    {
                        if (!File.Exists(CommonClass.speciesMonitorFile))
                        {
                            errorBuilder.Append("Species Monitor Data File path does not exist!\n");
                        }
                        else
                        {
                            fileStream = new FileStream(CommonClass.speciesMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                            streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                            frequency = streamReader.ReadLine();
                            if (frequency.Trim().ToLower().Replace(",", "") != "day")
                            {
                                errorBuilder.Append("Species Monitor Data File is ill-formatted data!\n");
                            }
                            else
                            {
                                string fieldName = streamReader.ReadLine();
                                string[] fieldNameAdd = new string[] { };
                                if (fieldName != null && fieldName.Length > 0)
                                {
                                    fieldName = fieldName.Replace(" ", "");
                                    fieldName = fieldName.Replace("\"", "");
                                    fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                }
                                if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("so4") && fieldNameAdd.Contains("no3r") && fieldNameAdd.Contains("nh4") && fieldNameAdd.Contains("ocb")
                                    && fieldNameAdd.Contains("ec") && fieldNameAdd.Contains("crustal") && fieldNameAdd.Contains("salt") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("h2o_aim") && fieldNameAdd.Contains("oc") && fieldNameAdd.Contains("no3") && fieldNameAdd.Contains("so4_3s") && fieldNameAdd.Contains("crustal_alt")
                                    && fieldNameAdd.Contains("frm_mass") && fieldNameAdd.Contains("measured_fm") && fieldNameAdd.Contains("rcfm") && fieldNameAdd.Contains("al") && fieldNameAdd.Contains("ca") && fieldNameAdd.Contains("fe") && fieldNameAdd.Contains("ti") && fieldNameAdd.Contains("si") && fieldNameAdd.Contains("epa_flag")
                                    && fieldNameAdd.Contains("user_flag") && fieldNameAdd.Length == 28)
                                {
                                    ok = true;
                                }
                                else
                                {
                                    ok = false;
                                }
                                if (!ok)
                                {
                                    errorBuilder.Append("Species Monitor Data File is ill-formatted data!\n");
                                }
                            }
                            ok = false;
                            fileStream.Dispose();
                            streamReader.Dispose();
                        }
                    }
                    else
                    {
                        errorBuilder.Append("Species Monitor Data File can't be empty!\n");
                    }
                }
                #endregion
                if (_dataInputA.rbtnFractionA.Checked)
                {
                    //check species fractions file-spatial field
                    #region
                    if (annualPMAnalysisConfiguration.monitorInput.useVNA)
                    {
                        if (CommonClass.speciesFractionFilePoint != null && CommonClass.speciesFractionFilePoint.Length > 0)
                        {
                            if (!File.Exists(CommonClass.speciesFractionFilePoint))
                            {
                                errorBuilder.Append("Spatial Field Species Fractions File path does not exist!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.speciesFractionFilePoint, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorBuilder.Append("Spatial Field Species Fractions File is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("gridcell_lat") && fieldNameAdd.Contains("gridcell_long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("pm25_mass_frac")
                                    && fieldNameAdd.Contains("fcr") && fieldNameAdd.Contains("fec") && fieldNameAdd.Contains("fnh4") && fieldNameAdd.Contains("focm") && fieldNameAdd.Contains("fso4")
                                    && fieldNameAdd.Contains("fno3") && fieldNameAdd.Contains("fwater") && fieldNameAdd.Contains("fsalt") && fieldNameAdd.Contains("blank_mass") && fieldNameAdd.Contains("don") && fieldNameAdd.Contains("i_so4")
                                    && fieldNameAdd.Contains("i_no3r") && fieldNameAdd.Contains("i_ocb") && fieldNameAdd.Contains("i_ec") && fieldNameAdd.Contains("i_crustal") && fieldNameAdd.Contains("i_don") && fieldNameAdd.Contains("i_nh4")
                                    && fieldNameAdd.Contains("i_no3") && fieldNameAdd.Contains("i_salt") && fieldNameAdd.Length == 24)
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Spatial Field Species Fractions File is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Spatial Field Species Fractions File can't be empty!\n");
                        }
                    }
                    else if (annualPMAnalysisConfiguration.monitorInput.useEVNA)
                    {
                        if (CommonClass.speciesFractionFileSpatial != null && CommonClass.speciesFractionFileSpatial.Length > 0)
                        {
                            if (!File.Exists(CommonClass.speciesFractionFileSpatial))
                            {
                                errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File path does not exist!\n");
                            }
                            else
                            {
                                fileStream = new FileStream(CommonClass.speciesFractionFileSpatial, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                                streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                                frequency = streamReader.ReadLine();
                                if (frequency.Trim().ToLower().Replace(",", "") != "quarter")
                                {
                                    errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File is ill-formatted data!\n");
                                }
                                else
                                {
                                    string fieldName = streamReader.ReadLine();
                                    string[] fieldNameAdd = new string[] { };
                                    if (fieldName != null && fieldName.Length > 0)
                                    {
                                        fieldName = fieldName.Replace(" ", "");
                                        fieldName = fieldName.Replace("\"", "");
                                        fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                                    }
                                    if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("gridcell_lat") && fieldNameAdd.Contains("gridcell_long") && fieldNameAdd.Contains("quarter") && fieldNameAdd.Contains("pm25_mass_frac_ga") && fieldNameAdd.Contains("fcr_ga") && fieldNameAdd.Contains("fec_ga")
                                        && fieldNameAdd.Contains("fnh4_ga") && fieldNameAdd.Contains("focm_ga") && fieldNameAdd.Contains("fso4_ga") && fieldNameAdd.Contains("fno3_ga") && fieldNameAdd.Contains("fwater_ga") && fieldNameAdd.Contains("fsalt_ga") && fieldNameAdd.Contains("blank_mass_ga")
                                        && fieldNameAdd.Contains("don_ga") && fieldNameAdd.Contains("i_so4_ga") && fieldNameAdd.Contains("i_no3r_ga") && fieldNameAdd.Contains("i_ocb_ga") && fieldNameAdd.Contains("i_ec_ga") && fieldNameAdd.Contains("i_crustal_ga") && fieldNameAdd.Contains("i_don_ga")
                                        && fieldNameAdd.Contains("i_nh4_ga") && fieldNameAdd.Contains("i_no3_ga") && fieldNameAdd.Contains("i_salt_ga") && fieldNameAdd.Length == 24)
                                    {
                                        ok = true;
                                    }
                                    else
                                    {
                                        ok = false;
                                    }
                                    if (!ok)
                                    {
                                        errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File is ill-formatted data!\n");
                                    }
                                }
                                ok = false;
                                fileStream.Dispose();
                                streamReader.Dispose();
                            }
                        }
                        else
                        {
                            errorBuilder.Append("Gradient-adjusted Spatial Field Species Fractions File can't be empty!\n");
                        }
                    }
                    #endregion
                }

                if (!string.IsNullOrEmpty(errorBuilder.ToString()))
                    return errorTips = errorBuilder.ToString();

                if (Convert.ToInt16(_dataInputA.cboEndYearA.Text) < Convert.ToInt16(_dataInputA.cboStartYearA.Text))
                    errorBuilder.Append(Language.Localization.GetValue("End Year should be later than Start Year!\n"));
                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        #endregion

        #region BenMapOzone
        public string checkBenMAPOzoneModel()
        {
            try
            {
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";

                //check model file-baseline
                if (CommonClass.baseModelFile != null && CommonClass.baseModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.baseModelFile))
                    {
                        errorBuilder.Append("Model Baseline File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.baseModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3"))
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Baseline File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Baseline File can't be empty!\n");
                }

                //check model file-forecast
                if (CommonClass.futureModelFile != null && CommonClass.futureModelFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.futureModelFile))
                    {
                        errorBuilder.Append("Model Forecast File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.futureModelFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "day")
                        {
                            errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("date") && fieldNameAdd.Contains("o3"))
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Model Forecast File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Model Forecast File can't be empty!\n");
                }

                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }

        public string checkBenMAPOzoneMonitor()
        {
            try
            {
                bool ok = false;
                StringBuilder errorBuilder = new StringBuilder("");
                string errorTips = "";
                FileStream fileStream;
                StreamReader streamReader;
                string frequency = "";
                //check monitor data file path
                if (CommonClass.ozoneMonitorFile != null && CommonClass.ozoneMonitorFile.Length > 0)
                {
                    if (!File.Exists(CommonClass.ozoneMonitorFile))
                    {
                        errorBuilder.Append("Monitor Data File path does not exist!\n");
                    }
                    else
                    {
                        fileStream = new FileStream(CommonClass.ozoneMonitorFile, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                        streamReader = new StreamReader(fileStream, System.Text.Encoding.UTF8);
                        frequency = streamReader.ReadLine();
                        if (frequency.Trim().ToLower().Replace(",", "") != "designvalue")
                        {
                            errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                        }
                        else
                        {
                            string fieldName = streamReader.ReadLine();
                            string[] fieldNameAdd = new string[] { };
                            if (fieldName != null && fieldName.Length > 0)
                            {
                                fieldName = fieldName.Replace(" ", "");
                                fieldName = fieldName.Replace("\"", "");
                                fieldNameAdd = fieldName.Trim().ToLower().Split(',');
                            }
                            if (fieldNameAdd.Contains("_id") && fieldNameAdd.Contains("_type") && fieldNameAdd.Contains("lat") && fieldNameAdd.Contains("long") && fieldNameAdd.Contains("poc") && fieldNameAdd.Contains("dvyear") && fieldNameAdd.Contains("o3") && fieldNameAdd.Contains("_state_name") && fieldNameAdd.Contains("_county_name"))
                            {
                                ok = true;
                            }
                            else
                            {
                                ok = false;
                            }
                            if (!ok)
                            {
                                errorBuilder.Append("Monitor Data File is ill-formatted data!\n");
                            }
                        }
                        ok = false;
                        fileStream.Dispose();
                        streamReader.Dispose();
                    }
                }
                else
                {
                    errorBuilder.Append("Monitor Data File can't be empty!\n");
                }

                return errorTips = errorBuilder.ToString();
            }
            catch (Exception ex)
            {
                return ex.ToString();
            }
        }
        #endregion


        /// <summary>
        /// Save configuration
        /// </summary>
        public string SaveCurrentUCConfiguration()
        {
            try
            {
                string errorTip = "";
                StringBuilder errorBuilder = new StringBuilder("");
                if (pnlUserControl.Controls.Count == 0)//By Devin, correct the error when choosing to save the current project in the DataView interface when switching languages
                {
                    return errorTip;
                }
                switch (pnlUserControl.Controls[0].Name)
                {
                    #region annual pm
                    case "uc_OutputA":
                        uc_OutputA _outPutA = (pnlUserControl.Controls[0] as uc_OutputA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA = new ChooseDesiredOutputA();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.scenarioName = _outPutA.txtScenarioName.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doStandardAnalysis = _outPutA.choStandardAnalysisA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doQuarterlyModelData = _outPutA.choQuarterlyModelDataA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doUsedQuarterlyAvgModelData = _outPutA.choQuarterlyModelDataUsedA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doSpeciesFraction = _outPutA.choSpeciesFractionOutputA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doAutomaticallyExtract = _outPutA.choActionsCompletionA.Checked;
                        break;
                    case "uc_OutputAdvancedA":
                        uc_OutputAdvancedA _outputAdvancedA = (pnlUserControl.Controls[0] as uc_OutputAdvancedA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA = new OutputChoiceAdvancedA();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj = _outputAdvancedA.choIFRMSpeA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyVNA = _outputAdvancedA.choBaseOnlyVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyVNA = _outputAdvancedA.choFutureOnlyVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj = _outputAdvancedA.choIAdjustedFRMSpeA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyEvna = _outputAdvancedA.choBaseOnlyEvna.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyEvna = _outputAdvancedA.choFutureOnlyEvna.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFilePoint = _outputAdvancedA.choQuaPointA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial = _outputAdvancedA.choQuaSpatialA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_GraAdj = _outputAdvancedA.choQuaSpaGraAdjA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doHighCountySites = _outputAdvancedA.choFileCA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial = _outputAdvancedA.choSpeSpatialFieldA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj = _outputAdvancedA.choSpeSpaGraAdjA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgSpeciatedMonitors = _outputAdvancedA.choFileEA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doDesignValuePeriods = _outputAdvancedA.choDVPeriods.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doNeighborFilePoint = _outputAdvancedA.choNeiPointA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doNeighborFileSpatial = _outputAdvancedA.choNeiSpatialA.Checked;

                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doDS = _outputAdvancedA.chkDS.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyDS = _outputAdvancedA.chkDSOnlyBase.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyDS = _outputAdvancedA.chkDSOnlyFuture.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Burn = Convert.ToInt32(_outputAdvancedA.txtDSBurn.Text);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Cmaqres = Convert.ToInt32(_outputAdvancedA.txtDSCmaqres.Text);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Thin = Convert.ToInt32(_outputAdvancedA.txtDSThin.Text);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Numit = Convert.ToInt32(_outputAdvancedA.txtDSNumit.Text);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_DS = _outputAdvancedA.choQuaSpaDSA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial_DS = _outputAdvancedA.choSpeSpaDSA.Checked;

                        break;
                    case "uc_DataInputA":
                        uc_DataInputA _dataInputA = (pnlUserControl.Controls[0] as uc_DataInputA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA = new DataInputA();
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile = CommonClass.speciesMonitorFile;
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.officialMonitorDataFile == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.officialMonitorDataFile = CommonClass.officialPMFile;
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile = CommonClass.unofficialPMFile;

                        //Bind improve-stn monitor data year in the categories fraction calculations form, from 'specifications -for-fractions-0206-v2 CSV 'file
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears == null || CommonClass.speciesMonitorFile != (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile)
                        {
                            WaitShow(Language.Localization.GetValue("working..."));
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.speciesMonitorFile);
                            if (lstYears == null)
                                errorBuilder.Append("Fail to read data \"" + Path.GetFileName(CommonClass.speciesMonitorFile) + "\"");
                            else
                            {
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears = new List<string>();
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile = CommonClass.speciesMonitorFile;
                                foreach (string item in lstYears)
                                {
                                    (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears.Add(item);
                                }
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears.Sort();
                            }
                        }
                        //Bind PM25 monitor data years in the categories fraction calculations form from 'PM25 for fractions-0206-v3 CSV 'file
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears == null || CommonClass.unofficialPMFile != (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile)
                        {
                            WaitChangeMsg(Language.Localization.GetValue("working..."));
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.unofficialPMFile);
                            if (lstYears == null)
                                errorBuilder.Append("Fail to read data \"" + Path.GetFileName(CommonClass.unofficialPMFile) + "\"");
                            else
                            {
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears = new List<string>();
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile = CommonClass.unofficialPMFile;
                                foreach (string item in lstYears)
                                {
                                    (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears.Add(item);
                                }
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears.Sort();
                            }
                        }
                        //}
                        //Bind PM25 monitors data years in PM25 calculations options form, from 'annual-official-frm-99-08-v2 CSV 'file
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears == null || CommonClass.officialPMFile != (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.officialMonitorDataFile)
                        {
                            WaitChangeMsg(Language.Localization.GetValue("working..."));
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.officialPMFile);
                            if (lstYears == null)
                                errorBuilder.Append("Fail to read data \"" + Path.GetFileName(CommonClass.officialPMFile) + "\"");
                            else
                            {
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears = new List<string>();
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.officialMonitorDataFile = CommonClass.officialPMFile;
                                foreach (string item in lstYears)
                                {
                                    (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Add(item);
                                }
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Sort();
                            }
                        }
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doSpeciesMonitorDataFile = _dataInputA.rbtnMonitorFileA.Checked;
                        //(CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile = CommonClass.speciesMonitorFile == null ? "" : CommonClass.speciesMonitorFile;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doSpeciesFractionFile = _dataInputA.rbtnFractionA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.specFracModePoint = _dataInputA.cboPointA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.specFracPointFile = CommonClass.speciesFractionFilePoint == null ? "" : CommonClass.speciesFractionFilePoint;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.specFracModeSpatial = _dataInputA.cboSpatialA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.specFracSpatialFile = CommonClass.speciesFractionFileSpatial == null ? "" : CommonClass.speciesFractionFileSpatial;
                        //(CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile = CommonClass.unofficialPMFile == null ? "" : CommonClass.unofficialPMFile;
                        //(CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.officialMonitorDataFile = CommonClass.officialPMFile == null ? "" : CommonClass.officialPMFile;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doDailyModelDataInput = _dataInputA.rbtnDailyModelA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doQuarterlyModelDataInput = _dataInputA.rbtnQuarterlyModelA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doInputFromCmaq = _dataInputA.rbtnCMAQA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.forecastModelDataFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                        WaitClose();
                        break;
                    case "uc_SpeciesFractionsCalculationOptionsA":
                        uc_SpeciesFractionsCalculationOptionsA _speciesFractionOptionsA = (pnlUserControl.Controls[0] as uc_SpeciesFractionsCalculationOptionsA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA = new SpeciesFractionOptionsA();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_StartYear = _speciesFractionOptionsA.cboIMPROVEStartYaerA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_EndYear = _speciesFractionOptionsA.cboIMPROVEEndYaerA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_EPADeletionChoice = _speciesFractionOptionsA.choIMPROVEEPADeletionsA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_UserDeletionChoice = _speciesFractionOptionsA.choIMPROVEUserDeletionA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinDays = Convert.ToInt32(_speciesFractionOptionsA.nudownIMPROVEMinDaysA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinYear = Convert.ToInt32(_speciesFractionOptionsA.nudownIMPROVEMinYearsA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinSeasons = Convert.ToInt32(_speciesFractionOptionsA.nudownIMPROVEMinSeasonsA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialStartYear = _speciesFractionOptionsA.cboPMStartYaerA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialEndYear = _speciesFractionOptionsA.cboPMEndYaerA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialEPADeletionChoice = _speciesFractionOptionsA.choPMEPADeletionsA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialUserDeletionChoice = _speciesFractionOptionsA.choPMUserDeletionA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinDays = Convert.ToInt32(_speciesFractionOptionsA.nudownPMMinDaysA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinYears = Convert.ToInt32(_speciesFractionOptionsA.nudownPMMinYearsA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinSeasonsPoint = Convert.ToInt32(_speciesFractionOptionsA.nudownPMMinPointA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinSeasonsSpatial = Convert.ToInt32(_speciesFractionOptionsA.nudownPMMinSpatialA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.doAdvancedOptionsForSpeciesFraction = _speciesFractionOptionsA.choAdvancedOptions.Checked;
                        #region species fraction advanced
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodPM25 = _speciesFractionOptionsA.cboItpPM25A.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distancePM25 = Convert.ToInt64(_speciesFractionOptionsA.nudownPM25DistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodSO4 = _speciesFractionOptionsA.cboItpSO4A.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceSO4 = Convert.ToInt64(_speciesFractionOptionsA.nudownSO4DistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodNO3 = _speciesFractionOptionsA.cboItpNO3A.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceNO3 = Convert.ToInt64(_speciesFractionOptionsA.nudownNO3DistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodEC = _speciesFractionOptionsA.cboItpECA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceEC = Convert.ToInt64(_speciesFractionOptionsA.nudownECDistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodSalt = _speciesFractionOptionsA.cboItpSaltA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceSalt = Convert.ToInt64(_speciesFractionOptionsA.nudownSaltDistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodCrustal = _speciesFractionOptionsA.cboItpCrustalA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceCrustal = Convert.ToInt64(_speciesFractionOptionsA.nudownCrustalDistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodDON = _speciesFractionOptionsA.cboItpDONA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceDON = Convert.ToInt64(_speciesFractionOptionsA.nudownDONDistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodOC = _speciesFractionOptionsA.cboItpOCA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceOC = Convert.ToInt64(_speciesFractionOptionsA.nudownOCDistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodNH4 = _speciesFractionOptionsA.cboItpNH4A.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceNH4 = Convert.ToInt64(_speciesFractionOptionsA.nudownNH4DistanceA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.doUseDonValues = _speciesFractionOptionsA.rbtnDONA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.doUseAmmoniumValues = _speciesFractionOptionsA.rbtnMeasuredA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.nh4PercentageEvaporating = Convert.ToInt32(_speciesFractionOptionsA.nudownNH4PercentageA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.defaultBlankMass = _speciesFractionOptionsA.nudownDefaultMassA.Value;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.floorOCMMB = _speciesFractionOptionsA.nudownOCmbFloorA.Value;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.ceilingOCMMB = _speciesFractionOptionsA.nudownOCmbCeilingA.Value;
                        #endregion
                        break;
                    case "uc_PM25CalculationOptionsA":
                        uc_PM25CalculationOptionsA _pmCalculationA = (pnlUserControl.Controls[0] as uc_PM25CalculationOptionsA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA = new PM25CalculationOptionsA();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.officialPM25StartYear = _pmCalculationA.cboStartYearA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.officialPM25EndYear = _pmCalculationA.cboEndYearA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.choiceOfficialDV = _pmCalculationA.rbtnOfficialA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.choiceCustomDV = _pmCalculationA.rbtnCustomA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minDaysForValidFRMQuarters = Convert.ToInt32(_pmCalculationA.nudownMinDaysA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minQuartersForValidFRMDesignValues = Convert.ToInt32(_pmCalculationA.nudownMinQuarterA.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minNumDVPeriodsForValidFRMMonitors = Convert.ToInt32(_pmCalculationA.nudownMinNumDV.Value);
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors = _pmCalculationA.txtRequiredA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.doCalcNH4fromDON = _pmCalculationA.rbtnNH4DONA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.doCalcNH4fromRRF = _pmCalculationA.rbtnNH4RRFA.Checked;
                        break;
                    case "uc_ModelDataA":
                        uc_ModelDataA _modelDataA = (pnlUserControl.Controls[0] as uc_ModelDataA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA = new ModelDataOptionsA();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA.temporalAdjustmentAtMonitorGrid = _modelDataA.cboPointGridA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA.temporalAdjustmentAtMonitorGridSpatial = _modelDataA.cboSpatialGridA.Text;
                        break;
                    case "uc_OutputD":
                        uc_OutputD _outputD = (pnlUserControl.Controls[0] as uc_OutputD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD = new ChooseDesiredOutputD();
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.scenarioName = _outputD.txtScenarioNameDily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doStandardAnalysis = _outputD.choStandardAnalysisD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doQuarterlyPeakModelData = _outputD.choQuarterlyPeakModelDataD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doSpeciesFraction = _outputD.choSpeciesFractionsFileD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doAutomaticallyExtract = _outputD.choActionsExtractAllD.Checked;
                        break;
                    #endregion
                    #region daily pm
                    case "uc_OutputAdvancedD":
                        uc_OutputAdvancedD _outputAdvancedD = (pnlUserControl.Controls[0] as uc_OutputAdvancedD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD = new OutputChoiceAdvancedD();
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakFilesPoint = _outputAdvancedD.choQuarterlyAvgFilePointD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doHighCountySites = _outputAdvancedD.choFileCD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakSpeciatedMonitors = _outputAdvancedD.choFileED.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doDesignValuePeriods = _outputAdvancedD.choDVPeriodsD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doNeighborFilePoint = _outputAdvancedD.choNeighborFilePointD.Checked;
                        break;
                    #region dian
                    case "uc_DataInputD":
                        uc_DataInputD _dataInputD = (pnlUserControl.Controls[0] as uc_DataInputD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD = new DataInputD();
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.speciesMonitorDataFile == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.speciesMonitorDataFile = CommonClass.speciesMonitorFile;
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.officialMonitorFile == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.officialMonitorFile = CommonClass.officialPMFile;
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.unofficialMonitorFile == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.unofficialMonitorFile = CommonClass.unofficialPMFile;
                        //Bind improve-stn monitor data year in the categories fraction calculations form, from 'specifications -for-fractions-0206-v2 CSV 'file
                        //test dian
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears == null || CommonClass.speciesMonitorFile != (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.speciesMonitorDataFile)
                        {
                            WaitShow(Language.Localization.GetValue("working..."));
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.speciesMonitorFile);
                            if (lstYears == null)
                                errorBuilder.Append("Fail to read data \"" + Path.GetFileName(CommonClass.speciesMonitorFile) + "\"");
                            else
                            {
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears = new List<string>();
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.speciesMonitorDataFile = CommonClass.speciesMonitorFile;
                                foreach (string item in lstYears)
                                { (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears.Add(item); }
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears.Sort();
                            }
                        }
                        //---pm-for-fractions--------------unofficial pm25----------
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears == null || CommonClass.unofficialPMFile != (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.unofficialMonitorFile)
                        {
                            WaitChangeMsg(Language.Localization.GetValue("working..."));
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.unofficialPMFile);
                            if (lstYears == null)
                                errorBuilder.Append("Fail to read data \"" + Path.GetFileName(CommonClass.unofficialPMFile) + "\"");
                            else
                            {
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears = new List<string>();
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.unofficialMonitorFile = CommonClass.unofficialPMFile;
                                foreach (string item in lstYears)
                                { (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears.Add(item); }
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears.Sort();
                            }

                        }
                        //---------offcial-annual-pm25-----------
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears == null || CommonClass.officialPMFile != (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.officialMonitorFile)
                        {
                            WaitChangeMsg(Language.Localization.GetValue("working..."));
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.officialPMFile);
                            if (lstYears == null)
                                errorBuilder.Append("Fail to read data \"" + Path.GetFileName(CommonClass.officialPMFile) + "\"");
                            else
                            {
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears = new List<string>();
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.officialMonitorFile = CommonClass.officialPMFile;
                                foreach (string item in lstYears)
                                { (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Add(item); }
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Sort();
                            }
                        }
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doSpeciesMonitorDataFile = _dataInputD.rbtnSpeciesMonitorD.Checked;
                        //(CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.speciesMonitorDataFile = CommonClass.speciesMonitorFile == null ? "" : CommonClass.speciesMonitorFile;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doSpeciesFractionFile = _dataInputD.rbtnSpeciesFractionD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.specFracModePoint = _dataInputD.cboSpeciesFractionsPointD.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.specFracModeSpatial = _dataInputD.cboSpeciesFractionsSpatialD.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.specFracPointFile = CommonClass.speciesFractionFilePoint == null ? "" : CommonClass.speciesFractionFilePoint;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.specFracSpatialFile = CommonClass.speciesFractionFileSpatial == null ? "" : CommonClass.speciesFractionFileSpatial;
                        //(CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.unofficialMonitorFile = CommonClass.unofficialPMFile == null ? "" : CommonClass.unofficialPMFile;
                        //(CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.officialMonitorFile = CommonClass.officialPMFile == null ? "" : CommonClass.officialPMFile;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doDailyModelDataInput = _dataInputD.rbtnDailyModelDataD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doQuarterlyPeakModelDataInput = _dataInputD.rbtnQuarterlyPeakModelDataD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.doInputfromCmaq = _dataInputD.rbtnCMAQFileD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.baselineModelFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.forecastModelFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                        WaitClose();
                        break;
                    #endregion
                    case "uc_SpeciesFrctionD":
                        uc_SpeciesFrctionD _speciesFractionsD = (pnlUserControl.Controls[0] as uc_SpeciesFrctionD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD = new SpeciesFractionOptionsD();
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_StartYear = _speciesFractionsD.cboIMPROVEMonitorStartYearDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_EndYear = _speciesFractionsD.cboIMPROVEMonitorEndYearDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_EPADeletionChoice = _speciesFractionsD.choEPASpecifiedIMPROVEDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_UserDeletionChoice = _speciesFractionsD.choUserSpecifiedIMPROVEDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinDays = Convert.ToInt32(_speciesFractionsD.nudownMinDaysIMPROVEDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinQuarters = Convert.ToInt32(_speciesFractionsD.nudownMinQuartersIMPROVEDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinYear = Convert.ToInt32(_speciesFractionsD.nudownMinYearsIMPROVEDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialStartYear = _speciesFractionsD.cboPMMonitorStartYearDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialEndYear = _speciesFractionsD.cboPMMonitorEndYearDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialEPADeletionChoice = _speciesFractionsD.choEPASpecifiedPMDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialUserDeletionChoice = _speciesFractionsD.choUserSpecifiedPMDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinDays = Convert.ToInt32(_speciesFractionsD.nudownMinDaysPMDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinQuartersPoint = Convert.ToInt32(_speciesFractionsD.nudownMinQuartersPMDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinYears = Convert.ToInt32(_speciesFractionsD.nudownMinYearsPMDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.doAdvancedOptionsForSpeciesFraction = _speciesFractionsD.choAdvancedOptions.Checked;

                        #region advanced options
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoTopXPercent = _speciesFractionsD.rbtnTopPercMonitorIMPROVEDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_TopXPercent = Convert.ToInt32(_speciesFractionsD.nudownTopPercMonitorIMPROVEDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan = _speciesFractionsD.rbtnAllMonitorGreaterIMPROVEDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_UseAlldailyMonitorValuesGreaterThan = Convert.ToInt32(_speciesFractionsD.nudownAllMonitorGreaterIMPROVEDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount = Convert.ToInt32(_speciesFractionsD.nudownMinNumAboveIMPROVEDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoUseTopXNumber = _speciesFractionsD.rbtnTopNumMonitorIMPROVEDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_UseTopXNumber = Convert.ToInt32(_speciesFractionsD.nudownTopNumMonitorIMPROVEDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoTopXPercent = _speciesFractionsD.rbtnTopPercMonitorPMDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_TopXPercent = Convert.ToInt32(_speciesFractionsD.nudownTopPercMonitorPMDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan = _speciesFractionsD.rbtnAllMonitorGreaterPMDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_UseAlldailyMonitorValuesGreaterThan = Convert.ToInt32(_speciesFractionsD.nudownAllMonitorGreaterPMDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount = Convert.ToInt32(_speciesFractionsD.nudownMinNumAbovePMDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoTopXNumber = _speciesFractionsD.rbtnTopNumMonitorPMDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_TopXNumber = Convert.ToInt32(_speciesFractionsD.nudownTopNumMonitorPMDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodPM25 = _speciesFractionsD.cboPM25InterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodSO4 = _speciesFractionsD.cboSO4InterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodNO3 = _speciesFractionsD.cboNO3InterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodEC = _speciesFractionsD.cboECInterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodSalt = _speciesFractionsD.cboSaltInterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodCrustal = _speciesFractionsD.cboCrastalInterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodDON = _speciesFractionsD.cboDONInterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodOC = _speciesFractionsD.cboOCInterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodNH4 = _speciesFractionsD.cboNH4InterpolationDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distancePM25 = Convert.ToInt64(_speciesFractionsD.nudownPM25DistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceSO4 = Convert.ToInt64(_speciesFractionsD.nudownSO4DistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceNO3 = Convert.ToInt64(_speciesFractionsD.nudownNO3DistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceEC = Convert.ToInt64(_speciesFractionsD.nudownECDistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceSalt = Convert.ToInt64(_speciesFractionsD.nudownSaltDistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceCrustal = Convert.ToInt64(_speciesFractionsD.nudownCrustalDistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceDON = Convert.ToInt64(_speciesFractionsD.nudownDONDistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceOC = Convert.ToInt64(_speciesFractionsD.nudownOCDistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceNH4 = Convert.ToInt64(_speciesFractionsD.nudownNH4DistanceDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.doUseDonValues = _speciesFractionsD.rbtnDONValueDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.doUseMeasuredAmmonium = _speciesFractionsD.rbtnMeasuredAmmoniumDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.nh4PercentageEvaporating = Convert.ToInt32(_speciesFractionsD.nudownNH4PercDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.defaultBlankMass = Convert.ToDecimal(_speciesFractionsD.nudownDefaultBMDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.floorOCMMB = Convert.ToDecimal(_speciesFractionsD.nudownOCmbFloorDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.ceilingOCMMB = Convert.ToDecimal(_speciesFractionsD.nudownOCmbCeilingDaily.Value);
                        #endregion
                        break;
                    case "uc_PM25CalculationD":
                        uc_PM25CalculationD _pmCalculationD = (pnlUserControl.Controls[0] as uc_PM25CalculationD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD = new PM25CalculationOptionsD();
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.officialPM25StartYear = _pmCalculationD.cboStartYearD.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.officialPM25EndYear = _pmCalculationD.cboEndYearD.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.minNumDVPeriodsForValidFRMMonitors = Convert.ToInt32(_pmCalculationD.nudownMinNumDVD.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors = _pmCalculationD.txtRequiredDVD.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.doCalcNH4fromDON = _pmCalculationD.rbtnCalculateNH4byDON.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.doCalcNH4fromRRF = _pmCalculationD.rbtnCalculateNH4byRRF.Checked;
                        break;
                    case "uc_ModelDataD":
                        uc_ModelDataD _modelDataD = (pnlUserControl.Controls[0] as uc_ModelDataD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD == null)
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD = new ModelDataOptionsD();
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentAtMonitorGridPoint = _modelDataD.cboGridPointModelOptionDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentAtMonitorGridSpatial = _modelDataD.choGridforSpatialForecast.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentType = _modelDataD.cboStatisticMethodDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseXTopPercent = _modelDataD.rbtnTopPerceRRFDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseXTopPercent = Convert.ToInt32(_modelDataD.nudownTopPerceRRFDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount = Convert.ToInt32(_modelDataD.nudownMinNumDaysGreaterRRFDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseTopXNumber = _modelDataD.rbtnTopNumRRFDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseTopXNumber = Convert.ToInt32(_modelDataD.nudownTopNumRRFDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseAllModelDaysGreaterThan = Convert.ToInt32(_modelDataD.nudownAllDailyGreaterRRFDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseAllModelDaysGreaterThan = _modelDataD.rbtnAllDailyGreaterRRFDaily.Checked;
                        break;
                    #endregion
                    #region ozone
                    case "uc_DesiredOutputOzone":
                        uc_DesiredOutputOzone _outputO = (pnlUserControl.Controls[0] as uc_DesiredOutputOzone);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO == null)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO = new ChooseDesiredOutputO();
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.scenarioName = _outputO.txtScenarioOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doPointEstimatesForecast = _outputO.choPointForecastOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doQuarterlyModelData = _outputO.choQuarterlyModelData.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates = _outputO.choSpatialOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj = _outputO.choSpatialGradAdjOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyVNA = _outputO.choBaseOnlyVNAOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA = _outputO.choFutureOnlyVNAOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyEVNA = _outputO.choBaseOnlyEvnaOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doDownscaler = _outputO.chkDS.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSBaseOnly = _outputO.chkDSOnlyBase.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSFutureOnly = _outputO.chkDSOnlyFuture.Checked;

                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSBurn = Convert.ToInt16(_outputO.txtDSBurn.Text);
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSCmaqres = Convert.ToInt16(_outputO.txtDSCmaqres.Text);
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSNumit = Convert.ToInt16(_outputO.txtDSNumit.Text);
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSThin = Convert.ToInt16(_outputO.txtDSThin.Text);

                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA = _outputO.choFutureOnlyEvnaOzone.Checked;
                        //(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesForecast = _outputO.choSpatialForecastOzone.Checked;
                        //(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesForecastGradAdj = _outputO.choSpatialGradAdjForecastOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doNeighborFileSpatial = _outputO.choNeighborFileSpatial.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doAutomaticallyExtract = _outputO.choExtractAllOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doDesignValuePeriods = _outputO.choDVPeriods.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doMaxDesignValuePeriods = _outputO.choMaxDVPeriods.Checked;
                        break;
                    case "uc_DataInputOzone":
                        uc_DataInputOzone _dataInputO = (pnlUserControl.Controls[0] as uc_DataInputOzone);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO == null)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO = new DataInputO();
                        #region added by devin 20120915
                        //Bind the monitor data year in the filtering/interpolation form from 'ozone'_ SMAT_ CE_ input_ 9908-v2.CSV 'file
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData == null || CommonClass.ozoneMonitorFile != (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.ozoneMonitorDataFile)
                        {
                            WaitShow(Language.Localization.GetValue("working..."));
                            List<string> lstYears = CommonClass.getListYearsFromCSV(CommonClass.ozoneMonitorFile);
                            if (lstYears == null)
                                errorBuilder.Append("Fail to read data \"" + Path.GetFileName(CommonClass.ozoneMonitorFile) + "\"");
                            else
                            {
                                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData = new List<string>();
                                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.ozoneMonitorDataFile = CommonClass.ozoneMonitorFile;
                                foreach (string item in lstYears)
                                {
                                    (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData.Add(item);
                                }
                                //ds = CommonClass.getDataSetFromCSVAndFirstLine((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.ozoneDataFile, ref refString);
                                //foreach (DataRow dr in ds.Tables[0].Rows)
                                //{
                                //    (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData.Add(dr["DVYEAR"].ToString());
                                //}
                                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData.Distinct().ToList();
                                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData.Sort();

                            }
                            //ds.Dispose();
                        }
                        #endregion
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.ozoneMonitorDataFile = CommonClass.ozoneMonitorFile;
                        //(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.ozoneMonitorDataFile = CommonClass.ozoneMonitorFile == null ? "" : CommonClass.ozoneMonitorFile;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.doInputfromCmaq = _dataInputO.cboCMAQOzone.Checked;
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays <= 0 || CommonClass.baseModelFile != (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.baselineModelDataFile)
                        {
                            int maxOzoneDays = CommonClass.getOzoneModelMaxDays(CommonClass.baseModelFile);
                            if (maxOzoneDays <= 0)
                                errorBuilder.Append("Fail to read data \"" + Path.GetFileName(CommonClass.baseModelFile) + "\"");
                            else
                                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays = maxOzoneDays;
                        }
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.forecastModelDataFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.temporalAdjustmentAtMonitorGrid = _dataInputO.cboGridOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.temporalAdjustmentType = _dataInputO.cboStatisticOzone.Text;
                        WaitClose();
                        break;
                    case "uc_FilteringorInterpolationOzone":
                        uc_FilteringorInterpolationOzone _filteringInterpolationO = (pnlUserControl.Controls[0] as uc_FilteringorInterpolationOzone);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO == null)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO = new FilteringInterpolationO();
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.ozoneStartYear = _filteringInterpolationO.cboStartYearOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.ozoneEndYear = _filteringInterpolationO.cboEndYearOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.minNumDV = Convert.ToInt32(_filteringInterpolationO.nudownMinNumDVO.Value);
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.requiredDVPeriods = _filteringInterpolationO.txtRequiredDVOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.defaultInterpolationMethod = _filteringInterpolationO.cboDefaultItpOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.doCheckToSetMaxDistance = _filteringInterpolationO.choMaxItpDistanceOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.maxDistance = Convert.ToInt32(_filteringInterpolationO.nudownMaxItpDistanceOzone.Value);
                        break;
                    case "uc_RRForSpatialGradientOzone":
                        uc_RRForSpatialGradientOzone _rrfO = (pnlUserControl.Controls[0] as uc_RRForSpatialGradientOzone);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO == null)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO = new RRFSpatialGradientO();
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.useInitialThreshold = _rrfO.rbtnInitial.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.initialThresholdValue = _rrfO.txtInitialValueOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minNumofDaysAtorAboveThreshold = _rrfO.txtAboveThresholdOzone.Text;
                        int i = 0;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.topXDays = int.TryParse(_rrfO.txtTopX.Text, out i) ? i : 0;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minAllowableThresholdValue = _rrfO.txtAllowableValueOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minNumDaysAtorAboveMinAllowableThreshold = _rrfO.txtAboveAllowableThresholdOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.doBackstop = _rrfO.choEnableBackstopOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.backstopMinThresholdforSpatialField = _rrfO.txtBackstopMinOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.subrangeFirstDay = Convert.ToInt32(_rrfO.nudownSubrangeFirstOzone.Value);
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.subrangeLastDay = Convert.ToInt32(_rrfO.nudownSubrangeLastOzone.Value);
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.doPairDays = _rrfO.choPairDaysOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.SRF_StartValue = _rrfO.txtStartValueOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.SRF_EndValue = _rrfO.txtEndValueOzone.Text;
                        break;
                    #endregion
                    #region visibility
                    case "uc_ChooseDesiredOutputV":
                        uc_ChooseDesiredOutputV _outputV = (pnlUserControl.Controls[0] as uc_ChooseDesiredOutputV);
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV == null)
                            (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV = new ChooseDesiredOutputV();
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.scenarioName = _outputV.txtScenarioNameVisibility.Text;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.doTemporallyAdjVisibilityLevelsForecast = _outputV.choVisibilityLevels.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm = _outputV.rbtnOldIMPROVEAlgorithmVisibility.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseNewVersionforIMPROVEAlgorithm = _outputV.rbtnNewIMPROVEAlgorithmVisibility.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseModelGridCellAtMonitor = _outputV.rbtnModelGridCellatMonitorVisi.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseModelGridCellatClassIAreaCentroid = _outputV.rbtnModelGridCellatClass1Visi.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.doAutomaticallyExtract = _outputV.choExtractAllVisibility.Checked;
                        break;
                    case "uc_DataInputV":
                        uc_DataInputV _dataInputV = (pnlUserControl.Controls[0] as uc_DataInputV);
                        WaitShow(Language.Localization.GetValue("working..."));
                        string msg = _dataInputV.SaveDataInputV();
                        if (msg != "")
                        {
                            errorBuilder.Append(msg + "\"");
                        }
                        //WaitClose();
                        while (!sFlog)
                        {
                            WaitClose();
                        }
                        break;
                    case "uc_FilteringV":
                        uc_FilteringV _filteringV = (pnlUserControl.Controls[0] as uc_FilteringV);
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV == null)
                            (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV = new FilteringV();
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.startMonitorYear = _filteringV.cboStartYearVisibility.Text;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.endMonitorYear = _filteringV.cboEndYearVisibility.Text;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.baseModelYear = _filteringV.cboBaseYearVisibility.Text;
                        (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.minYearsForValidVisibilityMonitors = _filteringV.txtMinYearVisibility.Text;
                        break;
                    #endregion
                    #region SSIA
                    case "uc_AnalysisOption":
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                        {
                            uc_AnalysisOption _AnalysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA == null)
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA = new SSIAAnalysisOption();
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.scenarioName = _AnalysisOption.txtScenarioName.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelData = _AnalysisOption.choUseModelData.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData = _AnalysisOption.choUseModelFRMData.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion = _AnalysisOption.rbtnGridAndDispersion.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly = _AnalysisOption.rbtnGridOnly.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly = _AnalysisOption.rbtnDispersionOnly.Checked;
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null && _AnalysisOption.rbtnDispersionOnly.Checked)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.useVNA = true;
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.useEVNA = false;
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                        {
                            uc_AnalysisOption _AnalysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD == null)
                                (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD = new SSIAAnalysisOption();
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.scenarioName = _AnalysisOption.txtScenarioName.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelData = _AnalysisOption.choUseModelData.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData = _AnalysisOption.choUseModelFRMData.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion = _AnalysisOption.rbtnGridAndDispersion.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly = _AnalysisOption.rbtnGridOnly.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly = _AnalysisOption.rbtnDispersionOnly.Checked;
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                        {
                            uc_AnalysisOption _AnalysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO == null)
                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO = new SSIAAnalysisOption();
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.scenarioName = _AnalysisOption.txtScenarioName.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelData = _AnalysisOption.choUseModelData.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData = _AnalysisOption.choUseModelFRMData.Checked;
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)    //added by K.B.
                        {
                            uc_AnalysisOption _AnalysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep == null)
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep = new SSIAAnalysisOption();
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName = _AnalysisOption.txtScenarioName.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelData = _AnalysisOption.choUseModelData.Checked;
                            /*(CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelFRMData = _AnalysisOption.choUseModelFRMData.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useGridAndDispersion = _AnalysisOption.rbtnGridAndDispersion.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useGridOnly = _AnalysisOption.rbtnGridOnly.Checked;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useDispersionOnly = _AnalysisOption.rbtnDispersionOnly.Checked;
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).monitorInputDep != null && _AnalysisOption.rbtnDispersionOnly.Checked)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).monitorInputDep.useVNA = true;
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).monitorInputDep.useEVNA = false;
                            }*/
                        }
                        break;
                    case "uc_ModelDataInputA":
                        uc_ModelDataInputA _modelDataInput = (pnlUserControl.Controls[0] as uc_ModelDataInputA);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA == null)
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA = new SSIAModelDataInputA();
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.DailyModelDataInput = _modelDataInput.rbtnDailyModelA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.QuarterlyModelDataInput = _modelDataInput.rbtnQuarterlyModelA.Checked;
                        //(CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.InputFromCMAQ = _modelDataInput.rbtnCMAQA.Checked;
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile = CommonClass.dispersionModelFile == null ? "" : CommonClass.dispersionModelFile;
                        }
                        else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile = null;
                        }
                        else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile = null;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile = null;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile = CommonClass.dispersionModelFile == null ? "" : CommonClass.dispersionModelFile;
                        }

                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.SourceCoordinateFile = CommonClass.ssiasourcefile == null ? "" : CommonClass.ssiasourcefile;
                        break;
                    case "uc_MonitorDataInputA":
                        uc_MonitorDataInputA _monitorDataInput = (pnlUserControl.Controls[0] as uc_MonitorDataInputA);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA == null)
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA = new SSIAMonitorDataInputA();
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.officialMonitorDataFile = CommonClass.officialPMFile == null ? "" : CommonClass.officialPMFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.monitorDataStartYear = _monitorDataInput.cboStartYearA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.monitorDataEndYear = _monitorDataInput.cboEndYearA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.useVNA = _monitorDataInput.choVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.useEVNA = _monitorDataInput.choEVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.temporalAdjustmentAtMonitorGrid = _monitorDataInput.cboPointGridA.Text;
                        break;
                    case "uc_ModelDataInputD":
                        uc_ModelDataInputD _modelDataInputD = (pnlUserControl.Controls[0] as uc_ModelDataInputD);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD == null)
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD = new SSIAModelDataInputD();
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.DailyModelDataInput = _modelDataInputD.rbtnDailyModelDataD.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.QuarterlyModelDataInput = _modelDataInputD.rbtnQuarterlyPeakModelDataD.Checked;
                        //(CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.InputFromCMAQ = _modelDataInputD.rbtnCMAQFileD.Checked;
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile = CommonClass.dispersionModelFile == null ? "" : CommonClass.dispersionModelFile;
                        }
                        else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile = null;
                        }
                        else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile = null;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile = null;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile = CommonClass.dispersionModelFile == null ? "" : CommonClass.dispersionModelFile;
                        }
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentAtMonitorGridPoint = _modelDataInputD.cboGridPointModelOptionDaily.Text;
                        //(CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentAtMonitorGridSpatial = _modelDataInputD.cboGridforSpatialForecast.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentType = _modelDataInputD.cboStatisticMethodDaily.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseXTopPercent = _modelDataInputD.rbtnTopPerceRRFDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseXTopPercent = Convert.ToInt32(_modelDataInputD.nudownTopPerceRRFDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount = Convert.ToInt32(_modelDataInputD.nudownMinNumDaysGreaterRRFDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseTopXNumber = _modelDataInputD.rbtnTopNumRRFDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseTopXNumber = Convert.ToInt32(_modelDataInputD.nudownTopNumRRFDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseAllModelDaysGreaterThan = Convert.ToInt32(_modelDataInputD.nudownAllDailyGreaterRRFDaily.Value);
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseAllModelDaysGreaterThan = _modelDataInputD.rbtnAllDailyGreaterRRFDaily.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile = CommonClass.dispersionModelFile == null ? "" : CommonClass.dispersionModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.SourceCoordinateFile = CommonClass.ssiasourcefile == null ? "" : CommonClass.ssiasourcefile;
                        break;
                    case "uc_MonitorDataInputD":
                        uc_MonitorDataInputD _monitorDataInputD = (pnlUserControl.Controls[0] as uc_MonitorDataInputD);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD == null)
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD = new SSIAMonitorDataInputD();
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.officialMonitorDataFile = CommonClass.officialPMFile == null ? "" : CommonClass.officialPMFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.monitorDataStartYear = _monitorDataInputD.cboStartYearD.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.monitorDataEndYear = _monitorDataInputD.cboEndYearD.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.useVNA = _monitorDataInputD.choVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.useEVNA = _monitorDataInputD.choEVNA.Checked;

                        break;
                    case "uc_ModelDataInputO":
                        uc_ModelDataInputO _modelDataInputO = (pnlUserControl.Controls[0] as uc_ModelDataInputO);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO == null)
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO = new SSIAModelDataInputO();
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.doInputfromCmaq = _modelDataInputO.choCMAQOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.forecastModelDataFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.dispersionFile = CommonClass.dispersionModelFile == null ? "" : CommonClass.dispersionModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.SourceCoordinateFile = CommonClass.ssiasourcefile == null ? "" : CommonClass.ssiasourcefile;
                        break;
                    case "uc_MonitorDataInputO":
                        uc_MonitorDataInputO _monitorDataInputO = (pnlUserControl.Controls[0] as uc_MonitorDataInputO);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO == null)
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO = new SSIAMonitorDataInputO();
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneMonitorDataFile = CommonClass.ozoneMonitorFile == null ? "" : CommonClass.ozoneMonitorFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneStartYear = _monitorDataInputO.cboStartYearOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneEndYear = _monitorDataInputO.cboEndYearOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useVNA = _monitorDataInputO.choVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useEVNA = _monitorDataInputO.choEVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useDownscaler = _monitorDataInputO.chkDS.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSBurn = Convert.ToInt16(_monitorDataInputO.txtDSBurn.Text);
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSCmaqres = Convert.ToInt16(_monitorDataInputO.txtDSCmaqres.Text);
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSNumit = Convert.ToInt16(_monitorDataInputO.txtDSNumit.Text);
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSThin = Convert.ToInt16(_monitorDataInputO.txtDSThin.Text);



                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.temporalAdjustmentAtMonitorGrid = _monitorDataInputO.cboGridOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.temporalAdjustmentType = _monitorDataInputO.cboStatisticOzone.Text;
                        break;
                    case "uc_ModelDataInputDep":                     //added by K.B.
                        uc_ModelDataInputDep _modelDataInputDep = (pnlUserControl.Controls[0] as uc_ModelDataInputDep);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep == null)
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep = new SSIAModelDataInputDep();
                        (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.DailyModelDataInput = _modelDataInputDep.rbtnDailyModelDataDep.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.QuarterlyModelDataInput = _modelDataInputDep.rbtnQuarterlyModelDataDep.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.alternativeScenarioFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.SourceCoordinateFile = CommonClass.ssiasourcefile == null ? "" : CommonClass.ssiasourcefile;
                        break;
                    case "uc_CalculationOption":
                        uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                        if (CommonClass.CurrentBaseScenario.configuration is SSIAAnnualPMAnalysisConfiguration)
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption == null)
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.NAAQS = _calculation.txtNAAQS.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.threshold = _calculation.txtThreshold.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.startPercentage = Convert.ToInt16(_calculation.nupdStartPercentage.Value);
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.endPercentage = Convert.ToInt16(_calculation.nupdEndPercentage.Value);
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration is SSIADailyPMAnalysisConfiguration)
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption == null)
                                (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.NAAQS = _calculation.txtNAAQS.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.threshold = _calculation.txtThreshold.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.startPercentage = Convert.ToInt16(_calculation.nupdStartPercentage.Value);
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.endPercentage = Convert.ToInt16(_calculation.nupdEndPercentage.Value);
                        }
                        else if (CommonClass.CurrentBaseScenario.configuration is SSIAOzoneAnalysisConfiguration)
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption == null)
                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.NAAQS = _calculation.txtNAAQS.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.threshold = _calculation.txtThreshold.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.startPercentage = Convert.ToInt16(_calculation.nupdStartPercentage.Value);
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.endPercentage = Convert.ToInt16(_calculation.nupdEndPercentage.Value);
                        }
                        if (CommonClass.CurrentBaseScenario.configuration is SSIADepositionConfiguration)    //added by K.B.
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption == null)
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption = new SSIACalculationOption();
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.NAAQS = _calculation.txtNAAQS.Text;
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.threshold = _calculation.txtThreshold.Text;
                            //(CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.startPercentage = Convert.ToInt16(_calculation.nupdStartPercentage.Value);
                            //(CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.endPercentage = Convert.ToInt16(_calculation.nupdEndPercentage.Value);
                        }
                        break;
                    #endregion
                    #region Annual PM China added by Edwin
                    case "uc_ModelDataChina":
                        uc_ModelDataChina modeldatachina = (pnlUserControl.Controls[0] as uc_ModelDataChina);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina = new ModelDataInputChina();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doInputFromCMAQ = modeldatachina.rbtnCMAQChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doDailyAverageDataInput = modeldatachina.rbtnDailyAvertageDatalChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doQuarterlyAverageDataInput = modeldatachina.rbtnQuarterlyAverageDataChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.scenarioName = modeldatachina.txtScenarioName.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.BaselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.ControlModelDataFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                        break;
                    case "uc_MonitorDataChina":
                        uc_MonitorDataChina monitordatachina = (pnlUserControl.Controls[0] as uc_MonitorDataChina);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina = new MonitorDataInputChina();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doQuarterlyMonitorDataInput = monitordatachina.rbtnQuarterlyMonitorChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doDailyMonitorDataInput = monitordatachina.rbtnDailyMonitorChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doInterpolateFRM = monitordatachina.choIFRMChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doInterpolateAdjustedFRM = monitordatachina.choIAdjustedFRMChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNA = monitordatachina.chkwVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNAAdvancedOption = monitordatachina.chkwVNA.Checked && monitordatachina.chkwVNAAdvance.Checked;
                        double d;
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNAAdvancedOption && !string.IsNullOrWhiteSpace(monitordatachina.txtwVNAWeight.Text))
                        {
                            if (double.TryParse (monitordatachina.txtwVNAWeight.Text,out d))
                            {
                                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.wVNAWeight = d;
                            }
                        }
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doNS = monitordatachina.chkNS.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataInputFile = CommonClass.monitorFile == null ? "" : CommonClass.monitorFile;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear = monitordatachina.cboStartYearChina.Text;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear = monitordatachina.cboEndYearChina.Text;

                        break;
                    case "uc_PM25SpeciesOptionChina":
                        uc_PM25SpeciesOptionChina speciesoptionchina = (pnlUserControl.Controls[0] as uc_PM25SpeciesOptionChina);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina = new PM25SpeciesOptionChina();
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.PM25SpeciesFractionDataAvailable = speciesoptionchina.chkSpeciesFractionDataChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.SpeciesMonitorDataFile = CommonClass.speciesMonitorFile == null ? "" : CommonClass.speciesMonitorFile;
                        break;
                    #endregion
                    #region Ozone China added by Edwin
                    case "uc_ModelDataOzoneChina":
                        uc_ModelDataOzoneChina modeldataozonechina = (pnlUserControl.Controls[0] as uc_ModelDataOzoneChina);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina == null)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina = new ModelDataOzoneChina();
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.doInputfromCmaq = modeldataozonechina.cboCMAQOzone.Checked;
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile == null || CommonClass.baseModelFile != (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile = CommonClass.baseModelFile;
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile == null || CommonClass.futureModelFile != (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile = CommonClass.futureModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.scenarioName = modeldataozonechina.txtScenarioName.Text;
                        break;
                    case "uc_MonitorDataOzoneChina":
                        uc_MonitorDataOzoneChina monitordataozonechina = (pnlUserControl.Controls[0] as uc_MonitorDataOzoneChina);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina == null)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina = new MonitorDataOzoneChina();
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useEVNA = monitordataozonechina.choIAdjustedFRMChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useVNA = monitordataozonechina.choIFRMChina.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNA = monitordataozonechina.chkwVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAAdvancedOption = monitordataozonechina.chkwVNA.Checked && monitordataozonechina.chkwVNAAdvance.Checked;
                        double c;
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAAdvancedOption && !string.IsNullOrWhiteSpace(monitordataozonechina.txtwVNAWeight.Text))
                        {
                            if (double.TryParse(monitordataozonechina.txtwVNAWeight.Text, out c))
                            {
                                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAWeight = c;
                            }
                        }
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useNS = monitordataozonechina.chkNS.Checked;
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneMonitorDataFile == null || CommonClass.ozoneMonitorFile != (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneMonitorDataFile)
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneMonitorDataFile = CommonClass.ozoneMonitorFile;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear = monitordataozonechina.cboEndYearOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear = monitordataozonechina.cboStartYearOzone.Text;
                        break;
                    #endregion
                    #region BenMAP Annual PM
                    case "uc_BenMAP_AnnualPM_ModelData":
                        uc_BenMAP_AnnualPM_ModelData model = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_ModelData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput == null)
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput = new BenMAPAnnualPMModel();
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doInputfromCMAQ = model.rbtnCMAQA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doDailyModelData = model.rbtnDailyModelA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doQuarterlyModelData = model.rbtnQuarterlyModelA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.scenarioName = model.txtScenarioName.Text;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.baselineFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.forecastFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.temporalAdjustmentAtMonitorGridSpatial = model.cboSpatialGridA.Text;
                        break;
                    case "uc_BenMAP_AnnualPM_MonitorData":
                        uc_BenMAP_AnnualPM_MonitorData monitor = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_MonitorData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput == null)
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput = new BenMAPAnnualPMMonitor();
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.unofficialFile = CommonClass.unofficialPMFile == null ? "" : CommonClass.unofficialPMFile;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.startYear = monitor.cboStartYearA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.endYear = monitor.cboEndYearA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.useVNA = monitor.choIFRMSpeA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.useEVNA = monitor.choIAdjustedFRMSpeA.Checked;

                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.doDownscaler = monitor.chkDS.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.DS_Burn = Convert.ToInt32(monitor.txtDSBurn.Text);
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.DS_Cmaqres = Convert.ToInt32(monitor.txtDSCmaqres.Text);
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.DS_Numit = Convert.ToInt32(monitor.txtDSNumit.Text);
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.DS_Thin = Convert.ToInt32(monitor.txtDSThin.Text);
                        break;
                    case "uc_BenMAP_AnnualPM_SpeciesData":
                        uc_BenMAP_AnnualPM_SpeciesData species = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_SpeciesData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput == null)
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput = new BenMAPAnnualPMSpecies();
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.doSpeciesMonitorDataFile = species.rbtnMonitorFileA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.speciesMonitorDataFile = CommonClass.speciesMonitorFile == null ? "" : CommonClass.speciesMonitorFile;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.doSpeciesFractionFile = species.rbtnFractionA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.specFracSpatialFile = CommonClass.speciesFractionFilePoint == null ? "" : CommonClass.speciesFractionFilePoint;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.gradAdjSpecFracSpatialFile = CommonClass.speciesFractionFileSpatial == null ? "" : CommonClass.speciesFractionFileSpatial;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.startYear = species.cboStartYearA.Text;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.endYear = species.cboEndYearA.Text;
                        break;
                    case "uc_BenMAP_GridDefinition":
                        uc_BenMAP_GridDefinition grid = (pnlUserControl.Controls[0] as uc_BenMAP_GridDefinition);
                        if (CommonClass.CurrentAnalysis == enumAnalysis.BenMAPAnnualPM)
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile == null)
                                (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile = "";
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile = CommonClass.shapefile == null ? "" : CommonClass.shapefile;
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.BenMAPSeasonalOzone)
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile == null)
                                (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile = "";
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile = CommonClass.shapefile == null ? "" : CommonClass.shapefile;
                        }
                        break;
                    #endregion
                    #region BenMAP Ozone
                    case "uc_BenMap_Ozone_ModelData":
                        uc_BenMap_Ozone_ModelData BenMapOzoneModel = (pnlUserControl.Controls[0] as uc_BenMap_Ozone_ModelData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput == null)
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput = new BenMAPOzoneModel();
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.doInputfromCmaq = BenMapOzoneModel.choCMAQOzone.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.scenarioName = BenMapOzoneModel.txtScenarioName.Text;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.baselineModelDataFile = CommonClass.baseModelFile == null ? "" : CommonClass.baseModelFile;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.forecastModelDataFile = CommonClass.futureModelFile == null ? "" : CommonClass.futureModelFile;
                        break;
                    case "uc_BenMap_Ozone_MonitorData":
                        uc_BenMap_Ozone_MonitorData BenMapOzoneMonitor = (pnlUserControl.Controls[0] as uc_BenMap_Ozone_MonitorData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput == null)
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput = new BenMapOzoneMonitor();
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneMonitorDataFile = CommonClass.ozoneMonitorFile == null ? "" : CommonClass.ozoneMonitorFile;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneStartYear = BenMapOzoneMonitor.cboStartYearOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneEndYear = BenMapOzoneMonitor.cboEndYearOzone.Text;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.useVNA = BenMapOzoneMonitor.choVNA.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.useEVNA = BenMapOzoneMonitor.choEVNA.Checked;
                        //(CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.temporalAdjustmentAtMonitorGrid = BenMapOzoneMonitor.cboGridOzone.Text;
                        //(CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.temporalAdjustmentType = BenMapOzoneMonitor.cboStatisticOzone.Text;

                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.doDownscaler = BenMapOzoneMonitor.chkDS.Checked;
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.DSBurn = Convert.ToInt32(BenMapOzoneMonitor.txtDSBurn.Text);
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.DSCmaqres = Convert.ToInt32(BenMapOzoneMonitor.txtDSCmaqres.Text);
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.DSNumit = Convert.ToInt32(BenMapOzoneMonitor.txtDSNumit.Text);
                        (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.DSThin = Convert.ToInt32(BenMapOzoneMonitor.txtDSThin.Text);

                        break;
                    //case "uc_BenMAP_GridDefinition":
                    //break;


                    #endregion
                }

                //Change the node color of the tree
                #region
                switch (CommonClass.CurrentAnalysis)
                {
                    case enumAnalysis.AnnualPM:
                        #region annual pm
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null)
                        {
                            if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                        }
                        //Relationship between all the output files.
                        if (pnlUserControl.Controls[0].Name == "uc_OutputAdvancedA" || pnlUserControl.Controls[0].Name == "uc_OutputA")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null)
                            {
                                errorTip = CommonClass.checkUCOutputAdvancedA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_DataInputA")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA != null)
                            {
                                errorTip = CommonClass.checkUCDataInputA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_SpeciesFractionsCalculationOptionsA")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA != null)
                            {
                                errorTip = CommonClass.checkUCSpeciesFractionOptionsA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[3].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[3].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_PM25CalculationOptionsA")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA != null)
                            {
                                errorTip = CommonClass.checkUCPMCalculationOptionsA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[4].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[4]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[4].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[4]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_ModelDataA")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA != null)
                            {
                                if (trvAnalysis.Nodes[5].ImageKey != _readyImageKey)
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[5]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.DailyPM:
                        #region daily add by dian
                        errorBuilder = new StringBuilder("");
                        if (pnlUserControl.Controls[0].Name == "uc_OutputD")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null)
                            {
                                errorTip = CommonClass.checkUCOutputD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[0].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }
                        }

                        if (pnlUserControl.Controls[0].Name == "uc_OutputAdvancedD")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null)
                            {
                                errorTip = CommonClass.checkUCOutputAdvancedD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }

                        if (pnlUserControl.Controls[0].Name == "uc_DataInputD")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD != null)
                            {
                                errorTip = CommonClass.checkUCDataInputD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_SpeciesFrctionD")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD != null)
                            {
                                errorTip = CommonClass.checkUCSpeciesFractionOptionsD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[3].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[3].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_PM25CalculationD")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD != null)
                            {
                                errorTip = CommonClass.checkUCPMCalculationOptionsD(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[4].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[4]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[4].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[4]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_ModelDataD")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD != null)
                            {
                                if (trvAnalysis.Nodes[5].ImageKey != _readyImageKey)
                                {
                                    ChangeNodeImage(trvAnalysis.Nodes[5]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.Ozone:
                        #region Ozone added by Devin 20120916
                        if (pnlUserControl.Controls[0].Name == "uc_DesiredOutputOzone")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO != null)
                            {
                                errorTip = CommonClass.checkUCOutputO(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[0].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_DataInputOzone")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null)
                            {
                                errorTip = CommonClass.checkUCDataInputO(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_FilteringorInterpolationOzone")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO != null)
                            {
                                errorTip = CommonClass.checkUCFilteringInterpolationO(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_RRForSpatialGradientOzone")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO != null)
                            {
                                errorTip = CommonClass.checkUCRRFSpatialGradientO(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[3].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[3].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.Visibility:
                        #region Ozone added by Devin 20120916

                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV != null)
                        {
                            if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_DataInputV")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV != null)
                            {
                                errorTip = CommonClass.checkUCDataInputV(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_FilteringV")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV != null)
                            {
                                errorTip = CommonClass.checkUCFilteringV(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.SSIAAnnualPM:
                        #region SSIA-Annual
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null)
                        {
                            if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_ModelDataInputA")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA != null)
                            {
                                errorTip = CommonClass.checkSSIAUCModelInputA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_MonitorDataInputA")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null && ssia_useMonitor)
                            {
                                errorTip = CommonClass.checkSSIAUCMonitorInputA(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_CalculationOption")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption != null)
                            {
                                errorTip = CommonClass.checkSSIAUCCalculationOption(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[3].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[3].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.SSIADailyPM:
                        #region SSIA-Daily
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null)
                        {
                            if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_ModelDataInputD")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD != null)
                            {
                                //errorTip = CommonClass.checkUCDataInputV(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_MonitorDataInputD")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null && ssia_useMonitor)
                            {
                                //errorTip = CommonClass.checkUCFilteringV(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_CalculationOption")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption != null)
                            {
                                errorTip = CommonClass.checkSSIAUCCalculationOption(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[3].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[3].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.SSIAOzone:
                        #region SSIA-Ozone
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO != null)
                        {
                            if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_ModelDataInputO")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO != null)
                            {
                                //errorTip = CommonClass.checkUCDataInputV(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_MonitorDataInputO")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO != null && ssia_useMonitor)
                            {
                                //errorTip = CommonClass.checkUCFilteringV(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_CalculationOption")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption != null)
                            {
                                errorTip = CommonClass.checkSSIAUCCalculationOption(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[3].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[3]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[3].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[3]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.SSIADeposition:
                        #region SSIA-Deposition added by K.B.
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep != null)
                        {
                            if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                            {
                                ChangeNodeImage(trvAnalysis.Nodes[0]);
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_ModelDataInputDep")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep != null)
                            {
                                //errorTip = CommonClass.checkSSIAUCModelInputDep(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        //if (pnlUserControl.Controls[0].Name == "uc_MonitorDataInputA")
                        //{
                        //    if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null && ssia_useMonitor)
                        //    {
                        //        errorTip = CommonClass.checkSSIAUCMonitorInputA(CommonClass.CurrentBaseScenario);
                        //        if (errorTip != null && errorTip.Length > 0)
                        //        {
                        //            errorBuilder.Append(errorTip);
                        //            if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                        //                errorNode(trvAnalysis.Nodes[2]);
                        //        }
                        //        else
                        //        {
                        //            if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                        //                ChangeNodeImage(trvAnalysis.Nodes[2]);
                        //        }
                        //    }
                        //}
                        if (pnlUserControl.Controls[0].Name == "uc_CalculationOption")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption != null)
                            {
                                //errorTip = CommonClass.checkSSIAUCCalculationOption(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.AnnualPMChina:
                        #region Annual PM China added by Edwin
                        if (pnlUserControl.Controls[0].Name == "uc_ModelDataChina")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina != null)
                            {
                                errorTip = "";
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[0].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_MonitorDataChina")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina != null)
                            {
                                errorTip = "";
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_PM25SpeciesOptionChina")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina != null)
                            {
                                errorTip = "";
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.OzoneChina:
                        #region Ozone China added by Edwin
                        if (pnlUserControl.Controls[0].Name == "uc_ModelDataOzoneChina")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina != null)
                            {
                                errorTip = "";
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[0].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }

                        }
                        if (pnlUserControl.Controls[0].Name == "uc_MonitorDataOzoneChina")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina != null)
                            {
                                errorTip = "";
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.BenMAPAnnualPM:
                        #region BenMAP Annual PM
                        if (pnlUserControl.Controls[0].Name == "uc_BenMAP_AnnualPM_ModelData")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput != null)
                            {
                                errorTip = CommonClass.checkUCBenMAPPMModelData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[0].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_BenMAP_AnnualPM_MonitorData")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput != null)
                            {
                                errorTip = CommonClass.checkUCBenMAPPMMonitorData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_BenMAP_AnnualPM_SpeciesData")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput != null)
                            {
                                errorTip = CommonClass.checkUCBenMAPPMSpeciesData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[2]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[2]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_BenMAP_GridDefinition")
                        {
                            if (string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile) || !File.Exists((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile))
                            {
                                if (trvAnalysis.Nodes[3].ImageKey != _errorImageKey)
                                    errorNode(trvAnalysis.Nodes[3]);
                            }
                            else
                            {
                                if (trvAnalysis.Nodes[3].ImageKey != _readyImageKey)
                                    ChangeNodeImage(trvAnalysis.Nodes[3]);
                            }
                        }
                        #endregion
                        break;
                    case enumAnalysis.BenMAPSeasonalOzone:
                        #region BenMAP Ozone
                        if (pnlUserControl.Controls[0].Name == "uc_BenMap_Ozone_ModelData")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput != null)
                            {
                                errorTip = CommonClass.checkBenMAPOzoneModelData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[0].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[0]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[0].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[0]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_BenMap_Ozone_MonitorData")
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput != null)
                            {
                                errorTip = CommonClass.checkBenMAPOzoneMonitorlData(CommonClass.CurrentBaseScenario);
                                if (errorTip != null && errorTip.Length > 0)
                                {
                                    errorBuilder.Append(errorTip);
                                    if (trvAnalysis.Nodes[1].ImageKey != _errorImageKey)
                                        errorNode(trvAnalysis.Nodes[1]);
                                }
                                else
                                {
                                    if (trvAnalysis.Nodes[1].ImageKey != _readyImageKey)
                                        ChangeNodeImage(trvAnalysis.Nodes[1]);
                                }
                            }
                        }
                        if (pnlUserControl.Controls[0].Name == "uc_BenMAP_GridDefinition")
                        {
                            if (string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile) || !File.Exists((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile))
                            {
                                if (trvAnalysis.Nodes[2].ImageKey != _errorImageKey)
                                    errorNode(trvAnalysis.Nodes[2]);
                            }
                            else
                            {
                                if (trvAnalysis.Nodes[2].ImageKey != _readyImageKey)
                                    ChangeNodeImage(trvAnalysis.Nodes[2]);
                            }
                        }
                        #endregion
                        break;
                }
                #endregion
                trvAnalysis.Refresh();
                pnlUserControl.Refresh();
                lblSteps.Refresh();
                errorTip = errorBuilder.ToString();
                if (errorTip != null && errorTip.Length > 0)
                {
                    this.btnSaveRun.Enabled = false;
                    this.btnSave.Enabled = false;
                }
                return errorTip;
                //if (errorTip != null && errorTip.Length > 0)
                //{
                //    MessageBox.Show(errorTip, "Tip", MessageBoxButtons.OK);
                //}
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return ex.ToString();
            }
        }

        /// <summary>
        /// Double-click tree nodes, load corresponding uc
        /// </summary>
        public void TreeNodeLoad()
        {
            try
            {
                string errorTips = SaveCurrentUCConfiguration();
                if (errorTips != null && errorTips.Length > 0)
                {
                    MessageBox.Show(errorTips, Language.Localization.GetValue("Tip"), MessageBoxButtons.OK);
                    return;
                }

                //Judge whether data input has been set
                #region
                string nodeName = trvAnalysis.SelectedNode.Name.ToLower().ToString();
                switch (nodeName)
                {
                    case "speciesa":
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA == null)
                        {
                            MessageBox.Show(Language.Localization.GetValue("Please select a Species Monitor Data File in Data Input!"));
                            return;
                        }
                        break;
                    case "calculationoptionsa":
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA == null)
                        {
                            MessageBox.Show(Language.Localization.GetValue("Please select Official Quarterly Averge FRM Data File in Data Input!"));
                            return;
                        }
                        break;
                    case "speciesd":
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD == null)
                        {
                            MessageBox.Show(Language.Localization.GetValue("Please select a Species Monitor Data File in Data Input!"));
                            return;
                        }
                        break;
                    case "calculationoptionsd":
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD == null)
                        {
                            MessageBox.Show(Language.Localization.GetValue("Please select Official Quarterly Averge FRM Data File in Data Input!"));
                            return;
                        }
                        break;
                    case "filteringinterpolationo"://Ozone added by devin 20120913 16:50
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO == null)
                        {
                            MessageBox.Show(Language.Localization.GetValue("Please select Ozone Data File in Data Input!"));
                            return;
                        }
                        break;
                    case "filteringv"://Visibility added by devin
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV == null)
                        {
                            MessageBox.Show(Language.Localization.GetValue("Please select a Monitor Data File in Data Input!"));
                            return;
                        }
                        break;
                }
                #endregion
                if (this.pnlUserControl.Controls.Count != 0)
                {
                    this.pnlUserControl.Controls.Clear();
                }
                this.lblSteps.Text = trvAnalysis.SelectedNode.Text;
                switch (nodeName)
                {
                    #region annual pm
                    case "outputa":
                        pnlUserControl.Controls.Add(new uc_OutputA());
                        uc_OutputA _outPutA = (pnlUserControl.Controls[0] as uc_OutputA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA == null)
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA = new ChooseDesiredOutputA();
                        _outPutA.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.scenarioName;
                        _outPutA.choStandardAnalysisA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doStandardAnalysis;
                        _outPutA.choQuarterlyModelDataA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doQuarterlyModelData;
                        _outPutA.choQuarterlyModelDataUsedA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doUsedQuarterlyAvgModelData;
                        _outPutA.choSpeciesFractionOutputA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doSpeciesFraction;
                        _outPutA.choActionsCompletionA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doAutomaticallyExtract;
                        break;
                    case "outputadvanceda":
                        pnlUserControl.Controls.Add(new uc_OutputAdvancedA());
                        uc_OutputAdvancedA _outputAdvancedA = (pnlUserControl.Controls[0] as uc_OutputAdvancedA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA = new OutputChoiceAdvancedA();
                            _outputAdvancedA.choQuaPointA.Checked = true;
                            _outputAdvancedA.choFileCA.Checked = true;
                            _outputAdvancedA.choFileEA.Checked = true;
                        }
                        else
                        {
                            _outputAdvancedA.choIFRMSpeA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj;
                            _outputAdvancedA.choIAdjustedFRMSpeA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj;
                            _outputAdvancedA.choBaseOnlyVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyVNA;
                            _outputAdvancedA.choFutureOnlyVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyVNA;
                            _outputAdvancedA.choBaseOnlyEvna.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyEvna;
                            _outputAdvancedA.choFutureOnlyEvna.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyEvna;
                            _outputAdvancedA.choQuaPointA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFilePoint;
                            _outputAdvancedA.choQuaSpatialA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial;
                            _outputAdvancedA.choQuaSpaGraAdjA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_GraAdj;
                            _outputAdvancedA.choFileCA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doHighCountySites;
                            _outputAdvancedA.choSpeSpatialFieldA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial;
                            _outputAdvancedA.choSpeSpaGraAdjA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj;
                            _outputAdvancedA.choFileEA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgSpeciatedMonitors;
                            _outputAdvancedA.choDVPeriods.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doDesignValuePeriods;
                            _outputAdvancedA.choNeiPointA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doNeighborFilePoint;
                            _outputAdvancedA.choNeiSpatialA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doNeighborFileSpatial;

                            _outputAdvancedA.chkDS.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doDS;
                            _outputAdvancedA.chkDSOnlyBase.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyDS;
                            _outputAdvancedA.chkDSOnlyFuture.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyDS;
                            _outputAdvancedA.txtDSBurn.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Burn.ToString();
                            _outputAdvancedA.txtDSCmaqres.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Cmaqres.ToString();
                            _outputAdvancedA.txtDSThin.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Thin.ToString();
                            _outputAdvancedA.txtDSNumit.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Numit.ToString();
                            _outputAdvancedA.choQuaSpaDSA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_DS;
                            _outputAdvancedA.choSpeSpaDSA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial_DS;
                        }
                        _outputAdvancedA.choChangedHeightAndTop();
                        break;
                    case "datainputa":
                        pnlUserControl.Controls.Add(new uc_DataInputA());
                        uc_DataInputA _dataInputA = (pnlUserControl.Controls[0] as uc_DataInputA);
                        //DataInputFile dataInputFile = new DataInputFile();
                        _dataInputA.InitializeControl();
                        break;
                    case "speciesa":
                        pnlUserControl.Controls.Add(new uc_SpeciesFractionsCalculationOptionsA());
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        uc_SpeciesFractionsCalculationOptionsA _speciesFractionOptionsA = (pnlUserControl.Controls[0] as uc_SpeciesFractionsCalculationOptionsA);
                        _speciesFractionOptionsA.cboIMPROVEStartYaerA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFractionOptionsA.cboIMPROVEEndYaerA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFractionOptionsA.cboPMStartYaerA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFractionOptionsA.cboPMEndYaerA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA = new SpeciesFractionOptionsA();
                            _speciesFractionOptionsA.choIMPROVEEPADeletionsA.Checked = true;
                            _speciesFractionOptionsA.choPMEPADeletionsA.Checked = true;
                            if (_speciesFractionOptionsA.cboIMPROVEStartYaerA.Items.Count >= 9)
                                _speciesFractionOptionsA.cboIMPROVEStartYaerA.SelectedIndex = 8;
                            else
                                _speciesFractionOptionsA.cboIMPROVEStartYaerA.SelectedIndex = _speciesFractionOptionsA.cboIMPROVEStartYaerA.Items.Count - 1;
                            if (_speciesFractionOptionsA.cboIMPROVEEndYaerA.Items.Count >= 11)
                            {
                                _speciesFractionOptionsA.cboIMPROVEEndYaerA.SelectedIndex = 10;
                            }
                            else
                            {
                                _speciesFractionOptionsA.cboIMPROVEEndYaerA.SelectedIndex = _speciesFractionOptionsA.cboIMPROVEEndYaerA.Items.Count - 1;
                            }
                            if (_speciesFractionOptionsA.cboPMStartYaerA.Items.Count >= 9)
                                _speciesFractionOptionsA.cboPMStartYaerA.SelectedIndex = 8;
                            else
                                _speciesFractionOptionsA.cboPMStartYaerA.SelectedIndex = _speciesFractionOptionsA.cboPMStartYaerA.Items.Count - 1;
                            if (_speciesFractionOptionsA.cboPMEndYaerA.Items.Count >= 11)
                            {
                                _speciesFractionOptionsA.cboPMEndYaerA.SelectedIndex = 10;
                            }
                            else
                            {
                                _speciesFractionOptionsA.cboPMEndYaerA.SelectedIndex = _speciesFractionOptionsA.cboPMEndYaerA.Items.Count - 1;
                            }
                            _speciesFractionOptionsA.nudownIMPROVEMinDaysA.Value = 11;
                            _speciesFractionOptionsA.nudownIMPROVEMinYearsA.Value = 1;
                            _speciesFractionOptionsA.nudownIMPROVEMinSeasonsA.Value = 1;
                            _speciesFractionOptionsA.nudownPMMinDaysA.Value = 11;
                            _speciesFractionOptionsA.nudownPMMinYearsA.Value = 1;
                            _speciesFractionOptionsA.nudownPMMinPointA.Value = 4;
                            _speciesFractionOptionsA.nudownPMMinSpatialA.Value = 1;

                            #region species options advanced
                            //(CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionAdvancedA = new SpeciesFractionAdvancedA();
                            _speciesFractionOptionsA.cboItpCrustalA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpDONA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpECA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpNH4A.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpNO3A.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpOCA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpPM25A.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpSaltA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpSO4A.SelectedIndex = 2;
                            _speciesFractionOptionsA.nudownCrustalDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownDONDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownECDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownNH4DistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownNO3DistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownOCDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownPM25DistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownSaltDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownSO4DistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.cboItpPM25A.Enabled = false;
                            _speciesFractionOptionsA.nudownPM25DistanceA.Enabled = false;
                            _speciesFractionOptionsA.rbtnDONA.Checked = true;
                            _speciesFractionOptionsA.cboItpNH4A.Enabled = false;
                            _speciesFractionOptionsA.nudownNH4DistanceA.Enabled = false;
                            _speciesFractionOptionsA.nudownNH4PercentageA.Enabled = false;
                            _speciesFractionOptionsA.nudownNH4PercentageA.Value = 0;
                            _speciesFractionOptionsA.nudownDefaultMassA.Value = 0.2M;
                            _speciesFractionOptionsA.nudownOCmbFloorA.Value = 1;
                            _speciesFractionOptionsA.nudownOCmbCeilingA.Value = 0.8M;
                            #endregion
                        }
                        else
                        {
                            _speciesFractionOptionsA.cboIMPROVEStartYaerA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_StartYear;
                            _speciesFractionOptionsA.cboIMPROVEEndYaerA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_EndYear;
                            _speciesFractionOptionsA.choIMPROVEEPADeletionsA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_EPADeletionChoice;
                            _speciesFractionOptionsA.choIMPROVEUserDeletionA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_UserDeletionChoice;
                            _speciesFractionOptionsA.nudownIMPROVEMinDaysA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinDays;
                            _speciesFractionOptionsA.nudownIMPROVEMinYearsA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinYear;
                            _speciesFractionOptionsA.nudownIMPROVEMinSeasonsA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinSeasons;
                            _speciesFractionOptionsA.cboPMStartYaerA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialStartYear;
                            _speciesFractionOptionsA.cboPMEndYaerA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialEndYear;
                            _speciesFractionOptionsA.choPMEPADeletionsA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialEPADeletionChoice;
                            _speciesFractionOptionsA.choPMUserDeletionA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialUserDeletionChoice;
                            _speciesFractionOptionsA.nudownPMMinDaysA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinDays;
                            _speciesFractionOptionsA.nudownPMMinYearsA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinYears;
                            _speciesFractionOptionsA.nudownPMMinPointA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinSeasonsPoint;
                            _speciesFractionOptionsA.nudownPMMinSpatialA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinSeasonsSpatial;

                            #region
                            _speciesFractionOptionsA.cboItpPM25A.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodPM25;
                            _speciesFractionOptionsA.nudownPM25DistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distancePM25;
                            _speciesFractionOptionsA.cboItpSO4A.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodSO4;
                            _speciesFractionOptionsA.nudownSO4DistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceSO4;
                            _speciesFractionOptionsA.cboItpNO3A.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodNO3;
                            _speciesFractionOptionsA.nudownNO3DistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceNO3;
                            _speciesFractionOptionsA.cboItpECA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodEC;
                            _speciesFractionOptionsA.nudownECDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceEC;
                            _speciesFractionOptionsA.cboItpSaltA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodSalt;
                            _speciesFractionOptionsA.nudownSaltDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceSalt;
                            _speciesFractionOptionsA.cboItpCrustalA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodCrustal;
                            _speciesFractionOptionsA.nudownCrustalDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceCrustal;
                            _speciesFractionOptionsA.cboItpDONA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodDON;
                            _speciesFractionOptionsA.nudownDONDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceDON;
                            _speciesFractionOptionsA.cboItpOCA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodOC;
                            _speciesFractionOptionsA.nudownOCDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceOC;
                            _speciesFractionOptionsA.cboItpNH4A.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodNH4;
                            _speciesFractionOptionsA.nudownNH4DistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceNH4;
                            _speciesFractionOptionsA.rbtnDONA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.doUseDonValues;
                            _speciesFractionOptionsA.rbtnMeasuredA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.doUseAmmoniumValues;
                            _speciesFractionOptionsA.nudownNH4PercentageA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.nh4PercentageEvaporating;
                            _speciesFractionOptionsA.nudownDefaultMassA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.defaultBlankMass;
                            _speciesFractionOptionsA.nudownOCmbFloorA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.floorOCMMB;
                            _speciesFractionOptionsA.nudownOCmbCeilingA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.ceilingOCMMB;
                            #endregion
                        }
                        break;
                    case "calculationoptionsa":
                        pnlUserControl.Controls.Add(new uc_PM25CalculationOptionsA());
                        lblSteps.Refresh();
                        pnlUserControl.Refresh();
                        uc_PM25CalculationOptionsA _pmCalculationA = (pnlUserControl.Controls[0] as uc_PM25CalculationOptionsA);
                        int n = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Count;
                        string[] dvString = new string[n];
                        for (int i = 0; i < n; i++)
                        {
                            dvString[i] = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears[i];
                        }
                        for (int i = 0; i < n; i++)
                        {
                            if (i + 2 < n)
                            {
                                _pmCalculationA.clboRequiredDV.Items.Add(dvString[i] + "-" + dvString[i + 2]);
                            }
                        }
                        _pmCalculationA.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        _pmCalculationA.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA = new PM25CalculationOptionsA();
                            _pmCalculationA.rbtnOfficialA.Checked = true;
                            _pmCalculationA.rbtnNH4DONA.Checked = true;
                            if (_pmCalculationA.cboStartYearA.Items.Count >= 8)//12
                                _pmCalculationA.cboStartYearA.SelectedIndex = 7;//11
                            else
                                _pmCalculationA.cboStartYearA.SelectedIndex = _pmCalculationA.cboStartYearA.Items.Count - 1;
                            if (_pmCalculationA.cboEndYearA.Items.Count >= 12)//14
                            {
                                _pmCalculationA.cboEndYearA.SelectedIndex = 11;//13
                            }
                            else
                            {
                                _pmCalculationA.cboEndYearA.SelectedIndex = _pmCalculationA.cboEndYearA.Items.Count - 1;
                            }
                            _pmCalculationA.txtRequiredA.Text = "None selected";
                            _pmCalculationA.nudownMinDaysA.Value = 11;
                            _pmCalculationA.nudownMinQuarterA.Value = 12;
                            _pmCalculationA.nudownMinNumDV.Value = 1;
                        }
                        else
                        {
                            _pmCalculationA.cboStartYearA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.officialPM25StartYear;
                            _pmCalculationA.cboEndYearA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.officialPM25EndYear;
                            _pmCalculationA.rbtnOfficialA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.choiceOfficialDV;
                            _pmCalculationA.rbtnCustomA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.choiceCustomDV;
                            _pmCalculationA.nudownMinDaysA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minDaysForValidFRMQuarters;
                            _pmCalculationA.nudownMinQuarterA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minQuartersForValidFRMDesignValues;
                            _pmCalculationA.nudownMinNumDV.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minNumDVPeriodsForValidFRMMonitors;
                            _pmCalculationA.txtRequiredA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors;
                            if (_pmCalculationA.txtRequiredA.Text != "None selected")
                            {
                                string[] requireDV = _pmCalculationA.txtRequiredA.Text.Split(',');
                                foreach (string s in requireDV)
                                {
                                    _pmCalculationA.clboRequiredDV.SetItemChecked(_pmCalculationA.clboRequiredDV.Items.IndexOf(s), true);
                                }
                            }
                            _pmCalculationA.rbtnNH4DONA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.doCalcNH4fromDON;
                            _pmCalculationA.rbtnNH4RRFA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.doCalcNH4fromRRF;
                        }
                        break;
                    case "modela":
                        pnlUserControl.Controls.Add(new uc_ModelDataA());
                        uc_ModelDataA _modelDataA = (pnlUserControl.Controls[0] as uc_ModelDataA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA = new ModelDataOptionsA();
                            _modelDataA.cboPointGridA.SelectedIndex = 1;
                            _modelDataA.cboSpatialGridA.SelectedIndex = 0;
                        }
                        else
                        {
                            _modelDataA.cboPointGridA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA.temporalAdjustmentAtMonitorGrid;
                            _modelDataA.cboSpatialGridA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA.temporalAdjustmentAtMonitorGridSpatial;
                        }
                        break;
                    #endregion
                    #region Daily dian
                    case "outputd":
                        pnlUserControl.Controls.Add(new uc_OutputD());
                        lblSteps.Text = trvAnalysis.Nodes[0].Text;
                        _stips = "Choose Desired Output";
                        uc_OutputD _outputD = (pnlUserControl.Controls[0] as uc_OutputD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD = new ChooseDesiredOutputD();
                            _outputD.choStandardAnalysisD.Checked = true;
                            _outputD.choQuarterlyPeakModelDataD.Checked = true;
                            _outputD.choSpeciesFractionsFileD.Checked = true;
                            _outputD.choActionsExtractAllD.Checked = true;
                        }
                        else
                        {
                            _outputD.txtScenarioNameDily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.scenarioName;
                            _outputD.choStandardAnalysisD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doStandardAnalysis;
                            _outputD.choQuarterlyPeakModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doQuarterlyPeakModelData;
                            _outputD.choSpeciesFractionsFileD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doSpeciesFraction;
                            _outputD.choActionsExtractAllD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doAutomaticallyExtract;
                        }
                        break;
                    case "outputadvancedd"://all unchecked?
                        pnlUserControl.Controls.Add(new uc_OutputAdvancedD());
                        lblSteps.Text = trvAnalysis.Nodes[1].Text;
                        _stips = "Select advanced output choices";
                        uc_OutputAdvancedD _outputAdvancedD = (pnlUserControl.Controls[0] as uc_OutputAdvancedD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD = new OutputChoiceAdvancedD();
                            _outputAdvancedD.choQuarterlyAvgFilePointD.Checked = true;
                            _outputAdvancedD.choFileCD.Checked = true;
                            _outputAdvancedD.choFileED.Checked = true;
                        }
                        else
                        {
                            _outputAdvancedD.choQuarterlyAvgFilePointD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakFilesPoint;
                            _outputAdvancedD.choFileCD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doHighCountySites;
                            _outputAdvancedD.choFileED.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakSpeciatedMonitors;
                            _outputAdvancedD.choDVPeriodsD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doDesignValuePeriods;
                            _outputAdvancedD.choNeighborFilePointD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doNeighborFilePoint;
                        }
                        break;
                    case "datainputd":
                        pnlUserControl.Controls.Add(new uc_DataInputD());
                        lblSteps.Text = trvAnalysis.Nodes[2].Text;
                        _stips = "Select input files for the analysis";
                        uc_DataInputD _dataInputD = (pnlUserControl.Controls[0] as uc_DataInputD);
                        _dataInputD.InitializeControl();
                        break;
                    case "speciesd":
                        pnlUserControl.Controls.Add(new uc_SpeciesFrctionD());
                        lblSteps.Text = trvAnalysis.Nodes[3].Text;
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        trvAnalysis.Refresh();
                        _stips = "Set up species fraction options";
                        uc_SpeciesFrctionD _speciesFrctionD = (pnlUserControl.Controls[0] as uc_SpeciesFrctionD);
                        _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFrctionD.cboPMMonitorStartYearDaily.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFrctionD.cboPMMonitorEndYearDaily.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD = new SpeciesFractionOptionsD();
                            if (_speciesFrctionD.cboIMPROVEMonitorStartYearDaily.Items.Count >= 9)
                                _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.SelectedIndex = 8;
                            else
                                _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.SelectedIndex = _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.Items.Count - 1;
                            if (_speciesFrctionD.cboIMPROVEMonitorEndYearDaily.Items.Count >= 11)
                                _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.SelectedIndex = 10;
                            else
                                _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.SelectedIndex = _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.Items.Count - 1;
                            if (_speciesFrctionD.cboPMMonitorStartYearDaily.Items.Count >= 9)
                                _speciesFrctionD.cboPMMonitorStartYearDaily.SelectedIndex = 8;
                            else
                                _speciesFrctionD.cboPMMonitorStartYearDaily.SelectedIndex = _speciesFrctionD.cboPMMonitorStartYearDaily.Items.Count - 1;
                            if (_speciesFrctionD.cboPMMonitorEndYearDaily.Items.Count >= 11)
                                _speciesFrctionD.cboPMMonitorEndYearDaily.SelectedIndex = 10;
                            else
                                _speciesFrctionD.cboPMMonitorEndYearDaily.SelectedIndex = _speciesFrctionD.cboPMMonitorEndYearDaily.Items.Count - 1;
                            _speciesFrctionD.choEPASpecifiedIMPROVEDaily.Checked = true;
                            _speciesFrctionD.choEPASpecifiedPMDaily.Checked = true;
                            _speciesFrctionD.nudownMinDaysIMPROVEDaily.Value = 11;
                            _speciesFrctionD.nudownMinQuartersIMPROVEDaily.Value = 1;
                            _speciesFrctionD.nudownMinYearsIMPROVEDaily.Value = 1;
                            _speciesFrctionD.nudownMinDaysPMDaily.Value = 11;
                            _speciesFrctionD.nudownMinQuartersPMDaily.Value = 4;
                            _speciesFrctionD.nudownMinYearsPMDaily.Value = 1;
                            #region advanced options
                            _speciesFrctionD.rbtnTopPercMonitorIMPROVEDaily.Checked = true;
                            _speciesFrctionD.rbtnTopPercMonitorPMDaily.Checked = true;
                            _speciesFrctionD.nudownTopPercMonitorIMPROVEDaily.Value = 10;
                            _speciesFrctionD.nudownAllMonitorGreaterIMPROVEDaily.Value = 0;
                            _speciesFrctionD.nudownMinNumAboveIMPROVEDaily.Value = 1;
                            _speciesFrctionD.nudownTopNumMonitorIMPROVEDaily.Value = 25;
                            _speciesFrctionD.nudownTopPercMonitorPMDaily.Value = 10;
                            _speciesFrctionD.nudownAllMonitorGreaterPMDaily.Value = 0;
                            _speciesFrctionD.nudownMinNumAbovePMDaily.Value = 1;
                            _speciesFrctionD.nudownTopNumMonitorPMDaily.Value = 25;
                            _speciesFrctionD.cboPM25InterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboSO4InterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboNO3InterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboECInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboSaltInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboCrastalInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboDONInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboOCInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboNH4InterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.nudownPM25DistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownSO4DistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownNO3DistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownECDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownSaltDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownCrustalDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownDONDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownOCDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownNH4DistanceDaily.Value = 9000000000;
                            _speciesFrctionD.cboPM25InterpolationDaily.Enabled = false;
                            _speciesFrctionD.nudownPM25DistanceDaily.Enabled = false;
                            _speciesFrctionD.cboNH4InterpolationDaily.Enabled = false;
                            _speciesFrctionD.nudownNH4DistanceDaily.Enabled = false;
                            _speciesFrctionD.rbtnDONValueDaily.Checked = true;
                            _speciesFrctionD.nudownNH4PercDaily.Enabled = false;
                            _speciesFrctionD.nudownDefaultBMDaily.Value = (decimal)0.2;
                            _speciesFrctionD.nudownOCmbFloorDaily.Value = 1;
                            _speciesFrctionD.nudownOCmbCeilingDaily.Value = (decimal)0.8;
                            #endregion
                        }
                        else
                        {
                            _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_StartYear;
                            _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_EndYear;
                            _speciesFrctionD.choEPASpecifiedIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_EPADeletionChoice;
                            _speciesFrctionD.choUserSpecifiedIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_UserDeletionChoice;
                            _speciesFrctionD.nudownMinDaysIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinDays;
                            _speciesFrctionD.nudownMinQuartersIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinQuarters;
                            _speciesFrctionD.nudownMinYearsIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinYear;
                            _speciesFrctionD.cboPMMonitorStartYearDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialStartYear;
                            _speciesFrctionD.cboPMMonitorEndYearDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialEndYear;
                            _speciesFrctionD.choEPASpecifiedPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialEPADeletionChoice;
                            _speciesFrctionD.choUserSpecifiedPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialUserDeletionChoice;
                            _speciesFrctionD.nudownMinDaysPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinDays;
                            _speciesFrctionD.nudownMinQuartersPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinQuartersPoint;
                            _speciesFrctionD.nudownMinYearsPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinYears;
                            #region advanced options
                            _speciesFrctionD.rbtnTopPercMonitorIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoTopXPercent;
                            _speciesFrctionD.rbtnAllMonitorGreaterIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan;
                            _speciesFrctionD.rbtnTopNumMonitorIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoUseTopXNumber;
                            _speciesFrctionD.rbtnTopPercMonitorPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoTopXPercent;
                            _speciesFrctionD.rbtnAllMonitorGreaterPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan;
                            _speciesFrctionD.rbtnTopNumMonitorPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoTopXNumber;
                            _speciesFrctionD.nudownTopPercMonitorIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_TopXPercent;
                            _speciesFrctionD.nudownAllMonitorGreaterIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_UseAlldailyMonitorValuesGreaterThan;
                            _speciesFrctionD.nudownMinNumAboveIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount;
                            _speciesFrctionD.nudownTopNumMonitorIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_UseTopXNumber;
                            _speciesFrctionD.nudownTopPercMonitorPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_TopXPercent;
                            _speciesFrctionD.nudownAllMonitorGreaterPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_UseAlldailyMonitorValuesGreaterThan;
                            _speciesFrctionD.nudownMinNumAbovePMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount;
                            _speciesFrctionD.nudownTopNumMonitorPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_TopXNumber;
                            _speciesFrctionD.cboPM25InterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodPM25;
                            _speciesFrctionD.nudownPM25DistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distancePM25;
                            _speciesFrctionD.cboSO4InterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodSO4;
                            _speciesFrctionD.nudownSO4DistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceSO4;
                            _speciesFrctionD.cboNO3InterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodNO3;
                            _speciesFrctionD.nudownNO3DistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceNO3;
                            _speciesFrctionD.cboECInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodEC;
                            _speciesFrctionD.nudownECDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceEC;
                            _speciesFrctionD.cboSaltInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodSalt;
                            _speciesFrctionD.nudownSaltDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceSalt;
                            _speciesFrctionD.cboCrastalInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodCrustal;
                            _speciesFrctionD.nudownCrustalDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceCrustal;
                            _speciesFrctionD.cboDONInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodDON;
                            _speciesFrctionD.nudownDONDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceDON;
                            _speciesFrctionD.cboOCInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodOC;
                            _speciesFrctionD.nudownOCDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceOC;
                            _speciesFrctionD.cboNH4InterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodNH4;
                            _speciesFrctionD.nudownNH4DistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceNH4;
                            _speciesFrctionD.rbtnDONValueDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.doUseDonValues;
                            _speciesFrctionD.rbtnMeasuredAmmoniumDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.doUseMeasuredAmmonium;
                            _speciesFrctionD.cboPM25InterpolationDaily.Enabled = false;
                            _speciesFrctionD.nudownPM25DistanceDaily.Enabled = false;
                            if (_speciesFrctionD.rbtnDONValueDaily.Checked == true)
                            {
                                _speciesFrctionD.cboDONInterpolationDaily.Enabled = true;
                                _speciesFrctionD.nudownDONDistanceDaily.Enabled = true;
                                _speciesFrctionD.cboNH4InterpolationDaily.Enabled = false;
                                _speciesFrctionD.nudownNH4DistanceDaily.Enabled = false;
                                _speciesFrctionD.nudownNH4PercDaily.Enabled = false;
                            }
                            if (_speciesFrctionD.rbtnMeasuredAmmoniumDaily.Checked == true)
                            {
                                _speciesFrctionD.cboDONInterpolationDaily.Enabled = false;
                                _speciesFrctionD.nudownDONDistanceDaily.Enabled = false;
                                _speciesFrctionD.cboNH4InterpolationDaily.Enabled = true;
                                _speciesFrctionD.nudownNH4DistanceDaily.Enabled = true;
                                _speciesFrctionD.nudownNH4PercDaily.Enabled = true;
                            }
                            _speciesFrctionD.nudownNH4PercDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.nh4PercentageEvaporating;
                            _speciesFrctionD.nudownDefaultBMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.defaultBlankMass;
                            _speciesFrctionD.nudownOCmbFloorDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.floorOCMMB;
                            _speciesFrctionD.nudownOCmbCeilingDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.ceilingOCMMB;
                            #endregion
                        }
                        break;
                    case "calculationoptionsd":
                        pnlUserControl.Controls.Add(new uc_PM25CalculationD());
                        lblSteps.Text = trvAnalysis.Nodes[4].Text;
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        trvAnalysis.Refresh();
                        _stips = "Set up pm25 calculation options";
                        uc_PM25CalculationD _pmCalculationD = (pnlUserControl.Controls[0] as uc_PM25CalculationD);

                        //----------------bind required dv,according to start year-------------
                        n = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Count;
                        dvString = new string[n];
                        for (int i = 0; i < n; i++)
                        {
                            dvString[i] = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears[i];
                        }
                        for (int i = 0; i < n; i++)
                        {
                            if (i + 2 < n)
                            {
                                _pmCalculationD.clboRequiredDV.Items.Add(dvString[i] + "-" + dvString[i + 2]);
                            }
                        }

                        _pmCalculationD.cboStartYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        _pmCalculationD.cboEndYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD = new PM25CalculationOptionsD();
                            if (_pmCalculationD.cboStartYearD.Items.Count >= 8)
                                _pmCalculationD.cboStartYearD.SelectedIndex = 7;
                            else
                                _pmCalculationD.cboStartYearD.SelectedIndex = _pmCalculationD.cboStartYearD.Items.Count - 1;
                            if (_pmCalculationD.cboEndYearD.Items.Count >= 12)
                                _pmCalculationD.cboEndYearD.SelectedIndex = 11;
                            else
                                _pmCalculationD.cboEndYearD.SelectedIndex = _pmCalculationD.cboEndYearD.Items.Count - 1;
                            _pmCalculationD.nudownMinNumDVD.Value = 1;
                            _pmCalculationD.txtRequiredDVD.Text = "None selected";
                            _pmCalculationD.rbtnCalculateNH4byDON.Checked = true;
                        }
                        else
                        {
                            _pmCalculationD.cboStartYearD.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.officialPM25StartYear;
                            _pmCalculationD.cboEndYearD.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.officialPM25EndYear;
                            _pmCalculationD.nudownMinNumDVD.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.minNumDVPeriodsForValidFRMMonitors;
                            _pmCalculationD.txtRequiredDVD.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors;
                            if (_pmCalculationD.txtRequiredDVD.Text != "None selected")
                            {
                                string[] requireDV = _pmCalculationD.txtRequiredDVD.Text.Split(',');
                                foreach (string s in requireDV)
                                {
                                    _pmCalculationD.clboRequiredDV.SetItemChecked(_pmCalculationD.clboRequiredDV.Items.IndexOf(s), true);
                                }
                            }
                            _pmCalculationD.rbtnCalculateNH4byDON.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.doCalcNH4fromDON;
                            _pmCalculationD.rbtnCalculateNH4byRRF.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.doCalcNH4fromRRF;
                        }
                        break;
                    case "modeld":
                        pnlUserControl.Controls.Add(new uc_ModelDataD());
                        lblSteps.Text = trvAnalysis.Nodes[5].Text;
                        _stips = "Set up model options";
                        uc_ModelDataD _modelDataD = (pnlUserControl.Controls[0] as uc_ModelDataD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD = new ModelDataOptionsD();
                            _modelDataD.cboGridPointModelOptionDaily.SelectedIndex = 0;
                            _modelDataD.choGridforSpatialForecast.SelectedIndex = 0;
                            _modelDataD.cboStatisticMethodDaily.SelectedIndex = 0;
                            _modelDataD.rbtnTopPerceRRFDaily.Checked = true;
                            _modelDataD.nudownTopPerceRRFDaily.Value = 10;
                            _modelDataD.nudownAllDailyGreaterRRFDaily.Value = 0;
                            _modelDataD.nudownMinNumDaysGreaterRRFDaily.Value = 1;
                            _modelDataD.nudownTopNumRRFDaily.Value = 25;
                        }
                        else
                        {
                            _modelDataD.cboGridPointModelOptionDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentAtMonitorGridPoint;
                            _modelDataD.choGridforSpatialForecast.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentAtMonitorGridSpatial;
                            _modelDataD.cboStatisticMethodDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentType;
                            _modelDataD.rbtnTopPerceRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseXTopPercent;
                            _modelDataD.nudownTopPerceRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseXTopPercent;
                            _modelDataD.rbtnAllDailyGreaterRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseAllModelDaysGreaterThan;
                            _modelDataD.nudownAllDailyGreaterRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseAllModelDaysGreaterThan;
                            _modelDataD.nudownMinNumDaysGreaterRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
                            _modelDataD.rbtnTopNumRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseTopXNumber;
                            _modelDataD.nudownTopNumRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseTopXNumber;
                        }
                        break;
                    #endregion
                    #region Ozone added by devin
                    case "outputo":
                        #region Desired Output
                        pnlUserControl.Controls.Add(new uc_DesiredOutputOzone());

                        uc_DesiredOutputOzone _desiredOutputOzone = (pnlUserControl.Controls[0] as uc_DesiredOutputOzone);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO = new ChooseDesiredOutputO();
                            _desiredOutputOzone.choPointForecastOzone.Checked = true;
                            _desiredOutputOzone.choSpatialOzone.Checked = false;
                            _desiredOutputOzone.choSpatialGradAdjOzone.Checked = false;
                            _desiredOutputOzone.choBaseOnlyVNAOzone.Checked = false;
                            _desiredOutputOzone.choFutureOnlyVNAOzone.Checked = false;
                            _desiredOutputOzone.chkDS.Checked = false;
                            _desiredOutputOzone.txtDSBurn.Text = "500";
                            _desiredOutputOzone.txtDSCmaqres.Text = "12";
                            _desiredOutputOzone.txtDSNumit.Text = "2500";
                            _desiredOutputOzone.txtDSThin.Text = "1";

                            _desiredOutputOzone.choBaseOnlyEvnaOzone.Checked = false;
                            _desiredOutputOzone.choFutureOnlyEvnaOzone.Checked = false;
                            //_desiredOutputOzone.choSpatialForecastOzone.Checked = false;
                            //_desiredOutputOzone.choSpatialGradAdjForecastOzone.Checked = false;
                            _desiredOutputOzone.choNeighborFileSpatial.Checked = false;
                            _desiredOutputOzone.choQuarterlyModelData.Checked = true;
                            _desiredOutputOzone.choExtractAllOzone.Checked = true;
                            _desiredOutputOzone.choDVPeriods.Checked = false;
                        }
                        else
                        {
                            _desiredOutputOzone.txtScenarioOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.scenarioName;
                            _desiredOutputOzone.choPointForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doPointEstimatesForecast;
                            _desiredOutputOzone.choQuarterlyModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doQuarterlyModelData;
                            _desiredOutputOzone.choSpatialOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates;
                            _desiredOutputOzone.choSpatialGradAdjOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj;
                            _desiredOutputOzone.choBaseOnlyVNAOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyVNA;
                            _desiredOutputOzone.choFutureOnlyVNAOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA;
                            _desiredOutputOzone.chkDS.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doDownscaler;
                            _desiredOutputOzone.txtDSBurn.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSBurn.ToString();
                            _desiredOutputOzone.txtDSCmaqres.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSCmaqres.ToString();
                            _desiredOutputOzone.txtDSNumit.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSNumit.ToString();
                            _desiredOutputOzone.txtDSThin.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSThin.ToString();


                            _desiredOutputOzone.choBaseOnlyEvnaOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyEVNA;
                            _desiredOutputOzone.choFutureOnlyEvnaOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA;
                            //_desiredOutputOzone.choSpatialForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesForecast;
                            //_desiredOutputOzone.choSpatialGradAdjForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesForecastGradAdj;
                            _desiredOutputOzone.choNeighborFileSpatial.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doNeighborFileSpatial;
                            _desiredOutputOzone.choExtractAllOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doAutomaticallyExtract;
                            _desiredOutputOzone.choDVPeriods.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doDesignValuePeriods;
                            _desiredOutputOzone.choMaxDVPeriods.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doMaxDesignValuePeriods;
                        }
                        #endregion
                        break;
                    case "datainputo":
                        #region Data Input
                        pnlUserControl.Controls.Add(new uc_DataInputOzone());
                        uc_DataInputOzone _dataInputOzone = (pnlUserControl.Controls[0] as uc_DataInputOzone);
                        _dataInputOzone.InitializeControl();
                        #endregion
                        break;
                    case "filteringinterpolationo":
                        #region Filtering/Interpolation
                        pnlUserControl.Controls.Add(new uc_FilteringorInterpolationOzone());
                        uc_FilteringorInterpolationOzone _filteringorInterpolationOzone = (pnlUserControl.Controls[0] as uc_FilteringorInterpolationOzone);

                        //----------------bind required dv,according to start year-------------
                        int j = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData.Count;
                        string[] dvStringOzone = new string[j];
                        for (int i = 0; i < j; i++)
                        {
                            dvStringOzone[i] = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData[i];
                        }

                        _filteringorInterpolationOzone.clboRequiredDV.Items.Add((Convert.ToInt32(dvStringOzone[0]) - 2).ToString() + "-" + dvStringOzone[0]);
                        _filteringorInterpolationOzone.clboRequiredDV.Items.Add((Convert.ToInt32(dvStringOzone[0]) - 1).ToString() + "-" + dvStringOzone[1]);
                        for (int i = 0; i < j; i++)
                        {
                            if (i + 2 < j)
                            {
                                _filteringorInterpolationOzone.clboRequiredDV.Items.Add(dvStringOzone[i] + "-" + dvStringOzone[i + 2]);
                            }
                        }
                        foreach (var item in _filteringorInterpolationOzone.clboRequiredDV.Items)
                        {
                            _filteringorInterpolationOzone.cboStartYearOzone.Items.Add(item);
                            _filteringorInterpolationOzone.cboEndYearOzone.Items.Add(item);
                        };
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO = new FilteringInterpolationO();
                            if (_filteringorInterpolationOzone.cboStartYearOzone.Items.Count >= 10)
                                _filteringorInterpolationOzone.cboStartYearOzone.SelectedIndex = 9;
                            else
                                _filteringorInterpolationOzone.cboStartYearOzone.SelectedIndex = _filteringorInterpolationOzone.cboStartYearOzone.Items.Count - 1;
                            if (_filteringorInterpolationOzone.cboEndYearOzone.Items.Count >= 12)
                                _filteringorInterpolationOzone.cboEndYearOzone.SelectedIndex = 11;
                            else
                                _filteringorInterpolationOzone.cboEndYearOzone.SelectedIndex = _filteringorInterpolationOzone.cboEndYearOzone.Items.Count - 1;
                            _filteringorInterpolationOzone.nudownMinNumDVO.Value = 1;
                            _filteringorInterpolationOzone.txtRequiredDVOzone.Text = "None selected";
                            _filteringorInterpolationOzone.cboDefaultItpOzone.SelectedIndex = 1;
                            _filteringorInterpolationOzone.choMaxItpDistanceOzone.Checked = false;
                            _filteringorInterpolationOzone.nudownMaxItpDistanceOzone.Value = 100;
                            _filteringorInterpolationOzone.nudownMaxItpDistanceOzone.Enabled = false;
                        }
                        else
                        {
                            _filteringorInterpolationOzone.cboStartYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.ozoneStartYear;
                            _filteringorInterpolationOzone.cboEndYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.ozoneEndYear;
                            _filteringorInterpolationOzone.nudownMinNumDVO.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.minNumDV;
                            _filteringorInterpolationOzone.txtRequiredDVOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.requiredDVPeriods;
                            if (_filteringorInterpolationOzone.txtRequiredDVOzone.Text != "None selected")
                            {
                                string[] requireDV = _filteringorInterpolationOzone.txtRequiredDVOzone.Text.Split(',');
                                foreach (string s in requireDV)
                                {
                                    _filteringorInterpolationOzone.clboRequiredDV.SetItemChecked(_filteringorInterpolationOzone.clboRequiredDV.Items.IndexOf(s), true);
                                }
                            }
                            _filteringorInterpolationOzone.cboDefaultItpOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.defaultInterpolationMethod;
                            _filteringorInterpolationOzone.choMaxItpDistanceOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.doCheckToSetMaxDistance;
                            _filteringorInterpolationOzone.nudownMaxItpDistanceOzone.Enabled = _filteringorInterpolationOzone.choMaxItpDistanceOzone.Checked ? true : false;
                            _filteringorInterpolationOzone.nudownMaxItpDistanceOzone.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.maxDistance;
                        }
                        //Turn gray or not(Filteringor/Interpolation) by according to the Spatial Field item(Desired Output)checked or not
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates == false && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj == false
                            && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyVNA == false && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA == false
                            && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyEVNA == false && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA == false)
                        {
                            _filteringorInterpolationOzone.cboDefaultItpOzone.Enabled = false;
                            _filteringorInterpolationOzone.choMaxItpDistanceOzone.Enabled = false;
                        }
                        else
                        {
                            _filteringorInterpolationOzone.cboDefaultItpOzone.Enabled = true;
                            _filteringorInterpolationOzone.choMaxItpDistanceOzone.Enabled = true;
                        }
                        #endregion
                        break;
                    case "rrfspatialgradiento":
                        #region RRF/Spatial Gradient
                        pnlUserControl.Controls.Add(new uc_RRForSpatialGradientOzone());
                        uc_RRForSpatialGradientOzone _rrforSpatialGradientOzone = (pnlUserControl.Controls[0] as uc_RRForSpatialGradientOzone);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO = new RRFSpatialGradientO();
                            _rrforSpatialGradientOzone.rbtnInitial.Checked = false;
                            _rrforSpatialGradientOzone.rbtnTopX.Checked = true;
                            _rrforSpatialGradientOzone.txtInitialValueOzone.Text = "85";
                            _rrforSpatialGradientOzone.txtAboveThresholdOzone.Text = "10";
                            _rrforSpatialGradientOzone.txtTopX.Text = "10";
                            _rrforSpatialGradientOzone.txtAllowableValueOzone.Text = "60";
                            _rrforSpatialGradientOzone.txtAboveAllowableThresholdOzone.Text = "5";
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Checked = false;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Enabled = false;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Text = "60";
                            _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Value = 1;
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays > 0)
                            {
                                _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Maximum = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Maximum = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                            }
                            else
                            {
                                _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Maximum = 366;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Maximum = 366;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Value = 366;
                            }
                            _rrforSpatialGradientOzone.choPairDaysOzone.Checked = false;
                            _rrforSpatialGradientOzone.txtStartValueOzone.Text = "1";
                            _rrforSpatialGradientOzone.txtEndValueOzone.Text = "5";
                        }
                        else
                        {
                            _rrforSpatialGradientOzone.rbtnInitial.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.useInitialThreshold;
                            _rrforSpatialGradientOzone.rbtnTopX.Checked = !(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.useInitialThreshold;
                            _rrforSpatialGradientOzone.txtInitialValueOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.initialThresholdValue;
                            _rrforSpatialGradientOzone.txtAboveThresholdOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minNumofDaysAtorAboveThreshold;
                            _rrforSpatialGradientOzone.txtTopX.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.topXDays.ToString();
                            _rrforSpatialGradientOzone.txtAllowableValueOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minAllowableThresholdValue;
                            _rrforSpatialGradientOzone.txtAboveAllowableThresholdOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minNumDaysAtorAboveMinAllowableThreshold;
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.doBackstop;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.backstopMinThresholdforSpatialField;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Enabled = _rrforSpatialGradientOzone.choEnableBackstopOzone.Checked ? true : false;
                            _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.subrangeFirstDay;
                            _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.subrangeLastDay;
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays > 0)
                            {
                                _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Maximum = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Maximum = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                            }
                            else
                            {
                                _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Maximum = 366;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Maximum = 366;
                            }
                            _rrforSpatialGradientOzone.choPairDaysOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.doPairDays;
                            _rrforSpatialGradientOzone.txtStartValueOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.SRF_StartValue;
                            _rrforSpatialGradientOzone.txtEndValueOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.SRF_EndValue;
                        }
                        //some control will turn gray(Unable to use) if it meets these requirements in Desired Output
                        if (!(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj
                            && !(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA
                            //&& !(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates
                            //&& !(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA
                            )
                        {
                            _rrforSpatialGradientOzone.txtStartValueOzone.Text = "1";
                            _rrforSpatialGradientOzone.txtEndValueOzone.Text = "5";
                            _rrforSpatialGradientOzone.txtStartValueOzone.Enabled = false;
                            _rrforSpatialGradientOzone.txtEndValueOzone.Enabled = false;
                        }
                        else
                        {
                            _rrforSpatialGradientOzone.txtStartValueOzone.Enabled = true;
                            _rrforSpatialGradientOzone.txtEndValueOzone.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates
|| (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj
|| (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA
|| (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA)
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Enabled = true;
                        else
                        {
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Enabled = false;
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Checked = false;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Enabled = false;
                        }
                        #endregion
                        break;
                    #endregion
                    #region Visibility added by devin

                    case "outputv":
                        #region uc_ChooseDesiredOutputV
                        pnlUserControl.Controls.Add(new uc_ChooseDesiredOutputV());
                        uc_ChooseDesiredOutputV _outPutV = (pnlUserControl.Controls[0] as uc_ChooseDesiredOutputV);
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV = new ChooseDesiredOutputV();
                            _outPutV.choVisibilityLevels.Checked = true;
                            _outPutV.rbtnOldIMPROVEAlgorithmVisibility.Checked = false;
                            _outPutV.rbtnNewIMPROVEAlgorithmVisibility.Checked = true;
                            _outPutV.rbtnModelGridCellatMonitorVisi.Checked = false;
                            _outPutV.rbtnModelGridCellatClass1Visi.Checked = false;
                            _outPutV.choExtractAllVisibility.Checked = true;
                        }
                        else
                        {
                            _outPutV.txtScenarioNameVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.scenarioName;
                            _outPutV.choVisibilityLevels.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.doTemporallyAdjVisibilityLevelsForecast;
                            _outPutV.rbtnOldIMPROVEAlgorithmVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm;
                            _outPutV.rbtnNewIMPROVEAlgorithmVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseNewVersionforIMPROVEAlgorithm;
                            _outPutV.rbtnModelGridCellatMonitorVisi.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseModelGridCellAtMonitor;
                            _outPutV.rbtnModelGridCellatClass1Visi.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseModelGridCellatClassIAreaCentroid;
                            _outPutV.choExtractAllVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.doAutomaticallyExtract;
                        }
                        #endregion
                        break;
                    case "datainputv":
                        #region uc_DataInputV
                        pnlUserControl.Controls.Add(new uc_DataInputV());
                        uc_DataInputV _dataInputV = (pnlUserControl.Controls[0] as uc_DataInputV);
                        _dataInputV.InitializeControl();

                        #endregion
                        break;
                    case "filteringv":
                        #region uc_FilteringV
                        pnlUserControl.Controls.Add(new uc_FilteringV());
                        uc_FilteringV _filteringV = (pnlUserControl.Controls[0] as uc_FilteringV);
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm)
                        {
                            _filteringV.cboStartYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataOld.Distinct().ToList();
                            _filteringV.cboEndYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataOld.Distinct().ToList();
                            _filteringV.cboBaseYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataOld.Distinct().ToList();
                        }
                        else
                        {
                            _filteringV.cboStartYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataNew.Distinct().ToList();
                            _filteringV.cboEndYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataNew.Distinct().ToList();
                            _filteringV.cboBaseYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataNew.Distinct().ToList();
                        }


                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV = new FilteringV();
                            if (_filteringV.cboStartYearVisibility.Items.Count > 11)
                                _filteringV.cboStartYearVisibility.SelectedIndex = 10;
                            else
                                _filteringV.cboStartYearVisibility.SelectedIndex = _filteringV.cboStartYearVisibility.Items.Count - 1;
                            if (_filteringV.cboEndYearVisibility.Items.Count > 13)
                                _filteringV.cboEndYearVisibility.SelectedIndex = 12;
                            else
                                _filteringV.cboEndYearVisibility.SelectedIndex = _filteringV.cboEndYearVisibility.Items.Count - 1;
                            if (_filteringV.cboBaseYearVisibility.Items.Count > 12)
                                _filteringV.cboBaseYearVisibility.SelectedIndex = 11;
                            else
                                _filteringV.cboBaseYearVisibility.SelectedIndex = _filteringV.cboBaseYearVisibility.Items.Count - 1;
                            _filteringV.txtMinYearVisibility.Text = "3";
                        }
                        else
                        {
                            _filteringV.cboStartYearVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.startMonitorYear;
                            _filteringV.cboEndYearVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.endMonitorYear;
                            _filteringV.cboBaseYearVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.baseModelYear;
                            _filteringV.txtMinYearVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.minYearsForValidVisibilityMonitors;

                        }
                        #endregion
                        break;
                    #endregion
                    #region SSIA
                    case "ssiaoption":
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                        {
                            _stips = "PM Calculation Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                            uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA = new SSIAAnalysisOption();
                                _analysisOption.choUseModelData.Checked = true;
                                _analysisOption.choUseModelFRMData.Checked = true;
                                _analysisOption.rbtnGridAndDispersion.Checked = false;
                                _analysisOption.rbtnGridOnly.Checked = true;
                                _analysisOption.rbtnDispersionOnly.Checked = false;
                            }
                            else
                            {
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData;
                                _analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion;
                                _analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly;
                                _analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly;
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                        {
                            _stips = "PM Calculation Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                            uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD = new SSIAAnalysisOption();
                                _analysisOption.choUseModelData.Checked = true;
                                _analysisOption.choUseModelFRMData.Checked = true;
                                _analysisOption.rbtnGridAndDispersion.Checked = false;
                                _analysisOption.rbtnGridOnly.Checked = true;
                                _analysisOption.rbtnDispersionOnly.Checked = false;
                            }
                            else
                            {
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData;
                                _analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion;
                                _analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly;
                                _analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly;
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                        {
                            _stips = "Ozone Calculation Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                            uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO = new SSIAAnalysisOption();
                                _analysisOption.choUseModelData.Checked = true;
                                _analysisOption.choUseModelFRMData.Checked = true;
                            }
                            else
                            {
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData;
                            }
                        }
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)    //added by K.B.
                        {
                            _stips = "Deposition Calculation Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                            uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep = new SSIAAnalysisOption();
                                _analysisOption.choUseModelData.Checked = true;
                                _analysisOption.choUseModelFRMData.Checked = false;
                                _analysisOption.rbtnGridAndDispersion.Checked = false;
                                _analysisOption.rbtnGridOnly.Checked = false;
                                _analysisOption.rbtnDispersionOnly.Checked = false;
                            }
                            else
                            {
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelFRMData;
                                //_analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useGridAndDispersion;
                                //_analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useGridOnly;
                                //_analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useDispersionOnly;
                            }
                        }
                        break;
                    case "ssiamodelinput":
                        lblSteps.Text = Language.Localization.GetValue("Model Data Input & Option");
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                        {
                            pnlUserControl.Controls.Add(new uc_ModelDataInputA());
                            uc_ModelDataInputA _modelInput = (pnlUserControl.Controls[0] as uc_ModelDataInputA);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA = new SSIAModelDataInputA();
                                if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion)
                                {
                                    _modelInput.rbtnDailyModelA.Checked = true;
                                    _modelInput.rbtnQuarterlyModelA.Checked = false;
                                    //_modelInput.rbtnCMAQA.Checked = false;
                                    if (CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM"))
                                    {
                                        //
                                        CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["baselineModelFile"];
                                        CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["forecastModelFile"]; ;
                                        CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["dispersionModelFile"];
                                    }
                                    else
                                    {
                                        CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                        CommonClass.dispersionModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                    }
                                    _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                                else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly)
                                {
                                    _modelInput.rbtnDailyModelA.Checked = true;
                                    _modelInput.rbtnQuarterlyModelA.Checked = false;
                                    //_modelInput.rbtnCMAQA.Checked = false;
                                    if (CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM"))
                                    {
                                        //
                                        CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["baselineModelFile"];
                                        CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["forecastModelFile"];
                                    }
                                    else
                                    {
                                        CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                    }

                                    _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    _modelInput.panelDispersion.Visible = false;
                                    _modelInput.pnlSourceFile.Location = new System.Drawing.Point(_modelInput.pnlSourceFile.Location.X, _modelInput.pnlSourceFile.Location.Y - _modelInput.panelDispersion.Height);
                                }
                                else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly)
                                {
                                    if (CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM"))
                                    {
                                        CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["dispersionModelFile"];
                                    }
                                    else
                                    {
                                        CommonClass.dispersionModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                    }

                                    _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    _modelInput.panelGrid.Visible = false;
                                    _modelInput.panelDispersion.Location = new System.Drawing.Point(_modelInput.panelGrid.Location.X, _modelInput.panelGrid.Location.Y);
                                    _modelInput.pnlSourceFile.Location = new System.Drawing.Point(_modelInput.pnlSourceFile.Location.X, _modelInput.pnlSourceFile.Location.Y - _modelInput.panelGrid.Height);
                                }
                                if (CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM"))
                                {
                                    CommonClass.ssiasourcefile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["sourceCoordinatesFile"];
                                }
                                else
                                {
                                    CommonClass.ssiasourcefile = Application.StartupPath + @"\Data\SampleData\SSIA\Source Coordinate.csv";
                                }
                                _modelInput.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                            }
                            else
                            {
                                if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion)
                                {
                                    _modelInput.rbtnDailyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.DailyModelDataInput;
                                    _modelInput.rbtnQuarterlyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.QuarterlyModelDataInput;
                                    //_modelInput.rbtnCMAQA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.InputFromCMAQ;
                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile))
                                    {
                                        CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile;
                                        _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.baseModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM") ? CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["baselineModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        //CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    }

                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile))
                                    {
                                        CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile;
                                        _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.futureModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM") ? CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["forecastModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                        _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    }

                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile))
                                    {
                                        CommonClass.dispersionModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile;
                                        _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM") ? CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["dispersionModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                        _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    }
                                }
                                else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly)
                                {
                                    _modelInput.rbtnDailyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.DailyModelDataInput;
                                    _modelInput.rbtnQuarterlyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.QuarterlyModelDataInput;
                                    //_modelInput.rbtnCMAQA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.InputFromCMAQ;
                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile))
                                    {
                                        CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile;
                                        _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.baseModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM") ? CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["baselineModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    }

                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile))
                                    {
                                        CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile;
                                        _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.futureModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM") ? CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["forecastModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                        _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    }
                                    _modelInput.panelDispersion.Visible = false;
                                    _modelInput.pnlSourceFile.Location = new System.Drawing.Point(_modelInput.pnlSourceFile.Location.X, _modelInput.pnlSourceFile.Location.Y - _modelInput.panelDispersion.Height);
                                }
                                else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly)
                                {
                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile))
                                    {
                                        CommonClass.dispersionModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile;
                                        _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM") ? CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["dispersionModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                        _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    }
                                    _modelInput.panelGrid.Visible = false;
                                    _modelInput.panelDispersion.Location = new System.Drawing.Point(_modelInput.panelGrid.Location.X, _modelInput.panelGrid.Location.Y);
                                    _modelInput.pnlSourceFile.Location = new System.Drawing.Point(_modelInput.pnlSourceFile.Location.X, _modelInput.pnlSourceFile.Location.Y - _modelInput.panelGrid.Height);
                                }
                                CommonClass.ssiasourcefile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.SourceCoordinateFile;
                                _modelInput.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                        {
                            pnlUserControl.Controls.Add(new uc_ModelDataInputD());
                            uc_ModelDataInputD _modelInputD = (pnlUserControl.Controls[0] as uc_ModelDataInputD);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD = new SSIAModelDataInputD();
                                if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion)
                                {
                                    _modelInputD.rbtnDailyModelDataD.Checked = true;
                                    _modelInputD.rbtnQuarterlyPeakModelDataD.Checked = false;
                                    //_modelInputD.rbtnCMAQFileD.Checked = false;
                                    if (CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM"))
                                    {
                                        //
                                        CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["baselineModelFile"];
                                        CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["forecastModelFile"]; ;
                                        CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["dispersionModelFile"];
                                    }
                                    else
                                    {
                                        CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                        CommonClass.dispersionModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";
                                    }
                                    _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                                else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly)
                                {
                                    _modelInputD.rbtnDailyModelDataD.Checked = true;
                                    _modelInputD.rbtnQuarterlyPeakModelDataD.Checked = false;
                                    //_modelInputD.rbtnCMAQFileD.Checked = false;
                                    if (CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM"))
                                    {
                                        CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["baselineModelFile"];
                                        CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["forecastModelFile"];
                                    }
                                    else
                                    {
                                        CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                    }

                                    _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    _modelInputD.panelDispersion.Visible = false;
                                    _modelInputD.panelOptions.Location = new System.Drawing.Point(_modelInputD.panelDispersion.Location.X, _modelInputD.panelDispersion.Location.Y);
                                    _modelInputD.pnlSourceFile.Location = new System.Drawing.Point(_modelInputD.pnlSourceFile.Location.X, _modelInputD.pnlSourceFile.Location.Y - _modelInputD.panelDispersion.Height);
                                }
                                else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly)
                                {
                                    CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["dispersionModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";

                                    _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    _modelInputD.panelGrid.Visible = false;
                                    _modelInputD.panelDispersion.Location = new System.Drawing.Point(_modelInputD.panelDispersion.Location.X, _modelInputD.panelDispersion.Location.Y - _modelInputD.panelGrid.Size.Height);
                                    _modelInputD.panelOptions.Location = new System.Drawing.Point(_modelInputD.panelOptions.Location.X, _modelInputD.panelOptions.Location.Y - _modelInputD.panelGrid.Size.Height);
                                    _modelInputD.pnlSourceFile.Location = new System.Drawing.Point(_modelInputD.pnlSourceFile.Location.X, _modelInputD.pnlSourceFile.Location.Y - _modelInputD.panelGrid.Height);
                                }
                                _modelInputD.cboGridPointModelOptionDaily.SelectedIndex = 0;
                                //_modelInputD.cboGridforSpatialForecast.SelectedIndex = 0;
                                _modelInputD.cboStatisticMethodDaily.SelectedIndex = 0;
                                _modelInputD.rbtnTopPerceRRFDaily.Checked = true;
                                _modelInputD.nudownTopPerceRRFDaily.Value = 10;
                                _modelInputD.nudownAllDailyGreaterRRFDaily.Value = 0;
                                _modelInputD.nudownMinNumDaysGreaterRRFDaily.Value = 1;
                                _modelInputD.nudownTopNumRRFDaily.Value = 25;

                                CommonClass.ssiasourcefile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["sourceCoordinatesFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Source Coordinate.csv";
                                _modelInputD.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                            }
                            else
                            {
                                if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion)
                                {
                                    _modelInputD.rbtnDailyModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.DailyModelDataInput;
                                    _modelInputD.rbtnQuarterlyPeakModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.QuarterlyModelDataInput;
                                    //_modelInputD.rbtnCMAQFileD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.InputFromCMAQ;
                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile))
                                    {
                                        CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile;
                                        _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.baseModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["baselineModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    }

                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile))
                                    {
                                        CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile;
                                        _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.futureModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["forecastModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                        _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    }

                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile))
                                    {
                                        CommonClass.dispersionModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile;
                                        _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["dispersionModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";
                                        _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    }
                                }
                                else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly)
                                {
                                    _modelInputD.rbtnDailyModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.DailyModelDataInput;
                                    _modelInputD.rbtnQuarterlyPeakModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.QuarterlyModelDataInput;
                                    //_modelInputD.rbtnCMAQFileD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.InputFromCMAQ;
                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile))
                                    {
                                        CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile;
                                        _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.baseModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["baselineModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                        _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                    }

                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile))
                                    {
                                        CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile;
                                        _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.futureModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["forecastModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                        _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                    }
                                    _modelInputD.panelDispersion.Visible = false;
                                    _modelInputD.panelOptions.Location = new System.Drawing.Point(_modelInputD.panelDispersion.Location.X, _modelInputD.panelDispersion.Location.Y);
                                    _modelInputD.pnlSourceFile.Location = new System.Drawing.Point(_modelInputD.pnlSourceFile.Location.X, _modelInputD.pnlSourceFile.Location.Y - _modelInputD.panelDispersion.Height);
                                }
                                else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly)
                                {
                                    if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile))
                                    {
                                        CommonClass.dispersionModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile;
                                        _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    }
                                    else
                                    {
                                        CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["dispersionModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";
                                        _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                    }
                                    _modelInputD.panelGrid.Visible = false;
                                    _modelInputD.panelDispersion.Location = new System.Drawing.Point(_modelInputD.panelDispersion.Location.X, _modelInputD.panelDispersion.Location.Y - _modelInputD.panelGrid.Size.Height);
                                    _modelInputD.panelOptions.Location = new System.Drawing.Point(_modelInputD.panelOptions.Location.X, _modelInputD.panelOptions.Location.Y - _modelInputD.panelGrid.Size.Height);
                                    _modelInputD.pnlSourceFile.Location = new System.Drawing.Point(_modelInputD.pnlSourceFile.Location.X, _modelInputD.pnlSourceFile.Location.Y - _modelInputD.panelGrid.Height);
                                }
                                _modelInputD.cboGridPointModelOptionDaily.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentAtMonitorGridPoint;
                                //_modelInputD.cboGridforSpatialForecast.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentAtMonitorGridSpatial;
                                _modelInputD.cboStatisticMethodDaily.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentType;
                                _modelInputD.rbtnTopPerceRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseXTopPercent;
                                _modelInputD.nudownTopPerceRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseXTopPercent;
                                _modelInputD.rbtnAllDailyGreaterRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseAllModelDaysGreaterThan;
                                _modelInputD.nudownAllDailyGreaterRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseAllModelDaysGreaterThan;
                                _modelInputD.nudownMinNumDaysGreaterRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
                                _modelInputD.rbtnTopNumRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseTopXNumber;
                                _modelInputD.nudownTopNumRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseTopXNumber;

                                CommonClass.ssiasourcefile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.SourceCoordinateFile;
                                _modelInputD.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                        {
                            pnlUserControl.Controls.Add(new uc_ModelDataInputO());
                            _stips = "Model Data Input & Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            uc_ModelDataInputO _modelDataInputO = (pnlUserControl.Controls[0] as uc_ModelDataInputO);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO = new SSIAModelDataInputO();
                                _modelDataInputO.choCMAQOzone.Checked = false;
                                if (CommonClass.dicExampleConfiguration.ContainsKey("SSIAOzone"))
                                {
                                    //
                                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIAOzone"]["baselineModelFile"];
                                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIAOzone"]["forecastModelFile"]; ;
                                    CommonClass.ssiasourcefile = CommonClass.dicExampleConfiguration["SSIAOzone"]["sourceCoordinatesFile"];
                                }
                                else
                                {
                                    CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.O3.4ATL1.2007ee_07f_BASE.csv";
                                    CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.O3.4ATL1.2007ee_07f_ALT.csv";
                                    CommonClass.ssiasourcefile = Application.StartupPath + @"\Data\SampleData\SSIA\Source Coordinate.csv";
                                }
                                _modelDataInputO.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                                _modelDataInputO.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                                _modelDataInputO.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                            }
                            else
                            {
                                _modelDataInputO.choCMAQOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.doInputfromCmaq;
                                CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.baselineModelDataFile;
                                _modelDataInputO.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                                CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.forecastModelDataFile;
                                _modelDataInputO.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                                CommonClass.ssiasourcefile = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.SourceCoordinateFile;
                                _modelDataInputO.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                            }
                        }
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)    //added by K.B.
                        {
                            pnlUserControl.Controls.Add(new uc_ModelDataInputDep());
                            uc_ModelDataInputDep _modelInputDep = (pnlUserControl.Controls[0] as uc_ModelDataInputDep);
                            _modelInputDep.rbtnQuarterlyModelDataDep.Enabled = false;
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep = new SSIAModelDataInputDep();
                                _modelInputDep.rbtnDailyModelDataDep.Checked = true;
                                _modelInputDep.rbtnQuarterlyModelDataDep.Checked = false;
                                ////_modelInput.rbtnCMAQA.Checked = false;
                                ///
                                if (CommonClass.dicExampleConfiguration.ContainsKey("SSIADeposition"))
                                {
                                    //
                                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIADeposition"]["baselineModelFile"];
                                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIADeposition"]["forecastModelFile"]; ;
                                    CommonClass.ssiasourcefile = CommonClass.dicExampleConfiguration["SSIADeposition"]["sourceCoordinatesFile"];
                                }
                                else
                                {
                                    CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Deposition\mats.TDEP.12WUS1.2011eh_v6_11g+25fake3000_baseline.csv";
                                    CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Deposition\mats.TDEP.12WUS1.2011eh_v6_11g+25fake3000_13.csv";
                                    CommonClass.ssiasourcefile = Application.StartupPath + @"\Data\SampleData\SSIA\Deposition\mats.sourcecoords.12WUS1.tag013.csv";
                                }

                                _modelInputDep.txtBaselineDep.Text = Path.GetFileName(CommonClass.baseModelFile);

                                _modelInputDep.txtForecastDep.Text = Path.GetFileName(CommonClass.futureModelFile);

                                _modelInputDep.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                                //CommonClass.dispersionModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                //_modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);                              
                            }
                            else
                            {
                                _modelInputDep.rbtnDailyModelDataDep.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.DailyModelDataInput;
                                _modelInputDep.rbtnQuarterlyModelDataDep.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.QuarterlyModelDataInput;
                                ////_modelInput.rbtnCMAQA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.InputFromCMAQ;
                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.baselineModelDataFile))
                                {
                                    CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.baselineModelDataFile;
                                    _modelInputDep.txtBaselineDep.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }
                                else
                                {
                                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADeposition") ? CommonClass.dicExampleConfiguration["SSIADeposition"]["baselineModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\Deposition\mats.TDEP.12WUS1.2011eh_v6_11g+25fake3000_baseline.csv";
                                    _modelInputDep.txtBaselineDep.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }

                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.alternativeScenarioFile))
                                {
                                    CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.alternativeScenarioFile;
                                    _modelInputDep.txtForecastDep.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }
                                else
                                {
                                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADeposition") ? CommonClass.dicExampleConfiguration["SSIADeposition"]["forecastModelFile"] : Application.StartupPath + @"\Data\SampleData\SSIA\SSIA\Deposition\mats.TDEP.12WUS1.2011eh_v6_11g+25fake3000_13.csv";
                                    _modelInputDep.txtForecastDep.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }
                            }
                            CommonClass.ssiasourcefile = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.SourceCoordinateFile;
                            _modelInputDep.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                        }
                        break;
                    case "ssiamonitorinput":
                        lblSteps.Text = Language.Localization.GetValue("Monitor Data Input & Option");
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                        {
                            pnlUserControl.Controls.Add(new uc_MonitorDataInputA());
                            uc_MonitorDataInputA _monitorInput = (pnlUserControl.Controls[0] as uc_MonitorDataInputA);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA = new SSIAMonitorDataInputA();

                                CommonClass.officialPMFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM") ? CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["officialMonitorFile"] : (Application.StartupPath + @"\Data\SampleData\Monitor_data\official_annual-PM25_2002thru2017.csv");//official_annual-PM25_allFRM 121013.csv";official_annual-PM25_allFRM.NID2002thru2015_v2.csv
                                CommonClass.getmonitorYear("");
                                _monitorInput.txtOfficialMonitorA.Text = Path.GetFileName(CommonClass.officialPMFile);
                                _monitorInput.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                _monitorInput.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                if (_monitorInput.cboStartYearA.Items.Count > 7)
                                    _monitorInput.cboStartYearA.SelectedIndex = 6;
                                else
                                    _monitorInput.cboStartYearA.SelectedIndex = _monitorInput.cboStartYearA.Items.Count - 1;
                                if (_monitorInput.cboEndYearA.Items.Count > 11)
                                {
                                    _monitorInput.cboEndYearA.SelectedIndex = 10;
                                }
                                else
                                {
                                    _monitorInput.cboEndYearA.SelectedIndex = _monitorInput.cboEndYearA.Items.Count - 1;
                                }
                                _monitorInput.choVNA.Checked = true;
                                _monitorInput.choEVNA.Checked = true;
                                _monitorInput.cboPointGridA.Text = "1x1";
                            }
                            else
                            {
                                CommonClass.officialPMFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.officialMonitorDataFile;
                                _monitorInput.txtOfficialMonitorA.Text = Path.GetFileName(CommonClass.officialPMFile);
                                _monitorInput.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                _monitorInput.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                _monitorInput.cboStartYearA.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.monitorDataStartYear;
                                _monitorInput.cboEndYearA.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.monitorDataEndYear;
                                _monitorInput.choVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.useVNA;
                                _monitorInput.choEVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.useEVNA;
                                _monitorInput.cboPointGridA.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.temporalAdjustmentAtMonitorGrid;
                            }
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly)
                            {
                                _monitorInput.choVNA.Checked = true;
                                _monitorInput.choEVNA.Checked = false;
                                _monitorInput.choVNA.Enabled = false;
                                _monitorInput.choEVNA.Enabled = false;
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                        {
                            pnlUserControl.Controls.Add(new uc_MonitorDataInputD());
                            uc_MonitorDataInputD _monitorInputD = (pnlUserControl.Controls[0] as uc_MonitorDataInputD);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD = new SSIAMonitorDataInputD();

                                CommonClass.officialPMFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIADailyPM") ? CommonClass.dicExampleConfiguration["SSIADailyPM"]["officialMonitorFile"] : Application.StartupPath + @"\Data\SampleData\Monitor_data\official_24-hr-PM25.NID2002thru2015_v2.csv";
                                CommonClass.getmonitorYear("");
                                _monitorInputD.txtOfficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.officialPMFile);
                                _monitorInputD.cboStartYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                _monitorInputD.cboEndYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                if (_monitorInputD.cboStartYearD.Items.Count > 7)
                                    _monitorInputD.cboStartYearD.SelectedIndex = 6;
                                else
                                    _monitorInputD.cboStartYearD.SelectedIndex = _monitorInputD.cboStartYearD.Items.Count - 1;
                                if (_monitorInputD.cboEndYearD.Items.Count > 11)
                                {
                                    _monitorInputD.cboEndYearD.SelectedIndex = 10;
                                }
                                else
                                {
                                    _monitorInputD.cboEndYearD.SelectedIndex = _monitorInputD.cboEndYearD.Items.Count - 1;
                                }
                                _monitorInputD.choEVNA.Checked = true;
                                _monitorInputD.choVNA.Checked = true;
                            }
                            else
                            {
                                CommonClass.officialPMFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.officialMonitorDataFile;
                                _monitorInputD.txtOfficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.officialPMFile);
                                _monitorInputD.cboStartYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                _monitorInputD.cboEndYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                                _monitorInputD.cboStartYearD.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.monitorDataStartYear;
                                _monitorInputD.cboEndYearD.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.monitorDataEndYear;
                                _monitorInputD.choEVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.useEVNA;
                                _monitorInputD.choVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.useVNA;
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                        {
                            pnlUserControl.Controls.Add(new uc_MonitorDataInputO());
                            uc_MonitorDataInputO _monitorInputO = (pnlUserControl.Controls[0] as uc_MonitorDataInputO);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO = new SSIAMonitorDataInputO();
                                CommonClass.ozoneMonitorFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAOzone") ? CommonClass.dicExampleConfiguration["SSIAOzone"]["officialMonitorFile"] : Application.StartupPath + @"\Data\SampleData\Monitor_data\SMAT_OZONE_MAX4DV_STD70_2002_2015.CSV";
                                //MATS_OZONE_DV_2012_V2_off.csv";
                                CommonClass.getmonitorYear("");
                                _monitorInputO.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);

                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData.Sort();
                                List<string> year = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData;
                                for (int i = 0; i < year.Count; i++)
                                {
                                    _monitorInputO.cboStartYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                                    _monitorInputO.cboEndYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                                }

                                if (_monitorInputO.cboStartYearOzone.Items.Count >= 5)
                                    _monitorInputO.cboStartYearOzone.SelectedIndex = 4;
                                else
                                    _monitorInputO.cboStartYearOzone.SelectedIndex = _monitorInputO.cboStartYearOzone.Items.Count - 1;
                                if (_monitorInputO.cboEndYearOzone.Items.Count > 7)
                                    _monitorInputO.cboEndYearOzone.SelectedIndex = 6;
                                else
                                    _monitorInputO.cboEndYearOzone.SelectedIndex = _monitorInputO.cboEndYearOzone.Items.Count - 1;
                                _monitorInputO.choVNA.Checked = true;
                                _monitorInputO.choEVNA.Checked = true;
                                _monitorInputO.cboGridOzone.SelectedIndex = 1;
                                _monitorInputO.cboStatisticOzone.SelectedIndex = 2;

                                _monitorInputO.chkDS.Checked = false;
                                _monitorInputO.txtDSThin.Text = "1";
                                _monitorInputO.txtDSNumit.Text = "2500";
                                _monitorInputO.txtDSCmaqres.Text = "12";
                                _monitorInputO.txtDSBurn.Text = "500";
                            }
                            else
                            {
                                CommonClass.ozoneMonitorFile = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneMonitorDataFile;
                                _monitorInputO.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);

                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData.Sort();
                                List<string> year = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData;
                                for (int i = 0; i < year.Count; i++)
                                {
                                    _monitorInputO.cboStartYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                                    _monitorInputO.cboEndYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                                }
                                _monitorInputO.cboStartYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneStartYear;
                                _monitorInputO.cboEndYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneEndYear;
                                _monitorInputO.choVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useVNA;
                                _monitorInputO.choEVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useEVNA;
                                _monitorInputO.cboGridOzone.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.temporalAdjustmentAtMonitorGrid;
                                _monitorInputO.cboStatisticOzone.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.temporalAdjustmentType;

                                _monitorInputO.chkDS.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useDownscaler;
                                _monitorInputO.txtDSThin.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSThin.ToString();
                                _monitorInputO.txtDSNumit.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSNumit.ToString();
                                _monitorInputO.txtDSCmaqres.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSCmaqres.ToString();
                                _monitorInputO.txtDSBurn.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSBurn.ToString();
                            }
                        }
                        break;
                    case "ssiacalculationoption":
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                        {
                            pnlUserControl.Controls.Add(new uc_CalculationOption());
                            uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                                string iniPath = Application.StartupPath + @"\SMAT.ini";
                                if (File.Exists(iniPath))
                                {
                                    _calculation.txtNAAQS.Text = CommonClass.IniReadValue("annual pm calculation option", "NAAQS_value", iniPath);
                                    _calculation.txtThreshold.Text = CommonClass.IniReadValue("annual pm calculation option", "Threshold_value", iniPath);
                                    _calculation.nupdStartPercentage.Text = CommonClass.IniReadValue("annual pm calculation option", "Start_percentage", iniPath);
                                    _calculation.nupdEndPercentage.Text = CommonClass.IniReadValue("annual pm calculation option", "End_percentage", iniPath);
                                }
                                else
                                {
                                    _calculation.txtNAAQS.Text = "12";
                                    _calculation.txtThreshold.Text = "1";
                                    _calculation.nupdStartPercentage.Text = "0";
                                    _calculation.nupdEndPercentage.Text = "100";
                                }
                            }
                            else
                            {
                                _calculation.txtNAAQS.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.NAAQS.ToString();
                                _calculation.txtThreshold.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.threshold.ToString();
                                _calculation.nupdStartPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.startPercentage.ToString();
                                _calculation.nupdEndPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.endPercentage.ToString();
                            }
                            _calculation.lblNAAQS_Unit.Text = "(μg/m3) ";
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                        {
                            pnlUserControl.Controls.Add(new uc_CalculationOption());
                            uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                                string iniPath = Application.StartupPath + @"\SMAT.ini";
                                if (File.Exists(iniPath))
                                {
                                    _calculation.txtNAAQS.Text = CommonClass.IniReadValue("daily pm calculation option", "NAAQS_value", iniPath);
                                    _calculation.txtThreshold.Text = CommonClass.IniReadValue("daily pm calculation option", "Threshold_value", iniPath);
                                    _calculation.nupdStartPercentage.Text = CommonClass.IniReadValue("daily pm calculation option", "Start_percentage", iniPath);
                                    _calculation.nupdEndPercentage.Text = CommonClass.IniReadValue("daily pm calculation option", "End_percentage", iniPath);
                                }
                                else
                                {
                                    _calculation.txtNAAQS.Text = "35";
                                    _calculation.txtThreshold.Text = "1";
                                    _calculation.nupdStartPercentage.Text = "95";
                                    _calculation.nupdEndPercentage.Text = "98";
                                }
                            }
                            else
                            {
                                _calculation.txtNAAQS.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.NAAQS.ToString();
                                _calculation.txtThreshold.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.threshold.ToString();
                                _calculation.nupdStartPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.startPercentage.ToString();
                                _calculation.nupdEndPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.endPercentage.ToString();
                            }
                            _calculation.lblNAAQS_Unit.Text = "(μg/m3) ";
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                        {
                            pnlUserControl.Controls.Add(new uc_CalculationOption());
                            uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                                string iniPath = Application.StartupPath + @"\SMAT.ini";
                                if (File.Exists(iniPath))
                                {
                                    _calculation.txtNAAQS.Text = CommonClass.IniReadValue("ozone calculation option", "NAAQS_value", iniPath);
                                    _calculation.txtThreshold.Text = CommonClass.IniReadValue("ozone calculation option", "Threshold_value", iniPath);
                                    _calculation.nupdStartPercentage.Text = CommonClass.IniReadValue("ozone calculation option", "Start_percentage", iniPath);
                                    _calculation.nupdEndPercentage.Text = CommonClass.IniReadValue("ozone calculation option", "End_percentage", iniPath);
                                }
                                else
                                {
                                    _calculation.txtNAAQS.Text = "70";
                                    _calculation.txtThreshold.Text = "1";
                                    _calculation.nupdStartPercentage.Text = "95";
                                    _calculation.nupdEndPercentage.Text = "98";
                                }
                            }
                            else
                            {
                                _calculation.txtNAAQS.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.NAAQS.ToString();
                                _calculation.txtThreshold.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.threshold.ToString();
                                _calculation.nupdStartPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.startPercentage.ToString();
                                _calculation.nupdEndPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.endPercentage.ToString();
                            }
                            _calculation.lblNAAQS_Unit.Text = "(ppb) ";
                        }
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)    //added by K.B.
                        {
                            pnlUserControl.Controls.Add(new uc_CalculationOption());
                            uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                            _calculation.label5.Hide();
                            _calculation.label6.Hide();
                            _calculation.label7.Hide();
                            _calculation.label8.Hide();
                            _calculation.label9.Hide();
                            _calculation.nupdStartPercentage.Hide();
                            _calculation.nupdEndPercentage.Hide();
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption = new SSIACalculationOption();
                                string iniPath = Application.StartupPath + @"\SMAT.ini";
                                if (File.Exists(iniPath))
                                {
                                    //_calculation.txtNAAQS.Text = CommonClass.IniReadValue("deposition calculation option", "NAAQS_value", iniPath);
                                    _calculation.txtThreshold.Text = CommonClass.IniReadValue("deposition calculation option", "Threshold_value", iniPath);
                                    //_calculation.nupdStartPercentage.Text = CommonClass.IniReadValue("annual pm calculation option", "Start_percentage", iniPath);
                                    //_calculation.nupdEndPercentage.Text = CommonClass.IniReadValue("annual pm calculation option", "End_percentage", iniPath);
                                }
                                else
                                {
                                    //_calculation.txtNAAQS.Text = "0";
                                    _calculation.txtThreshold.Text = "0";
                                    //_calculation.nupdStartPercentage.Text = "0";
                                    //_calculation.nupdEndPercentage.Text = "100";
                                }
                            }
                            else
                            {
                                _calculation.txtNAAQS.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.NAAQS.ToString();
                                _calculation.txtThreshold.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.threshold.ToString();
                                //_calculation.nupdStartPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.startPercentage.ToString();
                                //_calculation.nupdEndPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.endPercentage.ToString();
                            }
                            _calculation.lblNAAQS_Unit.Text = "";
                        }
                        break;
                    #endregion
                    #region Annual PM China added by Edwin
                    case "modeldatainput":
                        pnlUserControl.Controls.Add(new uc_ModelDataChina());
                        uc_ModelDataChina modeldatachina = (pnlUserControl.Controls[0] as uc_ModelDataChina);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina == null)
                        {
                            //(CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina = new ModelDataInputChina();
                            //CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\XiAn_Model_Base_Quarterly.csv";
                            //modeldatachina.txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                            //CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\XiAn_Model_L_R_0.5_0.5_Quarterly.csv";
                            //modeldatachina.txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
                            modeldatachina.InitializeControl();
                        }
                        else
                        {
                            modeldatachina.InitializeControl();
                            //modeldatachina.rbtnQuarterlyAverageDataChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doQuarterlyAverageDataInput;
                            //modeldatachina.rbtnDailyAvertageDatalChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doDailyAverageDataInput;
                            //modeldatachina.rbtnCMAQChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doInputFromCMAQ;
                            //modeldatachina.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.scenarioName;
                            //CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.BaselineModelDataFile;
                            //modeldatachina.txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                            //CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.ControlModelDataFile;
                            //modeldatachina.txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
                        }
                        break;
                    case "monitordatainput":
                        pnlUserControl.Controls.Add(new uc_MonitorDataChina());
                        uc_MonitorDataChina monitordatachina = (pnlUserControl.Controls[0] as uc_MonitorDataChina);
                        monitordatachina.InitializeControl();
                        //if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina == null)
                        //{
                        //    (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina = new MonitorDataInputChina();
                        //   CommonClass.monitorFile = Application.Startuppath + @ "\data\sampledata\smat china\ quarterly average of PM25 measurement points in Shaanxi Province csv";
                        //    monitordatachina.txtOfficialMonitorChina.Text = Path.GetFileName(CommonClass.monitorFile);
                        //    CommonClass.getmonitorYear("");
                        //    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear);
                        //    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear);
                        //    for (int i = start; i <= end; i++)
                        //    {
                        //        monitordatachina.cboEndYearChina.Items.Add(i);
                        //        monitordatachina.cboStartYearChina.Items.Add(i);
                        //    }
                        //    monitordatachina.cboStartYearChina.SelectedIndex = 0;
                        //    monitordatachina.cboEndYearChina.SelectedIndex = end - start;
                        //}
                        //else
                        //{
                        //    monitordatachina.rbtnDailyMonitorChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doDailyMonitorDataInput;
                        //    monitordatachina.rbtnQuarterlyMonitorChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doQuarterlyMonitorDataInput;
                        //    monitordatachina.choIAdjustedFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doInterpolateAdjustedFRM;
                        //    monitordatachina.choIFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doInterpolateFRM;
                        //    monitordatachina.chkwVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNA;
                        //    monitordatachina.chkwVNAAdvance.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNAAdvancedOption;
                        //    monitordatachina.txtwVNAWeight.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.wVNAWeight.ToString();
                        //    monitordatachina.chkNS.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doNS;
                        //    monitordatachina.txtOfficialMonitorChina.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataInputFile;
                        //    monitordatachina.cboStartYearChina.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear;
                        //    monitordatachina.cboEndYearChina.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear;

                        //    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear);
                        //    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear);
                        //    for (int i = start; i <= end; i++)
                        //    {
                        //        monitordatachina.cboEndYearChina.Items.Add(i);
                        //        monitordatachina.cboStartYearChina.Items.Add(i);
                        //    }
                        //    monitordatachina.cboStartYearChina.SelectedIndex = 0;
                        //    monitordatachina.cboEndYearChina.SelectedIndex = end - start;
                        //}
                        break;
                    case "pm25speciesoption":
                        pnlUserControl.Controls.Add(new uc_PM25SpeciesOptionChina());
                        uc_PM25SpeciesOptionChina speciesoptionchina = (pnlUserControl.Controls[0] as uc_PM25SpeciesOptionChina);
                        speciesoptionchina.InitializeControl();
                        //if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina == null)
                        //{
                        //    (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina = new PM25SpeciesOptionChina();
                        //    CommonClass.speciesMonitorFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\PM25_Species_Fraction_Quarterly_2013_YRD.csv";
                        //    speciesoptionchina.txtSpeciesDataChina.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                        //}
                        //else
                        //{
                        //    speciesoptionchina.chkSpeciesFractionDataChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.PM25SpeciesFractionDataAvailable;
                        //    speciesoptionchina.txtSpeciesDataChina.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.SpeciesMonitorDataFile;
                        //}
                        break;
                    #endregion
                    #region Ozone China added by Edwin
                    case "modeldatainputozone":
                        pnlUserControl.Controls.Add(new uc_ModelDataOzoneChina());
                        uc_ModelDataOzoneChina modeldataozonechina = (pnlUserControl.Controls[0] as uc_ModelDataOzoneChina);
                        modeldataozonechina.InitializeControl();
                        //if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina == null)
                        //{
                        //    (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina = new ModelDataOzoneChina();
                        //    CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\Model_O3_Seasonal_2013_YRD.csv";
                        //    modeldataozonechina.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                        //    CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\Model_O3_Seasonal_2017_YRD.csv";
                        //    modeldataozonechina.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                        //}
                        //else
                        //{
                        //    modeldataozonechina.cboCMAQOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.doInputfromCmaq;
                        //    modeldataozonechina.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.scenarioName;
                        //    CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile;
                        //    modeldataozonechina.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                        //    CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile;
                        //    modeldataozonechina.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                        //}
                        break;
                    case "monitordatainputozone":
                        pnlUserControl.Controls.Add(new uc_MonitorDataOzoneChina());
                        uc_MonitorDataOzoneChina monitordataozonechina = (pnlUserControl.Controls[0] as uc_MonitorDataOzoneChina);
                        monitordataozonechina.InitializeControl();
                        //if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina == null)
                        //{
                        //    (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina = new MonitorDataOzoneChina();
                        //    CommonClass.ozoneMonitorFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\Ozone_Data_Seasonal_2013_YRD.csv";
                        //    monitordataozonechina.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);

                        //    CommonClass.getmonitorYear("");
                        //    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear);
                        //    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear);
                        //    for (int i = start; i <= end; i++)
                        //    {
                        //        monitordataozonechina.cboEndYearOzone.Items.Add(i);
                        //        monitordataozonechina.cboStartYearOzone.Items.Add(i);
                        //    }
                        //    monitordataozonechina.cboStartYearOzone.SelectedIndex = 0;
                        //    monitordataozonechina.cboEndYearOzone.SelectedIndex = end - start;
                        //}
                        //else
                        //{
                        //    monitordataozonechina.choIFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useVNA;
                        //    monitordataozonechina.choIAdjustedFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useEVNA;
                        //    monitordataozonechina.chkwVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNA;
                        //    monitordataozonechina.chkwVNAAdvance.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAAdvancedOption;
                        //    monitordataozonechina.chkNS.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useNS;
                        //    monitordataozonechina.txtwVNAWeight.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAWeight.ToString();
                        //    CommonClass.ozoneMonitorFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneMonitorDataFile;
                        //    monitordataozonechina.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                        //    monitordataozonechina.cboEndYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear;
                        //    monitordataozonechina.cboStartYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear;

                        //    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear);
                        //    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear);
                        //    for (int i = start; i <= end; i++)
                        //    {
                        //        monitordataozonechina.cboEndYearOzone.Items.Add(i);
                        //        monitordataozonechina.cboStartYearOzone.Items.Add(i);
                        //    }
                        //    monitordataozonechina.cboStartYearOzone.SelectedIndex = 0;
                        //    monitordataozonechina.cboEndYearOzone.SelectedIndex = end - start;
                        //}
                        break;
                    #endregion
                    #region BenMAP annual pm
                    case "modeldata":
                        pnlUserControl.Controls.Add(new uc_BenMAP_AnnualPM_ModelData());
                        _stips = trvAnalysis.Nodes[0].Text;
                        lblSteps.Text = _stips.Replace("&", "&&");
                        uc_BenMAP_AnnualPM_ModelData _modelA = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_ModelData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput = new BenMAPAnnualPMModel();
                            _modelA.rbtnDailyModelA.Checked = true;
                            CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["baselineModelDataFile"];// Application.StartupPath + @"\Data\SampleData\Model_data\SMAT.PM.Large.12.SE_US2.2011eh.camx.grid.csv";//PM_small_USA_12km_2011.csv";
                            _modelA.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["forecastModelDataFile"];//  Application.StartupPath + @"\Data\SampleData\Model_data\SMAT.PM.Large.12.SE_US2.2017eh.camx.grid.csv";//PM_small_USA_12km_2018.csv";
                            _modelA.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                            _modelA.cboSpatialGridA.SelectedIndex = 0;
                        }
                        else
                        {
                            _modelA.rbtnDailyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doDailyModelData;
                            _modelA.rbtnQuarterlyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doQuarterlyModelData;
                            _modelA.rbtnCMAQA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.doInputfromCMAQ;
                            CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.baselineFile;
                            _modelA.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.forecastFile;
                            _modelA.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                            _modelA.cboSpatialGridA.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput.temporalAdjustmentAtMonitorGridSpatial;
                        }
                        break;
                    case "monitordata":
                        pnlUserControl.Controls.Add(new uc_BenMAP_AnnualPM_MonitorData());
                        _stips = trvAnalysis.Nodes[1].Text;
                        lblSteps.Text = _stips.Replace("&", "&&");
                        uc_BenMAP_AnnualPM_MonitorData _monitorA = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_MonitorData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput = new BenMAPAnnualPMMonitor();
                            CommonClass.unofficialPMFile = CommonClass.dicExampleConfiguration["AnnualPM"]["unofficialMonitorDataFile"];//  Application.StartupPath + @"\Data\SampleData\Monitor_data\PM25ForFractions2002to2017.csv";//PM25ForFractions2002to2012.csv;
                            _monitorA.txtUnofficialMonitorA.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                            CommonClass.getmonitorYear("uc_BenMAP_AnnualPM_MonitorData");
                            _monitorA.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear.Distinct().ToList();
                            _monitorA.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear.Distinct().ToList();
                            if (_monitorA.cboStartYearA.Items.Count >= 9)
                                _monitorA.cboStartYearA.SelectedIndex = 8;
                            else
                                _monitorA.cboStartYearA.SelectedIndex = _monitorA.cboStartYearA.Items.Count - 1;
                            if (_monitorA.cboEndYearA.Items.Count >= 11)
                            {
                                _monitorA.cboEndYearA.SelectedIndex = 10;
                            }
                            else
                            {
                                _monitorA.cboEndYearA.SelectedIndex = _monitorA.cboEndYearA.Items.Count - 1;
                            }
                            _monitorA.choIFRMSpeA.Checked = true;
                            _monitorA.choIAdjustedFRMSpeA.Checked = true;

                            _monitorA.chkDS.Checked = false;
                            _monitorA.txtDSBurn.Text = "500";
                            _monitorA.txtDSCmaqres.Text = "12";
                            _monitorA.txtDSThin.Text = "1";
                            _monitorA.txtDSNumit.Text = "2500";
                        }
                        else
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear == null)
                            {
                                CommonClass.getmonitorYear("uc_BenMAP_AnnualPM_MonitorData");
                            }
                            _monitorA.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear.Distinct().ToList();
                            _monitorA.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.lstUnofficialYear.Distinct().ToList();
                            _monitorA.cboStartYearA.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.startYear;
                            _monitorA.cboEndYearA.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.endYear;
                            CommonClass.unofficialPMFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.unofficialFile;
                            _monitorA.txtUnofficialMonitorA.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                            _monitorA.choIFRMSpeA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.useVNA;
                            _monitorA.choIAdjustedFRMSpeA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.useEVNA;


                            _monitorA.chkDS.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.doDownscaler;
                            _monitorA.txtDSNumit.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.DS_Numit.ToString();
                            _monitorA.txtDSCmaqres.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.DS_Cmaqres.ToString();
                            _monitorA.txtDSThin.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.DS_Thin.ToString();
                            _monitorA.txtDSBurn.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput.DS_Burn.ToString();
                        }
                        break;
                    case "speciesdata":
                        pnlUserControl.Controls.Add(new uc_BenMAP_AnnualPM_SpeciesData());
                        _stips = trvAnalysis.Nodes[2].Text;
                        lblSteps.Text = _stips.Replace("&", "&&");
                        uc_BenMAP_AnnualPM_SpeciesData _speciesA = (pnlUserControl.Controls[0] as uc_BenMAP_AnnualPM_SpeciesData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput = new BenMAPAnnualPMSpecies();
                            _speciesA.rbtnMonitorFileA.Checked = true;
                            CommonClass.speciesMonitorFile = CommonClass.dicExampleConfiguration["AnnualPM"]["speciesMonitorDataFile"];// Application.StartupPath + @"\Data\SampleData\Monitor_data\SpeciesForFractions2002to2015_v2.csv";//SpeciesForFractions2002to2012.csv;
                            _speciesA.txtMonitorFileA.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                            CommonClass.getmonitorYear("uc_BenMAP_AnnualPM_SpeciesData");
                            _speciesA.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear.Distinct().ToList();
                            _speciesA.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear.Distinct().ToList();
                            if (_speciesA.cboStartYearA.Items.Count >= 9)
                                _speciesA.cboStartYearA.SelectedIndex = 8;
                            else
                                _speciesA.cboStartYearA.SelectedIndex = _speciesA.cboStartYearA.Items.Count - 1;
                            if (_speciesA.cboEndYearA.Items.Count >= 11)
                            {
                                _speciesA.cboEndYearA.SelectedIndex = 10;
                            }
                            else
                            {
                                _speciesA.cboEndYearA.SelectedIndex = _speciesA.cboEndYearA.Items.Count - 1;
                            }
                        }
                        else
                        {
                            _speciesA.rbtnMonitorFileA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.doSpeciesMonitorDataFile;
                            CommonClass.speciesMonitorFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.speciesMonitorDataFile;
                            _speciesA.txtMonitorFileA.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear == null)
                                CommonClass.getmonitorYear("uc_BenMAP_AnnualPM_SpeciesData");
                            _speciesA.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear.Distinct().ToList();
                            _speciesA.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.lstSpeciesYear.Distinct().ToList();
                            _speciesA.cboStartYearA.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.startYear;
                            _speciesA.cboEndYearA.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.endYear;
                            _speciesA.rbtnFractionA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.doSpeciesFractionFile;
                            CommonClass.speciesFractionFilePoint = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.specFracSpatialFile;
                            _speciesA.txtFractionSpatialA.Text = Path.GetFileName(CommonClass.speciesFractionFilePoint);
                            CommonClass.speciesFractionFileSpatial = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput.gradAdjSpecFracSpatialFile;
                            _speciesA.txtgradadjFractionSpatialA.Text = Path.GetFileName(CommonClass.speciesFractionFileSpatial);
                        }
                        break;
                    case "griddefinition":
                        pnlUserControl.Controls.Add(new uc_BenMAP_GridDefinition());
                        lblSteps.Text = trvAnalysis.Nodes[3].Text;
                        _stips = lblSteps.Text;
                        uc_BenMAP_GridDefinition _grid = (pnlUserControl.Controls[0] as uc_BenMAP_GridDefinition);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile == null)
                        {
                            CommonClass.shapefile = Application.StartupPath + @"\Data\ShapeFiles\CMAQ_12km_Nation.shp";
                            _grid.txtGridDefinition.Text = Path.GetFileName(CommonClass.shapefile);
                        }
                        else
                        {
                            CommonClass.shapefile = (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile;
                            _grid.txtGridDefinition.Text = Path.GetFileName(CommonClass.shapefile);
                        }
                        break;
                    #endregion
                    #region BenMap Ozone
                    case "benmapozonemodeldata":
                        pnlUserControl.Controls.Add(new uc_BenMap_Ozone_ModelData());
                        _stips = trvAnalysis.Nodes[0].Text;
                        lblSteps.Text = _stips.Replace("&", "&&");
                        uc_BenMap_Ozone_ModelData BenMapOzoneModel = (pnlUserControl.Controls[0] as uc_BenMap_Ozone_ModelData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput = new BenMAPOzoneModel();
                            CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["Ozone"]["baselineModelDataFile"];//Application.StartupPath + @"\Data\SampleData\O3_small_USA_12km_2011.csv";
                            BenMapOzoneModel.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["Ozone"]["forecastModelDataFile"];//   Application.StartupPath + @"\Data\SampleData\O3_small_USA_12km_2018.csv";
                            BenMapOzoneModel.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                        }
                        else
                        {
                            CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.baselineModelDataFile;
                            BenMapOzoneModel.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput.forecastModelDataFile;
                            BenMapOzoneModel.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                        }
                        break;
                    case "benmapozonemonitordata":
                        pnlUserControl.Controls.Add(new uc_BenMap_Ozone_MonitorData());
                        _stips = trvAnalysis.Nodes[1].Text;
                        lblSteps.Text = _stips.Replace("&", "&&");
                        uc_BenMap_Ozone_MonitorData BenMapOzoneMonitor = (pnlUserControl.Controls[0] as uc_BenMap_Ozone_MonitorData);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput = new BenMapOzoneMonitor();
                            CommonClass.ozoneMonitorFile = CommonClass.dicExampleConfiguration["Ozone"]["ozoneMonitorDataFile"];//  Application.StartupPath + @"\Data\SampleData\Monitor_data\SMAT_OZONE_MAX4DV_STD70_2002_2015.CSV";//MATS_OZONE_DV_2012_V2_off.csv";
                            BenMapOzoneMonitor.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                            BenMapOzoneMonitor.choVNA.Checked = true;
                            BenMapOzoneMonitor.choEVNA.Checked = true;
                            CommonClass.getmonitorYear("uc_BenMap_Ozone_MonitorData");

                            (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.lstOzoneMonitorData.Sort();
                            List<string> year = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.lstOzoneMonitorData;
                            for (int i = 0; i < year.Count; i++)
                            {
                                BenMapOzoneMonitor.cboStartYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                                BenMapOzoneMonitor.cboEndYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                            }

                            if (BenMapOzoneMonitor.cboStartYearOzone.Items.Count >= 9) BenMapOzoneMonitor.cboStartYearOzone.SelectedIndex = 8;
                            else BenMapOzoneMonitor.cboStartYearOzone.SelectedIndex = BenMapOzoneMonitor.cboStartYearOzone.Items.Count - 1;
                            if (BenMapOzoneMonitor.cboEndYearOzone.Items.Count > 10) BenMapOzoneMonitor.cboEndYearOzone.SelectedIndex = 9;
                            else BenMapOzoneMonitor.cboEndYearOzone.SelectedIndex = BenMapOzoneMonitor.cboEndYearOzone.Items.Count - 1;
                        }
                        else
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.lstOzoneMonitorData == null)
                            {
                                CommonClass.getmonitorYear("uc_BenMap_Ozone_MonitorData");
                            }
                            List<string> year = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.lstOzoneMonitorData;
                            for (int i = 0; i < year.Count; i++)
                            {
                                BenMapOzoneMonitor.cboStartYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                                BenMapOzoneMonitor.cboEndYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                            }
                            BenMapOzoneMonitor.cboStartYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneStartYear;
                            BenMapOzoneMonitor.cboEndYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneEndYear;

                            CommonClass.ozoneMonitorFile = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.ozoneMonitorDataFile;
                            BenMapOzoneMonitor.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                            BenMapOzoneMonitor.choVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.useVNA;
                            BenMapOzoneMonitor.choEVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput.useEVNA;
                        }
                        break;
                    case "benmapozonegriddefinition":
                        pnlUserControl.Controls.Add(new uc_BenMAP_GridDefinition());
                        lblSteps.Text = trvAnalysis.Nodes[2].Text;
                        _stips = lblSteps.Text;
                        uc_BenMAP_GridDefinition _gridozone = (pnlUserControl.Controls[0] as uc_BenMAP_GridDefinition);
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile == null)
                        {
                            CommonClass.shapefile = Application.StartupPath + @"\Data\ShapeFiles\CMAQ_12km_Nation.shp";
                            _gridozone.txtGridDefinition.Text = Path.GetFileName(CommonClass.shapefile);
                        }
                        else
                        {
                            CommonClass.shapefile = (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile;
                            _gridozone.txtGridDefinition.Text = Path.GetFileName(CommonClass.shapefile);
                        }
                        break;
                        #endregion
                }
                _stips = trvAnalysis.SelectedNode.ToolTipText.ToString();
                tips.SetToolTip(pboHelp, _stips);
                pnlUserControl.Refresh();
                lblSteps.Refresh();
                trvAnalysis.Refresh();
                //As long as user do some setting, the save scenario button is enabled.
                switch (CommonClass.CurrentAnalysis)
                {
                    case enumAnalysis.AnnualPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                            || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA != null
                            || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                            && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA != null
                            && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    case enumAnalysis.DailyPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null
                        || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD != null
                        || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null
                            && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD != null
                           && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    case enumAnalysis.Ozone:
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null
                           || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null
                          && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    case enumAnalysis.Visibility:
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV != null || (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV != null
                            || (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV != null && (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV != null
                            && (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    case enumAnalysis.SSIAAnnualPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA != null && (((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    case enumAnalysis.SSIADailyPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD != null && (((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    case enumAnalysis.SSIAOzone:
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO != null && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO != null && (((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    case enumAnalysis.SSIADeposition:    //added by K.B.
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep != null || (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep != null || (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).monitorInputDep != null || (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep != null && (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep != null && (((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).monitorInputDep != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    #region Annual PM China added by Edwin
                    case enumAnalysis.AnnualPMChina:
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    #endregion
                    #region Ozone China added by Edwin
                    case enumAnalysis.OzoneChina:
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina != null)
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina != null)
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    #endregion
                    #region BenMap Annual
                    case enumAnalysis.BenMAPAnnualPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput != null || !string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile))
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput != null && !string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).gridDefinitionFile))
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                    #endregion
                    #region BenMap Ozone
                    case enumAnalysis.BenMAPSeasonalOzone:
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput != null || !string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile))
                        {
                            btnSave.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput != null && !string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).gridDefinitionFile))
                        {
                            btnSaveRun.Enabled = true;
                        }
                        break;
                        #endregion
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }

        /// <summary>
        /// operation for next/back button
        /// </summary>
        public void NextBackOperation()
        {
            try
            {
                string errorTips = SaveCurrentUCConfiguration();
                if (errorTips != null && errorTips.Length > 0)
                {
                    MessageBox.Show(errorTips, Language.Localization.GetValue("Tip"), MessageBoxButtons.OK);
                    return;
                }

                string loadUCName = "";
                if (isNext)
                {
                    switch (pnlUserControl.Controls[0].Name)
                    {
                        #region annual pm
                        case "uc_OutputA":
                            loadUCName = "uc_OutputAdvancedA";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        case "uc_OutputAdvancedA":
                            loadUCName = "uc_DataInputA";
                            break;
                        case "uc_DataInputA":
                            loadUCName = "uc_SpeciesFractionsCalculationOptionsA";
                            break;
                        case "uc_SpeciesFractionsCalculationOptionsA":
                            loadUCName = "uc_PM25CalculationOptionsA";
                            break;
                        case "uc_PM25CalculationOptionsA":
                            loadUCName = "uc_ModelDataA";
                            break;
                        #endregion
                        #region Daily
                        case "uc_OutputD":
                            loadUCName = "uc_OutputAdvancedD";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        case "uc_OutputAdvancedD":
                            loadUCName = "uc_DataInputD";
                            break;
                        case "uc_DataInputD":
                            loadUCName = "uc_SpeciesFrctionD";
                            break;
                        case "uc_SpeciesFrctionD":
                            loadUCName = "uc_PM25CalculationD";
                            break;
                        case "uc_PM25CalculationD":
                            loadUCName = "uc_ModelDataD";
                            break;
                        #endregion
                        #region Ozone added by devin
                        case "uc_DesiredOutputOzone":
                            loadUCName = "uc_DataInputOzone";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        case "uc_DataInputOzone":
                            loadUCName = "uc_FilteringorInterpolationOzone";
                            break;
                        case "uc_FilteringorInterpolationOzone":
                            loadUCName = "uc_RRForSpatialGradientOzone";
                            break;
                        #endregion
                        #region Visibility added by devin
                        case "uc_ChooseDesiredOutputV":
                            loadUCName = "uc_DataInputV";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        case "uc_DataInputV":
                            loadUCName = "uc_FilteringV";
                            break;
                        #endregion
                        #region SSIA
                        case "uc_AnalysisOption":
                            if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                                loadUCName = "uc_ModelDataInputA";
                            else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                                loadUCName = "uc_ModelDataInputD";
                            else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                                loadUCName = "uc_ModelDataInputO";
                            else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)    //added by K.B.
                                loadUCName = "uc_ModelDataInputDep";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        case "uc_ModelDataInputA":
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData)
                                loadUCName = "uc_MonitorDataInputA";
                            else
                                loadUCName = "uc_CalculationOption";
                            break;
                        case "uc_ModelDataInputD":
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData)
                                loadUCName = "uc_MonitorDataInputD";
                            else
                                loadUCName = "uc_CalculationOption";
                            break;
                        case "uc_ModelDataInputO":
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData)
                                loadUCName = "uc_MonitorDataInputO";
                            else
                                loadUCName = "uc_CalculationOption";
                            break;
                        case "uc_ModelDataInputDep":                      //added by K.B.     
                            loadUCName = "uc_CalculationOption";
                            break;
                        case "uc_MonitorDataInputA":
                            loadUCName = "uc_CalculationOption";
                            break;
                        case "uc_MonitorDataInputD":
                            loadUCName = "uc_CalculationOption";
                            break;
                        case "uc_MonitorDataInputO":
                            loadUCName = "uc_CalculationOption";
                            break;
                        #endregion
                        #region Annual PM China
                        case "uc_ModelDataChina":
                            loadUCName = "uc_MonitorDataChina";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        case "uc_MonitorDataChina":
                            loadUCName = "uc_PM25SpeciesOptionChina";
                            break;
                        #endregion
                        #region Ozone China
                        case "uc_ModelDataOzoneChina":
                            loadUCName = "uc_MonitorDataOzoneChina";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        #endregion
                        #region BenMAP annual pm
                        case "uc_BenMAP_AnnualPM_ModelData":
                            loadUCName = "uc_BenMAP_AnnualPM_MonitorData";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        case "uc_BenMAP_AnnualPM_MonitorData":
                            loadUCName = "uc_BenMAP_AnnualPM_SpeciesData";
                            break;
                        case "uc_BenMAP_AnnualPM_SpeciesData":
                            loadUCName = "uc_BenMAP_GridDefinition";
                            break;
                        #endregion
                        #region BenMAP Ozone
                        case "uc_BenMap_Ozone_ModelData":
                            loadUCName = "uc_BenMap_Ozone_MonitorData";
                            btnBack.Enabled = true;
                            btnBack.Image = Resources.Back;
                            break;
                        case "uc_BenMap_Ozone_MonitorData":
                            loadUCName = "uc_BenMAP_GridDefinition";
                            break;
                            #endregion
                    }
                }
                else
                {
                    switch (pnlUserControl.Controls[0].Name)
                    {
                        #region annual pm
                        case "uc_OutputAdvancedA":
                            loadUCName = "uc_OutputA";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_DataInputA":
                            loadUCName = "uc_OutputAdvancedA";
                            break;
                        case "uc_SpeciesFractionsCalculationOptionsA":
                            loadUCName = "uc_DataInputA";
                            break;
                        //case "uc_SpeciesFractionAdvancedA":
                        //    loadUCName = "uc_SpeciesFractionsCalculationOptionsA";
                        //    break;
                        case "uc_PM25CalculationOptionsA":
                            loadUCName = "uc_SpeciesFractionsCalculationOptionsA";
                            break;
                        case "uc_ModelDataA":
                            loadUCName = "uc_PM25CalculationOptionsA";
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "":
                            break;
                        #endregion
                        #region Daily
                        case "uc_OutputAdvancedD":
                            loadUCName = "uc_OutputD";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_DataInputD":
                            loadUCName = "uc_OutputAdvancedD";
                            break;
                        case "uc_SpeciesFrctionD":
                            loadUCName = "uc_DataInputD";
                            break;
                        //case "uc_SpeciesFractionAdvancedD":
                        //    loadUCName = "uc_SpeciesFrctionD";
                        //    break;
                        case "uc_PM25CalculationD":
                            loadUCName = "uc_SpeciesFrctionD";
                            break;
                        case "uc_ModelDataD":
                            loadUCName = "uc_PM25CalculationD";
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        #endregion
                        #region Ozone added by devin
                        case "uc_DataInputOzone":
                            loadUCName = "uc_DesiredOutputOzone";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_FilteringorInterpolationOzone":
                            loadUCName = "uc_DataInputOzone";
                            break;
                        case "uc_RRForSpatialGradientOzone":
                            loadUCName = "uc_FilteringorInterpolationOzone";
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        #endregion
                        #region Visibility added by devin
                        case "uc_DataInputV":
                            loadUCName = "uc_ChooseDesiredOutputV";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;

                        case "uc_FilteringV":
                            loadUCName = "uc_DataInputV";
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;

                        #endregion
                        #region SSIA
                        case "uc_ModelDataInputA":
                            loadUCName = "uc_AnalysisOption";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_MonitorDataInputA":
                            loadUCName = "uc_ModelDataInputA";
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_ModelDataInputD":
                            loadUCName = "uc_AnalysisOption";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_ModelDataInputDep":                 //added by K.B.
                            loadUCName = "uc_AnalysisOption";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_MonitorDataInputD":
                            loadUCName = "uc_ModelDataInputD";
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_ModelDataInputO":
                            loadUCName = "uc_AnalysisOption";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_MonitorDataInputO":
                            loadUCName = "uc_ModelDataInputO";
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_CalculationOption":
                            if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                            {
                                if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData)
                                    loadUCName = "uc_MonitorDataInputA";
                                else
                                    loadUCName = "uc_ModelDataInputA";
                            }
                            else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                            {
                                if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData)
                                    loadUCName = "uc_MonitorDataInputD";
                                else
                                    loadUCName = "uc_ModelDataInputD";
                            }
                            else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                            {
                                if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData)
                                    loadUCName = "uc_MonitorDataInputO";
                                else
                                    loadUCName = "uc_ModelDataInputO";
                            }
                            else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)    //added by K.B.
                            {
                                loadUCName = "uc_ModelDataInputDep";
                            }
                            break;
                        #endregion
                        #region Annual PM China
                        case "uc_MonitorDataChina":
                            loadUCName = "uc_ModelDataChina";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_PM25SpeciesOptionChina":
                            loadUCName = "uc_MonitorDataChina";
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        #endregion
                        #region Ozone China
                        case "uc_MonitorDataOzoneChina":
                            loadUCName = "uc_ModelDataOzoneChina";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        #endregion
                        #region BenMAP annual pm
                        case "uc_BenMAP_AnnualPM_MonitorData":
                            loadUCName = "uc_BenMAP_AnnualPM_ModelData";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            btnNext.Enabled = true;
                            btnNext.Image = Resources.Next1;
                            break;
                        case "uc_BenMAP_AnnualPM_SpeciesData":
                            loadUCName = "uc_BenMAP_AnnualPM_MonitorData";
                            break;
                        case "uc_BenMAP_GridDefinition":
                            if (CommonClass.CurrentAnalysis == enumAnalysis.BenMAPAnnualPM) loadUCName = "uc_BenMAP_AnnualPM_SpeciesData";
                            else if (CommonClass.CurrentAnalysis == enumAnalysis.BenMAPSeasonalOzone) loadUCName = "uc_BenMap_Ozone_MonitorData";
                            break;
                        #endregion
                        #region BenMAP Ozone
                        case "uc_BenMap_Ozone_MonitorData":
                            loadUCName = "uc_BenMap_Ozone_ModelData";
                            btnBack.Enabled = false;
                            btnBack.Image = Resources.Back_gray;
                            break;
                            //case "uc_BenMAP_GridDefinition":
                            //    loadUCName = "uc_BenMap_Ozone_MonitorData";
                            //break;
                            #endregion
                    }
                }

                if (this.pnlUserControl.Controls.Count != 0)
                {
                    this.pnlUserControl.Controls.Clear();
                }
                switch (loadUCName)
                {
                    #region annual
                    case "uc_OutputA":
                        pnlUserControl.Controls.Add(new uc_OutputA());
                        lblSteps.Text = trvAnalysis.Nodes[0].Text;
                        _stips = "Choose Desired Output";
                        uc_OutputA _outPutA = (pnlUserControl.Controls[0] as uc_OutputA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA = new ChooseDesiredOutputA();
                            _outPutA.choStandardAnalysisA.Checked = true;
                            _outPutA.choQuarterlyModelDataA.Checked = true;
                            _outPutA.choQuarterlyModelDataUsedA.Checked = true;
                            _outPutA.choSpeciesFractionOutputA.Checked = true;
                            _outPutA.choActionsCompletionA.Checked = true;
                        }
                        else
                        {
                            _outPutA.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.scenarioName;
                            _outPutA.choStandardAnalysisA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doStandardAnalysis;
                            _outPutA.choQuarterlyModelDataA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doQuarterlyModelData;
                            _outPutA.choQuarterlyModelDataUsedA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doUsedQuarterlyAvgModelData;
                            _outPutA.choSpeciesFractionOutputA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doSpeciesFraction;
                            _outPutA.choActionsCompletionA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA.doAutomaticallyExtract;
                        }
                        break;
                    case "uc_OutputAdvancedA":
                        pnlUserControl.Controls.Add(new uc_OutputAdvancedA());
                        lblSteps.Text = trvAnalysis.Nodes[1].Text;
                        _stips = "Select advanced output choices";
                        uc_OutputAdvancedA _outputAdvancedA = (pnlUserControl.Controls[0] as uc_OutputAdvancedA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA = new OutputChoiceAdvancedA();
                            _outputAdvancedA.choQuaPointA.Checked = true;
                            _outputAdvancedA.choFileCA.Checked = true;
                            _outputAdvancedA.choFileEA.Checked = true;
                        }
                        else
                        {
                            _outputAdvancedA.choIFRMSpeA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj;
                            _outputAdvancedA.choBaseOnlyVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyVNA;
                            _outputAdvancedA.choFutureOnlyVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyVNA;
                            _outputAdvancedA.choIAdjustedFRMSpeA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj;
                            _outputAdvancedA.choBaseOnlyEvna.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyEvna;
                            _outputAdvancedA.choFutureOnlyEvna.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyEvna;
                            _outputAdvancedA.choQuaPointA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFilePoint;
                            _outputAdvancedA.choQuaSpatialA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial;
                            _outputAdvancedA.choQuaSpaGraAdjA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_GraAdj;
                            _outputAdvancedA.choFileCA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doHighCountySites;
                            _outputAdvancedA.choSpeSpatialFieldA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial;
                            _outputAdvancedA.choSpeSpaGraAdjA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj;
                            _outputAdvancedA.choFileEA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgSpeciatedMonitors;
                            _outputAdvancedA.choDVPeriods.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doDesignValuePeriods;
                            _outputAdvancedA.choNeiPointA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doNeighborFilePoint;
                            _outputAdvancedA.choNeiSpatialA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doNeighborFileSpatial;

                            _outputAdvancedA.chkDS.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doDS;
                            _outputAdvancedA.chkDSOnlyBase.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doBaseOnlyDS;
                            _outputAdvancedA.chkDSOnlyFuture.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doFutureOnlyDS;
                            _outputAdvancedA.txtDSBurn.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Burn.ToString();
                            _outputAdvancedA.txtDSCmaqres.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Cmaqres.ToString();
                            _outputAdvancedA.txtDSThin.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Thin.ToString();
                            _outputAdvancedA.txtDSNumit.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.DS_Numit.ToString();
                            _outputAdvancedA.choQuaSpaDSA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doQuarterlyAvgFileSpatial_DS;
                            _outputAdvancedA.choSpeSpaDSA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA.doSpeciesFractionSpatial_DS;


                        }
                        break;
                    case "uc_DataInputA":
                        pnlUserControl.Controls.Add(new uc_DataInputA());
                        uc_DataInputA _dataInputA = (pnlUserControl.Controls[0] as uc_DataInputA);
                        lblSteps.Text = trvAnalysis.Nodes[2].Text;
                        _stips = "Select input files for the analysis";
                        //DataInputFile dataInputFile = new DataInputFile();
                        _dataInputA.InitializeControl();
                        break;
                    case "uc_SpeciesFractionsCalculationOptionsA":
                        pnlUserControl.Controls.Add(new uc_SpeciesFractionsCalculationOptionsA());
                        lblSteps.Text = trvAnalysis.Nodes[3].Text;
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        trvAnalysis.Refresh();
                        _stips = "Set up species fraction options";
                        uc_SpeciesFractionsCalculationOptionsA _speciesFractionOptionsA = (pnlUserControl.Controls[0] as uc_SpeciesFractionsCalculationOptionsA);
                        _speciesFractionOptionsA.cboIMPROVEStartYaerA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFractionOptionsA.cboIMPROVEEndYaerA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFractionOptionsA.cboPMStartYaerA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFractionOptionsA.cboPMEndYaerA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA = new SpeciesFractionOptionsA();
                            if (_speciesFractionOptionsA.cboIMPROVEStartYaerA.Items.Count >= 9)
                                _speciesFractionOptionsA.cboIMPROVEStartYaerA.SelectedIndex = 8;
                            else
                                _speciesFractionOptionsA.cboIMPROVEStartYaerA.SelectedIndex = _speciesFractionOptionsA.cboIMPROVEStartYaerA.Items.Count - 1;
                            if (_speciesFractionOptionsA.cboIMPROVEEndYaerA.Items.Count >= 11)
                            {
                                _speciesFractionOptionsA.cboIMPROVEEndYaerA.SelectedIndex = 10;
                            }
                            else
                            {
                                _speciesFractionOptionsA.cboIMPROVEEndYaerA.SelectedIndex = _speciesFractionOptionsA.cboIMPROVEEndYaerA.Items.Count - 1;
                            }
                            if (_speciesFractionOptionsA.cboPMStartYaerA.Items.Count >= 9)
                                _speciesFractionOptionsA.cboPMStartYaerA.SelectedIndex = 8;
                            else
                                _speciesFractionOptionsA.cboPMStartYaerA.SelectedIndex = _speciesFractionOptionsA.cboPMStartYaerA.Items.Count - 1;
                            if (_speciesFractionOptionsA.cboPMEndYaerA.Items.Count >= 11)
                            {
                                _speciesFractionOptionsA.cboPMEndYaerA.SelectedIndex = 10;
                            }
                            else
                            {
                                _speciesFractionOptionsA.cboPMEndYaerA.SelectedIndex = _speciesFractionOptionsA.cboPMEndYaerA.Items.Count - 1;
                            }
                            _speciesFractionOptionsA.choIMPROVEEPADeletionsA.Checked = true;
                            _speciesFractionOptionsA.choPMEPADeletionsA.Checked = true;
                            _speciesFractionOptionsA.nudownIMPROVEMinDaysA.Value = 11;
                            _speciesFractionOptionsA.nudownIMPROVEMinYearsA.Value = 1;
                            _speciesFractionOptionsA.nudownIMPROVEMinSeasonsA.Value = 1;
                            _speciesFractionOptionsA.nudownPMMinDaysA.Value = 11;
                            _speciesFractionOptionsA.nudownPMMinYearsA.Value = 1;
                            _speciesFractionOptionsA.nudownPMMinPointA.Value = 4;
                            _speciesFractionOptionsA.nudownPMMinSpatialA.Value = 1;
                            _speciesFractionOptionsA.choAdvancedOptions.Checked = false;

                            #region species options advanced
                            _speciesFractionOptionsA.cboItpCrustalA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpDONA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpECA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpNH4A.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpNO3A.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpOCA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpPM25A.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpSaltA.SelectedIndex = 2;
                            _speciesFractionOptionsA.cboItpSO4A.SelectedIndex = 2;
                            _speciesFractionOptionsA.nudownCrustalDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownDONDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownECDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownNH4DistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownNO3DistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownOCDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownPM25DistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownSaltDistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.nudownSO4DistanceA.Value = 9000000000;
                            _speciesFractionOptionsA.cboItpPM25A.Enabled = false;
                            _speciesFractionOptionsA.nudownPM25DistanceA.Enabled = false;
                            _speciesFractionOptionsA.rbtnDONA.Checked = true;
                            _speciesFractionOptionsA.cboItpNH4A.Enabled = false;
                            _speciesFractionOptionsA.nudownNH4DistanceA.Enabled = false;
                            _speciesFractionOptionsA.nudownNH4PercentageA.Enabled = false;
                            _speciesFractionOptionsA.nudownNH4PercentageA.Value = 0;
                            _speciesFractionOptionsA.nudownDefaultMassA.Value = 0.2M;
                            _speciesFractionOptionsA.nudownOCmbFloorA.Value = 1;
                            _speciesFractionOptionsA.nudownOCmbCeilingA.Value = 0.8M;
                            #endregion
                        }
                        else
                        {
                            _speciesFractionOptionsA.cboIMPROVEStartYaerA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_StartYear;
                            _speciesFractionOptionsA.cboIMPROVEEndYaerA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_EndYear;
                            _speciesFractionOptionsA.choIMPROVEEPADeletionsA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_EPADeletionChoice;
                            _speciesFractionOptionsA.choIMPROVEUserDeletionA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_UserDeletionChoice;
                            _speciesFractionOptionsA.nudownIMPROVEMinDaysA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinDays;
                            _speciesFractionOptionsA.nudownIMPROVEMinYearsA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinYear;
                            _speciesFractionOptionsA.nudownIMPROVEMinSeasonsA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.IMPROVESTN_MinSeasons;
                            _speciesFractionOptionsA.cboPMStartYaerA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialStartYear;
                            _speciesFractionOptionsA.cboPMEndYaerA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialEndYear;
                            _speciesFractionOptionsA.choPMEPADeletionsA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialEPADeletionChoice;
                            _speciesFractionOptionsA.choPMUserDeletionA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialUserDeletionChoice;
                            _speciesFractionOptionsA.nudownPMMinDaysA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinDays;
                            _speciesFractionOptionsA.nudownPMMinYearsA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinYears;
                            _speciesFractionOptionsA.nudownPMMinPointA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinSeasonsPoint;
                            _speciesFractionOptionsA.nudownPMMinSpatialA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.unofficialMinSeasonsSpatial;
                            _speciesFractionOptionsA.choAdvancedOptions.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.doAdvancedOptionsForSpeciesFraction;

                            #region advanced options
                            _speciesFractionOptionsA.cboItpPM25A.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodPM25;
                            _speciesFractionOptionsA.nudownPM25DistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distancePM25;
                            _speciesFractionOptionsA.cboItpSO4A.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodSO4;
                            _speciesFractionOptionsA.nudownSO4DistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceSO4;
                            _speciesFractionOptionsA.cboItpNO3A.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodNO3;
                            _speciesFractionOptionsA.nudownNO3DistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceNO3;
                            _speciesFractionOptionsA.cboItpECA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodEC;
                            _speciesFractionOptionsA.nudownECDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceEC;
                            _speciesFractionOptionsA.cboItpSaltA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodSalt;
                            _speciesFractionOptionsA.nudownSaltDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceSalt;
                            _speciesFractionOptionsA.cboItpCrustalA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodCrustal;
                            _speciesFractionOptionsA.nudownCrustalDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceCrustal;
                            _speciesFractionOptionsA.cboItpDONA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodDON;
                            _speciesFractionOptionsA.nudownDONDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceDON;
                            _speciesFractionOptionsA.cboItpOCA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodOC;
                            _speciesFractionOptionsA.nudownOCDistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceOC;
                            _speciesFractionOptionsA.cboItpNH4A.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.interpolationMethodNH4;
                            _speciesFractionOptionsA.nudownNH4DistanceA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.distanceNH4;
                            _speciesFractionOptionsA.rbtnDONA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.doUseDonValues;
                            _speciesFractionOptionsA.rbtnMeasuredA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.doUseAmmoniumValues;
                            _speciesFractionOptionsA.nudownNH4PercentageA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.nh4PercentageEvaporating;
                            _speciesFractionOptionsA.nudownDefaultMassA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.defaultBlankMass;
                            _speciesFractionOptionsA.nudownOCmbFloorA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.floorOCMMB;
                            _speciesFractionOptionsA.nudownOCmbCeilingA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA.ceilingOCMMB;
                            #endregion
                        }
                        //if (Convert.ToInt32(_speciesFractionOptionsA.cboIMPROVEEndYaerA.Text) < Convert.ToInt32(_speciesFractionOptionsA.cboIMPROVEStartYaerA.Text))
                        //    MessageBox.Show("End Year should be later than Start Year.");
                        //if (Convert.ToInt32(cboPMEndYaerA.Text) < Convert.ToInt32(cboPMStartYaerA.Text))
                        //    MessageBox.Show("End Year should be later than Start Year.");
                        break;
                    case "uc_PM25CalculationOptionsA":
                        pnlUserControl.Controls.Add(new uc_PM25CalculationOptionsA());
                        lblSteps.Text = trvAnalysis.Nodes[4].Text;
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        trvAnalysis.Refresh();
                        _stips = "Set up pm25 calculation options";
                        uc_PM25CalculationOptionsA _pmCalculationA = (pnlUserControl.Controls[0] as uc_PM25CalculationOptionsA);

                        //----------------bind required dv,according to start year-------------
                        int n = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Count;
                        string[] dvString = new string[n];
                        for (int i = 0; i < n; i++)
                        {
                            dvString[i] = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears[i];
                        }
                        for (int i = 0; i < n; i++)
                        {
                            if (i + 2 < n)
                            {
                                _pmCalculationA.clboRequiredDV.Items.Add(dvString[i] + "-" + dvString[i + 2]);
                            }
                        }

                        _pmCalculationA.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        _pmCalculationA.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA = new PM25CalculationOptionsA();
                            if (_pmCalculationA.cboStartYearA.Items.Count >= 8)// >= 12
                                _pmCalculationA.cboStartYearA.SelectedIndex = 7;// = 11
                            else
                                _pmCalculationA.cboStartYearA.SelectedIndex = _pmCalculationA.cboStartYearA.Items.Count - 1;
                            if (_pmCalculationA.cboEndYearA.Items.Count >= 12)//
                            {
                                _pmCalculationA.cboEndYearA.SelectedIndex = 11;//13
                            }
                            else
                            {
                                _pmCalculationA.cboEndYearA.SelectedIndex = _pmCalculationA.cboEndYearA.Items.Count - 1;
                            }
                            _pmCalculationA.rbtnOfficialA.Checked = true;
                            _pmCalculationA.rbtnNH4DONA.Checked = true;
                            _pmCalculationA.txtRequiredA.Text = "None selected";
                            _pmCalculationA.nudownMinDaysA.Value = 11;
                            _pmCalculationA.nudownMinQuarterA.Value = 12;
                            _pmCalculationA.nudownMinNumDV.Value = 1;
                        }
                        else
                        {
                            _pmCalculationA.cboStartYearA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.officialPM25StartYear;
                            _pmCalculationA.cboEndYearA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.officialPM25EndYear;
                            _pmCalculationA.rbtnOfficialA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.choiceOfficialDV;
                            _pmCalculationA.rbtnCustomA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.choiceCustomDV;
                            _pmCalculationA.nudownMinDaysA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minDaysForValidFRMQuarters;
                            _pmCalculationA.nudownMinQuarterA.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minQuartersForValidFRMDesignValues;
                            _pmCalculationA.nudownMinNumDV.Value = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.minNumDVPeriodsForValidFRMMonitors;
                            _pmCalculationA.txtRequiredA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.requiredDVPeriodsForValidFRMMonitors;
                            if (_pmCalculationA.txtRequiredA.Text != "None selected")
                            {
                                string[] requireDV = _pmCalculationA.txtRequiredA.Text.Split(',');
                                foreach (string s in requireDV)
                                {
                                    _pmCalculationA.clboRequiredDV.SetItemChecked(_pmCalculationA.clboRequiredDV.Items.IndexOf(s), true);
                                }
                            }
                            _pmCalculationA.rbtnNH4DONA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.doCalcNH4fromDON;
                            _pmCalculationA.rbtnNH4RRFA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA.doCalcNH4fromRRF;
                        }
                        break;
                    case "uc_ModelDataA":
                        pnlUserControl.Controls.Add(new uc_ModelDataA());
                        lblSteps.Text = trvAnalysis.Nodes[5].Text;
                        _stips = "Set up model options";
                        uc_ModelDataA _modelDataA = (pnlUserControl.Controls[0] as uc_ModelDataA);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA = new ModelDataOptionsA();
                            _modelDataA.cboPointGridA.SelectedIndex = 1;
                            _modelDataA.cboSpatialGridA.SelectedIndex = 0;
                        }
                        else
                        {
                            _modelDataA.cboPointGridA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA.temporalAdjustmentAtMonitorGrid;
                            _modelDataA.cboSpatialGridA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA.temporalAdjustmentAtMonitorGridSpatial;
                        }
                        break;
                    #endregion
                    #region Daily
                    case "uc_OutputD":
                        pnlUserControl.Controls.Add(new uc_OutputD());
                        lblSteps.Text = trvAnalysis.Nodes[0].Text;
                        _stips = "Choose Desired Output";
                        uc_OutputD _outputD = (pnlUserControl.Controls[0] as uc_OutputD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD = new ChooseDesiredOutputD();
                            _outputD.choStandardAnalysisD.Checked = true;
                            _outputD.choQuarterlyPeakModelDataD.Checked = true;
                            _outputD.choSpeciesFractionsFileD.Checked = true;
                            _outputD.choActionsExtractAllD.Checked = true;
                        }
                        else
                        {
                            _outputD.txtScenarioNameDily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.scenarioName;
                            _outputD.choStandardAnalysisD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doStandardAnalysis;
                            _outputD.choQuarterlyPeakModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doQuarterlyPeakModelData;
                            _outputD.choSpeciesFractionsFileD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doSpeciesFraction;
                            _outputD.choActionsExtractAllD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD.doAutomaticallyExtract;
                        }
                        break;
                    case "uc_OutputAdvancedD"://all unchecked?
                        pnlUserControl.Controls.Add(new uc_OutputAdvancedD());
                        lblSteps.Text = trvAnalysis.Nodes[1].Text;
                        _stips = "Select advanced output choices";
                        uc_OutputAdvancedD _outputAdvancedD = (pnlUserControl.Controls[0] as uc_OutputAdvancedD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD = new OutputChoiceAdvancedD();
                            _outputAdvancedD.choQuarterlyAvgFilePointD.Checked = true;
                            _outputAdvancedD.choFileCD.Checked = true;
                            _outputAdvancedD.choFileED.Checked = true;
                        }
                        else
                        {
                            _outputAdvancedD.choQuarterlyAvgFilePointD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakFilesPoint;
                            _outputAdvancedD.choFileCD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doHighCountySites;
                            _outputAdvancedD.choFileED.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doQuarterlyPeakSpeciatedMonitors;
                            _outputAdvancedD.choDVPeriodsD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doDesignValuePeriods;
                            _outputAdvancedD.choNeighborFilePointD.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD.doNeighborFilePoint;
                        }
                        break;
                    case "uc_DataInputD":
                        pnlUserControl.Controls.Add(new uc_DataInputD());
                        lblSteps.Text = trvAnalysis.Nodes[2].Text;
                        _stips = "Select input files for the analysis";
                        uc_DataInputD _dataInputD = (pnlUserControl.Controls[0] as uc_DataInputD);
                        _dataInputD.InitializeControl();
                        break;
                    case "uc_SpeciesFrctionD":
                        pnlUserControl.Controls.Add(new uc_SpeciesFrctionD());
                        lblSteps.Text = trvAnalysis.Nodes[3].Text;
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        trvAnalysis.Refresh();
                        _stips = "Set up species fraction options";
                        uc_SpeciesFrctionD _speciesFrctionD = (pnlUserControl.Controls[0] as uc_SpeciesFrctionD);
                        _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstSTNFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFrctionD.cboPMMonitorStartYearDaily.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                        _speciesFrctionD.cboPMMonitorEndYearDaily.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMForFractionsMonitorDataYears.Distinct().ToList();
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD = new SpeciesFractionOptionsD();
                            if (_speciesFrctionD.cboIMPROVEMonitorStartYearDaily.Items.Count >= 9)
                                _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.SelectedIndex = 8;
                            else
                                _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.SelectedIndex = _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.Items.Count - 1;
                            if (_speciesFrctionD.cboIMPROVEMonitorEndYearDaily.Items.Count >= 11)
                                _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.SelectedIndex = 10;
                            else
                                _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.SelectedIndex = _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.Items.Count - 1;
                            if (_speciesFrctionD.cboPMMonitorStartYearDaily.Items.Count >= 9)
                                _speciesFrctionD.cboPMMonitorStartYearDaily.SelectedIndex = 8;
                            else
                                _speciesFrctionD.cboPMMonitorStartYearDaily.SelectedIndex = _speciesFrctionD.cboPMMonitorStartYearDaily.Items.Count - 1;
                            if (_speciesFrctionD.cboPMMonitorEndYearDaily.Items.Count >= 11)
                                _speciesFrctionD.cboPMMonitorEndYearDaily.SelectedIndex = 10;
                            else
                                _speciesFrctionD.cboPMMonitorEndYearDaily.SelectedIndex = _speciesFrctionD.cboPMMonitorEndYearDaily.Items.Count - 1;
                            _speciesFrctionD.choEPASpecifiedIMPROVEDaily.Checked = true;
                            _speciesFrctionD.choEPASpecifiedPMDaily.Checked = true;
                            _speciesFrctionD.nudownMinDaysIMPROVEDaily.Value = 11;
                            _speciesFrctionD.nudownMinQuartersIMPROVEDaily.Value = 1;
                            _speciesFrctionD.nudownMinYearsIMPROVEDaily.Value = 1;
                            _speciesFrctionD.nudownMinDaysPMDaily.Value = 11;
                            _speciesFrctionD.nudownMinQuartersPMDaily.Value = 4;
                            _speciesFrctionD.nudownMinYearsPMDaily.Value = 1;
                            _speciesFrctionD.choAdvancedOptions.Checked = false;
                            #region advanced options
                            _speciesFrctionD.rbtnTopPercMonitorIMPROVEDaily.Checked = true;
                            _speciesFrctionD.rbtnTopPercMonitorPMDaily.Checked = true;
                            _speciesFrctionD.nudownTopPercMonitorIMPROVEDaily.Value = 10;
                            _speciesFrctionD.nudownAllMonitorGreaterIMPROVEDaily.Value = 0;
                            _speciesFrctionD.nudownMinNumAboveIMPROVEDaily.Value = 1;
                            _speciesFrctionD.nudownTopNumMonitorIMPROVEDaily.Value = 25;
                            _speciesFrctionD.nudownTopPercMonitorPMDaily.Value = 10;
                            _speciesFrctionD.nudownAllMonitorGreaterPMDaily.Value = 0;
                            _speciesFrctionD.nudownMinNumAbovePMDaily.Value = 1;
                            _speciesFrctionD.nudownTopNumMonitorPMDaily.Value = 25;
                            _speciesFrctionD.cboPM25InterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboSO4InterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboNO3InterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboECInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboSaltInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboCrastalInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboDONInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboOCInterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.cboNH4InterpolationDaily.SelectedIndex = 2;
                            _speciesFrctionD.nudownPM25DistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownSO4DistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownNO3DistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownECDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownSaltDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownCrustalDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownDONDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownOCDistanceDaily.Value = 9000000000;
                            _speciesFrctionD.nudownNH4DistanceDaily.Value = 9000000000;
                            _speciesFrctionD.cboPM25InterpolationDaily.Enabled = false;
                            _speciesFrctionD.nudownPM25DistanceDaily.Enabled = false;
                            _speciesFrctionD.cboNH4InterpolationDaily.Enabled = false;
                            _speciesFrctionD.nudownNH4DistanceDaily.Enabled = false;
                            _speciesFrctionD.rbtnDONValueDaily.Checked = true;
                            _speciesFrctionD.nudownNH4PercDaily.Enabled = false;
                            _speciesFrctionD.nudownDefaultBMDaily.Value = (decimal)0.2;
                            _speciesFrctionD.nudownOCmbFloorDaily.Value = 1;
                            _speciesFrctionD.nudownOCmbCeilingDaily.Value = (decimal)0.8;
                            #endregion
                        }
                        else
                        {
                            _speciesFrctionD.cboIMPROVEMonitorStartYearDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_StartYear;
                            _speciesFrctionD.cboIMPROVEMonitorEndYearDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_EndYear;
                            _speciesFrctionD.choEPASpecifiedIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_EPADeletionChoice;
                            _speciesFrctionD.choUserSpecifiedIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_UserDeletionChoice;
                            _speciesFrctionD.nudownMinDaysIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinDays;
                            _speciesFrctionD.nudownMinQuartersIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinQuarters;
                            _speciesFrctionD.nudownMinYearsIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVE_MinYear;
                            _speciesFrctionD.cboPMMonitorStartYearDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialStartYear;
                            _speciesFrctionD.cboPMMonitorEndYearDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialEndYear;
                            _speciesFrctionD.choEPASpecifiedPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialEPADeletionChoice;
                            _speciesFrctionD.choUserSpecifiedPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialUserDeletionChoice;
                            _speciesFrctionD.nudownMinDaysPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinDays;
                            _speciesFrctionD.nudownMinQuartersPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinQuartersPoint;
                            _speciesFrctionD.nudownMinYearsPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialMinYears;
                            _speciesFrctionD.choAdvancedOptions.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.doAdvancedOptionsForSpeciesFraction;
                            #region advanced options
                            _speciesFrctionD.rbtnTopPercMonitorIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoTopXPercent;
                            _speciesFrctionD.rbtnAllMonitorGreaterIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoUseAlldailyMonitorValuesGreaterThan;
                            _speciesFrctionD.rbtnTopNumMonitorIMPROVEDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_DoUseTopXNumber;
                            _speciesFrctionD.rbtnTopPercMonitorPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoTopXPercent;
                            _speciesFrctionD.rbtnAllMonitorGreaterPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoUseAlldailyMonitorValuesGreaterThan;
                            _speciesFrctionD.rbtnTopNumMonitorPMDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_DoTopXNumber;
                            _speciesFrctionD.nudownTopPercMonitorIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_TopXPercent;
                            _speciesFrctionD.nudownAllMonitorGreaterIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_UseAlldailyMonitorValuesGreaterThan;
                            _speciesFrctionD.nudownMinNumAboveIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_MinumumNumberOfDaysRequiredAboveFixedAmount;
                            _speciesFrctionD.nudownTopNumMonitorIMPROVEDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.IMPROVESTN_UseTopXNumber;
                            _speciesFrctionD.nudownTopPercMonitorPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_TopXPercent;
                            _speciesFrctionD.nudownAllMonitorGreaterPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_UseAlldailyMonitorValuesGreaterThan;
                            _speciesFrctionD.nudownMinNumAbovePMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_MinumumNumberOfDaysRequiredAboveFixedAmount;
                            _speciesFrctionD.nudownTopNumMonitorPMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.unofficialPM25_TopXNumber;
                            _speciesFrctionD.cboPM25InterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodPM25;
                            _speciesFrctionD.nudownPM25DistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distancePM25;
                            _speciesFrctionD.cboSO4InterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodSO4;
                            _speciesFrctionD.nudownSO4DistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceSO4;
                            _speciesFrctionD.cboNO3InterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodNO3;
                            _speciesFrctionD.nudownNO3DistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceNO3;
                            _speciesFrctionD.cboECInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodEC;
                            _speciesFrctionD.nudownECDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceEC;
                            _speciesFrctionD.cboSaltInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodSalt;
                            _speciesFrctionD.nudownSaltDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceSalt;
                            _speciesFrctionD.cboCrastalInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodCrustal;
                            _speciesFrctionD.nudownCrustalDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceCrustal;
                            _speciesFrctionD.cboDONInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodDON;
                            _speciesFrctionD.nudownDONDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceDON;
                            _speciesFrctionD.cboOCInterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodOC;
                            _speciesFrctionD.nudownOCDistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceOC;
                            _speciesFrctionD.cboNH4InterpolationDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.interpolationMethodNH4;
                            _speciesFrctionD.nudownNH4DistanceDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.distanceNH4;
                            _speciesFrctionD.rbtnDONValueDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.doUseDonValues;
                            _speciesFrctionD.rbtnMeasuredAmmoniumDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.doUseMeasuredAmmonium;
                            _speciesFrctionD.cboPM25InterpolationDaily.Enabled = false;
                            _speciesFrctionD.nudownPM25DistanceDaily.Enabled = false;
                            if (_speciesFrctionD.rbtnDONValueDaily.Checked == true)
                            {
                                _speciesFrctionD.cboDONInterpolationDaily.Enabled = true;
                                _speciesFrctionD.nudownDONDistanceDaily.Enabled = true;
                                _speciesFrctionD.cboNH4InterpolationDaily.Enabled = false;
                                _speciesFrctionD.nudownNH4DistanceDaily.Enabled = false;
                                _speciesFrctionD.nudownNH4PercDaily.Enabled = false;
                            }
                            if (_speciesFrctionD.rbtnMeasuredAmmoniumDaily.Checked == true)
                            {
                                _speciesFrctionD.cboDONInterpolationDaily.Enabled = false;
                                _speciesFrctionD.nudownDONDistanceDaily.Enabled = false;
                                _speciesFrctionD.cboNH4InterpolationDaily.Enabled = true;
                                _speciesFrctionD.nudownNH4DistanceDaily.Enabled = true;
                                _speciesFrctionD.nudownNH4PercDaily.Enabled = true;
                            }
                            _speciesFrctionD.nudownNH4PercDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.nh4PercentageEvaporating;
                            _speciesFrctionD.nudownDefaultBMDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.defaultBlankMass;
                            _speciesFrctionD.nudownOCmbFloorDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.floorOCMMB;
                            _speciesFrctionD.nudownOCmbCeilingDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD.ceilingOCMMB;
                            #endregion
                        }
                        break;
                    case "uc_PM25CalculationD":
                        pnlUserControl.Controls.Add(new uc_PM25CalculationD());
                        lblSteps.Text = trvAnalysis.Nodes[4].Text;
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        trvAnalysis.Refresh();
                        _stips = "Set up pm25 calculation options";
                        uc_PM25CalculationD _pmCalculationD = (pnlUserControl.Controls[0] as uc_PM25CalculationD);

                        //----------------bind required dv,according to start year-------------
                        n = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Count;
                        dvString = new string[n];
                        for (int i = 0; i < n; i++)
                        {
                            dvString[i] = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears[i];
                        }
                        for (int i = 0; i < n; i++)
                        {
                            if (i + 2 < n)
                            {
                                _pmCalculationD.clboRequiredDV.Items.Add(dvString[i] + "-" + dvString[i + 2]);
                            }
                        }

                        _pmCalculationD.cboStartYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        _pmCalculationD.cboEndYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD = new PM25CalculationOptionsD();
                            if (_pmCalculationD.cboStartYearD.Items.Count >= 8)
                                _pmCalculationD.cboStartYearD.SelectedIndex = 7;
                            else
                                _pmCalculationD.cboStartYearD.SelectedIndex = _pmCalculationD.cboStartYearD.Items.Count - 1;
                            if (_pmCalculationD.cboEndYearD.Items.Count >= 12)
                                _pmCalculationD.cboEndYearD.SelectedIndex = 11;
                            else
                                _pmCalculationD.cboEndYearD.SelectedIndex = _pmCalculationD.cboEndYearD.Items.Count - 1;
                            _pmCalculationD.nudownMinNumDVD.Value = 1;
                            _pmCalculationD.txtRequiredDVD.Text = "None selected";
                            _pmCalculationD.rbtnCalculateNH4byDON.Checked = true;
                        }
                        else
                        {
                            _pmCalculationD.cboStartYearD.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.officialPM25StartYear;
                            _pmCalculationD.cboEndYearD.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.officialPM25EndYear;
                            _pmCalculationD.nudownMinNumDVD.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.minNumDVPeriodsForValidFRMMonitors;
                            _pmCalculationD.txtRequiredDVD.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.requiredDesignValuePeriodsForValidFRMMonitors;
                            if (_pmCalculationD.txtRequiredDVD.Text != "None selected")
                            {
                                string[] requireDV = _pmCalculationD.txtRequiredDVD.Text.Split(',');
                                foreach (string s in requireDV)
                                {
                                    _pmCalculationD.clboRequiredDV.SetItemChecked(_pmCalculationD.clboRequiredDV.Items.IndexOf(s), true);
                                }
                            }
                            _pmCalculationD.rbtnCalculateNH4byDON.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.doCalcNH4fromDON;
                            _pmCalculationD.rbtnCalculateNH4byRRF.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD.doCalcNH4fromRRF;
                        }
                        break;
                    case "uc_ModelDataD":
                        pnlUserControl.Controls.Add(new uc_ModelDataD());
                        lblSteps.Text = trvAnalysis.Nodes[5].Text;
                        _stips = "Set up model options";
                        uc_ModelDataD _modelDataD = (pnlUserControl.Controls[0] as uc_ModelDataD);
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD = new ModelDataOptionsD();
                            _modelDataD.cboGridPointModelOptionDaily.SelectedIndex = 0;
                            _modelDataD.choGridforSpatialForecast.SelectedIndex = 0;
                            _modelDataD.cboStatisticMethodDaily.SelectedIndex = 0;
                            _modelDataD.rbtnTopPerceRRFDaily.Checked = true;
                            _modelDataD.nudownTopPerceRRFDaily.Value = 10;
                            _modelDataD.nudownAllDailyGreaterRRFDaily.Value = 0;
                            _modelDataD.nudownMinNumDaysGreaterRRFDaily.Value = 1;
                            _modelDataD.nudownTopNumRRFDaily.Value = 25;
                        }
                        else
                        {
                            _modelDataD.cboGridPointModelOptionDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentAtMonitorGridPoint;
                            _modelDataD.choGridforSpatialForecast.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentAtMonitorGridSpatial;
                            _modelDataD.cboStatisticMethodDaily.Text = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.temporalAdjustmentType;
                            _modelDataD.rbtnTopPerceRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseXTopPercent;
                            _modelDataD.nudownTopPerceRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseXTopPercent;
                            _modelDataD.rbtnAllDailyGreaterRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseAllModelDaysGreaterThan;
                            _modelDataD.nudownAllDailyGreaterRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseAllModelDaysGreaterThan;
                            _modelDataD.nudownMinNumDaysGreaterRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
                            _modelDataD.rbtnTopNumRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_DoUseTopXNumber;
                            _modelDataD.nudownTopNumRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD.RRF_UseTopXNumber;
                        }
                        break;

                    #endregion
                    #region Ozone added by devin
                    case "uc_DesiredOutputOzone":
                        #region uc_DesiredOutputOzone
                        pnlUserControl.Controls.Add(new uc_DesiredOutputOzone());
                        lblSteps.Text = trvAnalysis.Nodes[0].Text;
                        _stips = "Choose Desired Output";
                        uc_DesiredOutputOzone _desiredOutputOzone = (pnlUserControl.Controls[0] as uc_DesiredOutputOzone);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO = new ChooseDesiredOutputO();
                            _desiredOutputOzone.choPointForecastOzone.Checked = true;
                            _desiredOutputOzone.choSpatialOzone.Checked = false;
                            _desiredOutputOzone.choSpatialGradAdjOzone.Checked = false;
                            _desiredOutputOzone.choBaseOnlyVNAOzone.Checked = false;
                            _desiredOutputOzone.choFutureOnlyVNAOzone.Checked = false;
                            _desiredOutputOzone.choBaseOnlyEvnaOzone.Checked = false;
                            _desiredOutputOzone.choFutureOnlyEvnaOzone.Checked = false;
                            _desiredOutputOzone.choQuarterlyModelData.Checked = true;
                            //_desiredOutputOzone.choSpatialForecastOzone.Checked = false;
                            //_desiredOutputOzone.choSpatialGradAdjForecastOzone.Checked = false;
                            _desiredOutputOzone.choNeighborFileSpatial.Checked = false;
                            _desiredOutputOzone.choExtractAllOzone.Checked = true;
                            _desiredOutputOzone.choDVPeriods.Checked = false;
                            _desiredOutputOzone.chkDS.Checked = false;
                            _desiredOutputOzone.chkDSOnlyBase.Checked = false;
                            _desiredOutputOzone.chkDSOnlyFuture.Checked = false;

                            _desiredOutputOzone.txtDSBurn.Text = "500";
                            _desiredOutputOzone.txtDSCmaqres.Text = "12";
                            _desiredOutputOzone.txtDSNumit.Text = "2500";
                            _desiredOutputOzone.txtDSThin.Text = "1";
                        }
                        else
                        {
                            _desiredOutputOzone.txtScenarioOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.scenarioName;
                            _desiredOutputOzone.choPointForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doPointEstimatesForecast;
                            _desiredOutputOzone.choQuarterlyModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doQuarterlyModelData;
                            _desiredOutputOzone.choSpatialOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates;
                            _desiredOutputOzone.choSpatialGradAdjOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj;
                            _desiredOutputOzone.choBaseOnlyVNAOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyVNA;
                            _desiredOutputOzone.choFutureOnlyVNAOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA;
                            _desiredOutputOzone.choBaseOnlyEvnaOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyEVNA;
                            _desiredOutputOzone.chkDS.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doDownscaler;
                            _desiredOutputOzone.chkDSOnlyBase.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSBaseOnly;
                            _desiredOutputOzone.chkDSOnlyFuture.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSFutureOnly;

                            _desiredOutputOzone.txtDSBurn.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSBurn.ToString();
                            _desiredOutputOzone.txtDSCmaqres.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSCmaqres.ToString();
                            _desiredOutputOzone.txtDSNumit.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSNumit.ToString();
                            _desiredOutputOzone.txtDSThin.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.DSThin.ToString();

                            _desiredOutputOzone.choFutureOnlyEvnaOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA;
                            //_desiredOutputOzone.choSpatialForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesForecast;
                            //_desiredOutputOzone.choSpatialGradAdjForecastOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesForecastGradAdj;
                            _desiredOutputOzone.choNeighborFileSpatial.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doNeighborFileSpatial;
                            _desiredOutputOzone.choExtractAllOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doAutomaticallyExtract;
                            _desiredOutputOzone.choDVPeriods.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doDesignValuePeriods;
                            _desiredOutputOzone.choMaxDVPeriods.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doMaxDesignValuePeriods;
                        }
                        #endregion
                        break;
                    case "uc_DataInputOzone":
                        #region uc_DataInputOzone
                        pnlUserControl.Controls.Add(new uc_DataInputOzone());
                        lblSteps.Text = trvAnalysis.Nodes[1].Text;
                        _stips = "Select input files for the analysis";
                        uc_DataInputOzone _dataInputOzone = (pnlUserControl.Controls[0] as uc_DataInputOzone);
                        _dataInputOzone.InitializeControl();
                        #endregion
                        break;
                    case "uc_FilteringorInterpolationOzone":
                        #region uc_FilteringorInterpolationOzone
                        pnlUserControl.Controls.Add(new uc_FilteringorInterpolationOzone());
                        lblSteps.Text = trvAnalysis.Nodes[2].Text;
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        trvAnalysis.Refresh();
                        _stips = "Select the filter and interpolation methods";//??
                        uc_FilteringorInterpolationOzone _filteringorInterpolationOzone = (pnlUserControl.Controls[0] as uc_FilteringorInterpolationOzone);

                        //----------------bind required dv,according to start year-------------
                        int j = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData.Count;
                        string[] dvStringOzone = new string[j];
                        for (int i = 0; i < j; i++)
                        {
                            dvStringOzone[i] = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.lstOzoneMonitorData[i];
                        }

                        _filteringorInterpolationOzone.clboRequiredDV.Items.Add((Convert.ToInt32(dvStringOzone[0]) - 2).ToString() + "-" + dvStringOzone[0]);
                        _filteringorInterpolationOzone.clboRequiredDV.Items.Add((Convert.ToInt32(dvStringOzone[0]) - 1).ToString() + "-" + dvStringOzone[1]);
                        for (int i = 0; i < j; i++)
                        {
                            if (i + 2 < j)
                            {
                                _filteringorInterpolationOzone.clboRequiredDV.Items.Add(dvStringOzone[i] + "-" + dvStringOzone[i + 2]);
                            }
                        }
                        foreach (var item in _filteringorInterpolationOzone.clboRequiredDV.Items)
                        {
                            _filteringorInterpolationOzone.cboStartYearOzone.Items.Add(item);
                            _filteringorInterpolationOzone.cboEndYearOzone.Items.Add(item);
                        }

                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO = new FilteringInterpolationO();
                            if (_filteringorInterpolationOzone.cboStartYearOzone.Items.Count >= 10)//>= 9)
                                _filteringorInterpolationOzone.cboStartYearOzone.SelectedIndex = 9;//= 8
                            else
                                _filteringorInterpolationOzone.cboStartYearOzone.SelectedIndex = _filteringorInterpolationOzone.cboStartYearOzone.Items.Count - 1;
                            if (_filteringorInterpolationOzone.cboEndYearOzone.Items.Count >= 12)//>= 10
                                _filteringorInterpolationOzone.cboEndYearOzone.SelectedIndex = 11;//= 9
                            else
                                _filteringorInterpolationOzone.cboEndYearOzone.SelectedIndex = _filteringorInterpolationOzone.cboEndYearOzone.Items.Count - 1;
                            _filteringorInterpolationOzone.nudownMinNumDVO.Value = 1;
                            _filteringorInterpolationOzone.txtRequiredDVOzone.Text = "None selected";
                            _filteringorInterpolationOzone.cboDefaultItpOzone.SelectedIndex = 1;
                            _filteringorInterpolationOzone.choMaxItpDistanceOzone.Checked = false;
                            _filteringorInterpolationOzone.nudownMaxItpDistanceOzone.Value = 100;
                            _filteringorInterpolationOzone.nudownMaxItpDistanceOzone.Enabled = false;
                        }
                        else
                        {
                            _filteringorInterpolationOzone.cboStartYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.ozoneStartYear;
                            _filteringorInterpolationOzone.cboEndYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.ozoneEndYear;
                            _filteringorInterpolationOzone.nudownMinNumDVO.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.minNumDV;
                            _filteringorInterpolationOzone.txtRequiredDVOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.requiredDVPeriods;
                            if (_filteringorInterpolationOzone.txtRequiredDVOzone.Text != "None selected")
                            {
                                string[] requireDV = _filteringorInterpolationOzone.txtRequiredDVOzone.Text.Split(',');
                                foreach (string s in requireDV)
                                {
                                    _filteringorInterpolationOzone.clboRequiredDV.SetItemChecked(_filteringorInterpolationOzone.clboRequiredDV.Items.IndexOf(s), true);
                                }
                            }
                            _filteringorInterpolationOzone.cboDefaultItpOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.defaultInterpolationMethod;
                            _filteringorInterpolationOzone.choMaxItpDistanceOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.doCheckToSetMaxDistance;
                            _filteringorInterpolationOzone.nudownMaxItpDistanceOzone.Enabled = _filteringorInterpolationOzone.choMaxItpDistanceOzone.Checked ? true : false;
                            _filteringorInterpolationOzone.nudownMaxItpDistanceOzone.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO.maxDistance;
                        }
                        //Turn gray or not(Filteringor/Interpolation) by according to the Spatial Field item(Desired Output)checked or not
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates == false && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj == false
                            && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyVNA == false && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA == false
                            && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doBaseOnlyEVNA == false && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA == false
                            )
                        {
                            _filteringorInterpolationOzone.cboDefaultItpOzone.Enabled = false;
                            _filteringorInterpolationOzone.choMaxItpDistanceOzone.Enabled = false;
                        }
                        else
                        {
                            _filteringorInterpolationOzone.cboDefaultItpOzone.Enabled = true;
                            _filteringorInterpolationOzone.choMaxItpDistanceOzone.Enabled = true;
                        }
                        #endregion
                        break;
                    case "uc_RRForSpatialGradientOzone":
                        #region uc_RRForSpatialGradientOzone
                        pnlUserControl.Controls.Add(new uc_RRForSpatialGradientOzone());
                        lblSteps.Text = trvAnalysis.Nodes[3].Text;
                        _stips = "Set up for RRF and spatial gradient";//?
                        uc_RRForSpatialGradientOzone _rrforSpatialGradientOzone = (pnlUserControl.Controls[0] as uc_RRForSpatialGradientOzone);
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO = new RRFSpatialGradientO();
                            _rrforSpatialGradientOzone.rbtnInitial.Checked = false;
                            _rrforSpatialGradientOzone.rbtnTopX.Checked = true;
                            _rrforSpatialGradientOzone.txtInitialValueOzone.Text = "85";
                            _rrforSpatialGradientOzone.txtAboveThresholdOzone.Text = "10";
                            _rrforSpatialGradientOzone.txtTopX.Text = "10";
                            _rrforSpatialGradientOzone.txtAllowableValueOzone.Text = "60";
                            _rrforSpatialGradientOzone.txtAboveAllowableThresholdOzone.Text = "5";
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Checked = false;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Enabled = false;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Text = "0";
                            _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Value = 1;
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays > 0)
                            {
                                _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Maximum = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Maximum = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                            }
                            else
                            {
                                _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Maximum = 366;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Maximum = 366;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Value = 366;
                            }
                            _rrforSpatialGradientOzone.choPairDaysOzone.Checked = false;
                            _rrforSpatialGradientOzone.txtStartValueOzone.Text = "1";
                            _rrforSpatialGradientOzone.txtEndValueOzone.Text = "5";
                        }
                        else
                        {
                            _rrforSpatialGradientOzone.rbtnInitial.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.useInitialThreshold;
                            _rrforSpatialGradientOzone.rbtnTopX.Checked = !(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.useInitialThreshold;
                            _rrforSpatialGradientOzone.txtInitialValueOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.initialThresholdValue;
                            _rrforSpatialGradientOzone.txtAboveThresholdOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minNumofDaysAtorAboveThreshold;
                            _rrforSpatialGradientOzone.txtTopX.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.topXDays.ToString();
                            _rrforSpatialGradientOzone.txtAllowableValueOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minAllowableThresholdValue;
                            _rrforSpatialGradientOzone.txtAboveAllowableThresholdOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.minNumDaysAtorAboveMinAllowableThreshold;
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.doBackstop;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Enabled = _rrforSpatialGradientOzone.choEnableBackstopOzone.Checked ? true : false;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.backstopMinThresholdforSpatialField;
                            _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.subrangeFirstDay;
                            _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Value = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.subrangeLastDay;
                            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays > 0)
                            {
                                _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Maximum = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Maximum = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO.maxOzoneModelDays;
                            }
                            else
                            {
                                _rrforSpatialGradientOzone.nudownSubrangeFirstOzone.Maximum = 366;
                                _rrforSpatialGradientOzone.nudownSubrangeLastOzone.Maximum = 366;
                            }
                            _rrforSpatialGradientOzone.choPairDaysOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.doPairDays;
                            _rrforSpatialGradientOzone.txtStartValueOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.SRF_StartValue;
                            _rrforSpatialGradientOzone.txtEndValueOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO.SRF_EndValue;
                        }
                        //some control will turn gray(Unable to use) if it meets these requirements in Desired Output
                        if (!(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj
                            && !(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA
                            //&& !(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates
                            //&& !(CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA
                            )
                        {
                            _rrforSpatialGradientOzone.txtStartValueOzone.Text = "1";
                            _rrforSpatialGradientOzone.txtEndValueOzone.Text = "5";
                            _rrforSpatialGradientOzone.txtStartValueOzone.Enabled = false;
                            _rrforSpatialGradientOzone.txtEndValueOzone.Enabled = false;
                        }
                        else
                        {
                            _rrforSpatialGradientOzone.txtStartValueOzone.Enabled = true;
                            _rrforSpatialGradientOzone.txtEndValueOzone.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimates
|| (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doSpatialFieldEstimatesGradAdj
|| (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyVNA
|| (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO.doFutureOnlyEVNA)
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Enabled = true;
                        else
                        {
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Enabled = false;
                            _rrforSpatialGradientOzone.choEnableBackstopOzone.Checked = false;
                            _rrforSpatialGradientOzone.txtBackstopMinOzone.Enabled = false;
                        }

                        #endregion
                        break;
                    #endregion
                    #region Visibility added by devin
                    case "uc_ChooseDesiredOutputV":
                        #region uc_ChooseDesiredOutputV
                        pnlUserControl.Controls.Add(new uc_ChooseDesiredOutputV());
                        lblSteps.Text = trvAnalysis.Nodes[0].Text;
                        _stips = "Choose Desired Output";
                        uc_ChooseDesiredOutputV _outPutV = (pnlUserControl.Controls[0] as uc_ChooseDesiredOutputV);
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV = new ChooseDesiredOutputV();
                            _outPutV.choVisibilityLevels.Checked = true;
                            _outPutV.rbtnOldIMPROVEAlgorithmVisibility.Checked = false;
                            _outPutV.rbtnNewIMPROVEAlgorithmVisibility.Checked = true;
                            _outPutV.rbtnModelGridCellatMonitorVisi.Checked = false;
                            _outPutV.rbtnModelGridCellatClass1Visi.Checked = false;
                            _outPutV.choExtractAllVisibility.Checked = true;
                        }
                        else
                        {
                            _outPutV.txtScenarioNameVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.scenarioName;
                            _outPutV.choVisibilityLevels.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.doTemporallyAdjVisibilityLevelsForecast;
                            _outPutV.rbtnOldIMPROVEAlgorithmVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm;
                            _outPutV.rbtnNewIMPROVEAlgorithmVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseNewVersionforIMPROVEAlgorithm;
                            _outPutV.rbtnModelGridCellatMonitorVisi.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseModelGridCellAtMonitor;
                            _outPutV.rbtnModelGridCellatClass1Visi.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseModelGridCellatClassIAreaCentroid;
                            _outPutV.choExtractAllVisibility.Checked = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.doAutomaticallyExtract;
                        }
                        #endregion
                        break;
                    case "uc_DataInputV":
                        #region uc_DataInputV
                        pnlUserControl.Controls.Add(new uc_DataInputV());
                        uc_DataInputV _dataInputV = (pnlUserControl.Controls[0] as uc_DataInputV);
                        lblSteps.Text = trvAnalysis.Nodes[1].Text;
                        _stips = "Select input files for the analysis";
                        _dataInputV.InitializeControl();
                        #endregion
                        break;
                    case "uc_FilteringV":
                        #region uc_FilteringV
                        pnlUserControl.Controls.Add(new uc_FilteringV());
                        lblSteps.Text = trvAnalysis.Nodes[2].Text;
                        pnlUserControl.Refresh();
                        lblSteps.Refresh();
                        trvAnalysis.Refresh();
                        _stips = "Set up filtering options";
                        uc_FilteringV _filteringV = (pnlUserControl.Controls[0] as uc_FilteringV);
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV.choiceUseOldVersionforIMPROVEAlgorithm)
                        {
                            _filteringV.cboStartYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataOld.Distinct().ToList();
                            _filteringV.cboEndYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataOld.Distinct().ToList();
                            _filteringV.cboBaseYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataOld.Distinct().ToList();
                        }
                        else
                        {
                            _filteringV.cboStartYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataNew.Distinct().ToList();
                            _filteringV.cboEndYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataNew.Distinct().ToList();
                            _filteringV.cboBaseYearVisibility.DataSource = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV.lstMonitorDataNew.Distinct().ToList();
                        }


                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV = new FilteringV();
                            if (_filteringV.cboStartYearVisibility.Items.Count > 11)
                                _filteringV.cboStartYearVisibility.SelectedIndex = 9;//Use default 5 years “2009-2013” in GUI (instead of current 3 years),add by devin,2017-02-14
                            else
                                _filteringV.cboStartYearVisibility.SelectedIndex = _filteringV.cboStartYearVisibility.Items.Count - 1;
                            if (_filteringV.cboEndYearVisibility.Items.Count > 13)
                                _filteringV.cboEndYearVisibility.SelectedIndex = 13;//Use default 5 years “2009-2013” in GUI (instead of current 3 years),add by devin,2017-02-14
                            else
                                _filteringV.cboEndYearVisibility.SelectedIndex = _filteringV.cboEndYearVisibility.Items.Count - 1;
                            if (_filteringV.cboBaseYearVisibility.Items.Count > 12)
                                _filteringV.cboBaseYearVisibility.SelectedIndex = 11;
                            else
                                _filteringV.cboBaseYearVisibility.SelectedIndex = _filteringV.cboBaseYearVisibility.Items.Count - 1;
                            _filteringV.txtMinYearVisibility.Text = "3";
                        }
                        else
                        {
                            _filteringV.cboStartYearVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.startMonitorYear;
                            _filteringV.cboEndYearVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.endMonitorYear;
                            _filteringV.cboBaseYearVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.baseModelYear;
                            _filteringV.txtMinYearVisibility.Text = (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV.minYearsForValidVisibilityMonitors;
                        }
                        #endregion
                        break;
                    #endregion
                    #region SSIA
                    case "uc_AnalysisOption":
                        lblSteps.Text = trvAnalysis.Nodes[0].Text;
                        _stips = "Single Source Impact Analysis Option";
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                        {
                            pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                            uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA = new SSIAAnalysisOption();
                                _analysisOption.choUseModelData.Checked = true;
                                _analysisOption.choUseModelFRMData.Checked = true;
                                _analysisOption.rbtnGridAndDispersion.Checked = false;
                                _analysisOption.rbtnGridOnly.Checked = true;
                                _analysisOption.rbtnDispersionOnly.Checked = false;
                            }
                            else
                            {
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData;
                                _analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion;
                                _analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly;
                                _analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly;
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                        {
                            pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                            uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD = new SSIAAnalysisOption();
                                _analysisOption.choUseModelData.Checked = true;
                                _analysisOption.choUseModelFRMData.Checked = true;
                                _analysisOption.rbtnGridAndDispersion.Checked = false;
                                _analysisOption.rbtnGridOnly.Checked = true;
                                _analysisOption.rbtnDispersionOnly.Checked = false;
                            }
                            else
                            {
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData;
                                _analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion;
                                _analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly;
                                _analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly;
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                        {
                            pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                            uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO = new SSIAAnalysisOption();
                                _analysisOption.choUseModelData.Checked = true;
                                _analysisOption.choUseModelFRMData.Checked = true;
                            }
                            else
                            {
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData;
                            }
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)    //added by K.B.
                        {
                            pnlUserControl.Controls.Add(new uc_AnalysisOption(this));
                            uc_AnalysisOption _analysisOption = (pnlUserControl.Controls[0] as uc_AnalysisOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep = new SSIAAnalysisOption();
                                _analysisOption.choUseModelData.Checked = true;
                                _analysisOption.choUseModelFRMData.Checked = false;
                                _analysisOption.rbtnGridAndDispersion.Checked = false;
                                _analysisOption.rbtnGridOnly.Checked = false;
                                _analysisOption.rbtnDispersionOnly.Checked = false;
                            }
                            else
                            {
                                _analysisOption.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.scenarioName;
                                _analysisOption.choUseModelData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelData;
                                _analysisOption.choUseModelFRMData.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useModelFRMData;
                                //_analysisOption.rbtnGridAndDispersion.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useGridAndDispersion;
                                //_analysisOption.rbtnGridOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useGridOnly;
                                //_analysisOption.rbtnDispersionOnly.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep.useDispersionOnly;
                            }
                        }
                        break;
                    case "uc_ModelDataInputA":
                        pnlUserControl.Controls.Add(new uc_ModelDataInputA());
                        _stips = "Model Data Input && Option";
                        lblSteps.Text = Language.Localization.GetValue(_stips);
                        uc_ModelDataInputA _modelInput = (pnlUserControl.Controls[0] as uc_ModelDataInputA);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA = new SSIAModelDataInputA();
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion)
                            {
                                _modelInput.rbtnDailyModelA.Checked = true;
                                _modelInput.rbtnQuarterlyModelA.Checked = false;
                                //_modelInput.rbtnCMAQA.Checked = false;
                                CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["baselineModelFile"];//Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["dispersionModelFile"];//  Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                            }
                            else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly)
                            {
                                _modelInput.rbtnDailyModelA.Checked = true;
                                _modelInput.rbtnQuarterlyModelA.Checked = false;
                                //_modelInput.rbtnCMAQA.Checked = false;
                                CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["baselineModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                _modelInput.panelDispersion.Visible = false;
                                _modelInput.pnlSourceFile.Location = new System.Drawing.Point(_modelInput.panelDispersion.Location.X, _modelInput.panelDispersion.Location.Y);
                            }
                            else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly)
                            {
                                CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["dispersionModelFile"];//Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                _modelInput.panelGrid.Visible = false;
                                _modelInput.pnlSourceFile.Location = new System.Drawing.Point(_modelInput.pnlSourceFile.Location.X, _modelInput.pnlSourceFile.Location.Y - _modelInput.panelGrid.Height);
                                _modelInput.panelDispersion.Location = new System.Drawing.Point(_modelInput.panelGrid.Location.X, _modelInput.panelGrid.Location.Y);
                            }
                            CommonClass.ssiasourcefile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["sourceCoordinatesFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Source Coordinate.csv";
                            _modelInput.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                        }
                        else
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridAndDispersion)
                            {
                                _modelInput.rbtnDailyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.DailyModelDataInput;
                                _modelInput.rbtnQuarterlyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.QuarterlyModelDataInput;
                                //_modelInput.rbtnCMAQA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.InputFromCMAQ;
                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile))
                                {
                                    CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile;
                                    _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }
                                else
                                {
                                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["baselineModelFile"];//Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                    _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }

                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile))
                                {
                                    CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile;
                                    _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }
                                else
                                {
                                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["forecastModelFile"];//Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                    _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }

                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile))
                                {
                                    CommonClass.dispersionModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile;
                                    _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                                else
                                {
                                    CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["dispersionModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                    _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                            }
                            else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useGridOnly)
                            {
                                _modelInput.rbtnDailyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.DailyModelDataInput;
                                _modelInput.rbtnQuarterlyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.QuarterlyModelDataInput;
                                //_modelInput.rbtnCMAQA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.InputFromCMAQ;
                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile))
                                {
                                    CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.baselineModelDataFile;
                                    _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }
                                else
                                {
                                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["baselineModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                    _modelInput.txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }

                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile))
                                {
                                    CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.alternativeScenarioFile;
                                    _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }
                                else
                                {
                                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                    _modelInput.txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }
                                _modelInput.panelDispersion.Visible = false;
                                _modelInput.pnlSourceFile.Location = new System.Drawing.Point(_modelInput.panelDispersion.Location.X, _modelInput.panelDispersion.Location.Y);

                            }
                            else if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly)
                            {
                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile))
                                {
                                    CommonClass.dispersionModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.dispersionFile;
                                    _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                                else
                                {
                                    CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["dispersionModelFile"];//Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\SOURCE_ANNUAL.PLT";
                                    _modelInput.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                                _modelInput.panelGrid.Visible = false;
                                _modelInput.pnlSourceFile.Location = new System.Drawing.Point(_modelInput.panelDispersion.Location.X, _modelInput.pnlSourceFile.Location.Y - _modelInput.panelGrid.Height);
                                _modelInput.panelDispersion.Location = new System.Drawing.Point(_modelInput.panelGrid.Location.X, _modelInput.panelGrid.Location.Y);
                            }
                            CommonClass.ssiasourcefile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA.SourceCoordinateFile;
                            _modelInput.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                        }
                        break;
                    case "uc_MonitorDataInputA":
                        pnlUserControl.Controls.Add(new uc_MonitorDataInputA());
                        _stips = "Monitor Data Input & Option";
                        lblSteps.Text = Language.Localization.GetValue(_stips);
                        uc_MonitorDataInputA _monitorInput = (pnlUserControl.Controls[0] as uc_MonitorDataInputA);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA == null)
                        {
                            WaitShow(Language.Localization.GetValue("working..."));
                            (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA = new SSIAMonitorDataInputA();
                            CommonClass.officialPMFile = CommonClass.dicExampleConfiguration.ContainsKey("SSIAAnnualPM") ? CommonClass.dicExampleConfiguration["SSIAAnnualPM"]["officialMonitorFile"] : Application.StartupPath + @"\Data\SampleData\Monitor_data\official_annual-PM25_2002thru2017.csv";//official_annual-PM25_allFRM.NID2002thru2015_v2.csv//official_annual-PM25_allFRM 121013.csv";
                            CommonClass.getmonitorYear("");
                            _monitorInput.txtOfficialMonitorA.Text = Path.GetFileName(CommonClass.officialPMFile);
                            _monitorInput.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                            _monitorInput.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                            if (_monitorInput.cboStartYearA.Items.Count > 7)
                                _monitorInput.cboStartYearA.SelectedIndex = 6;
                            else
                                _monitorInput.cboStartYearA.SelectedIndex = _monitorInput.cboStartYearA.Items.Count - 1;
                            if (_monitorInput.cboEndYearA.Items.Count > 11)
                            {
                                _monitorInput.cboEndYearA.SelectedIndex = 10;
                            }
                            else
                            {
                                _monitorInput.cboEndYearA.SelectedIndex = _monitorInput.cboEndYearA.Items.Count - 1;
                            }
                            _monitorInput.choVNA.Checked = true;
                            _monitorInput.choEVNA.Checked = true;
                            _monitorInput.cboPointGridA.Text = "1x1";
                            WaitClose();
                        }
                        else
                        {
                            CommonClass.officialPMFile = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.officialMonitorDataFile;
                            _monitorInput.txtOfficialMonitorA.Text = Path.GetFileName(CommonClass.officialPMFile);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears == null)
                            {
                                CommonClass.getmonitorYear("");
                            }
                            _monitorInput.cboStartYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                            _monitorInput.cboEndYearA.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.lstPMCalculationMonitorDataYears.Distinct().ToList();
                            _monitorInput.cboStartYearA.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.monitorDataStartYear;
                            _monitorInput.cboEndYearA.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.monitorDataEndYear;
                            _monitorInput.choVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.useVNA;
                            _monitorInput.choEVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.useEVNA;
                            _monitorInput.cboPointGridA.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA.temporalAdjustmentAtMonitorGrid;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useDispersionOnly)
                        {
                            _monitorInput.choVNA.Checked = true;
                            _monitorInput.choEVNA.Checked = false;
                            _monitorInput.choVNA.Enabled = false;
                            _monitorInput.choEVNA.Enabled = false;
                        }
                        break;
                    case "uc_ModelDataInputD":
                        pnlUserControl.Controls.Add(new uc_ModelDataInputD());
                        _stips = "Model Data Input && Option";
                        lblSteps.Text = Language.Localization.GetValue(_stips);
                        uc_ModelDataInputD _modelInputD = (pnlUserControl.Controls[0] as uc_ModelDataInputD);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD = new SSIAModelDataInputD();
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion)
                            {
                                _modelInputD.rbtnDailyModelDataD.Checked = true;
                                _modelInputD.rbtnQuarterlyPeakModelDataD.Checked = false;
                                //_modelInputD.rbtnCMAQFileD.Checked = false;
                                CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["baselineModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["dispersionModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";
                                _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                            }
                            else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly)
                            {
                                _modelInputD.rbtnDailyModelDataD.Checked = true;
                                _modelInputD.rbtnQuarterlyPeakModelDataD.Checked = false;
                                //_modelInputD.rbtnCMAQFileD.Checked = false;
                                CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["baselineModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                _modelInputD.panelDispersion.Visible = false;
                                _modelInputD.panelOptions.Location = new System.Drawing.Point(_modelInputD.panelDispersion.Location.X, _modelInputD.panelDispersion.Location.Y);
                                _modelInputD.pnlSourceFile.Location = new System.Drawing.Point(_modelInputD.pnlSourceFile.Location.X, _modelInputD.panelDispersion.Location.Y);
                            }
                            else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly)
                            {
                                CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["dispersionModelFile"];//Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";
                                _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                _modelInputD.panelGrid.Visible = false;
                                _modelInputD.panelDispersion.Location = new System.Drawing.Point(_modelInputD.panelDispersion.Location.X, _modelInputD.panelDispersion.Location.Y - _modelInputD.panelGrid.Size.Height);
                                _modelInputD.panelOptions.Location = new System.Drawing.Point(_modelInputD.panelOptions.Location.X, _modelInputD.panelOptions.Location.Y - _modelInputD.panelGrid.Size.Height);
                                _modelInputD.pnlSourceFile.Location = new System.Drawing.Point(_modelInputD.pnlSourceFile.Location.X, _modelInputD.panelGrid.Location.Y);
                            }
                            _modelInputD.cboGridPointModelOptionDaily.SelectedIndex = 0;
                            //_modelInputD.cboGridforSpatialForecast.SelectedIndex = 0;
                            _modelInputD.cboStatisticMethodDaily.SelectedIndex = 0;
                            _modelInputD.rbtnTopPerceRRFDaily.Checked = true;
                            _modelInputD.nudownTopPerceRRFDaily.Value = 10;
                            _modelInputD.nudownAllDailyGreaterRRFDaily.Value = 0;
                            _modelInputD.nudownMinNumDaysGreaterRRFDaily.Value = 1;
                            _modelInputD.nudownTopNumRRFDaily.Value = 25;
                            CommonClass.ssiasourcefile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["sourceCoordinatesFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Source Coordinate.csv";
                            _modelInputD.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                        }
                        else
                        {
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridAndDispersion)
                            {
                                _modelInputD.rbtnDailyModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.DailyModelDataInput;
                                _modelInputD.rbtnQuarterlyPeakModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.QuarterlyModelDataInput;
                                //_modelInputD.rbtnCMAQFileD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.InputFromCMAQ;
                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile))
                                {
                                    CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile;
                                    _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }
                                else
                                {
                                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["baselineModelFile"];//  Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                    _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }

                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile))
                                {
                                    CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile;
                                    _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }
                                else
                                {
                                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                    _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }

                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile))
                                {
                                    CommonClass.dispersionModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile;
                                    _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                                else
                                {
                                    CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["dispersionModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";
                                    _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                            }
                            else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useGridOnly)
                            {
                                _modelInputD.rbtnDailyModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.DailyModelDataInput;
                                _modelInputD.rbtnQuarterlyPeakModelDataD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.QuarterlyModelDataInput;
                                //_modelInputD.rbtnCMAQFileD.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.InputFromCMAQ;
                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile))
                                {
                                    CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.baselineModelDataFile;
                                    _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }
                                else
                                {
                                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["baselineModelFile"];//Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_BASE.csv";
                                    _modelInputD.txtBaselineFileD.Text = Path.GetFileName(CommonClass.baseModelFile);
                                }

                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile))
                                {
                                    CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.alternativeScenarioFile;
                                    _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }
                                else
                                {
                                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.PM.4ATL1.2007ee_07f_ALT.csv";
                                    _modelInputD.txtForecastFileD.Text = Path.GetFileName(CommonClass.futureModelFile);
                                }
                                _modelInputD.panelDispersion.Visible = false;
                                _modelInputD.panelOptions.Location = new System.Drawing.Point(_modelInputD.panelDispersion.Location.X, _modelInputD.panelDispersion.Location.Y);
                                _modelInputD.pnlSourceFile.Location = new System.Drawing.Point(_modelInputD.pnlSourceFile.Location.X, _modelInputD.panelDispersion.Location.Y);
                            }
                            else if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useDispersionOnly)
                            {
                                if (!string.IsNullOrEmpty((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile))
                                {
                                    CommonClass.dispersionModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.dispersionFile;
                                    _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                                else
                                {
                                    CommonClass.dispersionModelFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["dispersionModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";
                                    _modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                                }
                                _modelInputD.panelGrid.Visible = false;
                                _modelInputD.panelDispersion.Location = new System.Drawing.Point(_modelInputD.panelDispersion.Location.X, _modelInputD.panelDispersion.Location.Y - _modelInputD.panelGrid.Size.Height);
                                _modelInputD.panelOptions.Location = new System.Drawing.Point(_modelInputD.panelOptions.Location.X, _modelInputD.panelOptions.Location.Y - _modelInputD.panelGrid.Size.Height);
                                _modelInputD.pnlSourceFile.Location = new System.Drawing.Point(_modelInputD.pnlSourceFile.Location.X, _modelInputD.panelGrid.Location.Y);
                            }
                            _modelInputD.cboGridPointModelOptionDaily.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentAtMonitorGridPoint;
                            //_modelInputD.cboGridforSpatialForecast.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentAtMonitorGridSpatial;
                            _modelInputD.cboStatisticMethodDaily.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.temporalAdjustmentType;
                            _modelInputD.rbtnTopPerceRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseXTopPercent;
                            _modelInputD.nudownTopPerceRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseXTopPercent;
                            _modelInputD.rbtnAllDailyGreaterRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseAllModelDaysGreaterThan;
                            _modelInputD.nudownAllDailyGreaterRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseAllModelDaysGreaterThan;
                            _modelInputD.nudownMinNumDaysGreaterRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_MinumumNumberOfDaysRequiredAboveFixedAmount;
                            _modelInputD.rbtnTopNumRRFDaily.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_DoUseTopXNumber;
                            _modelInputD.nudownTopNumRRFDaily.Value = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.RRF_UseTopXNumber;
                            CommonClass.ssiasourcefile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD.SourceCoordinateFile;
                            _modelInputD.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                        }
                        break;
                    case "uc_MonitorDataInputD":
                        pnlUserControl.Controls.Add(new uc_MonitorDataInputD());
                        _stips = "Monitor Data Input & Option";
                        lblSteps.Text = Language.Localization.GetValue(_stips);
                        uc_MonitorDataInputD _monitorInputD = (pnlUserControl.Controls[0] as uc_MonitorDataInputD);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD == null)
                        {
                            WaitShow(Language.Localization.GetValue("working..."));
                            (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD = new SSIAMonitorDataInputD();
                            CommonClass.officialPMFile = CommonClass.dicExampleConfiguration["SSIADailyPM"]["officialMonitorFile"];// Application.StartupPath + @"\Data\SampleData\Monitor_data\official_24-hr-PM25.NID2002thru2015_v2.csv";
                            CommonClass.getmonitorYear("");
                            _monitorInputD.txtOfficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.officialPMFile);
                            _monitorInputD.cboStartYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                            _monitorInputD.cboEndYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                            if (_monitorInputD.cboStartYearD.Items.Count > 7)
                                _monitorInputD.cboStartYearD.SelectedIndex = 6;
                            else
                                _monitorInputD.cboStartYearD.SelectedIndex = _monitorInputD.cboStartYearD.Items.Count - 1;
                            if (_monitorInputD.cboEndYearD.Items.Count > 11)
                            {
                                _monitorInputD.cboEndYearD.SelectedIndex = 10;
                            }
                            else
                            {
                                _monitorInputD.cboEndYearD.SelectedIndex = _monitorInputD.cboEndYearD.Items.Count - 1;
                            }
                            _monitorInputD.choEVNA.Checked = true;
                            _monitorInputD.choVNA.Checked = true;
                            WaitClose();
                        }
                        else
                        {
                            CommonClass.officialPMFile = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.officialMonitorDataFile;
                            _monitorInputD.txtOfficialMonitorDataFileD.Text = Path.GetFileName(CommonClass.officialPMFile);
                            _monitorInputD.cboStartYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                            _monitorInputD.cboEndYearD.DataSource = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.lstPMCalculationMonitorDataYears.Distinct().ToList();
                            _monitorInputD.cboStartYearD.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.monitorDataStartYear;
                            _monitorInputD.cboEndYearD.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.monitorDataEndYear;
                            _monitorInputD.choEVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.useEVNA; ;
                            _monitorInputD.choVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD.useVNA; ;
                        }
                        break;
                    case "uc_ModelDataInputO":
                        pnlUserControl.Controls.Add(new uc_ModelDataInputO());
                        _stips = "Model Data Input && Option";
                        lblSteps.Text = Language.Localization.GetValue(_stips);
                        uc_ModelDataInputO _modelDataInputO = (pnlUserControl.Controls[0] as uc_ModelDataInputO);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO = new SSIAModelDataInputO();
                            _modelDataInputO.choCMAQOzone.Checked = false;
                            CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIAOzone"]["baselineModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.O3.4ATL1.2007ee_07f_BASE.csv";
                            _modelDataInputO.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIAOzone"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Grid\mats.O3.4ATL1.2007ee_07f_ALT.csv";
                            _modelDataInputO.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                            CommonClass.ssiasourcefile = CommonClass.dicExampleConfiguration["SSIAOzone"]["sourceCoordinatesFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Source Coordinate.csv";
                            _modelDataInputO.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                        }
                        else
                        {
                            _modelDataInputO.choCMAQOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.doInputfromCmaq;
                            CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.baselineModelDataFile;
                            _modelDataInputO.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.forecastModelDataFile;
                            _modelDataInputO.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                            CommonClass.ssiasourcefile = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO.SourceCoordinateFile;
                            _modelDataInputO.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                        }
                        break;
                    case "uc_MonitorDataInputO":
                        pnlUserControl.Controls.Add(new uc_MonitorDataInputO());
                        _stips = "Monitor Data Input & Option";
                        lblSteps.Text = Language.Localization.GetValue(_stips);
                        uc_MonitorDataInputO _monitorInputO = (pnlUserControl.Controls[0] as uc_MonitorDataInputO);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO == null)
                        {
                            WaitShow(Language.Localization.GetValue("working..."));
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO = new SSIAMonitorDataInputO();
                            CommonClass.ozoneMonitorFile = CommonClass.dicExampleConfiguration["SSIAOzone"]["officialMonitorFile"];//Application.StartupPath + @"\Data\SampleData\Monitor_data\SMAT_OZONE_MAX4DV_STD70_2002_2015.CSV";//MATS_OZONE_DV_2012_V2_off.csv";
                            CommonClass.getmonitorYear("");
                            _monitorInputO.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);

                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData.Sort();
                            List<string> year = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData;
                            for (int i = 0; i < year.Count; i++)
                            {
                                _monitorInputO.cboStartYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                                _monitorInputO.cboEndYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                            }

                            if (_monitorInputO.cboStartYearOzone.Items.Count >= 5)
                                _monitorInputO.cboStartYearOzone.SelectedIndex = 4;
                            else
                                _monitorInputO.cboStartYearOzone.SelectedIndex = _monitorInputO.cboStartYearOzone.Items.Count - 1;
                            if (_monitorInputO.cboEndYearOzone.Items.Count > 7)
                                _monitorInputO.cboEndYearOzone.SelectedIndex = 6;
                            else
                                _monitorInputO.cboEndYearOzone.SelectedIndex = _monitorInputO.cboEndYearOzone.Items.Count - 1;
                            _monitorInputO.choVNA.Checked = true;
                            _monitorInputO.choEVNA.Checked = true;
                            _monitorInputO.chkDS.Checked = false;
                            _monitorInputO.txtDSThin.Text = "1";
                            _monitorInputO.txtDSNumit.Text = "2500";
                            _monitorInputO.txtDSCmaqres.Text = "12";
                            _monitorInputO.txtDSBurn.Text = "500";
                            _monitorInputO.cboGridOzone.SelectedIndex = 1;
                            _monitorInputO.cboStatisticOzone.SelectedIndex = 2;
                            WaitClose();
                        }
                        else
                        {
                            CommonClass.ozoneMonitorFile = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneMonitorDataFile;
                            _monitorInputO.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData == null)
                            {
                                CommonClass.getmonitorYear("");
                            }
                            (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData.Sort();
                            List<string> year = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.lstOzoneMonitorData;
                            for (int i = 0; i < year.Count; i++)
                            {
                                _monitorInputO.cboStartYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                                _monitorInputO.cboEndYearOzone.Items.Add((Convert.ToInt32(year[i]) - 2).ToString() + "-" + year[i]);
                            }
                            _monitorInputO.cboStartYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneStartYear;
                            _monitorInputO.cboEndYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.ozoneEndYear;
                            _monitorInputO.choVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useVNA;
                            _monitorInputO.choEVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useEVNA;
                            _monitorInputO.chkDS.Checked = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.useDownscaler;
                            _monitorInputO.txtDSThin.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSThin.ToString();
                            _monitorInputO.txtDSNumit.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSNumit.ToString();
                            _monitorInputO.txtDSCmaqres.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSCmaqres.ToString();
                            _monitorInputO.txtDSBurn.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.DSBurn.ToString();

                            _monitorInputO.cboGridOzone.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.temporalAdjustmentAtMonitorGrid;
                            _monitorInputO.cboStatisticOzone.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO.temporalAdjustmentType;
                        }
                        break;
                    case "uc_ModelDataInputDep":                                    //added by K.B.
                        pnlUserControl.Controls.Add(new uc_ModelDataInputDep());
                        _stips = "Model Data Input && Option";
                        lblSteps.Text = Language.Localization.GetValue(_stips);
                        uc_ModelDataInputDep _modelDataInputDep = (pnlUserControl.Controls[0] as uc_ModelDataInputDep);
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep = new SSIAModelDataInputDep();
                            _modelDataInputDep.rbtnDailyModelDataDep.Checked = true;
                            _modelDataInputDep.rbtnQuarterlyModelDataDep.Checked = false;
                            _modelDataInputDep.rbtnQuarterlyModelDataDep.Enabled = false;
                            ////_modelInputD.rbtnCMAQFileD.Checked = false;
                            CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["SSIADeposition"]["baselineModelFile"];//Application.StartupPath + @"\Data\SampleData\SSIA\Deposition\mats.TDEP.12WUS1.2011eh_v6_11g+25fake3000_baseline.csv";
                            _modelDataInputDep.txtBaselineDep.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["SSIADeposition"]["forecastModelFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Deposition\mats.TDEP.12WUS1.2011eh_v6_11g+25fake3000_13.csv";
                            _modelDataInputDep.txtForecastDep.Text = Path.GetFileName(CommonClass.futureModelFile);
                            CommonClass.ssiasourcefile = CommonClass.dicExampleConfiguration["SSIADeposition"]["sourceCoordinatesFile"];// Application.StartupPath + @"\Data\SampleData\SSIA\Deposition\mats.sourcecoords.12WUS1.tag013.csv";
                            _modelDataInputDep.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                            //CommonClass.dispersionModelFile = Application.StartupPath + @"\Data\SampleData\SSIA\Dispersion\DAILY_SOURCE.PST";
                            //_modelInputD.txtDispersion.Text = Path.GetFileName(CommonClass.dispersionModelFile);
                        }
                        else
                        {
                            _modelDataInputDep.rbtnDailyModelDataDep.Checked = true;
                            _modelDataInputDep.rbtnQuarterlyModelDataDep.Checked = false;
                            _modelDataInputDep.rbtnQuarterlyModelDataDep.Enabled = false;
                            CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.baselineModelDataFile;
                            _modelDataInputDep.txtBaselineDep.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.alternativeScenarioFile;
                            _modelDataInputDep.txtForecastDep.Text = Path.GetFileName(CommonClass.futureModelFile);
                            CommonClass.ssiasourcefile = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep.SourceCoordinateFile;
                            _modelDataInputDep.txtSourceFile.Text = Path.GetFileName(CommonClass.ssiasourcefile);
                        }
                        break;
                    case "uc_CalculationOption":
                        if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAAnnualPM)
                        {
                            _stips = "PM Calculation Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            pnlUserControl.Controls.Add(new uc_CalculationOption());
                            uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                                string iniPath = Application.StartupPath + @"\SMAT.ini";
                                if (File.Exists(iniPath))
                                {
                                    _calculation.txtNAAQS.Text = CommonClass.IniReadValue("annual pm calculation option", "NAAQS_value", iniPath);
                                    _calculation.txtThreshold.Text = CommonClass.IniReadValue("annual pm calculation option", "Threshold_value", iniPath);
                                    _calculation.nupdStartPercentage.Text = CommonClass.IniReadValue("annual pm calculation option", "Start_percentage", iniPath);
                                    _calculation.nupdEndPercentage.Text = CommonClass.IniReadValue("annual pm calculation option", "End_percentage", iniPath);
                                }
                                else
                                {
                                    _calculation.txtNAAQS.Text = "12";
                                    _calculation.txtThreshold.Text = "1";
                                    _calculation.nupdStartPercentage.Text = "0";
                                    _calculation.nupdEndPercentage.Text = "100";
                                }
                            }
                            else
                            {
                                _calculation.txtNAAQS.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.NAAQS.ToString();
                                _calculation.txtThreshold.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.threshold.ToString();
                                _calculation.nupdStartPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.startPercentage.ToString();
                                _calculation.nupdEndPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption.endPercentage.ToString();
                            }
                            _calculation.lblNAAQS_Unit.Text = "(μg/m3) ";
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADailyPM)
                        {
                            _stips = "PM Calculation Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            pnlUserControl.Controls.Add(new uc_CalculationOption());
                            uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                                string iniPath = Application.StartupPath + @"\SMAT.ini";
                                if (File.Exists(iniPath))
                                {
                                    _calculation.txtNAAQS.Text = CommonClass.IniReadValue("daily pm calculation option", "NAAQS_value", iniPath);
                                    _calculation.txtThreshold.Text = CommonClass.IniReadValue("daily pm calculation option", "Threshold_value", iniPath);
                                    _calculation.nupdStartPercentage.Text = CommonClass.IniReadValue("daily pm calculation option", "Start_percentage", iniPath);
                                    _calculation.nupdEndPercentage.Text = CommonClass.IniReadValue("daily pm calculation option", "End_percentage", iniPath);
                                }
                                else
                                {
                                    _calculation.txtNAAQS.Text = "35";
                                    _calculation.txtThreshold.Text = "1";
                                    _calculation.nupdStartPercentage.Text = "95";
                                    _calculation.nupdEndPercentage.Text = "98";
                                }
                            }
                            else
                            {
                                _calculation.txtNAAQS.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.NAAQS.ToString();
                                _calculation.txtThreshold.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.threshold.ToString();
                                _calculation.nupdStartPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.startPercentage.ToString();
                                _calculation.nupdEndPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption.endPercentage.ToString();
                            }
                            _calculation.lblNAAQS_Unit.Text = "(μg/m3) ";
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIAOzone)
                        {
                            _stips = "Ozone Calculation Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            pnlUserControl.Controls.Add(new uc_CalculationOption());
                            uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption = new SSIACalculationOption();
                                string iniPath = Application.StartupPath + @"\SMAT.ini";
                                if (File.Exists(iniPath))
                                {
                                    _calculation.txtNAAQS.Text = CommonClass.IniReadValue("ozone calculation option", "NAAQS_value", iniPath);
                                    _calculation.txtThreshold.Text = CommonClass.IniReadValue("ozone calculation option", "Threshold_value", iniPath);
                                    _calculation.nupdStartPercentage.Text = CommonClass.IniReadValue("ozone calculation option", "Start_percentage", iniPath);
                                    _calculation.nupdEndPercentage.Text = CommonClass.IniReadValue("ozone calculation option", "End_percentage", iniPath);
                                }
                                else
                                {
                                    _calculation.txtNAAQS.Text = "70";
                                    _calculation.txtThreshold.Text = "1";
                                    _calculation.nupdStartPercentage.Text = "0";
                                    _calculation.nupdEndPercentage.Text = "100";
                                }
                            }
                            else
                            {
                                _calculation.txtNAAQS.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.NAAQS.ToString();
                                _calculation.txtThreshold.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.threshold.ToString();
                                _calculation.nupdStartPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.startPercentage.ToString();
                                _calculation.nupdEndPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption.endPercentage.ToString();
                            }
                            _calculation.lblNAAQS_Unit.Text = "(ppb) ";
                        }
                        else if (CommonClass.CurrentAnalysis == enumAnalysis.SSIADeposition)      //added by K.B.
                        {
                            _stips = "Deposition Calculation Option";
                            lblSteps.Text = Language.Localization.GetValue(_stips);
                            pnlUserControl.Controls.Add(new uc_CalculationOption());
                            uc_CalculationOption _calculation = (pnlUserControl.Controls[0] as uc_CalculationOption);
                            _calculation.label5.Hide();
                            _calculation.label6.Hide();
                            _calculation.label7.Hide();
                            _calculation.label8.Hide();
                            _calculation.label9.Hide();
                            _calculation.nupdStartPercentage.Hide();
                            _calculation.nupdEndPercentage.Hide();
                            if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption == null)
                            {
                                (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption = new SSIACalculationOption();
                                string iniPath = Application.StartupPath + @"\SMAT.ini";
                                if (File.Exists(iniPath))
                                {
                                    //_calculation.txtNAAQS.Text = CommonClass.IniReadValue("deposition calculation option", "NAAQS_value", iniPath);
                                    _calculation.txtThreshold.Text = CommonClass.IniReadValue("deposition calculation option", "Threshold_value", iniPath);
                                    //_calculation.nupdStartPercentage.Text = CommonClass.IniReadValue("annual pm calculation option", "Start_percentage", iniPath);
                                    //_calculation.nupdEndPercentage.Text = CommonClass.IniReadValue("annual pm calculation option", "End_percentage", iniPath);
                                }
                                else
                                {
                                    //_calculation.txtNAAQS.Text = "0";
                                    _calculation.txtThreshold.Text = "0";
                                    //_calculation.nupdStartPercentage.Text = "0";
                                    //_calculation.nupdEndPercentage.Text = "100";
                                }
                            }
                            else
                            {
                                _calculation.txtNAAQS.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.NAAQS.ToString();
                                _calculation.txtThreshold.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.threshold.ToString();
                                //_calculation.nupdStartPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.startPercentage.ToString();
                                //_calculation.nupdEndPercentage.Text = (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption.endPercentage.ToString();
                            }
                            _calculation.lblNAAQS_Unit.Text = "";
                        }
                        break;
                    #endregion
                    #region Annual PM China added by Edwin
                    case "uc_ModelDataChina":
                        pnlUserControl.Controls.Add(new uc_ModelDataChina());
                        lblSteps.Text = trvAnalysis.Nodes[0].Text;
                        _stips = "Set up Model data input.";
                        uc_ModelDataChina modeldatachina = (pnlUserControl.Controls[0] as uc_ModelDataChina);
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina == null)
                        {
                            (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina = new ModelDataInputChina();
                            CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["baselineModelDataFile"];// Application.StartupPath + @"\Data\SampleData\SMAT-China\XiAn_Model_Base_Quarterly.csv";
                            modeldatachina.txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["forecastModelDataFile"];// Application.StartupPath + @"\Data\SampleData\SMAT-China\XiAn_Model_L_R_0.5_0.5_Quarterly.csv";
                            modeldatachina.txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
                        }
                        else
                        {
                            modeldatachina.rbtnQuarterlyAverageDataChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doQuarterlyAverageDataInput;
                            modeldatachina.rbtnDailyAvertageDatalChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doDailyAverageDataInput;
                            modeldatachina.rbtnCMAQChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doInputFromCMAQ;
                            modeldatachina.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.scenarioName;
                            CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.BaselineModelDataFile;
                            modeldatachina.txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                            CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.ControlModelDataFile;
                            modeldatachina.txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
                        }
                        break;
                    case "uc_MonitorDataChina":
                        pnlUserControl.Controls.Add(new uc_MonitorDataChina());
                        lblSteps.Text = trvAnalysis.Nodes[1].Text;
                        _stips = "Set up Monitor data input";
                        uc_MonitorDataChina monitordatachina = (pnlUserControl.Controls[0] as uc_MonitorDataChina);
                        monitordatachina.InitializeControl();
                        //if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina == null)
                        //{
                        //    (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina = new MonitorDataInputChina();
                        //    monitordatachina.rbtnQuarterlyMonitorChina.Checked = true;
                        //   CommonClass.monitorFile = Application.Startuppath + @ "\data\sampledata\smat china\ quarterly average of PM25 measurement points in Shaanxi Province csv";
                        //    monitordatachina.txtOfficialMonitorChina.Text = Path.GetFileName(CommonClass.monitorFile);
                        //    CommonClass.getmonitorYear("");
                        //    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear);
                        //    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear);
                        //    for (int i = start; i <= end; i++)
                        //    {
                        //        monitordatachina.cboEndYearChina.Items.Add(i);
                        //        monitordatachina.cboStartYearChina.Items.Add(i);
                        //    }
                        //    monitordatachina.cboStartYearChina.SelectedIndex = 0;
                        //    monitordatachina.cboEndYearChina.SelectedIndex = end - start;
                        //}
                        //else
                        //{
                        //    monitordatachina.choIAdjustedFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doInterpolateAdjustedFRM;
                        //    monitordatachina.choIFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doInterpolateFRM;
                        //    monitordatachina.chkwVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNA;
                        //    monitordatachina.chkwVNAAdvance.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNAAdvancedOption;
                        //    monitordatachina.txtwVNAWeight.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.wVNAWeight.ToString();
                        //    monitordatachina.chkNS.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doNS;
                        //    monitordatachina.rbtnQuarterlyMonitorChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doQuarterlyMonitorDataInput;
                        //    monitordatachina.rbtnDailyMonitorChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doDailyMonitorDataInput;
                        //    CommonClass.monitorFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataInputFile;
                        //    monitordatachina.txtOfficialMonitorChina.Text = Path.GetFileName(CommonClass.monitorFile);
                        //    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear);
                        //    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear);
                        //    for (int i = start; i <= end; i++)
                        //    {
                        //        monitordatachina.cboEndYearChina.Items.Add(i);
                        //        monitordatachina.cboStartYearChina.Items.Add(i);
                        //    }
                        //    monitordatachina.cboStartYearChina.SelectedIndex = 0;
                        //    monitordatachina.cboEndYearChina.SelectedIndex = end - start;
                        //}
                        break;
                    case "uc_PM25SpeciesOptionChina":
                        pnlUserControl.Controls.Add(new uc_PM25SpeciesOptionChina());
                        lblSteps.Text = trvAnalysis.Nodes[2].Text;
                        _stips = "Set up PM2.5 species option";
                        uc_PM25SpeciesOptionChina speciesoptionchina = (pnlUserControl.Controls[0] as uc_PM25SpeciesOptionChina);
                        speciesoptionchina.InitializeControl();
                        //if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina == null)
                        //{
                        //    (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina = new PM25SpeciesOptionChina();
                        //    CommonClass.speciesMonitorFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\PM25_Species_Fraction_Quarterly_2013_YRD.csv";
                        //    speciesoptionchina.txtSpeciesDataChina.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                        //}
                        //else
                        //{
                        //    speciesoptionchina.chkSpeciesFractionDataChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.PM25SpeciesFractionDataAvailable;
                        //    CommonClass.speciesMonitorFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.SpeciesMonitorDataFile;
                        //    speciesoptionchina.txtSpeciesDataChina.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                        //}
                        break;
                    #endregion
                    #region Ozone China added by Edwin
                    case "uc_ModelDataOzoneChina":
                        pnlUserControl.Controls.Add(new uc_ModelDataOzoneChina());
                        lblSteps.Text = trvAnalysis.Nodes[0].Text;
                        _stips = "Set up Model data input.";
                        uc_ModelDataOzoneChina modeldataozonechina = (pnlUserControl.Controls[0] as uc_ModelDataOzoneChina);
                        modeldataozonechina.InitializeControl();
                        //if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina == null)
                        //{
                        //    (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina = new ModelDataOzoneChina();
                        //    CommonClass.baseModelFile = CommonClass.monitorFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\Model_O3_Seasonal_2013_YRD.csv";
                        //    modeldataozonechina.txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                        //    CommonClass.futureModelFile = CommonClass.monitorFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\Model_O3_Seasonal_2017_YRD.csv";
                        //    modeldataozonechina.txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                        //}
                        //else
                        //{
                        //    modeldataozonechina.cboCMAQOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.doInputfromCmaq;
                        //    modeldataozonechina.txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.scenarioName;
                        //    modeldataozonechina.txtBaselineOzone.Text = Path.GetFileName((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile);
                        //    modeldataozonechina.txtForecastOzone.Text = Path.GetFileName((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile);
                        //    CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile;
                        //    CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile;
                        //}
                        break;
                    case "uc_MonitorDataOzoneChina":
                        pnlUserControl.Controls.Add(new uc_MonitorDataOzoneChina());
                        lblSteps.Text = trvAnalysis.Nodes[1].Text;
                        _stips = "Set up Monitor data input";
                        uc_MonitorDataOzoneChina monitordataozonechina = (pnlUserControl.Controls[0] as uc_MonitorDataOzoneChina);
                        monitordataozonechina.InitializeControl();
                        //if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina == null)
                        //{
                        //    (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina = new MonitorDataOzoneChina();
                        //    CommonClass.ozoneMonitorFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\Ozone_Data_Seasonal_2013_YRD.csv";
                        //    monitordataozonechina.txtOzoneData.Text = Path.GetFileName(CommonClass.ozoneMonitorFile);

                        //    CommonClass.getmonitorYear("");
                        //    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear);
                        //    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear);
                        //    foreach (var item in (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.lstOzoneMonitorData)
                        //    {
                        //        monitordataozonechina.cboEndYearOzone.Items.Add(item);
                        //        monitordataozonechina.cboStartYearOzone.Items.Add(item);
                        //    }
                        //    monitordataozonechina.cboStartYearOzone.SelectedIndex = 0;
                        //    monitordataozonechina.cboEndYearOzone.SelectedIndex = end - start;
                        //}
                        //else
                        //{
                        //    monitordataozonechina.choIAdjustedFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useEVNA;
                        //    monitordataozonechina.choIFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useVNA;
                        //    monitordataozonechina.chkwVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNA;
                        //    monitordataozonechina.chkwVNAAdvance.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAAdvancedOption;
                        //    monitordataozonechina.chkNS.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.useNS;
                        //    monitordataozonechina.txtwVNAWeight.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.usewVNAWeight.ToString();
                        //    monitordataozonechina.txtOzoneData.Text = Path.GetFileName((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneMonitorDataFile);
                        //    CommonClass.ozoneMonitorFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneMonitorDataFile;
                        //    monitordataozonechina.cboStartYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear;
                        //    monitordataozonechina.cboEndYearOzone.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear;

                        //    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneStartYear);
                        //    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina.ozoneEndYear);
                        //    for (int i = start; i <= end; i++)
                        //    {
                        //        monitordataozonechina.cboEndYearOzone.Items.Add(i);
                        //        monitordataozonechina.cboStartYearOzone.Items.Add(i);
                        //    }
                        //    monitordataozonechina.cboStartYearOzone.SelectedIndex = 0;
                        //    monitordataozonechina.cboEndYearOzone.SelectedIndex = end - start;
                        //}
                        break;
                    #endregion
                    #region BenMAP annual pm
                    case "uc_BenMAP_AnnualPM_ModelData":
                        pnlUserControl.Control