using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class SaveOrRunProject : FormBase
    {
        public SaveOrRunProject()
        {
            InitializeComponent();
            #region language added by Edwin

            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            
            #endregion
        }
        private Form _currentForm = null;
        private void btnSaveRunProject_Click(object sender, EventArgs e)
        {
            try
            {
                this.DialogResult = DialogResult.OK;
                CommonClass.IsSaveOrRun = enumSaveProjectOrRun.SaveRunProject;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSaveProject_Click(object sender, EventArgs e)
        {
            try
            {
                this.DialogResult = DialogResult.OK;
                CommonClass.IsSaveOrRun = enumSaveProjectOrRun.SaveProject;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void SaveOrRunProject_Load(object sender, EventArgs e)
        {
            try
            {
                btnSaveProject.Enabled = false;
                btnSaveRunProject.Enabled = false;
                switch (CommonClass.CurrentAnalysis)
                {
                    case enumAnalysis.AnnualPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                            || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA != null
                            || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).chooseDesiredOutputA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).outputChoiceAdvancedA != null
                            && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).speciesFractionOptionsA != null
                            && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).pm25CalculationOptionsA != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).modelDataOptionsA != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    case enumAnalysis.DailyPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null
                        || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD != null
                        || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD != null || (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).chooseDesiredOutputD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).outputChoiceAdvancedD != null
                            && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).dataInputD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).speciesFractionOptionsD != null
                           && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).pm25CalculationOptionsD != null && (CommonClass.CurrentBaseScenario.configuration as DailyPMAnalysisConfiguration).modelDataOptionsD != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    case enumAnalysis.Ozone:
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null
                           || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).chooseDesiredOutputO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).dataInputO != null
                          && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).filteringInterpolationO != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisConfiguration).rrfSpatialGradientO != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    case enumAnalysis.Visibility:
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV != null || (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV != null
                            || (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).chooseDesiredOutputV != null && (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).dataInputV != null
                            && (CommonClass.CurrentBaseScenario.configuration as VisibilityAnalysisConfiguration).filteringV != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    case enumAnalysis.SSIAAnnualPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null || (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA != null && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).modelInputA != null && (((CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).monitorInputA != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).analysisOptionA.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIAAnnualPMAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    case enumAnalysis.SSIADailyPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null || (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD != null && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).modelInputD != null && (((CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).monitorInputD != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).analysisOptionD.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIADailyPMAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    case enumAnalysis.SSIAOzone:
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO != null || (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO != null && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).modelInputO != null && (((CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).monitorInputO != null) || (!(CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).analysisOptionO.useModelFRMData)) && (CommonClass.CurrentBaseScenario.configuration as SSIAOzoneAnalysisConfiguration).calculationOption != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    case enumAnalysis.SSIADeposition:                                 //added by K.B.
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep != null || (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep != null || (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).analysisOptionDep != null && (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).modelInputDep != null &&  (CommonClass.CurrentBaseScenario.configuration as SSIADepositionConfiguration).calculationOption != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    #region Annual PM China added by Edwin
                    case enumAnalysis.AnnualPMChina:
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina != null || (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina != null && (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    #endregion
                    #region OzoneChina added by Edwin
                    case enumAnalysis.OzoneChina:
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina != null || (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina != null )
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina != null && (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).monitorDataOzoneChina != null )
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    #endregion
                    #region BenMAP Annual PM
                    case enumAnalysis.BenMAPAnnualPM:
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).modelInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).monitorInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPAnnualPMAnalysisConfiguration).speciesMonitorInput != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    case enumAnalysis.BenMAPSeasonalOzone:
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput != null || (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput != null)
                        {
                            btnSaveProject.Enabled = true;
                        }
                        if ((CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).modelInput != null && (CommonClass.CurrentBaseScenario.configuration as BenMAPOzoneAnalysisConfiguration).monitorInput != null)
                        {
                            btnSaveRunProject.Enabled = true;
                        }
                        break;
                    #endregion
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
