using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class ScenarioSelectionscs : FormBase
    {
        public ScenarioSelectionscs()
        {
            InitializeComponent();
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
        }

        private void ScenarioSelectionscs_Load(object sender, EventArgs e)
        {
            try
            {
                this.BackColor = Color.FromArgb(225, 225, 225);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        public Form _currentForm = null;
        private void btnGoStart_Click(object sender, EventArgs e)
        {
            try
            {
                if (rbtnAnnualPM.Checked == true)
                {     
                    //------modified by Edwin-----
                    if (!LanguageOld.IsSMATChina)
                        CommonClass.CurrentAnalysis = enumAnalysis.AnnualPM;
                    else
                        CommonClass.CurrentAnalysis = enumAnalysis.AnnualPMChina;
                }
                else if (rbtnDailyPM.Checked == true)
                {
                    CommonClass.CurrentAnalysis = enumAnalysis.DailyPM;
                }
                else if (rbtnOzone.Checked == true)
                {                   
                    //------modified by Edwin-----
                    if (!LanguageOld.IsSMATChina)
                        CommonClass.CurrentAnalysis = enumAnalysis.Ozone;
                    else
                        CommonClass.CurrentAnalysis = enumAnalysis.OzoneChina;
                }
                else if (rbtnVisibility.Checked == true)
                {
                    CommonClass.CurrentAnalysis = enumAnalysis.Visibility;
                }
                this.DialogResult = DialogResult.OK;
                CommonClass.OpenScenario = false;
                CommonClass.OutputNavigator = false;
                CommonClass.IsDataViewerState = false;
                _currentForm = new SMAT_CE();
                (_currentForm as SMAT_CE).initForm();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            //DialogResult result = MessageBox.Show("Cancel this operation?", "Tip", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            //if (result == DialogResult.No)
            //{
            //    return;
            //}
            //if (result == DialogResult.Yes)
            //{
            //    this.Close();
            //}
        }
    }
}
