using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml;
using System.Configuration;

namespace SMAT_CE
{
    public partial class SelectBenMAPexePath : FormBase
    {
        public string filePath = "";
        public SelectBenMAPexePath()
        {
            InitializeComponent();
        }

        private void btnOpenFile_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (File.Exists(txtBenMAPexe.Text))
                    openfile.InitialDirectory = Path.GetDirectoryName(txtBenMAPexe.Text);
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("EXE Files(BenMAP.exe)|BenMAP.exe");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    txtBenMAPexe.Text = openfile.FileName;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                if (!string.IsNullOrEmpty(txtBenMAPexe.Text))
                {
                    if (!File.Exists(txtBenMAPexe.Text))
                    {
                        MessageBox.Show("File path is not exist.");
                        txtBenMAPexe.Text = "";
                        return;
                    }
                }
                XmlDocument doc = new XmlDocument();
                doc.Load(CommonClass.ResultFilePath + @"\SMAT.exe.config");//Application.ExecutablePath + ".config");
                XmlNode node = doc.SelectSingleNode(@"//add[@key='BenMAP-CEpath']");
                XmlElement ele = (XmlElement)node;
                ele.SetAttribute("value", txtBenMAPexe.Text);
                doc.Save(CommonClass.ResultFilePath + @"\SMAT.exe.config");//Application.ExecutablePath + ".config");
                ConfigurationManager.RefreshSection("appSettings");
                filePath = txtBenMAPexe.Text;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
