using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class SetZgcChart : FormBase
    {
        public string ititle = "";
        public string ix = "";
        public string iy = "";
        public double ixmin = 0;
        public double ixmax = 0;
        public double iymin = 0;
        public double iymax = 0;
        public bool plotLine = false;
        public bool changeColor = false;
        public int itype = 0;
        public SetZgcChart()
        {
            InitializeComponent();
        }

        private void SetZgcChart_Load(object sender, EventArgs e)
        {
            txtTitle.Text = ititle;
            txtX.Text = ix;
            txtY.Text = iy;
            txtXmin.Text = ixmin.ToString();
            txtXmax.Text = ixmax.ToString();
            txtYmin.Text = iymin.ToString();
            txtYmax.Text = iymax.ToString();
            chkChangeColor.Checked = changeColor;
            chkPlotLine.Checked = plotLine;
            //0-bar or 1-distribution or 2-frequency 
            switch (itype)
            {
                case 0:
                    chkChangeColor.Checked = false;
                    chkChangeColor.Enabled = false;
                    chkPlotLine.Checked = false;
                    chkPlotLine.Enabled = false;
                    break;
                case 2:
                    chkChangeColor.Checked = false;
                    chkChangeColor.Enabled = false;
                    chkPlotLine.Enabled = true;
                    break;
                case 1:
                    chkChangeColor.Enabled = true;
                    chkPlotLine.Enabled = true;
                    break;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            ititle = txtTitle.Text;
            ix = txtX.Text;
            iy = txtY.Text;
            ixmin = Convert.ToDouble(txtXmin.Text);
            ixmax = Convert.ToDouble(txtXmax.Text);
            iymin = Convert.ToDouble(txtYmin.Text);
            iymax = Convert.ToDouble(txtYmax.Text);
            plotLine = chkPlotLine.Checked;
            changeColor = chkChangeColor.Checked;
            this.DialogResult = DialogResult.OK;
        }

        private void txtXmin_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonClass.keypress(false, sender, e);
        }

        private void txtXmax_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonClass.keypress(false, sender, e);
        }

        private void txtYmin_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonClass.keypress(false, sender, e);
        }

        private void txtYmax_KeyPress(object sender, KeyPressEventArgs e)
        {
            CommonClass.keypress(false, sender, e);
        }

    }
}
