using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class StartPage : Form
    {
        //ConfigurationManagement frm = new ConfigurationManagement();
        //DialogResult rtn;
        public StartPage()
        {
            InitializeComponent();

            //#region Language

            //Language.GetLanguagePath();
            //Dictionary<string, string> dic = new Dictionary<string, string>();
            //Language.SetDicFromXml(this, dic);
            //Language.ChangeLanguage(dic, this);

            //#endregion

            if (!LanguageOld.IsSMATChina)
            {
                this.Text = Language.Localization.GetValue("Title_name") + CommonClass.VersionNumber; ;
                lblVersion.Text = "SMAT-CE " + CommonClass.VersionNumber;
                //this.Text = "SMAT-CE " + System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Substring(0, System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Count() - 4);
                //lblVersion.Text = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Substring(0, System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString().Count() - 4);


            }
            else
            {
                this.Text = "SMAT-China " + CommonClass.versionSMATChina;
                lblVersion.Text = CommonClass.versionSMATChina;
            }
            SetStyle(ControlStyles.UserPaint, true);
            SetStyle(ControlStyles.AllPaintingInWmPaint, true);//Do not erase background
            SetStyle(ControlStyles.OptimizedDoubleBuffer, true);//Dual cache

        }


        private void HomePage_Load(object sender, EventArgs e)
        {
            try
            {
                ToolTip tips = new ToolTip();
                tips.InitialDelay = 200;
                tips.AutoPopDelay = 10 * 1000;
                tips.ReshowDelay = 200;
                tips.ShowAlways = true;
                tips.IsBalloon = true;
                tips.BackColor = Color.FromArgb(251, 233, 169);
                tips.SetToolTip(btnUserGuide, Language.Localization.GetValue("Users' Guide"));
                tips.SetToolTip(btnAbout, Language.Localization.GetValue("About"));
                tips.SetToolTip(btnSSIAAnnualPM, Language.Localization.GetValue("SSIA Annual PM Analysis"));
                tips.SetToolTip(btnSSIADailyPM, Language.Localization.GetValue("SSIA Daily PM Analysis"));
                tips.SetToolTip(btnSSIAOzone, Language.Localization.GetValue("SSIA Ozone Analysis"));
                tips.SetToolTip(btnBenMAPAnnualPM, Language.Localization.GetValue("BenMAP Annual PM Analysis"));
                tips.SetToolTip(btnBenMAPSeasonalOzone, Language.Localization.GetValue("BenMAP Seasonal Ozone Analysis"));
                InitBetaVersion();
                if (LanguageOld.IsSMATChina)
                {
                    btnDailyPM.Visible = false;
                    btnHaze.Visible = false;

                    btnAnnualPM.Location = new Point(btnAnnualPM.Location.X, btnAnnualPM.Location.Y+ btnAnnualPM.Height/2);
                    btnOzone.Location = new Point(btnOzone.Location.X, btnOzone.Location.Y + btnOzone.Height / 2);

                    lblSSIA.Visible = false;
                    picboxsingle.Visible = false;
                    btnSSIAAnnualPM.Visible = false;
                    btnSSIADailyPM.Visible = false;
                    lblAnd.Visible = false;
                    btnSSIAOzone.Visible = false;
                    lblBenMAPModule.Visible = false;
                    picBenMAPLogo.Visible = false;
                    btnBenMAPAnnualPM.Visible = false;
                    btnBenMAPSeasonalOzone.Visible = false;
                    label2.Location = lblSSIA.Location;
                    btnDataViewer.Location = picboxsingle.Location;
                    label5.Location = lblBenMAPModule.Location;
                    var height = label5.Height + picBenMAPLogo.Height;
                    btnUserGuide.Location = new Point(btnUserGuide.Location.X, btnUserGuide.Location.Y - height);
                    btnAbout.Location = new Point(btnAbout.Location.X, btnAbout.Location.Y - height);
                    picSplitLine.Location = new Point(picSplitLine.Location.X, picSplitLine.Location.Y - height);
                    btnExit.Location = new Point(btnExit.Location.X, btnExit.Location.Y - height);

                }

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///According to app The betaversion field of the config file determines whether to adjust to the betaversion version
        /// by devin
        /// </summary>
        private void InitBetaVersion()
        {
            try
            {
                if (CommonClass.BetaVersion)
                {
                    label4.Location = new Point(234, 219);//What would you like to do?
                    label1.Location = new Point(59, 272);//Process Data
                    btnLoadProject.Location = new Point(80, 316);//Process Data
                    pictureBox4.Location = new Point(80, 365);
                    btnAnnualPM.Location = new Point(80, 369);
                    btnDailyPM.Location = new Point(80, 416);
                    btnOzone.Location = new Point(80, 463);
                    btnHaze.Location = new Point(80, 510);
                    label2.Location = new Point(465, 272);//Analyze/Visualize Data
                    btnDataViewer.Location = new Point(486, 316);
                    label5.Location = new Point(465, 377);//Support && Help
                    btnUserGuide.Location = new Point(486, 423);
                    btnAbout.Location = new Point(486, 469);
                    picSplitLine.Location = new Point(486, 515);
                    btnExit.Location = new Point(486, 517);
                    lblSSIA.Visible = false;//Single Source Impact Analysis
                    picboxsingle.Visible = false;
                    btnSSIAAnnualPM.Visible = false;
                    btnSSIADailyPM.Visible = false;
                    lblAnd.Visible = false;//&
                    btnSSIAOzone.Visible = false;
                    lblBenMAPModule.Visible = false;//BenMAP Benefit Module
                    picBenMAPLogo.Visible = false;
                    btnBenMAPAnnualPM.Visible = false;
                    btnBenMAPSeasonalOzone.Visible = false;
                }
                else
                {
                    label4.Location = new Point(234, 200);//What would you like to do?
                    label1.Location = new Point(59, 232);//Process Data
                    btnLoadProject.Location = new Point(80, 256);//Process Data
                    pictureBox4.Location = new Point(80, 305);
                    btnAnnualPM.Location = new Point(80, 309);
                    btnDailyPM.Location = new Point(80, 356);
                    btnOzone.Location = new Point(80, 403);
                    btnHaze.Location = new Point(80, 450);
                    label2.Location = new Point(59, 504);//Analyze/Visualize Data
                    btnDataViewer.Location = new Point(80, 543);
                    label5.Location = new Point(440, 416);//Support && Help
                    btnUserGuide.Location = new Point(461, 449);
                    btnAbout.Location = new Point(461, 495);
                    picSplitLine.Location = new Point(461, 541);
                    btnExit.Location = new Point(461, 543);
                    lblSSIA.Visible = true;//Single Source Impact Analysis
                    picboxsingle.Visible = true;
                    btnSSIAAnnualPM.Visible = true;
                    btnSSIADailyPM.Visible = true;
                    lblAnd.Visible = true;//&
                    btnSSIAOzone.Visible = true;
                    lblBenMAPModule.Visible = true;//BenMAP Benefit Module
                    picBenMAPLogo.Visible = true;
                    btnBenMAPAnnualPM.Visible = true;
                    btnBenMAPSeasonalOzone.Visible = true;
                }

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Close
        private void btnExit_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //About
        private void btnAbout_Click(object sender, EventArgs e)
        {
            try
            {
                About ab = new About();
                ab.ShowDialog();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Annual PM analysis
        private void btnAnnualPM_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina || Language.Localization.CurrentLanguage == "zh")//The Chinese interface opens the Chinese case by default
                    CommonClass.CurrentAnalysis = enumAnalysis.AnnualPMChina;
                else
                {
                    CommonClass.CurrentAnalysis = enumAnalysis.AnnualPM;
                }
                CommonClass.OutputNavigator = false;
                CommonClass.OpenScenario = false;
                CommonClass.IsDataViewerState = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Daily PM analysis
        private void btnDailyPM_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina)
                    return;
                CommonClass.CurrentAnalysis = enumAnalysis.DailyPM;
                CommonClass.OutputNavigator = false;
                CommonClass.IsDataViewerState = false;
                CommonClass.OpenScenario = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Ozone analysis
        private void btnOzone_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina || Language.Localization.CurrentLanguage == "zh")//Chinese interface, Chinese case is opened by default)
                {
                    CommonClass.CurrentAnalysis = enumAnalysis.OzoneChina;
                }
                else
                {
                    CommonClass.CurrentAnalysis = enumAnalysis.Ozone;
                }
                
                CommonClass.OutputNavigator = false;
                CommonClass.OpenScenario = false;
                CommonClass.IsDataViewerState = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Visibility Analysis
        private void btnHaze_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina)
                    return;
                CommonClass.CurrentAnalysis = enumAnalysis.Visibility;
                CommonClass.OutputNavigator = false;
                CommonClass.OpenScenario = false;
                CommonClass.IsDataViewerState = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Output navigator
        private void btnOutput_Click(object sender, EventArgs e)
        {
            try
            {
                CommonClass.OutputNavigator = true;
                CommonClass.LoadProjectFromStartPageOrAnalysisPage = false;
                CommonClass.IsFirstLoadProject = false;
                CommonClass.OpenScenario = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //User Guide
        private void btnUserGuide_Click(object sender, EventArgs e)
        {
            try
            {
                switch (Language.Localization.CurrentLanguage)
                {
                    case "en":
                        Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm");
                        break;
                    case "zh":
                        Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual_zh.chm");
                        break;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
        private Form _currentForm = null;
        private void btnLoadProject_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openFile = new OpenFileDialog();
                openFile.Title = Language.Localization.GetValue("Select project...");
                openFile.InitialDirectory = CommonClass.ResultFilePath + @"\Result\Project";
                openFile.Filter = Language.Localization.GetValue("Project files(*.proj)|*.proj");
                openFile.RestoreDirectory = true;
                if (openFile.ShowDialog() != DialogResult.OK)
                {
                    return;
                }
                CommonClass.OpenScenario = false;
                CommonClass.OutputNavigator = true;
                CommonClass.LoadProjectFromStartPageOrAnalysisPage = true;
                CommonClass.IsDataViewerState = false;
                CommonClass.FileName = openFile.FileName;
                //_currentForm = new SMAT_CE();
                //(_currentForm as SMAT_CE).LoadProject(openFile.FileName);
                //CommonClass.OpenScenario = true;
                //CommonClass.OutputNavigator = false;
                //CommonClass.IsDataViewerState = false;
                //CommonClass.CurrentBaseScenario = CommonClass.LoadScenario(openFile.FileName);
                //CommonClass.IsOutputNavigator
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSSIAAnnualPM_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina)
                    return;
                CommonClass.CurrentAnalysis = enumAnalysis.SSIAAnnualPM;
                CommonClass.OutputNavigator = false;
                CommonClass.OpenScenario = false;
                CommonClass.IsDataViewerState = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSSIADailyPM_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina)
                    return;
                CommonClass.CurrentAnalysis = enumAnalysis.SSIADailyPM;
                CommonClass.OutputNavigator = false;
                CommonClass.OpenScenario = false;
                CommonClass.IsDataViewerState = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSSIAOzone_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina)
                    return;
                CommonClass.CurrentAnalysis = enumAnalysis.SSIAOzone;
                CommonClass.OutputNavigator = false;
                CommonClass.OpenScenario = false;
                CommonClass.IsDataViewerState = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnBenMAPAnnualPM_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina)
                    return;
                CommonClass.CurrentAnalysis = enumAnalysis.BenMAPAnnualPM;
                CommonClass.OutputNavigator = false;
                CommonClass.OpenScenario = false;
                CommonClass.IsDataViewerState = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnBenMAPSeasonalOzone_Click(object sender, EventArgs e)
        {
            try
            {
                if (LanguageOld.IsSMATChina)
                    return;
                CommonClass.CurrentAnalysis = enumAnalysis.BenMAPSeasonalOzone;
                CommonClass.OutputNavigator = false;
                CommonClass.OpenScenario = false;
                CommonClass.IsDataViewerState = false;
                this.DialogResult = DialogResult.OK;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
