using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class TipForm : FormBase
    {
        /// <summary>
        ///Show prompt window
        /// </summary>
        public TipForm()
        {
            InitializeComponent();
            //lblTip.Text = Msg; //Display prompt on label
            this.TopMost = false;   //Window front
            //Remove the max, min, and close buttons in the upper right corner
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.ControlBox = false;
        }

        /// <summary>
        ///Different prompt windows are displayed according to different parameters passed in
        /// </summary>
        /// <param name="tipStr"></param>
        public TipForm(string tipStr)
        {
            InitializeComponent();

            //lblTip.Text = Msg;
        }

        private string _msg = "Loading Data. Please wait!";
        /// <summary>
        ///Displayed text prompt
        /// </summary>
        public string Msg
        {
            get { return _msg; }
            set
            {
                _msg = value;
                this.Text = _msg;
                timer1 = new Timer();
                timer1.Tick += new EventHandler(timer1_Tick);

            }
        }

        private void TipForm_Load(object sender, EventArgs e)
        {
            progressBarTip.Maximum = 100;//Set the maximum length value
            progressBarTip.Value = 0;//Set current value
            progressBarTip.Step = 1;//Set how much to increase every time
            timer1.Enabled = true;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            Application.DoEvents();
            if (progressBarTip.Value == 100)
            {
                progressBarTip.Value = 0;
            }
            else
                progressBarTip.Value += progressBarTip.Step;//Increase the progress bar once
            //if (progressBarTip.Value == 100)
            //{
            //   progressBarTip.Maximum = 100;//Set the maximum length value
            //   progressBarTip.Value = 0;//set currency
            //   progressBarTip.Step = 5;//Set how much to increase every time
            //    timer1.Enabled = true;
            //    progressBarTip.Value = 0;
            //}
        }
    }
}
