using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using SMAT_CE;

namespace WinControls
{
    public partial class ColorBlendControl : UserControl
    {
        public string strKey = "";

        /// <summary>
        ///Event triggered after manually setting the value range
        /// </summary>
        [Description("Event triggered after manually setting the value range")]
        public event EventHandler CustomizeValueRange;
        protected void OnCustomizeValueRange(object sender, EventArgs e)
        {
            if (CustomizeValueRange != null)
            {
                CustomizeValueRange(sender, e);
            }
        }

        //User defined value range
        bool _useCustomValueRange = false;
        //Actual minimum and maximum values of the form
        public double _minPlotValue = double.NaN;
        public double _maxPlotValue = double.NaN;

        //Declare minimum and maximum values
        double _minValue = 0;
        /// <summary>
        ///Colorblend min
        /// </summary>
        public double MinValue
        {
            get { return _minValue; }
        }

        double _maxValue = 0;
        /// <summary>
        ///Colorblend min
        /// </summary>
        public double MaxValue
        {
            get { return _maxValue; }
        }

        /// <summary>
        ///When dividing discrete color blocks, the numerical distance of each adjacent color block
        /// </summary>
        double _discreteValueStep = 1;

        /// <summary>
        ///When it is continuous color, every adjacent_ Numerical distance of colorarray
        /// </summary>
        double _continuousValueStep = 1;

        //Number of boundary points in legend
        int _count = 7;
        //Legend's color block
        Color[] _colorArray = new Color[7];

        //Users can define color patches according to their own needs
        public Color[] ColorArray
        {
            get { return _colorArray; }
            set { _colorArray = value; }
        }

        //Redraw legend
        ColorBlend _colorBlend = new ColorBlend();

        private double[] _valueArray = new double[7];

        /// <summary>
        ///The starting value of each color block in legend is used for the customized colorblend, which is not used at present
        /// </summary>
        public double[] ValueArray
        {
            get { return _valueArray; }
            set { _valueArray = value; }
        }

        private string valueUnit;
        /// <summary>
        ///Unit of value
        /// </summary>
        public string ValueUnit
        {
            get { return valueUnit; }
            set
            {
                lblUnit.Text = value;
                lblUnit.Visible = true;
                SetUnitLabelPosition();
                valueUnit = value;
            }
        }

        public ColorBlendControl()
        {
            InitializeComponent();
            //The color of the boundary point must be initialized in the constructor, otherwise an exception will be generated
            SetDefaultColors();

            //lblUnit.Text = "";
        }

        //Initialize the boundary point color, and can also be used to set the default color
        private void SetDefaultColors()
        {
            try
            {
                //Color.Blue, Color.FromArgb(0, 255, 255), Color.FromArgb(0, 255, 0), Color.Yellow, Color.Red 
                _colorArray[0] = Color.LightGray;//Color.FromArgb(0,0,251);
                _colorArray[1] = Color.FromArgb(57, 125, 252);
                _colorArray[2] = Color.FromArgb(24, 240, 255);
                _colorArray[3] = Color.FromArgb(173, 255, 152);
                _colorArray[4] = Color.FromArgb(251,255,18);//Color FromArgb(255, 255, 0);

                //_colorArray[4] = Color.FromArgb(255, 0, 255);
                _colorArray[5] = Color.FromArgb(255, 162, 0);
                _colorArray[6] = Color.FromArgb(253, 47, 0);
                //Define multiple colors
                _colorBlend.Colors = _colorArray;
                _colorBlend.Positions = new float[] { 0f, 0.143f, 0.286f, 0.428f, 0.571f, 0.714f, 0.857f };
                //Assign the legend color bar to an array
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            if (this.Parent.Size.Width >= 400)
                this.Size = new Size(400, 30);
            base.OnPaint(e);
            //this.lblMax.Top = 42;
            //this.lblMin.Top = 42;
            //this.lblUnit.Top = 42;            
            try
            {
                //e.Graphics.Clear(Color.FromArgb(CommonClass.BackColorPick[0], CommonClass.BackColorPick[1], CommonClass.BackColorPick[2]));
            }
            catch
            {
            }
            Point pt = new Point(0, 0);
            int height = 10;// lblMax.Top - 2;
            //if (height < 10) { height = 10; }
            int width = (int)(Convert.ToDouble(ClientSize.Width - lblUnit.Size.Width) / (Convert.ToDouble(ColorArray.Length)+2));
            Size size = new Size(width, height);
            Rectangle rect = new Rectangle();
            for (int i = 0; i < ColorArray.Length ; i++)
            {
                pt = new Point(lblUnit.Size.Width / 2 + (1 + i) * width, 0);
                rect = new Rectangle(pt, size);
                e.Graphics.FillRectangle(new SolidBrush(ColorArray[i]), rect);
            }
            lblMin.Location = new Point(lblUnit.Size.Width / 2 + width - lblMin.Size.Width / 2, 14);
            lbl1.Location = new Point(lblUnit.Size.Width / 2 + 2 * width - lbl1.Size.Width / 2, 14);
            lbl2.Location = new Point(lblUnit.Size.Width / 2 + 3 * width - lbl2.Size.Width / 2, 14);
            lbl3.Location = new Point(lblUnit.Size.Width / 2 + 4 * width - lbl3.Size.Width / 2, 14);
            lbl4.Location = new Point(lblUnit.Size.Width / 2 + 5 * width - lbl4.Size.Width / 2, 14);
            lbl5.Location = new Point(lblUnit.Size.Width / 2 + 6 * width - lbl5.Size.Width / 2, 14);
            lbl6.Location = new Point(lblUnit.Size.Width / 2 + 7 * width - lbl6.Size.Width / 2, 14);
            lblMax.Location = new Point(lblUnit.Size.Width / 2 + 8 * width - lblMax.Size.Width / 2, 14);
            //lblUnit.Location = new Point(lblMax.Location.X + lblMax.Width + 10, 14);
            lblUnit.Location = lblMax.Location;
            //--------Gradient
            //Size size = new Size(ClientSize.Width, height);
            //using (LinearGradientBrush brush = new LinearGradientBrush(rect, _colorArray[0], _colorArray[1], LinearGradientMode.Horizontal))
            //{
            //    brush.InterpolationColors = _colorBlend;
            //    e.Graphics.FillRectangle(brush, rect);
            //}

            //-----------Modify by xiejp --------- don't let it fade into direct color blocks!

        }

        /// <summary>
        ///Set the maximum value, and the minimum value is displayed on colorblendcontrol
        /// </summary>
        ///<param name="minvalue">minimum value passed in</param>
        ///<param name="maxvalue">maximum value passed in</param>
        ///<param name="isfirstload">used to control whether to restore the default state: true restores the default state, and flash is set according to the user</param>
        public void SetValueRange(double minValue, double maxValue, bool isFirstLoad)
        {
            try
            {
                //added by Edwin
                if (minValue == 0 && maxValue == 0)
                {
                    lbl1.Visible = false;
                    lbl2.Visible = false;
                    lbl3.Visible = false;
                    lbl4.Visible = false;
                    lbl5.Visible = false;
                    lbl6.Visible = false;
                    lblMax.Visible = false;
                    lblMin.Visible = false;
                    lblUnit.Visible = false;
                    _minValue = 0;
                    _maxValue = 0;
                    for (int i = 0; i < 7; i++)
                    {
                        _valueArray[i] = 0;
                    }
                    return;
                }

                Int64 tmp = (Int64)(minValue * 10000d);
                minValue = tmp / 10000d;
                tmp = (Int64)(maxValue * 10000d);
                maxValue = tmp / 10000d;
                _minValue = minValue;
                _maxValue = maxValue;
                //--------------Check whether valuearray is reasonable.If valuearray is used reasonably----
                bool IsValidValueArray = false;
                for (int i = 1; i < 7; i++)
                {
                    if (_valueArray[i] <= _valueArray[i - 1])
                    {
                        IsValidValueArray = false;
                        break;
                    }
                    else
                    {
                        IsValidValueArray = true;
                    }
                }

                //DefaultStartValue(_minValue, _maxValue);
                if (isFirstLoad)
                {
                    SetDefaultValues(minValue, maxValue);
                    SetDefaultColors();
                }
                else
                {
                    if (IsValidValueArray == false)
                    {
                        SetDefaultValues(minValue, maxValue);

                    }
                    else
                    {
                        maxValue = _valueArray[6];
                        _maxValue = maxValue;
                        minValue = _valueArray[0];
                        _minValue = minValue;
                    }
                }
                //lblMin.Text = minValue.ToString("0.###");// minValue.ToString("g4"); G4->general 4 significant digits
                //lblMax.Text = maxValue.ToString("0.###");// maxValue.ToString("g4");
                if ((maxValue - minValue) > 1)
                {
                    lblMin.Text = Math.Round(minValue, 1).ToString("F1");
                    lbl1.Text = Math.Round(_valueArray[1], 1).ToString("F1");
                    lbl2.Text = Math.Round(_valueArray[2], 1).ToString("F1");
                    lbl3.Text = Math.Round(_valueArray[3], 1).ToString("F1");
                    lbl4.Text = Math.Round(_valueArray[4], 1).ToString("F1");
                    lbl5.Text = Math.Round(_valueArray[5], 1).ToString("F1");
                    lbl6.Text = Math.Round(_valueArray[6], 1).ToString("F1");
                    lblMax.Text = Math.Round(maxValue, 1).ToString("F1");
                    if (lblUnit.Text.Contains("x1E-3 "))
                        lblUnit.Text=lblUnit.Text.Replace("x1E-3 ", "");
                }
                else if ((maxValue - minValue < 0.005) && minValue < 0.001)
                {
                    lblMin.Text = Math.Round(minValue*1000, 3).ToString("F3");
                    lbl1.Text = Math.Round(_valueArray[1]*1000, 3).ToString("F3");
                    lbl2.Text = Math.Round(_valueArray[2]*1000, 3).ToString("F3");
                    lbl3.Text = Math.Round(_valueArray[3]*1000, 3).ToString("F3");
                    lbl4.Text = Math.Round(_valueArray[4]*1000, 3).ToString("F3");
                    lbl5.Text = Math.Round(_valueArray[5] * 1000, 3).ToString("F3");
                    lbl6.Text = Math.Round(_valueArray[6] * 1000, 3).ToString("F3");
                    lblMax.Text = Math.Round(maxValue*1000, 3).ToString("F3");
                    if (!lblUnit.Text.Contains("x1E-3 "))
                        lblUnit.Text = lblUnit.Text.Insert(0, "x1E-3 ");
                }
                else
                {
                    lblMin.Text = Math.Round(minValue, 3).ToString("F3");
                    lbl1.Text = Math.Round(_valueArray[1], 3).ToString("F3");
                    lbl2.Text = Math.Round(_valueArray[2], 3).ToString("F3");
                    lbl3.Text = Math.Round(_valueArray[3], 3).ToString("F3");
                    lbl4.Text = Math.Round(_valueArray[4], 3).ToString("F3");
                    lbl5.Text = Math.Round(_valueArray[5], 3).ToString("F3");
                    lbl6.Text = Math.Round(_valueArray[6], 3).ToString("F3");
                    lblMax.Text = Math.Round(maxValue, 3).ToString("F3");
                    if (lblUnit.Text.Contains("x1E-3 "))
                        lblUnit.Text=lblUnit.Text.Replace("x1E-3 ", "");
                }
                lbl1.Text = "<" + lbl1.Text;
                lbl6.Text = ">" + lbl6.Text;
                //if ((0.00001 < minValue) && (minValue < 100000)) { lblMin.Text = string.Format("{0}", Math.Round(minValue, 3)); }
                //else
                //{ lblMin.Text = string.Format("{0}", Math.Round(minValue, 3).ToString("G3")); }
                //if ((0.00001 < maxValue) && (maxValue < 100000))
                //{ lblMax.Text = string.Format("{0}", Math.Round(maxValue, 3)); }
                //else
                //{ lblMax.Text = string.Format("{0}", Math.Round(maxValue, 3).ToString("G3")); }

                //if ((0.00001 < _valueArray[1]) && (_valueArray[1] < 100000))
                //{ lbl1.Text = string.Format("{0}", Math.Round(_valueArray[1], 3)); }
                //else
                //{ lbl1.Text = string.Format("{0}", Math.Round(_valueArray[1], 3).ToString("G3")); }
                //if ((0.00001 < _valueArray[2]) && (_valueArray[2] < 100000))
                //{ lbl2.Text = string.Format("{0}", Math.Round(_valueArray[2], 3)); }
                //else
                //{ lbl2.Text = string.Format("{0}", Math.Round(_valueArray[2], 3).ToString("G3")); }
                //if ((0.00001 < _valueArray[3]) && (_valueArray[3] < 100000))
                //{ lbl3.Text = string.Format("{0}", Math.Round(_valueArray[3], 3)); }
                //else
                //{ lbl3.Text = string.Format("{0}", Math.Round(_valueArray[3], 3).ToString("G3")); }
                //if ((0.00001 < _valueArray[4]) && (_valueArray[4] < 100000))
                //{ lbl4.Text = string.Format("{0}", Math.Round(_valueArray[4], 3)); }
                //else
                //{ lbl4.Text = string.Format("{0}", Math.Round(_valueArray[4], 3).ToString("G3")); }
                //lblMin.Text = string.Format("{0}", Math.Round(minValue, 3).ToString("E2"));
                //lblMax.Text = string.Format("{0}", Math.Round(maxValue, 3).ToString("E2"));
                //lblMax.Left = this.ClientSize.Width - lblMax.Width;
                int width = (int)(Convert.ToDouble(ClientSize.Width - lblUnit.Size.Width) / (Convert.ToDouble(ColorArray.Length) + 2));
                lblMin.Location = new Point(lblUnit.Size.Width / 2 + width - lblMin.Size.Width / 2, 14);
                lbl1.Location = new Point(lblUnit.Size.Width / 2 + 2 * width - lbl1.Size.Width / 2, 14);
                lbl2.Location = new Point(lblUnit.Size.Width / 2 + 3 * width - lbl2.Size.Width / 2, 14);
                lbl3.Location = new Point(lblUnit.Size.Width / 2 + 4 * width - lbl3.Size.Width / 2, 14);
                lbl4.Location = new Point(lblUnit.Size.Width / 2 + 5 * width - lbl4.Size.Width / 2, 14);
                lbl5.Location = new Point(lblUnit.Size.Width / 2 + 6 * width - lbl5.Size.Width / 2, 14);
                lbl6.Location = new Point(lblUnit.Size.Width / 2 + 7 * width - lbl6.Size.Width / 2, 14);
                lblMax.Location = new Point(lblUnit.Size.Width / 2 + 8 * width - lblMax.Size.Width / 2, 14);
                //lblUnit.Location = new Point(lblMax.Location.X + lblMax.Width + 10, 14);
                lblUnit.Location = lblMax.Location;

                lbl1.Visible = true;
                lbl2.Visible = true;
                lbl3.Visible = true;
                lbl4.Visible = true;
                lbl5.Visible = true;
                lbl6.Visible = true;
                //lblMax.Visible = true;
                //lblMin.Visible = true;
                this.Invalidate();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Set the value of the boundary point according to the default rule
        private void SetDefaultValues(double minValue, double maxValue)
        {
            try
            {
                //Initialize color block: the whole color block is composed of 5 boundary points
                //int count = _valueArray.Length;
                //The equal score between the minimum and maximum is 4
                //double var = (maxValue - minValue) / (_count);
                double var = (maxValue - minValue) / (_count-1);//change by devin,need to minus one; 2017-03-05
                _valueArray[0] = minValue;
                _valueArray[_valueArray.Length - 1 ] = maxValue;
                for (int i = 0; i < _count; i++)
                {
                    _valueArray[i] = minValue + i * var;
                    //_valueArray[i] = Math.Round(_valueArray[i], 3);
                }

                _continuousValueStep = var;
                _discreteValueStep = (maxValue - minValue) / 10.0;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Get the corresponding color according to the incoming grid value
        /// </summary>
        ///<param name="val">grid value</param>
        ///<returns>corresponding color</returns>
        public Color GetValueColor2(double val)
        {
            try
            {
                //int zoneIndex = 0;// Interval index, by_ Colorarray [] OK, this example is 4
                int partColor = 255;
                double dblPercent = (val - _minValue) / (_maxValue - _minValue);
                // Console.Write(dblPercent+"  ");
                //zoneIndex = (int)dblPercent;
                if (dblPercent < 0)
                {
                    //return _colorArray[0];
                    return Color.Transparent;
                }
                else if (dblPercent < 0.2)
                {
                    partColor = (int)(255 * 4 * dblPercent);
                    // Console.WriteLine(partColor);
                    return Color.FromArgb(0, partColor, 255);
                }
                else if (dblPercent < 0.4)
                {
                    partColor = 255 - (int)(255 * 4 * (dblPercent - 0.2));
                    //Console.WriteLine(partColor);
                    return Color.FromArgb(0, 255, partColor);
                }
                else if (dblPercent < 0.6)
                {
                    partColor = (int)(255 * 4 * (dblPercent - 0.4));
                    //Console.WriteLine(partColor);
                    return Color.FromArgb(partColor, 255, 0);
                }
                else if (dblPercent < 0.8)
                {
                    partColor = 255 - (int)(255 * 4 * (dblPercent - 0.6));
                    //Console.WriteLine(partColor);
                    return Color.FromArgb(255, partColor, 0);
                }
                //else if (dblPercent <= 1)
                //{
                //    partColor = (int)(255 * 5 * (dblPercent - 0.8));
                //    //Console.WriteLine(partColor);
                //    return Color.FromArgb(255, 0, partColor);
                //}
                else
                {
                    //return _colorArray[5];
                    return Color.Transparent;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return _colorArray[0];
            }
        }

        /// <summary>
        ///Get the corresponding color according to the incoming grid value Can handle isometric and custom color ranges
        /// </summary>
        ///<param name="val">grid value</param>
        ///<returns>corresponding color</returns>
        public Color GetValueColor(double val)
        {
            try
            {
                Color partColor = Color.Transparent;
                if (val <= _valueArray[0])
                {
                    return _colorArray[0];
                }
                else if (val >= _valueArray[_count - 1])
                {
                    return _colorArray[_count - 1];
                }
                double dbPercent = 0.00;
                byte a = 255;
                byte r = 255;
                byte g = 255;
                byte b = 255;

                //Only isometric cases can be handled
                //double tmp = val / _continuousValueStep;
                //int i = (int)Math.Floor(tmp);
                //double dbPercent = tmp - i;
                //a = (byte)(_colorArray[i].A + (_colorArray[i + 1].A - _colorArray[i].A) * dbPercent);
                //r = (byte)(_colorArray[i].R + (_colorArray[i + 1].R - _colorArray[i].R) * dbPercent);
                //g = (byte)(_colorArray[i].G + (_colorArray[i + 1].G - _colorArray[i].G) * dbPercent);
                //b = (byte)(_colorArray[i].B + (_colorArray[i + 1].B - _colorArray[i].B) * dbPercent);
                //partColor = Color.FromArgb(a, r, g, b);

                //Count is a global variable, equal to the number of boundary points
                for (int i = 1; i < _count; i++)
                {
                    //Judge the filling color according to the incoming value
                    //Judgment idea: if the incoming value is less than the minimum boundary value, it will be displayed as the first color point;
                    //If the incoming value is greater than the maximum boundary value, it is displayed as the next color
                    if (val < _valueArray[i])
                    {
                        dbPercent = (val - _valueArray[i - 1]) / (_valueArray[i] - _valueArray[i - 1]);
                        //partColor.ToKnownColor();
                        a = (byte)(_colorArray[i - 1].A + (_colorArray[i].A - _colorArray[i - 1].A) * dbPercent);
                        // Console.Write(a+" ");
                        r = (byte)(_colorArray[i - 1].R + (_colorArray[i].R - _colorArray[i - 1].R) * dbPercent);
                        g = (byte)(_colorArray[i - 1].G + (_colorArray[i].G - _colorArray[i - 1].G) * dbPercent);
                        b = (byte)(_colorArray[i - 1].B + (_colorArray[i].B - _colorArray[i - 1].B) * dbPercent);
                        // tmpColorValue = (int)(_colorArray[i - 1].ToArgb() + (_colorArray[i].ToArgb() - _colorArray[i - 1].ToArgb()) * dbPercent);
                        // partColor = Color.FromArgb(tmpColorValue);
                        partColor = Color.FromArgb(a, r, g, b);
                        break;
                    }
                    //}
                }
                return partColor;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return _colorArray[0];
            }
        }

        /// <summary>
        ///According to the incoming grid value, the corresponding color is obtained without interpolation
        /// </summary>
        ///<param name="val">grid value</param>
        ///<returns>corresponding color</returns>
        public Color GetValueRangeColor(double val)
        {
            val = _minValue + _discreteValueStep * Math.Floor(val / _discreteValueStep);
            return GetValueColor(val);
        }

        /// <summary>
        ///Set the location of the unit label
        /// </summary>
        private void SetUnitLabelPosition()
        {
            try
            {
                //lblUnit.Left = (this.ClientSize.Width - lblUnit.Width) / 2;
                //lblUnit.Location = new Point(lblMax.Location.X + lblMax.Width + 10, 14);//modified by Edwin
                lblUnit.Location = new Point(lblMax.Location.X, 14);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        protected override void OnMouseMove(MouseEventArgs e)
        {
            try
            {
                if (_maxValue > _minValue)
                {
                    double val = _minValue + ((double)e.X / (double)this.Width) * (_maxValue - _minValue);
                    //toolTip1.SetToolTip(this, val.ToString("0.##"));
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            finally
            {
                base.OnMouseMove(e);
            }
        }

        protected override void OnDoubleClick(EventArgs e)
        {
            try
            {
                SetValueRange frm = new SetValueRange();
                //Transfer the minimum and maximum values and units into the set value range form
                frm.MinValue = _minValue;
                frm.MaxValue = _maxValue;

                frm.Unit = lblUnit.Text;
                //Pass the start value of each interval and each equally divided color block into the set value range form as an array
                frm.ValueArray = _valueArray;
                frm.ColorArray = _colorArray;
                //Isfirstload=true when the control is used for the first time, otherwise it is false
                bool isFirstLoad = false;
                //Record defaults
                //Pay attention to the sequence of code execution.The default value must be assigned before the event delegate, otherwise it is the first time to execute "rebuild" or "OK" after the pop-up window is executed
                if (double.IsNaN(_minPlotValue))
                {
                    _minPlotValue = _minValue;
                    _maxPlotValue = _maxValue;
                }

                //Delegate the practice to a method named setvaluerange_ Valuerangechanged method
                frm.ValueRangeChanged += SetValueRange_ValueRangeChanged;

                DialogResult rtn = frm.ShowDialog();
                if (rtn == DialogResult.OK)
                {
                    isFirstLoad = false;
                    SetValueRangeAndBundaryColor(frm, isFirstLoad);
                }
                else if (rtn == DialogResult.Ignore)
                {
                    isFirstLoad = true;
                    SetValueRangeAndBundaryColor(frm, isFirstLoad);
                }

                //Destroy object
                frm.Dispose();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            finally
            {
                base.OnDoubleClick(e);
            }
        }

        //Event setvaluerange_ Processing method of valuerangechanged
        private void SetValueRange_ValueRangeChanged(SetValueRange frm)
        {
            try
            {
                // MessageBox.Show("........");
                SetValueRangeAndBundaryColor(frm, false);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Set the boundary point and color of colorblendcontrol according to the incoming value
        /// </summary>
        ///<param name="frm">pop up form</param>
        ///<param name="isfirstload">tru: restore the default setting, false: the value at the time of setting</param>
        public void SetValueRangeAndBundaryColor(SetValueRange frm, bool isFirstLoad)
        {
            try
            {
                _useCustomValueRange = false;
                //SetValueRange();
                if (!isFirstLoad)
                {
                    _minValue = frm.MinValue;
                    
                    _maxValue = frm.MaxValue;
                    _colorArray = frm.ColorArray;
                    _valueArray = frm.ValueArray;
                    SetValueRange(_minValue, _maxValue, isFirstLoad);
                    
                }
                else
                {
                    if(strKey!="")
                    {
                        SetValueRange(CommonClass.dicLayerValueRange[strKey].Item1, CommonClass.dicLayerValueRange[strKey].Item2, isFirstLoad);
                    }
                    else
                        SetValueRange(_minPlotValue, _maxPlotValue, isFirstLoad);
                }
                _useCustomValueRange = true;
                //Return the set color and boundary value
                OnCustomizeValueRange(this, null);
                this.Invalidate();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            try
            {
                bool isLegend = true;
                SavePicture save = new SavePicture(this);
                save.SaveAs(isLegend);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Draw the graph on a bitmap and return This bitmap will be used when saving, but when the current form is called by onpaint method, the_ BMP, do not directly use the return value
        /// </summary>
        /// <returns></returns>
        public Bitmap DrawImage()
        {
            try
            {
                Bitmap bmp = new Bitmap(this.ClientSize.Width, this.ClientSize.Height);
                //using (Graphics bmpGraphics = Graphics.FromImage(bmp))
                //{
                //    Point pt = new Point(0, 0);
                //    int height = lblMax.Top - 2;
                //    if (height < 10) { height = 10; }
                //    Size size = new Size(this.ClientSize.Width, height);
                //    Rectangle rect = new Rectangle(pt, size);
                //    using (LinearGradientBrush brush = new LinearGradientBrush(rect, _colorArray[0], _colorArray[1], LinearGradientMode.Horizontal))
                //    {
                //        brush.InterpolationColors = _colorBlend;
                //        e.Graphics.FillRectangle(brush, rect);
                //    }

                //}
                this.DrawToBitmap(bmp, this.ClientRectangle);// new Rectangle(new Point(0,0),new Size(bmp.Width,bmp.Height)));
                return bmp;
            }

            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }
    }//class
}//namespace
