using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using System.IO;
using System.Drawing.Imaging;
using System.Text.RegularExpressions;
using System.Linq;
using WinControls;
using SMAT_CE.Properties;
namespace SMAT_CE
{
    /// <summary>
    ///A grid in the model domain
    /// </summary>
    public struct GridCell
    {
        /// <summary>
        ///Line, starting from 1
        /// </summary>
        public int Row;
        /// <summary>
        ///Columns, starting from 1
        /// </summary>
        public int Col;
        /// <summary>
        ///Value
        /// </summary>
        public double Value;
    }

    public partial class PlotControl : UserControl
    {

        private PointF selectedPoint;
        public PointF SelectedPoint { get => selectedPoint; set => selectedPoint = value; }
        public string strSelectedPointLatLon;

        public bool isMarkSelectedPoint = false;

        #region Private variables and properties
        /// <summary>
        ///Whether to draw monitoring points
        /// </summary>
        public bool IsDrawMonitors = false;

        /// <summary>
        ///Whether to draw pollution source
        /// </summary>
        public bool IsDrawSSIASource = false;

        /// <summary>
        ///Monitoring point value
        /// </summary>
        public Dictionary<string, double> dicMonitors = new Dictionary<string, double>();

        /// <summary>
        ///Pollution source location
        /// </summary>
        public PointF pointSource = new PointF();

        /// <summary>
        ///Projection parameters
        /// </summary>
        public DotSpatial.Projections.ProjectionInfo projForMap = new DotSpatial.Projections.ProjectionInfo();

        private bool _useInterpolation = false;
        /// <summary>
        ///Whether to use interpolation
        /// </summary>
        public bool UseInterpolation
        {
            get { return _useInterpolation; }
            set
            {
                _useInterpolation = value;
                _needRedrawBmp = true;
                this.Invalidate();
            }
        }

        private bool _useContinuousColor = true;
        /// <summary>
        ///Use continuous colors
        /// </summary>
        public bool UseContinuousColor
        {
            get { return _useContinuousColor; }
            set
            {
                _useContinuousColor = value;
                _needRedrawBmp = true;
                this.Invalidate();
            }
        }

        /// <summary>
        ///Selected gridcell list
        /// </summary>
        private List<GridCell> _selectedCells = null;
        /// <summary>
        ///Selected gridcell list
        /// </summary>
        public List<GridCell> SelectedCells
        {
            get { return _selectedCells; }
            set { _selectedCells = value; }
        }

        /// <summary>
        ///A coefficient that converts world coordinates into page coordinates
        /// </summary>
        private float _factor = 1;

        /// <summary>
        ///Coordinate conversion matrix, which is converted to y-up as positive by default
        /// </summary>
        /// <remarks>
        /// 1  0  1
        /// 0  -1 1
        /// dx dy 1
        /// </remarks>
        private Matrix _matrix = new Matrix(1f, 0f, 0f, -1f, 0f, 0f);

        private Color _shapeLineColor = Color.Gray;
        /// <summary>
        ///Line color of shape
        /// </summary>
        public Color ShapeLineColor
        {
            get { return _shapeLineColor; }
            set { _shapeLineColor = value; }
        }


        private ModelDef _modelDef;
        //private static RSMModelDef _modelDef;
        /// <summary>
        ///The rsmmodeldef object used for this control is usually set when changing the policy corresponding to this control
        /// </summary>
        public ModelDef modelDef
        {
            get { return _modelDef; }
            set { _modelDef = value; }
        }



        List<List<PointF>> _segmentsList = null;
        /// <summary>
        ///Line segment list for drawing shape
        /// </summary>
        public List<List<PointF>> SegmentsList
        {
            get { return _segmentsList; }
            set { _segmentsList = value; }
        }

        private float[] _xCoords;
        /// <summary>
        ///X coordinates of all grids, with the number of locationcount
        /// </summary>
        public float[] XCoords
        {
            get { return _xCoords; }
            set { _xCoords = value; }
        }

        private float[] _yCoords;
        /// <summary>
        ///Y coordinates of all grids, with the number of locationcount
        /// </summary>
        public float[] YCoords
        {
            get { return _yCoords; }
            set { _yCoords = value; }
        }

        /// <summary>
        ///All meshes at the minimum value
        /// </summary>
        double _minValue = 0;
        /// <summary>
        ///Maximum value in all meshes
        /// </summary>
        double _maxValue = 0;
        private double[] _gridValues = new double[0];
        /// <summary>
        ///The number of values of all grids is locationcount
        /// </summary>
        public double[] GridValues
        {
            get { return _gridValues; }
            set
            {
                if (value == null || value.Length == 0) { return; }
                _gridValues = value;
                #region added by devin
                double[] tmp = new double[_gridValues.Length];
                _gridValues.CopyTo(tmp, 0);
                Array.Sort(tmp);
                double minValue = tmp[_gridValues.Length - 1];
                double maxValue = _gridValues[0];
                #endregion
                //_minValue = 0;
                //_maxValue = _gridValues[0];
                for (int i = 1; i < _gridValues.Length; i++)
                {
                    if (_gridValues[i] != -9) //added by devin 20130914
                    {
                        if (_gridValues[i] < _minValue) { _minValue = _gridValues[i]; }
                        else if (_gridValues[i] > _maxValue) { _maxValue = _gridValues[i]; }
                    }

                }
                if (_colorBlendControl != null)
                {
                    //Isfirstload is equal to true, initialize the social express partition
                    bool isFirstLoad = true;
                    _colorBlendControl.SetValueRange(_minValue, _maxValue, isFirstLoad);

                    //Set the color of the mesh
                    ResetAllGridsColor();
                }
                //_ needRedrawBmp = true;// Move to the resetallgridscolor() function
                //this.Invalidate();
            }
        }
        #region Grid value dictionary<string, double>_ NewGridValues
        // private Dictionary<string, double> _NewGridValues = new Dictionary<string, double>();
        //public Dictionary<string, double> NewGridValues
        //{
        //    get { return _NewGridValues; }
        //    set
        //    {
        //        if (value == null || value.Keys.Count == 0) { return; }
        //        _NewGridValues = value;
        //        double[] tmp = new double[value.Keys.Count];
        //        _minValue = CommonClass.minValue;
        //        _maxValue = 0;
        //        foreach (var key in _NewGridValues.Keys)
        //        {
        //            if (_NewGridValues[key] < _minValue) { _minValue = _NewGridValues[key]; }
        //            else if (_NewGridValues[key] > _maxValue) { _maxValue = _NewGridValues[key]; }
        //        }

        //        if (_colorBlendControl != null)
        //        {
        ////isfirstload equals true, initialize the social express partition
        //            bool isFirstLoad = true;
        //            _colorBlendControl.SetValueRange(_minValue, _maxValue, isFirstLoad);

        ////set the color of the grid
        //            ResetNewAllGridsColor();
        //        }
        //    }
        //}
        #endregion

        #region added by Edwin 20131218
        //use for recording the Map name in lstSpeciesTypeMap(Form SMAT_CE) 
        public string Mapname = "";
        //used for recoding the min&max value of each Maps
        private Dictionary<string, Dictionary<double, double>> dicMinMax = new Dictionary<string, Dictionary<double, double>>();
        //clean 
        public void MinMaxClean()
        {
            dicMinMax.Clear();
        }
        #endregion

        private Dictionary<string, double> _NewGridValues = new Dictionary<string, double>();
        public Dictionary<string, double> NewGridValues
        {
            get { return _NewGridValues; }
            set
            {
                if (value == null || value.Keys.Count == 0) { return; }
                _NewGridValues = value;
                double[] tmp = new double[value.Keys.Count];

                //_minValue = CommonClass.minValue;
                _minValue = _NewGridValues.Values.Max();
                _maxValue = 0;
                foreach (var key in _NewGridValues.Keys)
                {
                    if (_NewGridValues[key] == -9 || _NewGridValues[key] == -7)
                        continue;
                    if (_NewGridValues[key] < _minValue) { _minValue = _NewGridValues[key]; }
                    else if (_NewGridValues[key] > _maxValue) { _maxValue = _NewGridValues[key]; }
                }

                _colorBlendControl._minPlotValue = _minValue;
                _colorBlendControl._maxPlotValue = _maxValue;

                ////Get min&max value from Dictionary 'MinMax'  added and modified by Edwin 20131218
                //if (!(_minValue == 0 && _maxValue == 0) && Mapname != "" && dicMinMax.Keys.Contains(Mapname))
                //{
                //    Dictionary<double, double> dic = new Dictionary<double, double>();
                //    dicMinMax.TryGetValue(Mapname, out dic);
                //    _minValue = dic.Keys.First();
                //    _maxValue = dic.Values.Last();
                //}


                if (_colorBlendControl != null)
                {
                    //added by Edwin 2014.3.24
                    if (CommonClass.dicBlend.Keys.Contains("Map") && CommonClass.dicBlend["Map"].Keys.Contains(Mapname))
                    {
                        SetValueRange frm = new SetValueRange();
                        frm.ColorArray = CommonClass.dicBlend["Map"][Mapname].colorarray;
                        frm.ValueArray = CommonClass.dicBlend["Map"][Mapname].value;
                        frm.MinValue = CommonClass.dicBlend["Map"][Mapname].min;
                        frm.MaxValue = CommonClass.dicBlend["Map"][Mapname].max;
                        _colorBlendControl.SetValueRangeAndBundaryColor(frm, false);
                    }
                    else
                    {
                        //Isfirstload equals true, initialize the color block partition
                        bool isFirstLoad = true;
                        _colorBlendControl.SetValueRange(_minValue, _maxValue, isFirstLoad);

                    }
                    //Set the color of the mesh
                    ResetNewAllGridsColor();
                }

            }
        }
        /// <summary>
        ///Re color all meshes and redraw all meshes
        /// </summary>
        public void ResetNewAllGridsColor()
        {
            try
            {
                _gridColors = new Color[_NewGridValues.Keys.Count];
                int j = 0;
                foreach (var key in _NewGridValues.Keys)
                {
                    _gridColors[j] = _colorBlendControl.GetValueColor(_NewGridValues[key]);
                    j++;
                }

                _needRedrawBmp = true;
                this.Invalidate();

                ////...Save min&max value to Dictionary MinMax added by Edwin 201301218
                //Dictionary<double, double> dic = new Dictionary<double, double>();
                //dic.Add(_colorBlendControl.MinValue, _colorBlendControl.MaxValue);
                //if (dicMinMax.Keys.Contains(Mapname))
                //    dicMinMax[Mapname] = dic;
                //else
                //    dicMinMax.Add(Mapname, dic);

                //added by Edwin 2014.3.24
                CommonClass.SaveBlend saveblend = new CommonClass.SaveBlend(_colorBlendControl.ColorArray, _colorBlendControl.ValueArray);
                saveblend.max = _colorBlendControl.MaxValue;
                saveblend.min = _colorBlendControl.MinValue;
                _colorBlendControl.SetValueRange(saveblend.min, saveblend.max, false);//Let txtmax be the minimum value of red
                if (!CommonClass.dicBlend.Keys.Contains("Map"))
                {
                    Dictionary<string, CommonClass.SaveBlend> dic = new Dictionary<string, CommonClass.SaveBlend>();
                    dic.Add(Mapname, saveblend);
                    CommonClass.dicBlend.Add("Map", dic);
                }
                else if (CommonClass.dicBlend["Map"].Keys.Contains(Mapname))
                    CommonClass.dicBlend["Map"][Mapname] = saveblend;
                else
                    CommonClass.dicBlend["Map"].Add(Mapname, saveblend);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
        /// <summary>
        ///Re color all meshes and redraw all meshes
        /// </summary>
        public void ResetAllGridsColor()
        {
            try
            {
                _gridColors = new Color[_gridValues.Length];
                for (int j = 0; j < _gridValues.Length; j++)
                {
                    if (_gridValues[j] != -9) //added by devin 20130914
                    {
                        _gridColors[j] = _colorBlendControl.GetValueColor(_gridValues[j]);
                    }

                }
                _needRedrawBmp = true;
                this.Invalidate();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Color of all meshes, set in_ Set when gridvalues
        /// </summary>
        private Color[] _gridColors = new Color[0];

        private ColorBlendControl _colorBlendControl;
        /// <summary>
        ///Color legend
        /// </summary>
        public ColorBlendControl ColorBlendControl
        {
            get { return _colorBlendControl; }
            set { _colorBlendControl = value; }
        }


        /// <summary>
        ///The mesh color is excessively mixed to the periphery, which is initialized in the constructor
        /// </summary>
        Blend _blend = new Blend();


        /// <summary>
        ///When the model field is drawn on the form, the size of the width or height of the reduced edge in the form coordinates
        /// </summary>
        private float _modelWidthOrHeightInForm = 0f;


        /// <summary>
        ///Identify the coordinate axis where the model value changes
        /// </summary>
        private string _axisChanged = "x";
        #endregion

        /// <summary>
        /// plotting monitors on Map
        /// </summary>
        /// <param name="dicMonitors">dictionary of monitors; key->x,y; value->concentration</param>
        /// <param name="bmpGraphics"></param>
        /// <returns>T or F</returns>
        private bool drawMonitor(Dictionary<string, double> dicMonitors, Graphics bmpGraphics)
        {

            string errorMsg = "";
            SolidBrush brush = new SolidBrush(Color.Blue);
            if (dicMonitors.Keys.Count <= 0) { errorMsg = "No monitors!"; goto Exit; }
            try
            {
                //Todo: determine whether the grid coordinate is in the lower left corner of the cell or the midpoint of the cell
                float d = 8 / _factor;
                SizeF size = new SizeF(d, d);
                int i = 0;
                foreach (var key in dicMonitors.Keys)
                {
                    Color cellColor = _colorBlendControl.GetValueColor(dicMonitors[key]);

                    brush = new SolidBrush(cellColor);

                    string[] vars = key.Split(',');
                    float x = 0;
                    float y = 0;
                    x = float.Parse(vars[0]);
                    y = float.Parse(vars[1]);
                    //bmpGraphics.FillRectangle(brush, new RectangleF(new PointF(x, y), size));
                    bmpGraphics.FillEllipse(brush, new RectangleF(new PointF(x, y), size));

                    Pen p = new Pen(Color.Black, 2.0f);
                    bmpGraphics.DrawEllipse(p, new RectangleF(new PointF(x, y), size));

                    i++;
                }




            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        Exit:
            {
                //MessageBox.Show(errorMsg);
                return false;
            }
        }

        /// <summary>
        /// plotting monitors on Map
        /// </summary>
        /// <param name="dicMonitors">dictionary of monitors; key->x,y; value->concentration</param>
        /// <param name="bmpGraphics"></param>
        /// <returns>T or F</returns>
        private bool MarkSelectMonitor(PointF m, Graphics bmpGraphics)
        {            
            SolidBrush brush = new SolidBrush(Color.Blue);
            try
            {
                //Todo: determine whether the grid coordinate is in the lower left corner of the cell or the midpoint of the cell
                float d = 8 / _factor;
                SizeF size = new SizeF(d, d);
                int i = 0;
                //foreach (var key in dicMonitors.Keys)
                //{
                //    //Color cellColor = _colorBlendControl.GetValueColor(dicMonitors[key]);
                //    //brush = new SolidBrush(cellColor);

                //    string[] vars = key.Split(',');
                //    float x = 0;
                //    float y = 0;
                //    x = float.Parse(vars[0]);
                //    y = float.Parse(vars[1]);
                    //bmpGraphics.FillRectangle(brush, new RectangleF(new PointF(x, y), size));
                    //bmpGraphics.FillEllipse(brush, new RectangleF(new PointF(x, y), size));

                    Pen p = new Pen(Color.Red, 2.0f/_factor);
                    bmpGraphics.DrawEllipse(p, new RectangleF(m, size));
                    i++;
                //}
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        Exit:
            {
                //MessageBox.Show(errorMsg);
                return false;
            }
        }

        /// <summary>
        /// plotting SSIA Source on Map
        /// </summary>
        /// <param name="dicMonitors">dictionary of monitors; key->x,y; value->concentration</param>
        /// <param name="bmpGraphics"></param>
        /// <returns>T or F</returns>
        public bool drawSSIASource(PointF p, Graphics bmpGraphics)
        {

            //string errorMsg = "";
            //SolidBrush brush = new SolidBrush(Color.Blue);
            //if (dicMonitors.Keys.Count <= 0) { errorMsg = "No monitors!"; goto Exit; }
            try
            {
                double[] arrayPoint = new double[] { (double)p.X, (double)p.Y };
                DotSpatial.Projections.Reproject.ReprojectPoints(arrayPoint, null,
                    DotSpatial.Projections.KnownCoordinateSystems.Geographic.World.WGS1984,
                    projForMap, 0, 1);

                //point = new PointF((float)arrayPoint[0], (float)arrayPoint[1]);


                //Todo: determine whether the grid coordinate is in the lower left corner of the cell or the midpoint of the cell
                float d = 12 / _factor;
                SizeF size = new SizeF(d, d);
                //int i = 0;
                //foreach (var key in dicMonitors.Keys)
                //{
                //   Color cellColor = _colorBlendControl.GetValueColor(dicMonitors[key]);

                // brush = new SolidBrush(cellColor);

                //string[] vars = key.Split(',');
                //float x = 0;
                //float y = 0;
                //x = float.Parse(vars[0]);
                //y = float.Parse(vars[1]);
                //bmpGraphics.FillRectangle(brush, new RectangleF(new PointF(x, y), size));
                // bmpGraphics.FillEllipse(brush, new RectangleF(new PointF(x, y), size));

                bmpGraphics.DrawImage(Resources.sourceX,
                    (float)arrayPoint[0] - size.Width / 2,
                    (float)arrayPoint[1] - size.Height / 2,
                    size.Width, size.Height);

                //Pen p = new Pen(Color.Black, 2.0f);
                //bmpGraphics.DrawEllipse(p, new RectangleF(new PointF(x, y), size));

                //i++;
                //}




            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        Exit:
            {
                //MessageBox.Show(errorMsg);
                return false;
            }
        }

        public PlotControl()
        {
            InitializeComponent();
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);//Set double buffering to prevent image jitter, which must be set together with allpaintinginwmpaint.Setting it to true will automatically use double buffering, so there is no need to use BMP manually
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);//Ignore system messages to prevent images from flickering
            //this.SetStyle(ControlStyles.UserMouse, true);//Control mouse completion event

            _blend.Factors = new float[] { 0f, 0.5f, 1f };//{ 0.0f, 0.3f, 0.5f, 1.0f };
            _blend.Positions = new float[] { 0f, 0.5f, 1f };// { 0.0f, 0.2f, 0.6f, 1.0f };
        }


        /// <summary>
        ///The bitmap object used for buffering.When the control size or grid value does not change, the object is painted on the interface in onpaint, and more than 10000 grids are no longer redrawn
        /// </summary>
        Bitmap _bmp = null;
        /// <summary>
        ///Whether it is necessary to regenerate the bitmap object.When the grid value changes, the control size changes, or after zooming in, zooming out, and panning, it should be set to true, and after regenerating the bitmap, it should be set to false
        /// </summary>
        bool _needRedrawBmp = false;
        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);
            try
            {
                if (_needRedrawBmp)
                {

                    DrawImage();
                }

                if (_bmp != null)
                {
                    e.Graphics.DrawImage(_bmp, 0f, 0f);//The coordinate transformation is carried out in BMP.The coordinate system of the form has not changed, and the upper left corner is still the origin

                }

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Draw the graph on a bitmap and return This bitmap will be used when saving, but when the current form is called by onpaint method, the_ BMP, do not directly use the return value
        /// </summary>
        /// <returns></returns>
        private Bitmap DrawImage()
        {
            try
            {
                //Manual double buffering technology, first draw all the contents into memory (a bitmap)
                _bmp = new Bitmap(this.ClientSize.Width, this.ClientSize.Height);
                CalFactorAndMatrix();
                using (Graphics bmpGraphics = Graphics.FromImage(_bmp))
                {
                    //The coordinate transformation is carried out in BMP.The coordinate system of the form has not changed, and the upper left corner is still the origin
                    bmpGraphics.Transform = _matrix;
                   
                    //Draw grid
                    if (_useInterpolation)
                    {
                        DrawGridWithInterpolate();
                    }
                    else
                    {
                        DrawGrid(bmpGraphics);
                    }

                    //Draw the selected grid
                    DrawSelectedCells(bmpGraphics);

                    //Draw monitoring points
                    if (IsDrawMonitors)
                    {
                        drawMonitor(dicMonitors, bmpGraphics);
                        if (isMarkSelectedPoint)
                        { MarkSelectMonitor(SelectedPoint, bmpGraphics); }
                    }

                    //Draw pollution sources
                    if (IsDrawSSIASource)
                    {
                        drawSSIASource(pointSource, bmpGraphics);
                    }


                    //Draw a map
                    DrawShape(bmpGraphics);


                }
                #region draw the variables,by devin,2017-03-09
           
                Graphics g = Graphics.FromImage(_bmp);
                Font titleFont = new Font("Calibri", 14f, FontStyle.Bold);
                Color titleColor = Color.Black;
                string title = this.Mapname;
                float locationWidth = _bmp.Width / 2;
              
                if (title == "Δ(o3_used)")
                {
                    title = "deltaO3 = b_o3_used - f_o3_used";
                }
                SizeF string_size = g.MeasureString(title, titleFont);
                locationWidth = locationWidth - string_size.Width / 2;
                g.DrawString(title, titleFont, new SolidBrush(titleColor), new PointF(locationWidth, 5));
                g.Dispose();
                GC.Collect();
                #endregion draw the variables,by devin,2017-03-09
                //e.Graphics.DrawImage(_bmp, 0f, 0f);// The coordinate transformation is carried out in BMP.The coordinate system of the form has not changed, and the upper left corner is still the origin
                _needRedrawBmp = false;
                return _bmp;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }



        /// <summary>
        ///It is used to call and save savepictures into EMF file.There is a problem temporarily
        /// </summary>
        /// <param name="g"></param>
        public void DrawImageToGraphics(Graphics g)
        {
            try
            {
                CalFactorAndMatrix();
                //The coordinate transformation is carried out in BMP.The coordinate system of the form has not changed, and the upper left corner is still the origin
                g.Transform = _matrix;
                //Draw grid
                DrawGrid(g);
                //DrawGradientGrid(bmpGraphics);
                //Draw the selected grid
                DrawSelectedCells(g);

                //Draw a map
                DrawShape(g);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        protected new void Dispose()
        {
            if (_bmp != null) { _bmp.Dispose(); }
            base.Dispose();
        }

        /// <summary>
        ///The size of the real drawing model result graph
        /// </summary>
        private Size _drawSize = new Size(1, 1);

        /// <summary>
        ///Calculates the member variables used for coordinate conversion
        ///Call before each draw
        /// </summary>
        private void CalFactorAndMatrix()
        {
            try
            {
                _drawSize = this.ClientSize;
                //How many screen units is a map unit equivalent to, mainly small ones
                float factorX = (float)this.ClientSize.Width / (_modelDef.MaxX - _modelDef.MinX + _modelDef.CellWidth);
                float factorY = (float)this.ClientSize.Height / (_modelDef.MaxY - _modelDef.MinY + _modelDef.CellHeight);
                if (factorX < factorY)
                {
                    _factor = factorX;
                    //Width of actual model field to form coordinate system
                    _modelWidthOrHeightInForm = (_modelDef.MaxY - _modelDef.MinY + _modelDef.CellHeight) * factorX;
                    _axisChanged = "y";
                    _drawSize.Height = (int)_modelWidthOrHeightInForm;
                }
                else
                {
                    _factor = factorY;
                    //The height of the actual model field to the form coordinate system
                    _modelWidthOrHeightInForm = (_modelDef.MaxX - _modelDef.MinX + _modelDef.CellWidth) * factorY;
                    _axisChanged = "x";
                    _drawSize.Width = (int)_modelWidthOrHeightInForm;

                }
                //Console.WriteLine("factor={0}", factor);
                //Set the value of*-1 in the Y direction, which is equivalent to positive upward At the same time, put y value +this Height, which is equivalent to moving the origin of form coordinates down this Height units
                //float dx = -_ cmaqModeDef.MinX*_ factor + (this.ClientSize.Width - (_cmaqModeDef.MaxX - _cmaqModeDef.MinX+_modelDef.CellWidth)*_ factor)/2f;// It is estimated that the width of the form is greater than the width of the model field Less than is also correct
                //Consolidation of the above formula
                float dx = (this.ClientSize.Width - (_modelDef.MaxX + _modelDef.MinX + _modelDef.CellWidth) * _factor) / 2f;
                //float dy = this.ClientSize.Height + _ cmaqModeDef.MinY*_ factor- (this.ClientSize.Height - (_cmaqModeDef.MaxY - _cmaqModeDef.MinY+_modelDef.CellHeight)*_ factor)/2f;// It is estimated that the height of the form is greater than the width of the model field Less than is also correct
                //Consolidation of the above formula
                float dy = (this.ClientSize.Height + (_modelDef.MaxY + _modelDef.MinY + _modelDef.CellHeight) * _factor) / 2f;
                _matrix = new Matrix(_factor, 0f, 0f, -_factor, dx, dy);
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }



        /// <summary>
        ///Draw grid without interpolation
        /// </summary>
        ///<param name="bmp graphics">graphics for bitmap objects used for drawing</param>
        private void DrawGrid(Graphics bmpGraphics)
        {
            #region
            //SolidBrush brush = new SolidBrush(Color.Blue);
            //if (_gridValues.Length <= 0) { return; }
            //try
            //{
            ////todo: determine whether the grid coordinate is in the lower left corner of the cell or the midpoint of the cell
            //    SizeF size = new SizeF(_modelDef.CellWidth, _modelDef.CellHeight);
            //    for (int i = 0; i < _modelDef.LocationCount; i++)
            //    {
            //        Color cellColor = _gridColors[i];
            //        if (!_useContinuousColor)
            //        {
            //            cellColor = _colorBlendControl.GetValueRangeColor(_gridValues[i]);
            //        }
            //        brush = new SolidBrush(cellColor);// new SolidBrush(cellColor);
            //        bmpGraphics.FillRectangle(brush, new RectangleF(new PointF(_xCoords[i], _yCoords[i]), size));
            //        //Console.WriteLine("Row {0}", i);
            //    }
            //}
            #endregion
            SolidBrush brush = new SolidBrush(Color.Blue);
            if (_NewGridValues.Keys.Count <= 0) { return; }
            try
            {
                //Todo: determine whether the grid coordinate is in the lower left corner of the cell or the midpoint of the cell
                SizeF size = new SizeF(_modelDef.CellWidth, _modelDef.CellHeight);
                int i = 0;
                foreach (var key in _NewGridValues.Keys)
                {
                    Color cellColor = _gridColors[i];

                    if (!_useContinuousColor)
                    {
                        cellColor = _colorBlendControl.GetValueRangeColor(_NewGridValues[key]);
                    }
                    brush = new SolidBrush(cellColor);// new SolidBrush(cellColor);
                    #region String type
                    //Regex _regex = new Regex(",");
                    //string[] vars;
                    //vars = _regex.Split(key);
                    //bmpGraphics.FillRectangle(brush, new RectangleF(new PointF(float.Parse(vars[0]), float.Parse(vars[1])), size));
                    #endregion
                    string[] vars = key.Split(',');
                    float x = 0;
                    float y = 0;
                    if (vars.Count() == 3)//"d,lat,long"---ssia dispersion
                    {
                        x = float.Parse(vars[1]);
                        y = float.Parse(vars[2]);
                        bmpGraphics.FillRectangle(brush, new RectangleF(new PointF(x, y), new SizeF(100, 100)));
                        //bmpGraphics.FillEllipse(brush, new RectangleF(new PointF(x, y), new SizeF(200, 200)));
                    }
                    else
                    {
                        x = float.Parse(vars[0]);
                        y = float.Parse(vars[1]);
                        bmpGraphics.FillRectangle(brush, new RectangleF(new PointF(x, y), size));
                    }
                    i++;
                }

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            finally
            {
                brush.Dispose();
            }
        }

        #region Interpolation, v2.0
        /// <summary>
        ///Draw grid with interpolation
        /// </summary>
        ///<param name="bmp graphics">graphics for bitmap objects used for drawing</param>
        private void DrawGridWithInterpolate()
        {
            if (_gridValues.Length <= 0 || _bmp == null) { return; }
            try
            {
                int xOffset = (_bmp.Width - _drawSize.Width) / 2;
                int yOffset = (_bmp.Height - _drawSize.Height) / 2;
                double pixelsPerGridX = (double)_drawSize.Width / _modelDef.ColCount;
                double pixelsPerGridY = (double)_drawSize.Height / _modelDef.RowCount;
                int lastRow = -1, lastCol = -1;
                double cellValue = 0, v1 = 0, v2 = 0, v3 = 0, v4 = 0, val = 0;
                double v12 = 0, v13 = 0, v24 = 0, v34 = 0;
                double v10 = 0, v20 = 0, v30 = 0, v40 = 0;
                //int cnt = 0;
                for (int y = 0; y < _drawSize.Height; y++)
                {
                    double tmp = (_drawSize.Height - y) / pixelsPerGridY;
                    int row = (int)Math.Floor(tmp);
                    if (row == _modelDef.RowCount) { row = _modelDef.RowCount - 1; }
                    double gridYPercent = tmp - row;
                    bool isYGreaterHalf = false;
                    if (gridYPercent > 0.5)
                    {
                        isYGreaterHalf = true;
                        gridYPercent = (gridYPercent - 0.5) * 2;    //The value must be set here
                    }
                    else
                    {
                        gridYPercent = gridYPercent * 2;
                    }
                    for (int x = 0; x < _drawSize.Width; x++)
                    {
                        tmp = x / pixelsPerGridX;
                        int col = (int)Math.Floor(tmp);
                        if (col == _modelDef.ColCount) { col = _modelDef.ColCount - 1; }
                        double gridXPercent = tmp - col;
                        if (row != lastRow || col != lastCol)
                        {
                            //The grid index 1 of VPI is located in the second row and the first column from the lower left corner The grid index 1 of CMAQ is located in the first row and the second column from the lower left corner
                            CalcVertex(ref v1, ref v2, ref v3, ref v4, ref v12, ref v13, ref v24, ref v34, ref cellValue, row, col);
                            lastRow = row;
                            lastCol = col;
                        }

                        if (gridXPercent > 0.5)
                        {
                            gridXPercent = (gridXPercent - 0.5) * 2;
                            if (isYGreaterHalf)
                            {
                                v10 = v12;
                                v20 = v2;
                                v30 = cellValue;
                                v40 = v24;
                            }
                            else
                            {
                                v10 = cellValue;
                                v20 = v24;
                                v30 = v34;
                                v40 = v4;
                            }
                        }
                        else
                        {
                            gridXPercent = gridXPercent * 2;
                            if (isYGreaterHalf)
                            {
                                v10 = v1;
                                v20 = v12;
                                v30 = v13;
                                v40 = cellValue;
                            }
                            else
                            {
                                v10 = v13;
                                v20 = cellValue;
                                v30 = v3;
                                v40 = v34;
                            }
                        }
                        //v10 = v1; v20 = v2; v30 = v3; v40 = v4;
                        val = v30 + (v40 - v30) * gridXPercent + (v10 - v30) * gridYPercent + (v20 - v10 + v30 - v40) * gridXPercent * gridYPercent;
                        //val = v3 + (v4 - v3) * gridXPercent + (v1 - v3) * gridYPercent + (v2 - v1 + v3 - v4) * gridXPercent * gridYPercent;
                        Color color;
                        if (_useContinuousColor)
                        {
                            color = _colorBlendControl.GetValueColor(val);
                            //color = _colorBlendControl.GetValueColor2(val);
                        }
                        else
                        {
                            color = _colorBlendControl.GetValueRangeColor(val);
                        }
                        _bmp.SetPixel(x + xOffset, y + yOffset, color);
                    }
                }
                //Console.WriteLine("cnt={0}", cnt);
                /*Interpolation diagram
                 * 
                 *   v1----a----v2
                 *   |          |
                 *   |---x0---v |
                 *   a        | | 
                 *   |        y0|
                 *   v3-------|-v4
                 *   
                 *   v=v3+(v4-v3)*x0/a+(v1-v3)*y0/a+(v2-v1+v3-v4)*x0*y0/a/a
                 *Of which:
                 *V1, V2, V3, V4 are the values of the four vertices of the mesh Each value is obtained by averaging the four mesh values around the vertex
                 *A is the grid width
                 *X0 is the distance from the point of the required value to the left border of the grid
                 *   x0/a=gridXPercent
                 */

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Calculate the surrounding vertices and midpoint values of all meshes
        /// </summary>
        ///<param name="cellvalue">save the obtained current grid value</param>
        ///<param name="v12">v1, the median value of V2</param>
        ///<param name="row">current grid row, used to calculate cellvalue</param>
        ///<param name="col">current grid column, used to calculate cellvalue</param>
        private void CalcVertex(ref double v1, ref double v2, ref double v3, ref double v4
            , ref double v12, ref double v13, ref double v24, ref double v34, ref double cellValue, int row, int col)
        {
            try
            {
                //Determine the surrounding ranks
                int row1 = row - 1;
                if (row1 < 0) { row1 = 0; }
                int row2 = row + 1;
                if (row2 >= _modelDef.RowCount) { row2 = _modelDef.RowCount - 1; }
                int col1 = col - 1;
                if (col1 < 0) { col1 = 0; }
                int col2 = col + 1;
                if (col2 >= _modelDef.ColCount) { col2 = _modelDef.ColCount - 1; }
                //Calculate the current grid and surrounding grid planting
                double c0 = _gridValues[GetLocationBaseRow0(row, col)];
                double c1 = _gridValues[GetLocationBaseRow0(row2, col1)];
                double c2 = _gridValues[GetLocationBaseRow0(row2, col)];
                double c3 = _gridValues[GetLocationBaseRow0(row2, col2)];
                double c4 = _gridValues[GetLocationBaseRow0(row, col1)];
                double c5 = _gridValues[GetLocationBaseRow0(row, col2)];
                double c6 = _gridValues[GetLocationBaseRow0(row1, col1)];
                double c7 = _gridValues[GetLocationBaseRow0(row1, col)];
                double c8 = _gridValues[GetLocationBaseRow0(row1, col2)];
                //Calculate the current grid and surrounding grid planting
                //C0: the value of the grid where row and col are located
                //C1-C8, 8 grid values around the current grid, arranged in the following order
                //  c1 c2 c3
                //  c4 c0 c5
                //  c6 c7 c8
                v1 = (c1 + c2 + c4 + c0) / 4;
                v2 = (c2 + c3 + c0 + c5) / 4;
                v3 = (c4 + c0 + c6 + c7) / 4;
                v4 = (c0 + c5 + c7 + c8) / 4;
                v12 = (c2 + c0) / 2;
                v13 = (c4 + c0) / 2;
                v24 = (c0 + c5) / 2;
                v34 = (c0 + c7) / 2;
                cellValue = c0;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        #endregion


        /// <summary>
        ///Draw the selected mesh
        /// </summary>
        ///<param name="bmp graphics">graphics object for drawing</param>
        private void DrawSelectedCells(Graphics bmpGraphics)
        {
            if (_selectedCells == null) { return; }
            if (_gridValues.Length <= 0) { return; }
            try
            {
                //Todo: determine whether the grid coordinate is in the lower left corner of the cell or the midpoint of the cell
                //SizeF size = new SizeF(_modelDef.CellWidth, _modelDef.CellHeight);
                //bmpGraphics.Transform = _matrix;
                using (Pen pen = new Pen(Color.Gray))
                {
                    pen.DashStyle = DashStyle.Solid;
                    foreach (GridCell cell in _selectedCells)
                    {
                        int idx = GetLocation(cell.Row, cell.Col);
                        //this.Invalidate();// Doing so will eliminate the box drawn below
                        bmpGraphics.DrawRectangle(pen, _xCoords[idx], _yCoords[idx], _modelDef.CellWidth, _modelDef.CellHeight);
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }


        /// <summary>
        ///Draw shape
        /// </summary>
        ///<param name="bmp graphics">graphics for bitmap objects used for drawing</param>
        private void DrawShape(Graphics g)
        {
            try
            {
                if (_segmentsList == null || _segmentsList.Count == 0) { return; }
                //g.Transform = _matrix;
                using (Pen pen = new Pen(_shapeLineColor, 1f / _factor))
                {
                    foreach (List<PointF> pts in _segmentsList)
                    {
                        PointF[] points = new PointF[pts.Count];
                        pts.CopyTo(points);
                        g.DrawLines(pen, points);//Stiff
                        //g.DrawPolygon(pen, points);// One more line from the end to the starting point
                        //g.DrawBeziers(pen, points);// Invalid parameter
                        //g.DrawCurve(pen, points);// Best effect
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void RSMPlotControl_SizeChanged(object sender, EventArgs e)
        {

            //Refresh the entire control every time you change the size
            _needRedrawBmp = true;
            this.Invalidate();
        }

        /// <summary>
        ///Convert the incoming screen coordinate points (usually obtained directly from the mouseClick event) into gridcell objects of the model
        /// </summary>
        ///<param name="pt">screen coordinate point (usually obtained directly from mouseClick event)</param>
        ///<returns>gridcell object of the corresponding model If the conversion fails, gridcell Row=-1</returns>
        public string TransformToGridCell(Point pt)
        {
            try
            {
                //Transform screen coordinates into model coordinates
                Matrix matrix = _matrix.Clone();
                matrix.Invert();
                PointF[] pts = new PointF[] { pt };
                matrix.TransformPoints(pts);
                //Console.WriteLine("X={0},\tY={1}", pts[0].X, pts[0].Y);
                int cellwidth = CommonClass.modelDefinition.ActiveGridType == "12km" ? cellwidth = 12100 / 2 : cellwidth = 36000 / 2;
                int cellheight = cellwidth;
                if (CommonClass.modelDefinition.CellWidthHeight != null && CommonClass.modelDefinition.CellWidthHeight[0] > 0 && CommonClass.modelDefinition.CellWidthHeight[1] > 0)
                {
                    cellwidth = (int)CommonClass.modelDefinition.CellWidthHeight[0];
                    cellheight = (int)CommonClass.modelDefinition.CellWidthHeight[1];
                }

                foreach (var key in _NewGridValues.Keys)
                {
                    string skey = key;
                    Regex _regex = new Regex(",");
                    string[] vars;
                    if (skey.Contains("d"))
                        skey = skey.Substring(2);
                    vars = _regex.Split(skey);
                    float x = 0;
                    float y = 0;
                    x = float.Parse(vars[0]);
                    y = float.Parse(vars[1]);
                    if (Math.Abs(x - pts[0].X) <= cellwidth & Math.Abs(y - pts[0].Y) <= cellheight)
                    {
                        //cell.Value = _NewGridValues[key];
                        #region MyRegion
                        //var keys = CommonClass.modelDefinition.ColRowgridValues.FirstOrDefault(q => q.Value ==cell.Value).Key;
                        //Regex _regex = new Regex(",");
                        //string[] vars;
                        //vars = _regex.Split(keys);
                        //cell.Row = int.Parse(vars[0]);
                        //cell.Col = int.Parse(vars[1]);
                        #endregion
                        return skey;
                    }
                }
                #region Note by devin

                ////Get the grid row corresponding to the point, and the row counts from 1
                //int row = (int)Math.Truncate((pts[0].Y - _modelDef.MinY) / _modelDef.CellHeight) + 1;
                //if (row < 1 || row > _modelDef.RowCount) { return cell; }
                ////Get the grid column corresponding to the point
                //int col = (int)Math.Truncate((pts[0].X - _modelDef.MinX) / _modelDef.CellWidth) + 1;
                //if (col < 1 || col > _modelDef.ColCount) { return cell; }
                //cell.Row = row;
                //cell.Col = col;
                ////Get the value of the grid
                //cell.Value = _gridValues[GetLocation(row, col)];

                #endregion
                //AddCell2SelectedList(cell, true);
                return "";
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return "";
            }
        }
        #region Add grid to selected list unchanged
        /// <summary>
        ///Add grid to selected list
        /// </summary>
        ///<param name="cell">grid to be added to the selection list</param>
        ///<param name="clearothers">whether to clear the selected list first</param>
        //public void AddCell2SelectedList(GridCell cell, bool clearOthers)
        //{
        //    Graphics g = this.CreateGraphics();
        //    g.Transform = _matrix;
        //    //SolidBrush brush = new SolidBrush(Color.Red);
        //    Pen pen = new Pen(Color.Red);
        //    int location;
        //    pen.DashStyle = DashStyle.Solid;

        //    try
        //    {
        //        if (_selectedCells == null)
        //        {
        //            _selectedCells = new List<GridCell>();
        //        }
        //        else
        //        {
        ////restore all meshes to the original state
        //            SizeF size = new SizeF(_modelDef.CellWidth, _modelDef.CellHeight);
        //            foreach (GridCell cell1 in _selectedCells)
        //            {
        //                location = GetLocation(cell1.Row, cell1.Col);
        //                //brush = new SolidBrush(_gridColors[location]);
        //                //g.FillRectangle(brush, new RectangleF(new PointF(_xCoords[location], _yCoords[location]), size));
        //                Color clr = _gridColors[location];
        //                if (clr == Color.Transparent) { clr = this.BackColor; }
        //                pen = new Pen(clr);

        //                g.DrawRectangle(pen, _xCoords[location], _yCoords[location], _modelDef.CellWidth, _modelDef.CellHeight);
        //            }
        //            DrawShape(g);
        //        }
        //        if (clearOthers)
        //        {
        //            _selectedCells.Clear();
        //        }
        //        _selectedCells.Add(cell);
        ////draw the selected grid border

        //        pen = new Pen(Color.Gray);
        //        foreach (GridCell cell2 in _selectedCells)
        //        {
        //            location = GetLocation(cell2.Row, cell2.Col);
        //          //this.Invalidate();// Doing so will eliminate the box drawn below


        //            g.DrawRectangle(pen, _xCoords[location], _yCoords[location], _modelDef.CellWidth, _modelDef.CellHeight);
        //        }

        //       _ needRedrawBmp = true;// Ensure buffer BMP is regenerated
        //        //this.Invalidate();
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //    }
        //    finally
        //    {
        //        g.Dispose();
        //        //brush.Dispose();
        //        pen.Dispose();
        //    }
        //}
        #endregion
        /// <summary>
        ///Add grid to selected list
        /// </summary>
        ///<param name="cell">grid to be added to the selection list</param>
        ///<param name="clearothers">whether to clear the selected list first</param>
        public void AddCell2SelectedList(GridCell cell, bool clearOthers)
        {
            Graphics g = this.CreateGraphics();
            g.Transform = _matrix;
            //SolidBrush brush = new SolidBrush(Color.Red);
            Pen pen = new Pen(Color.Red);
            int location;
            pen.DashStyle = DashStyle.Solid;
            var keys = _NewGridValues.FirstOrDefault(q => q.Value == cell.Value).Key;
            try
            {
                if (_selectedCells == null)
                {
                    _selectedCells = new List<GridCell>();
                }
                else
                {
                    //Restore all meshes to their original state
                    SizeF size = new SizeF(_modelDef.CellWidth, _modelDef.CellHeight);
                    foreach (GridCell cell1 in _selectedCells)
                    {
                        //location = GetLocation(cell1.Row, cell1.Col);
                        //brush = new SolidBrush(_gridColors[location]);
                        //g.FillRectangle(brush, new RectangleF(new PointF(_xCoords[location], _yCoords[location]), size));
                        Color clr = _gridColors[0];
                        if (clr == Color.Transparent) { clr = this.BackColor; }
                        pen = new Pen(clr);
                        Regex _regex = new Regex(",");
                        string[] vars;
                        vars = _regex.Split(keys);
                        float x = 0;
                        float y = 0;
                        x = float.Parse(vars[0]);
                        y = float.Parse(vars[1]);
                        g.DrawRectangle(pen, x, y, _modelDef.CellWidth, _modelDef.CellHeight);
                        //g.DrawRectangle(pen, _xCoords[location], _yCoords[location], _modelDef.CellWidth, _modelDef.CellHeight);
                    }
                    DrawShape(g);
                }
                if (clearOthers)
                {
                    _selectedCells.Clear();
                }
                _selectedCells.Add(cell);
                //Draw the selected grid border

                pen = new Pen(Color.Gray);
                foreach (GridCell cell2 in _selectedCells)
                {
                    location = GetLocation(cell2.Row, cell2.Col);
                    //this.Invalidate();// Doing so will eliminate the box drawn below
                    Regex _regex = new Regex(",");
                    string[] vars;
                    vars = _regex.Split(keys);
                    float x = 0;
                    float y = 0;
                    x = float.Parse(vars[0]);
                    y = float.Parse(vars[1]);
                    g.DrawRectangle(pen, x, y, _modelDef.CellWidth, _modelDef.CellHeight);
                    //g.DrawRectangle(pen, _xCoords[location], _yCoords[location], _modelDef.CellWidth, _modelDef.CellHeight);
                }

                _needRedrawBmp = true;//Ensure buffer BMP is regenerated
                //this.Invalidate();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            finally
            {
                g.Dispose();
                //brush.Dispose();
                pen.Dispose();
            }
        }

        /// <summary>
        ///Calculate the location index based on rows (starting from 1) and columns (starting from 1)
        ///The grid index 1 of VPI is located in the second row and the first column from the lower left corner The grid index 1 of CMAQ is located in the first row and the second column from the lower left corner
        /// </summary>
        ///<param name="row">line (starting from 1)</param>
        ///<param name="col">column (starting from 1)</param>
        ///<returns>location index</returns>
        private int GetLocation(int row, int col)
        {
            return _modelDef.RowCount * (col - 1) + row - 1;
        }

        /// <summary>
        ///Calculate the location index based on rows (starting from 0) and columns (starting from 0)
        ///The grid index 1 of VPI is located in the second row and the first column from the lower left corner The grid index 1 of CMAQ is located in the first row and the second column from the lower left corner
        /// </summary>
        ///<param name="row">line (starting from 0)</param>
        ///<param name="col">column (starting from 0)</param>
        ///<returns>location index</returns>
        private int GetLocationBaseRow0(int row, int col)
        {
            return _modelDef.RowCount * (col) + row;
        }

        /// <summary>
        ///Get the value of grid according to row and column If the row or column is out of range, double is returned NaN
        /// </summary>
        ///<param name="row">row, index from 1</param>
        ///<param name="col">column, index from 1</param>
        /// <returns></returns>
        public double GetCellValue(int row, int col)
        {
            if (row < 1 || row > _modelDef.RowCount || col < 1 || col > _modelDef.ColCount) { return double.NaN; }
            return _gridValues[GetLocation(row, col)];
        }

        //Right click context menu
        private void saveAsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                //SavePicture save = new SavePicture(this.ColorBlendControl);
                //save.SaveAs();
                SaveRsmAndBlend(false); //false represents for saving without blend. added and modified by Edwin 20131219
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Right click the context menu to save the data as benmapfile
        private void saveDataAsBenMAPFileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string msg = "";
            try
            {
                msg = SaveDataToFile();
                if (msg != "")
                {
                    return;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
            finally
            {
                if (msg != "")
                {
                    MessageBox.Show(msg, "Tip", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                }
            }
        }

        //Save the data to a file, and return a null value to indicate that the save is successful, otherwise the save fails
        private string SaveDataToFile()
        {

            string strPath = "";
            string msg = "";
            try
            {
                SaveFileDialog SFD = new SaveFileDialog();
                SFD.DefaultExt = "CSV";
                SFD.Filter = "CSV File(*.csv)|*.csv";

                if (SFD.ShowDialog() == DialogResult.OK)
                {
                    strPath = SFD.FileName;

                    //Save benmapfile
                    msg = SaveToBenMAPFile(strPath);
                }
                return msg;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return msg + ex.Message;
            }

        }

        /// <summary>
        ///Save data as benmapfile
        /// </summary>
        ///<param name="strpath">file name of this file</param>
        ///<returns>return a null value: save successfully, otherwise save fails</returns>
        private string SaveToBenMAPFile(string strPath)
        {
            string msg = "";
            StreamWriter Writer = new StreamWriter(strPath, false, Encoding.Default);
            double tmp = 0.0d;
            try
            {
                //Lines should be written on the first line of each benmap file
                string lines = "Row,Column,Metric,Seasonal Metric,Statistic,Values";
                //Define the length of the array
                int count = _modelDef.RowCount * _modelDef.ColCount + 1;
                string[] DataLines = new string[count];
                DataLines[0] = lines;
                // Console.WriteLine(count);
                //The elements of the array start from 1 to the end
                count = 1;
                //Assign the values of each grid to the array, and each grid is used as a tuple.
                for (int j = 1; j < (_modelDef.RowCount + 1); j++)
                {
                    for (int k = 1; k < (_modelDef.ColCount + 1); k++)
                    {
                        tmp = _gridValues[GetLocation(j, k)];
                        tmp = Math.Round(tmp, 5);
                        DataLines[count] = string.Format("{0},{1},D24HourMean,QuarterlyMean,Mean,{2}", j, k, tmp);
                        //Console.WriteLine(DataLines[count]);
                        count++;
                    }
                }

                //Coordinates of xcoords X; Coordinates of ycoords;
                //Write array to file
                foreach (string line in DataLines)
                {
                    //File.AppendAllText(strFilePath, line+"\r\n", Encoding.Default);
                    Writer.Write(line + "\n", Encoding.Default);
                }

                Writer.Flush();//Write buffer data to stream
                //Write successful
                msg = "Save to BenMAP file succeeded!";
                return msg;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return msg + ex.Message;
            }
            finally
            {
                Writer.Close();
            }
        }// msg = "Fale to save data to BenMAP file !";

        private void saveDataAsCMAQToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //string msg = "";
            try
            {
                SaveCMAQToFile();
            }
            catch (Exception ex)
            {

                CommonClass.LogError(ex);
            }

        }

        private void SaveCMAQToFile()
        {
            string msg = "";
            bool ok = false;
            string strPath = "";
            try
            {
                SaveFileDialog sfd = new SaveFileDialog();
                sfd.DefaultExt = "";
                sfd.Filter = "CMAQ Data File|";
                if (sfd.ShowDialog() == DialogResult.OK && sfd.FileName != "")
                {
                    strPath = sfd.FileName;
                    //Save benmapfile
                    //ok = SaveCMAQDataToFile(strPath);
                    if (!ok)
                    {
                        msg = string.Format("Fail to save " + strPath + " as CMAQ File!");
                        return;
                    }
                    msg = "The CMAQ Data file has been saved successfully !";
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                msg = "An exception has happened when save file as CMAQ data file!";
            }
            finally
            {
                if (msg != "")
                {
                    MessageBox.Show(msg, "Tip", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                }
            }
        }

        //private bool SaveCMAQDataToFile(string strPath)
        //{
        //    //string msg = "";
        //    bool ok = false;
        //    double[] gridValues = new double[_gridValues.Length];
        //    int count = 0;
        //    try
        //    {
        //        // get _gridValues for row->col
        //        for (int i = 1; i < _modelDef.RowCount + 1; i++)
        //        {
        //            for (int j = 1; j < _modelDef.ColCount + 1; j++)
        //            {
        //                gridValues[count] = _gridValues[GetLocation(i, j)];
        //                #region Console.Write
        //                //if (count <= _gridValues.Length)
        //                //{
        //                //    if (count % 7 == 0)
        //                //    {
        //                //        Console.Write("\n" + gridValues[count] + ",");
        //                //    }
        //                //    else
        //                //    {
        //                //        if (count % 147 == 0) { Console.Write(gridValues[count] + "\n"); }
        //                //        else
        //                //        { Console.Write(gridValues[count] + ","); }
        //                //    }
        //                //} 
        //                #endregion
        //                count++;
        //            }
        //        }

        //        // CommonClass.saveCMAQDataFile.CreateDataFile(strPath);
        //        NetCDFDataParer saveNetCDFData = new NetCDFDataParer();

        //        string pollutant = CommonClass.rsmPolicy.modelDef.Pollutant;
        //        string valueUnit = CommonClass.rsmPolicy.modelDef.ValueUnit;

        //        //-----------------modied by longsc 20120812------
        //        List<string[]> GlobalAttributeslst = new List<string[]>();
        //        GlobalAttributeslst = CommonClass.rsmPolicy.modelDef.GlobalAttributeslst;
        //        ok = saveNetCDFData.CreateDataFile(strPath, _modelDef.RowCount, _modelDef.ColCount, pollutant, valueUnit,GlobalAttributeslst, gridValues);
        //        return ok;
        //    }
        //    catch (Exception ex)
        //    {
        //        CommonClass.LogError(ex);
        //        return false;
        //    }
        //}

        private void tsmnuSaveRsmAndBlend_Click(object sender, EventArgs e)
        {
            try
            {
                SaveRsmAndBlend(true); //true represents for saving with blend  added and modified by Edwin
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Save the map image in the clipboard and paste it at will
        ///Save as PNG by default
        /// </summary>
        /// <remarks>
        /// add by ty 2016-07-09
        /// </remarks>
        private void saveImageLegendToClipboardToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                Bitmap img = GetFixedPlot(true);
                if (img != null)
                {
                    Clipboard.Clear();
                    Clipboard.SetImage(img);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }


        /// <summary>
        ///Save map
        /// </summary>
        ///<param name="containsblend">true</param>
        public void SaveRsmAndBlend(bool ContainsBlend)
        {
            try
            {
                SaveFileDialog saveFileDialog = new SaveFileDialog();
                saveFileDialog.Filter =
                    //"Emf Format (*.emf)|*.emf|" +
                "Gif Format (*.gif)|*.gif|" +
                "Jpeg Format (*.jpg)|*.jpg|" +
                "PNG Format (*.png)|*.png|" +
                "Tiff Format (*.tif)|*.tif|" +
                "Bmp Format (*.bmp)|*.bmp";
                saveFileDialog.InitialDirectory = CommonClass.ResultFilePath + @"\Result\Picture";
                String DefaultFileName = null;
                if (DefaultFileName != null && DefaultFileName.Length > 0)
                {
                    //Get extension
                    String ext = System.IO.Path.GetExtension(DefaultFileName).ToLower();
                    switch (ext)
                    {
                        //case ".emf": _saveFileDialog.FilterIndex = 1; break;
                        case ".png": saveFileDialog.FilterIndex = 2; break;
                        case ".gif": saveFileDialog.FilterIndex = 3; break;
                        case ".jpeg": saveFileDialog.FilterIndex = 1; break;
                        case ".jpg": saveFileDialog.FilterIndex = 1; break;
                        case ".tiff": saveFileDialog.FilterIndex = 4; break;
                        case ".tif": saveFileDialog.FilterIndex = 4; break;
                        case ".bmp": saveFileDialog.FilterIndex = 5; break;
                    }
                    //If we were passed a file name, not just an extension, use it
                    if (DefaultFileName.Length > ext.Length)
                    {
                        saveFileDialog.FileName = DefaultFileName;
                    }
                }
                if (saveFileDialog.ShowDialog() == DialogResult.OK)
                {
                    Stream myStream = saveFileDialog.OpenFile();
                    ////20090902 @ chenzhirun
                    //MemoryStream myStream = _saveFileDialog.OpenFile();
                    if (myStream != null)
                    {
                        ImageFormat format = ImageFormat.Png;
                        switch (saveFileDialog.FilterIndex)
                        {
                            case 1: format = ImageFormat.Gif; break;
                            case 2: format = ImageFormat.Png; break;
                            case 3: format = ImageFormat.Jpeg; break;
                            case 4: format = ImageFormat.Tiff; break;
                            case 5: format = ImageFormat.Bmp; break;
                        }
                        //Bitmap bmpBlend = _colorBlendControl.DrawImage();

                        Image bmpRsm = GetFixedPlot(ContainsBlend);
                        //Image srcImage = new Bitmap(bmpBlend, 100, 20);
                        //Graphics gSrc = _ colorBlendControl.CreateGraphics();// You must use this method, using graphics FromImage(bmpBlend); Invalid, reason unknown
                        Image destImage = bmpRsm;// new Bitmap(this.ClientRectangle.Width, this.ClientRectangle.Height);// new Bitmap(this.ClientRectangle.Width, this.ClientRectangle.Height, gSrc);
                        Graphics gDest = Graphics.FromImage(bmpRsm);// this.CreateGraphics();
                        //gDest.FillRectangle(Brushes.White, 0, bmpRsm.Height - bmpBlend.Height, bmpRsm.Width, bmpRsm.Height);//add White Rectangle under the Map added by Edwin
                        //IntPtr srcDC = gSrc.GetHdc();
                        //IntPtr destDC = gDest.GetHdc();
                        //WinBmpAPI.BitBlt(destDC, (bmpRsm.Width - bmpBlend.Width) / 2, bmpRsm.Height - bmpBlend.Height, bmpBlend.Width, bmpBlend.Height, srcDC, 0, 0, 0xCC0020); //13369376);//modified by Edwin
                        //gSrc.ReleaseHdc(srcDC);
                        //gDest.ReleaseHdc(destDC);
                        //gSrc.Dispose();
                        gDest.Dispose();
                        destImage.Save(myStream, format);
                        myStream.Close();
                    }
                    MessageBox.Show(LanguageOld.Translate("Save map image successfully!"));
                }
                //WinAPIuse.BitBlt();
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        /// <summary>
        ///Draw the graph on a bitmap and return This bitmap will be used when saving
        /// </summary>
        ///<returns>return picture</returns>
        public Bitmap GetFixedPlot(bool ContainBlend)
        {
            try
            {
                Bitmap bmpRsm = this.DrawImage();
                int width = this.ClientSize.Width;
                int height = this.ClientSize.Height;
                int originX = 0;
                int originY = 0;
                Bitmap destImage = null;
                if (_axisChanged.ToLower() == "x")
                {
                    width = (int)_modelWidthOrHeightInForm;
                    originX = (this.ClientSize.Width - width) / 2;
                }
                else
                {
                    height = (int)_modelWidthOrHeightInForm;
                    originY = (this.ClientSize.Height - height) / 2;
                }

                if (ContainBlend)
                {
                    int upperHeight = 0;
                    int[] filenameWidthHeight = new int[2];
                    int filenameparts = 1;
                    int[] pollutantNameWidthHeight = new int[2];
                    int leftWidth = 0;//the width of color blend, including the space
                    int valueHeight = 0;//the height of number
                    int[] colorsquareWidthHeight = new int[3];
                    colorsquareWidthHeight[0] = 10;//width
                    colorsquareWidthHeight[1] = 40;//height
                    colorsquareWidthHeight[2] = 5;//the left space
                    Font[] font = new Font[5];
                    font[0] = new Font("Calibri", 20, FontStyle.Bold);//pollutant name
                    font[1] = new Font("Calibri", 12, FontStyle.Bold);//file name
                    font[2] = new Font("Calibri", 10, FontStyle.Bold);//color value
                    font[3] = new Font("Calibri", 10, FontStyle.Bold);//col row
                    font[4] = new Font("Calibri", 12, FontStyle.Bold);//min max value
                    int[] colrowWidthHeight = new int[2];
                    string[] strMapInfo = (this.ParentForm as SMAT_CE).strMapNameColRow;
                    string minmaxValue = "";
                    if (!string.IsNullOrEmpty(CommonClass.modelDefinition.MinmaxValueGrid))
                    {
                        string[] minmaxGridValue = CommonClass.modelDefinition.MinmaxValueGrid.Split(',');
                        if (minmaxGridValue.Count() == 6)
                            minmaxValue = "Min = " + Convert.ToDouble(minmaxGridValue[2]).ToString("F3") + " at (" + Math.Round(Convert.ToDouble(minmaxGridValue[0]), 2) + "," + Math.Round(Convert.ToDouble(minmaxGridValue[1]), 2) + "), Max = " + Convert.ToDouble(minmaxGridValue[5]).ToString("F3") + " at (" + Math.Round(Convert.ToDouble(minmaxGridValue[3]), 2) + "," + Math.Round(Convert.ToDouble(minmaxGridValue[4]), 2) + ")";
                        else
                            minmaxValue = "Min = " + Convert.ToDouble(minmaxGridValue[1]).ToString("F3") + " at (" + Convert.ToInt32(minmaxGridValue[0]) / 1000 + "," + Convert.ToInt32(minmaxGridValue[0]) % 1000 + "), Max = " + Convert.ToDouble(minmaxGridValue[3]).ToString("F3") + " at (" + Convert.ToInt32(minmaxGridValue[2]) / 1000 + "," + Convert.ToInt32(minmaxGridValue[2]) % 1000 + ")";
                    }
                    int[] minmaxValueWidthHeight = new int[2];
                    string[] colorValue = new string[7];
                    //for (int i = 0; i < 5; i++)
                    //{
                    //    if ((0.00001 < _colorBlendControl.ValueArray[i]) && (_colorBlendControl.ValueArray[i] < 100000))
                    //    { colorValue[i] = string.Format("{0}", Math.Round(_colorBlendControl.ValueArray[i], 3)); }
                    //    else
                    //    { colorValue[i] = string.Format("{0}", Math.Round(_colorBlendControl.ValueArray[i], 3).ToString("G3")); }
                    //}
                    //if ((0.00001 < _colorBlendControl.MaxValue) && (_colorBlendControl.MaxValue < 100000))
                    //{ colorValue[5] = string.Format("{0}", Math.Round(_colorBlendControl.MaxValue, 3)); }
                    //else
                    //{ colorValue[5] = string.Format("{0}", Math.Round(_colorBlendControl.MaxValue, 3).ToString("G3")); }
                    int d = (_colorBlendControl.MaxValue - _colorBlendControl.MinValue) > 1 ? 1 : 3;
                    for (int i = 0; i < 7; i++)
                    {
                        colorValue[i] = Math.Round(_colorBlendControl.ValueArray[i], d).ToString(string.Format("F{0}", d));
                    }
                    //colorValue[6] = Math.Round(_colorBlendControl.MaxValue, d).ToString(string.Format("F{0}", d));

                    using (Graphics g0 = this.CreateGraphics())
                    {
                        SizeF string_size = g0.MeasureString(strMapInfo[0], font[1]);
                        filenameWidthHeight[0] = (int)string_size.Width;
                        filenameWidthHeight[1] = (int)string_size.Height;
                        if (filenameWidthHeight[0] <= width + 10)
                            upperHeight = filenameWidthHeight[1] + 2;
                        else
                        {
                            do
                            {
                                filenameparts++;
                            } while (filenameWidthHeight[0] > filenameparts * width);
                            upperHeight = filenameparts * filenameWidthHeight[1] + 2;
                        }

                        string_size = g0.MeasureString(strMapInfo[1], font[0]);
                        pollutantNameWidthHeight[0] = (int)string_size.Width;
                        pollutantNameWidthHeight[1] = (int)string_size.Height;
                        upperHeight = upperHeight + pollutantNameWidthHeight[1] + 20;

                        string_size = g0.MeasureString(colorValue[5], font[2]);
                        leftWidth = (int)string_size.Width;
                        valueHeight = (int)string_size.Height;
                        for (int i = 0; i < 5; i++)
                        {
                            string_size = g0.MeasureString(colorValue[i], font[3]);
                            leftWidth = Math.Max((int)string_size.Width, leftWidth);
                        }

                        string_size = g0.MeasureString("999", font[3]);
                        colrowWidthHeight[0] = (int)string_size.Width;
                        colrowWidthHeight[1] = (int)string_size.Height;
                        leftWidth = leftWidth + colorsquareWidthHeight[0] + colorsquareWidthHeight[2] + colrowWidthHeight[0] + 6;//add the space of Row
                        upperHeight = upperHeight + colrowWidthHeight[1] / 2;//add the space of Col

                        string_size = g0.MeasureString(minmaxValue, font[4]);
                        minmaxValueWidthHeight[0] = (int)string_size.Width;
                        minmaxValueWidthHeight[1] = (int)string_size.Height;
                    }

                    destImage = new Bitmap(width + leftWidth + colrowWidthHeight[0] / 2 + 5, height + upperHeight + colrowWidthHeight[1] + minmaxValueWidthHeight[1] + 17);
                    Graphics g = Graphics.FromImage(destImage);
                    g.Clear(Color.White);

                    //draw pollutant name
                    g.DrawString(strMapInfo[1], font[0], new SolidBrush(Color.Black), new PointF(leftWidth + 2 + (width - pollutantNameWidthHeight[0]) / 2, 10));

                    //draw file name
                    //if file name is too long
                    if (filenameWidthHeight[0] < width + 10)
                    {
                        g.DrawString(strMapInfo[0], font[1], new SolidBrush(Color.Black), new PointF(leftWidth + 2 + (width - filenameWidthHeight[0]) / 2, 20 + pollutantNameWidthHeight[1]));
                    }
                    else
                    {
                        int iCountIn1Row = strMapInfo[0].Length / filenameparts;
                        int y = 20 + pollutantNameWidthHeight[1];
                        List<string> lstStr = GetStringRows(g, font[1], strMapInfo[0], width);
                        for (int i = 0; i < filenameparts; i++)
                        {
                            g.DrawString(lstStr[i], font[1], new SolidBrush(Color.Black), new PointF(leftWidth, y));
                            y += filenameWidthHeight[1];
                        }
                    }

                    //draw color blend
                    int location = upperHeight;
                    for (int i = 6; i >= 0; i--)
                    {
                        g.FillRectangle(new SolidBrush(_colorBlendControl.ColorArray[i]), colorsquareWidthHeight[2], location, colorsquareWidthHeight[0], colorsquareWidthHeight[1]);
                        location += colorsquareWidthHeight[1];
                    }
                    g.DrawRectangle(new Pen(Color.Black, 1), colorsquareWidthHeight[2], upperHeight, colorsquareWidthHeight[0], colorsquareWidthHeight[1] * 7);//add the border of color blend
                    g.DrawString(_colorBlendControl.ValueUnit, font[2], new SolidBrush(Color.Black), new PointF(colorsquareWidthHeight[2], location + colrowWidthHeight[1] / 2 + 2));

                    //draw color range value
                    location -= valueHeight / 2;
                    //for (int i = 0; i < 6; i++)
                    //{
                    //    g.DrawString(colorValue[i], font[2], new SolidBrush(Color.Black), new PointF(colorsquareWidthHeight[0] + colorsquareWidthHeight[2] + 3, location));
                    //    location -= colorsquareWidthHeight[1];
                    //}
                    //Do not draw min max
                    location -= colorsquareWidthHeight[1];
                    g.DrawString("<" + colorValue[1], font[2], new SolidBrush(Color.Black), new PointF(colorsquareWidthHeight[0] + colorsquareWidthHeight[2] + 3, location));
                    for (int i = 2; i < 6; i++)
                    {
                        location -= colorsquareWidthHeight[1];
                        g.DrawString(colorValue[i], font[2], new SolidBrush(Color.Black), new PointF(colorsquareWidthHeight[0] + colorsquareWidthHeight[2] + 3, location));
                    }
                    location -= colorsquareWidthHeight[1];
                    g.DrawString(">" + colorValue[6], font[2], new SolidBrush(Color.Black), new PointF(colorsquareWidthHeight[0] + colorsquareWidthHeight[2] + 3, location));

                    //g.DrawString(_colorBlendControl.MaxValue.ToString(), font[2], new SolidBrush(Color.Black), new PointF(colorsquareWidthHeight[0] + colorsquareWidthHeight[2] + 3, location));

                    //draw colrow
                    g.DrawString(strMapInfo[2], font[3], new SolidBrush(Color.Black), new PointF(leftWidth - colrowWidthHeight[0] / 2 + (3 - strMapInfo[2].Length) * colrowWidthHeight[0] / 3, height + upperHeight + 2));//col.min
                    g.DrawString(strMapInfo[3], font[3], new SolidBrush(Color.Black), new PointF(leftWidth + width - colrowWidthHeight[0] / 2 + (3 - strMapInfo[3].Length) * colrowWidthHeight[0] / 3, height + upperHeight + 2));//col.max
                    g.DrawString(strMapInfo[4], font[3], new SolidBrush(Color.Black), new PointF(leftWidth - colrowWidthHeight[0] + (3 - strMapInfo[4].Length) * colrowWidthHeight[0] / 3, height + upperHeight - colrowWidthHeight[1] / 2));//row.min
                    g.DrawString(strMapInfo[5], font[3], new SolidBrush(Color.Black), new PointF(leftWidth - colrowWidthHeight[0] + (3 - strMapInfo[5].Length) * colrowWidthHeight[0] / 3, upperHeight - colrowWidthHeight[1] / 2));//row.max

                    //draw map
                    //g.DrawImage(bmpRsm, new Rectangle(new Point(leftWidth + 2, upperHeight), destImage.Size), new Rectangle(new Point(originX, originY), destImage.Size), GraphicsUnit.Pixel);
                    g.DrawImage(bmpRsm, new Rectangle(new Point(leftWidth + 2, upperHeight), new Size(width, height)), new Rectangle(new Point(originX, originY), new Size(width, height)), GraphicsUnit.Pixel);
                    g.DrawRectangle(new Pen(Color.Black, 1), leftWidth + 2, upperHeight, width, height);//add the border of map

                    //draw min max value
                    g.DrawString(minmaxValue, font[4], new SolidBrush(Color.Black), new PointF(leftWidth + 2 + (width - minmaxValueWidthHeight[0]) / 2, upperHeight + height + colrowWidthHeight[1] + 7));
                    g.Dispose();
                }
                else
                {
                    destImage = new Bitmap(width, height);
                    Graphics g = Graphics.FromImage(destImage);
                    g.Clear(Color.White);
                    g.DrawImage(bmpRsm, new Rectangle(new Point(0, 0), destImage.Size), new Rectangle(new Point(originX, originY), destImage.Size), GraphicsUnit.Pixel);
                    g.Dispose();
                }

                #region Call windows API to compose pictures
                //Graphics gSrc = this.CreateGraphics();
                ////Graphics gDest = Graphics.FromImage(destImage);
                ////IntPtr srcDC = gSrc.GetHdc();
                ////IntPtr destDC = gDest.GetHdc();
                ////WinAPIuse.BitBlt(destDC, 0, 0,destImage.Width , destImage.Height, srcDC, originX, originY, 0xCC0020); //13369376);

                ////gSrc.ReleaseHdc(srcDC);
                ////gDest.ReleaseHdc(destDC);
                ////// destImage.Save(myStream, format);
                ////gSrc.Dispose();
                ////// gDest = Graphics.FromImage(this.DrawImage());
                ////gDest.Dispose();
                //destImage.Save(@"c:\ttt.bmp", ImageFormat.Bmp); 
                #endregion
                GC.Collect();
                return destImage;

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
                return null;
            }
        }

        private List<string> GetStringRows(Graphics graphic, Font font, string text, int width)
        {
            int RowBeginIndex = 0;
            int rowEndIndex = 0;
            int textLength = text.Length;
            List<string> textRows = new List<string>();
            for (int index = 0; index < textLength; index++)
            {
                rowEndIndex = index;
                if (index == textLength - 1)
                {
                    textRows.Add(text.Substring(RowBeginIndex));
                }
                else if (rowEndIndex + 1 < text.Length && text.Substring(rowEndIndex, 2) == "\r\n")
                {
                    textRows.Add(text.Substring(RowBeginIndex, rowEndIndex - RowBeginIndex));
                    rowEndIndex = index += 2;
                    RowBeginIndex = rowEndIndex;
                }
                else if (graphic.MeasureString(text.Substring(RowBeginIndex, rowEndIndex - RowBeginIndex + 1), font).Width > width)
                {
                    textRows.Add(text.Substring(RowBeginIndex, rowEndIndex - RowBeginIndex));
                    RowBeginIndex = rowEndIndex;
                }
            }
            return textRows;
        }

        private void PlotControl_Click(object sender, EventArgs e)
        {
            
        }

        private void PlotControl_MouseClick(object sender, MouseEventArgs e)
        {
            if(dicMonitors == null ||dicMonitors.Keys.Count==0)
            { return; }
            var m_Point = e.Location;
            //Console.WriteLine(m_Point.X.ToString() + ", " + m_Point.Y.ToString());

            ////Transform screen coordinates into model coordinates
            //Matrix matrix = _matrix.Clone();
            //matrix.Invert();
            //PointF[] pts = new PointF[] { m_Point };
            //matrix.TransformPoints(pts);


            List<PointF> lstM = new List<PointF>();            
            foreach (var k in dicMonitors.Keys)
            {
                var s = k.Split(',');
                lstM.Add(new PointF(float.Parse(s[0]), float.Parse(s[1])));
            }
            var arrayM = lstM.ToArray();
            _matrix.TransformPoints(arrayM);

            List<PointF> lstOpt = new List<PointF>();
            List<int> lstIndex = new List<int>();
            double mind = 100; int minID = -1;
            for (int i = 0; i < arrayM.Length; i++)
            {
                double d = Math.Pow((arrayM[i].X - e.Location.X), 2) + Math.Pow(arrayM[i].Y - e.Location.Y, 2);                
                if(mind>d)
                {
                    minID = i;
                    mind = d;
                    //Console.WriteLine(d);
                }
            }
            if (minID != -1)
            {
                SelectedPoint = lstM[minID];
                strSelectedPointLatLon = dicMonitors.Keys.ToArray()[minID];
                isMarkSelectedPoint = true;
                _needRedrawBmp = true;
                this.Invalidate();
            }
            else
            {
                isMarkSelectedPoint = false;
                _needRedrawBmp = true;
                this.Invalidate();
            }
            //MarkSelectMonitor(lstM[lstIndex.First()], null);
        }

        private void PlotControl_Leave(object sender, EventArgs e)
        {
            isMarkSelectedPoint = false;
        }
    }//class



}//namespace
